$!++
$!  FACILITY:
$!      NEWSBUILD
$!
$!  AUTHOR:
$!      Geoff Huston
$!      Copyright  1988,1989,1990,1991,1992
$!
$!  FUNCTIONALITY:
$!      This file can be used to rebuild the NEWS executables either from
$!      scratch, or can be used for an incremental build if one (or a number)
$!      of source files have been edited. Both the production and debug
$!      executables are constructed in this procedure.
$!
$!  PRECONDITIONS:
$!      - All sources are in Dev:[NEWS.NEWS_SRC]
$!      - The default directory is set to DEV:[NEWS.NEWS_BUILD]
$!      - Execute by "$ @[-.news_src]newsbuild"
$!
$!  Version:
$!      V5.5     7-Oct-1988     GIH
$!        - Included modifications for WIN TCP/IP V3.0 support by Jim Patterson
$!          (jimp@cognos.uucp).
$!          NOTE: I have NOT tested the WIN support modifications
$!      V5.6    11-Nov-1988     GIH
$!        - Version 5.6 configuration
$!      V5.8     2-Mar-1989     GIH
$!        - Add NEWSV58_UPGRADE, NEWSDIST, NEWSRTL modules
$!	V5.9	14-Jul-1989	GIH
$!	  - Reduce the file activity to speed up the routine
$!	  - now included in NEWS_SRC directory
$!	V6.0	13-Jun-1989	GIH
$!	  - use parameter 1 to specify the TCP transport (or ask if not supplied)
$!	V6.0-1	 3-Nov-1990	(GIH added) - James Gerland: TWG changes
$!	V6.0-4	25-May-1991	volz@process.com
$!	  - Added TCPware support
$!	V6.1	31-Jan-1991	ake@dayton.saic.com Earle Ake
$!	  - Don't deassign newsrc logical if it isn't defined
$!	V6.1	 3-Feb-1991	ake@dayton.saic.com Earle Ake
$!	  - For Multinet define "__TYPES" to avoid compiler noise
$!      v6.1     9-Feb-1991     don@beckman.com Don Roberts
$!        - Allow compile only.  Necessary because my site has the c compiler
$!          on a different node from TCP/IP.  Also if you define the logical
$!          env_verify to 1, verification is set on
$!      v6.1     17-Feb-1991     mark@infocomm.com Mark Pizzolato
$!	  - Let Control-Y during a compile actually stop compiling and not 
$!	    simply abort the current compile and go on to the next.
$!      v6.1     03-Mar-1993     bailey@genetics.upenn.edu
$!        - p6 = purgetype.  If p6 contains string NOOBJ, object files will
$!          not be purged.  If p6 contains string NOEXE, images will not be
$!          purged.
$!	V6.1b7	13-Jul-1993	bailey@genetics.upenn.edu  Charles Bailey
$!        - changed WIN/TCP link option to use shareable image library
$!          for PathWay 1.0 if it exists
$!	V6.1b7  20-May-1993  Charles Bailey  bailey@genetics.upenn.edu
$!	  - fixed minor bug in makeobj subroutine
$!	  - fixed bug in News.Exe and NewsDbg.Exe generation for link-only runs
$!	V6.1b8  20-Oct-1993  Bernie Volz  volz@process.com
$!        - updated TCPware logical names
$!	V6.1b9  29-Dec-1993  Mark Pizzolato mark@infocomm.com
$!	  - Moved NNTP_TTY.EXE to [.NEWS_BUILD] and made sure that it is always
$!	    built with the debug compiled pieces so that it can serve it's
$!	    function as a test framework for debugging the NNTP_SERVER code.
$!	V6.1b9  23-Jun-1994  Mark Martinec  mark.martinec@ijs.si
$!	  - modify subroutine 'makeobj' to look more like subroutine 'compile';
$!	  - subroutine 'makeobj' now handles compiling .MSG and .CLD files,
$!	    and as a special case calls Pat Rankin's (rankin@eql.caltech.edu)
$!	    DCL procedure NEWSMSG.COM to make newsmsg.h from newsmsg.msg .
$!	    This was necessary in order to accomodate gcc compiler which
$!	    does not like globaldef VAXC directive; (tested with gcc 2.6.0)
$!	  - add logical name for the GNU cc compiler include directories;
$!	  - add '.obj' to all 'cc/object' commands for the sake of gcc compiler
$!	    which otherwise produces object files with empty file types
$!	  - add  '$ set symbol/scope=(nolocal,noglobal)' command
$!	    to prevent influence of user-defined symbols to NEWSBUILD.COM
$!	V6.1b9  16-Sep-1994  Mark Martinec  mark.martinec@ijs.si
$!	  - removed the __TYPES hack from 3-Feb-1991
$!	  - for vax11c with Multinet use logical names SYS, ARPA, ...
$!	    instead of VAXC$INCLUDE search list to simplify include files
$!	    (now the same mechanism for finding system include files
$!	    is used both for DECC and VAX11C compilers)
$!	V6.1b9  27-Sep-1994  Mark Martinec  mark.martinec@ijs.si
$!	  - handle the case of DECC compiler on VAX:  determine the
$!	    actual compiler based on its predefined preprocessor macros
$!	V6.1b9   6-Oct-1994  Mark Martinec  mark.martinec@ijs.si
$!	  - create directories [-.news_build] and [-.news_dist]
$!	    if they are missing
$!	V6.1b9  22-Jan-1995  Charles Bailey  bailey@genetics.upenn.edu
$!	  - add WINOBJECT, fix dependencies for TCP/IP headers, fix
$!	    dependencies for link-only runs
$!	V6.1b9  28-FEB-1995  Mark Martinec  mark.martinec@ijs.si
$!	  - use DCL symbol CC_OPT to specify CC optimization level;
$!	    this solves the problem when gcc was called with /OPT=2/OPT
$!	    where the second qualifier would reduce the optimization level to 1
$!
$!  Usage:
$!	$ SET DEF [.NEWS_SRC]
$!	$ @NEWSBUILD [tcp-transport] [force] [debug] [client-only] [compile-defines]
$!
$!		tcp-transport:  N [ONE]
$!			        M [ULTINET]
$!			        C [MU]
$!				W [IN]
$!				WINO [BJECTLIB]
$!				U [CXQIOS]
$!				UCXS [OCKETS]
$!				E [XOS]]
$!				T [CPware]
$!
$!		force:		COMPILE only - force full compilation and skip link
$!				LINK only - skip compilation and force full link
$!                              BOTH compile and link - force full compile and full link
$!				Objects - compile only - but only based on date/time check and skip link
$!				Exes - skip compilation and link - but only based on date/time check
$!              		<empty string> - both compile and link, but only as required by date/time check
$!
$!		debug:		DEBUG   - compile and link with DEBUG option
$!				NODEBUG - compile and link with NODEBUG option
$!                              <empty string> - Do both
$!
$!		client-only:	CLIENT - build NEWS.EXE and NEWS.HLB only
$!				<empty string> - build everything
$!
$!		compile-defines:
$!				<define list> - comma separated list of 
$!						identifiers/value pairs which 
$!						will be passed to compiles of
$!						C code.
$!				<empty string> - no extra compile time defines
$!
$!
$!
$ makehay_ver='f$verify(0)
$ set = ""
$ set symbol/scope=(nolocal,noglobal)
$ image_ver = f$environment("verify_image")   !store verification info
$ proc_ver = 'f$verify(f$trnlnm("ENV_VERIFY"), image_ver)
$ say = "write sys$output"
$ axpflag = F$GetSyi("HW_MODEL") .gt. 1024  ! Probably ALPHA
$ newsrclog=f$trnlnm("newsrc")
$ if newsrclog .nes. "" then $ deassign newsrc
$ on control_y then $ stop
$ on error then $ goto done
$!create necessary directories if they are missing
$ if f$sear("[-]NEWS_BUILD.DIR").eqs."" then create/dir [-.NEWS_BUILD]
$ if f$sear("[-]NEWS_DIST.DIR") .eqs."" then create/dir [-.NEWS_DIST]
$ set def [-.NEWS_BUILD]
$
$ compiler = 0 ! default (try to automatically determine the compiler available)
$! the following compilers are recognized and supported:
$ comp_vaxc = 1
$ comp_decc = 2
$ comp_gcc  = 3
$
$! if you want to override the automatic guessing of compiler type
$! uncomment one of the following three lines:
$!compiler = comp_vaxc
$!compiler = comp_decc
$!compiler = comp_gcc
$
$ if compiler.eq.0
$ then
$! try to guess which compiler is available
$   if f$log("GNU_CC").nes.""
$   then
$     compiler = comp_gcc
$     say "Make sure your GNU C version is not 2.6.0, 2.6.1 or 2.6.2"
$     say "  (versions 2.5.8 and earlier or 2.6.3 and later should be ok)"
$   else
$! since DECC compiler can now be found on AXP as well as on VAX,
$! we run its preprocessor to distinguish between DECC and VAXC
$     tmp = "0tmp.tmp"
$     if f$log("SYS$SCRATCH").nes."" then tmp = "SYS$SCRATCH:" + tmp
$     cc/preprocess_only='tmp'/nolist/noobj sys$input:x.y  ! silly DECC on VAX needs dummy filename
$     deck/dollars
#if defined(__GNUC__)
$	compiler = comp_gcc
#elif defined(vax11c) && !defined(__DECC)
$	compiler = comp_vaxc
#elif defined(__DECC)
$	compiler = comp_decc
#endif
$     eod
$     if f$trnlnm("f").nes."" then close/nolog f
$     open/read/error=trycmp9 f 'tmp'
$trycmp1: !loop
$       read/end=trycmp9 f line
$       if f$extr(0,1,line).eqs."$" then 'line'
$       goto trycmp1
$trycmp9:
$     close f
$     delete/noconf 'tmp';*
$   endif
$ endif		! end of compiler type guessing
$
$ if compiler.eq.0 then compiler = comp_vaxc	! default
$ if compiler.eq.comp_vaxc then say "Compiler used: VAXC"
$ if compiler.eq.comp_decc then say "Compiler used: DECC"
$ if compiler.eq.comp_gcc  then say "Compiler used: GCC"
$
$ link_lib = "link_opt/opt"	! link_opt logical name will be defined later
$ if compiler.eq.comp_gcc then -
    link_lib = "gnu_cc:[000000]gcclib/lib," + link_lib 
$ define vaxc$include sys$library
$ if compiler.eq.comp_gcc then gcc_include = ""
$ if compiler.eq.comp_decc
$ then
$   define link_opt sys$disk:[-.news_src]options_c_link_decc.opt
$ else
$   define link_opt sys$disk:[-.news_src]options_c_link.opt
$ endif
$ defsw = ""
$ use_multinet = 0
$ use_cmu = 0
$ use_twg = 0
$ use_ucx = 0	! (use_ucxqios or use_ucxsockets)
$ use_ucxqios = 0
$ use_ucxsockets = 0
$ use_exos = 0
$ use_tcpware = 0
$ IF p1 .eqs. ""
$ THEN !Try to guess TCP transport
$   if f$trnlnm("UCX$DEVICE")	.nes. ""  then p1 = "UCXQIOS"
$   if f$trnlnm("TWG$TCP")	.nes. ""  then p1 = "WIN"
$   if f$trnlnm("EXOS_ETC")	.nes. ""  then p1 = "EXOS"
$   if f$trnlnm("TCPWARE_INCLUDE").nes."" then p1 = "TCPWARE"
$   if f$trnlnm("MULTINET")	.nes. ""  then p1 = "MULTINET"
$ ENDIF
$ IF p1 .eqs. ""
$ THEN
$   say "TCP transport options:"
$   say "      NONE"
$   say "      MULTINET"
$   say "      CMU"
$   say "      WIN"
$   say "      WINOBJECTLIB"
$   say "      UCXQIOS"
$   say "      UCXSOCKETS (not tested thoroughly)"
$   say "      EXOS"
$   say "      TCPware"
$   Read Sys$Command p1 /Prompt="TCP Transport [NONE] "
$ ENDIF
$ p1 = f$edit(p1,"UPCASE") ! We'll use this later
$ tcptransport = f$extract(0,1,p1)
$ IF tcptransport .EQS. "M" THEN $ use_multinet = 1
$ IF tcptransport .EQS. "C" THEN $ use_cmu = 1
$ IF tcptransport .EQS. "W" THEN $ use_twg = 1
$ IF tcptransport .EQS. "E" THEN $ use_exos = 1
$ IF tcptransport .EQS. "T" THEN $ use_tcpware = 1
$ IF tcptransport .EQS. "U"
$ THEN
$   use_ucx = 1
$   tcptransport = f$extract(0,4,p1)
$   IF tcptransport .EQS. "UCXS"
$   THEN
$     use_ucxsockets = 1
$   ELSE
$     use_ucxqios = 1
$   ENDIF
$ ENDIF
$!
$!	Examine parameter 2 (Compile | Link | Both | Objects | Exes | empty)
$!
$ force = f$extract(0,1,f$edit(p2,"UPCASE"))
$ skip_compile = 0
$ skip_link = 0
$ force_compile = 0
$ force_link = 0
$ IF force .EQS. "O" THEN $ skip_link = 1
$ IF force .EQS. "E" THEN $ skip_compile = 1
$ IF force .EQS. "C"
$ THEN
$  force_compile = 1
$  skip_link = 1
$ ENDIF
$ IF force .EQS. "L"
$ THEN 
$  force_link = 1
$  skip_compile = 1
$ ENDIF
$ IF force .EQS. "B"
$ THEN
$  force_compile = 1
$  force_link = 1
$ ENDIF
$!
$! Call in CMUTCP support
$!
$ IF use_cmu
$ THEN
$   defsw = "/DEFINE=(CMU=1)"
$   say "CMU IP support included"
$ ENDIF
$!
$! Call in UCXSOCKETS support
$!
$ IF use_ucxsockets
$ THEN
$   say "ANU-NEWS under UCXSOCKETS is not thoroughly tested,"
$   say "the use of UCXQIOS is recommended.  Also the"
$   say "NNTP_TCPUCXM server is not compiled under UCXSOCKETS."
$   IF skip_compile .eq. 0
$   THEN
$     IF f$search("sys$library:ucx$inetdef.h") .EQS. ""
$     THEN
$       say "UCX support cannot be loaded - no library file"
$       exit
$     ENDIF
$     defsw = "/DEFINE=(UCXSOCKETS=1,UCX=1)"
$   ENDIF
$   if compiler.eq.comp_decc
$   then
$     DEFINE link_opt sys$disk:[-.news_src]options_c_ucxlink_decc.opt
$   else
$     DEFINE link_opt sys$disk:[-.news_src]options_c_ucxlink.opt
$   endif
$   say "UCX IP support included (socket drivers)"
$ ENDIF
$!
$! Call in UCXQIOS support
$!
$ IF use_ucxqios
$ THEN
$   IF skip_compile .eq. 0
$   THEN
$     IF f$search("sys$library:ucx$inetdef.h") .EQS. ""
$     THEN
$       say "UCX support cannot be loaded - no library file"
$       exit
$     ENDIF
$     defsw = "/DEFINE=(UCXQIOS=1,UCX=1)"
$   ENDIF
$   if compiler.eq.comp_decc
$   then
$     DEFINE link_opt sys$disk:[-.news_src]options_c_ucxlink_decc.opt
$   else
$     DEFINE link_opt sys$disk:[-.news_src]options_c_ucxlink.opt
$   endif
$   say "UCX IP support included (qio drivers)"
$ ENDIF
$!
$! Call in Multinet support based on multinet include files
$!
$ IF use_multinet
$ THEN
$   IF skip_compile .eq. 0
$   THEN
$     IF f$search("multinet_root:[multinet.include]*.h") .EQS. ""
$     THEN
$       say "MULTINET support cannot be loaded - no library files"
$       exit
$     ENDIF
$     defsw = "/DEFINE=(MULTINET=1)"
$     IF compiler.eq.comp_gcc then -
        gcc_include = "multinet_root:[multinet.include.]"
$     IF compiler.eq.comp_decc .or. compiler.eq.comp_vaxc
$     THEN
$       DEFINE/nolog vaxc$include multinet_root:[multinet.include],sys$library
$       DEFINE vms	multinet_root:[multinet.include.vms]
$       DEFINE arpa	multinet_root:[multinet.include.arpa]
$       DEFINE sys	multinet_root:[multinet.include.sys]
$       DEFINE netinet	multinet_root:[multinet.include.netinet]
$     ENDIF
$   ENDIF
$   IF compiler.eq.comp_decc
$   THEN
$     DEFINE link_opt sys$disk:[-.news_src]options_c_multinetlink_decc.opt
$   ELSE
$     DEFINE link_opt sys$disk:[-.news_src]options_c_multinetlink.opt
$   ENDIF
$   say "Multinet IP support included"
$ ENDIF
$!
$! Call in TCPware support based on TCPware include files
$!
$ IF use_tcpware
$ THEN
$   IF skip_compile .eq. 0
$   THEN
$     IF f$search("TCPWARE_INCLUDE:*.h") .EQS. ""
$     THEN
$       say "TCPware support cannot be loaded - no library files"
$       exit
$     ENDIF
$     defsw = "/DEFINE=(TCPWARE=1)"
$     DEFINE/nolog vaxc$include tcpware_include,sys$library
$     IF compiler.eq.comp_gcc then gcc_include = "tcpware_include:"
$   ENDIF
$   IF compiler.eq.comp_decc
$   THEN
$     DEFINE link_opt sys$disk:[-.news_src]options_c_tcpwarelink_decc.opt
$   ELSE
$     DEFINE link_opt sys$disk:[-.news_src]options_c_tcpwarelink.opt
$   ENDIF
$   say "TCPware TCP/IP support included"
$ ENDIF
$!
$!
$! Call in TWG support based on TWG include files
$!
$ IF use_twg
$ THEN
$   IF skip_compile .eq. 0
$   THEN
$     IF f$search("TWG$TCP:[NETDIST.INCLUDE]*.H") .eqs. ""
$     THEN
$       say "WIN support cannot be loaded - no library files"
$       exit
$     ENDIF
$     defsw = "/DEFINE=(TWG=1)"
$     IF compiler.eq.comp_decc .or. compiler.eq.comp_vaxc
$     THEN
$       DEFINE/nolog vaxc$include twg$tcp:[netdist.include],sys$library
$       DEFINE vms	twg$tcp:[netdist.include.vms]
$       DEFINE arpa	twg$tcp:[netdist.include.arpa]
$       DEFINE sys	twg$tcp:[netdist.include.sys]
$       DEFINE netinet	twg$tcp:[netdist.include.netinet]
$     ENDIF
$   ENDIF
$   IF (F$Search("Sys$Share:TWGLib.Exe").nes."") .and. -
       (F$Extract(3,1,p1).nes."O")
$   THEN
$     IF compiler.eq.comp_decc
$     THEN
$       DEFINE link_opt sys$disk:[-.news_src]options_c_winlink_decc.opt
$     ELSE
$       DEFINE link_opt sys$disk:[-.news_src]options_c_winlink.opt
$     ENDIF
$     say "TWG IP support included (shareable image library)"
$   ELSE
$     link_lib = "twg$tcp:[netdist.lib]twglib/lib,link_opt/opt"
$     IF compiler.eq.comp_gcc then -
$       link_lib = "gnu_cc:[000000]gcclib/lib," + link_lib 
$     DEFINE lnk$library   sys$library:vaxcrtl
$     say "TWG IP support included (object library)"
$   ENDIF
$ ENDIF
$ IF use_exos
$ THEN
$   IF skip_compile .eq. 0
$   THEN
$     IF f$trnlnm("EXOS_ETC").eqs.""
$     THEN
$       say "EXOS not found!"
$       exit
$     ENDIF
$     defsw = "/DEFINE=(EXOS=1)"
$   ENDIF
$   IF compiler.eq.comp_decc
$   THEN
$     DEFINE link_opt sys$disk:[-.news_src]options_c_link_decc.opt
$   ELSE
$     DEFINE link_opt sys$disk:[-.news_src]options_c_link.opt
$   ENDIF
$ ENDIF
$!
$!	Examine parameter 3 (DEBUG | NODEBUG | empty)
$!
$ dbgtype = f$extract(0,1,f$edit(p3,"UPCASE"))
$ make_debug = 1
$ make_nodebug = 1
$ IF dbgtype .EQS. "D" THEN $ make_nodebug = 0
$ IF dbgtype .EQS. "N" THEN $ make_debug = 0
$!
$!	Examine parameter 4 (Client-only | empty)
$!
$!	client-only means build NEWS.EXE and NEWS.HLB only; ignore the rest
$ client_only = (f$extract(0,1,f$edit(p4,"UPCASE")) .eqs. "C")
$!
$!	Examine parameter 5 (Extra Compile Defines | empty)
$!
$ IF skip_compile .eq. 0
$ THEN
$   IF p5.nes.""
$   THEN
$     IF defsw.eqs.""
$     THEN
$       defsw = "/DEFINE=("+p5+")"
$     ELSE
$       defsw = f$extract(0,f$length(defsw)-1,defsw)+","+p5+")"
$     ENDIF
$   ENDIF
$!
$!
$   cc = "cc/NOLIS" + defsw	! default, also VAX C
$   cc_opt   = "/OPT/NODEBUG"
$   cc_noopt = "/NOOPT/DEBUG"
$
$   IF compiler.eq.comp_gcc
$   THEN
$     ! -fno-builtin is required for gcc versions <2.6.3, due to a bug which
$     ! leads memcpy() to be mapped to movc3, which can't handle blocks >64k
$     cc = "gcc/NOLIS" + defsw + "/cc1=""""""-Wall"""" """"-Wwrite-strings"""" """"-Wtraditional"""" """"-Wpointer-arith"""" """"-Wcast-align"""" """"-Waggregate-return"""""""
$     cc_opt = "/OPT=2/NODEBUG"
$     IF gcc_include.nes."" then cc = cc + "/incl=(''gcc_include')"
$   ENDIF
$
$   IF compiler.eq.comp_decc
$   THEN
$     cc_decc_sw = "/PREFIX=ALL_ENTRIES"
$     IF .not. use_ucx	! seems like UCX is the default in DECC RTL
$     THEN
$       cc_decc_sw = "/PREFIX=(ALL_ENTRIES,EXCEPT=("+-
           "BCMP,BCOPY,BZERO,SOCKET_READ,SOCKET_WRITE,SOCKET_CLOSE,"+-
           "GETDTABLESIZE,ACCEPT,BIND,CONNECT,LISTEN,SELECT,SOCKET,"+-
           "GETSOCKOPT,SETSOCKOPT,RECV,SEND,RECVFROM,SENDTO,GETPEERNAME,"+-
           "GETHOSTBYNAME,GETHOSTBYADDR,HTONL,HTONS,NTOHL,NTOHS"
$!      The remaining TCP/IP routines are not used by ANU at this time.
$!      We list them just in case some future version would want to use them.
$       cc_decc_sw = cc_decc_sw +-
           ",SHUTDOWN,RECVMSG,SENDMSG,READV,WRITEV,GETHOSTNAME,"+-
           "SETHOSTNAME,GETSOCKNAME,GETNETBYNAME,GETNETENT,SETNETENT,"+-
           "ENDNETENT,GETPROTOBYNAME,GETPROTOBYNUMBER,GETPROTOENT"
$       cc_decc_sw = cc_decc_sw +-
           ",SETPROTOENT,ENDPROTOENT,GETSERVBYNAME,GETSERVBYPORT,"+-
           "GETSERVENT,SETSERVENT,ENDSERVENT,GETHOSTENT,SETHOSTENT,"+-
           "ENDHOSTENT,INET_ADDR,INET_LNAOF,INET_MAKEADDR,INET_NETOF,"+-
           "INET_NTOA,INET_NETWORK"
$       cc_decc_sw = cc_decc_sw + "))"
$     ENDIF
$!    /TIE presumably required for the sake of callable EDT
$     if axpflag then cc_decc_sw = cc_decc_sw + "/TIE"   ! not for DECC on VAX !!!
$     cc_decc_sw = cc_decc_sw + "/NOMEMBER_ALIGN/STANDARD=RELAXED_ANSI"
$     cc_decc_sw = cc_decc_sw + "/WARN=(ENABLE=CHECK,DISABLE=("+-
         "GLOBALEXT,NOSHAREEXT,ADDRCONSTEXT,IGNORECALLVAL,VALUEPRES,"+-
         "MACROEXT),NOINFORM)"
$!                                  ^^^^^^^^ this one for DECC 1.3 include files
$     cc = "cc/NOLIS" + defsw + cc_decc_sw
$!       /nolist is essential for DECC, without it the compiler crashes in batch
$   ENDIF
$   say/sym cc
$!
$!   Save the Compile Time "Defines" for this compile.
$!
$   open/write temp [-.news_build]compile.defines
$   write temp defsw
$   close temp
$   IF f$search("[-.news_build]compile.defines;-1").eqs.""
$   THEN
$     force_compile = 1
$     force_link = 1
$   ELSE
$     differences/output=nla0: [-.news_build]compile.defines
$     IF $severity.eq.3
$     THEN
$       say ""
$       IF f$file_attributes("[-.news_build]compile.defines;-1","FFB").eqs.4
$       THEN
$         say "Forcing a complete recompile due to specification compile time defines"
$       ELSE
$         say "Forcing a complete recompile due to compile defines changing from:"
$         type [-.news_build]compile.defines;-1
$       ENDIF
$       IF f$length(defsw).eqs.0
$       THEN
$         say "to compiling without any compile time defines."
$       ELSE
$         say "To:
$         type [-.news_build]compile.defines
$       ENDIF
$       say ""
$       force_compile = 1
$       force_link = 1
$     ENDIF
$     purge [-.news_build]compile.defines
$   ENDIF
$ ENDIF
$!
$!	Examine parameter 6 (Purge object,exe | do not purge)
$ purge_objs = 1
$ purge_exes = 1
$ If p6.nes.""
$ Then
$   p6 = F$Edit(p6,"Upcase,Collapse")
$   If F$Locate("NOOBJ",p6).lt.F$Length(p6) Then purge_objs = 0
$   If F$Locate("NOEXE",p6).lt.F$Length(p6) Then purge_exes = 0
$ EndIf
$ purge_objs = 0
$ purge_exes = 0
$!
$!  INPATHS.EXE - done first as there is no tcp code required
$!
$ IF f$search("[-.NEWS_SRC]INPATHS.C") .nes. "" .and. .not. client_only .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("INPATHS.OBJ").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("[-.NEWS_SRC]INPATHS.C","rdt")).gts.f$cvtime(f$file_attributes("INPATHS.OBJ","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc inpaths"
$     cc/object=[-.news_build]inpaths.obj'cc_opt' inpaths
$     set def [-.news_build]
$     if purge_objs then purge inpaths.obj
$   ENDIF
$ ENDIF
$!
$ IF f$search("INPATHS.OBJ") .nes. "" .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("[-.NEWS_DIST]INPATHS.EXE") .eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("INPATHS.OBJ","rdt")).gts.-
                  f$cvtime(f$file_attributes("[-.NEWS_DIST]INPATHS.EXE","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ link inpaths"
$     link/nomap/notrace/exe=[-.news_dist]inpaths.exe inpaths,'link_lib'
$     if purge_exes then purge [-.news_dist]inpaths.exe
$   ENDIF
$ ENDIF
$!
$! .OLB files
$!
$ IF f$search("NEWS_LIBRARY.OLB").eqs."" THEN $ library/create/obj news_library
$ IF f$search("NEWS_LIBRARYD.OLB").eqs."" THEN $ library/create/obj news_libraryd
$!
$!  get cre date time for include files
$!
$ call makeobj "NEWSMSG.MSG"	"[-.NEWS_SRC].H"
$ vartime = f$cvtime(f$file_attributes("[-.NEWS_SRC]NEWSVARIABLES.H","rdt"))
$ exttime = f$cvtime(f$file_attributes("[-.NEWS_SRC]NEWSEXTERN.H","rdt"))
$ deftime = f$cvtime(f$file_attributes("[-.NEWS_SRC]NEWSDEFINE.H","rdt"))
$ inctime = f$cvtime(f$file_attributes("[-.NEWS_SRC]NEWSINCLUDE.H","rdt"))
$ nntpinctime = f$cvtime(f$file_attributes("[-.NEWS_SRC]NNTPINCLUDE.H","rdt"))
$ sittime = f$cvtime(f$file_attributes("[-.NEWS_SRC]NEWSSITE.H","rdt"))
$ msgtime = f$cvtime(f$file_attributes("[-.NEWS_SRC]NEWSMSG.H","rdt"))
$ call compile "NEWSADD"	"DELOBJ"
$ call compile "NEWSCALLEDIT"	"DELOBJ"
$ call compile "NEWSCLASSES"	"DELOBJ"
$ call compile "NEWSCONFIGS"	"DELOBJ"
$ call compile "NEWSCONTROL"	"DELOBJ"
$ call compile "NEWSDELETE"	"DELOBJ"
$ call compile "NEWSDIR"	"DELOBJ"
$ call compile "NEWSDISPLAY"	"DELOBJ"
$ call compile "NEWSDIST"	"NODELOBJ"
$ call compile "NEWSEXTRACT"	"DELOBJ"
$ call compile "NEWSFILES"	"DELOBJ"
$ call compile "NEWSFORWARD"	"DELOBJ"
$ call compile "NEWSHELP"	"DELOBJ"
$ call compile "NEWSKILL"	"DELOBJ"
$ call compile "NEWSLOCK"	"NODELOBJ"
$ call compile "NEWSVMSMAIL"	"DELOBJ"
$ call compile "NEWSMOD"	"DELOBJ"
$ call compile "NEWSMENU"	"DELOBJ"
$ call compile "NEWSMODE"	"DELOBJ"
$ call compile "NEWSPOST"	"DELOBJ"
$ call compile "NEWSPROFILE"	"DELOBJ"
$ call compile "NEWSRC"		"DELOBJ"
$ call compile "NEWSREAD"	"DELOBJ"
$ call compile "NEWSREGISTER"	"DELOBJ"
$ call compile "NEWSREMCLIENT"	"DELOBJ" "NNTP"
$ call compile "NEWSSEARCH"	"DELOBJ"
$ call compile "NEWSSELECT"	"DELOBJ"
$ call compile "NEWSSETSHOW"	"DELOBJ"
$ call compile "NEWSSKIM"	"DELOBJ"
$ call compile "NEWSSKIP"	"DELOBJ"
$ call compile "NEWSSITE"	"DELOBJ"
$ call compile "NEWSUTILITY"	"DELOBJ"
$ call compile "NEWSV58_UPGRADE"  "DELOBJ"
$ call compile "NEWSV60_UPGRADE"  "DELOBJ"
$ call compile "ADD_TRANSFORM"	"NODELOBJ"
$ call compile "NEWSRTL"	"NODELOBJ"
$ call compile "NEWSCMD.CLD"	"DELOBJ"
$ call compile "NEWSMSG.MSG"	"NODELOBJ"
$!
$!  NEWS
$!
$ IF make_nodebug .and. f$search("[-.news_src]news.c") .nes. "" .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   else
$     IF f$search("NEWS.OBJ").eqs.""
$     THEN
$       iftest = 1
$     else
$       objtime = f$cvtime(f$file_attributes("NEWS.OBJ","rdt"))
$       iftest =      vartime.gts.objtime -
                 .or. exttime.gts.objtime -
                 .or. inctime.gts.objtime -
                 .or. deftime.gts.objtime -
                 .or. inctime.gts.objtime -
                 .or. sittime.gts.objtime -
                 .or. msgtime.gts.objtime -
                 .or. f$cvtime(f$file_attributes("[-.NEWS_SRC]NEWS.C","rdt")).gts.objtime
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc news"
$     cc/object=[-.news_build]news.obj'cc_opt' news
$     set def [-.news_build]
$     if purge_objs then purge news.obj
$   ENDIF
$ ENDIF
$!
$ IF (f$search("NEWS.OBJ") .nes. "") .and. (f$search("NEWS_LIBRARY.OLB") .nes. "") .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("[-.NEWS_DIST]NEWS.EXE") .eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       iftest =     f$cvtime(f$file_attributes("NEWS_LIBRARY.OLB","rdt")).gts.-
                      f$cvtime(f$file_attributes("[-.NEWS_DIST]NEWS.EXE","rdt")) -
                .or. f$cvtime(f$file_attributes("NEWS.OBJ","rdt")).gts.-
                      f$cvtime(f$file_attributes("[-.NEWS_DIST]NEWS.EXE","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ link news,news_library/library"
$     link/nomap/notrace/exe=[-.news_dist]news.exe -
	news,news_library/library/include=newsmsg,'link_lib'
$     if purge_exes then purge [-.news_dist]news.exe
$   ENDIF
$ ENDIF
$!
$!  NEWSDBG
$!
$ IF make_debug .and. f$search("[-.news_src]news.c") .nes. "" .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("NEWSDBG.OBJ").eqs.""
$     THEN
$       iftest = 1
$     ELSE
$       objtime = f$cvtime(f$file_attributes("NEWSDBG.OBJ","rdt"))
$       iftest =      vartime.gts.objtime -
                 .or. exttime.gts.objtime -
		.or. inctime.gts.objtime -
		.or. deftime.gts.objtime -
		.or. inctime.gts.objtime -
		.or. sittime.gts.objtime -
		.or. msgtime.gts.objtime -
		.or. f$cvtime(f$file_attributes("[-.NEWS_SRC]NEWS.C","rdt")).gts.objtime
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc/debug/noopt news"
$     cc/object=[-.news_build]newsdbg.obj'cc_noopt' news
$     set def [-.news_build]
$     if purge_objs then purge newsdbg.obj
$   ENDIF
$ ENDIF
$ IF (f$search("NEWSDBG.OBJ") .nes. "") .and. (f$search("NEWS_LIBRARYD.OLB") .nes. "") .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("NEWSDBG.EXE").eqs.""
$     THEN
$       iftest = 1
$     ELSE
$       iftest =     f$cvtime(f$file_attributes("NEWS_LIBRARYD.OLB","rdt")).gts.-
                      f$cvtime(f$file_attributes("NEWSDBG.EXE","rdt")) -
                .or. f$cvtime(f$file_attributes("NEWSDBG.OBJ","rdt")).gts.-
                      f$cvtime(f$file_attributes("NEWSDBG.EXE","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ link/debug newsdbg,news_libraryd/library"
$     link/debug/nomap newsdbg,news_libraryd/library/include=newsmsg,'link_lib'
$     if purge_exes then purge newsdbg.exe
$   ENDIF
$ ENDIF
$!
$!  NNTP_SERVER
$!
$ call makeobj "CACHE.C"	".OBJ"
$ call makeobj "CACHEM.C"	".OBJ"
$ call makeobj "CACHE_LOGGER.C"	".OBJ"
$ call makeobj "CACHE_VERIFY.C"	".OBJ"
$ call makeobj "CACHE_HASH.MAR"	".OBJ"
$ call makeobj "CACHE_MAP.MAR"	".OBJ"
$ IF compiler.eq.comp_decc
$ THEN
$   link/nomap/notrace/exe=[-.news_dist]cachem.exe -
	cachem,cache,cache_hash,cache_map,cache_verify,cache_logger,-
	sys$disk:[-.news_src]options_c_link_decc/opt
$ ELSE
$   IF compiler.eq.comp_gcc
$   THEN
$     link/nomap/notrace/exe=[-.news_dist]cachem.exe -
	  cachem,cache,cache_hash,cache_map,cache_verify,cache_logger,-
	  gnu_cc:[000000]gcclib/lib,-
	  sys$disk:[-.news_src]options_c_link/opt
$   ELSE
$     link/nomap/notrace/exe=[-.news_dist]cachem.exe -
	  cachem,cache,cache_hash,cache_map,cache_verify,cache_logger,-
	  sys$disk:[-.news_src]options_c_link/opt
$   ENDIF
$ ENDIF
$ IF purge_exes THEN purge [-.news_dist]cachem.exe
$ IF f$search("[-.news_src]nntp_server.c") .nes. "" .and. .not. client_only .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("NNTP_SERVER.OBJ").eqs.""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("[-.NEWS_SRC]NEWSDEFINE.H","rdt")).gts.-
		  f$cvtime(f$file_attributes("NNTP_SERVER.OBJ","rdt")) -
		.or. f$cvtime(f$file_attributes("[-.NEWS_SRC]NNTP_SERVER.C","rdt")).gts.-
		  f$cvtime(f$file_attributes("NNTP_SERVER.OBJ","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc nntp_server"
$     cc/object=[-.news_build]nntp_server.obj'cc_opt' nntp_server
$     cc/object=[-.news_build]nntp_serverd.obj'cc_noopt' nntp_server
$     set def [-.news_build]
$     if purge_objs then purge nntp_server.obj,nntp_serverd.obj
$   ENDIF
$ ENDIF
$!
$!  NNTP_TTY
$!
$ IF make_debug .and. f$search("[-.news_src]nntp_tty.c") .nes. "" .and. .not. client_only .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("NNTP_TTY.OBJ").eqs.""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("[-.NEWS_SRC]NNTP_TTY.C","rdt")).gts.-
                  f$cvtime(f$file_attributes("NNTP_TTY.OBJ","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc nntp_tty"
$     cc/object=[-.news_build]nntp_tty.obj'cc_noopt' nntp_tty
$     set def [-.news_build]
$     if purge_objs then purge nntp_tty.obj
$   ENDIF
$ ENDIF
$!
$ IF make_debug .and. (f$search("NNTP_TTY.OBJ") .nes. "") .and. -
       (f$search("NNTP_SERVERD.OBJ") .nes. "")  .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("[-.NEWS_BUILD]NNTP_TTY.EXE").eqs.""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("NNTP_TTY.OBJ","rdt")).gts.-
		  f$cvtime(f$file_attributes("[-.NEWS_BUILD]NNTP_TTY.EXE","rdt")) -
		.or. f$cvtime(f$file_attributes("NNTP_SERVERD.OBJ","rdt")).gts.-
		  f$cvtime(f$file_attributes("[-.NEWS_BUILD]NNTP_TTY.EXE","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ link/debug nntp_tty,nntp_server"
$     link/nomap/debug/exe=[-.NEWS_BUILD] -
	  nntp_tty,nntp_serverd,-
        cached,cache_mapd,cache_hashd,cache_loggerd,-
        news_libraryd/libr/include=newsmsg,'link_lib'
$     if purge_exes then purge [-.news_build]nntp_tty.exe
$   ENDIF
$ ENDIF
$!
$!  NNTP_DEC
$!
$ IF f$search("[-.news_src]nntp_dec.c") .nes. "" .and. .not. client_only  .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("NNTP_DEC.OBJ").eqs.""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("[-.NEWS_SRC]NNTP_DEC.C","rdt")).gts.-
                  f$cvtime(f$file_attributes("NNTP_DEC.OBJ","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc nntp_dec"
$     cc/object=[-.news_build]nntp_dec.obj'cc_opt' nntp_dec
$     set def [-.news_build]
$     if purge_objs then purge nntp_dec.obj
$   ENDIF
$ ENDIF
$!
$ IF (f$search("NNTP_DEC.OBJ") .nes. "") .and. -
       (f$search("NNTP_SERVER.OBJ") .nes. "")  .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("[-.NEWS_DIST]NNTP_DEC.EXE").eqs.""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("NNTP_DEC.OBJ","rdt")).gts.-
		  f$cvtime(f$file_attributes("[-.NEWS_DIST]NNTP_DEC.EXE","rdt")) -
		.or. f$cvtime(f$file_attributes("NNTP_SERVER.OBJ","rdt")).gts.-
		  f$cvtime(f$file_attributes("[-.NEWS_DIST]NNTP_DEC.EXE","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ link nntp_dec,nntp_server"
$     link/nomap/notrace/exe=[-.news_dist]nntp_dec -
	nntp_dec,nntp_server,newsdist,-
        add_transform,newsrtl,newsmsg,newslock,-
        cache,cache_map,cache_hash,cache_logger,-
        'link_lib'
$     if purge_exes then purge [-.news_dist]nntp_dec.exe
$   ENDIF
$ ENDIF
$!
$!  NNTP_DECM
$!
$ IF f$search("[-.news_src]nntp_decm.c") .nes. "" .and. .not. client_only  .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("NNTP_DECM.OBJ").eqs.""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("[-.NEWS_SRC]NNTP_DECM.C","rdt")).gts.-
                  f$cvtime(f$file_attributes("NNTP_DECM.OBJ","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc nntp_decm"
$     cc/object=[-.news_build]nntp_decm.obj'cc_opt' nntp_decm
$     set def [-.news_build]
$     if purge_objs then purge nntp_decm.obj
$   ENDIF
$ ENDIF
$!
$ IF (f$search("NNTP_DECM.OBJ") .nes. "") .and. -
       (f$search("NNTP_SERVER.OBJ") .nes. "") .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("[-.NEWS_DIST]NNTP_DECM.EXE").eqs.""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("NNTP_DECM.OBJ","rdt")).gts.-
		  f$cvtime(f$file_attributes("[-.NEWS_DIST]NNTP_DECM.EXE","rdt")) -
		.or. f$cvtime(f$file_attributes("NNTP_SERVER.OBJ","rdt")).gts.-
		  f$cvtime(f$file_attributes("[-.NEWS_DIST]NNTP_DECM.EXE","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ link nntp_decm,nntp_server"
$     link/nomap/exe=[-.NEWS_DIST]nntp_decm -
	nntp_decm,nntp_server,newsdist,-
        add_transform,newsrtl,newsmsg,newslock,-
        cache,cache_map,cache_hash,cache_logger,-
        'link_lib'
$     if purge_exes then purge [-.news_dist]nntp_decm.exe
$   ENDIF
$ ENDIF
$!
$!  NNTP_CLIENT
$!
$ IF f$search("[-.news_src]nntp_client.c") .nes. "" .and. .not. client_only .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("NNTP_CLIENT.OBJ").eqs.""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("[-.NEWS_SRC]NNTP_CLIENT.C","rdt")).gts.-
                  f$cvtime(f$file_attributes("NNTP_CLIENT.OBJ","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc nntp_client"
$     cc/object=[-.news_build]nntp_client.obj'cc_opt' nntp_client
$     set def [-.news_build]
$     if purge_objs then purge nntp_client.obj
$   ENDIF
$ ENDIF
$!
$ IF f$search("NNTP_CLIENT.OBJ") .nes. "" .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("[-.NEWS_DIST]NNTP_CLIENT.EXE").eqs.""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("NNTP_CLIENT.OBJ","rdt")).gts.-
		  f$cvtime(f$file_attributes("[-.NEWS_DIST]NNTP_CLIENT.EXE","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ link nntp_client"
$     link/nomap/exe=[-.NEWS_DIST]nntp_client nntp_client,newsmsg,-
        'link_lib'
$     if purge_exes then purge [-.news_dist]nntp_client.exe
$   ENDIF
$ ENDIF
$!
$! NNTP_XMIT
$!
$ IF f$search("[-.news_src]nntpxmitcmd.cld") .nes. "" .and. .not. client_only .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("NNTPXMITCMD.OBJ") .eqs. ""
$     THEN
$      iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("[-.NEWS_SRC]NNTPXMITCMD.CLD","rdt")).gts.-
                  f$cvtime(f$file_attributes("NNTPXMITCMD.OBJ","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ set command/obj nntpxmitcmd.cld"
$     set command/obj=[-.news_build]nntpxmitcmd.obj nntpxmitcmd.cld
$     set def [-.news_build]
$     if purge_objs then purge nntpxmitcmd.obj
$   ENDIF
$ ENDIF
$ IF f$search("[-.news_src]nntp_xmit.c") .nes. "" .and. .not. client_only .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("NNTP_xmit.OBJ").eqs.""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("[-.NEWS_SRC]NNTP_xmit.C","rdt")).gts.-
                  f$cvtime(f$file_attributes("NNTP_xmit.OBJ","rdt")) .or. -
                 nntpinctime .gts. f$cvtime(f$file_attributes("NNTP_xmit.OBJ","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc nntp_xmit"
$     cc/object=[-.news_build]nntp_xmit.obj'cc_opt' nntp_xmit
$     set def [-.news_build]
$     if purge_objs then purge nntp_xmit.obj
$   ENDIF
$ ENDIF
$!
$ IF f$search("NNTP_XMIT.OBJ") .nes. ""  .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("[-.NEWS_DIST]NNTP_XMIT.EXE").eqs.""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("NNTP_XMIT.OBJ","rdt")).gts.-
		  f$cvtime(f$file_attributes("[-.NEWS_DIST]NNTP_XMIT.EXE","rdt")) -
           .or. f$cvtime(f$file_attributes("NNTPXMITCMD.OBJ","rdt")).gts.-
		  f$cvtime(f$file_attributes("[-.NEWS_DIST]NNTP_XMIT.EXE","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ link nntp_xmit"
$     link/nomap/notrace/exe=[-.NEWS_DIST]NNTP_XMIT -
	nntp_xmit,nntpxmitcmd,newslock,newsrtl,newsmsg,-
	'link_lib'
$     if purge_exes then purge [-.news_dist]nntp_xmit.exe
$   ENDIF
$ ENDIF
$!
$! NNTP_XFER
$!
$ IF f$search("[-.news_src]nntpxfercmd.cld") .nes. "" .and. .not. client_only .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("NNTPXFERCMD.OBJ") .eqs. ""
$     THEN
$      iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("[-.NEWS_SRC]NNTPXFERCMD.CLD","rdt")).gts.-
                  f$cvtime(f$file_attributes("NNTPXFERCMD.OBJ","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ set command/obj nntpxfercmd.cld"
$     set command/obj=[-.news_build]nntpxfercmd.obj nntpxfercmd.cld
$     set def [-.news_build]
$     if purge_objs then purge nntpxfercmd.obj
$   ENDIF
$ ENDIF
$ IF f$search("[-.news_src]nntp_xfer.c") .nes. "" .and. .not. client_only .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("NNTP_xfer.OBJ").eqs.""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("[-.NEWS_SRC]NNTP_xfer.C","rdt")).gts.-
                   f$cvtime(f$file_attributes("NNTP_xfer.OBJ","rdt")) .or. -
                 nntpinctime .gts. f$cvtime(f$file_attributes("NNTP_xfer.OBJ","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc nntp_xfer"
$     cc/object=[-.news_build]nntp_xfer.obj'cc_opt' nntp_xfer
$     set def [-.news_build]
$     if purge_objs then purge nntp_xfer.obj
$   ENDIF
$ ENDIF
$!
$ IF f$search("NNTP_XFER.OBJ") .nes. "" .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("[-.NEWS_DIST]NNTP_XFER.EXE").eqs.""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("NNTP_XFER.OBJ","rdt")).gts.-
		  f$cvtime(f$file_attributes("[-.NEWS_DIST]NNTP_XFER.EXE","rdt")) -
           .or. f$cvtime(f$file_attributes("NNTPXFERCMD.OBJ","rdt")).gts.-
		  f$cvtime(f$file_attributes("[-.NEWS_DIST]NNTP_XFER.EXE","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ link nntp_xfer"
$     link/nomap/notrace/exe=[-.NEWS_DIST]nntp_xfer -
	nntp_xfer,nntpxfercmd,newslock,newsrtl,newsmsg,-
	'link_lib'
$     if purge_exes then purge [-.news_dist]nntp_xfer.exe
$   ENDIF
$ ENDIF
$!
$!  NNTP_TCPCMU
$!
$ IF use_cmu
$ THEN
$   IF (f$search("[-.NEWS_SRC]NNTP_TCPCMU.C") .nes. "") -
      .and. .not. client_only .and. .not. skip_compile
$   THEN
$     IF force_compile
$     THEN
$       iftest = 1
$     ELSE
$       IF f$search("NNTP_TCPCMU.OBJ").eqs.""
$       THEN
$         iftest = 1
$       ELSE
$         iftest = f$cvtime(f$file_attributes("[-.NEWS_SRC]NNTP_TCPCMU.C","rdt")).gts.-
                   f$cvtime(f$file_attributes("NNTP_TCPCMU.OBJ","rdt"))
$       ENDIF
$     ENDIF
$     IF iftest
$     THEN
$       set def [-.news_src]
$       say "$ cc nntp_tcpcmu"
$       cc/object=[-.news_build]nntp_tcpcmu.obj'cc_opt' nntp_tcpcmu
$       set def [-.news_build]
$       IF purge_objs then purge nntp_tcpcmu.obj
$     ENDIF
$   ENDIF
$!
$   IF (f$search("NNTP_TCPCMU.OBJ") .nes. "") .and. -
       (f$search("NNTP_SERVER.OBJ") .nes. "") .and. .not. skip_link
$   THEN
$     IF force_link
$     THEN
$       iftest = 1
$     ELSE
$       IF f$search("[-.NEWS_DIST]NNTP_TCPCMU.EXE").eqs.""
$       THEN
$         iftest = 1
$       ELSE
$         iftest =     f$cvtime(f$file_attributes("NNTP_TCPCMU.OBJ","rdt")).gts.-
                       f$cvtime(f$file_attributes("[-.NEWS_DIST]NNTP_TCPCMU.EXE","rdt")) -
                  .or. f$cvtime(f$file_attributes("NNTP_SERVER.OBJ","rdt")).gts.-
                       f$cvtime(f$file_attributes("[-.NEWS_DIST]NNTP_TCPCMU.EXE","rdt"))
$       ENDIF
$     ENDIF
$     IF iftest
$     THEN
$       say "$ link nntp_tcpcmu,nntp_server"
$       link/nomap/notrace/exe=[-.NEWS_DIST]nntp_tcpcmu -
          nntp_tcpcmu,nntp_server,newsdist,-
          add_transform,newsrtl,newsmsg,newslock,-
          cache,cache_map,cache_hash,cache_logger,-
          'link_lib'
$       IF purge_exes then purge [-.news_dist]nntp_tcpcmu.exe
$     ENDIF
$   ENDIF
$ ENDIF
$!
$! NNTP_TCPWINMULTINET
$!
$ IF (use_twg .or. use_multinet .or. use_tcpware)
$ THEN
$   IF (f$search("[-.NEWS_SRC]NNTP_TCPWINMULTINET.C") .nes. "") -
        .and. .not. client_only .and. .not. skip_compile
$   THEN
$     IF force_compile
$     THEN
$       iftest = 1
$     ELSE
$       IF f$search("NNTP_TCPWINMULTINET.OBJ").eqs.""
$       THEN
$         iftest = 1
$       ELSE
$         iftest = f$cvtime(f$file_attributes("[-.NEWS_SRC]NNTP_TCPWINMULTINET.C","rdt")).gts.-
                   f$cvtime(f$file_attributes("NNTP_TCPWINMULTINET.OBJ","rdt")) .or. -
                 nntpinctime .gts. f$cvtime(f$file_attributes("NNTP_TCPWINMULTINET.OBJ","rdt"))
$       ENDIF
$     ENDIF
$     IF iftest
$     THEN
$       set def [-.news_src]
$       say "$ cc nntp_tcpwinmultinet"
$       cc/object=[-.news_build]nntp_tcpwinmultinet.obj'cc_opt' nntp_tcpwinmultinet
$       set def [-.news_build]
$       if purge_objs then purge nntp_tcpwinmultinet.obj
$     ENDIF
$   ENDIF
$!
$   IF (f$search("NNTP_TCPWINMULTINET.OBJ") .nes. "") .and. -
       (f$search("NNTP_SERVER.OBJ") .nes. "") .and. .not. skip_link
$   THEN
$     IF force_link
$     THEN
$       iftest = 1
$     ELSE
$       IF f$search("[-.NEWS_DIST]NNTP_TCPWINMULTINET.EXE").eqs.""
$       THEN
$         iftest = 1
$       ELSE
$         iftest =     f$cvtime(f$file_attributes("NNTP_TCPWINMULTINET.OBJ","rdt")).gts.-
                       f$cvtime(f$file_attributes("[-.NEWS_DIST]NNTP_TCPWINMULTINET.EXE","rdt")) -
                  .or. f$cvtime(f$file_attributes("NNTP_SERVER.OBJ","rdt")).gts.-
                       f$cvtime(f$file_attributes("[-.NEWS_DIST]NNTP_TCPWINMULTINET.EXE","rdt"))
$       ENDIF
$     ENDIF
$     IF iftest
$     THEN
$       say "$ link nntp_tcpwinmultinet,nntp_server"
$       link/nomap/notrace/exe=[-.news_dist]nntp_tcpwinmultinet -
          nntp_tcpwinmultinet,nntp_server,newsdist,-
          add_transform,newsrtl,newsmsg,newslock,-
          cache,cache_map,cache_hash,cache_logger,-
          'link_lib'
$       IF purge_exes then purge [-.news_dist]nntp_tcpwinmultinet.exe
$     ENDIF
$   ENDIF
$ ENDIF
$!
$! NNTP_TCPUCXM
$!
$ IF (use_ucxqios .or. use_multinet)
$ THEN
$   IF (f$search("[-.NEWS_SRC]NNTP_TCPUCXM.C") .nes. "") .and. .not. client_only .and. .not. skip_compile
$   THEN
$     IF force_compile 
$     THEN
$       iftest = 1
$     ELSE
$       IF f$search("NNTP_TCPUCXM.OBJ").eqs.""
$       THEN
$         iftest = 1
$       ELSE
$         iftest = f$cvtime(f$file_attributes("[-.NEWS_SRC]NNTP_TCPUCXM.C","rdt")).gts.-
                   f$cvtime(f$file_attributes("NNTP_TCPUCXM.OBJ","rdt")) .or. -
                   nntpinctime .gts. f$cvtime(f$file_attributes("NNTP_TCPUCXM.OBJ","rdt"))
$       ENDIF
$     ENDIF
$     IF iftest
$     THEN
$       set def [-.news_src]
$       say "$ cc nntp_tcpucxm"
$       cc/object=[-.news_build]nntp_tcpucxm.obj'cc_opt' nntp_tcpucxm
$       set def [-.news_build]
$       if purge_objs then purge nntp_tcpucxm.obj
$     ENDIF
$   ENDIF
$!
$   IF (f$search("NNTP_TCPUCXM.OBJ") .nes. "") .and. -
       (f$search("NNTP_SERVER.OBJ") .nes. "") .and. .not. skip_link
$   THEN
$     IF force_link
$     THEN
$       iftest = 1
$     ELSE
$       IF f$search("[-.NEWS_DIST]NNTP_TCPUCXM.EXE").eqs.""
$       THEN
$         iftest = 1
$       ELSE
$         iftest =     f$cvtime(f$file_attributes("NNTP_TCPUCXM.OBJ","rdt")).gts.-
                       f$cvtime(f$file_attributes("[-.NEWS_DIST]NNTP_TCPUCXM.EXE","rdt")) -
                  .or. f$cvtime(f$file_attributes("NNTP_SERVER.OBJ","rdt")).gts.-
                       f$cvtime(f$file_attributes("[-.NEWS_DIST]NNTP_TCPUCXM.EXE","rdt")) 
$       ENDIF
$     ENDIF
$     IF iftest
$     THEN
$       say "$ link nntp_tcpucxm,nntp_server"
$       link/nomap/exe=[-.news_dist]nntp_tcpucxm -
          nntp_tcpucxm,nntp_server,newsdist,-
          add_transform,newsrtl,newsmsg,newslock,-
          cache,cache_map,cache_hash,cache_logger,-
          'link_lib'
$       IF purge_exes then purge [-.news_dist]nntp_tcpucxm.exe
$     ENDIF
$   ENDIF
$ ENDIF
$!
$!  NEWS.HLP
$!
$ IF f$search("[-.NEWS_SRC]NEWS.HLP") .nes. "" .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("[-.NEWS_DIST]NEWS.HLB").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("[-.NEWS_SRC]NEWS.HLP","rdt")).gts.-
                  f$cvtime(f$file_attributes("[-.NEWS_DIST]NEWS.HLB","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ libr/help/create news news"
$     set def [-.news_dist]
$     libr/help/create news [-.news_src]news
$     set def [-.news_build]
$     if purge_exes then purge [-.news_dist]news.hlb
$   ENDIF
$ ENDIF
$!
$!  ARBITRON.EXE - same for arbitron
$!
$ IF f$search("[-.NEWS_SRC]ARBITRON.C") .nes. "" .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("ARBITRON.OBJ").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("[-.NEWS_SRC]ARBITRON.C","rdt")).gts.-
                  f$cvtime(f$file_attributes("ARBITRON.OBJ","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc arbitron"
$     cc/object=[-.news_build]arbitron.obj'cc_opt' arbitron
$     set def [-.news_build]
$     if purge_objs then purge arbitron.obj
$   ENDIF
$ ENDIF
$!
$ IF f$search("ARBITRON.OBJ") .nes. "" .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("[-.NEWS_DIST]ARBITRON.EXE").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("ARBITRON.OBJ","rdt")).gts.-
	     f$cvtime(f$file_attributes("[-.NEWS_DIST]ARBITRON.EXE","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ link arbitron"
$     link/nomap/notrace/exe=[-.news_dist]arbitron.exe -
	arbitron,news_library/libr/include=newsmsg,'link_lib'
$     if purge_exes then purge [-.news_dist]arbitron.exe
$   ENDIF
$ ENDIF
$!
$!  NEWITMFILE.EXE
$!
$ IF f$search("[-.NEWS_SRC]NEWITMFILE.C") .nes. ""  .and. .not. client_only .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("NEWITMFILE.OBJ").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       objtime = f$cvtime(f$file_attributes("NEWITMFILE.OBJ","rdt"))
$       iftest =      deftime.gts.objtime -
                 .or. f$cvtime(f$file_attributes("[-.NEWS_SRC]NEWITMFILE.C","rdt")).gts.objtime
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc newitmfile"
$     cc/object=[-.news_build]NEWITMFILE.obj'cc_opt' NEWITMFILE
$     set def [-.news_build]
$     if purge_objs then purge NEWITMFILE.obj
$   ENDIF
$ ENDIF
$!
$ IF f$search("NEWITMFILE.OBJ") .nes. "" .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("[-.NEWS_DIST]NEWITMFILE.EXE").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("NEWITMFILE.OBJ","rdt")).gts.-
	     f$cvtime(f$file_attributes("[-.NEWS_DIST]NEWITMFILE.EXE","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ link newitmfile"
$     link/nomap/exe=[-.news_dist]NEWITMFILE.exe -
	NEWITMFILE,-
	news_library/libr/include=newsmsg,'link_lib'
$     if purge_exes then purge [-.news_dist]NEWITMFILE.exe
$   ENDIF
$ ENDIF
$!
$!  NEWGRPFILE.EXE
$!
$ IF f$search("[-.NEWS_SRC]NEWGRPFILE.C") .nes. "" .and. .not. client_only .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("NEWGRPFILE.OBJ").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       objtime = f$cvtime(f$file_attributes("NEWGRPFILE.OBJ","rdt"))
$       iftest =      deftime.gts.objtime -
                 .or. f$cvtime(f$file_attributes("[-.NEWS_SRC]NEWGRPFILE.C","rdt")).gts.objtime
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc newgrpfile"
$     cc/object=[-.news_build]NEWGRPFILE.obj'cc_opt' NEWGRPFILE
$     set def [-.news_build]
$     if purge_objs then purge NEWGRPFILE.obj
$   ENDIF
$ ENDIF
$!
$ IF f$search("NEWGRPFILE.OBJ") .nes. "" .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("[-.NEWS_DIST]NEWGRPFILE.EXE").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("NEWGRPFILE.OBJ","rdt")).gts.-
	     f$cvtime(f$file_attributes("[-.NEWS_DIST]NEWGRPFILE.EXE","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ link newgrpfile"
$     link/nomap/exe=[-.news_dist]NEWGRPFILE.exe -
	NEWGRPFILE,-
	news_library/libr/include=newsmsg,'link_lib'
$     if purge_exes then purge [-.news_dist]NEWGRPFILE.exe
$   ENDIF
$ ENDIF
$!
$!  NEWSSHUTDOWN.EXE
$!
$ IF f$search("[-.NEWS_SRC]NEWSSHUTDOWN.C") .nes. "" .and. .not. client_only .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("NEWSSHUTDOWN.OBJ").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       objtime = f$cvtime(f$file_attributes("NEWSSHUTDOWN.OBJ","rdt"))
$       iftest =      deftime.gts.objtime -
                 .or. f$cvtime(f$file_attributes("[-.NEWS_SRC]NEWSSHUTDOWN.C","rdt")).gts.objtime
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc newsshutdown"
$     cc/object=[-.news_build]NEWSSHUTDOWN.obj'cc_opt' NEWSSHUTDOWN
$     set def [-.news_build]
$     if purge_objs then purge NEWSSHUTDOWN.obj
$   ENDIF
$ ENDIF
$!
$ IF f$search("NEWSSHUTDOWN.OBJ") .nes. "" .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("[-.NEWS_DIST]NEWSSHUTDOWN.EXE").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("NEWSSHUTDOWN.OBJ","rdt")).gts.-
	     f$cvtime(f$file_attributes("[-.NEWS_DIST]NEWSSHUTDOWN.EXE","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ link newsshutdown"
$     link/nomap/notrace/exe=[-.news_dist]NEWSSHUTDOWN.exe -
	NEWSSHUTDOWN, -
	news_library/libr/include=newsmsg,'link_lib'
$     if purge_exes then purge [-.news_dist]NEWSSHUTDOWN.exe
$   ENDIF
$ ENDIF
$!
$!  FEEDCHECK.EXE
$!
$ IF f$search("[-.NEWS_SRC]FEEDCHECK.C") .nes. "" .and. .not. client_only .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("FEEDCHECK.OBJ").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       objtime = f$cvtime(f$file_attributes("FEEDCHECK.OBJ","rdt"))
$       iftest =      deftime.gts.objtime -
                 .or. f$cvtime(f$file_attributes("[-.NEWS_SRC]FEEDCHECK.C","rdt")).gts.objtime
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc feedcheck"
$     cc/object=[-.news_build]FEEDCHECK.obj'cc_opt' FEEDCHECK
$     set def [-.news_build]
$     if purge_objs then purge FEEDCHECK.obj
$   ENDIF
$ ENDIF
$ IF f$search("[-.NEWS_SRC]FEEDCHECKCMD.CLD") .nes. "" .and. .not. client_only .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("FEEDCHECKCMD.OBJ").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       objtime = f$cvtime(f$file_attributes("FEEDCHECKCMD.OBJ","rdt"))
$       iftest =      deftime.gts.objtime -
                 .or. f$cvtime(f$file_attributes("[-.NEWS_SRC]FEEDCHECKCMD.CLD","rdt")).gts.objtime
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ set command/obj feedcheckcmd"
$     set command/object=[-.news_build]FEEDCHECKCMD FEEDCHECKCMD
$     set def [-.news_build]
$     if purge_objs then purge FEEDCHECKCMD.obj
$   ENDIF
$ ENDIF
$!
$ IF f$search("FEEDCHECK.OBJ") .nes. "" .and. f$search("FEEDCHECKCMD.OBJ") .nes. "" .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("[-.NEWS_DIST]FEEDCHECK.EXE").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("FEEDCHECK.OBJ","rdt")).gts.-
	     f$cvtime(f$file_attributes("[-.NEWS_DIST]FEEDCHECK.EXE","rdt")).or.-
		 f$cvtime(f$file_attributes("FEEDCHECKCMD.OBJ","rdt")).gts.-
	     f$cvtime(f$file_attributes("[-.NEWS_DIST]FEEDCHECK.EXE","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ link feedcheck"
$     link/nomap/notrace/exe=[-.news_dist]FEEDCHECK.exe	-
	FEEDCHECK,FEEDCHECKCMD,-
	'link_lib'
$     if purge_exes then purge [-.news_dist]FEEDCHECK.exe
$   ENDIF
$ ENDIF
$!
$!  BATCHNEWS.EXE
$!
$ IF f$search("[-.NEWS_SRC]BATCHNEWS.C") .nes. "" .and. .not. client_only .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("BATCHNEWS.OBJ").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       objtime = f$cvtime(f$file_attributes("BATCHNEWS.OBJ","rdt"))
$       iftest =      deftime.gts.objtime -
                 .or. f$cvtime(f$file_attributes("[-.NEWS_SRC]BATCHNEWS.C","rdt")).gts.objtime
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ cc batchnews"
$     cc/object=[-.news_build]BATCHNEWS.obj'cc_opt' BATCHNEWS
$     set def [-.news_build]
$     if purge_objs then purge BATCHNEWS.obj
$   ENDIF
$ ENDIF
$ IF f$search("[-.NEWS_SRC]BATCHNEWSCMD.CLD") .nes. "" .and. .not. client_only .and. .not. skip_compile
$ THEN
$   IF force_compile
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("BATCHNEWSCMD.OBJ").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       objtime = f$cvtime(f$file_attributes("BATCHNEWSCMD.OBJ","rdt"))
$       iftest =      deftime.gts.objtime -
                 .or. f$cvtime(f$file_attributes("[-.NEWS_SRC]BATCHNEWSCMD.CLD","rdt")).gts.objtime
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     set def [-.news_src]
$     say "$ set command/obj batchnewscmd"
$     set command/object=[-.news_build]BATCHNEWSCMD BATCHNEWSCMD
$     set def [-.news_build]
$     if purge_objs then purge BATCHNEWSCMD.obj
$   ENDIF
$ ENDIF
$!
$ IF f$search("BATCHNEWS.OBJ") .nes. "" .and. f$search("BATCHNEWSCMD.OBJ") .nes. "" .and. .not. skip_link
$ THEN
$   IF force_link
$   THEN
$     iftest = 1
$   ELSE
$     IF f$search("[-.NEWS_DIST]BATCHNEWS.EXE").eqs. ""
$     THEN
$       iftest = 1
$     ELSE
$       iftest = f$cvtime(f$file_attributes("BATCHNEWS.OBJ","rdt")).gts.-
	     f$cvtime(f$file_attributes("[-.NEWS_DIST]BATCHNEWS.EXE","rdt")).or.-
		 f$cvtime(f$file_attributes("BATCHNEWSCMD.OBJ","rdt")).gts.-
	     f$cvtime(f$file_attributes("[-.NEWS_DIST]BATCHNEWS.EXE","rdt"))
$     ENDIF
$   ENDIF
$   IF iftest
$   THEN
$     say "$ link batchnews"
$     link/nomap/notrace/exe=[-.news_dist]BATCHNEWS.exe -
	BATCHNEWS,BATCHNEWSCMD,-
	'link_lib'
$     if purge_exes then purge [-.news_dist]BATCHNEWS.exe
$   ENDIF
$ ENDIF
$ say "NEWS FILES Built"
$done:
$ set def [-.news_src]
$ if newsrclog .nes. "" then $ define newsrc 'newsrclog
$ exit ! 'f$verify(makehay_ver)'
$!
$!  COMPILE SUBROUTINE
$!
$compile: subroutine
$   on control_y THEN $ stop
$   IF skip_compile THEN $  goto compdun
$   if f$trnlnm(p1) .nes. ""
$   then 
$       savedSym = "''p1'"
$       savedTrn = f$trnlnm(p1)
$       deassign 'p1
$   endif
$   srcname = f$parse(p1,"[-.news_src].c")
$   srctype = f$parse(srcname,,,"TYPE") - "."
$   objname = f$parse(".obj;",p1) - ";"
$   objcomp = f$parse("[-.news_build].obj;",p1) - ";"
$   srctime = f$cvtime(f$file_attributes(srcname,"rdt"))
$   IF p2 .eqs. "NODELOBJ" THEN $ goto testcomp
$   IF make_nodebug THEN goto testcomp
$   goto dbgcomp
$    testcomp:
$     IF force_compile THEN $ goto ccit
$     IF f$search(objname).eqs."" THEN $ goto ccit
$     objtime = f$cvtime(f$file_attributes(objname,"rdt"))
$     IF srctime.gts.objtime THEN $ goto ccit
$     IF vartime.gts.objtime THEN $ goto ccit
$     IF exttime.gts.objtime THEN $ goto ccit
$     IF deftime.gts.objtime THEN $ goto ccit
$     IF inctime.gts.objtime THEN $ goto ccit
$     IF sittime.gts.objtime THEN $ goto ccit
$     IF msgtime.gts.objtime THEN $ goto ccit
$     IF p3 .eqs. "NNTP" .and. nntpinctime.gts.objtime THEN $goto ccit
$     goto dbgcomp
$    ccit:
$     set def [-.news_src]
$     goto cmp_'srctype'
$     goto cmp_UNKNOWN
$cmp_C:
$     say "$ cc/nodebug/opt ''p1'"
$     cc'cc_opt'/object='objcomp 'srcname
$     goto cmp_endcase
$cmp_MAR:
$     say "$ macro ''p1'"
$     macro/nolis/nodebug/object='objcomp 'srcname
$     goto cmp_endcase
$cmp_CLD:
$     say "$ set command/obj ''p1'"
$     set command/obj='objcomp 'srcname
$     goto cmp_endcase
$cmp_MSG:
$     say "$ message ''p1'"
$     message/nolis/object='objcomp 'srcname
$     goto cmp_endcase
$cmp_UNKNOWN:
$     say "unknown source file type: ",srctype
$     goto cmp_endcase
$cmp_endcase:
$     set def [-.news_build]
$     library/object news_library 'objname
$     If .not.purge_objs Then goto dbgcomp
$     IF p2 .eqs. "NODELOBJ" THEN $ goto purgeit
$     create 'objname
	COMPILE MARKER
$    purgeit:
$     purge 'objname
$ dbgcomp:
$   IF .not. make_debug THEN $  goto compdun
$    dbgchk:
$     objname = f$parse(f$parse(p1,,,"NAME")+"d", ".obj;") - ";"
$     objcomp = f$parse(f$parse(p1,,,"NAME")+"d", "[-.news_build].obj;") - ";"
$     IF force_compile THEN $ goto dbgccit
$     IF f$search(objname).eqs."" THEN $ goto dbgccit
$     objtime = f$cvtime(f$file_attributes(objname,"rdt"))
$     IF srctime.gts.objtime THEN $ goto dbgccit
$     IF vartime.gts.objtime THEN $ goto dbgccit
$     IF exttime.gts.objtime THEN $ goto dbgccit
$     IF deftime.gts.objtime THEN $ goto dbgccit
$     IF inctime.gts.objtime THEN $ goto dbgccit
$     IF sittime.gts.objtime THEN $ goto dbgccit
$     IF msgtime.gts.objtime THEN $ goto dbgccit
$     IF p3 .eqs. "NNTP" .and. nntpinctime.gts.objtime THEN $goto ccit
$     goto compdun
$    dbgccit:
$     set def [-.news_src]
$     goto cmpdbg_'srctype'
$     goto cmpdbg_UNKNOWN
$cmpdbg_C:
$     say "$ cc/debug/noopt ''p1'"
$     cc'cc_noopt'/object='objcomp 'srcname
$     goto cmpdbg_endcase
$cmpdbg_MAR:
$     say "$ macro/debug ''p1'"
$     macro/nolis/debug/object='objcomp 'srcname
$     goto cmpdbg_endcase
$cmpdbg_CLD:
$     say "$ set command/obj ''p1'"
$     set command/obj='objcomp 'srcname
$     goto cmpdbg_endcase
$cmpdbg_MSG:
$     say "$ message ''p1'"
$     message/nolis/object='objcomp 'srcname
$     goto cmpdbg_endcase
$cmpdbg_UNKNOWN:
$     say "unknown source file type: ",srctype
$     goto cmpdbg_endcase
$cmpdbg_endcase:
$     set def [-.news_build]
$     library/object news_libraryd 'objname
$     If .not.purge_objs Then goto compdun
$     create 'objname
	COMPILE MARKER
$     purge 'objname
$ compdun:
$     if f$type(savedSym) .nes. ""
$     then
$         define 'savedSym "''savedTrn'"
$     endif
$   exit
$ endsubroutine
$!
$!  MAKEOBJ SUBROUTINE
$!
$makeobj: subroutine
$!    p1 ... source file name (default is .C)
$!    p2 ... object file name (default is [-.NEWS_BUILD].OBJ)
$   on control_y THEN $ stop
$   IF skip_compile THEN $  goto makedun
$   srcname = f$parse(p1,"[-.news_src].c") - ";"
$   srctype = f$parse(srcname,,,"TYPE") - "."
$   objname = f$parse(p2,"[-.news_build].obj;",p1) - ";"
$   objtype = f$parse(objname,,,"TYPE") - "."
$   objnamed = f$parse(f$parse(objname,,,"NAME")+"d", objname) - ";"
$   srctime = f$cvtime(f$file_attributes(srcname,"rdt"))
$   IF force_compile THEN $ goto ccit
$   IF f$search(objname).eqs."" THEN $ goto ccit
$   objtime = f$cvtime(f$file_attributes(objname,"rdt"))
$   IF srctime.gts.objtime THEN $ goto ccit
$   goto makedun
$   ccit:
$     set def [-.news_src]
$     goto mak_'srctype'_'objtype'
$     goto mak_UNKNOWN
$ mak_C_OBJ:
$     say "$ cc ''p1'"
$     if make_nodebug then cc'cc_opt'/object='objname'  'srcname
$     if make_debug   then cc'cc_noopt'/object='objnamed' 'srcname
$     goto mak_endcase
$ mak_MAR_OBJ:
$     say "$ macro ''p1'"
$     if axpflag
$     then
$	if make_nodebug then macro/nolis/nodebug/migration/unalign/nowarn/object='objname' 'srcname
$	if make_debug   then macro/nolis/debug/migration/unalign/nowarn/object='objnamed'  'srcname
$     else
$	if make_nodebug then macro/nolis/nodebug/object='objname' 'srcname
$	if make_debug   then macro/nolis/debug/object='objnamed'  'srcname
$     endif
$     goto mak_endcase
$ mak_CLD_OBJ:
$     say "$ set command/object ''p1'"
$     set command/object='objname 'srcname
$     goto mak_endcase
$ mak_MSG_OBJ:
$     say "$ message ''p1'"
$     message/nolis/object='objname 'srcname
$     goto mak_endcase
$ mak_MSG_H:
$     say "$ @newsmsg ''p1'"
$     @newsmsg 'srcname
$     goto mak_endcase
$ mak_UNKNOWN:
$     say "Unknown compile method: ''srctype' --> ''objtype'"
$     goto mak_endcase
$ mak_endcase:
$     set def [-.news_build]
$     if purge_objs.and.make_nodebug then -
        if f$sear(objname) .nes."" then purge 'objname
$     if purge_objs.and.make_debug then -
        if f$sear(objnamed).nes."" then purge 'objnamed
$ makedun:
$   exit
$ endsubroutine
