/*
**++
**  FACILITY:
**	NEWSCLASSES
**
**  ABSTRACT:
**      Routines to manipulate CLASSES
**
**  AUTHOR:
**      Geoff Huston
**
**  COPYRIGHT:
**      Copyright  1989, 1990
**--
**/

#ifdef vaxc
#module NEWSCLASSES "V6.1"
#endif

#define _NEWSCLASSES_C
#define module_name "NEWSCLASSES"

#include "newsinclude.h"
#include "newsextern.h"

static
char class_list_ret[256],
     class_name_ret[132];

int add_class_member(cname,gnum)
  char *cname;
  unsigned int gnum;
{
  struct dir_class *ch = c_head, *pch = 0, *tch;
  int i;

  lower_case(cname);
  while (ch && (strcmp(ch->c_name,cname) < 0)) {
    pch = ch;
    ch = ch->c_next;
    }
  if (!ch || strcmp(ch->c_name,cname)) {
    tch = (struct dir_class *) news_malloc(sizeof *ch);
    tch->c_next = ch;
    strcpy((tch->c_name = (char *) news_malloc(strlen(cname) + 1)),cname);
    tch->c_nums =  (unsigned int *) news_malloc((sizeof gnum) * (tch->c_malloc = 20));
    tch->c_nums[0] = gnum;
    tch->c_size = 1;
    if (pch) pch->c_next = tch;
    else c_head = tch;
    }
  else {
    for (i = 0; i < ch->c_size; ++i) if (ch->c_nums[i] == gnum) return 0;
    if (ch->c_size == ch->c_malloc) {
      ch->c_nums = (unsigned int *) news_realloc(ch->c_nums,((ch->c_malloc += 20) * sizeof gnum));
      }
    ch->c_nums[ch->c_size] = gnum;
    ++(ch->c_size);
    }
  return 1;
}

char *class_list(gnum)
  unsigned int gnum;
{
  struct dir_class *ch = c_head;
  char *cn;
  int i;

  *class_list_ret = '\0';
  while (ch) {
    cn = ch->c_name;
    if ((*cn != '$') && (cn[strlen(cn)-1] != '.')) {
      for (i = 0; i < ch->c_size; ++i) {
        if (ch->c_nums[i] == gnum) {
          if (!*class_list_ret) strcpy(class_list_ret,"{");
          else strcat(class_list_ret,",");
          strcat(class_list_ret,ch->c_name);
          break;
          }
        }
      }
    ch = ch->c_next;
    }
  if (*class_list_ret) strcat(class_list_ret,"} ");
  return(class_list_ret);
}

int do_add_entry()
{
  int g, c = 0, refresh = 0;
  char entry[132], class[132], *cn;
  unsigned short entry_len, class_len;
  struct dir_class *ch = c_head;
  $DESCRIPTOR(entry_dsc,entry);
  $DESCRIPTOR(class_dsc,class);

  if (   (!(cli$get_value(c$dsc("ENTRY"),&entry_dsc,&entry_len) & 1))
      && (get_input_dflt(&entry_dsc,c$dsc("Newsgroup: "),&entry_len,
           ((curr_g) ? c$dsc(ga[curr_g]->grp_name) : 0),0) == RMS$_EOF))
    return(0);
  if (!entry_len) return(0);
  entry[entry_len] = '\0';
  util_cvrt(entry,entry);
  if (!(g = ga_search_name(entry))) {
    sprintf(err_oline,"Add Entry %s: newsgroup does not exist",entry);
    err_line(err_oline);
    return(0);
    }

  while (cli$get_value(c$dsc("CLASSES"),&class_dsc,&class_len) & 1) {
    ++c;
    class[class_len] = '\0';
    lower_case(class);
    if (strchr(class,'*') || strchr(class,'%')) {
      while (ch) {
        cn = ch->c_name;
        if ((*cn != '$') && (cn[strlen(cn)-1] != '.')) {
          if (wild_match(ch->c_name,class)) {
            refresh += (ch == curr_class);
            add_class_member(ch->c_name,ga[g]->grp_num);
            }
	  }
        ch = ch->c_next;
        }
      ch = c_head;
      }
    else if ((*class != '$') && (class[strlen(class)-1] != '.')) {
      add_class_member(class,ga[g]->grp_num);
      refresh += (ch == curr_class);
      }
    }

  if (!c) {
    if (   curr_class
        && (!(   ((*(cn = curr_class->c_name)) == '$')
              || (cn[strlen(cn)-1] == '.')))) {
      add_class_member(curr_class->c_name,ga[g]->grp_num);
      ++refresh;
      }
    else err_line("Add Entry: No current class selected");
    }
  if (refresh) {
    int slev = news_context;

    set_level(1);
    return(groupdir(cur_dir_type + 1, 1,slev));
    }
  return(0);
}

int class_check(g)
  int g;
{
  unsigned int gn;
  int i;

  if (!curr_class) return(1);
  gn = ga[g]->grp_num;
  for (i = 0; i < curr_class->c_size; ++i)
    if (curr_class->c_nums[i] == gn) return(1);
  return(0);
}

static int dsc_1()
{
  int g;
  char class[132], clp[132];
  unsigned short class_len;
  struct dir_class *ch = c_head;
  $DESCRIPTOR(class_dsc,class);

  if (   (!(cli$get_value(c$dsc("CLASSNAME"),&class_dsc,&class_len) & 1))
      && (get_input_dflt(&class_dsc,c$dsc("Class: "),&class_len,
           ((curr_class) ? c$dsc(curr_class->c_name) : 0),0) == RMS$_EOF))
    return(0);
  if (!class_len) return(0);
  class[class_len] = '\0';
  lower_case(class);
  if (!strcmp(class,"*")) curr_class = 0;
  else if (!strcmp(class,"all")) curr_class = 0;
  else {
    while (ch) {
      if (!strcmp(class,ch->c_name)) break;
      ch = ch->c_next;
      }
    if (!ch && (*class != '$')) {
      strcpy(clp,"$");
      strcat(clp,class);
      ch = c_head;
      while (ch) {
        if (!strcmp(clp,ch->c_name)) break;
        ch = ch->c_next;
        }
      }
    if (!ch) {
      int memb_added = 0;

      if (strchr(class,'*') || (class[class_len - 1] == '.')) {
        char cmpclass[132], cmpclass2[132];

        strcpy(cmpclass,class);
        if (class[class_len - 1] == '.') {
          strcat(cmpclass,"*");
          strcpy(cmpclass2,class);
          cmpclass2[class_len -1] = '\0';
          }       
        else *cmpclass2 = '\0';

        for (g = 1; g <= ga_size; ++g) {
          if (wild_match(ga[g]->grp_name,cmpclass)
              || (*cmpclass2 && wild_match(ga[g]->grp_name,cmpclass2))) {
            add_class_member(class,ga[g]->grp_num);
            ++memb_added;
            }
          }
        }
      if (memb_added) set_class(class);
      else err_line("Set Class: No such class name defined");
      }
    else curr_class = ch;
    }
  set_level(1);
  do_dir(cur_dir_type + 1,1);
  set_level(1);
  return(0);
}

int do_set_class()
{
  return(unwind_display(OUTER_LOOP,dsc_1));
}

int set_class(class)
  char *class;
{
  char clp[132];
  int g;
  struct dir_class *ch = c_head;

  lower_case(class);
  if (!strcmp(class,"*")) curr_class = 0;
  else if (!strcmp(class,"all")) curr_class = 0;
  else {
    while (ch) {
      if (!strcmp(class,ch->c_name)) break;
      ch = ch->c_next;
      }
    if (!ch && (*class != '$')) {
      strcpy(clp,"$");
      strcat(clp,class);
      ch = c_head;
      while (ch) {
        if (!strcmp(clp,ch->c_name)) break;
        ch = ch->c_next;
        }
      }
    if (!ch) {
      int memb_added = 0;

      if (class[strlen(class) - 1] == '.') {
        char cmpclass[132];
        int cl = strlen(class) - 1;

        strcpy(cmpclass,class);
        strcat(cmpclass,"*");
        for (g = 1; g <= ga_size; ++g) {
          if (   wild_match(ga[g]->grp_name,cmpclass)
              || !strncmp(class,ga[g]->grp_name,cl)) {
            add_class_member(class,ga[g]->grp_num);
            ++memb_added;
            }
          }
        }
      if (memb_added) return(set_class(class));
      else return(err_line("Set Class: No such class name defined"),0);
      }
    else curr_class = ch;
    }
  return(1);
}

void reset_class()
{
  curr_class = 0;
}

char *class_name()
{
  if (curr_class) sprintf(class_name_ret,"CLASS: %s",curr_class->c_name);
  else *class_name_ret = '\0';
  return(class_name_ret);
}

static int dsclasses()
{
  struct dir_class *ch = c_head;
  int i, gn, g;
  char *cn;

  start_header(T_DISPLAY_LOOP,SHOW_CLASSES);
  put_line("CLASS DIRECTORY",0,T_DISPLAY_LOOP);
  put_line("",0,T_DISPLAY_LOOP);
  end_header(T_DISPLAY_LOOP);
  while (ch) {
    cn = ch->c_name;
    if (cn[strlen(cn)-1] != '.') {
      sprintf(err_oline,"  %s (%d)",ch->c_name,ch->c_size);
      if (ch == curr_class) *err_oline = '*';
      put_line(err_oline,0,T_DISPLAY_LOOP);
      for (i = 0; i < ch->c_size; ++i) {
        gn = ch->c_nums[i];
	if ((g = ga_locate(gn)) != 0) {
          sprintf(err_oline,"\t%s",ga[g]->grp_name);
          put_line(err_oline,0,T_DISPLAY_LOOP);
          }
        }
      }
    ch = ch->c_next;
    }
  put_line("",1,T_DISPLAY_LOOP);
  return(0);
}

int do_show_classes()
{
  if (!c_head) return(err_line("Show Classes: No classes defined"),0);
  return(unwind_display(I_DISPLAY_LOOP,dsclasses));
}

void list_classes(g)
  unsigned int g;
{
  struct dir_class *ch = c_head;
  int op = 0, i;
  char *cn;

  while (ch) {
    cn = ch->c_name;
    if (cn[strlen(cn)-1] != '.') {
      for (i = 0; i < ch->c_size; ++i) {
        if (ch->c_nums[i] == g) {
          if (!op++)
	    put_line("Newsgroup is entered in the following Classes:",0,T_DISPLAY_LOOP);
          sprintf(err_oline,"  %s",ch->c_name);
          put_line(err_oline,0,T_DISPLAY_LOOP);
          break;
          }
        }
      }
    ch = ch->c_next;
    }
}

int do_modify_entry()
{
  int g, i;
  unsigned int gn;
  char entry[132], class[132], *cn;
  unsigned short entry_len,
        class_len;
  struct dir_class *ch = c_head;
  $DESCRIPTOR(entry_dsc,entry);
  $DESCRIPTOR(class_dsc,class);

  if (   (!(cli$get_value(c$dsc("NEWSGROUP"),&entry_dsc,&entry_len) & 1))
      && (get_input_dflt(&entry_dsc,c$dsc("Newsgroup: "),&entry_len,
              ((curr_g) ? c$dsc(ga[curr_g]->grp_name) : 0),0) == RMS$_EOF))
    return(0);
  if (!entry_len) return(0);
  entry[entry_len] = '\0';
  util_cvrt(entry,entry);
  if (!(g = ga_search_name(entry))) {
    sprintf(err_oline,"Modify Entry %s: newsgroup does not exist",entry);
    err_line(err_oline);
    return(0);
    }
  gn = ga[g]->grp_num;

  if (!(cli$present(c$dsc("CLASSES")) & 1)) return(0);
  while (ch) {
    cn = ch->c_name;
    if ((*cn != '$') && (cn[strlen(cn)-1] != '.')) {
      for (i = 0; i < ch->c_size; ++i)
        if (ch->c_nums[i] == gn) ch->c_nums[i] = 0;
      }
    ch = ch->c_next;
    }
  ch = c_head;

  while (cli$get_value(c$dsc("CLASSES"),&class_dsc,&class_len) & 1) {
    class[class_len] = '\0';
    lower_case(class);
    if (strchr(class,'*') || strchr(class,'%')) {
      while (ch) {
        cn = ch->c_name;
        if ((*cn != '$') && (cn[strlen(cn)-1] != '.')) {
          if (wild_match(class,ch->c_name))
            add_class_member(ch->c_name,ga[g]->grp_num);
          }
        ch = ch->c_next;
        }
      ch = c_head;
      }
    else if ((*class != '$') && (class[strlen(class)-1] != '.'))
      add_class_member(class,ga[g]->grp_num);
    }
  return(0);
}

int do_delete_entry()
{
  int g = 0, c = 0, delete_class = 0, i;

  unsigned int gn;
  char entry[132], class[132], *cn;
  unsigned short entry_len,
		 class_len;
  struct dir_class *ch = c_head, *pch;
  $DESCRIPTOR(entry_dsc,entry);
  $DESCRIPTOR(class_dsc,class);

  if (   (!(cli$get_value(c$dsc("ENTRY"),&entry_dsc,&entry_len) & 1))
      && (get_input_dflt(&entry_dsc,c$dsc("Newsgroup: "),&entry_len,
           ((curr_g) ? c$dsc(ga[curr_g]->grp_name) : 0),0) == RMS$_EOF))
    return(0);
  if (!entry_len) return(0);
  entry[entry_len] = '\0';
  util_cvrt(entry,entry);

  if (!strcmp(entry,"*")) delete_class = 1;
  else if (!(g = ga_search_name(entry))) {
    sprintf(err_oline,"Delete Entry %s: newsgroup does not exist",entry);
    err_line(err_oline);
    return(0);
    }
  gn = g ? ga[g]->grp_num : 0;

  while (cli$get_value(c$dsc("CLASSES"),&class_dsc,&class_len) & 1) {
    ++c;
    class[class_len] = '\0';
    lower_case(class);
    while (ch) {
      cn = ch->c_name;
      if ((*cn != '$') && (cn[strlen(cn)-1] != '.')) {
        if (wild_match(class,ch->c_name)) {
          if (delete_class) {
            pch = 0;
            if (ch != c_head) {
              pch = c_head;
              while (pch->c_next != ch) pch = pch->c_next;
              }
            news_free(ch->c_name);
            news_free(ch->c_nums);
            if (ch == curr_class) curr_class = 0;
            if (pch) pch->c_next = ch->c_next;
            else c_head = ch->c_next;
            news_free(ch);
            }
          else {
            for (i = 0; i < ch->c_size; ++i)
              if (ch->c_nums[i] == gn) ch->c_nums[i] = 0;
            }
          }
        }
      ch = ch->c_next;
      }
    ch = c_head;
    }
  if (!c && curr_class) {
    ch = curr_class;
    cn = ch->c_name;
    if ((*cn != '$') && (cn[strlen(cn)-1] != '.')) {
      if (delete_class) {
        pch = 0;
        if (ch != c_head) {
          pch = c_head;
          while (pch->c_next != ch) pch = pch->c_next;
          }
        news_free(ch->c_name);
        news_free(ch->c_nums);
        curr_class = 0;
        if (pch) pch->c_next = ch->c_next;
        else c_head = ch->c_next;
        news_free(ch);
        }
      else {
        for (i = 0; i < ch->c_size; ++i)
          if (ch->c_nums[i] == gn) ch->c_nums[i] = 0;
        }
      }
    }
  return(0);
}

void set_start_classname(class)
  char *class;
{
  strcpy(n_class_name,class);
  initial_classname = 1;
}
