/*
**++
**  FACILITY:
**      NEWSCONFIGS
**
**  ABSTRACT:
**      Manage NEWS configuration files
**
**  AUTHOR:
**      Geoff Huston
**
**  COPYRIGHT:
**      Copyright, Geoff Huston  1988,1989,1990,1991,1992
**
**  MODIFICATION HISTORY:
**	V6.1b9	17-Aug-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to make it compile under gcc 2.6.0 with full
**	    warnings reporting turned on - with no or very few harmless warnings
**	V6.1b9	17-Sep-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to preserve the read-only nature of string literals
**	    (strategically placed 'const' attribute to string parameters)
**--
**/

#ifdef vaxc
#module NEWSCONFIGS "V6.1"
#endif

#define _NEWSCONFIGS_C
#define module_name "NEWSCONFIGS"

#include "newsinclude.h"
#include "newsextern.h"

char newsg[256];

static int dsaliases()
{
  ALIAS_PTR tmp = aliases_list;

  if (!tmp) {
    err_line("SHOW ALIASES - no local aliases defined");
    return(0);
    }

  start_header(T_DISPLAY_LOOP,SHOW_ALIASES);
  put_line("NEWS  - Local Newsgroup Alias list",0,T_DISPLAY_LOOP);
  put_line("",0,T_DISPLAY_LOOP);
  end_header(T_DISPLAY_LOOP);

  while (tmp) {
    if ( wild_match(tmp->ngname,newsg) ) {
      sprintf(err_oline,"%s -> %s",tmp->ngname,tmp->alias_name);
      put_line(err_oline,0,T_DISPLAY_LOOP);
      }
    tmp = tmp->a_next;  
    }
  put_line("",1,T_DISPLAY_LOOP);
  return(0);
}

int do_show_aliases()
{
  $DESCRIPTOR(newsg_d,newsg);
  unsigned short len = 0;

  if (cli$get_value(c$dsc("NEWSGROUP"),&newsg_d,&len) & 1) newsg[len] = '\0';
  else *newsg = '\0';
  if (!*newsg)
    strcpy(newsg,"*");
  strip_compress_lower(newsg);

  if (nntp_client) return(0);

  if (!read_aliases() && (textptr.display_code != SHOW_ALIASES)) {
    err_line("SHOW ALIASES - no local aliases defined");
    return(0);
    }
  return(unwind_display(I_DISPLAY_LOOP,dsaliases));
}

static int daalias(mod)
  int mod;
{
  int status;
  ALIAS_PTR tmp;
  char alias[256], alias_list[512], *cp;
  unsigned short len = 0;
  $DESCRIPTOR(newsg_d,newsg);
  $DESCRIPTOR(alias_d,alias);

  if (nntp_client) return(0);
  if (no_priv()) {
    err_line("Error: Set Item - No priv");
    return(0);
    }

  if (cli$get_value(c$dsc("NEWSGROUP"),&newsg_d,&len) & 1) newsg[len] = '\0';
  else *newsg = '\0';
  if (!*newsg) {
    if (!(get_input(&newsg_d,c$dsc("ALIAS Newsgroup: "),&len) & 1)) return(0);
    newsg[len] = '\0';
    }
  strip_compress_lower(newsg);
  if (!*newsg) return(0);

  if (cli$get_value(c$dsc("ALIAS"),&alias_d,&len) & 1) {
    *alias_list = '\0';
    do {
      alias[len] = '\0';
      strip_compress_lower(alias);
      if (*alias) {
        if (*alias_list) strcat(alias_list,",");
        strcat(alias_list,alias);
        }
      } while (cli$get_value(c$dsc("ALIAS"),&alias_d,&len) & 1);
    }
  else *alias_list = '\0';
  if (!*alias_list) {
    sprintf(err_oline,"ALIAS %s (to): ",newsg);
    if (!(get_input(&alias_d,c$dscl(&err_oline_d),&len) & 1)) return(0);
    alias[len] = '\0';
    strcpy(alias_list,alias);
    }
  strip_compress_lower(alias_list);
  if (!*alias_list) return(0);

  if ((tmp = read_aliases()) != 0) {
    while (tmp) {
      if (!strcmp(tmp->ngname,newsg)) {
        if (!mod) {
          sprintf(err_oline,"Alias for %s (-> %s) already defined",tmp->ngname,tmp->alias_name);
          err_line(err_oline);
          status = get_input(&alias_d,c$dsc("Replace this alias? [y]"),&len);
          clear_err_line();
          if ((!(status & 1)) || (len && (tolower(*alias) != 'y'))) return(0);
          }
        news_free(tmp->alias_name);
        strcpy((tmp->alias_name = news_malloc(strlen(alias_list) + 1)),alias_list);
        break;
        }
      tmp = tmp->a_next;
      }
    }
  if (!tmp) {
    tmp = news_malloc(sizeof *tmp);
    strcpy((tmp->alias_name = news_malloc(strlen(alias_list) + 1)),alias_list);
    strcpy((tmp->ngname = news_malloc(strlen(newsg) + 1)),newsg);
    tmp->a_next = aliases_list;
    aliases_list = tmp;
    }

  tmp = aliases_list;
  sysprv();
  if ((fp = fopen(ALIAS_FILE,"w")) != 0) {
    while (tmp) {
      fprintf(fp,"%s %s\n",tmp->ngname,tmp->alias_name);
      tmp = tmp->a_next;
      }
    fgetname(fp,alias);
    fclose(fp);

    if ((cp = strchr(alias,';')) != 0) {
      strcpy(cp,";-1");
      delete_file_versions(alias);
      }
    }
  nosysprv();

  return(do_show_aliases());
}

int do_add_alias()
{
  return(daalias(0));
}

int do_mod_alias()
{
  return(daalias(1));
}

int do_delete_alias()
{
  int status;
  ALIAS_PTR tmp;
  char alias[256], *cp;
  unsigned short len = 0;
  int conf;
  $DESCRIPTOR(newsg_d,newsg);
  $DESCRIPTOR(alias_d,alias);

  if (nntp_client) return(0);
  if (no_priv()) {
    err_line("Error: Set Item - No priv");
    return(0);
    }

  conf = (cli$present(c$dsc("CONFIRM")) != CLI$_NEGATED);
  
  if (cli$get_value(c$dsc("NEWSGROUP"),&newsg_d,&len) & 1) newsg[len] = '\0';
  else *newsg = '\0';
  if (!*newsg) {
    if (!(get_input(&newsg_d,c$dsc("Delete Alias for Newsgroup: "),&len) & 1)) return(0);
    newsg[len] = '\0';
    }
  strip_compress_lower(newsg);
  if (!*newsg) return(0);

  if ((tmp = read_aliases()) != 0) {
    while (tmp) {
      if (!strcmp(tmp->ngname,newsg)) {
        if (conf) {
          sprintf(err_oline,"Alias for %s is %s",tmp->ngname,tmp->alias_name);
          err_line(err_oline);
          status = get_input(&alias_d,c$dsc("Delete alias? [y]"),&len);
          clear_err_line();
          if ((!(status & 1)) || (len && (tolower(*alias) != 'y')))
            return(0);
          }
        break;
        }
      tmp = tmp->a_next;
      }
    }

  if (!tmp) {
    sprintf(err_oline,"No Alias defined for %s",newsg);
    err_line(err_oline);
    return(0);
    }

  if (tmp == aliases_list) aliases_list = tmp->a_next;
  else {
    ALIAS_PTR p = aliases_list;

    while (p->a_next != tmp) p = p->a_next;
    p->a_next = tmp->a_next;
    }

  news_free(tmp->ngname);
  news_free(tmp->alias_name);
  news_free(tmp);

  tmp = aliases_list;
  sysprv();

  if (tmp) {
    if ((fp = fopen(ALIAS_FILE,"w")) != 0) {
      while (tmp) {
        fprintf(fp,"%s %s\n",tmp->ngname,tmp->alias_name);
        tmp = tmp->a_next;
        }
      fgetname(fp,alias);
      fclose(fp);

      if ((cp = strchr(alias,';')) != 0) {
        strcpy(cp,";-1");
        delete_file_versions(alias);
        }
      }
    }
  else delete_file_versions(ALIAS_FILE);

  nosysprv();

  return(do_show_aliases());
}

static void out_list(c,f)
  const char *c;
  const SYS_FILTER_T *f;
{
  if (!f) return;
  sprintf(err_oline,"    %s: ",c);
  do {
    strcat(err_oline,f->sys_filtnam);
    if ((f = f->sys_fnext) != 0) {
      strcat(err_oline,",");
      if ((strlen(err_oline) + strlen(f->sys_filtnam) + 2) > devcol) {
        put_line(err_oline,0,T_DISPLAY_LOOP);
        strcpy(err_oline,"        ");
        }
      }
    else put_line(err_oline,0,T_DISPLAY_LOOP);
    } while (f);
}

    
static int dssys()
{
  SYS_ENTRY_T *tmp = sysfile;
  char *cp;

  if (!tmp) {
    err_line("SHOW SYS - no local aliases defined");
    return(0);
    }

  start_header(T_DISPLAY_LOOP,SHOW_SYS);
  put_line("NEWS - System Configuration (NEWS.SYS)",0,T_DISPLAY_LOOP);
  end_header(T_DISPLAY_LOOP);

  while (tmp) {
    put_line("",0,T_DISPLAY_LOOP);
    sprintf(err_oline,"Node: %s",tmp->sys_nodename);
    if (local_filter == tmp->sys_f) strcat(err_oline," (LOCAL NODE)");
    put_line(err_oline,0,T_DISPLAY_LOOP);
    if (tmp->sys_no) out_list("Path Filter",tmp->sys_no);
    if (tmp->sys_f) out_list("Newsgroups Accepted",tmp->sys_f);
    else put_line("    Newsgroups Accepted: *",0,T_DISPLAY_LOOP);
    if (tmp->sys_f == tmp->sys_d) 
      put_line("    Distributions Accepted: => Newsgroups",0,T_DISPLAY_LOOP);
    else if (tmp->sys_d) out_list("Distributions Accepted",tmp->sys_d);
    else put_line("    Distributions Accepted: *",0,T_DISPLAY_LOOP);
    if (tmp->sys_type && *(tmp->sys_type)) {
      sprintf(err_oline,"    Flags: %s",tmp->sys_type);    
      cp = tmp->sys_type;
      if (*cp == 'b') {
        strcat(err_oline,"   (Batch-File");
        if (*(cp + 1) == 'n')
          strcat(err_oline,", N-wrapped");
        strcat(err_oline,")");
        }
      else if (*cp == 'm') {
        strcat(err_oline,"   (Message-File");
        if (*(cp + 1) == 'n')
          strcat(err_oline,", N-wrapped");
        strcat(err_oline,")");
        }
      else if (*cp == 'n') {
        strcat(err_oline,"   (Message-ID-File");
        if (*(cp + 1) == 'x')
          strcat(err_oline,", Indexed-Access");
        strcat(err_oline,")");
        }
      else if (*cp == 'f') {
        strcat(err_oline,"   (File-Specification-List-Batch-File");
        if (*(cp + 1) == 'c')
          strcat(err_oline,", File-Size-Included");
        strcat(err_oline,")");
        }
      put_line(err_oline,0,T_DISPLAY_LOOP);
      }
    if (tmp->sys_file && *(tmp->sys_file)) {
      sprintf(err_oline,"    Spool Area: %s",tmp->sys_file);    
      put_line(err_oline,0,T_DISPLAY_LOOP);
      }
    tmp = tmp->sys_enext;
    }
  put_line("",1,T_DISPLAY_LOOP);
  return(0);
}

int do_show_sys()
{
  if (nntp_client) return(0);

  if (!readsys() && (textptr.display_code != SHOW_SYS)) {
    err_line("SHOW SYS - no local sys config file located");
    return(0);
    }
  return(unwind_display(I_DISPLAY_LOOP,dssys));
}
