/*
**++
**  FACILITY:
**
**      NEWSEXTERN
**
**  ABSTRACT:
**
**      Common NEWS external variable definitions.
**
**  AUTHOR:
**
**      Geoff Huston
**
**  COPYRIGHT:
**
**      Copyright  1988
**
**  MODIFICATION HISTORY:
**
**      V5.5     7-Oct-1988     GIH
**      V5.6    11-Nov-1988     GIH
**        - Version 5.6 release - no changes to this module
**      V5.9    18-Apr-1989     GIH
**        - Include data types of runtime functions for GNUCC compiler
**      V6.0    30-Sep-1990     SCA
**        - Update for version 6.0 and handle prototypes differently
**	V6.1     2-Feb-1992     rankin@eql.caltech.edu
**	  - lint cleanup from gcc -Wall
**	V6.1b5  17-Feb-1993     bailey@genetics.upenn.edu
**	  - changed 'unseenitems' to 'unreaditems' throughout
**	V6.1b7  15-May-1993  Charles Bailey  bailey@genetics.upenn.edu
**	  - add routines for item lookup, message-id handling, and
**	    case-insensitive string comparison
**	V6.1b7  13-Jul-1993  Charles Bailey  bailey@genetics.upenn.edu
**	  - change set_mail_self_flag() in NewsForward.C to extern, so it
**	    can be called from do_posting() in NewsPost.C
**	V6.1b9	17-Aug-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to make it compile under gcc 2.6.0 with full
**	    warnings reporting turned on - with no or very few harmless warnings
**	V6.1b9	17-Sep-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to preserve the read-only nature of string literals
**	    (strategically placed 'const' attribute to string parameters)
**	  - added some prototypes
**--
**/

#ifndef _NEWSEXTERN_H
#define _NEWSEXTERN_H

#include "newsdefine.h"

#ifndef _NNTPINCLUDE_H
#include "newsvariables.h"
#endif

#if PROTOTYPES
#define __ARGS(args) args
#else
#define __ARGS(args) ()
#endif

/* These aren't currently (VAXC 3.2) defined in unixlib.h */
/* (but are declared when __DECC or __GNUC__) */
#if defined(vaxc) && !defined(__DECC)
extern int chmod __ARGS((const char *, unsigned int));
#endif

/* extern unsigned short umask __ARGS((unsigned int));  HUJI - AXP */

/* Prototype the CLI routines we use */

extern int cli$dispatch __ARGS((void));
extern int cli$present __ARGS((struct dsc$descriptor_const_s *));
extern int cli$get_value __ARGS((struct dsc$descriptor_const_s *,
                                 struct dsc$descriptor_s *, unsigned short *));
extern int cli$dcl_parse __ARGS((struct dsc$descriptor_const_s *, int *, int (*)(),
                                 int (*)(), struct dsc$descriptor_const_s *));

extern int lib$free_vm_page();
extern int lib$get_vm_page();
extern int lib$multf_delta_time();
extern int lib$sub_times();
extern int lib$attach();
extern int lib$getjpi();
extern int lib$get_vm(), lib$free_vm(), lib$show_vm();
extern int lib$emul(), lib$ediv(), lib$subx();

extern void lib$signal __ARGS((int, ...));
extern void lib$stop __ARGS((int, ...));
extern int lib$sig_to_ret __ARGS((void *, void *));
extern void lib$establish __ARGS((int (*exception_handler)(void *,void *)));
	/* these prototypes are only approximate */
extern int lib$find_file __ARGS((const struct dsc$descriptor_const_s *,
				 struct dsc$descriptor_s *, void *, ...));
extern int lib$find_file_end __ARGS((void *));
extern int lib$get_foreign __ARGS((struct dsc$descriptor_s *, ...));

#define	DESCR  const struct dsc$descriptor_const_s
extern int lib$spawn __ARGS((DESCR*,DESCR*,DESCR*,int*,DESCR*,int*,int*,
                            char*,void*,int,DESCR*,DESCR*));
extern int lib$find_image_symbol __ARGS((DESCR*,DESCR*,int (**)()));

extern int lib$create_dir __ARGS((DESCR*, ...));
extern int lib$set_logical __ARGS((DESCR*,DESCR*,DESCR*, ...));
extern int lib$put_output __ARGS((DESCR*));
extern int lib$get_input __ARGS((struct dsc$descriptor_s *, DESCR*, unsigned short *));
#undef DESCR

/*
 * ADD_TRANSFORM.C
 *
 */

#ifndef _ADD_TRANSFORM_C
#define EXTERN extern
#else
#define EXTERN
#if !UWO
static void clearaddrs __ARGS((void));
static void read_cnf __ARGS((void));
static void *load_cnf __ARGS((void));
static char *transform __ARGS((char *, int));
static int match __ARGS((const char *, const char *, int, int));
#endif
#endif
EXTERN char *add_transform __ARGS((char *));
#undef EXTERN

/*
 * NEWSADD.C
 *
 */

#ifndef _NEWSADD_C
#define EXTERN extern
#else
#define EXTERN
#endif
EXTERN char *create_article __ARGS((char *, char *));
EXTERN int do_add_net __ARGS((void));
EXTERN int do_add_mail __ARGS((void));
EXTERN int add_posting __ARGS((FILE *, int));
EXTERN int post_net __ARGS((char **, char *));
#undef EXTERN

/*
 * NEWSCALLEDIT.C
 *
 */

#ifndef _NEWSCALLEDIT_C
#define EXTERN extern
#else
#define EXTERN
#endif
EXTERN int invoke_editor __ARGS((int, const char *, const char *, const char *));
#undef EXTERN

/*
 * NEWSCLASSES.C
 *
 */

#ifndef _NEWSCLASSES_C
#define EXTERN extern
#else
#define EXTERN
static int dsc_1 __ARGS((void));
static int dsclasses __ARGS((void));
#endif
EXTERN int add_class_member __ARGS((char *, unsigned int));
EXTERN char *class_list __ARGS((unsigned int));
EXTERN int do_add_entry __ARGS((void));
EXTERN int class_check __ARGS((int));
EXTERN int do_set_class __ARGS((void));
EXTERN int set_class __ARGS((char *));
EXTERN void reset_class __ARGS((void));
EXTERN char *class_name __ARGS((void));
EXTERN int do_show_classes __ARGS((void));
EXTERN void list_classes __ARGS((unsigned int));
EXTERN int do_modify_entry __ARGS((void));
EXTERN int do_delete_entry __ARGS((void));
EXTERN void set_start_classname __ARGS((char *));
#undef EXTERN

/*
 * NEWSCONFIGS.C
 *
 */

#ifndef _NEWSCONFIGS_C
#define EXTERN extern
#else
#define EXTERN
static int dsaliases __ARGS((void));
static int daalias __ARGS((int));
static void out_list __ARGS((const char *, const SYS_FILTER_T *));
static int dssys __ARGS((void));
#endif
EXTERN int do_show_aliases __ARGS((void));
EXTERN int do_add_alias __ARGS((void));
EXTERN int do_mod_alias __ARGS((void));
EXTERN int do_delete_alias __ARGS((void));
EXTERN int do_show_sys __ARGS((void));
#undef EXTERN

/*
 * NEWSCONTROL.C
 *
 */

#ifndef _NEWSCONTROL_C
#define EXTERN extern
#else
#define EXTERN
#if !NNTP_CLIENT_ONLY
static int control_version __ARGS((char **, char *, int));
static int control_senduuname __ARGS((char **, char *, int));
static int control_sendsys __ARGS((char **, char *, int));
static void append_control __ARGS((char *, FILE *));
static int control_newgroup __ARGS((char **, char *, int));
static int control_rmgroup __ARGS((char **, char *, int));
static void clear_domain __ARGS((void));
static struct domain_list *match_domain_list __ARGS((char *));
static void add_domain_list __ARGS((char *));
static int domain_match __ARGS((char *));
static void add_domain __ARGS((char *));
static int control_checkgroups __ARGS((char **, char *, int));
static int control_cancel __ARGS((char **, char *, int));
static int c_ihave_id __ARGS((char *, FILE *));
static int control_ihave __ARGS((char **, char *, int));
static int control_sendme __ARGS((char **, char *, int));
#endif
#endif
EXTERN int parse_control_item __ARGS((char **, char *, int, char *));
#undef EXTERN

/*
 * NEWSDELETE.C
 *
 */

#ifndef _NEWSDELETE_C
#define EXTERN extern
#else
#define EXTERN
static void delitm_file __ARGS((unsigned int, unsigned int));
static int ddi_1 __ARGS((void));
static int ddg_1 __ARGS((void));
static int dcncl __ARGS((void));
#endif
EXTERN int set_nohistory __ARGS((void));
EXTERN int set_history __ARGS((void));
EXTERN int do_show_history __ARGS((void));
EXTERN int open_hist_file __ARGS((void));
EXTERN void close_hist_file __ARGS((void));
EXTERN int hist_check __ARGS((char *));
EXTERN int hist_add __ARGS((char *));
EXTERN int hist_skim __ARGS((unsigned int));
EXTERN void parse_items __ARGS((char *, NOTE_RANGE *, int, int));
EXTERN void news_delete_file __ARGS((int, char *));
EXTERN void delgrp_mem __ARGS((int));
EXTERN void delgrp_file __ARGS((int));
EXTERN int del_grp __ARGS((int));
EXTERN int delitm_mem __ARGS((int, int));
EXTERN int del_id __ARGS((char *, char *));
EXTERN int do_ditem __ARGS((void));
EXTERN int do_dgroup __ARGS((void));
EXTERN int do_dcontext __ARGS((void));
EXTERN int do_cancel __ARGS((void));
#undef EXTERN

/*
 * NEWSDIR.C
 *
 */

#ifndef _NEWSDIR_C
#define EXTERN extern
#else
#define EXTERN
static void item_dir __ARGS((int));
static int dd_1 __ARGS((void));
static int gd_1 __ARGS((void));
#endif
EXTERN void newsgroup_dir __ARGS((void));
EXTERN int dir_call __ARGS((int, int));
EXTERN int do_dir __ARGS((int, int));
EXTERN int groupdir __ARGS((int, int, int));
EXTERN int do_dircall __ARGS((void));
EXTERN void dirnew_check __ARGS((void));
#undef EXTERN

/*
 * NEWSDISPLAY.C
 *
 */

#ifndef _NEWSDISPLAY_C
#define EXTERN extern
#else
#define EXTERN
static void put_parse __ARGS((const char *, int *, int, int));
static int ddf_1 __ARGS((void));
static int dsn_1 __ARGS((void));
#endif
EXTERN void start_header __ARGS((int, int));
EXTERN void end_header __ARGS((int));
EXTERN void put_line __ARGS((const char *, int, int));
EXTERN void put_rot __ARGS((char *, int));
EXTERN void dtungetc __ARGS((int, FILE *));
EXTERN char *detabfgets __ARGS((char *, int, FILE *));
EXTERN int do_display __ARGS((int, int, int));
EXTERN int do_display_file __ARGS((void));
EXTERN int do_set_display __ARGS((void));
EXTERN int do_show_note __ARGS((void));
#undef EXTERN

/*
 * NEWSDIST.C
 *
 */

#ifndef _NEWSDIST_C
#define EXTERN extern
#else
#define EXTERN
static int open_id_file __ARGS((SYS_ENTRY_T *));
static void close_id_file __ARGS((SYS_ENTRY_T *));
static int add_id __ARGS((SYS_ENTRY_T *, char *));
static void clearfilter __ARGS((SYS_FILTER_T *));
static void cleardist __ARGS((void));
static void clearsys __ARGS((void));
static int parse_batch_size __ARGS((char *));
static void scansys __ARGS((char *));
static void scandist __ARGS((char *));
static void scannet __ARGS((char *));
static int read_config __ARGS((const char *, void (*)()));
static void readsysd __ARGS((int));
static DIST_ENTRY_T *readnet __ARGS((void));
static int test_accept __ARGS((char *, char *, SYS_FILTER_T *, SYS_FILTER_T *));
static void clearals __ARGS((void));
static void scanalias __ARGS((char *));
static ALIAS_PTR search_aliases __ARGS((char *));
static void scandistwords __ARGS((char *));
static NAME_LIST *readdist __ARGS((void));
#endif
EXTERN SYS_ENTRY_T *readsys __ARGS((void));
EXTERN int sys_local_accept __ARGS((char *, char *));
EXTERN int sys_accept_group __ARGS((char *));
EXTERN void sys_remote_send __ARGS((char *, char *, char *, char *, char *, int));
EXTERN int path_match __ARGS((char *, char *));
EXTERN ALIAS_PTR read_aliases __ARGS((void));
EXTERN char *aliases __ARGS((char *, int));
EXTERN int check_distribution_string __ARGS((char *));
EXTERN void flush_downstream __ARGS((int));
#undef EXTERN

/*
 * NEWSEXTRACT.C
 *
 */

#ifndef _NEWSEXTRACT_C
#define EXTERN extern
#else
#define EXTERN
struct pmem;
struct it;
static void *precord __ARGS((void *));
static void punrecord __ARGS((void *));
static void *pnews_realloc __ARGS((void *, unsigned));
static void pnews_free __ARGS((struct pmem *));
static void init_filter __ARGS((unsigned *));
static int get_header_line __ARGS((char *));
static int check_header_line __ARGS((unsigned, int));
static void fill_qual_block __ARGS((void));
static void fill_local_block __ARGS((void));
static int sjc_add_file __ARGS((char *, int));
static void sjc_close_job __ARGS((void));
static int dextr __ARGS((void));
static int list_equal __ARGS((struct it *, struct it *));
static int dprint __ARGS((void));
#endif
EXTERN void get_filter __ARGS((int));
EXTERN int scan_filter __ARGS((int, int));
EXTERN void apply_filter __ARGS((int, int, unsigned, int (*)()));
EXTERN int dir_entry __ARGS((int, int));
EXTERN int extract_it __ARGS((int, int, unsigned));
EXTERN int submit_it __ARGS((int, int, unsigned));
EXTERN int do_dirwrite __ARGS((const char *, int));
EXTERN int ask_confirm __ARGS((char *, int));
EXTERN void loop_search __ARGS((int (*)()));
EXTERN void print_exit __ARGS((void));
EXTERN int do_extract __ARGS((void));
EXTERN int do_print __ARGS((void));
#undef EXTERN

/*
 * NEWSFILES.C
 *
 */

#ifndef _NEWSFILES_C
#define EXTERN extern
#else
#define EXTERN
#if NNTP_CLIENT
static int initng __ARGS((char *));
static int initng_compare __ARGS((const void *, const void*));
static void initng_sort __ARGS((void));
static int inittopics __ARGS((char *));
#if NNTP_USE_XGNOTICE
static int initnotices __ARGS((char *));
#endif
#endif
#endif
EXTERN struct rms_file *rms_open __ARGS((const char *, const char *, int));
EXTERN int rms_get __ARGS((char *, int, struct rms_file *));
EXTERN struct rms_file *rms_create __ARGS((const char *, unsigned int, int));
EXTERN int rms_put __ARGS((const char *, struct rms_file *));
EXTERN void rms_close __ARGS((struct rms_file *));
EXTERN void openfiles __ARGS((int));
#if NNTP_CLIENT
EXTERN int initgroups __ARGS((int));
#endif
EXTERN void open_groups __ARGS((int));
EXTERN void closefiles __ARGS((void));
EXTERN void closefiles_opt __ARGS((int, int));
EXTERN int get_input __ARGS((struct dsc$descriptor_s *,
                             struct dsc$descriptor_const_s *, unsigned short *));
EXTERN int get_input_dflt
                     __ARGS((struct dsc$descriptor_s *,
                             struct dsc$descriptor_const_s *, unsigned short *,
                             struct dsc$descriptor_const_s *, unsigned short *));
EXTERN int get_input_general
                     __ARGS((struct dsc$descriptor_s *,
                             struct dsc$descriptor_const_s *, unsigned short *,
                             struct dsc$descriptor_const_s *, unsigned short *,
                             int, int));
#if FAST_LOAD
EXTERN void start_group_load __ARGS((void));
EXTERN int read_group __ARGS((char *));
#endif
#undef EXTERN

/*
 * NEWSFORWARD.C
 *
 */

#ifndef _NEWSFORWARD_C
#define EXTERN extern
#else
#define EXTERN
static int dfwd __ARGS((void));
static int drply __ARGS((void));
static int dsnd __ARGS((void));
#endif
EXTERN int do_mail __ARGS((int, int));
EXTERN int do_forward __ARGS((void));
EXTERN int do_reply __ARGS((void));
EXTERN int do_send __ARGS((void));
EXTERN void set_mail_self_flag __ARGS((int));
#undef EXTERN

/*
 * NEWSHELP.C
 *
 */


#ifndef _NEWSHELP_C
#define EXTERN extern
#else
#define EXTERN
static int hlp_output __ARGS((struct dsc$descriptor_const_s *));
static int hlp_input __ARGS((struct dsc$descriptor_s *,
                             struct dsc$descriptor_const_s *, unsigned short *));
#endif
EXTERN int call_help __ARGS((const char *));
EXTERN int do_help __ARGS((void));
#undef EXTERN

/*
 * NEWSKILL.C
 *
 */

#ifndef _NEWSKILL_C
#define EXTERN extern
#else
#define EXTERN
static int dks_1 __ARGS((void));
static int dk_1 __ARGS((void));
static int kc_1 __ARGS((void));
static int dkm_1 __ARGS((void));
static void killmod_recurse __ARGS((struct marks *, char *));
#endif
EXTERN void kill_read __ARGS((FILE *));
EXTERN void kill_write __ARGS((FILE *));
EXTERN int kill_filter __ARGS((int, int));
EXTERN int do_killshow __ARGS((void));
EXTERN int do_kill __ARGS((void));
EXTERN int do_killclear __ARGS((void));
EXTERN int do_killmod __ARGS((void));
#undef EXTERN

/*
 * NEWSLOCK.C
 *
 */

#ifndef _NEWSLOCK_C
#define EXTERN extern
#else
#define EXTERN
#ifndef NO_SYNC_FILE_SUPPORT
static void closeoff __ARGS((void));
static void notify_user __ARGS((const char *));
static void enqw_timeout __ARGS((void));
static int lock_blocking_ast __ARGS((void));
static int stop_logical_defined __ARGS((void));
static int check_stop_logical __ARGS((void));
static int gotlock_ast __ARGS((void));
static int notlock_timeout __ARGS((void));
static void lock_exit_routine __ARGS((int *));
static void busy_timeout __ARGS((void));
static void busy_message __ARGS((void));
#endif
#endif
EXTERN int init_lock __ARGS((void));
EXTERN int acquire_exclusive_lock __ARGS((int));
#undef EXTERN

#if MENU_SUPPORT
/*
 * NEWSMENU.C
 *
 */

#ifndef _NEWSMENU_C
#define EXTERN extern
#else
#define EXTERN
static int run_menu();
#endif
EXTERN const char *get_menu_input __ARGS((void));
EXTERN void initialise_menus __ARGS((void));
EXTERN int auto_restarting __ARGS((void));
#undef EXTERN

#endif	/* MENU_SUPPORT */

/*
 * NEWSMOD.C
 *
 */

#ifndef _NEWSMOD_C
#define EXTERN extern
#else
#define EXTERN
#if !NNTP_CLIENT_ONLY
static void clear_mailpaths __ARGS((void));
static void add_tail_mod __ARGS((char *, char *));
static void read_mod_file __ARGS((int));
#endif
static int update_newsgroup_1 __ARGS((void));
static int update_newsgroup __ARGS((int));
#endif
EXTERN int do_attach __ARGS((void));
EXTERN int do_define __ARGS((void));
EXTERN int do_setaccess __ARGS((void));
EXTERN int do_spawn __ARGS((void));
EXTERN int do_start_version __ARGS((void));
EXTERN char *moderator_address __ARGS((char *));
EXTERN int check_moderator __ARGS((char *));
EXTERN int add_moderator __ARGS((char *, char *));
EXTERN int gwrite_access __ARGS((int));
EXTERN int write_access __ARGS((char *));
EXTERN int auth_list __ARGS((char *));
EXTERN int do_update __ARGS((void));
EXTERN int do_update_1 __ARGS((void));
EXTERN int update_newsgroup __ARGS((int));
EXTERN int unwind_display __ARGS((int, int (*)()));
#undef EXTERN

/*
 * NEWSMODE.C
 *
 */

#ifndef _NEWSMODE_C
#define EXTERN extern
#else
#define EXTERN
static int exit_mode __ARGS((int *));
#endif
EXTERN unsigned int page_size __ARGS((void));
EXTERN void chg_mode __ARGS((void));
EXTERN void reset_mode __ARGS((void));
EXTERN int set_line __ARGS((void));
EXTERN int set_noline __ARGS((void));
EXTERN int set_dotnewsrc __ARGS((void));
EXTERN int set_nodotnewsrc __ARGS((void));
EXTERN void no_broad_trap __ARGS((void));
EXTERN void broad_trap __ARGS((void));
EXTERN int set_broad __ARGS((void));
EXTERN int set_nobroad __ARGS((void));
EXTERN int leave_screen __ARGS((int));
EXTERN void join_screen __ARGS((int));
#undef EXTERN

/*
 * NEWSPOST.C
 *
 */

#ifndef _NEWSPOST_C
#define EXTERN extern
#else
#define EXTERN
static int do_posting __ARGS((int, int));
static int dpst __ARGS((void));
static int dflwp __ARGS((void));
static int dxpst __ARGS((void));
static int drepost __ARGS((void));
static int dedit __ARGS((void));
#endif
#ifdef VMSV5
EXTERN int call_mail __ARGS((const char *, const char *, const char *, const char *));
#else
EXTERN int call_mail_v5 __ARGS((const char *, const char *, const char *, const char *));
#endif
EXTERN int all_local __ARGS((char *));
EXTERN void parse_newsgroups __ARGS((char *, const char *, int, int, int));
EXTERN int call_edit __ARGS((char *));
EXTERN int do_post __ARGS((void));
EXTERN int do_followup __ARGS((void));
EXTERN int do_xpost __ARGS((void));
EXTERN int do_repost __ARGS((void));
EXTERN int do_edit __ARGS((void));
#undef EXTERN

/*
 * NEWSPROFILE.C
 *
 */

#ifndef _NEWSPROFILE_C
#define EXTERN extern
#else
#define EXTERN
static int dsprofile __ARGS((void));
static int dsetprofile __ARGS((void));
#endif
EXTERN void profile_read __ARGS((FILE *));
EXTERN void profile_write __ARGS((FILE *));
EXTERN int do_show_profile __ARGS((void));
EXTERN int do_set_profile __ARGS((void));
EXTERN void selgrp_action __ARGS((void));
EXTERN FILE *profile_sigfile __ARGS((char *));
EXTERN void clear_profile_flags __ARGS((void));
#undef EXTERN

/*
 * NEWSRC.C
 *
 */

#ifndef _NEWSRC_C
#define EXTERN extern
#else
#define EXTERN
static int find_itm __ARGS((struct marks *, unsigned int, unsigned int));
static int dmark __ARGS((void));
static int dunmark __ARGS((void));
static int dms_1 __ARGS((void));
static int scanlist __ARGS((char *));
#endif
EXTERN int get_device_class __ARGS((FILE *f));
EXTERN void putl __ARGS((const char *, FILE *));
EXTERN int read_reg_file __ARGS((void));
EXTERN int reg_context __ARGS((void));
EXTERN int write_reg_file __ARGS((void));
EXTERN int quadcmp __ARGS((unsigned int, unsigned int, unsigned int, unsigned int));
EXTERN struct marks *find_tag __ARGS((const char *, struct marks *, int));
EXTERN void mark_read __ARGS((FILE *));
EXTERN void mark_write __ARGS((FILE *));
EXTERN void mark_set __ARGS((unsigned int, unsigned int, const char *));
EXTERN void mark_clear __ARGS((char *, struct marks *));
EXTERN void mark_del __ARGS((unsigned int, unsigned int, const char *));
EXTERN int mark_find __ARGS((unsigned int, unsigned int, const char *, unsigned int *, unsigned int *));
EXTERN char *mark_list __ARGS((unsigned int, unsigned int));
EXTERN void mark_show __ARGS((const char *, struct marks *, int, int, int));
EXTERN void mark_group_list __ARGS((int));
EXTERN int do_mark __ARGS((void));
EXTERN int do_unmark __ARGS((void));
EXTERN int do_markshow __ARGS((void));
EXTERN int do_markclear __ARGS((void));
EXTERN int getnoteid __ARGS((void));
EXTERN int noterange __ARGS((const char *, const char *, int, const char *, int, int));
EXTERN int getnoterange __ARGS((void));
EXTERN int scannoterange __ARGS((char *, char *, int *));
EXTERN int fastscan __ARGS((void));
EXTERN int check_groups __ARGS((int, int));
#if ARBITRON
EXTERN void record_time __ARGS((char *, int));
EXTERN int get_time __ARGS((char *));
#endif
#undef EXTERN

/*
 * NEWSREAD.C
 *
 */

#ifndef _NEWSREAD_C
#define EXTERN extern
#else
#define EXTERN
static int ddci __ARGS((void));
static int rgi __ARGS((void));
static void stkclr __ARGS((void));
static void stkpush __ARGS((unsigned int, unsigned int));
static int stkpop __ARGS((unsigned int *, unsigned int *));
static int do_rnew_1 __ARGS((void));
static int do_rnew __ARGS((int, int, int));
static int do_readparent __ARGS((int, int));
static int do_readancestor __ARGS((int, int, int));
static int do_readident __ARGS((int, int));
static int do_readmark __ARGS((int, int));
static int dread __ARGS((void));
static int dunread __ARGS((void));
static int dnn __ARGS((void));
static int dbn __ARGS((void));
static int dtopic __ARGS((void));
static int dlst __ARGS((void));
#endif
EXTERN int markasread __ARGS((int, int, int));
EXTERN int markasunread __ARGS((int, int, int));
EXTERN void xrefs __ARGS((unsigned int, char *, int (*)()));
EXTERN void rpush __ARGS((int, int));
EXTERN int rpop __ARGS((int *, int *));
EXTERN int do_readfind __ARGS((char *, int, int));
EXTERN int display_new __ARGS((int, int, int, int));
EXTERN int do_readnew __ARGS((int, int, int));
EXTERN int do_readnext __ARGS((int, int, int));
EXTERN int parent_exists __ARGS((int *, int *));
EXTERN int do_readfollow __ARGS((int, int, int));
EXTERN int do_readprev __ARGS((int, int));
EXTERN int readtitle __ARGS((int, int, char *, int));
EXTERN int do_read __ARGS((void));
EXTERN int do_unread __ARGS((void));
EXTERN int unupdate __ARGS((int, int));
EXTERN int do_next_note __ARGS((void));
EXTERN int do_next_reply __ARGS((void));
EXTERN int do_next_unseen __ARGS((void));
EXTERN int do_back_note __ARGS((void));
EXTERN int do_back_reply __ARGS((void));
EXTERN int do_topic __ARGS((void));
EXTERN int do_last __ARGS((void));
#undef EXTERN

/*
 * NEWSREGISTER.C
 *
 */

#ifndef _NEWSREGISTER_C
#define EXTERN extern
#else
#define EXTERN
static int dddr __ARGS((void));
static int drgr __ARGS((void));
#endif
EXTERN void screen_dereg __ARGS((int));
EXTERN void screen_reg __ARGS((int));
EXTERN int do_reg_all __ARGS((int, int, int));
EXTERN void add_reg __ARGS((int, int));
EXTERN int do_dereg_all __ARGS((void));
EXTERN void rem_reg __ARGS((int));
EXTERN int do_deregister __ARGS((void));
EXTERN int do_register __ARGS((void));
#undef EXTERN

/*
 * NEWSREMCLIENT.C
 *
 */

#ifndef _NEWSREMCLIENT_C
#define EXTERN extern
#else
#define EXTERN
#ifdef UCXQIOS
static unsigned int get_local_adrs __ARGS((void));
static unsigned int get_host_adrs __ARGS((char *));
#endif
static int nntp_write __ARGS((const char *));
static void cancel_nntp_read __ARGS((int));
static int nntp_read __ARGS((char *, int));
static int nntp_read_line __ARGS((char *, int));
#endif
EXTERN int wait_net_response __ARGS((int, int));
EXTERN int open_net __ARGS((char *, int));
EXTERN void close_net __ARGS((void));
EXTERN int toggle_link __ARGS((void));
EXTERN int open_rem_chan __ARGS((const char *, int));
EXTERN int get_group_topnum __ARGS((char *, int, char *));
EXTERN FILE *get_server_file __ARGS((const char *, const char *, char *, const char *, int, int, int));
EXTERN FILE *getno_server __ARGS((int, int, const char *, char *, const char *, int));
EXTERN FILE *get_server_header __ARGS((const char *, const char *, char *, int, const char *, int));
EXTERN void server_check_ids __ARGS((struct grps *));
EXTERN void server_get_titles __ARGS((struct grps *, struct itms *));
EXTERN char *server_get_newsgroups __ARGS((char *, int, time_t));
EXTERN char *s_to_upper __ARGS((char *));
EXTERN void close_nntp_file __ARGS((void));
EXTERN int nntp_call __ARGS((char *, int, char *, char **));
EXTERN int nntp_one_call __ARGS((const char *, int, const char *, char **));
EXTERN int nntp_get_info __ARGS((const char *, int, const char *,  int, int (*)(), int (*)()));
EXTERN int post_to_server __ARGS((char *, int, char *));
#undef EXTERN

/*
 * NEWSRTL.C
 *
 */

#ifndef _NEWSRTL_C
#define EXTERN extern
#else
#define EXTERN
#endif
EXTERN int *c$alloc_tmp __ARGS((int));
EXTERN int *c$realloc_tmp __ARGS((int *, int));
EXTERN void c$free_tmp __ARGS(());
EXTERN int *c$rfi __ARGS((int));
EXTERN struct dsc$descriptor_const_s *c$dsc     __ARGS((const char *));
EXTERN struct dsc$descriptor_s       *c$dsc_rw  __ARGS((char *));
EXTERN struct dsc$descriptor_const_s *c$dscl    __ARGS((struct dsc$descriptor_s *));
EXTERN void news_assert_routine __ARGS((const char *, const char *, int, int));
EXTERN int cks_routine   __ARGS((int, const char *, int));
EXTERN int c$cks_routine __ARGS((int, const char *, int));
EXTERN int report_cio_error_routine __ARGS((int, const FILE *, const char *, const char *, int));
EXTERN int report_rms_error_routine __ARGS((int, int, const void *, const char *, int));
EXTERN int report_sys_error_routine __ARGS((int, int, int, const char *, int));
EXTERN int try_to_make_some_free_space __ARGS((int, int, const char *, int));
EXTERN char *fgetl __ARGS((FILE *));
EXTERN char *fgetlc __ARGS((FILE *));
EXTERN void strip_compress_lower __ARGS((char *));
EXTERN void strip_compress __ARGS((char *));
EXTERN void blank_strip __ARGS((char *));
EXTERN char *lower_case __ARGS((char *));
EXTERN int substrcmp __ARGS((const char *, const char *));
EXTERN int substrcasecmp __ARGS((const char *, const char *));
EXTERN void util_cpy __ARGS((char *, const char *));
EXTERN void util_idcpy __ARGS((char *, const char *));
EXTERN void util_fromcpy __ARGS((char *, const char *));
EXTERN void util_subjcpy __ARGS((char *, const char *));
EXTERN char *quotes __ARGS((char *));
EXTERN int file_copy __ARGS((const char *, const char *, int));
EXTERN int wild_match __ARGS((const char *, const char *));
EXTERN int cvt_date __ARGS((int *));
EXTERN int cvt_date_val __ARGS((char *));
EXTERN void init_tz __ARGS((void));
EXTERN int parse_usenet_date __ARGS((const char *));
EXTERN int parse_expiry_date __ARGS((const char *));
EXTERN void delete_file_versions __ARGS((const char *));
EXTERN char *chop_str __ARGS((char *,int));
EXTERN char *chop_str_plus __ARGS((char *,int));
EXTERN int news_strncasecmp __ARGS((const char *, const char *, int));
EXTERN char *news_getenv __ARGS((const char *, unsigned long int));
EXTERN void init_names __ARGS((void));
EXTERN unsigned long int set_mem_ceiling __ARGS((void));
EXTERN unsigned long int init_mem __ARGS((void));
#ifndef news_calloc
EXTERN void *news_calloc __ARGS((size_t, size_t));
#endif
#ifndef news_malloc
EXTERN void *news_malloc __ARGS((size_t));
#endif
#ifndef news_realloc
EXTERN void *news_realloc __ARGS((void *, size_t));
#endif
#ifndef news_free
EXTERN void news_free __ARGS((void *));
#endif
#ifndef news_calloc_raw
EXTERN void *news_calloc_raw __ARGS((size_t, size_t));
#endif
#ifndef news_malloc_raw
EXTERN void *news_malloc_raw __ARGS((size_t));
#endif
#ifndef news_realloc_raw
EXTERN void *news_realloc_raw __ARGS((void *, size_t));
#endif
#ifndef news_free_raw
EXTERN void news_free_raw __ARGS((void *));
#endif
#undef EXTERN

/*
 * NEWSSEARCH.C
 *
 */

#ifndef _NEWSSEARCH_C
#define EXTERN extern
#else
#define EXTERN
static char esc __ARGS((char **));
static void dodash __ARGS((int, char **, char **));
static int getccl __ARGS((char **, char **));
static int locate __ARGS((int, char *));
static int omatch __ARGS((char **, char *));
static int patsize __ARGS((char *));
static int amatch __ARGS((char *, char *));
static int reg_match __ARGS((char *, char *));
static int exe_search __ARGS((void));
static int dsh __ARGS((void));
#endif
EXTERN int makeregpat __ARGS((char *, char *));
EXTERN void search_break __ARGS((unsigned int, unsigned int, unsigned int,
                                 unsigned int, unsigned int, unsigned int));
EXTERN int get_break_str __ARGS((void));
EXTERN int do_search __ARGS((void));
#undef EXTERN

/*
 * NEWSSELECT.C
 *
 */

#ifndef _NEWSSELECT_C
#define EXTERN extern
#else
#define EXTERN
static int dsgroup __ARGS((void));
static int dopn __ARGS((void));
static int dcls __ARGS((void));
#endif
EXTERN int selnew __ARGS((int));
EXTERN int selmark __ARGS((int));
EXTERN int do_select __ARGS((const char *, int, int));
EXTERN int do_selgrp __ARGS((void));
EXTERN int do_openit __ARGS((void));
EXTERN int do_closeit __ARGS((void));
#undef EXTERN

/*
 * NEWSSETSHOW.C
 *
 */

#ifndef _NEWSSETSHOW_C
#define EXTERN extern
#else
#define EXTERN
static void update_newsitm __ARGS((int, int));
static int set_show_item __ARGS((int));
static int dsi_1 __ARGS((void));
static int dsn_1 __ARGS((void));
#if !NNTP_CLIENT_ONLY
static int dsi_2 __ARGS((void));
static int dsn_2 __ARGS((void));
#endif
static int sm_1 __ARGS((void));
static int dsmoderator __ARGS((void));
static int dse __ARGS((void));
static void dsg __ARGS((int));
static int dsa __ARGS((void));
static int dsag __ARGS((void));
#endif
EXTERN int get_newsgroup_params __ARGS((void));
EXTERN void set_newsgroup_params __ARGS((unsigned int));
EXTERN void newsg_status __ARGS((unsigned int));
EXTERN void update_newsgrp __ARGS((unsigned int));
EXTERN int set_show_newsgroup __ARGS((int));
EXTERN int do_show_item __ARGS((void));
EXTERN int do_set_item __ARGS((void));
EXTERN int do_show_newsgroup __ARGS((void));
EXTERN int do_set_newsgroup __ARGS((void));
EXTERN int ismember __ARGS((char *, char *));
EXTERN int do_add_member __ARGS((void));
EXTERN int do_delete_member __ARGS((void));
EXTERN int do_modfiy_member __ARGS((void));
EXTERN int show_members __ARGS((int, int, char *));
EXTERN int do_show_member __ARGS((void));
EXTERN int do_show_moderator __ARGS((void));
EXTERN int do_set_restrict __ARGS((int));
EXTERN int do_set_norestrict __ARGS((int));
EXTERN void check_access __ARGS((int));
EXTERN int do_set_mod __ARGS((void));
EXTERN int do_set_nomod __ARGS((void));
EXTERN int do_show_entry __ARGS((void));
EXTERN void display_group __ARGS((int));
EXTERN int cregrp __ARGS((int));
EXTERN int do_update_client __ARGS((void));
EXTERN int do_cregrp __ARGS((void));
EXTERN int do_show_allitems __ARGS((void));
EXTERN int do_show_unseenstack __ARGS((void));
EXTERN int do_show_unreaditems __ARGS((void));
EXTERN int do_set_display_type __ARGS((int, int));
#undef EXTERN

/*
 * NEWSSITE.C
 *
 */

#ifndef _NEWSSITE_C
#define EXTERN extern
#else
#define EXTERN
static void dsformatline __ARGS((const char *,const char *,const char *,const char *));
static int dsversion __ARGS((void));
#endif
EXTERN int site_get_env __ARGS((void));
EXTERN int no_priv __ARGS((void));
EXTERN int do_set_nomanager __ARGS((void));
EXTERN int do_set_manager __ARGS((void));
EXTERN int idmatch __ARGS((char *));
EXTERN int nout_priv __ARGS((void));
EXTERN void add_keys __ARGS((char *, char *));
EXTERN void get_post_defaults __ARGS((char *, char *, char *));
EXTERN void first_time __ARGS((void));
EXTERN void get_v4mailprofile __ARGS((void));
EXTERN int get_uaf_entry __ARGS((char *));
EXTERN int captive_account __ARGS((void));
EXTERN int call_mail_profile __ARGS((void));
EXTERN int do_version __ARGS((void));
#undef EXTERN

/*
 * NEWSSKIM.C
 *
 */

#ifndef _NEWSSKIM_C
#define EXTERN extern
#else
#define EXTERN
#if !NNTP_CLIENT_ONLY
static void add_recheck __ARGS((char *));
static void files_skim __ARGS((void));
static void dir_skim __ARGS((void));
static void grp_skim __ARGS((void));
static int doskim __ARGS((void));
#endif
#endif
EXTERN int do_skim __ARGS((void));
#if !NNTP_CLIENT_ONLY
EXTERN void add_check_id __ARGS((char *, char *, unsigned int, char *, int, int));
EXTERN void clear_gl __ARGS((void));
EXTERN void server_check __ARGS((int, int));
EXTERN void noserver_add __ARGS((unsigned int));
EXTERN void noserver_skim __ARGS((void));
#endif
#undef EXTERN

/*
 * NEWSSKIP.C
 *
 */

#ifndef _NEWSSKIP_C
#define EXTERN extern
#else
#define EXTERN
static void add_skip_itm __ARGS((unsigned int, unsigned int));
static int skipfollowup __ARGS((void));
static int dskip __ARGS((void));
#endif
EXTERN void screen_update_gread __ARGS((int));
EXTERN void screen_update_iread __ARGS((int, int));
EXTERN int do_skip __ARGS((void));
EXTERN int dunskip __ARGS((void));
EXTERN int do_unskip __ARGS((void));
#undef EXTERN

/*
 * NEWSUTILITY.C
 *
 */

#ifndef _NEWSUTILITY_C
#define EXTERN extern
#else
#define EXTERN
static int itf __ARGS((void));
static int dcitm __ARGS((void));
static int ga_exact_compare __ARGS((const void *, const void *));
static int dsm_1 __ARGS((void));
#if NNTP_CLIENT
static int initni __ARGS((char *));
static int nntp_get_linecount __ARGS((char *));
static int nntp_get_from __ARGS((char *));
static int additmid __ARGS((char *));
#endif
static int nntp_get_postmark __ARGS((char *));
static int nntp_get_date __ARGS((char *));
/* static char *regtext_array __ARGS((int, int, char *)); */
/* static char *regtext_range __ARGS((int, int, char *)); */
static int snewsgroup __ARGS((char *));
static int sinum __ARGS((char *));
static int fib __ARGS((char *));
static char *dat __ARGS((void));
static unsigned long int mem_fail_ret __ARGS((void));
#endif
EXTERN void nosysprv __ARGS((void));
EXTERN void sysprv __ARGS((void));
EXTERN struct dsc$descriptor_const_s *make_printable_dsc __ARGS((const char *));
EXTERN void smg_put_chars __ARGS((int, const char *, int, int, int, int));
EXTERN void clear_err_line __ARGS((void));
EXTERN int news_condition_handler __ARGS((void *, void *));
EXTERN void create_keydefs __ARGS((void));
EXTERN int cur_down_grp __ARGS((int, int));
EXTERN int cur_down_itm __ARGS((int, int, int));
EXTERN void cur_set_grp __ARGS((int));
EXTERN void cur_set_itm __ARGS((int, int));
EXTERN int cur_up_grp __ARGS((int, int));
EXTERN int cur_up_itm __ARGS((int, int, int));
EXTERN unsigned int do_newg __ARGS((char *, int, int));
EXTERN void do_new_group __ARGS((const char *, int, unsigned int *));
EXTERN void create_newsgroups __ARGS((char *, unsigned int *));
EXTERN void load_newsgroups __ARGS((char *, unsigned int *));
EXTERN FILE *do_oitem __ARGS((const ITM *, const char *, const char *, char *, int, int *));
EXTERN unsigned int do_new_item __ARGS((unsigned int *, char *, char *, char *, char *, int, int, int, int));
EXTERN void do_new_mem_grp __ARGS((void));
EXTERN char *gendate __ARGS((unsigned int));
EXTERN char *gen_id __ARGS((void));
EXTERN void do_new_mem_itm __ARGS((int, GRP_PTR));
EXTERN FILE *do_open_item __ARGS((int, int, const char *, char *));
EXTERN unsigned int find_itm_by_id __ARGS((unsigned int, const char *, unsigned int *));
EXTERN unsigned int find_itm_by_num __ARGS((unsigned int, unsigned int, int *)); 
EXTERN int get_itm_by_ident __ARGS((char *, int *, int*, int));
EXTERN int get_itm_by_num __ARGS((int, int, int *));
EXTERN FILE *do_open_header __ARGS((int, int, const char *, char *));
EXTERN int do_parse __ARGS((const char *));
EXTERN void write_err_line __ARGS((const char *));
EXTERN int ga_locate __ARGS((unsigned int));
EXTERN int ga_search_name __ARGS((const char *));
EXTERN int ga_exact_name __ARGS((const char *));
EXTERN int do_clear_messages __ARGS((void));
EXTERN void push_brdmsg __ARGS((const char *));
EXTERN void err_line __ARGS((const char *));
EXTERN int do_show_messages __ARGS((void));
EXTERN void messages_write __ARGS((FILE *));
EXTERN void display_brdcst __ARGS((int));
EXTERN void b_trap __ARGS((void));
EXTERN int create_pb __ARGS((void));
EXTERN int init_screen __ARGS((void));
EXTERN int do_screen __ARGS((void));
EXTERN int item_find __ARGS((char *));
EXTERN int map_items __ARGS((unsigned int));
EXTERN int map_ids __ARGS((unsigned int));
EXTERN int ds_lines __ARGS((int));
EXTERN int do_show_linecounts __ARGS((void));
EXTERN int ds_from __ARGS((int));
EXTERN int ds_postmark __ARGS((int));
EXTERN int do_show_postmarks __ARGS((void));
EXTERN void mem_reset __ARGS((int, int));
EXTERN int noscreen __ARGS((void));
EXTERN int do_noscreen __ARGS((void));
EXTERN void position_display __ARGS((int *, int *, int, int, int));
EXTERN void screen_map_dir __ARGS((void));
EXTERN void newsgroup_status_line __ARGS((unsigned int));
EXTERN void newsgroup_header __ARGS((void));
EXTERN void set_level __ARGS((int));
EXTERN void util_cvrt __ARGS((char *, char *));
EXTERN char *util_dir __ARGS((const char *));
EXTERN char *util_undir __ARGS((const char *));
EXTERN void strip __ARGS((char *, int));
EXTERN int do_refresh __ARGS((void));
EXTERN int do_error __ARGS((void));
EXTERN int do_exit __ARGS((void));
EXTERN int do_quit __ARGS((void));
EXTERN int screen_grp_display __ARGS((void));
EXTERN int do_groups_display __ARGS((void));
EXTERN int screen_cur_down __ARGS((void));
EXTERN int screen_cur_up __ARGS((void));
EXTERN int do_top __ARGS((void));
EXTERN int do_bottom __ARGS((void));
EXTERN int check_id __ARGS((char *));
EXTERN int do_noop __ARGS((void));
EXTERN int scup __ARGS((void));
EXTERN int scdown __ARGS((void));
EXTERN int do_abort __ARGS((void));
EXTERN void log_to_usage_file __ARGS((int,int));
EXTERN void *mem_fail __ARGS((size_t));
#undef EXTERN

/*
 * NEWSVMSMAIL.C
 *
 */

#ifndef _NEWSVMSMAIL_C
#define EXTERN extern
#else
#define EXTERN
static GRP_PTR mail_newgroup __ARGS((char *, char *));
static int folder_routine __ARGS((int *, struct dsc$descriptor *));
static int dmpurge __ARGS((void));
static int dmove __ARGS((void));
static int dcopy __ARGS((void));
static int dsmail __ARGS((void));
#endif
EXTERN int open_mail_file __ARGS((void));
EXTERN int close_mail_file __ARGS((void));
EXTERN int do_mail_purge __ARGS((void));
EXTERN int do_mail_compress __ARGS((void));
EXTERN int list_folders __ARGS((void));
EXTERN int mailmap __ARGS((int));
EXTERN FILE *read_mail __ARGS((int, int, char *));
EXTERN void remap __ARGS((const char *));
EXTERN void update_mail __ARGS((int));
EXTERN int mail_delfolder __ARGS((int));
EXTERN int del_mail_item __ARGS((int, int));
EXTERN void mail_reset __ARGS((void));
EXTERN int do_open_mail __ARGS((void));
EXTERN int do_close_mail __ARGS((void));
EXTERN void dec_newmail_count __ARGS((void));
EXTERN int do_move_folder __ARGS((int));
EXTERN int do_move __ARGS((void));
EXTERN int do_copy __ARGS((void));
EXTERN int get_common_profile __ARGS((void));
EXTERN int set_common_profile __ARGS((void));
EXTERN int do_set_mail __ARGS((void));
EXTERN int do_show_mail __ARGS((void));
#undef EXTERN

/*
 * NEWSV58_UPGRADE.C
 *
 */

#ifndef _NEWSV58_UPGRADE_C
#define EXTERN extern
#else
#define EXTERN
static int mcvtfiles __ARGS((void));
#endif
EXTERN int v58_upgrade __ARGS((void));
#undef EXTERN

/*
 * NEWSV60_UPGRADE.C
 *
 */

#ifndef _NEWSV60_UPGRADE_C
#define EXTERN extern
#else
#define EXTERN
static int mcvtfiles __ARGS((void));
#endif
EXTERN int v60_upgrade __ARGS((void));
#undef EXTERN

#endif  /* _NEWSEXTERN_H */
