/*
**++
**  FACILITY:
**
**      NEWSFORWARD
**
**  ABSTRACT:
**
**      This module interfaces to VMS MAIL. The functionality is to either
**      post a response directly back to the sender of an item (REPLY) or
**      to forward a news item to another user via mail.
**
**      The module supports mail address of either internet or mail-11 format.
**
**  AUTHOR:
**
**      Geoff Huston
**
**  COPYRIGHT:
**
**      Copyright  1988
**
**  MODIFICATION HISTORY:
**
**      V5.5     6-Oct-1988     GIH
**          Include full subject line as the subject title of the mail item.
**      V5.6    11-Nov-1988     GIH
**          Alter ^Z behaviour to only abort current operation, not NEWS itself.
**      V5.9    13-Jun-1989     GIH
**	    Use call_mail instead of lib$spawn to invoke mail function.	
**	V6.0-1	 4-Nov-1990	glass@mgi.com
**	  - corrections to extraction of reply addresses from the headers
**	V6.1	 7-FEB-1991	mark@infocomm.com
**	    Use the user's mail-profile info to determine the default state
**	    of the /SELF qualifier.
**	V6.1	 11-Aug-1992	mark@infocomm.com
**	    When a message is being "REPLIED" to, change the default subject
**	    line to be "Re: <original subject>" as long as the original subject
**	    didn't already start with "Re:"
**      V6.1     26-Apr-1993    winter@vision.rs.ch
**          changed MAIL and FORWARD to allow multiple items in a single
**          message. Added /MARK, /ALL and itemrange to MAIL and FORWARD
**          to provide this functionality
**	V6.1	13-Jul-1993	Charles Bailey  bailey@genetics.upenn.edu
**	    make set_mail_self_flag() extern as part of changes to NewsPost.C
**	V6.1b9	17-Aug-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to make it compile under gcc 2.6.0 with full
**	    warnings reporting turned on - with no or very few harmless warnings
**--
**/

#ifdef vaxc
#module NEWSFORWARD "V6.1"
#endif

#define _NEWSFORWARD_C
#define module_name "NEWSFORWARD"

#include "newsinclude.h"
#include "newsextern.h"
#include "newsmail.h"



/*
 *  do_mail
 *
 *  Either send a reply to the poster, or forward the news message.
 *  All via VMS mail.
 */

int do_mail(forward,incl_header)
  int forward, incl_header;
{
  int status;
  int header, reply_to = 0;
  char xfrbuf[512], address[512], id[256], from[256], idate[256], subj[256],
       ngroup[132], subjline[132], fpad[3];
  char *cp, *sa;
  FILE *fpr, *fpw;
  unsigned short ngroup_len;
  $DESCRIPTOR(ngroup_dsc,ngroup);
  struct stat sbuffer;

	/* Next line stops MAIL/FORW/REPLY commands working for NEWS/CAPTIVE */
  if (news_captive) return(0);

  if ((!curr_g) || (curr_i <= 0)) {
    err_line("Error: Mailer - No item located to mail");
    return(0);
    }

  if (!(fpr = do_open_item(curr_g,curr_i,"r",fp_open))) {
    err_line("Error: Mailer - cannot read item");
    return(0);
    }

  if (!(fpw = fopen(Mail_file,"w","rat=cr","rfm=var"))) {
    fclose(fpr);
    if (*fp_open > 1) delete_file_versions(fp_open);
    *fp_open = '\0';
    err_line("Error: Mailer - cannot open tmp output file");
    return(0);
    }

  fprintf(fpw,"X-News: %s %s:%d\n",news_node,ga[curr_g]->grp_name,ga[curr_g]->grp_ia[curr_i].itm_num);
  if (!forward) fprintf(fpw,"\n");

  *id = *from = *subj = *idate = '\0';
  if (forward) *fpad = '\0';
  else strcpy(fpad,">");

  header = 1;
  while (fgets(xfrbuf,510,fpr)) {
    if ((*xfrbuf == '\n') && (header)) {
      if (incl_header) fprintf(fpw,"%s%s",fpad,xfrbuf);
      else {
        fprintf(fpw,"%sFrom: %s\n%sSubject:%s\n%s%s",fpad,from,fpad,subj,fpad,idate);
        fprintf(fpw,"%s%s",fpad,"Message-ID:");
        if (*id) fprintf(fpw,"%s\n\n",id);
        else fprintf(fpw,"<%s %s:%d>\n\n", news_node,ga[curr_g]->grp_name,ga[curr_g]->grp_ia[curr_i].itm_num);
        }
      header = 0;
      continue;
      }
    else if (header) {
      if (!strncmp(xfrbuf,"From:",5)) {
        strcpy(from,&xfrbuf[6]);
	chop_str(from,'\n');
        if ((!forward) && (!reply_to)) {
          cp = &xfrbuf[5];
	  if ((sa = strchr(cp,'<')) != 0) {
            strcpy(address,++sa);  
	    chop_str(address,'>');
	    chop_str(address,'\n');
            }
          else {
            while (isspace(*cp)) cp++;
            strcpy(address,cp);
            cp = address;			/* glass@mgi.com V6.0-1 */
            while (*cp && !isspace(*cp)) cp++;  /*    "			*/
            *cp = '\0';                         /*    "			*/
	    chop_str(address,'(');
            }
          }
        }
      else if ((!forward) && (!strncmp(xfrbuf,"Reply-To:",9))) {
        reply_to = 1;
        cp = &xfrbuf[9];
	if ((sa = strchr(cp,'<')) != 0) {
          strcpy(address,++sa);
	  chop_str(address,'>');
	  chop_str(address,'\n');
          }
        else {
          while (isspace(*cp)) cp++;
          strcpy(address,cp);
          cp = address;				/* glass@mgi.com V6.0-1 */
          while (*cp && !isspace(*cp)) cp++;	/*    "			*/
          *cp = '\0';                        	/*    "			*/
	  chop_str(address,'(');
          }
        }
      else if (!strncmp(xfrbuf,"Message-ID:",11)) {
        strcpy(id,&xfrbuf[12]);
	chop_str(id,'\n');
        }
      else if (!strncmp(xfrbuf,"Subject:",8)) {
        strcpy(subj,&xfrbuf[9]);
	chop_str(subj,'\n');
        }
      else if (!strncmp(xfrbuf,"Date:",5)) {
        strcpy(idate,xfrbuf);
        }
      }
    if ((!header) || ((incl_header) && (header))) {
      if ((*xfrbuf == '>') && *fpad) fprintf(fpw,">%s",xfrbuf);
      else fprintf(fpw,"%s%s",fpad,xfrbuf);
      }
    }
  fclose(fpr);
  if (*fp_open > 1) delete_file_versions(fp_open);
  *fp_open = '\0';
  if ( (fpr = profile_sigfile(0)) != 0 ) {
    fputs("-- \n",fpw);
    if (forward) fputs("Forwarded-By:\n",fpw);
    while (fgets(xfrbuf,512,fpr)) fputs(xfrbuf,fpw);
    fclose(fpr);
    }
  fclose(fpw);


  set_mail_self_flag(forward);

  *xfrbuf = '\0';
  if (forward && (cli$get_value(c$dsc("TO"),&ngroup_dsc,&ngroup_len) & 1)) {
    do {
      ngroup[ngroup_len] = '\0';
      sprintf(&xfrbuf[strlen(xfrbuf)],"%s,",add_transform(ngroup));
      } while (cli$get_value(c$dsc("TO"),&ngroup_dsc,&ngroup_len) & 1);
    }
  else {
    char *comma_pointer, *address_field;

    if (!forward) status = get_input_dflt(&ngroup_dsc,c$dsc("To: "),&ngroup_len,c$dsc(address),0);
    else status = get_input(&ngroup_dsc,c$dsc("To: "),&ngroup_len);
    if ((status == RMS$_EOF) || (status == SMG$_EOF)) {
      delete_file_versions(Mail_file);
      mail_self_flag = 0;
      return(0);
      }
    ngroup[ngroup_len] = '\0';
    address_field = ngroup;
    do {
      comma_pointer = chop_str_plus(address_field,',');
      sprintf(&xfrbuf[strlen(xfrbuf)],"%s,",add_transform(address_field));
      address_field = comma_pointer;
      } while (address_field);
    }
  xfrbuf[strlen(xfrbuf) - 1] = '\0';

  if (cli$get_value(c$dsc("SUBJECT"),&ngroup_dsc,&ngroup_len)
      == CLI$_ABSENT) {
    if (!*subj) strcpy(subjline,ga[curr_g]->grp_ia[curr_i].itm_title);
    else if (forward) strcpy(subjline,subj); 
      else if (((subj[0] == 'r') || (subj[0] == 'R')) &&
    	       ((subj[1] == 'e') || (subj[1] == 'e')) && (subj[2] == ':'))
    	   strcpy(subjline,subj); 
         else sprintf(subjline,"Re: %s", subj);
    status = get_input_dflt(&ngroup_dsc,c$dsc("Subject: "),&ngroup_len,c$dsc(subjline),0);
    if ((status == RMS$_EOF) || (status == SMG$_EOF)) {
      delete_file_versions(Mail_file);
      return(0);
      }
    }
  ngroup[ngroup_len] = '\0';
  strcpy(subj,ngroup);

  if ((!forward) || (cli$present(c$dsc("EDIT")) & 1)) {
    if ((status = call_edit(Mail_file)) == 2) {
      mail_self_flag = 0;
      return(0);
      }
    sprintf(err_oline,"Mail <%s>? [y]:",xfrbuf);
    status = get_input(&cmd_dsc,c$dscl(&err_oline_d),&cmd_len);
    if ((status == RMS$_EOF) || (status == SMG$_EOF)) {
      delete_file_versions(Mail_file);
      mail_self_flag = 0;
      return(0);
      }
    if (!((status & 1) && ((!cmd_len) || ((cmd_len) && (toupper(*cmd) == 'Y'))))) {
      delete_file_versions(Mail_file);
      mail_self_flag = 0;
      return(0);
      }
    }
  if (stat(Mail_file,&sbuffer)) {
    err_line("Error: Mail - extracted file not found");
    mail_self_flag = 0;
    return(0);
    }
  if (!sbuffer.st_size) {
    err_line("Error: Mail - extracted file is empty");
    delete_file_versions(Mail_file);
    mail_self_flag = 0;
    return(0);
    }
  call_mail(Mail_file,subj,xfrbuf,"Invoking mailer...");
  mail_self_flag = 0;
  delete_file_versions(Mail_file);
  return(0);
}

/*
 *  forward_additm
 *
 *  Adds a message to the mailfile for forwarding.
 */

static int forward_additm(g, m, fpw, incl_header, multiple, subj)
  int g, m, incl_header, *multiple;
  char *subj;
  FILE **fpw;
{
  int header;
  char xfrbuf[512], id[256], from[256], idate[256], fpad[3];
  FILE *fpr;

  if ((m = scan_filter(g,m)) == 0)     
    return(0);
 
  if (!(fpr = do_open_item(g,m,"r",fp_open))) {
    err_line("Error: Mailer - cannot read item");
    return(0);
    }

  if (*multiple > 0)
    fprintf(*fpw,"\n\f\n");
  (*multiple)++;
  fprintf(*fpw,"X-News: %s %s:%d\n",news_node,ga[g]->grp_name,ga[g]->grp_ia[m].itm_num);

  *id = *from = *subj = *idate = *fpad = '\0';

  header = 1;
  while (fgets(xfrbuf,510,fpr)) {
    if ((*xfrbuf == '\n') && (header)) {
      if (incl_header) fprintf(*fpw,"%s%s",fpad,xfrbuf);
      else {
        fprintf(*fpw,"%sFrom: %s\n%sSubject:%s\n%s%s",fpad,from,fpad,subj,fpad,idate);
        fprintf(*fpw,"%s%s",fpad,"Message-ID:");
        if (*id) fprintf(*fpw,"%s\n\n",id);
        else fprintf(*fpw,"<%s %s:%d>\n\n",news_node,ga[g]->grp_name,ga[g]->grp_ia[m].itm_num);
        }
      header = 0;
      continue;
      }
    else if (header) {
      if (!strncmp(xfrbuf,"From:",5)) {
        strcpy(from,&xfrbuf[6]);
	chop_str(from,'\n');
        }
      else if (!strncmp(xfrbuf,"Message-ID:",11)) {
        strcpy(id,&xfrbuf[12]);
	chop_str(id,'\n');
        }
      else if (!strncmp(xfrbuf,"Subject:",8)) {
        strcpy(subj,&xfrbuf[9]);
	chop_str(subj,'\n');
        }
      else if (!strncmp(xfrbuf,"Date:",5)) {
        strcpy(idate,xfrbuf);
        }
      }
    if ((!header) || ((incl_header) && (header))) {
      if ((*xfrbuf == '>') && *fpad) fprintf(*fpw,">%s",xfrbuf);
      else fprintf(*fpw,"%s%s",fpad,xfrbuf);
      }
    }
  fclose(fpr);
  if (*fp_open > 1) delete_file_versions(fp_open);
  *fp_open = '\0';
  if ( (fpr = profile_sigfile(0)) != 0 ) {
    fputs("-- \n",*fpw);
    fputs("Forwarded-By:\n",*fpw);
    while (fgets(xfrbuf,512,fpr)) fputs(xfrbuf,*fpw);
    fclose(fpr);
    }
  return(0);
}

/*
 *  do_forward
 *
 *  Forward a mail item via VMS MAIL
 */

static int
dfwd()
{
  int status;
  int di, fi, li, i, multiple = 0;
  char xfrbuf[512], subj[256], ngroup[132], subjline[132];
  FILE *fpw;
  unsigned short ngroup_len;
  $DESCRIPTOR(ngroup_dsc,ngroup);
  struct stat sbuffer;

	/* Next line stops MAIL/FORW/REPLY commands working for NEWS/CAPTIVE */
  if (news_captive) return(0);

  if (!getnoterange()) { 
    err_line("Error: Mailer - No items located to mail");
    return(0);
    }

  if (!(fpw = fopen(Mail_file,"w","rat=cr","rfm=var"))) {
    err_line("Error: Mailer - cannot open tmp output file");
    return(0);
    }

  for (di = 0; (li = d_itm[di].litm), (fi = d_itm[di].fitm); ++di) {
    if ((fi > 0) && !li) 
      forward_additm(d_itm[di].ngrp, fi, &fpw, 
                   (cli$present(c$dsc("HEADERS")) & 1), &multiple, subj);
    else if (fi < 0) {
      for (i = 1; i <= ga[d_itm[di].ngrp]->grp_count; ++i)
        forward_additm(d_itm[di].ngrp, ga[d_itm[di].ngrp]->grp_ia[i].itm_num, 
              &fpw, (cli$present(c$dsc("HEADERS")) & 1), &multiple, subj);
      }
    else {
      for (i = fi; i <= li; ++i)
        forward_additm(d_itm[di].ngrp, i, &fpw, 
                     (cli$present(c$dsc("HEADERS")) & 1), &multiple, subj);
    }
  }

  fclose(fpw);

  set_mail_self_flag(1);

  *xfrbuf = '\0';
  if (cli$get_value(c$dsc("TO"),&ngroup_dsc,&ngroup_len) & 1) {
    do {
      ngroup[ngroup_len] = '\0';
      sprintf(&xfrbuf[strlen(xfrbuf)],"%s,",add_transform(ngroup));
      } while (cli$get_value(c$dsc("TO"),&ngroup_dsc,&ngroup_len) & 1);
    }
  else {
    char *comma_pointer, *address_field;

    status = get_input(&ngroup_dsc,c$dsc("To: "),&ngroup_len);
    if ((status == RMS$_EOF) || (status == SMG$_EOF)) {
      delete_file_versions(Mail_file);
      mail_self_flag = 0;
      return(0);
      }
    ngroup[ngroup_len] = '\0';
    address_field = ngroup;
    do {
      comma_pointer = chop_str_plus(address_field,',');
      sprintf(&xfrbuf[strlen(xfrbuf)],"%s,",add_transform(address_field));
      address_field = comma_pointer;
      } while (address_field);
    }
  xfrbuf[strlen(xfrbuf) - 1] = '\0';

  if (cli$get_value(c$dsc("SUBJECT"),&ngroup_dsc,&ngroup_len)
      == CLI$_ABSENT) {
    if (multiple > 1)
      subjline[0] = '\0';
    else
      strcpy(subjline,subj);
    status = get_input_dflt(&ngroup_dsc,c$dsc("Subject: "),&ngroup_len,c$dsc(subjline),0);
    if ((status == RMS$_EOF) || (status == SMG$_EOF)) {
      delete_file_versions(Mail_file);
      return(0);
      }
    }
  ngroup[ngroup_len] = '\0';
  strcpy(subj,ngroup);

  if (cli$present(c$dsc("EDIT")) & 1) {
    if ((status = call_edit(Mail_file)) == 2) {
      mail_self_flag = 0;
      return(0);
      }
    sprintf(err_oline,"Mail <%s>? [y]:",xfrbuf);
    status = get_input(&cmd_dsc,c$dscl(&err_oline_d),&cmd_len);
    if ((status == RMS$_EOF) || (status == SMG$_EOF)) {
      delete_file_versions(Mail_file);
      mail_self_flag = 0;
      return(0);
      }
    if (!((status & 1) && ((!cmd_len) || ((cmd_len) && (toupper(*cmd) == 'Y'))))) {
      delete_file_versions(Mail_file);
      mail_self_flag = 0;
      return(0);
      }
    }
  if (stat(Mail_file,&sbuffer)) {
    err_line("Error: Mail - extracted file not found");
    mail_self_flag = 0;
    return(0);
    }
  if (!sbuffer.st_size) {
    err_line("Error: Mail - extracted file is empty");
    delete_file_versions(Mail_file);
    mail_self_flag = 0;
    return(0);
    }
  call_mail(Mail_file,subj,xfrbuf,"Invoking mailer...");
  mail_self_flag = 0;
  delete_file_versions(Mail_file);
  return(0);
}

int do_forward()
{
  return(unwind_display(I_DISPLAY_LOOP,dfwd));
}

/*
 *  do_reply
 *
 *  Post a mail reply to the news originator
 */

static int drply()
{
  int i;
  unsigned short item_len;
  char item[128];
  $DESCRIPTOR(item_dsc,item);

  if (cli$get_value(c$dsc("NEWSITEM"),&item_dsc,&item_len) != CLI$_ABSENT) {
    item[item_len] = '\0';
    if (!(i = item_find(item))) return(0);
    cur_set_itm(curr_g,i);
    }

  if (curr_i <= 0) {
    err_line("Error: Reply - No item specified");
    return(0);
    }
/*
  if (cli$present(c$dsc("FOLLOWUP")) == CLI$_PRESENT) return(do_followup());
*/
  do_mail(0,(cli$present(c$dsc("HEADERS")) == CLI$_PRESENT));
  return(0);
}

int do_reply()
{
  if (!curr_g) {
    err_line("Error: Reply - No item specified");
    return(0);
    }

  return(unwind_display(I_DISPLAY_LOOP,drply));
}

static int dsnd()
{
  int status;
  int author, extract_sw, incl_header = 0, reply_to = 0,
      header, addressees, members;
  unsigned short ngroup_len, infile_len;
  char ngroup[132], infile[256], id[256], from[256], idate[256], subj[256],
       subjline[132], xfrbuf[512], address[512], fpad[6],
       *cp, *sa;
  FILE *fpr, *fpw = 0;
  struct stat sbuffer;
  $DESCRIPTOR(ngroup_dsc,ngroup);
  $DESCRIPTOR(infile_dsc,infile);

	/* Next line stops SEND command working for NEWS/CAPTIVE */
  if (news_captive) return(0);

  *subj = *address = '\0';
  if (!(fpw = fopen(Mail_file,"w","rat=cr","rfm=var"))) {
    err_line("Error: Send - cannot open tmp output file");
    return(0);
    }

  author = (cli$present(c$dsc("AUTHOR")) & 1);
  if ((extract_sw = (cli$present(c$dsc("EXTRACT")) & 1)) != 0) {
    incl_header = (cli$present(c$dsc("HEADERS")) & 1);
    if (cli$present(c$dsc("QUOTE")) == CLI$_NEGATED) *fpad = '\0';
    else {
      strcpy(fpad,"> ");
      if (cli$get_value(c$dsc("QUOTE"),&ngroup_dsc,&ngroup_len) & 1) {
        if (ngroup_len > 5) ngroup_len = 5;
        ngroup[ngroup_len] = '\0';
        strcpy(fpad,ngroup);
        }
      }
    }
  if (author || extract_sw) {
    if ((!curr_g) || (curr_i <= 0))
      return(err_line("Error: Send - No current item"),0);
    if (!(fpr = do_open_item(curr_g,curr_i,"r",fp_open)))
      return(err_line("Error: Send - cannot read current news item"),0);
    if (extract_sw)
      fprintf(fpw,"X-VMS-News: %s %s:%d\n",news_node,
              ga[curr_g]->grp_name,ga[curr_g]->grp_ia[curr_i].itm_num);
    *id = *from = *subj = *idate = '\0';
    header = 1;

    while (fgets(xfrbuf,510,fpr)) {
      if ((*xfrbuf == '\n') && (header)) {
        if (extract_sw) {
          if (incl_header) fprintf(fpw,"%s%s",fpad,xfrbuf);
          else {
            fprintf(fpw,"%sFrom: %s\n%sSubject:%s\n%s%s",fpad,from,fpad,subj,fpad,idate);
            fprintf(fpw,"%s%s",fpad,"Message-ID:");
            if (*id) fprintf(fpw,"%s\n\n",id);
            else fprintf(fpw,"<%s %s:%d>\n\n", news_node,ga[curr_g]->grp_name,ga[curr_g]->grp_ia[curr_i].itm_num);
            }
          }
        header = 0;
        continue;
        }
      else if (header) {
        if (!strncmp(xfrbuf,"From:",5)) {
          strcpy(from,&xfrbuf[6]);
	  chop_str(from,'\n');
          if (!reply_to) {
            cp = &xfrbuf[5];
	    if ((sa = strchr(cp,'<')) != 0) {
              strcpy(address,++sa);
	      chop_str(address,'>');
	      chop_str(address,'\n');
              }
            else {
              while (isspace(*cp)) cp++;
              strcpy(address,cp);
              cp = address;			  /* glass@mgi.com V6.0-1 */
              while (*cp && !isspace(*cp)) cp++;  /*    "		  */
              *cp = '\0';                         /*    "		  */
	      chop_str(address,'(');
              }
            }
          }
        else if (!strncmp(xfrbuf,"Reply-To:",9)) {
          reply_to = 1;
          cp = &xfrbuf[9];
	  if ((sa = strchr(cp,'<')) != 0) {
            strcpy(address,++sa);
	    chop_str(address,'>');
	    chop_str(address,'\n');
            }
          else {
            while (isspace(*cp)) cp++;
            strcpy(address,cp);
            cp = address;			  /* glass@mgi.com V6.0-1 */
            while (*cp && !isspace(*cp)) cp++;    /*    "		  */
            *cp = '\0';                           /*    "		  */
	    chop_str(address,'(');
            }
          }
        else if (!strncmp(xfrbuf,"Message-ID:",11)) {
          strcpy(id,&xfrbuf[12]);
	  chop_str(id,'\n');
          }
        else if (!strncmp(xfrbuf,"Subject:",8)) {
          strcpy(subj,&xfrbuf[9]);
	  chop_str(subj,'\n');
          }
        else if (!strncmp(xfrbuf,"Date:",5)) strcpy(idate,xfrbuf);
        }
      if ((!header) || ((incl_header) && (header))) {
        if (extract_sw) fprintf(fpw,"%s%s",fpad,xfrbuf);
        }
      }
    fclose(fpr);
    if (*fp_open > 1) delete_file_versions(fp_open);
    *fp_open = '\0';
    }

  if (cli$get_value(c$dsc("INFILE"),&infile_dsc,&infile_len) == CLI$_ABSENT) *infile = '\0';
  else infile[infile_len] = '\0';
  if (*infile) {
    if ((fpr = fopen(infile,"r")) != 0) {
      while (fgets(xfrbuf,512,fpr)) fputs(xfrbuf,fpw);
      fclose(fpr);
      }
    else {
      sprintf(err_oline,"Error: Send - Cannot open send file %s",infile);
      err_line(err_oline);
      fclose(fpw);
      delete_file_versions(Mail_file);
      return(0);
      }
    }
  else if ((!(cli$present(c$dsc("EDIT")) & 1)) && !extract_sw) {
    err_line("Send - No file to send");
    fclose(fpw);
    delete_file_versions(Mail_file);
    return(0);
    }

  if ( (fpr = profile_sigfile(0)) != 0) {
    fputs("-- \n",fpw);
    while (fgets(xfrbuf,512,fpr)) fputs(xfrbuf,fpw);
    fclose(fpr);
    }
  fclose(fpw);      

  if (author && !*address) {
    err_line("Send/Author - No author field located in item");
    delete_file_versions(Mail_file);
    return(0);
    }

  mail_self_flag = 0;
  members = (cli$present(c$dsc("MEMBERS")) & 1);
  if (!members) set_mail_self_flag(2);

  *xfrbuf = '\0';
  addressees = 0;        
  if (cli$get_value(c$dsc("TO"),&ngroup_dsc,&ngroup_len) & 1) {
    if (author) {
      sprintf(&xfrbuf[strlen(xfrbuf)],"%s,",add_transform(address));
      ++addressees;
      }
    do {
      ngroup[ngroup_len] = '\0';
      sprintf(&xfrbuf[strlen(xfrbuf)],"%s,",add_transform(ngroup));
      ++addressees;
      } while (cli$get_value(c$dsc("TO"),&ngroup_dsc,&ngroup_len) & 1);
    }
  else {
    char *comma_pointer, *address_field;
                    
    if (author) status = get_input_dflt(&ngroup_dsc,c$dsc("To: "),&ngroup_len,c$dsc(address),0);
    else status = get_input(&ngroup_dsc,c$dsc("To: "),&ngroup_len);
    if ((status == RMS$_EOF) || (status == SMG$_EOF)) {
      err_line("Send - Cancelled");
      delete_file_versions(Mail_file);
      mail_self_flag = 0;
      return(0);
      }
    if (ngroup_len) {
      ngroup[ngroup_len] = '\0';
      address_field = ngroup;
      do {
	comma_pointer = chop_str_plus(address_field,',');
        sprintf(&xfrbuf[strlen(xfrbuf)],"%s,",add_transform(address_field));
        ++addressees;
        address_field = comma_pointer;
        } while (address_field);
      }
    }

  if (!addressees && !(cli$present(c$dsc("MEMBERS")) & 1)) {
    err_line("Send - Cancelled: No address specified");
    delete_file_versions(Mail_file);
    mail_self_flag = 0;
    return(0);
    }

  if (addressees) xfrbuf[strlen(xfrbuf) - 1] = '\0';

  if (cli$get_value(c$dsc("SUBJECT"),&ngroup_dsc,&ngroup_len) == CLI$_ABSENT) {
    if ((!*subj) && (curr_g > 0) && ga[curr_g]->grp_ia) strcpy(subjline,ga[curr_g]->grp_ia[curr_i].itm_title);
    else strcpy(subjline,subj);
    status = get_input_dflt(&ngroup_dsc,c$dsc("MAIL/SUBJECT="),&ngroup_len,
      c$dsc(subjline),0);
    if ((status == RMS$_EOF) || (status == SMG$_EOF)) {
      err_line("Send - Cancelled");
      delete_file_versions(Mail_file);
      mail_self_flag = 0;
      return(0);
      }
    }
  ngroup[ngroup_len] = '\0';
  members = (cli$present(c$dsc("MEMBERS")) & 1);

  if (cli$present(c$dsc("EDIT")) & 1) {
    if ((status = call_edit(Mail_file)) == 2) {
      err_line("Send - Cancelled");
      delete_file_versions(Mail_file);
      mail_self_flag = 0;
      return(0);
      }
    if (addressees) sprintf(err_oline,"Mail <%s>? [y]:",xfrbuf);
    else if (members && curr_g > 0)
      sprintf(err_oline,"Mail <members:%s>? [y]:",ga[curr_g]->grp_name);
    else strcpy(err_oline,"Mail item? [y]:");
    status = get_input(&cmd_dsc,c$dsc("Mail item? [y]:"),&cmd_len);
    if ((status == RMS$_EOF) || (status == SMG$_EOF)) {
      err_line("Send - Cancelled");
      delete_file_versions(Mail_file);
      mail_self_flag = 0;
      return(0);
      }
    if (!((status & 1) && ((!cmd_len) || ((cmd_len) && (toupper(*cmd) == 'Y'))))) {
      err_line("Send - Cancelled");
      delete_file_versions(Mail_file);
      mail_self_flag = 0;
      return(0);
      }
    }

  if (stat(Mail_file,&sbuffer)) {
    err_line("Error: Mail - extracted file not found");
    mail_self_flag = 0;
    return(0);
    }
  if (!sbuffer.st_size) {
    err_line("Error: Mail - extracted file is empty");
    delete_file_versions(Mail_file);
    mail_self_flag = 0;
    return(0);
    }

  if (addressees) {
    call_mail(Mail_file,ngroup,xfrbuf,"Invoking mailer...");
    mail_self_flag = 0;
    }

  *err_oline = '\0';
  if (members) {
    FILE *fpd;

    if (curr_g < 1) 
      strcpy(err_oline,"Send/Members: No current newsgroup selected");
    else {
      sprintf(itm_fname,Access_template,util_dir(ga[curr_g]->grp_name));
      sysprv();
      if ((fpd = fopen(itm_fname,"r")) != 0) {
	char acline[256], *ma;

        while (fgets(acline,256,fpd)) {
          if (*acline == '#') continue;
	  chop_str(acline,'\n');
          lower_case(acline);
	  if (!(ma = chop_str_plus(acline,':'))) ma = acline;
	  chop_str(ma,' ');
          if (!empty_string(ma)) {
            strcpy(xfrbuf,add_transform(ma));
            call_mail(Mail_file,ngroup,xfrbuf,"Invoking mailer...");
            mail_self_flag = 0;
            }
          }
        fclose(fpd);
        }
      else 
        strcpy(err_oline,"Send/Members: No membership list for newsgroup");
      nosysprv();
      }
    }
  delete_file_versions(Mail_file);
  if (*err_oline) err_line(err_oline);
  mail_self_flag = 0;
  return(0);
}

int do_send()
{
  return(unwind_display(I_DISPLAY_LOOP,dsnd));
}

void set_mail_self_flag(cmd)
int cmd;	/* 0 = reply, 1 = forward, 2 = send */
{
  int context = 0,
      profile_flag, sts;
  struct mai_itmlst
      sm[2] = {{sizeof(profile_flag),0,(void *)&profile_flag,0}, {0,0,0,0}},
      no_in_list[1] = {{0,0,0,0}},
      no_out_list[1] = {{0,0,0,0}};

  switch (cmd)
    {
    case 0: sm[0].ic = MAIL$_USER_COPY_REPLY; break;
    case 1: sm[0].ic = MAIL$_USER_COPY_FORWARD; break;
    case 2: sm[0].ic = MAIL$_USER_COPY_SEND; break;
    };
  sysprv();
  if ((sts = mail$user_begin(&context,no_in_list,no_out_list)) & 1) {
    sts = mail$user_get_info(&context,no_in_list,sm);
    }
  mail$user_end(&context,no_in_list,no_out_list);
  nosysprv();
  mail_self_flag = profile_flag;
  if (cli$present(c$dsc("SELF")) == CLI$_PRESENT)
    mail_self_flag = 1;
  else
    if (cli$present(c$dsc("SELF")) == CLI$_NEGATED)
      mail_self_flag = 0;
}
