/*
**++
**  FACILITY:
**      NEWSINCLUDE
**
**  ABSTRACT:
**      Common NEWS include modules
**
**  AUTHOR:
**      Geoff Huston
**
**  COPYRIGHT:
**      Copyright  1988,1989,1990
**
**  MODIFICATION HISTORY:
**	V6.1b9	17-Sep-1994     Mark Martinec   mark.martinec@ijs.si
**	  - rearanged #includes and #ifs to handle better different
**	    compilers and different TCP/IP transport sw products
**	    (vaxc, decc, gcc 2.6.0)
**	V6.1b9	21-Sep-1994     Mark Martinec   mark.martinec@ijs.si
**	  - introduce macro NAKED_INCLUDES
**--
**/

#ifndef _NEWSINCLUDE_H
#define _NEWSINCLUDE_H

#ifndef NAKED_INCLUDES
/* Set NAKED_INCLUDES to 1 if it is desired to use the
 * nonstandard vaxc feature of including modules from text library.
 * Normally (value 0) includes are from <*.h> files.
 * Value 0 is ok for DECC as well, even if modules actually come
 * from text library. */
#if defined(vaxc) && !defined(__DECC)
#define NAKED_INCLUDES 0 /* set this to 1 only if *.h files are not available */
#else
#define NAKED_INCLUDES 0
#endif
#endif


#ifdef __GNUC__
/* ANSI does not recognize 'variant' unions, neither does it allow to use
 * unions for typecasting in the style of fortran EQUIVALENCE statements.
 * By using the 'volatile' attribute we disable optimizations
 * and with some luck this may work - but is still illegal !
 *    mark.martinec@ijs.si
 */
#define variant_union	volatile union
#define variant_struct	volatile struct
#endif

                                /* VMS INCLUDE MODULES */
#if NAKED_INCLUDES

#include starlet
#include clidef
#include climsgdef
#include descrip
#include dcdef
#include dvidef
#include jpidef
#include prvdef
#include rms
#include chfdef
#include syidef
#include lnmdef
#include smgdef
#include smgmsg
#include smg$routines	 /* optional; delete if old compiler doesn't have it */
/*#include lib$routines    prefer more accurate declarations in newsextern.h */
#include ssdef

#if defined(MULTINET) || defined(TCPWARE)
#include <types.h>
#ifdef __DECC
#include <sys/types.h>
#endif
#else
#include types
#endif

#include stddef
#include stdio
#include stdlib
#include string
#include ctype
#include setjmp
#include time
#include errno
#include stat
#include signal
#include unixio
#include unixlib

#else	/*!NAKED_INCLUDES*/

#include <starlet.h>
#include <clidef.h>
#include <climsgdef.h>
#include <descrip.h>
#include <dcdef.h>
#include <dvidef.h>
#include <jpidef.h>
#include <prvdef.h>
#include <rms.h>
#if defined(__GNUC__) && !defined(xab$w_pos)
# define xab$w_pos0 xab$w_pos[0]
# define xab$b_siz0 xab$b_siz[0]
# define xab$w_pos1 xab$w_pos[1]
# define xab$b_siz1 xab$b_siz[1]
#endif
#include <chfdef.h>
#include <syidef.h>
#include <lnmdef.h>
#include <smgdef.h>
#include <smgmsg.h>
#include <smg$routines.h>   /* optional; delete if missing */
/*#include <lib$routines.h> prefer more accurate declarations in newsextern.h */
#include <ssdef.h>

#if defined(__GNUC__)
  /*  problem is that both multinet and gnu_cc_include contain sys/types.h    *
   *  and the multinet version is missing some declarations (dev_t,off_t,...) *
   *  which are necessary when stat.h gets included, so we force GNU types.h  */
#  include <gnu_cc_include:[sys]types.h>
#elif defined(MULTINET) || defined(TCPWARE)
#  include <sys/types.h>    /* take the Multinet (or other IP vendor) types.h */
#elif defined(TWG)
   /* use TWG's types.h, but tell it not to define the types which show up
    * in VAXC's stat.h */
#  define __STAT
#  include <twg$tcp:[netdist.include.sys]types.h>
#else
#  include <types.h>        /* take whatever we have */
#endif

#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <setjmp.h>
#include <time.h>
#include <errno.h>
#include <stat.h>
#include <signal.h>
#include <unixio.h>
#include <unixlib.h>

#endif	/*?NAKED_INCLUDES*/

#ifdef __GNUC__
#include <gnu_hacks.h>
#endif


/* We expect tolower() to be the version that returns its argument if it is
 * not uppercase.  This version is usually a library routine, while the other
 * version is usually a macro.  Tim Cook 6 Apr 1990
 *
 * The ctype.h that comes with gcc v2 defines toupper as ((c)-'a'+'A'),
 * which is wrong.  mark.martinec@ijs.si, 16 Aug 1994
 */

#ifdef	tolower
#undef	tolower
#endif
#ifdef	toupper
#undef	toupper
#endif


/* vaxc declares TRUE and FALSE in stdio.h, others probably don't */
#ifndef TRUE
#define TRUE	(1)
#define FALSE	(0)
#endif

#endif	/* _NEWSINCLUDE_H */
