$! newsmsg.com -- construct source file newsmsg.h from newsmsg.msg
$ v = 'f$verify(0)'
$!
$! Version:
$!      V6.1B9  25-May-1994	Pat Rankin, rankin@eql.caltech.edu
$!	- initial version
$!      V6.1B10 26-Oct-1994	Pat Rankin, rankin@eql.caltech.edu
$!	- turn off DCL verification by default, and add 'newsmsg_debug'
$!	  to control reenabling it during execution
$
$! Use LINK/MAP to get the global values from the newsmsg module
$! because MESSAGE/LIST is inadequate for the task.
$
$ if f$type(newsmsg_debug).eqs."" then -
	newsmsg_debug = f$trnlnm("NEWSMSG_DEBUG")
$ if newsmsg_debug then  set verify
$ set symbol/Scope=(noLocal,noGlobal)
$
$ if f$trnlnm("MSG_FILE") then  close/noLog msg_file
$ if f$trnlnm("DEF_FILE") then  close/noLog def_file
$
$! build a symbol table, then have the linker format it for us
$ message /noList newsmsg.msg /Object=newsmsg.stb /Symbols/noText
$       define/user sys$output _NL:
$       define/user sys$error  _NL:     !hide "no transfer address" warning
$ link /noExe newsmsg.stb /Map=newsmsg.map
$
$! trim down the linker map so only interesting lines remain
$ search newsmsg.map "NEWS$_","NNTP$_"/Exact/Match=OR /Output=newsmsg.dat
$ open/Read msg_file newsmsg.dat
$
$! construct newsmsg.h; using CREATE results in "normal" text file attributes
$ create newsmsg.h
/* newsmsg.h -- generated by newsmsg.com -- do not edit */

$ open/Append def_file newsmsg.h
$ format = "#define !AS!_0x!XL"         !<macro_name><tab><hexadecimal_value>
$
$! process each line of the linker supplied data
$! (up to three columns of name & value pairs)
$loop:
$  read/end=done msg_file msg_line
$  msg_line = f$edit(msg_line,"COMPRESS,TRIM")
$!
$  symbol = f$element(0," ",msg_line)
$  prefix = f$extract(0,6,symbol)
$  value  = "%x" + f$element(1," ",msg_line)
$  if (prefix.eqs."NEWS$_" .or. prefix.eqs."NNTP$_") -
     .and. f$type(value).eqs."INTEGER" then -
	write def_file f$fao(format,symbol,f$integer(value))
$!
$  symbol = f$element(2," ",msg_line)
$  prefix = f$extract(0,6,symbol)
$  value  = "%x" + f$element(3," ",msg_line)
$  if (prefix.eqs."NEWS$_" .or. prefix.eqs."NNTP$_") -
     .and. f$type(value).eqs."INTEGER" then -
	write def_file f$fao(format,symbol,f$integer(value))
$!
$  symbol = f$element(4," ",msg_line)
$  prefix = f$extract(0,6,symbol)
$  value  = "%x" + f$element(5," ",msg_line)
$  if (prefix.eqs."NEWS$_" .or. prefix.eqs."NNTP$_") -
     .and. f$type(value).eqs."INTEGER" then -
	write def_file f$fao(format,symbol,f$integer(value))
$!
$  goto loop
$done:
$
$ write def_file ""
$ write def_file "/* end of newsmsg.h */
$ close def_file
$
$ close msg_file
$ delete/noConfirm newsmsg.dat;*,newsmsg.map;*,newsmsg.stb;*
$
$ exit 1 + 0*f$verify(v)
