/* NEWSSHUTDOWN.C.
   This program tries to obtain an exclusive mode lock which causes
   blocking ASTs to be delivered to the other programs that have called
   init_lock();
   The program needs to be run with SYSLCK privilege
**
**  MODIFICATION HISTORY:
**	V6.1b9	17-Aug-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to make it compile under gcc 2.6.0 with full
**	    warnings reporting turned on - with no or very few harmless warnings
**	V6.1b9	17-Sep-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to preserve the read-only nature of string literals
**	    (strategically placed 'const' attribute to string parameters)
**--
*/

#ifdef vaxc
#module NEWSSHUTDOWN "V6.1"
#endif

#define _NEWSSHUTDOWN_C
#define _NNTPINCLUDE_H

#include "newsinclude.h"
#include "newsextern.h"

#if NOGLOBALREF
void newscmd() {}
#else
globaldef int newscmd;
#endif

int main(argc, argv)
  int argc;
  char **argv;
{
    int status;
    $DESCRIPTOR_CONST(table, "LNM$FILE_DEV");
    $DESCRIPTOR_CONST(lognam, "NEWS_LOCKED_COMMAND");
    $DESCRIPTOR_CONST(waitnam, "NEWS_LOCKED_WAIT_MINUTES");
    $DESCRIPTOR_CONST(prcnam, "NEWS_LOCKED");
    const char trans[LNM$C_NAMLENGTH+1];
    $DESCRIPTOR_CONST(command, trans);
    char wait_str[LNM$C_NAMLENGTH+1];
    $DESCRIPTOR(wait_dsc, wait_str);
    int wait_minutes = 1;
    struct itm3 { unsigned short len, code; void *buf; unsigned short *retlen; }
	trnlist[] = { {(sizeof trans)-1, LNM$_STRING,
                       (void*)trans, &(command.dsc$w_length)},
                      {0,0,0,0} };
    struct itm3 
	trnlist1[] = { {(sizeof wait_str)-1, LNM$_STRING,
                        (void*)wait_str, &(wait_dsc.dsc$w_length)},
                       {0,0,0,0} };
    if (!(1 & sys$trnlnm(0,&table,&lognam,0,trnlist) ))
	{
	fprintf(stderr, "No Command Specified via logical NEWS_LOCKED_COMMAND\n");
	exit(0);
	}
    if ((1 & sys$trnlnm(0,&table,&waitnam,0,trnlist1) ))
	{
	wait_str[wait_dsc.dsc$w_length] = '\0';
	if (0 < atoi(wait_str))
	    wait_minutes = atoi(wait_str);
	}
    if (!((status = acquire_exclusive_lock(60*wait_minutes)) & 1))
	exit(status);
    /* 
     * We've got the lock now (exclusively), so everyone else 
     * has already shutdown, now we can go do what ever needed exclusive 
     * access to things.
     */
    lib$spawn(&command, 0, 0, 0, &prcnam, 0, &status, 0,0,0,0,0);
    exit(status);
}
#if defined(__DECC)
/*
 * All these symbols show up as undefined on DECC (both on AXP and VAX)
 * when building nntp stuff.  They are never actually used, as far as I know,
 * so this kludge gets rid of the error messages.
 */
int 	all_loaded ;
int 	auto_cre_grp ;
int 	brdcst_col ;
int 	brdcst_line ;
int 	broadcast_trapping_requested ;
int 	closing_files ;
int 	cmd ;
int 	cmd_dsc ;
int 	cmd_len ;
int 	confirm_specified ;
int 	on_error ;
int 	curr_class ;
int 	curr_g ;
int 	curr_i ;
int 	cur_dir_type ;
int 	c_head ;
int 	devcol ;
int 	devrow ;
int 	display_stk ;
int 	display_unseen_items ;
int 	display_unseen_stack ;
int 	d_itm ;
int 	editor ;
int 	env ;
int 	envdisp ;
int 	err_oline ;
int 	err_oline_d ;
int 	extract_file ;
int 	fast_loading ;
int 	first_retr_call ;
int 	first_time_user ;
int 	forward_posting ;
int 	fp ;
int 	fpa ;
int 	fpa_open ;
int 	fpd ;
int 	fpd_open ;
int 	fp_open ;
int 	ga ;
int 	ga_malloc ;
int 	ga_size ;
int 	gmt_offset ;
int 	grpfab ;
int 	grprab ;
int 	grp_display_size ;
int 	grp_header_vd ;
int 	grp_paste ;
int 	grp_vd ;
int 	gv_size ;
int 	g_arrow ;
int 	include_all_groups ;
int 	initial_classname ;
int 	init_scanning ;
int 	itmfab ;
int 	itmptr ;
int 	itmrab ;
int 	itm_approved ;
int 	itm_fname ;
int 	itm_header_vd ;
int 	keytab ;
int 	kid ;
int 	line_editing ;
int 	mailfile_open ;
int 	mail_add_expiry ;
int 	mail_editor ;
int 	mail_file ;
int 	mail_flags ;
int 	mail_form ;
int 	mail_queue ;
int 	mail_self_flag ;
int 	mail_sig ;
int 	mem_reserve ;
int 	minfromlen ;
int 	mk_head ;
int 	m_head ;
int 	net_news ;
int 	newsgrp ;
int 	newsitm ;
int 	newsmgr_dir ;
int 	newsrc ;
int 	news_captive ;
int 	news_context ;
int 	news_lock_alarm ;
int 	news_node ;
int 	news_pathname ;
int 	news_readonly ;
int 	news_register ;
int 	news_timezone ;
int 	nntp_anu_news_server ;
int 	nntp_client ;
int 	nntp_node ;
int 	nntp_no_posting_allowed ;
int 	nntp_proto ;
int 	node_address ;
int 	no_more_news ;
int 	no_new_item ;
int 	n_class_name ;
int 	old_context ;
int 	organisation_name ;
int 	parse_level ;
int 	pid ;
int 	pid_created ;
int 	post_file ;
int 	print_constant ;
int 	print_file ;
int 	print_save_file ;
int 	problems_encountered ;
int 	profile_dirstr ;
int 	profile_display_lines ;
int 	profile_display_postmark ;
int 	profile_endofitm_cmd ;
int 	profile_filter ;
int 	profile_reply_to ;
int 	profile_scansize ;
int 	reorder_groups ;
int 	scangroups ;
int 	server_call ;
int 	session_is_interactive ;
int 	showdirs_val ;
int 	smg_active ;
int 	status ;
int 	str_target ;
int 	sysprv_off ;
int 	textptr ;
int 	tpuedit ;
int 	tpuview ;
int 	trailer_vd ;
int 	usr_inp ;
int 	usr_inp_dsc ;
int 	usr_inp_l ;
int 	usr_persname ;
int 	usr_username ;
int 	v59_file ;
int 	verbose ;
int 	viewer ;
int 	vms_major ;
int 	vms_minor ;
int 	vms_vers ;
int 	xref_enabled ;
int	try_to_quietly_handle_errors ;
int	usedotnewsrc ;
int	signalled_error_count ;
int	stat_make_space_called ;
int	stat_make_space_succeeded ;
int	stat_make_space_retry_success ;
#endif
