/*
**++
**  FACILITY:
**      NEWSSITE.H
**
**  ABSTRACT:
**      Site tailorable NEWS constant definitions.
**
**  AUTHOR:
**      Geoff Huston
**
**  COPYRIGHT:
**      Copyright  1988,1989,1990,1991,1992
**--
**/
#ifndef _NEWSSITE_H
#define _NEWSSITE_H

#define NEWS_VERSION    "ANU News - V6.1B10"
#define NEWS_VDATE      "18-Apr-1995"
#define NEWS_DDATE      "04/18/95"

/* VMSV4, VMSV5 are used in compilation to determine if NEWS is to be linked
 * and executed on a VMS V4 or V5 system. If neither are defined then the
 * compiled code may be linked and executed on either system (but will give
 * link errors on a V4 system because of static links to the V5 callable
 * mail interface
 */

#undef VMSV4
#define VMSV5	1

/*
 *  EXP_TIME
 *  News item lifetime (in days): global default.
 *
 *  GRP_TIME
 *  Newsgroup lifetime (in days): global default.
 */

#ifndef EXP_TIME
#define EXP_TIME        14
#endif
#ifndef GRP_TIME
#define GRP_TIME        60
#endif

/*
 *  NEWSBATCH
 *  This is the template used by the NNTP server to create file
 *  names for incoming batches.
 */

#ifndef NEWSBATCH
#define NEWSBATCH    "NEWS_MANAGER:NNTP_%s_%X.%sBATCH"          /* file names */
#endif

/*
 *  NEWS_BATCH_SIZE
 *  This is the default maximum size of news batch files (in bytes -
 *  not blocks).  This value may be overridden via the logical name
 *  NEWS_NNTP_SERVER_BATCH_SIZE.
 *  NEWS_BATCH_SIZE_LOWLIM
 *  This is the lowest value that can be used as a maximum batch file size,
 *  regardless of the value specified by the NEWS_NNTP_SERVER_BATCH_SIZE
 *  logical name.  It is also the maximum batch file size used when spooling
 *  single postings.
 *  NEWS_BATCH_SIZE_HIGHLIM
 *  This is the highest value that can be used as a maximum batch file size,
 *  regardless of the value specified by the News_NNTP_Server_Batch_Size
 *  logical name.
 */

#ifndef NEWS_BATCH_SIZE
#define NEWS_BATCH_SIZE (500*512)
#endif
#ifndef NEWS_BATCH_SIZE_LOWLIM
#define NEWS_BATCH_SIZE_LOWLIM (10*512)
#endif
#ifndef NEWS_BATCH_SIZE_HIGHLIM
#define NEWS_BATCH_SIZE_HIGHLIM (10000*512)
#endif

/*
 *  NEWS_NNTP_BATCH_SIZE
 *  This is the maximum size of news message-ID spool files for
 *  downstream NNTP sites (in articles, not bytes). Zero is unlimited.
 */

#ifndef NEWS_NNTP_BATCH_SIZE
#define NEWS_NNTP_BATCH_SIZE 0
#endif

/*
 *  RECHECK_TIMER
 *  The configuration files are periodically re-checked to ensure that any edit
 *  changes made to the files are read into all active NEWS sessions. The timer
 *  determines the frequency of the check of the modification date of these
 *  files. Units are seconds.
 */

#ifndef RECHECK_TIMER
#define RECHECK_TIMER   (15 * 60)
#endif

/*
 *  DIST_PATH_CHECK
 *  If DIST_PATH_CHECK is defined as 1 then NEWS will check the Path: header of all
 *  incoming news items to see if a neighbouring node has already postmarked
 *  the item, and if so the item will not be forwarded to that node. This
 *  relies on unique node names throughout the network - if this is not the
 *  case then the Path: check can be disabled by setting this value to '0' -
 *  the drawback is a (probably marginal) increase in redundant network traffic.
 */

#ifndef SELF_PATH_CHECK
#define SELF_PATH_CHECK 0
#endif

#ifndef DIST_PATH_CHECK
#define DIST_PATH_CHECK  1
#endif

/*
 *  CANCELMAIL determines whether the USENET account will be mailed in response
 *  to an incoming "cancel" control message. The distribution version sets this
 *  variable to 0 (no auto mail generation for cancel messages).
 */

#ifndef CANCELMAIL
#define CANCELMAIL  0
#endif

/*
 *  UNKCONTROLMAIL determines whether the USENET account will be mailed in
 *  response to an incoming control message with an unrecognised keyword.
 */

#ifndef UNKCONTROLMAIL
#define UNKCONTROLMAIL  1
#endif

/*
 * JUNKNODOT filters incoming news items and removes any newsgroups from the
 * item's "Newsgroups:" header which do not contain a '.' character.  The
 * implicit assumption in USENET NEWS is that only those newsgroups local to
 * an individual node will not have a '.' - all other newsgroups will contain
 * at least one '.' character.  However there is a certain amount of abuse of
 * this and it's kind of aysilly distribution limitation mechanism - hence
 * the shipped default is 0. You may wish to set it to 1 (as per the RFC -
 * - don't accept incoming newsgroups without a '.') but there's no point
 * in adhering to a written standard if noone else does.
 *
 * Even if JUNKNODOT is set, the newsgroups 'test' and 'junk' are accepted.
 */

#ifndef JUNKNODOT
#define JUNKNODOT   0
#endif

/*
 * DISTFILE is the flag to determine the way in which the news.distribution and
 * the news.sys file are linked. Incoming news items (not local postings) are
 * searched for the Path: control header, and the leftmost entry in the path
 * string is used as the sending node. This node is looked up in the dist file
 * and the incoming mail is sent only to those nodes listed in the dist file
 * entry which have a matching sys filter. If DISTFILE is 0, then if the node
 * entry is not located in the dist file then the sysfile is used against all
 * nodes. If DISTFILE is 1 then if the node is not in the dist file, then the
 * item is NOT forwarded to any neighbouring nodes
 */

#ifndef DISTFILE
#define DISTFILE    0
#endif

/*
 * UNAPPROVED NEWS is used to define the action when the local site is fed
 * (over the news network) a posting to a moderated newsgroup which is an
 * unapproved item (no Approved: header), and where the local system manager
 * has not specified that approval is optional. The possible actions are to
 * discard the item (default action), accept the item, or mail the item to
 * the moderator. In the case of converted mailing lists into NEWS the last
 * option may lead to mail loops. Note that this does NOT refer to local
 * postings, where the posting is ALWAYS mailed to the first approval
 * moderator address.
 */

#define DISCARD		  0
#define ACCEPT		  1
#define MAIL_TO_MODERATOR 2

#ifndef UNAPPROVED_NEWS
#define UNAPPROVED_NEWS   DISCARD
#endif

/* MIN_DAYS, MAX_DAYS define the acceptable range (in days) of item retention
 * These values are used in modifying the Exipres: information in the newsitem
 * header so that the item retention time lies in the range of these two
 * values.
 * ITMLIFE_DEFAULTS if non-zero indicates that news item life times are further
 * restricted to be no greater than the default item retention period for the
 * newsgroup into which the item is placed.
 */

#ifndef MIN_DAYS
#define MIN_DAYS    4
#endif

#ifndef MAX_DAYS
#define MAX_DAYS    366
#endif

#ifndef ITMLIFE_DEFAULTS
#define ITMLIFE_DEFAULTS   0
#endif

/* DEBUG
 *
 * Used to debug ADD FILE - as the output gets verbose, this one is
 * best left at 0.
 */

#ifndef DEBUG
#define DEBUG	0
#endif

/* ADDFILE_STATISTICS_ENABLE
 *
 * Setting this macro to 1 compiles the code to collect and report statistics
 * during ADD FILE operations. Statistics is reported only when the
 * code is present and the /STATISTICS qualifier is present on the ADD FILE
 * command line.
 *
 * If ADDFILE_STATISTICS_ENABLE is zero the qualifier is silently ignored
 * and some small reduction in program size is achieved.  CPU savings
 * are negligible.
 */

#ifndef ADDFILE_STATISTICS_ENABLE
#define ADDFILE_STATISTICS_ENABLE 1
#endif

/* ADDFILE_NEWSGROUPS_SIZE_LIMIT,
 * ADDFILE_NEWSGROUPS_CROSSPOSTING_LIMIT
 *
 * These two constants limit the acceptable article "Newsgroups:" lists size
 * during the ADD FILE operation.  Articles exceeding any of the two
 * limits will be JUNKed.
 *
 * The limit value 0 implies no limit (except for the possible other
 * implementation-specific limits, like NEWSGROUPS_MAX_SIZE).
 *
 * ADDFILE_NEWSGROUPS_SIZE_LIMIT:  0, or maximum size of the newsgroups list
 *   in the "Newsgroups:" header line of an article (measured in characters
 *   counting the original string - before applying any transformations,
 *   like JUNKNODOT or aliases expansion).  Setting this limit below
 *   the default (6000 or so - see NEWSADD.C) reduces the storage required
 *   during ADD FILE operations.
 *
 * ADDFILE_NEWSGROUPS_CROSSPOSTING_LIMIT: 0, or maximum number of newsgroups
 *   in the "Newsgroups:" header line of an article (in the original string,
 *   before applying transformations).
 */

#ifndef ADDFILE_NEWSGROUPS_SIZE_LIMIT
#define ADDFILE_NEWSGROUPS_SIZE_LIMIT 0         /* zero means no limit */
#endif

#ifndef ADDFILE_NEWSGROUPS_CROSSPOSTING_LIMIT
#define ADDFILE_NEWSGROUPS_CROSSPOSTING_LIMIT 0 /* zero means no limit */
#endif

/* MAXUNK
 *
 * Array size definition used in parsing news item headers. This variable
 * refers to the maximum stored number of header lines which are not headers
 * recognised by NEWS.  100 is adequate.
*/

#ifndef MAX_UNK
#define MAX_UNK  100
#endif

/* STARTLINE

   If STARTLINE is #defined to 1 then you can use the command line of NEWS
   as the first command of an interactive session.. e.g.

     announce :== 'news select local.messages

   which will execute the command line, then continue with an interactive
   session as normal.

   If STARTLINE is set to 0 then if the command line has a command, then
   that single command will be executed and then NEWS will exit
   (This behaviour is similar to the VMS MAIL command)

   The STARTLINE code was supplied by :
		Jonathan Welch
		VAX Systems Programmer   Bitnet: JHWELCH@umaecs
		Univ. of Mass, Amherst   Internet: JHWELCH@ecs.umass.edu

*/

#ifndef STARTLINE
#define STARTLINE	1
#endif

/* NEWS_INIT

   IF NEWS_INIT if #defined to 1, then the logical name "NEWS_INIT" or the
   file "sys$login:news.init" is opened at the start of the news session,
   and the contents of the file are treated as interactive commands.

   NOTE that all interactive prompts relating to subcommands and options
   will stay as interactive prompts - so this is NOT exactly the same
   as full input redirection.

   Any command line options are executed AFTER NEWS_INIT.

*/

#ifndef NEWS_INIT
#define NEWS_INIT	1
#endif

/* FULL_DIRECTORY_ACCESS_CHECK
   DIRECTORY_ACCESS_CHECK

   If FULL_DIRECTORY_ACCESS_CHECK is defined to 1, then each startup of NEWS
   will check for read access to the directory associated with each newsgroup
   (which can be maintained by SET ACCESS, or direct editing of the ACLS
   attached to a newsgroup).

   If DIRECTORY_ACCESS_CHECK is defined to 1, then the directory check will be
   performed for those newsgroups which have be set RESTRICTed only.

   If both compile variables are defined to 0, then the directory check is
   only performed in the absence of an ACCESS list on only RESTRICTED
   newsgroups.

   NEWS is shipped with both variables set to 0, as this is the fastest
   execution startup option.
*/

#ifndef DIRECTORY_ACCESS_CHECK
#define DIRECTORY_ACCESS_CHECK 0
#endif

#ifndef FULL_DIRECTORY_ACCESS_CHECK
#define FULL_DIRECTORY_ACCESS_CHECK 0
#endif

#if FULL_DIRECTORY_ACCESS_CHECK
#define DIRECTORY_ACCESS_CHECK 0
#endif

/*
 *  NOALLOW_USER_FROM
 *
 * If defined then NEWS will not attempt to substitute a from: mailing address
 * for the default of username@node.domain.
 *
 * If not defined then NEWS will use NEWS_FROM, or if not defined, PMDF_FROM,
 * as the user's mail address. While this would normally only affect other
 * users trying to mail responses to the user, this also has ramifications
 * if you are running a large system where you may have troublesom users..
 * using NEWS_FROM and/or PMDF_FROM users may masquerade as others, and 
 * post items in others' names and cancel others' postings.
 *
 * So think about whether the default setting, implying a trusted user population,
 * is appropriate for your system before accepting this default setting.
 */

#ifndef NOALLOW_USER_FROM
#define NOALLOW_USER_FROM 0
#endif

#ifndef ALLOW_USER_FROM
#if !NOALLOW_USER_FROM
#define ALLOW_USER_FROM		1
#else
#define ALLOW_USER_FROM		0
#endif
#endif

/*
 *  When a newsgroup is marked /Served, and a user reads an item from that
 *  group, News retrieves the item text from the server.  The local copy
 *  is retained for NNTP_CACHE days, so that further requests to read the
 *  item do not require additional requests to the server.  This default
 *  value can be overridden using the Set Newsgroup/Cache=n command.
 */

#ifndef NNTP_CACHE
#define NNTP_CACHE  3
#endif

/*
 * NEWGROUP_REG is the default value for users being automatically registered
 * into new newsgroups. This is overridden by a SET PROFILE/NEWREGISTER
 * setting. The default distributed value of this is 0 (do not automatically
 * register), but sites MAY prefer to have users know about new newsgroups
 * by registering them automatically, using a value of 1. (Strictly speaking
 * a value between 1 and 255 is possible as this value is the registered
 * priority of the new newsgroup, but it is not recommended.)
 */

#ifndef NEWGROUP_REG
#define NEWGROUP_REG   0
#endif

/*
 *  USENET is the mail address to which News sends mail messages documenting
 *  incoming control messages.
 */

#ifndef USENET
#define USENET  "usenet"
#endif

/*
 * Logical name security - the following preprocessor symbols are used to
 * determine the level of security required when attempting to translate
 * logical names used to determine access privileges or to identify this
 * site to the outside.  Basically, the limitations imposed here are applied
 * to any logical name which the documentation states must be defined
 * /System/Executive_Mode.  The translation process for these logical names
 * is as follows:
 *    1. Attempt to translate the logical name using the name tables specified
 *       by SECLNM_TABLE, and the access mode specified by SECLNM_MODE as the
 *       outermost access mode allowed.  SECLNM_TABLE may be defined as a
 *       single table name or as a comma-separated list of table names.
 *       If this fails and SECURE_LOGICALS is #defined, translation fails.
 *    3. Attempt to translate the logical name using the usual progression of
 *       name tables (LNM$FILE_DEV) and access modes.
 *
 * Logical names which are not specified as secure are always translated
 * using the usual order of name tables and access modes.
 */

#ifndef SECURE_LOGICALS
#define SECURE_LOGICALS 1
#endif

/* */
#ifndef SECLNM_TABLE
#define SECLNM_TABLE   "LNM$SYSTEM,LNM$GROUP,LNM$PROCESS,LNM$JOB"
#endif
#ifndef SECLNM_MODE
#define SECLNM_MODE        PSL$C_EXEC
#endif
/*  The following are used for testing only .....
 * #define SECLNM_TABLE   "LNM$PROCESS"
 * #define SECLNM_MODE     PSL$C_SUPER
 */

/*
 * CONFIRM_NEW_GROUPS is defined to 1 to manually ask the user to confirm 
 * registration in new newsgroups which have been created since the
 * previous run of NEWS.
 */

#ifndef CONFIRM_NEW_GROUPS
#define CONFIRM_NEW_GROUPS 1
#endif

/*
 * NNTP_USE_XOVER determines whether the nntp client will use xover commands
 * against the remote server. For servers which do not support this, the use
 * of xover will fill the log file with invalid command entries. XOVER is much
 * faster than XHDR.
 */

#ifndef NNTP_USE_XOVER
#define NNTP_USE_XOVER 1
#endif

/*
 * NNTP_USE_XHDR determines whether the nntp client will use xhdr commands
 * against the remote server. For servers which do not support this, the use
 * of xhdr will fill the log file with invalid command entries.
 */

#ifndef NNTP_USE_XHDR
#define NNTP_USE_XHDR 1
#endif

/*
 * NNTP_USE_XUPDGROUP determines whether the nntp client will use the vms
 * anu-news server-defined xupdgroup command. For non-vms servers set this to
 * 0.
 */

#ifndef NNTP_USE_XUPDGROUP
#define NNTP_USE_XUPDGROUP 1
#endif

/*
 * NNTP_USE_XGTITLE determines whether the nntp client will use the vms
 * anu-news server-defined xgtitle command. For non-vms servers set this to
 * 0.
 */

#ifndef NNTP_USE_XGTITLE
#define NNTP_USE_XGTITLE 1
#endif

/*
 * NNTP_USE_XGNOTICE determines whether the nntp client will use the vms
 * anu-news server-defined xgnotice command. For non-vms servers set this to
 * 0.
 */

#ifndef NNTP_USE_XGNOTICE
#define NNTP_USE_XGNOTICE 1
#endif

/*
 * DISPLAY_BY_NEWSGROUPS determines whether to break and display a newsgroup
 * directory whenever the newsgroup is automatically changed by the item reader.
 */

#ifndef DISPLAY_BY_NEWSGROUPS
#define DISPLAY_BY_NEWSGROUPS 1
#endif

/*
 * STRIP_ERR_LINES determines whether the CLI% prefixes from the CLI messages are stripped by the
 * code - default is ON
 */

#ifndef STRIP_ERR_LINES
#define STRIP_ERR_LINES 1
#endif

/*
 * MENU_SUPPORT determines whether on-screen menu drivers are included
 * in theNews image.  If so, the user may select commands in screen mode
 * using single-key shortcuts displayed on a menu. Default is ON.
 */

#ifndef MENU_SUPPORT
#define MENU_SUPPORT	1
#endif

/*
 * ARBITRON will cause NEWS to write the date of last item read access to
 * each newsgroup into the user's newsrc file. This will make the arbitron
 * program more accurate in reporting local readership levels.
 * default is ON.
 */

#ifndef ARBITRON
#define ARBITRON	1
#endif

/*
 * FAST_LOAD determines whether fast loading drivers are included in the 
 * News image.  If so, the user may activate the Fastload option using the
 * command Set Profile/Fastlaod.  
 * Default is ON. FAST_LOAD requires Arbitron support as well.
 */

#ifndef FAST_LOAD
#define FAST_LOAD	1
#endif
#if FAST_LOAD
#define ARBITRON	1
#endif

/*
 * If SILENT_CLIENT_STARTUP is defined TRUE, then the connect messages during
 * NNTP client startup are suppressed.  Default is OFF.
 */

#ifndef SILENT_CLIENT_STARTUP
#define SILENT_CLIENT_STARTUP 0
#endif

/*
 * UWO adds support for UWO/Mail for Vax/VMS 
 * default is OFF
 */

#ifndef UWO
#define UWO		0
#endif

#ifndef NOTE_RANGE_MAX
#define NOTE_RANGE_MAX	1000	 /* number of slots available for notes ranges */
#endif

/*
 * News memory allocation management - for details on routines, see
 * comments and code in NewsRTL.C
 */

/* MALLOC_SANITY_LIMIT is the number of bytes that news_*alloc* routines
 * permit to allocate in one request
 */
#define MALLOC_SANITY_LIMIT	(50000*512)

/* setting SIMPLE_MALLOC to 1 causes a simple version of malloc routines
 * to be used - a bit faster and smaller code at the expense
 * of ungraceful failure in case of virtual memory shortage
 */
#ifndef SIMPLE_MALLOC
#define SIMPLE_MALLOC 0
#endif

/*
 * Note: if SIMPLE_MALLOC is nonzero the remaining MEM_* macros are not used!
 *
 * MEM_CHECK_QUOTA = Check remaining available memory before trying to
 * allocate a new block, and react appropriately (see MEM_RESERVE_SIZE)
 * if there isn't much left.  Setting this symbol to 0 disables all
 * checking of limits, so the allocation routines won't return NULL or
 * call mem_fail() until an allocation request actually fails.  This is
 * generally not a good idea, since this usually means there's not
 * enough memory left for your error recovery code to run (remember, RTL
 * routines may allocate memory, the stack may expand, etc.)  In
 * particular, if you set this to 0 and News runs out of memory, it will
 * usually die a horrible death.
 *
 * MEM_RESERVE_SIZE = Size of memory reserve to hold out for low memory
 * recovery.  If available memory falls below this value, allocation
 * routines fail and call recovery routine mem_fail().
 *
 * MEM_DYNAMIC_QUOTA = If true, check remaining PAGFILCNT every time
 * an attempt is made to allocate memory; otherwise, check only once at
 * startup and again when returning from subprocess.  Checking PAGFILCNT
 * slows down the allocation routines a bit, and shouldn't be necessary
 * unless you've got another process consuming your pagefile quota at the
 * same time as News, so this symbol is false by default.
 *
 * MEM_CACHEMAX = Maximum size of block eligible for caching when
 * deallocated. This is set fairly small for ANU News, since it doesn't
 * tend to free and reallocate large blocks of memory often (except to
 * realloc expanding arrays, which wouldn't benefit much from reusing old
 * blocks), and we don't want to keep a large block of memory floating
 * around if we don't need something that big.
 */

#ifndef MEM_CHECK_QUOTA
#define MEM_CHECK_QUOTA 1
#endif

#if MEM_CHECK_QUOTA
#ifndef MEM_RESERVE_SIZE
#define MEM_RESERVE_SIZE 8096
#endif
#ifndef MEM_DYNAMIC_QUOTA
#define MEM_DYNAMIC_QUOTA 0
#endif
#else  /* MEM_CHECK_QUOTA */
#define MEM_RESERVE_SIZE 0
#define MEM_DYNAMIC_QUOTA 1  /* we're not actually checking quotas; this */
                             /* causes other unneeded code to be bypassed */
#endif  /* MEM_CHECK_QUOTA */

#ifndef MEM_CACHEMAX
#define MEM_CACHEMAX 1024
#endif

#endif	/* _NEWSSITE_H */
