/*
**++
**  FACILITY:
**      NEWSV60_UPGRADE
**
**  ABSTRACT:
**      Convert the ITEM file to V6.0 format
**
**  AUTHOR:
**      Geoff Huston
**
**  COPYRIGHT:
**      Copyright  1990
**
**  VERSION HISTORY:
**	V6.1b8  22-Dec-1993	mark.martinec@ijs.si
**	   - convert calls to RMS to use new sys_* macros for error handling 
**	V6.1b9	17-Aug-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to make it compile under gcc 2.6.0 with full
**	    warnings reporting turned on - with no or very few harmless warnings
**	V6.1b9	17-Sep-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to preserve the read-only nature of string literals
**	    (strategically placed 'const' attribute to string parameters)
**--
**/

#ifdef vaxc
#module NEWSV60_UPGRADE "V6.1"
#endif

#define _NEWSV60_UPGRADE_C
#define module_name "NEWSV60_UPGRADE"

#include "newsinclude.h"
#include "newsextern.h"

#define ITM_NEWFILENAME		"NEWS_ROOT:NEWS.TMP"

#ifdef __DECC
#pragma member_alignment save
#pragma nomember_alignment   /* no member alignment - file record ! */
#endif
typedef struct {
    unsigned int oitm_num;           /* newsitem index [key 0, b 1-4] 4   4 */
    unsigned int oitm_grp;           /* newsgroup index[key 0, b 5-8] 4   8 */
                                     /*                [key 1, seg 1]       */
    char oitm_id[IDLEN];             /* item id        [key 1, seg 0]60  68 */
    unsigned int oitm_recvdate;      /* date                          4  72 */
    unsigned int oitm_lines;         /* lines                         4  76 */
    char oitm_title[SUBJLEN];        /* title                        50 126 */
    unsigned int oitm_cachedate;     /* server - cache entry date     4 130 */
    unsigned short oitm_life;        /* retention period              4 134 */
    unsigned int oitm_flags;         /* item flags                    4 138 */
    unsigned int oitm_cid;           /* conversation id [key 2, b1-4] 4 142 */
    unsigned int oitm_cno;           /* conversation seq[key 2, b5-8] 4 146 */
    } OITM;

static OITM onewsitm;
static ITM nnewsitm;

#ifdef __DECC
#pragma member_alignment restore
#endif


static int mcvtfiles()
{
  int status;
  int i;
  struct FAB oitmfab, itmfab;
  struct RAB oitmrab, itmrab;
  struct XABKEY xabkey_1, xabkey_2;
  struct XABPRO xabpro_1;

  oitmfab = cc$rms_fab;
  oitmfab.fab$b_fac = FAB$M_GET;
  
  oitmfab.fab$l_fna = (char *) ITM_FILENAME;
  oitmfab.fab$b_fns = strlen(oitmfab.fab$l_fna);
  oitmfab.fab$b_shr = FAB$M_SHRDEL | FAB$M_SHRGET | FAB$M_SHRPUT | FAB$M_SHRUPD;

  oitmrab = cc$rms_rab;
  oitmrab.rab$l_fab = &oitmfab;
  oitmrab.rab$l_ubf = (char *) &onewsitm;
  oitmrab.rab$w_usz = sizeof nnewsitm;
  oitmrab.rab$l_rbf = (char *) &onewsitm;
  oitmrab.rab$w_rsz = sizeof nnewsitm;
  oitmrab.rab$b_rac = RAB$C_SEQ;

  sys_open(&oitmfab);
  sys_connect(&oitmrab);
  sys_get(&oitmrab);
  if (oitmrab.rab$w_rsz == sizeof nnewsitm) {
    sys_close(&oitmfab);
    return(1);
    }

  itmfab = cc$rms_fab;
  itmfab.fab$b_bks = 3;
  itmfab.fab$b_fac = FAB$M_PUT ;
  itmfab.fab$l_fna = (char *) ITM_NEWFILENAME;
  itmfab.fab$b_fns = strlen(itmfab.fab$l_fna);
  itmfab.fab$l_fop = FAB$M_CIF;
  itmfab.fab$w_mrs = sizeof nnewsitm;
  itmfab.fab$b_org = FAB$C_IDX;
  itmfab.fab$b_rfm = FAB$C_FIX;
  itmfab.fab$l_xab = (char *) &xabkey_1;

  xabkey_1 = cc$rms_xabkey;
  xabkey_1.xab$b_dtp = XAB$C_BN8;
  xabkey_1.xab$b_flg = 0;
  xabkey_1.xab$w_pos0 = (char *) &nnewsitm.itm_num - (char *) &nnewsitm;
  xabkey_1.xab$b_ref = 0;
  xabkey_1.xab$b_siz0 = 8;
  xabkey_1.xab$l_nxt = (char *) &xabkey_2;

  xabkey_2 = cc$rms_xabkey;
  xabkey_2.xab$b_dtp = XAB$C_STG;
  xabkey_2.xab$b_flg = 0;
  xabkey_2.xab$w_pos0 = (char *) &nnewsitm.itm_id - (char *) &nnewsitm;
  xabkey_2.xab$w_pos1 = (char *) &nnewsitm.itm_grp - (char *) &nnewsitm;
  xabkey_2.xab$b_ref = 1;
  xabkey_2.xab$b_siz0 = IDLEN;
  xabkey_2.xab$b_siz1 = 4;
  xabkey_2.xab$l_nxt = (char *) &xabpro_1;

  xabpro_1 = cc$rms_xabpro;
  xabpro_1.xab$w_pro = 0xEE00;

  itmrab = cc$rms_rab;
  itmrab.rab$l_fab = &itmfab;
  itmrab.rab$b_krf = 0;
  itmrab.rab$b_ksz = 4;
  itmrab.rab$l_ubf = (char *) &nnewsitm;
  itmrab.rab$w_usz = sizeof nnewsitm;
  itmrab.rab$l_rbf = (char *) &nnewsitm;
  itmrab.rab$w_rsz = sizeof nnewsitm;

  nnewsitm.itm_grp = 0;

  sys_create(&itmfab);
  sys_connect(&itmrab);
  do {
    if (nnewsitm.itm_grp != onewsitm.oitm_grp)
      printf("Working on newsgroup #%d\n",onewsitm.oitm_grp);
    nnewsitm.itm_num = onewsitm.oitm_num;
    nnewsitm.itm_grp = onewsitm.oitm_grp;
    for (i = 0; i < IDLEN; ++i)
      nnewsitm.itm_id[i] = onewsitm.oitm_id[i];
    nnewsitm.itm_recvdate = onewsitm.oitm_recvdate;
    nnewsitm.itm_lines = onewsitm.oitm_lines;
    for (i = 0; i < SUBJLEN; ++i)
      nnewsitm.itm_title[i] = onewsitm.oitm_title[i];
    nnewsitm.itm_cachedate = onewsitm.oitm_cachedate;
    nnewsitm.itm_life = onewsitm.oitm_life;
    nnewsitm.itm_flags = onewsitm.oitm_flags;
    nnewsitm.itm_cid = onewsitm.oitm_cid;
    nnewsitm.itm_postdate = nnewsitm.itm_recvdate;
    nnewsitm.itm_from[0] = '\0';
    sys_put(&itmrab);
    } while (sys_get_noeof(&oitmrab));

  sys_close(&oitmfab);
  sys_close(&itmfab);
  rename(ITM_NEWFILENAME,ITM_FILENAME);
  return(1);
}

#ifdef	STANDALONE
int main()
#else
int v60_upgrade()
#endif
{
  printf("CONVERSION PROGRAM - NEWS V6.0 upgrade\n\n");
  printf("This program alters the record structure of the NEWS ITEM file\n");
  if (!mcvtfiles())
    printf("Error - cannot open files for conversion\nCheck that this account has appropriate privileges\n");
  return 1;
}
