/*
**++
**  FACILITY
**	NEWSVARIABLES
**
**  ABSTRACT:
**	Common NEWS variable declarations and defintions
**	Single definition of all global news variables, used to define
**	variables in NEWS.C and to reference the variables in NEWSEXTERN.H.
**
**  AUTHOR:
**	Geoff Huston
**
**  COPYRIGHT:
**	Copyright  1988,1989,1990
**--
**/

#ifndef _NEWSVARIABLES_H
#define _NEWSVARIABLES_H

#if NOGLOBALREF
extern void newscmd();	/* this "lie" yields the proper linkage */
#define CLICMDTBL (int *)newscmd
#else
globalref int newscmd;
#define CLICMDTBL &newscmd
#endif

#ifdef _NEWS_C
			/* "global" variables are defined by NEWS.C */
#define global_var
#define iev(v)	= v
#define iv(v)	v
#define DESCRIPT(dsc,val)	$DESCRIPTOR(dsc,val)
#else
			/* ... and used by other modules */
#define global_var	extern
#define iev(v)
#define iv(v)
#define DESCRIPT(dsc,val)	extern struct dsc$descriptor_s dsc
#endif

global_var
size_t mem_reserve;  /* minimum free bytes VM before allocs complain */

global_var
int   kid,			/* SMG keyboard id */
      pid,			/* SMG Pasteboard id */
      devrow,			/* SMG device rows */
      devcol,			/* SMG device columns */
      keytab iev(0),		/* SMG key definition table */
      no_more_news iev(0),	/* global flag indicating all registered groups read */
      ga_size iev(0),		/* size of group array */
      ga_malloc,		/* size of memory allocated for group array */
      cur_dir_type iev(DIR_ALL),/* current selection type */
      curr_g iev(0),		/* current group */
      curr_i iev(-1),		/* current item */
      news_context iev(1),	/* news level (1,2,3) */
      old_context iev(1),	/* news level (1,2,3) */
      grp_vd,			/* group display */
      grp_display_size,		/* group display size */
      smg_active iev(0),	/* smg display routines in use */
      pid_created iev(0),	/* no screen at all! */
      trailer_vd,		/* input virtual display */
      g_arrow iev(0),		/* screen group arrow */
      grp_header_vd,
      itm_header_vd,
      gv_size iev(0),
      grp_paste,
      itm_approved,
      forward_posting,
      net_news,
      auto_cre_grp,
      mail_add_expiry iev(0),
      brdcst_line iev(0),
      brdcst_col iev(0),
      verbose iev(1),           /* verbose level on SKIM command function */
      server_call iev(0),       /* call the nntp server update flag */
      vms_major iev(0),         /* VMS Version - major level */
      vms_minor iev(0),         /* VMS Version - minor level */
      mail_self_flag iev(0),
      nntp_client iev(0),	/* this is a remote reader executable */
      nntp_proto iev(0),	/* this is a remote reader executable */
      news_readonly iev(0),
      news_captive iev(0),      /* JLH this is for captive NEWS reader accounts */
      parse_level iev(0),	/* current parse position */
      profile_scansize iev(-1),		/* first screen display size */
      nntp_no_posting_allowed iev(0),	/* set on a 201 server opening response */
      nntp_anu_news_server iev(0),	/* set on an ANU NEW implementation of the remote server */
      profile_display_lines iev(0),	/* display line count on opening newsgroup  (nntp) */
      profile_display_postmark iev(0),  /* display postmark on opening newsgroup  (nntp) */
      sysprv_off iev(0),	/* sysprv set / not set flag */
      first_retr_call iev(1),	/* flag to print out nntp progress */
      display_unseen_stack iev(0),
      display_unseen_items iev(0),
      reorder_groups iev(0),
      include_all_groups iev(0),
      profile_filter iev(0),
      initial_classname iev(0),
      v59_file iev(0),
      news_lock_alarm iev(0),
      minfromlen iev(19),
      display_stk iev(0),
      line_editing iev(0),		/* line_editing mode on */
      usedotnewsrc iev(0),		/* rn-style .newsrc support */
      broadcast_trapping_requested iev(1), /* SMG broadcast trapping wanted ? */
      closing_files iev(0),       /* true only when closefiles() is executing */
      problems_encountered iev(0),/* set to true by the condition handler,
                                   causes cautious NEWSRC writing during exit */
      signalled_error_count iev(0),/* count condition handler invocations;
                                   used to limit infinite loops through
                                   condition handler's ability to unwind or
                                   continue on error */
      session_is_interactive iev(0),    /* controlling keyboard is terminal */
      on_error iev(0),            /* controls how the condition handler reacts
                                   on signals - see 'ON_ERROR_*' constants */
      try_to_quietly_handle_errors iev(1), /* some parts of the code know
                                   how to handle certain more common errors
                                   (like RMS errors during ADD FILE processing).
                                   Setting this value to true (1) indicates that
                                   we prefer a log file entry or quietly handled
                                   error without throwing a signal.
                                   False (0) disables this code-specific
                                   error handling, errors are signalled and
                                   the execution is controlled by the condition
                                   handler (based on the value of 'on_error') */
       /* some statistics on the usefulness of routine try_to_make_some_space */
      stat_make_space_called iev(0),   /* no. of times the routine was called */
      stat_make_space_succeeded iev(0),/* no. of times the routine returned 1 */
      stat_make_space_retry_success iev(0), /* number of times the file create
                                   operation succeeded on the second attempt
                                   after first succesfully calling the
                                   procedure try_to_make_some_space() */
      mailfile_open iev(0),		/* mail folder open ? */
      confirm_specified iev(0),		/* ask_confirm variable */
      showdirs_val iev(DISPLAY_BY_NEWSGROUPS),
#if FAST_LOAD
      all_loaded iev(0),
      fast_loading iev(0),
#endif
      init_scanning iev(0),
      first_time_user iev(0),
      gmt_offset iev(0);  /* signed offset in seconds added to GMT to */
                          /* generate local time */

global_var
unsigned short usr_inp_l,		/* input length */
	       cmd_len,			/* command input string length */
	       mail_flags;

global_var
char  usr_inp[iv(256)],		/* input */
      cmd[iv(256)],		/* command line */
      usr_username[iv(33)],	/* who is this person anyway ? */
      news_node[iv(256)],	/* and where ? */
      news_pathname[iv(256)],	/* what goes in the Path: header? */
      usr_persname[iv(256)],
      mail_queue[iv(256)],
      mail_form[iv(256)],
      mail_editor[iv(256)],
      Node_address[iv(256)],	/* Internet node address */
      Editor[iv(132)],		/* editor string */
      Viewer[iv(132)],		/* view command string */
      TPUedit[iv(132)],		/* tpu edit string */
      TPUview[iv(132)],		/* tpu view string */
      no_new_item[iv(132)],	/* add item error text returned */
      news_register[iv(132)],	/* register file name */
      err_oline[iv(512)],	/* err line */
      itm_fname[iv(100)],	/* filename */
      Mail_file[iv(132)],	/* mail temp file name */
      Extract_file[iv(132)],
      Print_file[iv(132)],
      Print_save_file[iv(132)],
      Post_file[iv(132)],
      Organisation_name[iv(132)],
      newsmgr_dir[iv(132)],
      news_timezone[iv(132)],
      print_constant[iv(132)],
      fp_open[iv(256)],		/* flag to indicate open files which require closing */
      fpa_open[iv(256)],	/* flag to indicate open files which require closing */
      fpd_open[iv(256)],	/* flag to indicate open files which require closing */
      mail_sig[iv(132)],
      str_target[iv(132)],
      nntp_node[iv(256)],	/* nntp reader variable */
      n_class_name[iv(256)],
      profile_dirstr[iv(132)],
      profile_reply_to[iv(256)] iev(""),	/* reply-to header setting */
      profile_endofitm_cmd[iv(256)] iev("READ/NEXT"),
      scangroups[512],
      VMS_VERS[11];		/* holds VMS version string */


global_var
FILE *fp,			/* utility file */
     *fpa,
     *fpd,
     *newsrc iev(0);		/* newsrc file */

global_var
struct FAB grpfab,		/* newsgroup file fab */
	   itmfab;		/* newsitem file fab */

global_var
struct RAB grprab,		/* newsgroup file rab */
	   itmrab;		/* newsitem file rab */

global_var
ITM newsitm;			/* newsitem i/o buffer */

global_var
GRP newsgrp;			/* newsgroup i/o buffer */

global_var
jmp_buf env,    		/* outer loop jump back point */
	envdisp;                /* item display jump back point */

global_var
GRP_PTR *ga;

global_var
DPT itmptr,			/* smg display context block : item display */
    textptr;			/*       "                     text display */

global_var
NOTE_RANGE d_itm[iv(NOTE_RANGE_MAX)];

global_var
DIR_CLASS_PTR c_head iev(0),	/* class list and current class pointer */    	
              curr_class iev(0);

global_var
struct marks *m_head iev(0),
             *mk_head iev(0);

ALIAS_PTR aliases_list iev(0);

SYS_FILTER_T *local_filter iev(0),
             *local_dfilter iev(0);

SYS_ENTRY_T *sysfile iev(0);

DIST_ENTRY_T *distfile iev(0);

DESCRIPT(usr_inp_dsc,usr_inp);
DESCRIPT(cmd_dsc,cmd);
DESCRIPT(err_oline_d,err_oline);
#endif
