/*
**++
**  FACILITY:
**      NNTP_TCPUCX
**
**  ABSTRACT:
**      NNTP server under VMS using the UCX TCP transport.
**
**  AUTHOR:
**      Geoff Huston
**
**  COPYRIGHT:
**      Copyright  1990,1991
**
**  MODIFICATION HISTORY:
**	V6.1b9	17-Aug-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to make it compile under gcc 2.6.0 with full
**	    warnings reporting turned on - with no or very few harmless warnings
**	V6.1b9	17-Sep-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to preserve the read-only nature of string literals
**	    (strategically placed 'const' attribute to string parameters)
**	V6.1b9	 3-Feb-1995	Mark Martinec   mark.martinec@ijs.si
**	  - replaced  #include "newsinclude.h"  with  #include "nntpinclude.h"
**	    and removed now redundant includes
**
**      NOTE: this module is presently not supported, use NNTP_TCPUCXM instead !
**--
**/

#ifdef vaxc
#module NNTP_TCPUCX "V6.1"
#endif

#define _NNTP_SERVER_DRIVER_C
#define _NNTP_TCPUCX_C
#define module_name "NNTP_TCPUCX"

#include "nntpinclude.h"

#define NO_INPUT        0
#define CMD_INPUT       1
#define FILE_INPUT      2

#define IDLE                0
#define READ_IN_PROGRESS    1
#define WRITE_IN_PROGRESS   2
#define LINK_ERROR          3

#define MAX_STMS	31
#define NNTP_PORT	(119)

struct wb {
  char *txt;
  struct wb *wnext;
  };

static int master_socket;

static char hostname[256];
static struct hostent hostentstruct, *hostentptr;
static struct sockaddr_in master_sockname;

static struct STM {
  int socket;
  int (*func)();
  char *stop_read_text;
  struct wb *writenext, *writetail;
  int state;
  } stm[MAX_STMS];

#ifdef MULTINET
extern noshare int h_errno;
struct hostent *dest_host;
struct sockaddr_in data_socket = {0};
#endif

#define TIMEOUT     7200         /* read wait timeout  - 2 hours */
#define X_BUF_SIZE  2048        /* size of line assembly read buffer */

                                /* check status bits */
#define cks(s)      if (!((c$status = (s)) & 1)) lib$signal(c$status)

#define nntp_getchar() (!nntp_size ? nntp_fillbuf() : (--nntp_size, *nntp_ptr++))

static unsigned short f_i;      /* tcp channel input */
static unsigned short f_o;      /* tcp channel output */

static int c$status;            /* return status */

static unsigned short iosb[4];  /* i/o status blocks */
static unsigned short *i_o_sts = iosb;
static char nntp_buffer[X_BUF_SIZE];
static char *nntp_ptr = nntp_buffer;
static int nntp_size = 0;

void (*next_function)(int);
int create_initial_socket(int);

main(argc, argv)
  int argc;
  char *argv[];
{
  int nntp_port;

  switch (argc) {
    case 1:
      nntp_port = NNTP_PORT;
      break;
    case 2:
      if (is_numeric(argv[1])) nntp_port = atoi(argv[1]);
      else {
        puts("nntp: portnumber must be numeric");
        exit(-1);
        }
      break;
    default:
      puts("Usage: nntp [portnumber]\n");
      exit(-1);
    }

/*
 *get_date(start_time);
 *get_time(start_time+1);
 *start_time[10] = ' ';
 *
 *system_log("Starting nntp server on port %d",nntp_port,0);
 *if (!create_initial_socket(nntp_port)) {
 *  system_log("Could not create or bind initial socket",0);
 *  exit(-1);
 *  }
 *
 *for (count=0; count<MAX_STMS; count++) stm[count].state = IDLE;
 *
 *status = ASTOFF;
 *listen(initial_socket,SOMAXCONN);
 *issue_new_connect_qio();
 *attn_state = ATTN_SLEEP;
 *while (serving) {
 *  status = ASTON;
 *  if (vms_error(status)) system_log("setast: %s",vms_message(status),0);
 *  status = sys$hiber();
 *  switch(attn_state) {
 */

  if (!server_init(MAX_STMS)) {
    fprintf(stderr,"Failed to startup NNTP SERVER\n");
    exit(1);
    }

    if (!open_net()) exit(1);
    server_init_unit(1);
    while (next_function) (*next_function)(1);
    server_shut();
    close_net();
}

/*
 *int create_initial_socket(int nntp_port)
 *{
 *  int return_value = FALSE;
 *  int status;
 *  struct sockaddr_in server;
 *  static int one = 1;
 *
 *  if ((initial_socket = socket(AF_INET,SOCKSTREAM,0)) < 0) system_log("error creating initial socket",0);
 *  else {
 *    server.sin_family = AF_INET;
 *    server.sin_addr.s_addr = INADDR_ANY;
 *    server.sin_port = htons(nntp_port);
 *    if (status = bind(initial_socket,&server, sizeof(server))) system_log("error binding initial socket",0);
 *    else {
 *      setsockopt(initial_socket,SOL_SOCKET,SO_KEEPALIVE,(char *)&one,sizeof(one));
 *      return_value = TRUE);
 *      }
 *    }
 *  return(return_value);
 *}
 *int issue_new_connect_qio()
 *{
 *  int status;
 *
 *  status = sys$qio(0,initial_socket,IO$_ACCEPT_WAIT,&connect_iosb,&new_connect_ast,0,0,0,0,0,0,0,);
 *}
 */

/*
 *  cancel_net
 *
 *  If the read timer expires then cancel this server task (by exiting)
 */

void cancel_net(sig)
  int sig;
{
#if DEBUG
    fprintf(stderr,"Cancel_net\n");
#endif
    sys$cancel(f_o);
    sys$cancel(f_i);
    log_to_file(1);
    write_net("400 service discontinued - read timeout\r\n");
    cks(sys$qiow(0,f_i,IO$_DELETE,iosb,0,0,0,0,0,0,0,0));
    cks(sys$qiow(0,f_o,IO$_DELETE,iosb,0,0,0,0,0,0,0,0));
    cks(*i_o_sts);
    sys$dassgn(f_i);
    sys$dassgn(f_o);
    exit(1);
}

static int nntp_fillbuf()
{
    signal(SIGALRM,cancel_net);
    alarm(TIMEOUT);
    cks(sys$qiow(0,f_i,IO$_READVBLK,iosb,0,0,nntp_buffer, sizeof(nntp_buffer),0,0,0,0));
    alarm(0);
    if (!iosb[1]) return(cancel_net(SIGKILL),-1);
    nntp_ptr = nntp_buffer;
    nntp_size = iosb[1]-1;
    return(*nntp_ptr++);
}

/*
 *  read_net
 *
 *  Get a line of text from the server.  Strips CR's and LF's.
 *  Parameters:     string  has the buffer space for the line received.
 *                  size    is the size of the buffer.
 *  Returns:           -1 on error, 0 otherwise.
 *  Side effects:      Talks to server, changes contents of "string"
 */

read_net(string, size,unit)
    char *string;
    int size;
    int unit;
{
  if (!stm[unit].readnext) strcpy(string,stm[unit].stop_read_text);
  else {
    strcpy(buffer,stm[unit].readnext->txt);
    tmp = stm[unit].readnext;
    stm[unit].readnext = tmp->wnext;
    if (!stm[unit].readnext) stm[unit].readtail = 0;
    news_free(tmp->txt);
    news_free(tmp);
    }
  return(strlen(buffer));
}

/*
 *  write_net
 *
 *  write to the client process - catch i/o errors and abort
 */

write_net(s,unit)
  char *s;
  int unit;
{
  struct wb *tmp;

#if DEBUG
  fprintf(stderr,"Write_net [%d]:|%s|",unit,s);
#endif
  tmp = news_malloc(sizeof *tmp);
  tmp->wnext = 0;
  strcpy(tmp->txt = news_malloc(strlen(s) + 1),s);
  if (stm[unit].writetail) stm[unit].writetail->wnext = tmp;
  if (!stm[unit].writenext) stm[unit].writenext = tmp;
  stm[unit].writetail = tmp;
  if (stm[unit].state == IDLE) issue_link_write(index);
}

next_call(unit,func,type)
  int unit, (*func)(), type;
{
  stm[unit].next_function = func;
  if (type == FILE_INPUT) stm[unit].stop_read_text = ".\n";
  else stm[unit].stop_read_text = "QUIT\n";
}

/*
 *  open_net
 *
 *  Open TCP channel
 */

int open_net(void)
{
#if DEBUG
  fprintf(stderr,"Open_net\n");
#endif
  if ((master_socket = socket (AF_INET, SOCK_STREAM, 0)) == -1) 
    fprintf(stderr,"socket (master): %s\n",strerror(errno);
    return(0);
    }
  if (gethostname(hostname,sizeof hostname)) {
    fprintf(stderr,"gethostname: %s\n",strerror(errno);
    close_net();
    return(0);
    }
  if ((hostentptr = gethostbyname(hostname)) == NULL) 
    fprintf(stderr,"gethostbyname: %s\n",strerror(errno);
    close_net();
    return(0);
    }
  hostentstruct = *hostentptr;
  master_sockname.sin_family = hostentstruct.h_addrtype;
  master_sockname.sin_port = htons(atoi(NNTP_PORT));
  master_sockname.sin_addr = * ((struct in_addr *) hostentstruct.h_addr);
  if (bind(master_socket,&master_sockname,sizeof master_sockname));
    fprintf(stderr,"bind: %s\n",strerror(errno));
    close_net();
    return(0);
    }
  if (listen(master_socket,MAX_STMS)) {
    fprintf(stderr,"listen: %s\n",strerror(errno));
    close_net();
    return(0);
    }
  return(1);
}

/*
 *  close_net
 *
 *  Close the TCP link
 */

close_net()
{
#if DEBUG
  fprintf(stderr,"Close_net\n");
#endif
  if (shutdown(master_socket,2) == -1) fprintf(stderr,"shutdown (master): %s\n,strerror(errno));
  if (close(master_socket) == -1) fprintf(stderr,"close (master): %s\n,strerror(errno));
}

/*
 * Get name of the host requesting connection with NNTP_SERVER.
 * return reverse name lookup or dotted quad address if reverse name not defined
 */
 
int getremhost(remhost, remuser, unit)
  char *remhost, *remuser;
  int unit;
{
  struct hostent *hp;
  struct sockaddr_in name;
  int namelen;
 
  if (remuser) strcpy(remuser,"nntp");
  if (remhost) {
    namelen=sizeof(name);
    if (getpeername(stm[unit].socket,&name,&namelen) == -1) {
      fprintf(stderr,"getpeername: %s\n",strerror(errno));
      strcpy(remhost,"TCP");
      }
    else if ((hp = gethostbyaddr(&(name.sin_addr),4,AF_INET)) == NULL)
      strcpy(remhost,inet_ntoa(name.sin_addr));
    else
      strcpy(remhost,hp->h_name);
    }
}
