/*
**++
**  FACILITY:
**      NNTP_TTY
**
**  ABSTRACT:
**      This module contains the QIO interface to the terminal for an
**      interactive interface via NNTP to the local database. (This module
**      is used to check the functionality of the NNTP_SERVER code.
**
**  AUTHOR:
**      Geoff Huston
**
**  COPYRIGHT:
**      Copyright  1988,1989,1990
**
**  MODIFICATION HISTORY:
**	V6.1b9	17-Aug-1994     Mark Martinec   mark.martinec@ijs.si
**	  - code cleanup to make it compile under gcc 2.6.0 with full
**	    warnings reporting turned on - with no or very few harmless warnings
**--
**/

#ifdef vaxc
#module NNTP_TTY "V6.1"
#endif

#define _NNTP_SERVER_DRIVER_C

#include "nntpinclude.h"

#define TIMEOUT     300         /* read wait timeout  - 5 minutes */

void (*next_function)(int);

/*
 *  cancel_net
 *
 *  If the read timer expires then cancel this server task (by exiting)
 */

void cancel_net(sig)
  int sig;
{
  write_net("400 service discontinued - read timeout\r\n",0);
  log_to_file(1);
  exit(1);
}

/*
 *  read_net
 *
 *  read from the client process - if the read timer expires cancel this server
 */

int read_net(buffer,size,unit)
  char *buffer;
  int size;
  int unit;
{
  int buffer_l;

  signal(SIGALRM,cancel_net);
  alarm(TIMEOUT);
  if (!gets(buffer)) strcpy(buffer,"quit");
  alarm(0);
  strcat(buffer,"\n");
  buffer_l = strlen(buffer);
  news_assert(buffer_l < size);  /* although this test comes after the fact,
                                    better check now than never */
  return(buffer_l);
}

/*
 *  write_net
 *
 *  write to the client process - catch i/o errors and abort
 */

void write_net(s,unit)
  const char *s;
  int unit;
{
  printf("%s",s);
}

/*
 *  next_call
 *
 *  Set the next function to be invoked by the server
 */

void next_call(unit,func,type)
    int unit;
    void (*func)(int);
    int type;
{
    next_function = func;
}

/*
 *  open_net1
 *
 *  Open tty channel
 */

int open_net1(void)
{
    return(1);
}

/*
 *  close_net
 *
 *  Close the tty link - noop for tty channel
 */

void close_net()
{
  log_to_file(1);
}

/*
 *  getremhost
 *
 *  Return the remote host name and remote username
 */

void getremhost(remhost,remuser,unit)
  char *remhost, *remuser;
  int unit;
{
  char *cp;

  if (remhost) {
    cp = news_getenv("SYS$NODE",1);
    if (cp) {
      strcpy(remhost,cp);
      if ( (cp = strchr(remhost,':')) ) *cp = '\0';
      }
    }
  if (remuser) cuserid(remuser);
}

/*               
 *  main
 */

int main(void)
{
  if (!server_init(1)) exit(1);
  if (!open_net1()) exit(1);
  server_init_unit(1);
  while (next_function) (*next_function)(1);
  server_shut();
  close_net();
  return(1);
}
#if defined(__DECC)
/*
 * All these symbols show up as undefined on DECC (both on AXP and VAX)
 * when building nntp stuff.  They are never actually used, as far as I know,
 * so this kludge gets rid of the error messages.
 */
int	stat_make_space_called ;
int	stat_make_space_succeeded ;
int	stat_make_space_retry_success ;
#endif
