/*
**++
**  FACILITY:
**      NNTPINCLUDE
**
**  ABSTRACT:
**      Common NNTP include modules
**
**  VERSION:
**	V6.1b10	23-Aug-1994     Mark Martinec   mark.martinec@ijs.si
**	  - Initial version - collect all include files from
**          NNTP server and driver modules
**	V6.1b10	15-Feb-1995	Mark Martinec   mark.martinec@ijs.si
**	  - moved the declarations of htons() and ntohs() from various
**	    modules to this include file
**--
**/

#ifndef _NNTPINCLUDE_H
#define _NNTPINCLUDE_H

#include "newsinclude.h"
#include "newsextern.h"

#ifdef __P
/* One of the gcc-vms "alternate" header files (stddef.h) defines __P(x)
   for BSD-compatible prototype selection, and one of MultiNet's headers
   (cdefs.h) defines it too, but they spell `x' differently, causing gcc to
   issue a redefinition warning.  NEWS doesn't need either definition anyway. */
#undef __P
#endif

#if NAKED_INCLUDES
#include iodef
#include psldef
#include libdef
#else
#include <iodef.h>
#include <psldef.h>
#include <libdef.h>
#endif

#ifdef __DECC
#pragma message save
#pragma message disable (MACROEXT)
/* #pragma message disable (IGNOREEXTRA)  */
#endif

#ifdef UCX

#if defined(__GNUC__) && !defined(__SOCKET_TYPEDEFS)
/* to prevent redefinition of caddr_t,u_short,u_long,u_char in <socket.h>
   which have already been defined in gnu_cc_include:[sys]types.h  */
#define __SOCKET_TYPEDEFS
#endif

#include <socket.h>
#include <netdb.h>
#include <inet.h>
/* #include <in.h>    * already included in <inet.h> */
#include <ucx$inetdef.h>

#elif defined(MULTINET)

#if !defined(__SOCKET_TYPEDEFS)
/* to prevent redefinition of caddr_t,u_short,u_long,u_char in <socket.h>
   which have already been defined in multinet:<sys/types.h>  */
#define __SOCKET_TYPEDEFS
#endif

/* must include socket.h before netdb.h
   since it defines gethostbyaddr as a macro */
#include <sys/socket.h>
#include <netdb.h>
#include <vms/inetiodef.h>
#include <netinet/in.h>

#elif defined(TWG)

#include <twg$tcp:[netdist.include.sys]socket.h>
#include <twg$tcp:[netdist.include.sys]netdb.h>
#include <twg$tcp:[netdist.include.vms]inetiodef.h>
#include <twg$tcp:[netdist.include.netinet]in.h>

#elif defined(TCPWARE)

#include <socket.h>
#include <netdb.h>
#include <inetiodef.h>
#include <in.h>

#endif

#ifdef __DECC
#pragma message restore
#endif

#ifdef _NNTP_SERVER_C
#define EXTERN extern
#else
#define EXTERN
#endif
EXTERN int read_net    __ARGS((char *, int, int));
EXTERN void write_net  __ARGS((const char *, int));
EXTERN void close_net  __ARGS((void));
EXTERN void getremhost __ARGS((char *, char *, int));
EXTERN void next_call  __ARGS((int, void (*)(int), int));
#undef EXTERN

#ifndef _NNTP_SERVER_C
#define EXTERN extern
#else
#define EXTERN
#endif
EXTERN int  server_init __ARGS((int));
EXTERN void server_init_unit __ARGS((int));
EXTERN void server_shut __ARGS((void));
EXTERN void spool_flush_batch __ARGS((void));
EXTERN void log_to_file __ARGS((int));
EXTERN void close_batch_file __ARGS((void));
#undef EXTERN

#ifdef MULTINET
  /* this doesn't seem to be declared in any header file */
extern unsigned short htons __ARGS((unsigned short));
extern unsigned short ntohs __ARGS((unsigned short));
extern int getpeername __ARGS((short, struct sockaddr *, int *));
#endif

#ifdef UCX
  /* the <in.h> sets:  #define ntohs(x) (x)  and  #define htons(x) (x)
     which conflicts with the documentation.  Either the macros should be
     redefined or macros undefined and the library routines used. */
#define htons(x) ((unsigned short)(((x)<<8)|((x)>>8)))
#define ntohs(x) ((unsigned short)(((x)<<8)|((x)>>8)))
#endif

#ifdef TCPWARE
#ifndef IO$_GETPEERNAME
#define IO$_GETPEERNAME (IO$_ACCESS | (15 << 6))
#endif
#endif

#endif	/* _NNTPINCLUDE_H */
