#ifdef __DECC
#pragma member_alignment save
#pragma nomember_alignment  /* no member alignment - these are VMS structures */
#endif

/* add the following for the second longword */
#define PRV$M_UPGRADE 0x00000001
#define PRV$M_DOWNGRADE 0x00000002
#define PRV$M_GRPPRV 0x00000004
#define PRV$M_READALL 0x00000008
#define PRV$M_SECURITY 0x00000040


/* *** MODULE $UAFDEF *** */
/* ++ */
/* User authorization file format */
/* Note: With the exception of the username and account name, */
/* all strings are blank padded counted strings. Username and */
/* account name are uncounted, blank padded. */
/* -- */
#define UAF$C_USER_ID 1 /* main user ID record */
#define UAF$C_VERSION1 1 /* this version */
#define UAF$C_KEYED_PART 52 /* ISAM keys come this far */
#define UAF$C_AD_II 0 /* AUTODIN-II 32 bit crc code */
#define UAF$C_PURDY 1 /* Purdy polynomial over salted input */
#define UAF$C_PURDY_V 2 /* Purdy polynomial + variable length username */
#define UAF$K_FIXED 644 /* length of fixed portion */
#define UAF$C_FIXED 644 /* length of fixed portion */
#define UAF$K_LENGTH 1412
#define UAF$C_LENGTH 1412
#define UAF$S_UAFDEF 1412

#define UAF$S_USERNAME 32
#define UAF$S_PARENT_ID 8
#define UAF$S_ACCOUNT 32
#define UAF$S_OWNER 32
#define UAF$S_DEFDEV 32
#define UAF$S_DEFDIR 64
#define UAF$S_LGICMD 64
#define UAF$S_DEFCLI 32
#define UAF$S_CLITABLES 32
#define UAF$S_PWD 8
#define UAF$S_PWD2 8
#define UAF$S_EXPIRATION 8
#define UAF$S_PWD_LIFETIME 8
#define UAF$S_PWD_DATE 8
#define UAF$S_PWD2_DATE 8
#define UAF$S_LASTLOGIN_I 8
#define UAF$S_LASTLOGIN_N 8
#define UAF$S_PRIV 8
#define UAF$S_DEF_PRIV 8
#define UAF$S_MIN_CLASS 20
#define UAF$S_MAX_CLASS 20
#define UAF$S_NETWORK_ACCESS_P 3
#define UAF$S_NETWORK_ACCESS_S 3
#define UAF$S_BATCH_ACCESS_P 3
#define UAF$S_BATCH_ACCESS_S 3
#define UAF$S_LOCAL_ACCESS_P 3
#define UAF$S_LOCAL_ACCESS_S 3
#define UAF$S_DIALUP_ACCESS_P 3
#define UAF$S_DIALUP_ACCESS_S 3
#define UAF$S_REMOTE_ACCESS_P 3
#define UAF$S_REMOTE_ACCESS_S 3

struct uaf$r_flags_bits {
  unsigned uaf$v_disctly:1; /* no user control-y */
  unsigned uaf$v_defcli:1; /* only allow user default CLI */
  unsigned uaf$v_lockpwd:1; /* disable SET PASSWORD command */
  unsigned uaf$v_captive:1; /* captive account (no overrides) */
  unsigned uaf$v_disacnt:1; /* no interactive login */
  unsigned uaf$v_diswelcom:1; /* skip welcome message */
  unsigned uaf$v_dismail:1; /* skip new mail message */
  unsigned uaf$v_nomail:1; /* disable mail delivery */
  unsigned uaf$v_genpwd:1; /* passwords must be generated */
  unsigned uaf$v_pwd_expired:1; /* password has expired */
  unsigned uaf$v_pwd2_expired:1; /* 2nd password has expired */
  unsigned uaf$v_audit:1; /* audit all actions */
  unsigned uaf$v_disreport:1; /* skip last login messages */
  unsigned uaf$v_disreconnect:1; /* inhibit reconnections */
  unsigned uaf$v_autologin:1; /* auto-login only */
  unsigned uaf$v_disforce_pwd_change:1; /* disable forced password change */
};

struct uaf$r_primedays_bits {
  unsigned uaf$v_monday:1; /* bit clear means this is a primary day */
  unsigned uaf$v_tuesday:1; /* bit set means this is an off day */
  unsigned uaf$v_wednesday:1; 
  unsigned uaf$v_thursday:1; 
  unsigned uaf$v_friday:1; 
  unsigned uaf$v_saturday:1; 
  unsigned uaf$v_sunday:1; 
};

struct UAFDEF
{
  char uaf$b_rtype; /* UAF record type */
  char uaf$b_version; /* UAF format version */
  short int uaf$w_usrdatoff; /* offset of counted string of user data */
  char uaf$t_username[UAF$S_USERNAME]; /* username */
  union {
    long int uaf$l_uic; /* user ID code */
    struct {
      short int uaf$w_mem; /* member subfield */
      short int uaf$w_grp; /* group subfield */
    } uaf$r_uic_fields;
  } uaf$r_uic_overlay;
  long int uaf$l_sub_id; /* user sub-identifier */
  long int uaf$q_parent_id[2]; /* identifier of owner of this account */
  char uaf$t_account[UAF$S_ACCOUNT]; /* account name */
  char uaf$t_owner[UAF$S_OWNER]; /* owner's name */
  char uaf$t_defdev[UAF$S_DEFDEV]; /* default device */
  char uaf$t_defdir[UAF$S_DEFDIR]; /* default directory */
  char uaf$t_lgicmd[UAF$S_LGICMD]; /* login command file */
  char uaf$t_defcli[UAF$S_DEFCLI]; /* default command interpreter */
  char uaf$t_clitables[UAF$S_CLITABLES]; /* user CLI tables */
  union {
    long int uaf$q_pwd[2];  /* hashed password */
    long int uaf$l_pwd; /* 32 bit subfield */
  } uaf$r_pwd_overlay;
  long int uaf$q_pwd2[2]; /* second password */
  short int uaf$w_logfails; /* count of login failures */
  short int uaf$w_salt; /* random password salt */
  char uaf$b_encrypt; /* encryption algorithm */
/* encryption codes */
  char uaf$b_encrypt2; /* encryption algorithm for 2nd pwd */
  char uaf$b_pwd_length; /* minimum password length */
  char uaf$fill_1;
  long int uaf$q_expiration[2]; /* expiration date for account */
  long int uaf$q_pwd_lifetime[2]; /* password lifetime */
  long int uaf$q_pwd_date[2]; /* date of password change */
  long int uaf$q_pwd2_date[2]; /* date of 2nd password change */
  long int uaf$q_lastlogin_i[2]; /* date of last interactive login */
  long int uaf$q_lastlogin_n[2]; /* date of last non-interactive login */
  union {
    long int uaf$q_priv[2]; /* process privilege vector */
    /* union prvdef uaf$r_priv; */
  } uaf$r_priv_overlay;
  union {
    long int uaf$q_def_priv[2]; /* default process privileges */
    /* union prvdef uaf$r_def_priv; */
  } uaf$r_def_priv_overlay;
  char uaf$r_min_class[UAF$S_MIN_CLASS]; /* minimum security class */
  char uaf$r_max_class[UAF$S_MAX_CLASS]; /* maximum security class */
  union {
    long int uaf$l_flags; /* user flags longword */
    struct uaf$r_flags_bits uaf$r_flags_bits;
  } uaf$r_flags_overlay;
  char uaf$b_network_access_p[UAF$S_NETWORK_ACCESS_P]; /* hourly network access, primary */
  char uaf$b_network_access_s[UAF$S_NETWORK_ACCESS_S]; /* hourly network access, secondary */
  char uaf$b_batch_access_p[UAF$S_BATCH_ACCESS_P]; /* hourly batch access, primary */
  char uaf$b_batch_access_s[UAF$S_BATCH_ACCESS_S]; /* hourly batch access, secondary */
  char uaf$b_local_access_p[UAF$S_LOCAL_ACCESS_P]; /* hourly local access, primary */
  char uaf$b_local_access_s[UAF$S_LOCAL_ACCESS_S]; /* hourly local access, secondary */
  char uaf$b_dialup_access_p[UAF$S_DIALUP_ACCESS_P]; /* hourly dialup access, primary */
  char uaf$b_dialup_access_s[UAF$S_DIALUP_ACCESS_S]; /* hourly dialup access, secondary */
  char uaf$b_remote_access_p[UAF$S_REMOTE_ACCESS_P]; /* hourly remote access, primary */
  char uaf$b_remote_access_s[UAF$S_REMOTE_ACCESS_S]; /* hourly remote access, secondary */
  char uaf$fill_2[514 - 502];
  union {
    char uaf$b_primedays; /* bits representing primary days */
    struct uaf$r_primedays_bits uaf$r_primedays_bits;
  } uaf$r_primedays_overlay;
  char uaf$fill_3[516 - 515];
  char uaf$b_pri; /* base process priority */
  char uaf$b_quepri; /* maximum job queuing priority */
  short int uaf$w_maxjobs; /* maximum jobs for UIC allowed */
/* 0 means no limit */
  short int uaf$w_maxacctjobs; /* maximum jobs for account allowed */
/* 0 means no limit */
  short int uaf$w_maxdetach; /* maximum detached processes for UIC */
/* 0 means no limit */
  short int uaf$w_prccnt; /* subprocess creation limit */
  short int uaf$w_biolm; /* buffered I/O limit */
  short int uaf$w_diolm; /* direct I/O limit */
  short int uaf$w_tqcnt; /* timer queue entry limit */
  short int uaf$w_astlm; /* AST queue limit */
  short int uaf$w_enqlm; /* enqueue limit */
  short int uaf$w_fillm; /* open file limit */
  short int uaf$w_shrfillm; /* shared file limit */
  long int uaf$l_wsquota; /* working set size quota */
  long int uaf$l_dfwscnt; /* default working set size */
  long int uaf$l_wsextent; /* working set size limit */
  long int uaf$l_pgflquota; /* page file quota */
  long int uaf$l_cputim; /* CPU time quota */
  long int uaf$l_bytlm; /* buffered I/O byte count limit */
  long int uaf$l_pbytlm; /* paged buffer I/O byte count limit */
  long int uaf$l_jtquota; /* job-wide logical name table creation quota */
  short int uaf$w_proxy_lim; /* number of proxies user can grant */
  short int uaf$w_proxies; /* number of proxies granted */
  short int uaf$w_account_lim; /* number of sub-accounts allowed */
  short int uaf$w_accounts; /* number of sub-accounts in use */
  char uaf$fill_4[UAF$K_LENGTH - 580];
};

#ifdef __DECC
#pragma member_alignment restore
#endif
