! MMS description file for LIBHTMLW
! Bjorn S. Nilsson, Aleph, CERN, 20-Nov-1993
! (Mosaic version 2.0)
! Motif 1.2 support added on 3-Jun-1994
! Mosaic 2.4 20-Aug-1994
!
! Usage:
!       $ MMS                           for DEC/UCX
!       $ MMS/MACRO=(MULTINET=1)        for Multinet
!       $ MMS/MACRO=(PATHWAY=1)         for Pathway
!	$ MMS/MACRO=(SOCKETSHR=1)	for SOCKETSHR  BGT
! Add a DEBUG=1 macro when debugging.
! Add a DECC=1 macro when compiling with DEC C.
!
! You may have to use the /IGNORE=WARNING qualifier to make MMS run all
! the way through if you get (acceptable) compilation warnings.
!

WDIR = [.$(WORK)]

LIBTARGET = $(WDIR)libhtmlw.olb

.IFDEF PATHWAY
.IFDEF DECC
.INCLUDE [-.TWG]DECC_PREFIX_RULES.MMS
CQUALC=/DECC/Precision=SINGLE $(CC_PREFIX_NO_SIN)
.ELSE
.IFDEF DECCVAXC
CQUALC=/VAXC/Precision=SINGLE
.ELSE
CQUALC=/Precision=SINGLE
.ENDIF
.ENDIF

.ELSE ! Not PATHWAY

.IFDEF SOCKETSHR ! BGT
.IFDEF DECC ! BGT
CQUALC=/DECC/Precision=SINGLE/Prefix=ANSI ! BGT
.ELSE ! BGT
.IFDEF DECCVAXC
CQUALC=/VAXC/Precision=SINGLE
.ELSE
CQUALC=/Precision=SINGLE
.ENDIF
.ENDIF ! BGT

.ELSE ! Not SOCKETSHR

.IFDEF MULTINET
.IFDEF DECC
CQUALC=/DECC/Precision=SINGLE/Prefix=ANSI
.ELSE
.IFDEF DECCVAXC
CQUALC=/VAXC/Precision=SINGLE
.ELSE
CQUALC=/Precision=SINGLE
.ENDIF
.ENDIF

.ELSE ! Not MultiNet

!UCX
.IFDEF DECC
CQUALC=/DECC/Precision=SINGLE/Prefix=All
.ELSE
.IFDEF DECCVAXC
CQUALC=/VAXC/Precision=SINGLE
.ELSE
CQUALC=/Precision=SINGLE
.ENDIF
.ENDIF
.ENDIF
.ENDIF

.ENDIF ! BGT

.IFDEF DEBUG
CFLAGS = $(CQUALC)/NoOpt/Debug
.ELSE
CFLAGS = $(CQUALC)
.ENDIF

.FIRST
        @ If F$Search("$(LIBTARGET)") .EQS. "" Then Library/Create $(LIBTARGET)
	@ Define/NoLog Odir $(WDIR)
.IFDEF PATHWAY
	@ @[-.twg]def
.ELSE
.IFDEF DECC
.IFDEF ALPHA
	@ If F$TRNLNM("ALPHA$LIBRARY") .NES. "" Then Define/NoLog Sys Alpha$Library
.ELSE
	@ If F$TRNLNM("DECC$LIBRARY_INCLUDE") .NES. "" Then Define/NoLog Sys DECC$Library_Include
.ENDIF
.ELSE
	@ Define/NoLog Sys SYS$Library
.ENDIF
.ENDIF

OBJECTS = Odir:HTML-PSformat.obj Odir:HTML.obj Odir:HTMLformat.obj \
 Odir:HTMLimages.obj Odir:HTMLjot.obj Odir:HTMLlists.obj Odir:HTMLparse.obj \
 Odir:HTMLtable.obj Odir:HTMLwidgets.obj Odir:list.obj

$(LIBTARGET) : $(LIBTARGET)($(OBJECTS))
	@ Write SYS$Output "Library libhtmlw.olb built."

Odir:HTML-PSformat.obj : HTML-PSformat.c [-]config.h htmlp.h html.h
Odir:HTML.obj          : HTML.c [-]config.h [-]config_$(WORK).h htmlp.h html.h \
                         [-.libnut]str-tools.h [-.libnut]system.h
Odir:HTMLformat.obj    : HTMLformat.c [-]config.h htmlp.h html.h
Odir:HTMLimages.obj    : HTMLimages.c [-]config.h htmlp.h html.h noimage.xbm \
                         delayedimage.xbm anchoredimage.xbm
Odir:HTMLjot.obj       : HTMLjot.c [-]config.h inkstore.h htmlp.h html.h
Odir:HTMLlists.obj     : HTMLlists.c [-]config.h html.h
Odir:HTMLparse.obj     : HTMLparse.c [-]config.h html.h htmlamp.h
Odir:HTMLtable.obj     : HTMLtable.c [-]config.h htmlp.h html.h list.h
Odir:HTMLwidgets.obj   : HTMLwidgets.c [-]config.h [-]config_$(WORK).h \
			 [-.libnut]str-tools.h htmlp.h html.h
Odir:list.obj          : list.c listp.h list.h [-]config.h

.c.obj :
	$(CC)$(CFLAGS)/OBJECT=$@ $<

.obj.olb
	$(LIBR) $(LIBRFLAGS) $(MMS$TARGET) $(MMS$SOURCE)

clean :
	Delete/Log $(WDIR)*.OBJ;*
	Delete/Log $(LIBTARGET);*

