$! Create Mosaic version 2.7 on VMS.
$! This command procedure compiles and links Mosaic with MMS or MMK if
$! either is available, otherwise it just compiles and links in one go.
$!
$! Debugging is invoked if P1 is set to DEBUG.  P2 can specify the TCP/IP
$! package (MULTINET, UCX, PATHWAY, SOCKETSHR).  MMS parameters can be added
$! in P3 (e.g. /IGNORE=WARNING to make MMS ignore compilation warnings).
$! Additional arguments (e.g. NOWAIS, VAXC, NOMMS, NOUCX) can be specified
$! in P4 thru P8.
$!
$! Bjrn S. Nilsson, 25-Nov-1993
$! Motif 1.2 sensitivity added 2-June-1994
$! Mosaic 2.4 with WAIS Dec. 1994
$! Mosaic 2.6, Oct. 1995, George Cook
$! Combined build procedure, Nov. 1995, George Cook
$!
$!---------------------------------------------------------------------------
$!
$! Define your home page, default print command, mail prefix, etc. here:
$!
$ HOME_PAGE     ="http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/NCSAMosaicHome.html"
$ PRINT_COMMAND ="Print/Name=\""""""""From Mosaic\""""""""/Notify/Identify/Delete"
$ MAIL_PREFIX   ="in%"
$! MAIL_PREFIX   ="smtp%"    ! Uncomment this for native UCX
$ EDIT_COMMAND  ="Edit"
$ NEWS_HOST     =""
$ POSTSCRIPT_VIEWER ="View/interface=decwindows/format=ps %s"
$! POSTSCRIPT_VIEWER ="gv %s"      ! Uncomment to use Ghostview
$!
$!---------------------------------------------------------------------------
$!
$ Verify = F$Verify(0)
$ On Error Then Goto The_End
$ On Control_Y Then Goto EndY
$ Set Symbol/Scope=(NoGlobal,NoLocal)
$ pwd = F$Environment("Default")
$ Set Default 'F$Element (0, "]", F$Environment("PROCEDURE"))']
$ If P2 .EQS. "?" .OR. P2 .EQS. "HELP"
$  Then
$   Write sys$output "Specify UCX, CMU, MULTINET, PATHWAY or SOCKETSHR."
$   Goto The_End
$  Endif
$ If P1 .EQS. "?" .OR. P1 .EQS. "HELP"
$  Then
$   Write sys$output "Specify DEBUG in P1 to build with debugging."
$   Write sys$output -
     "Specify the TCP/IP package (UCX, CMU, MULTINET, PATHWAY or SOCKETSHR) in P2."
$   Write sys$output "Specify MMS parameters (e.g. /IGNORE=WARNING) in P3."
$   Write sys$output -
        "Specify additional arguments (e.g. VAXC, NOMMS) in P4 thru P8."
$   Goto The_End
$  Endif
$ Args = ""
$ If P4 .NES. "" then Args = P4 + ","
$ If P5 .NES. "" then Args = Args + P5 + ","
$ If P6 .NES. "" then Args = Args + P6 + ","
$ If P7 .NES. "" then Args = Args + P7 + ","
$ If P8 .NES. "" then Args = Args + P8 + ","
$ Args = F$Edit(Args,"Collapse,UPCase")
$ Macro = "("
$ If F$Locate("NOWAIS",Args) .NE. F$Length(Args) -
	Then Macro = Macro + "NOWAIS=1,"
$!
$ On Warning Then Platform = "VAX"
$ Platform = F$GetSYI("Arch_Name")
$ On Error Then Goto The_End
$ If Platform .EQS. "Alpha"
$  Then
$   Macro = Macro + "AXP=1,ALPHA=1,"
$   Work = "A"
$  Else
$   Work = "V"
$  Endif
$ If F$Search("SYS$System:DECC$Compiler.Exe") .NES. ""
$  Then
$   If (Platform .EQS. "Alpha") .OR. ((Platform .EQS. "VAX") .AND. -
	((F$Trnlnm("DECC$LIBRARY_INCLUDE") .NES. "") .OR. -
	(F$Trnlnm("DECC$CC_DEFAULT") .NES. "")))
$    Then
$     Compiler = "DECC"
$     Macro = Macro + "DECC=1,"
$    Else
$     Write sys$output "DEC C does not appear to be properly installed on"
$     Write sys$output "this system.  Check if SYS$STARTUP:CCXX$STARTUP.COM"
$     Write sys$output "was executed.  Will attempt to use VAX C."
$     Compiler = "VAXC"
$    Endif
$  Else
$    If Platform .EQS. "Alpha"
$     Then
$      Write sys$output "Aborting because DEC C does not appear to be"
$      Write sys$output "installed on this system."
$      Goto The_End
$     Else Compiler = "VAXC"
$     Endif
$  Endif
$ Extras = P3
$ If F$GetJPI("","CLINAME") .EQS. "DCL_RECALL" Then Extras = Extras + "/CLI=DCL"
$ If (F$Locate("DEBUG",P1) .EQ. F$Length(P1)) .OR. -
        (F$Locate("NODEBUG",P1) .NE. F$Length(P1))
$  Then
$   COpt = "/Optim"
$   LOpt = "/NoTrace"
$   VMS_Debug = 0
$  Else
$   COpt = "/NoOptim/Debug"
$   LOpt = "/Debug"
$   VMS_Debug = 1
$   Macro = Macro + "DEBUG=1,"
$   Work = "D" + Work
$  EndIf
$ If Compiler .EQS. "DECC"
$  Then
$   If (F$Locate("VAXC",Args) .EQ. F$Length(Args)) .OR. (Platform .NES "VAX")
$    Then
$     COpt_NoVAXC = "/DECC" + COpt
$     COpt = "/DECC/Standard=VAXC/PRECISION=SINGLE" + COpt
$    Else
$     Compiler = "VAXC"
$     COpt = "/VAXC/PRECISION=SINGLE" + COpt
$     COpt_NoVAXC = COpt
$     Macro = Macro - "DECC=1,"
$     Macro = Macro + "DECCVAXC=1,"
$    Endif
$  Else
$   COpt_NoVAXC = COpt + "/PRECISION=SINGLE"
$  Endif
$ If Compiler .EQS. "VAXC" Then Work = Work + "C"
$!
$ If P2 .EQS. ""
$ Then
$  IP = "UCX"
$  If F$Trnlnm("CMU") .NES. ""
$   Then
$    IP = "CMU"
$    Goto ip_done
$   Endif
$  If F$Trnlnm("MULTINET") .NES. ""
$   Then
$    IP = "MULTINET_UCX"
$    Goto ip_done
$   Endif
$  If F$Trnlnm("TWG$TCP") .NES. ""
$   Then
$    IP = "PATHWAY_UCX"
$    Goto ip_done
$   EndIf
$  If F$Trnlnm("SOCKETSHR") .NES. ""
$   Then
$    IP = "SOCKETSHR"
$    Goto ip_done
$   EndIf
$ Else
$  IP = ""
$  IPX = F$Edit(P2,"UPCase")
$  If F$Locate("UCX",IPX) .NE. F$Length(IPX) Then IP ="UCX"
$  If F$Locate("CMU",IPX) .NE. F$Length(IPX) Then IP ="CMU"
$  If F$Locate("MULTINET",IPX) .NE. F$Length(IPX) Then IP ="MULTINET_UCX"
$  If F$Locate("PATHWAY",IPX) .NE. F$Length(IPX) Then IP ="PATHWAY_UCX"
$  If F$Locate("SOCKETSHR",IPX) .NE. F$Length(IPX) Then IP ="SOCKETSHR"
$  If IP .EQS. ""
$   Then
$    Write sys$output "Invalid TCP/IP package specified in P2."
$    Write sys$output -
	"Must be UCX, CMU, MULTINET, PATHWAY or SOCKETSHR."
$    Goto The_End
$   Endif
$ Endif
$Ip_done:
$ If F$Locate("NOUCX",Args) .NE. F$Length(Args) Then IP = IP - "_UCX"
$ Macro = Macro + IP + "=1,"
$ If (IP .EQS. "UCX") .OR. (IP .EQS. "MULTINET_UCX") .OR. (IP .EQS. "CMU") -
	.OR. (IP .EQS. "PATHWAY_UCX") Then Work = Work + "U"
$ If IP .EQS. "MULTINET" Then Work = Work + "M"
$ If IP .EQS. "PATHWAY"
$  Then
$   Work = Work + "P"
$   @[.twg]def.com      ! define the location of PathWay include files
$  Endif
$ If IP .EQS. "SOCKETSHR" Then Work = Work + "S"
$ Macro = Macro + "WORK=" + Work + ","
$!
$ If Compiler .EQS. "DECC"
$  Then
$   If IP .EQS. "MULTINET"
$    Then
$     COpt = COpt + "/PREFIX=ANSI"
$     COpt_NoVAXC = COpt_NoVAXC + "/PREFIX=ANSI"
$    Else
$     COpt = COpt + "/PREFIX=ALL"
$     COpt_NoVAXC = COpt_NoVAXC + "/PREFIX=ALL"
$    Endif
$  Endif
$!
$ If IP .EQS. "SOCKETSHR"
$  Then
$   Define Socketshr_Files -
     "''f$parse(f$trnlnm("SOCKETSHR"),,,"DEVICE")'''f$parse(f$trnlnm("SOCKETSHR"),,,"DIRECTORY")"
$   Write SYS$Output "Will look for the SOCKETSHR include files in the same"
$   Write SYS$Output "location as the SOCKETSHR shareable library."
$   Write SYS$Output " "
$  Endif
$!
$ Motif12 = ""
$ Motif123 = ""
$ Motif124 = ""
$ If F$Search("SYS$Update:DECW$Get_Image_Version.COM") .NES. ""
$  Then
$   Set Symbol/Scope=(Global,Local)
$   @SYS$Update:DECW$Get_Image_Version SYS$Share:DECW$XLibshr.EXE DECW$Version
$   If (F$Length(DECW$Version) .NE. 0) .AND. -
       (F$Locate("V1.2", DECW$Version) .NE. F$Length(DECW$Version))
$    Then
$     Macro = Macro + "MOTIF1_2=1,"
$     Motif12 = "1"
$     If (F$Locate("V1.2-395", DECW$Version) .NE. F$Length(DECW$Version)) .OR. -
         (F$Locate("V1.2-394", DECW$Version) .NE. F$Length(DECW$Version)) .OR. -
         (F$Locate("V1.23", DECW$Version) .NE. F$Length(DECW$Version))
$      Then
$       Write SYS$Output "Your system has Motif 1.2-3 installed.  Due to a bug"
$       Write SYS$Output "in Motif 1.2-3, the hotlist dialog windows may act oddly."
$       Write SYS$Output " "
$       Motif123 = "1"
$      Else
$!	39602 is MOTF07, 39604 is DWMW01
$       If F$Locate("V1.2-3960", DECW$Version) .NE. F$Length(DECW$Version)
$        Then Motif123 = "7"
$        Endif
$      Endif
$     If F$Locate("V1.2-4", DECW$Version) .NE. F$Length(DECW$Version)
$      Then Motif124 = "1"
$      Endif
$     If (Motif123 .EQS. "") .AND. (Motif124 .EQS. "")
$      Then
$       Write SYS$Output "Your system appears to have Motif 1.2 installed.  Due"
$       Write SYS$Output "to various problems with the Motif 1.2 header files,"
$       Write SYS$Output "the build of LIBXMX may fail with warning messages."
$       Write SYS$Output "If no other errors are encountered, the build can"
$       Write SYS$Output "safely be continued.  It is recommended, however,"
$       Write SYS$Output "that you upgrade your system to Motif 1.2-3 and"
$       If Platform .EQS. "Alpha"
$        Then
$	  Write SYS$Output "install patch kit ALPMOTF07_U3012 (for systems"
$	  Write SYS$Output "with Motif Worldwide Support installed, the kit"
$	  Write SYS$Output "is ALPDWMW01_U3012)."
$        Else
$	  Write SYS$Output "install patch kit VAXMOTF07_U3012 (for systems"
$	  Write SYS$Output "with Motif Worldwide Support installed, the kit"
$	  Write SYS$Output "is VAXDWMW01_U3012)."
$        Endif
$       Write SYS$Output " "
$      Endif
$    EndIf
$   Set Symbol/Scope=(NoGlobal,NoLocal)
$  Else
$   Write SYS$Output "You do not seem to have DECW Motif installed correctly!"
    Goto Err
$  EndIf
$!
$ If F$Trnlnm("XMU") .EQS. ""
$  Then   
$   Write SYS$Output -
     "You cannot build Mosaic without the XMU auxiliary library.  It comes as"
$   Write SYS$Output -
     "an optional subset with DECWindows Motif, so you should install that now."
$   Goto Err
$  EndIf
$!
$ If F$Trnlnm("LNK$LIBRARY") .NES. ""
$  Then
$   Write SYS$Output -
     "Logical LNK$LIBRARY is currently defined.  If the link of Mosaic fails,"
$   Write SYS$Output -
     "please deassign all LNK$LIBRARY logicals and rerun the build procedure."
$   Write SYS$Output " "
$  EndIf
$!
$!
$! Create config.h, first the VMS invariant parts.
$!
$ Type$$ sys$input /output=test_config.h
/* config.h.  Generated automatically on VMS by MAKE_MOSAIC.COM.  */
/*            Do not edit this file, it will just be overwritten  */
/*            during the build. */

/* Define to empty if the keyword does not work.  */
/* #undef const */

#define XMOSAIC 1
#define PRERELEASE 1

/* Defines for system types */
/* #undef ALPHA */
/* #undef _BSD */
/* #undef DGUX */
/* #undef NEXT */
/* #undef _HPUX_SOURCE */
/* #undef MO_IRIX5 */
/* #undef SVR4 */
/* #undef SOLARIS */
/* #undef SOLARIS23 */
/* #undef SOLARIS24 */
/* #undef SOLARIS24X86 */
/* #undef SCO */
/* #undef SUN */
/* #undef CONVEX */
/* #undef MOTOROLA */
/* #undef BROKEN_MOTIF */

/* external software packages */
#define HAVE_JPEG 1
#define HAVE_PNG 1
/* #undef HAVE_DTM */
#define HAVE_WAIS 1


/* define to figure motif version (does anybody use 1.0?)*/
#define MOTIF 1
#define MOTIF1_1 1

/* Include the build specific config */
#include <mosaic_config>
$!
$!    The rest of the config has to be customized for each site
$!    and build configuration.  It is placed in a build specific
$!    include file.
$!        
$ Open/write config_file test_config_'work'.h
$ If (Motif12 .EQS. "")
$  Then write config_file "/* #undef MOTIF1_2 */"
$  Else write config_file "#define MOTIF1_2 1"
$ Endif
$ Write config_file "/* #undef MOTIF2_0 */"
$ Write config_file ""
$ Write config_file ""
$ Write config_file "/* These are VMS port specific */"
$ If (Motif123 .EQS. "")
$  Then write config_file "/* #undef MOTIF1_23 */"         
$  Else
$   If (Motif123 .EQS. "7")
$    Then write config_file "#define MOTIF1_23 7"
$    Else write config_file "#define MOTIF1_23 1"
$   Endif
$ Endif
$ If (Motif124 .EQS. "")
$  Then write config_file "/* #undef MOTIF1_24 */"
$  Else write config_file "#define MOTIF1_24 1"
$ Endif
$ Write config_file "#define HOME_PAGE_DEFAULT ""''HOME_PAGE'"""
$ DUMMY_PRINT = "''PRINT_COMMAND'"
$ Write config_file "#define PRINT_DEFAULT ""''DUMMY_PRINT'"""
$ Write config_file "#define MAIL_PREFIX_DEFAULT ""''MAIL_PREFIX'"""
$ Write config_file "#define EDITOR_DEFAULT ""''EDIT_COMMAND'"""
$ Write config_file "#define DEFAULT_NEWS_HOST ""''NEWS_HOST'"""
$ Write config_file "#define DEFAULT_PS_VIEWER ""''POSTSCRIPT_VIEWER'"""
$!
$ If (IP .eqs. "UCX") .or. (IP .eqs. "MULTINET_UCX") .or. (IP .eqs. "CMU") -
	.or. (IP .eqs. "PATHWAY_UCX")
$  Then write config_file "#define UCX 1"
$  Else write config_file "/* #undef UCX */"
$ Endif
$ If IP .eqs. "MULTINET"
$  Then write config_file "#define MULTINET 1"
$  Else write config_file "/* #undef MULTINET */"
$ Endif
$ If IP .eqs. "PATHWAY"
$  Then write config_file "#define WIN_TCP 1"
$  Else write config_file "/* #undef WIN_TCP */"
$ Endif
$ If IP .eqs. "SOCKETSHR"
$  Then write config_file "#define SOCKETSHR 1"
$  Else write config_file "/* #undef SOCKETSHR */"
$ Endif
$ If (IP .eqs. "MULTINET_UCX") .or. (IP .eqs. "CMU") -
	.or. (IP .eqs. "PATHWAY_UCX")
$  Then write config_file "#define UCX_COMPAT 1"
$  Else write config_file "/* #undef UCX_COMPAT */"
$ Endif
$ If VMS_Debug .EQ. 1
$  Then write config_file "#define DEBUGVMS 1"
$  Else write config_file "/* #undef DEBUGVMS */"
$ Endif
$ Write config_file "/* Given HAVE_WAIS defined above, do we need this? */"
$ Write config_file "#define DIRECT_WAIS 1"
$ Close config_file
$!
$ Open/write config_file Built_'work'.h
$ Write config_file "#define BUILD_TIME ""''f$time()'"""
$ Close config_file
$!
$! Don't want to create a new config.h on every build or MMS will rebuild
$! everything.  Update only if it changed.
$ If f$search ("config.h") .eqs ""
$  Then rename test_config.h config.h
$  Else
$     Set noon
$     Differ/out=nl: test_config.h config.h
$     Diff_err = $severity
$     Set on
$     If diff_err .eq. 1
$      Then delete test_config.h;*
$      Else rename test_config.h config.h
$     Endif
$ Endif
$!
$ If f$search ("config_''work'.h") .eqs ""
$  Then rename test_config_'work'.h config_'work'.h
$  Else
$     Set noon
$     Differ/out=nl: test_config_'work'.h config_'work'.h
$     Diff_err = $severity
$     Set on
$     If diff_err .eq. 1
$      Then delete test_config_'work'.h;*
$      Else rename test_config_'work'.h config_'work'.h
$     Endif
$ Endif
$!
$ Define mosaic_config "''f$environment("default")config_''work'.h"
$ Define mosaic_built "''f$environment("default")built_''work'.h"
$!
$ If F$Locate("NOMMS",Args) .NE. F$Length(Args) Then Goto No_mms
$ If F$Search("SYS$System:MMS.Exe") .NES. ""
$  Then
$   Command = "MMS"
$  Else
$    If F$Search("MMK_DIR:MMK.Exe") .NES. ""
$     Then
$      Macro = Macro + "USE_MMK=1,"
$      Command = "MMK"
$     Else
$      Write SYS$Output "Neither MMS or MMK appears to be available."
$      Write SYS$Output "Proceeding with complete (re)build."
$      Write SYS$Output " "
$      Goto No_mms
$     EndIf
$  EndIf
$!
$! Do MMS or MMK build
$!            
$ Quals = Extras
$ If Macro .NES. "("
$  Then
$   Quals = Quals + "/Skip/Macro=" + Macro + ")"
$   Quals = Quals - ",)"
$   Quals = Quals + ")"
$  EndIf
$! MMS needs global symbols enabled
$ Set Symbol/Scope=(Global,NoLocal)
$! Define before deleting to avoid warning messages
$ Cmu:==
$ Multinet:==
$ Pathway:==
$ Socketshr:==
$ Delete/symbol/global Cmu
$ Delete/symbol/global Multinet
$ Delete/symbol/global Pathway
$ Delete/symbol/global Socketshr
$ Delete/symbol/local Macro
$!
$! Run MMS or MMK now
$!
$ Write SYS$Output "''Command' will be invoked as ''Command'''Quals'"
$ If Command .EQS. "MMS"
$  Then MMS'Quals'
$  Else MMK'Quals'
$  EndIf
$ Goto The_End
$!
$No_mms:
$ If F$Locate("DEB",Args) .NE. F$Length(Args) Then Show Symbol/Local *
$ If F$Locate("CLEAN",Args) .NE. F$Length(Args) Then Goto No_mms_clean
$ LibWAIS = ""
$ WAISD = ""
$ If IP .NES. "PATHWAY"
$  Then
$   If Compiler .EQS. "DECC"
$    Then
$     If Platform .EQS. "VAX"
$      Then If F$Trnlnm("DECC$LIBRARY_INCLUDE") .NES. "" Then Define Sys DECC$Library_Include
$      Else If F$Trnlnm("ALPHA$LIBRARY") .NES. "" Then Define Sys Alpha$Library
$      Endif
$    Else Define Sys SYS$Library
$    Endif
$  Endif
$ Verify = F$Verify(1)
$ If F$Locate("NOWAIS",Args) .NE. F$Length(Args) Then GoTo After_WAIS
$!
$! Create [.freeWAIS-0_5.ir]libWAIS.olb
$!
$ Set Default [.freeWAIS-0_5.ir]
$ If F$Search("libWAIS.olb") .EQS. "" Then Library/Create/Log libWAIS.olb
$ Comp = "CC" + COpt_NoVAXC + "/Define=''IP'"
$ 'Comp' cutil.c
$ 'Comp' futil.c
$ 'Comp' panic.c
$ 'Comp' ui.c
$ 'Comp' wmessage.c
$ 'Comp' wprot.c
$ 'Comp' wutil.c
$ 'Comp' zprot.c
$ 'Comp' ztype1.c
$ 'Comp' zutil.c
$ Library/Replace/Log libWAIS.olb *.obj
$ LibWAIS = ",[-.freeWAIS-0_5.ir]libWAIS.olb/Lib"
$ WAISD = "DIRECT_WAIS,"
$ Define WAIS_IR 'F$Environment("Default")'
$ Set Default [-.-]
$After_WAIS:
$!
$! Create [.libwww2]libwww.olb
$!
$ Set Default [.libwww2]
$ If F$Search("libwww.olb") .EQS. "" Then Library/Create/Log libwww.olb
$ Comp = "CC" + COpt
$ 'Comp' HTAABrow.c
$ 'Comp' HTAAUtil.c
$ 'Comp' HTAccess.c
$ 'Comp' HTAlert.c
$ 'Comp' HTAnchor.c
$ 'Comp' HTAssoc.c
$ 'Comp' HTAtom.c
$ 'Comp' HTChunk.c
$ 'Comp' HTCompressed.c
$ 'Comp' HTFile.c
$ 'Comp' HTFormat.c
$ 'Comp' HTFTP.c
$ 'Comp' HTFWriter
$ 'Comp' HTGopher.c
$ 'Comp' HTIcon.c
$ 'Comp' HTInit.c
$ 'Comp' HTList.c
$ 'Comp' HTMailto.c
$ 'Comp' HTMIME.c
$ 'Comp' HTML.c
$ 'Comp' HTMLDTD.c
$ 'Comp' HTMLGen
$ 'Comp' HTMosaicHTML.c
$ 'Comp' HTNews.c
$ 'Comp' HTParse.c
$ 'Comp' HTPlain.c
$ 'Comp' HTSort.c
$ 'Comp' HTString.c
$ 'Comp' HTTCP.c
$ 'Comp' HTTelnet.c
$ 'Comp' HTTP.c
$ 'Comp' HTUU.c
$ 'Comp' HTWriter.c
$ If F$Locate("NOWAIS",Args) .EQ. F$Length(Args) Then 'Comp' HTWSRC.c
$ 'Comp' SGML.c
$ If F$Locate("NOWAIS",Args) .EQ. F$Length(Args)
$  Then
$   If Compiler .EQS. "DECC"
$    Then
$     Define DECC$User_Include 'F$Environment("Default")',WAIS_IR
$     Define DECC$System_Include 'F$Environment("Default")',WAIS_IR
$    Else
$     Define VAXC$Include 'F$Environment("Default")',WAIS_IR,SYS$Library
$     Define C$Include 'F$Environment("Default")',WAIS_IR
$    EndIf
$   'Comp' HTWAIS.c
$  EndIf
$ Library/Replace/Log libwww.olb *.obj
$!
$! Create [.libhtmlw]libhtmlw.olb
$!
$ Set Default [-.libhtmlw]
$ If F$Search("libhtmlw.olb") .EQS. "" Then Library/Create/Log libhtmlw.olb
$ Comp = "CC" + COpt
$ 'Comp' HTML-PSformat.c
$ 'Comp' HTML.c
$ 'Comp' HTMLformat.c
$ 'Comp' HTMLimages.c
$ 'Comp' HTMLjot.c
$ 'Comp' HTMLlists.c
$ 'Comp' HTMLparse.c
$ 'Comp' HTMLtable.c
$ 'Comp' HTMLwidgets.c
$ 'Comp' LIST.c
$ Library/Replace/Log libhtmlw.olb *.obj
$!
$! Create [.libxmx]libxmx.olb
$!
$ Set Default [-.libXmx]
$ If F$Search("libXmx.olb") .EQS. "" Then Library/Create/Log libXmx.olb
$ Comp = "CC" + COpt_NoVAXC
$ 'Comp' Xmx.c
$ 'Comp' Xmx2.c
$ Library/Replace/Log libXmx.olb *.obj
$!
$! Create [.libjpeg]libjpeg.olb
$!
$ Set Default [-.libjpeg]
$ @Makefile.com 'Macro'
$!
$! Create [.libnut]libnut.olb
$!
$ Set Default [-.libnut]
$ If F$Search("libnut.olb") .EQS. "" Then Library/Create/Log libnut.olb
$ Comp = "CC" + COpt_NoVAXC
$ 'Comp' ellipsis.c
$ 'Comp' mm.c
$ 'Comp' str-tools.c
$ 'Comp' system.c
$ 'Comp' url-utils.c
$ Library/Replace/Log libnut.olb *.obj
$!
$! Create [.libpng]libpng.olb
$!
$ Set Default [-.libpng]
$ If F$Search("libpng.olb") .EQS. "" Then Library/Create/Log libpng.olb
$ Comp = "CC" + COpt_NoVAXC + "/INCLUDE=[.ZLIB]"
$ 'Comp' png.c
$ 'Comp' pngpread.c
$ 'Comp' pngrcb.c
$ 'Comp' pngrutil.c
$ 'Comp' pngtrans.c
$ 'Comp' pngwutil.c
$ 'Comp' pngread.c
$ 'Comp' pngmem.c
$ 'Comp' pngwrite.c
$ 'Comp' pngrtran.c
$ 'Comp' pngwtran.c
$ 'Comp' pngrio.c
$ 'Comp' pngwio.c
$ 'Comp' pngerror.c
$ Library/Replace/Log libpng.olb *.obj
$!
$! Create [.libpng.zlib]libz.olb
$!
$ Set Default [.zlib]
$ If F$Search("libz.olb") .EQS. "" Then Library/Create/Log libz.olb
$ Comp = "CC" + COpt_NoVAXC
$ 'Comp' adler32.c
$ 'Comp' compress.c
$ 'Comp' crc32.c
$ 'Comp' gzio.c
$ 'Comp' uncompr.c
$ 'Comp' deflate.c
$ 'Comp' trees.c
$ 'Comp' zutil.c
$ 'Comp' inflate.c
$ 'Comp' infblock.c
$ 'Comp' inftrees.c
$ 'Comp' infcodes.c
$ 'Comp' infutil.c
$ 'Comp' inffast.c
$ Library/Replace/Log libz.olb *.obj
$ Set Default [-]
$!
$! Create [.libvms]libvms.olb
$!
$ Set Default [-.libvms]
$ If F$Search("libvms.olb") .EQS. "" Then Library/Create/Log libvms.olb
$ Comp = "CC" + COpt_NoVAXC
$ 'Comp' cmdline.c
$ Set Command/Object mosaic_cld.cld
$ Library/Replace/Log libvms.olb *.obj
$ Edit/Tpu/Nosection/Nodisplay/Command=cvthelp.tpu mosaic.help
$ Runoff/Output=[-]mosaic.hlp mosaic.rnh
$ If (IP .EQS. "CMU") .AND. (Compiler .EQS. "VAXC")
$  Then
$   If F$Search("ucx$ipc.olb") .EQS. "" Then Library/Create/Log ucx$ipc.olb
$   Macro/Object=ucx$crtlibxfr.obj ucx$crtlibxfr.mar
$   Library/Replace/Log ucx$ipc.olb ucx$crtlibxfr.obj
$  Endif
$!
$! Compile the [.src] modules.
$!
$ Set Default [-.src]
$ Comp = "CC" + COpt
$ If F$Search("src.olb") .EQS. "" Then Library/Create/Log src.olb
$ Topdir = F$Environment("Default")-"SRC]"
$ Define LIBWWW2   'Topdir'LIBWWW2]
$ Define LIBXMX    'Topdir'LIBXMX]
$ Define LIBHTMLW  'Topdir'LIBHTMLW]
$ Define LIBJPEG   'Topdir'LIBJPEG]
$ Define LIBNUT    'Topdir'LIBNUT]
$ Define LIBPNG    'Topdir'LIBPNG]
$ Define ZLIB      'Topdir'LIBPNG.ZLIB]
$ Define LIBVMS    'Topdir'LIBVMS]
$ If Compiler .EQS. "DECC"
$  Then
$   Define/nolog DECC$User_Include 'F$Environment("Default")', -
        LIBWWW2,LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS
$   Define/nolog DECC$System_Include 'F$Environment("Default")', -
        LIBWWW2,LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS
$  Else
$   Define/nolog VAXC$Include 'F$Environment("Default")', -
        LIBWWW2,LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS$Library
$   Define/nolog C$Include 'F$Environment("Default")', -
        LIBWWW2,LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS$Library
$  EndIf
$ 'Comp' accept.c
$ 'Comp' annotate.c
$ 'Comp' audan.c
$ 'Comp' bla.c
$ 'Comp' ccibindings.c
$ 'Comp' ccibindings2.c
$ 'Comp' cciserver.c
$ 'Comp' child.c
$ 'Comp' comment.c
$ 'Comp' gifread.c
$ 'Comp' globalhist.c
$ 'Comp' grpan-www.c
$ 'Comp' grpan.c
$ 'Comp' gui-dialogs.c
$ 'Comp' gui-documents.c
$ 'Comp' gui-extras.c
$ 'Comp' gui-ftp.c
$ 'Comp' gui-menubar.c
$ 'Comp' gui-news.c
$ 'Comp' gui-popup.c
$ 'Comp' gui.c
$ 'Comp' history.c
$ 'Comp' hotfile.c
$ 'Comp' hotlist.c
$ 'Comp' img.c
$ 'Comp' kcms.c
$ 'Comp' mailto.c
$ 'Comp' main.c
$ 'Comp' md5.c
$ 'Comp' medcut.c
$ 'Comp' mo-hdf.c
$ 'Comp' mo-dtm.c
$ 'Comp' mo-www.c
$ 'Comp' newsrc.c
$ 'Comp' pan.c
$ 'Comp' picread.c
$ 'Comp' pixmaps.c
$ 'Comp' prefs.c
$ 'Comp' proxy-dialogs.c
$ 'Comp' proxy-misc.c
$ 'Comp' readjpeg.c
$ 'Comp' readpng.c
$ 'Comp' support.c
$ 'Comp' xpmhash.c
$ 'Comp' xpmread.c
$ Library/Replace/Log src.olb *.obj
$!
$! Finally link ...
$!
$ Optfile = "''IP'.Opt"
$ If IP .EQS. "UCX"
$  Then
$   If Compiler .EQS. "DECC"
$    Then Optfile = "UCX_DECC.Opt"
$    Else Optfile = "UCX_VAXC.Opt"
$    Endif
$  EndIf
$ If IP .EQS. "CMU"
$  Then
$   If Compiler .EQS. "DECC"
$    Then Optfile = "CMU_UCX_DECC.Opt"
$    Else Optfile = "CMU_UCX_VAXC.Opt"
$    Endif
$  EndIf
$ If IP .EQS. "PATHWAY_UCX"
$  Then
$   If Compiler .EQS. "DECC"
$    Then Optfile = "PATHWAY_UCX_DECC.Opt"
$    Else Optfile = "PATHWAY_UCX_VAXC.Opt"
$    Endif
$  EndIf
$ If Motif12 .NES. ""
$  Then XMOptfile = "Motif1_2.Opt"
$  Else XMOptfile = "Motif1_1.Opt"
$  Endif
$ Link'LOpt'/Exe=mosaic.exe src.olb/Lib/Inc=(main,mailto,md5),-
   [-.libhtmlw]libhtmlw.olb/Lib,[-.libxmx]libxmx.olb/Lib,-
   [-.libwww2]libwww.olb/Lib,[-.libjpeg]libjpeg.olb/Lib'LibWAIS',-
   [-.libnut]libnut.olb/Lib,[-.libpng]libpng.olb/Lib,-
   [-.libpng.zlib]libz.olb/Lib,[-.libvms]libvms.olb/Lib,-
   []'Optfile'/Opt,'XMOptfile'/Opt
$ xxx = F$Verify(Verify)
$ Set Default [-]
$ Write SYS$Output "Linking done.  Welcome to VMS Mosaic 2.7-5"
$ Write SYS$Output "The executable is in [.src]Mosaic.exe"
$ Dir/Date=Modif/Size=All [.src]Mosaic.exe
$ Goto The_End
$No_mms_clean:
$ Purge Mosaic.hlp
$ Purge *.h
$ Purge [.src]Mosaic.exe
$ Delete [.src]*.obj;*
$ Delete [.src]*.olb;*
$ Delete [.freewais-0_5.ir]*.obj;*
$ Delete [.freewais-0_5.ir]*.olb;*
$ Delete [.libwww2]*.obj;*
$ Delete [.libwww2]*.olb;*
$ Delete [.libxmx]*.obj;*
$ Delete [.libxmx]*.olb;*
$ Delete [.libhtmlw]*.obj;*
$ Delete [.libhtmlw]*.olb;*
$ Delete [.libnut]*.obj;*
$ Delete [.libnut]*.olb;*
$ Delete [.libjpeg]*.obj;*
$ Delete [.libjpeg]*.olb;*
$ Purge [.libjpeg]*.exe;*
$ Delete [.libpng]*.obj;*
$ Delete [.libpng]*.olb;*
$ Delete [.libpng.zlib]*.obj;*
$ Delete [.libpng.zlib]*.olb;*
$ Delete [.libvms]*.obj;*
$ Delete [.libvms]*.olb;*
$ Delete [.libvms]*.rnh;*
$ Write SYS$Output "Cleanup completed."
$ Goto The_End
$EndY:
$ Write SYS$Output "Execution interrupted..."
$Err:
$The_End:
$ xxx = F$Verify(Verify)
$ If F$Trnlnm("SYS","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process SYS
$ If F$Trnlnm("NETINET","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process NETINET
$ If F$Trnlnm("LIBHTMLW","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBHTMLW
$ If F$Trnlnm("LIBWWW2","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBWWW2
$ If F$Trnlnm("LIBXMX","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBXMX
$ If F$Trnlnm("LIBJPEG","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBJPEG
$ If F$Trnlnm("LIBNUT","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBNUT
$ If F$Trnlnm("LIBPNG","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBPNG
$ If F$Trnlnm("ZLIB","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process ZLIB
$ If F$Trnlnm("DECC$User_Include","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process DECC$User_Include
$ If F$Trnlnm("DECC$System_Include","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process DECC$System_Include
$ If F$Trnlnm("VAXC$Include","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process VAXC$Include
$ If F$Trnlnm("C$Include","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process C$Include
$ If F$Trnlnm("WAIS_IR","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process WAIS_IR
$ If F$Trnlnm("SOCKETSHR_FILES","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process SOCKETSHR_FILES
$ If F$Trnlnm("MOSAIC_CONFIG","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process MOSAIC_CONFIG
$ If F$Trnlnm("MOSAIC_BUILT","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process MOSAIC_BUILT
$ Set Default 'pwd'
$ Exit
