 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                   DDDD   EEEEE   CCCC   OOO   DDDD   EEEEE                  % O %                   D   D  E      C      O   O  D   D  E                      % O %                   D   D  EEE    C      O   O  D   D  EEE                    % O %                   D   D  E      C      O   O  D   D  E                      % O %                   DDDD   EEEEE   CCCC   OOO   DDDD   EEEEE                  % O %                                                                             % O %                                                                             % O %                    Utility Routines to Read Image Formats                   % O %                                                                             % O %                                                                             % O %                             Software Design                                 % O %                               John Cristy                                   % O %                              January 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright 1996 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Functions in this library convert to and from `alien' image formats to the  %  MIFF image format.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "XWDFile.h"   /*   Define declarations. */- #define LoadImageText  "  Loading image...  " & #define PrematureExit(message,image) \ { \ %   Warning(message,image->filename); \    DestroyImages(image); \    return((Image *) NULL); \  }    /*   Function prototypes. */ static Image$   *ReadMIFFImage(const ImageInfo *),#   *ReadPNMImage(const ImageInfo *), "   *ReadXCImage(const ImageInfo *);   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d A V S I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadAVSImage reads a AVS X image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadAVSImage routine is:  % % %      image=ReadAVSImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadAVSImage returns a pointer to the image after N %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadAVSImage(const ImageInfo *image_info)  {    typedef struct _AVSHeader    {      int        width,
       height;    } AVSHeader;     AVSHeader      avs_header;      Image      *image;   	   Quantum 	     blue, 
     green,     red;     register int     x,     y;     register RunlengthPacket     *q;      unsigned int     packets,     status;      unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Read AVS image.    */J   status=ReadData((char *) &avs_header,1,(unsigned int) sizeof(AVSHeader),     image->file);    if (status == False)0     PrematureExit("Not a AVS image file",image);   do   {      /*!       Initialize image structure.      */     image->matte=True;$     image->columns=avs_header.width;"     image->rows=avs_header.height;     image->packets=0; 7     packets=Max((image->columns*image->rows+4) >> 3,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert AVS raster image to runlength-encoded packets.     */     q=image->pixels;     q->length=MaxRunlength; #     for (y=0; y < image->rows; y++)      { (       for (x=0; x < image->columns; x++)       { (         index=Opaque-fgetc(image->file);(         red=UpScale(fgetc(image->file));*         green=UpScale(fgetc(image->file));)         blue=UpScale(fgetc(image->file)); J         if ((red == q->red) && (green == q->green) && (blue == q->blue) &&D             (index == q->index) && ((int) q->length < MaxRunlength))           q->length++;         else           { $             if (image->packets != 0)               q++;             image->packets++; *             if (image->packets == packets)               {                  packets<<=1;B                 image->pixels=(RunlengthPacket *) realloc((char *)A                   image->pixels,packets*sizeof(RunlengthPacket)); >                 if (image->pixels == (RunlengthPacket *) NULL)C                   PrematureExit("Unable to allocate memory",image); 1                 q=image->pixels+image->packets-1;                }              q->red=red;              q->green=green;              q->blue=blue;              q->index=index;              q->length=0;           }        } 3       ProgressMonitor(LoadImageText,y,image->rows);      } %     image->pixels=(RunlengthPacket *) M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket)); L     status=ReadData((char *) &avs_header,1,(unsigned int) sizeof(AVSHeader),       image->file);      if (status == True)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status == True); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d B M P I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadBMPImage reads a Microsoft Windows bitmap image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadBMPImage routine is:  % % %      image=ReadBMPImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadBMPImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadBMPImage(const ImageInfo *image_info)  {    typedef struct _BMPHeader    {      unsigned long        file_size;       unsigned short       reserved[2];       unsigned long        offset_bits,       size,        width,
       height;        unsigned short
       planes,        bit_count;       unsigned long        compression,       image_size,        x_pixels,        y_pixels,        number_colors,       colors_important;    } BMPHeader;     BMPHeader      bmp_header;      Image      *image;      register int     bit,     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *bmp_data,     *bmp_pixels,     magick[12];      unsigned int     bytes_per_line,      start_position,      status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*$     Determine if this is a BMP file.   */3   status=ReadData((char *) magick,1,2,image->file);    do   {      /*       Verify BMP identifier.     */(     start_position=ftell(image->file)-2;D     if ((status == False) || (strncmp((char *) magick,"BM",2) != 0))2       PrematureExit("Not a BMP image file",image);7     bmp_header.file_size=LSBFirstReadLong(image->file); :     bmp_header.reserved[0]=LSBFirstReadShort(image->file);:     bmp_header.reserved[1]=LSBFirstReadShort(image->file);9     bmp_header.offset_bits=LSBFirstReadLong(image->file); 2     bmp_header.size=LSBFirstReadLong(image->file);     if (bmp_header.size == 12)       { 
         /*           OS/2 BMP image file.
         */H         bmp_header.width=(unsigned long) LSBFirstReadShort(image->file);I         bmp_header.height=(unsigned long) LSBFirstReadShort(image->file); 9         bmp_header.planes=LSBFirstReadShort(image->file); <         bmp_header.bit_count=LSBFirstReadShort(image->file);#         bmp_header.number_colors=0; !         bmp_header.compression=0;           bmp_header.image_size=0;       }      else       { 
         /*+           Microsoft Windows BMP image file. 
         */7         bmp_header.width=LSBFirstReadLong(image->file); 8         bmp_header.height=LSBFirstReadLong(image->file);9         bmp_header.planes=LSBFirstReadShort(image->file); <         bmp_header.bit_count=LSBFirstReadShort(image->file);=         bmp_header.compression=LSBFirstReadLong(image->file); <         bmp_header.image_size=LSBFirstReadLong(image->file);:         bmp_header.x_pixels=LSBFirstReadLong(image->file);:         bmp_header.y_pixels=LSBFirstReadLong(image->file);?         bmp_header.number_colors=LSBFirstReadLong(image->file); B         bmp_header.colors_important=LSBFirstReadLong(image->file);6         for (i=0; i < ((int) bmp_header.size-40); i++)$           (void) fgetc(image->file);       } "     if (bmp_header.bit_count < 24)       {          unsigned char            *bmp_colormap;           unsigned int           packet_size;  
         /*#           Read BMP raster colormap. 
         */!         image->class=PseudoClass; /         image->colors=bmp_header.number_colors;          if (image->colors == 0) 2           image->colors=1 << bmp_header.bit_count;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));&         bmp_colormap=(unsigned char *)8           malloc(4*image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||5             (bmp_colormap == (unsigned char *) NULL)) ;           PrematureExit("Unable to allocate memory",image);          packet_size=4;"         if (bmp_header.size == 12)           packet_size=3;H         (void) ReadData((char *) bmp_colormap,packet_size,image->colors,           image->file);          p=bmp_colormap; )         for (i=0; i < image->colors; i++) 	         { 0           image->colormap[i].blue=UpScale(*p++);1           image->colormap[i].green=UpScale(*p++); /           image->colormap[i].red=UpScale(*p++); $           if (bmp_header.size != 12)             p++;	         } $         free((char *) bmp_colormap);       }      /*       Read image data.     */H     while (ftell(image->file) < (start_position+bmp_header.offset_bits))        (void) fgetc(image->file);#     if (bmp_header.image_size == 0)        bmp_header.image_size=L         ((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height;     bmp_data=(unsigned char *):       malloc(bmp_header.image_size*sizeof(unsigned char));+     if (bmp_data == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image); M     (void) ReadData((char *) bmp_data,1,(unsigned int) bmp_header.image_size,        image->file);      bmp_pixels=bmp_data;$     if (bmp_header.compression != 0)       {          unsigned int           packets;  
         /*3           Convert run-length encoded raster pixels. 
         */         packets=N           ((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height;(         if (bmp_header.compression == 2)           packets<<=1;K         bmp_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char)); 1         if (bmp_pixels == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); 2         (void) BMPDecodeImage(bmp_data,bmp_pixels,P           (unsigned int) bmp_header.compression,(unsigned int) bmp_header.width,,           (unsigned int) bmp_header.height);(         if (bmp_header.compression == 2)#           bmp_header.bit_count<<=1;           free((char *) bmp_data);       }      /*!       Initialize image structure.      */$     image->columns=bmp_header.width;"     image->rows=bmp_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert BMP raster image to runlength-encoded packets.     */C     bytes_per_line=((image->columns*bmp_header.bit_count+31)/32)*4; !     switch (bmp_header.bit_count)      { 
       case 1:        { 
         /*E           Convert bitmap scanline to runlength-encoded color packets. 
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); 1           for (x=0; x < (image->columns-7); x+=8)            { '             for (bit=0; bit < 8; bit++) 
             { <               q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);               q->length=0;               q++;
             }              p++;           } (           if ((image->columns % 8) != 0)
             { <               for (bit=0; bit < (image->columns % 8); bit++)               { >                 q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);                 q->length=0;                 q++;               }                p++;
             } C           ProgressMonitor(LoadImageText,image->rows-y,image->rows); 	         }          SyncImage(image);          break;       } 
       case 4:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); 1           for (x=0; x < (image->columns-1); x+=2)            { %             q->index=(*p >> 4) & 0xf;              q->length=0;             q++;              q->index=(*p) & 0xf;             q->length=0;             p++;             q++;           } (           if ((image->columns % 2) != 0)
             { '               q->index=(*p >> 4) & 0xf;                q->length=0;               q++;               p++;
             } C           ProgressMonitor(LoadImageText,image->rows-y,image->rows); 	         }          SyncImage(image);           CompressColormap(image);         break;       } 
       case 8:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */(         if (bmp_header.compression == 1)(           bytes_per_line=image->columns;*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } C           ProgressMonitor(LoadImageText,image->rows-y,image->rows); 	         }          SyncImage(image);           CompressColormap(image);         break;       }        case 24:       { 
         /*J           Convert DirectColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           { B             q->index=(unsigned short) (image->matte ? (*p++) : 0);"             q->blue=UpScale(*p++);#             q->green=UpScale(*p++); !             q->red=UpScale(*p++);              q->length=0;             q++;           } C           ProgressMonitor(LoadImageText,image->rows-y,image->rows); 	         }          break;       }        default:4         PrematureExit("Not a BMP image file",image);     }      free((char *) bmp_pixels);     CompressImage(image);      /*       Proceed to next image.     */5     status=ReadData((char *) magick,1,2,image->file); C     if ((status == True) && (strncmp((char *) magick,"BM",2) == 0))        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } G   } while ((status == True) && (strncmp((char *) magick,"BM",2) == 0)); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d C M Y K I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function ReadCMYKImage reads an image of raw cyan, magenta, yellow, andM %  black bytes and returns it.  It allocates the memory necessary for the new : %  Image structure and returns a pointer to the new image. % . %  The format of the ReadCMYKImage routine is: % & %      image=ReadCMYKImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadCMYKImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 static Image *ReadCMYKImage(const ImageInfo *image_info) {    Image      *image;      int      x,
     x_offset,      y,
     y_offset;      register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *scanline;     unsigned int
     black,	     cyan,      height,      magenta,     packet_size,     yellow, 
     width;     unsigned short
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; 
   x_offset=0; 
   y_offset=0; (   if (image_info->size != (char *) NULL)     { 
       x=0;C       (void) XParseGeometry(image_info->size,&x,&y,&width,&height);        for (i=0; i < x; i++) "         (void) fgetc(image->file);     }    /*     Initialize image structure.    */   image->columns=width;    image->rows=height; $   packet_size=4*(QuantumDepth >> 3);   scanline=(unsigned char *)=     malloc(packet_size*image->columns*sizeof(unsigned char)); (   if (image_info->tile != (char *) NULL)O     (void) XParseGeometry(image_info->tile,&x_offset,&y_offset,&image->columns,        &image->rows);,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); -   if ((scanline == (unsigned char *) NULL) || 2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*6     Convert raster image to runlength-encoded packets.   */    switch (image_info->interlace)   {      case NoneInterlace:      default:     {        /*0         No interlacing:  CMYKCMYKCMYKCMYKCMYK...       */"       for (y=0; y < y_offset; y++)I         (void) ReadData((char *) scanline,packet_size,width,image->file);        q=image->pixels;%       for (y=0; y < image->rows; y++)        { I         (void) ReadData((char *) scanline,packet_size,width,image->file); (         p=scanline+packet_size*x_offset;*         for (x=0; x < image->columns; x++)	         {             ReadQuantum(q->red,p);"           ReadQuantum(q->green,p);!           ReadQuantum(q->blue,p); "           ReadQuantum(q->index,p);           q->length=0;           q++;	         } 5         ProgressMonitor(LoadImageText,y,image->rows);        }        break;     }      case LineInterlace:      {        /*K         Line interlacing:  CCC...MMM...YYY...KKK...CCC...MMM...YYY...KKK...        */"       for (y=0; y < y_offset; y++)I         (void) ReadData((char *) scanline,packet_size,width,image->file); %       for (y=0; y < image->rows; y++)        { ?         (void) ReadData((char *) scanline,1,width,image->file);          p=scanline+x_offset;)         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {             ReadQuantum(q->red,p);           q->length=0;           q++;	         } ?         (void) ReadData((char *) scanline,1,width,image->file);          p=scanline+x_offset;)         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         { "           ReadQuantum(q->green,p);           q++;	         } ?         (void) ReadData((char *) scanline,1,width,image->file);          p=scanline+x_offset;)         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         { !           ReadQuantum(q->blue,p);            q++;	         } ?         (void) ReadData((char *) scanline,1,width,image->file);          p=scanline+x_offset;)         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         { "           ReadQuantum(q->index,p);           q++;	         } 5         ProgressMonitor(LoadImageText,y,image->rows);        }        break;     }      case PlaneInterlace:     {        /*@         Plane interlacing:  CCCCCC...MMMMMM...YYYYYY...KKKKKK...       */"       for (y=0; y < y_offset; y++)?         (void) ReadData((char *) scanline,1,width,image->file); 
       i=0;       q=image->pixels;%       for (y=0; y < image->rows; y++)        { ?         (void) ReadData((char *) scanline,1,width,image->file);          p=scanline+x_offset;*         for (x=0; x < image->columns; x++)	         {             ReadQuantum(q->red,p);           q->length=0;           q++;	         } <         ProgressMonitor(LoadImageText,i++,image->rows << 2);       }        q=image->pixels;.       for (y=0; y < (height-image->rows); y++)?         (void) ReadData((char *) scanline,1,width,image->file); %       for (y=0; y < image->rows; y++)        { ?         (void) ReadData((char *) scanline,1,width,image->file);          p=scanline+x_offset;*         for (x=0; x < image->columns; x++)	         { "           ReadQuantum(q->green,p);           q++;	         } <         ProgressMonitor(LoadImageText,i++,image->rows << 2);       }        q=image->pixels;.       for (y=0; y < (height-image->rows); y++)?         (void) ReadData((char *) scanline,1,width,image->file); %       for (y=0; y < image->rows; y++)        { ?         (void) ReadData((char *) scanline,1,width,image->file);          p=scanline+x_offset;*         for (x=0; x < image->columns; x++)	         { !           ReadQuantum(q->blue,p);            q++;	         } <         ProgressMonitor(LoadImageText,i++,image->rows << 2);       }        q=image->pixels;.       for (y=0; y < (height-image->rows); y++)?         (void) ReadData((char *) scanline,1,width,image->file); %       for (y=0; y < image->rows; y++)        { ?         (void) ReadData((char *) scanline,1,width,image->file);          p=scanline+x_offset;*         for (x=0; x < image->columns; x++)	         { "           ReadQuantum(q->index,p);           q++;	         } <         ProgressMonitor(LoadImageText,i++,image->rows << 2);       }        break;     }    }    free((char *) scanline);   /*%     Transform image from CMYK to RGB.    */   q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {        cyan=q->red;       magenta=q->green;        yellow=q->blue;        black=q->index;         if ((cyan+black) > MaxRGB)         q->red=0; 
       else#         q->red=MaxRGB-(cyan+black); #       if ((magenta+black) > MaxRGB)          q->green=0; 
       else(         q->green=MaxRGB-(magenta+black);"       if ((yellow+black) > MaxRGB)         q->blue=0;
       else&         q->blue=MaxRGB-(yellow+black);       q->index=0;        q->length=0;
       q++;     }    }    CompressImage(image);    CloseImage(image);   return(image); }  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d D P S I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % P %  Function ReadDPSImage reads a Adobe Postscript image file and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadDPSImage routine is:  % % %      image=ReadDPSImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadDPSImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasDPS 7 static Image *ReadDPSImage(const ImageInfo *image_info)  {  #include <DPS/dpsXclient.h>  #include <DPS/dpsXpreview.h>  	   Display 
     *display;      float      pixels_per_point;      Image      *image;      int 	     sans,      status,      x,     y;     Pixmap     pixmap;      register int     i;     register RunlengthPacket     *p;      register unsigned long
     pixel;     Screen     *screen;     XColor     *colors;     XImage     *dps_image;      XRectangle     bounding_box,      pixel_size;      XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     XStandardColormap      *map_info;  
   XVisualInfo      *visual_info;      /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     return((Image *) NULL);    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)      return((Image *) NULL);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);    /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) M     Warning("Unable to create standard colormap","Memory allocation failed");    else     {        /*         Initialize visual info.        */*       resource_info.visual_type="default";C       visual_info=XBestVisualInfo(display,map_info,&resource_info); )       map_info->colormap=(Colormap) NULL;      } 1   if ((map_info == (XStandardColormap *) NULL) || ,       (visual_info == (XVisualInfo *) NULL))     {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*7     Create a pixmap the appropriate size for the image.    */6   screen=ScreenOfDisplay(display,visual_info->screen);.   pixels_per_point=XDPSPixelsPerPoint(screen);+   if (image_info->density != (char *) NULL)      {        float          x_resolution,          y_resolution;   	       int          count;  3       x_resolution=72.0*XDPSPixelsPerPoint(screen); L       count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);       if (count != 2) "         y_resolution=x_resolution;;       pixels_per_point=Min(x_resolution,y_resolution)/72.0;      } F   status=XDPSCreatePixmapForEPSF((DPSContext) NULL,screen,image->file,K     visual_info->depth,pixels_per_point,&pixmap,&pixel_size,&bounding_box); L   if ((status == dps_status_failure) || (status == dps_status_no_extension))     {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*'     Rasterize the file into the pixmap.    */O   status=XDPSImageFileIntoDrawable((DPSContext) NULL,screen,pixmap,image->file, G     pixel_size.height,visual_info->depth,&bounding_box,-bounding_box.x, <     -bounding_box.y,pixels_per_point,True,False,True,&sans);#   if (status != dps_status_success)      {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*     Initialize DPS X image.    */L   dps_image=XGetImage(display,pixmap,0,0,pixel_size.width,pixel_size.height,     AllPlanes,ZPixmap);    XFreePixmap(display,pixmap);#   if (dps_image == (XImage *) NULL)      {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*     Get the colormap colors.   */F   colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));    if (colors == (XColor *) NULL)     {        DestroyImage(image);       XDestroyImage(dps_image); F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      } ,   if ((visual_info->class != DirectColor) &&(       (visual_info->class != TrueColor))2     for (i=0; i < visual_info->colormap_size; i++)     {        colors[i].pixel=i;       colors[i].pad=0;     }    else     {        unsigned long 
         blue,          blue_bit,          green,         green_bit,         red,         red_bit;         /*(         DirectColor or TrueColor visual.       */       red=0;       green=0;
       blue=0; C       red_bit=visual_info->red_mask & (~(visual_info->red_mask)+1); I       green_bit=visual_info->green_mask & (~(visual_info->green_mask)+1); F       blue_bit=visual_info->blue_mask & (~(visual_info->blue_mask)+1);4       for (i=0; i < visual_info->colormap_size; i++)       { +         colors[i].pixel=red | green | blue;          colors[i].pad=0;         red+=red_bit; (         if (red > visual_info->red_mask)           red=0;         green+=green_bit; ,         if (green > visual_info->green_mask)           green=0;         blue+=blue_bit; *         if (blue > visual_info->blue_mask)           blue=0;        }      } L   XQueryColors(display,XDefaultColormap(display,visual_info->screen),colors,      visual_info->colormap_size);   /*#     Convert X image to MIFF format.    */*   if ((visual_info->class != TrueColor) &&*       (visual_info->class != DirectColor))     image->class=PseudoClass; "   image->columns=dps_image->width;    image->rows=dps_image->height;,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)     {        DestroyImage(image);       free((char *) colors);       XDestroyImage(dps_image); F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    p=image->pixels;   switch (image->class)    {      case DirectClass:      {        register unsigned long         color,         index;         unsigned long          blue_mask,         blue_shift,          green_mask,          green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */%       red_mask=visual_info->red_mask;        red_shift=0;$       while ((red_mask & 0x01) == 0)       {          red_mask>>=1;          red_shift++;       } )       green_mask=visual_info->green_mask;        green_shift=0;&       while ((green_mask & 0x01) == 0)       {          green_mask>>=1;          green_shift++;       } '       blue_mask=visual_info->blue_mask;        blue_shift=0; %       while ((blue_mask & 0x01) == 0)        {          blue_mask>>=1;         blue_shift++;        }        /*/         Convert X image to DirectClass packets.        */-       if ((visual_info->colormap_size > 0) && .           (visual_info->class == DirectColor))'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { +             pixel=XGetPixel(dps_image,x,y); 2             index=(pixel >> red_shift) & red_mask;1             p->red=XDownScale(colors[index].red); 6             index=(pixel >> green_shift) & green_mask;5             p->green=XDownScale(colors[index].green); 4             index=(pixel >> blue_shift) & blue_mask;3             p->blue=XDownScale(colors[index].blue);              p->index=0;              p->length=0;             p++;           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         } 
       else'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { +             pixel=XGetPixel(dps_image,x,y); 2             color=(pixel >> red_shift) & red_mask;7             p->red=XDownScale((color*65535L)/red_mask); 6             color=(pixel >> green_shift) & green_mask;;             p->green=XDownScale((color*65535L)/green_mask); 4             color=(pixel >> blue_shift) & blue_mask;9             p->blue=XDownScale((color*65535L)/blue_mask);              p->index=0;              p->length=0;             p++;           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }        break;     }      case PseudoClass:      {        /*         Create colormap.       *//       image->colors=visual_info->colormap_size; P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         {            DestroyImage(image);            free((char *) colors);#           XDestroyImage(dps_image); J           XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,F             (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);!           return((Image *) NULL); 	         } '       for (i=0; i < image->colors; i++)        { G         image->colormap[colors[i].pixel].red=XDownScale(colors[i].red); K         image->colormap[colors[i].pixel].green=XDownScale(colors[i].green); I         image->colormap[colors[i].pixel].blue=XDownScale(colors[i].blue);        }        /*/         Convert X image to PseudoClass packets.        */%       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         { =           p->index=(unsigned short) XGetPixel(dps_image,x,y);            p->length=0;           p++;	         } 5         ProgressMonitor(LoadImageText,y,image->rows);        }        SyncImage(image);        break;     }    } "   if (image->class == PseudoClass)     CompressColormap(image);   free((char *) colors);   XDestroyImage(dps_image);    /*     Rasterize matte image.   */H   status=XDPSCreatePixmapForEPSF((DPSContext) NULL,screen,image->file,1,8     pixels_per_point,&pixmap,&pixel_size,&bounding_box);L   if ((status != dps_status_failure) && (status != dps_status_no_extension))     { G       status=XDPSImageFileIntoDrawable((DPSContext) NULL,screen,pixmap, F         image->file,pixel_size.height,1,&bounding_box,-bounding_box.x,?         -bounding_box.y,pixels_per_point,True,True,True,&sans); '       if (status == dps_status_success) 	         {            XImage             *matte_image;              /*#             Initialize image matte.            */D           matte_image=XGetImage(display,pixmap,0,0,pixel_size.width,1             pixel_size.height,AllPlanes,ZPixmap); &           XFreePixmap(display,pixmap);-           if (matte_image != (XImage *) NULL) 
             { '               image->class=DirectClass;                 image->matte=True;               p=image->pixels;-               for (y=0; y < image->rows; y++) 2                 for (x=0; x < image->columns; x++)                 { "                   p->index=Opaque;2                   if (!XGetPixel(matte_image,x,y)))                     p->index=Transparent;                    p++;                 } )               XDestroyImage(matte_image); 
             } 	         }      }    /*     Free resources.    */B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,>     (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);   CompressImage(image);    CloseImage(image);   return(image); }  #else 7 static Image *ReadDPSImage(const ImageInfo *image_info)  { 9   Warning("Cannot read DPS images",image_info->filename);    return((Image *) NULL);  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d F A X I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ReadFAXImage reads a Group 3 FAX image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadFAXImage routine is:  % % %      image=ReadFAXImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadFAXImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadFAXImage(const ImageInfo *image_info)  {    Image      *image;      unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize image structure.    */   image->class=PseudoClass;    image->columns=1728;   image->rows=2156; <   image->packets=Max((image->columns*image->rows+8) >> 4,1);#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Monochrome colormap.   */    image->colormap[0].red=MaxRGB;"   image->colormap[0].green=MaxRGB;!   image->colormap[0].blue=MaxRGB;    image->colormap[1].red=0;    image->colormap[1].green=0;    image->colormap[1].blue=0;#   status=HuffmanDecodeImage(image);    if (status == False)5     PrematureExit("Unable to read image data",image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d F I T S I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadFITSImage reads a FITS image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadFITSImage routine is: % & %      image=ReadFITSImage(image_info) % + %  A description of each parameter follows:  % I %    o image: Function ReadFITSImage returns a pointer to the image after O %      reading.  A null image is returned if there is a a memory shortage or if   %      the image cannot be read. % 9 %    o filename: Specifies the name of the image to read.  %  %  */8 static Image *ReadFITSImage(const ImageInfo *image_info) {    typedef struct _FITSHeader   {      unsigned int
       simple;        int        bits_per_pixel;        unsigned int       number_of_axis,        columns,       rows,        depth;  
     double       min_data,        max_data,        zero,        scale;   } FITSHeader;      char     long_quantum[8],     keyword[MaxTextLength],      value[MaxTextLength];      double
     pixel,
     scale,     scaled_pixel;      FITSHeader     fits_header;     Image      *image;      int      j,     packet_size,     y;     long
     count,     quantum;     register int     c,     i,     x;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *fits_pixels;      unsigned int     status,      value_expected;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize image header.   */   fits_header.simple=False;    fits_header.bits_per_pixel=8;    fits_header.columns=1;   fits_header.rows=1;    fits_header.depth=1;   fits_header.min_data=0.0;    fits_header.max_data=0.0;    fits_header.zero=0.0;    fits_header.scale=1.0;   /*     Decode image header.   */   c=fgetc(image->file); 
   count=1;   if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      } 
   for ( ; ; )    {      if (!isalnum(c))       {          c=fgetc(image->file);          count++;       }      else       {          register char 
           *p;   
         /*,           Determine a keyword and its value.
         */         p=keyword;
         do	         { .           if ((p-keyword) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);            count++;+         } while (isalnum(c) || (c == '_'));          *p='\0';'         if (strcmp(keyword,"END") == 0)            break;         value_expected=False; (         while (isspace(c) || (c == '='))	         {            if (c == '=')               value_expected=True;           c=fgetc(image->file);            count++;	         } $         if (value_expected == False)           continue;          p=value;D         while (isalnum(c) || (c == '-') || (c == '+') || (c == '.'))	         { ,           if ((p-value) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);            count++;	         }          *p='\0';
         /*2           Assign a value to the specified keyword.
         */*         if (strcmp(keyword,"SIMPLE") == 0)@           fits_header.simple=(*value == 'T') || (*value == 't');*         if (strcmp(keyword,"BITPIX") == 0)@           fits_header.bits_per_pixel=(unsigned int) atoi(value);)         if (strcmp(keyword,"NAXIS") == 0) @           fits_header.number_of_axis=(unsigned int) atoi(value);*         if (strcmp(keyword,"NAXIS1") == 0)9           fits_header.columns=(unsigned int) atoi(value); *         if (strcmp(keyword,"NAXIS2") == 0)6           fits_header.rows=(unsigned int) atoi(value);*         if (strcmp(keyword,"NAXIS3") == 0)7           fits_header.depth=(unsigned int) atoi(value); +         if (strcmp(keyword,"DATAMAX") == 0) +           fits_header.max_data=atof(value); +         if (strcmp(keyword,"DATAMIN") == 0) +           fits_header.min_data=atof(value); )         if (strcmp(keyword,"BZERO") == 0) '           fits_header.zero=atof(value); *         if (strcmp(keyword,"BSCALE") == 0)(           fits_header.scale=atof(value);       }      while (isspace(c))     {        c=fgetc(image->file);        count++;     }    }    while (count > 2880)     count-=2880;    for ( ; count < 2880; count++)     (void) fgetc(image->file);   /*6     Verify that required image information is defined.   */B   if ((!fits_header.simple) || (fits_header.number_of_axis < 1) ||)       (fits_header.number_of_axis > 4) || 2       (fits_header.columns*fits_header.rows) == 0)4     PrematureExit("image type not supported",image);   /*     Create linear colormap.    */%   image->columns=fits_header.columns;    image->rows=fits_header.rows;    image->class=PseudoClass;    image->colors=MaxRGB+1; L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)/     PrematureExit("Unable to open file",image); #   for (i=0; i < image->colors; i++)    { 0     image->colormap[i].red=(Quantum) UpScale(i);2     image->colormap[i].green=(Quantum) UpScale(i);1     image->colormap[i].blue=(Quantum) UpScale(i);    }    /*     Initialize image structure.    */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); +   packet_size=fits_header.bits_per_pixel/8;    if (packet_size < 0)     packet_size=(-packet_size);    fits_pixels=(unsigned char *) =     malloc(image->packets*packet_size*sizeof(unsigned char)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||.       (fits_pixels == (unsigned char *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*5     Convert FITS pixels to runlength-encoded packets.    */B   status=ReadData((char *) fits_pixels,(unsigned int) packet_size,      image->packets,image->file);   if (status == False)?     Warning("Insufficient image data in file",image->filename); E   if ((fits_header.min_data == 0.0) && (fits_header.max_data == 0.0))      {        /*0         Determine minimum and maximum intensity.       */       p=fits_pixels;       long_quantum[0]=(*p);        quantum=(*p++); )       for (j=0; j < (packet_size-1); j++)        {          long_quantum[j+1]=(*p); (         quantum=(quantum << 8) | (*p++);       }        pixel=(double) quantum; ,       if (fits_header.bits_per_pixel == -32)/         pixel=(double) (*((float *) &quantum)); ,       if (fits_header.bits_per_pixel == -64)4         pixel=(double) (*((double *) long_quantum));D       fits_header.min_data=pixel*fits_header.scale+fits_header.zero;D       fits_header.max_data=pixel*fits_header.scale+fits_header.zero;(       for (i=1; i < image->packets; i++)       {          long_quantum[0]=(*p);          quantum=(*p++); +         for (j=0; j < (packet_size-1); j++) 	         { !           long_quantum[j+1]=(*p); *           quantum=(quantum << 8) | (*p++);	         }          pixel=(double) quantum; .         if (fits_header.bits_per_pixel == -32)1           pixel=(double) (*((float *) &quantum)); .         if (fits_header.bits_per_pixel == -64)6           pixel=(double) (*((double *) long_quantum));>         scaled_pixel=pixel*fits_header.scale+fits_header.zero;0         if (scaled_pixel < fits_header.min_data),           fits_header.min_data=scaled_pixel;0         if (scaled_pixel > fits_header.max_data),           fits_header.max_data=scaled_pixel;       }      }    /*5     Convert FITS pixels to runlength-encoded packets.    */   scale=1.0;3   if (fits_header.min_data != fits_header.max_data) A     scale=(MaxRGB+1)/(fits_header.max_data-fits_header.min_data);    p=fits_pixels;   q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {        long_quantum[0]=(*p);        quantum=(*p++); )       for (j=0; j < (packet_size-1); j++)        {          long_quantum[j+1]=(*p); (         quantum=(quantum << 8) | (*p++);       }        pixel=(double) quantum; ,       if (fits_header.bits_per_pixel == -32)/         pixel=(double) (*((float *) &quantum)); ,       if (fits_header.bits_per_pixel == -64)4         pixel=(double) (*((double *) long_quantum));       scaled_pixel=scale* H         (pixel*fits_header.scale+fits_header.zero-fits_header.min_data);       while (scaled_pixel < 0)!         scaled_pixel+=(MaxRGB+1); #       while (scaled_pixel > MaxRGB) !         scaled_pixel-=(MaxRGB+1); -       q->index=(unsigned short) scaled_pixel;        q->length=0;
       q++;     } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    free((char *) fits_pixels);    SyncImage(image);    CompressColormap(image);   CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d G I F I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadGIFImage reads a Compuserve Graphics image file and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % - %  The format of the ReadGIFImage routine is:  % % %      image=ReadGIFImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadGIFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or %      an error occurs.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */1 static Image *ReadGIFImage(ImageInfo *image_info)  { 5 #define BitSet(byte,bit)  (((byte) & (bit)) == (bit)) . #define LSBFirstOrder(x,y)  (((y) << 8) | (x))     Image      *image;      int 	     left,      status,      top,     x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      short int      transparency_index;      unsigned char      c,	     flag,      *global_colormap,      header[MaxTextLength],     magick[12];      unsigned int
     delay,     global_colors,     height,      image_count,
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*$     Determine if this is a GIF file.   */3   status=ReadData((char *) magick,1,6,image->file); H   if ((status == False) || ((strncmp((char *) magick,"GIF87",5) != 0) &&1       (strncmp((char *) magick,"GIF89",5) != 0))) 0     PrematureExit("Not a GIF image file",image);   global_colors=0;)   global_colormap=(unsigned char *) NULL; '   width=LSBFirstReadShort(image->file); (   height=LSBFirstReadShort(image->file);2   (void) ReadData((char *) &flag,1,1,image->file);G   (void) ReadData((char *) &c,1,1,image->file);  /* background color */ ?   (void) ReadData((char *) &c,1,1,image->file);  /* reserved */    if (BitSet(flag,0x80))     {        /*         Read global colormap.        */+       global_colors=1 << ((flag & 0x07)+1); '       global_colormap=(unsigned char *) 6         malloc(3*global_colors*sizeof(unsigned char));4       if (global_colormap == (unsigned char *) NULL)B         PrematureExit("Unable to read image colormap file",image);L       (void) ReadData((char *) global_colormap,3,global_colors,image->file);     } 
   delay=0;   transparency_index=(-1);   image_count=0;
   for ( ; ; )    { 1     status=ReadData((char *) &c,1,1,image->file);      if (status == False)       break;     if (c == ';')        break;  /* terminator */     if (c == '!')        { 
         /*           GIF Extension block.
         */5         status=ReadData((char *) &c,1,1,image->file);          if (status == False)@           PrematureExit("Unable to read extention block",image);         switch (c)	         {            case 0xf9:           {              /*.               Read Graphics Control extension.             */C             while (ReadDataBlock((char *) header,image->file) > 0); /             delay=(header[2] << 8) | header[1]; (             if ((header[0] & 0x01) == 1)+               transparency_index=header[3];              break;           }            case 0xfe:           {              int                length;                /*%               Read Comment extension.              */             for ( ; ; ) 
             { @               length=ReadDataBlock((char *) header,image->file);               if (length <= 0)                 break;3               if (image->comments != (char *) NULL) J                 image->comments=(char *) realloc((char *) image->comments,C                   (strlen(image->comments)+length+1)*sizeof(char));                else                 { K                   image->comments=(char *) malloc((length+1)*sizeof(char)); 7                   if (image->comments != (char *) NULL) *                     *image->comments='\0';                 } 3               if (image->comments == (char *) NULL) A                 PrematureExit("Unable to allocate memory",image); "               header[length]='\0';=               (void) strcat(image->comments,(char *) header); 
             }              break;           }            default:           { C             while (ReadDataBlock((char *) header,image->file) > 0);              break;           } 	         }        }      if (c != ',')        continue;      if (image_count != 0)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }      image_count++;     /*       Read image attributes.     */     image->class=PseudoClass; (     left=LSBFirstReadShort(image->file);'     top=LSBFirstReadShort(image->file); 2     image->columns=LSBFirstReadShort(image->file);/     image->rows=LSBFirstReadShort(image->file); .     image->packets=image->columns*image->rows;     if (image->packets == 0)-       PrematureExit("image size is 0",image);      /*       Allocate image.      */2     if (image->pixels != (RunlengthPacket *) NULL)#       free((char *) image->pixels); %     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image); %     if (image->page == (char *) NULL)        { @         image->page=(char *) malloc(MaxTextLength*sizeof(char));)         if (image->page == (char *) NULL) ;           PrematureExit("Unable to allocate memory",image); H         (void) sprintf(image->page,"%ux%u%+d%+d",width,height,left,top);       } &     if (image->delay == (char *) NULL)       { A         image->delay=(char *) malloc(MaxTextLength*sizeof(char)); *         if (image->delay == (char *) NULL);           PrematureExit("Unable to allocate memory",image); 0         (void) sprintf(image->delay,"%u",delay);       }      /*       Inititialize colormap.     */4     (void) ReadData((char *) &flag,1,1,image->file);'     image->interlace=BitSet(flag,0x40); N     image->colors=!BitSet(flag,0x80) ? global_colors : 1 << ((flag & 0x07)+1);N     image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));0     if (image->colormap == (ColorPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      if (!BitSet(flag,0x80))        { 
         /*           Use global colormap.
         */         p=global_colormap;)         for (i=0; i < image->colors; i++) 	         { /           image->colormap[i].red=UpScale(*p++); 1           image->colormap[i].green=UpScale(*p++); 0           image->colormap[i].blue=UpScale(*p++);	         }        }      else       {          unsigned char            *colormap;  
         /*           Read local colormap.
         */"         colormap=(unsigned char *)8           malloc(3*image->colors*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); G         (void) ReadData((char *) colormap,3,image->colors,image->file);          p=colormap; )         for (i=0; i < image->colors; i++) 	         { /           image->colormap[i].red=UpScale(*p++); 1           image->colormap[i].green=UpScale(*p++); 0           image->colormap[i].blue=UpScale(*p++);	         }           free((char *) colormap);       }      /*       Decode image.      */!     status=GIFDecodeImage(image);      if (image->interlace)        { 
         Image            *interlaced_image;           int            pass;             register RunlengthPacket
           *p;            static int-           interlace_rate[4] = { 8, 8, 4, 2 }, .           interlace_start[4] = { 0, 4, 2, 1 };  
         /*           Interlace image.
         */,         image_info->interlace=LineInterlace;         image->orphan=True; J         interlaced_image=CopyImage(image,image->columns,image->rows,True);         image->orphan=False;/         if (interlaced_image == (Image *) NULL) ;           PrematureExit("Unable to allocate memory",image); #         p=interlaced_image->pixels;          q=image->pixels;&         for (pass=0; pass < 4; pass++)	         { "           y=interlace_start[pass];!           while (y < image->rows)            { /             q=image->pixels+(y*image->columns); .             for (x=0; x < image->columns; x++)
             {                *q=(*p);               p++;               q++;
             } $             y+=interlace_rate[pass];           } 	         } '         DestroyImage(interlaced_image);        }      if (transparency_index < 0)        CompressColormap(image);     else       { 
         /*           Create matte channel. 
         */         q=image->pixels;*         for (i=0; i < image->packets; i++)	         { >           if (q->index != (unsigned short) transparency_index)             q->index=Opaque;           else!             q->index=Transparent;            q++;	         }           transparency_index=(-1);!         image->class=DirectClass;          image->matte=True;       }      if (status == False)       { 5         Warning("Corrupt GIF image",image->filename);          break;       }      CompressImage(image); "     if (image_info->subimage != 0)2       if ((image->scene+1) < image_info->subimage)	         {            Image              subimage;              /*             Destroy image.           */           subimage=(*image);$           image->file=(FILE *) NULL;           DestroyImage(image);*           image=AllocateImage(image_info);&           if (image == (Image *) NULL)#             return((Image *) NULL); $           image->file=subimage.file;(           image->scene=subimage.scene+1;           image_count=0;	         } 
       elseN         if ((image->scene+1) >= (image_info->subimage+image_info->subrange-1))           break;   } 0   if (global_colormap != (unsigned char *) NULL)#     free((char *) global_colormap); 0   if (image->pixels == (RunlengthPacket *) NULL)C     PrematureExit("Corrupt GIF image or subimage not found",image); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d G R A Y I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadGRAYImage reads an image of raw grayscale bytes and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % . %  The format of the ReadGRAYImage routine is: % & %      image=ReadGRAYImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadGRAYImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 static Image *ReadGRAYImage(const ImageInfo *image_info) {    Image      *image;      int      x,
     x_offset,      y,
     y_offset;      register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *scanline;     unsigned int     height, 
     width;     unsigned short
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Create linear colormap.    */   image->class=PseudoClass; "   image->colors=1 << QuantumDepth;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image); #   for (i=0; i < image->colors; i++)    { '     image->colormap[i].red=(Quantum) i; )     image->colormap[i].green=(Quantum) i; (     image->colormap[i].blue=(Quantum) i;   }    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; 
   x_offset=0; 
   y_offset=0; (   if (image_info->size != (char *) NULL)     { 
       x=0;C       (void) XParseGeometry(image_info->size,&x,&y,&width,&height);        for (i=0; i < x; i++) "         (void) fgetc(image->file);     }    /*     Initialize image structure.    */   image->columns=width;    image->rows=height; J   scanline=(unsigned char *) malloc(image->columns*sizeof(unsigned char));(   if (image_info->tile != (char *) NULL)O     (void) XParseGeometry(image_info->tile,&x_offset,&y_offset,&image->columns,        &image->rows);,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); -   if ((scanline == (unsigned char *) NULL) || 2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*6     Convert raster image to runlength-encoded packets.   */   for (y=0; y < y_offset; y++);     (void) ReadData((char *) scanline,1,width,image->file);    q=image->pixels;!   for (y=0; y < image->rows; y++)    { ;     (void) ReadData((char *) scanline,1,width,image->file);      p=scanline+x_offset;&     for (x=0; x < image->columns; x++)     {        ReadQuantum(q->index,p);       q->length=0;
       q++;     } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    free((char *) scanline);   SyncImage(image);    CompressColormap(image);   CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H D F I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadHDFImage reads a Hierarchical Data Format image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadHDFImage routine is:  % % %      image=ReadHDFImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadHDFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasHDF 1 static Image *ReadHDFImage(ImageInfo *image_info)  {  #include "hdf.h"
 #undef BSD #undef LOCAL     Image      *image;      int      interlace,     is_palette,      status,      y;     int32      height,      length, 
     width;     register int     i,     x;     register unsigned char     *p;      register RunlengthPacket     *q;      uint16     reference;     unsigned char      *hdf_pixels;     unsigned int
     class,     packet_size;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    CloseImage(image);   /*     Read HDF image.    */   class=DirectClass;@   status=DF24getdims(image->filename,&width,&height,&interlace);   if (status == -1)      {        class=PseudoClass;E       status=DFR8getdims(image->filename,&width,&height,&is_palette);      }    if (status == -1) I     PrematureExit("Image file or does not contain any image data",image);    do   {      /*!       Initialize image structure.      */     image->class=class;      image->columns=width;      image->rows=height; .     image->packets=image->columns*image->rows;     packet_size=1;$     if (image->class == DirectClass)       packet_size=3;      hdf_pixels=(unsigned char *)?       malloc(packet_size*image->packets*sizeof(unsigned char)); %     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 1     if ((hdf_pixels == (unsigned char *) NULL) || 4         (image->pixels == (RunlengthPacket *) NULL))7       PrematureExit("Unable to allocate memory",image);      q=image->pixels;$     if (image->class == PseudoClass)       {          unsigned char            *hdf_palette;   
         /*           Create colormap.
         */H         hdf_palette=(unsigned char *) malloc(768*sizeof(unsigned char));         image->colors=256;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));6         if ((hdf_palette == (unsigned char *) NULL) ||6             (image->colormap == (ColorPacket *) NULL));           PrematureExit("Unable to allocate memory",image); L         (void) DFR8getimage(image->filename,hdf_pixels,(int) image->columns,)           (int) image->rows,hdf_palette);           reference=DFR8lastref();
         /*L           Convert HDF raster image to PseudoClass runlength-encoded packets.
         */         p=hdf_palette;         if (is_palette) !           for (i=0; i < 256; i++)            { 1             image->colormap[i].red=UpScale(*p++); 3             image->colormap[i].green=UpScale(*p++); 2             image->colormap[i].blue=UpScale(*p++);           }          else+           for (i=0; i < image->colors; i++)            { 8             image->colormap[i].red=(Quantum) UpScale(i);:             image->colormap[i].green=(Quantum) UpScale(i);9             image->colormap[i].blue=(Quantum) UpScale(i);            } #         free((char *) hdf_palette);          p=hdf_pixels; '         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }          SyncImage(image);        }      else       {          int            x,           y;  
         /*L           Convert HDF raster image to DirectClass runlength-encoded packets.
         */O         (void) DF24getimage(image->filename,(void *) hdf_pixels,image->columns,            image->rows);           reference=DF24lastref();         p=hdf_pixels; *         image_info->interlace=interlace+1;&         switch (image_info->interlace)	         {            case NoneInterlace:            default:           {              /*4               No interlacing:  RGBRGBRGBRGBRGBRGB...             */             q=image->pixels;+             for (y=0; y < image->rows; y++) 
             { 0               for (x=0; x < image->columns; x++)               { %                 q->red=UpScale(*p++); '                 q->green=UpScale(*p++); &                 q->blue=UpScale(*p++);                 q->index=0;                  q->length=0;                 q++;               } ;               ProgressMonitor(LoadImageText,y,image->rows); 
             }              break;           }            case LineInterlace:            {              /*E               Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...              */+             for (y=0; y < image->rows; y++) 
             { /               q=image->pixels+y*image->columns; 0               for (x=0; x < image->columns; x++)               { %                 q->red=UpScale(*p++);                  q->index=0;                  q->length=0;                 q++;               } /               q=image->pixels+y*image->columns; 0               for (x=0; x < image->columns; x++)               { '                 q->green=UpScale(*p++);                  q++;               } /               q=image->pixels+y*image->columns; 0               for (x=0; x < image->columns; x++)               { &                 q->blue=UpScale(*p++);                 q++;               } ;               ProgressMonitor(LoadImageText,y,image->rows); 
             }              break;           }            case PlaneInterlace:           {              /*=               Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...              */3             ProgressMonitor(LoadImageText,100,400);              q=image->pixels;.             for (i=0; i < image->packets; i++)
             { #               q->red=UpScale(*p++);                q->index=0;                q->length=0;               q++;
             } 3             ProgressMonitor(LoadImageText,200,400);              q=image->pixels;.             for (i=0; i < image->packets; i++)
             { %               q->green=UpScale(*p++);                q++;
             } 3             ProgressMonitor(LoadImageText,300,400);              q=image->pixels;.             for (i=0; i < image->packets; i++)
             { $               q->blue=UpScale(*p++);               q++;
             } 3             ProgressMonitor(LoadImageText,400,400);              break;           } 	         }        } >     length=DFANgetlablen(image->filename,DFTAG_RIG,reference);     if (length > 0)        { 
         /*           Read the image label. 
         */         length+=MaxTextLength;:         image->label=(char *) malloc(length*sizeof(char));*         if (image->label != (char *) NULL)P           DFANgetlabel(image->filename,DFTAG_RIG,reference,image->label,length);       } ?     length=DFANgetdesclen(image->filename,DFTAG_RIG,reference);      if (length > 0)        { 
         /*"           Read the image comments.
         */         length+=MaxTextLength;=         image->comments=(char *) malloc(length*sizeof(char)); -         if (image->comments != (char *) NULL) J           DFANgetdesc(image->filename,DFTAG_RIG,reference,image->comments,             length);       }      free((char *) hdf_pixels);     CompressImage(image);      class=DirectClass;B     status=DF24getdims(image->filename,&width,&height,&interlace);     if (status == -1)        {          class=PseudoClass;G         status=DFR8getdims(image->filename,&width,&height,&is_palette);        }      if (status != -1)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status != -1); +   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }  #else 7 static Image *ReadHDFImage(const ImageInfo *image_info)  { ?   Warning("HDF library is not available",image_info->filename); $   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H I S T O G R A M I m a g e                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadHISTOGRAMImage reads a HISTOGRAM image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % 3 %  The format of the ReadHISTOGRAMImage routine is:  % + %      image=ReadHISTOGRAMImage(image_info)  % + %  A description of each parameter follows:  % O %    o image:  Function ReadHISTOGRAMImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */= static Image *ReadHISTOGRAMImage(const ImageInfo *image_info)  {    Image      *image;   "   image=ReadMIFFImage(image_info);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H T M L I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadHTMLImage reads a HTML image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadHTMLImage routine is: % & %      image=ReadHTMLImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadHTMLImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 static Image *ReadHTMLImage(const ImageInfo *image_info) {    Image      *image;   :   Warning("Cannot read HTML images",image_info->filename);"   image=ReadMIFFImage(image_info);   return(image); }    #ifdef HasJBIG #include "jbig.h"  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d J B I G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadJBIGImage reads a JBIG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadJBIGImage routine is: % & %      image=ReadJBIGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadJBIGImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 static Image *ReadJBIGImage(const ImageInfo *image_info) {  #define MaxBufferSize  8192      Image      *image;      int      length,      status,      x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      register unsigned short 
     index;     size_t
     count;     struct jbg_dec_state     jbig_info;     unsigned char      bit,     buffer[MaxBufferSize];     unsigned int	     byte,      height,      packets,
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*5     Determine maximum width and height, e.g. 640x512.    */   width=65535L;    height=65535L;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Read JBIG file.    */   jbg_dec_init(&jbig_info); K   jbg_dec_maxsize(&jbig_info,(unsigned long) width,(unsigned long) height);    status=JBG_EAGAIN;   do   { 5     length=fread(buffer,1,MaxBufferSize,image->file);      if (length == 0)       break;
     p=buffer;      count=0;K     while ((length > 0) && ((status == JBG_EAGAIN) || (status == JBG_EOK)))      { 4       status=jbg_dec_in(&jbig_info,p,length,&count);       p+=count;        length-=count;     } :   } while ((status == JBG_EAGAIN) || (status == JBG_EOK));   /*     Initialize image structure.    */.   image->columns=jbg_dec_getwidth(&jbig_info);,   image->rows=jbg_dec_getheight(&jbig_info);   image->packets=0; 5   packets=Max((image->columns*image->rows+8) >> 4,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*     Create colormap.   */   image->class=PseudoClass;    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    image->colormap[0].red=0;    image->colormap[0].green=0;    image->colormap[0].blue=0;    image->colormap[1].red=MaxRGB;"   image->colormap[1].green=MaxRGB;!   image->colormap[1].blue=MaxRGB;    /*8     Convert X bitmap image to runlength-encoded packets.   */	   byte=0; #   p=jbg_dec_getimage(&jbig_info,0);    q=image->pixels;   q->length=MaxRunlength; !   for (y=0; y < image->rows; y++)    { 
     bit=0;&     for (x=0; x < image->columns; x++)     {        if (bit == 0)          byte=(*p++);"       index=(byte & 0x80) ? 0 : 1;B       if ((index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;O               image->pixels=(RunlengthPacket *) realloc((char *) image->pixels, 1                 packets*sizeof(RunlengthPacket)); <               if (image->pixels == (RunlengthPacket *) NULL)                 { +                   jbg_dec_free(&jbig_info); C                   PrematureExit("Unable to allocate memory",image);                  } /               q=image->pixels+image->packets-1; 
             }            q->index=index;            q->length=0;	         }        bit++;       byte<<=1;        if (bit == 8)          bit=0;     } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    jbg_dec_free(&jbig_info);    SyncImage(image); #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    CloseImage(image);   return(image); }  #else 8 static Image *ReadJBIGImage(const ImageInfo *image_info) { @   Warning("JBIG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   #ifdef HasJPEG #include <setjmp.h>  #include "jpeglib.h" #include "jerror.h"    static Image	   *image;    static jmp_buf   error_recovery;    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d J P E G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadJPEGImage reads a JPEG image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % . %  The format of the ReadJPEGImage routine is: % & %      image=ReadJPEGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadJPEGImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % ? %    o filename:  Specifies the name of the jpeg image to read.  %  %  */  < static unsigned int GetCharacter(j_decompress_ptr jpeg_info) {    struct jpeg_source_mgr
     *data;     data=jpeg_info->src;!   if (data->bytes_in_buffer == 0) +     (*data->fill_input_buffer) (jpeg_info);    data->bytes_in_buffer--;.   return(GETJOCTET(*data->next_input_byte++)); }   5 static int CommentHandler(j_decompress_ptr jpeg_info)  { 
   long int     length;      register char      *p;      /*      Determine length of comment.   */&   length=GetCharacter(jpeg_info) << 8;"   length+=GetCharacter(jpeg_info);   length-=2;'   if (image->comments != (char *) NULL) >     image->comments=(char *) realloc((char *) image->comments,F       (unsigned int) (strlen(image->comments)+length+1)*sizeof(char));   else     {        image->comments=(char *)7         malloc((unsigned int) (length+1)*sizeof(char)); +       if (image->comments != (char *) NULL)          *image->comments='\0';     } '   if (image->comments == (char *) NULL)      { 7       Warning("Memory allocation error",(char *) NULL);        return(False);     }    /*     Read comment.    */,   p=image->comments+strlen(image->comments);   while (--length >= 0) !     *p++=GetCharacter(jpeg_info); 
   *p='\0';   return(True);  }   9 static void EmitMessage(j_common_ptr jpeg_info,int level)  {    char     message[JMSG_LENGTH_MAX];      struct jpeg_error_mgr      *jpeg_error;     jpeg_error=jpeg_info->err;3   (jpeg_error->format_message) (jpeg_info,message);    if (level < 0)     { L       if ((jpeg_error->num_warnings == 0) || (jpeg_error->trace_level >= 3))2         Warning((char *) message,image->filename);!       jpeg_error->num_warnings++;      }    else)     if (jpeg_error->trace_level >= level) 0       Warning((char *) message,image->filename); }   - static void ErrorExit(j_common_ptr jpeg_info)  {    EmitMessage(jpeg_info,0);    longjmp(error_recovery,1); }   8 static Image *ReadJPEGImage(const ImageInfo *image_info) {    int      y;  	   JSAMPLE      *jpeg_pixels;   
   JSAMPROW     scanline[1];  	   Quantum 	     blue, 
     green,     red;     register int     i,     x;     register JSAMPLE     *p;      register RunlengthPacket     *q;      struct jpeg_decompress_struct      jpeg_info;     struct jpeg_error_mgr      jpeg_error;      unsigned int     packets;     unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize image structure.    */,   jpeg_info.err=jpeg_std_error(&jpeg_error);*   jpeg_info.err->emit_message=EmitMessage;&   jpeg_info.err->error_exit=ErrorExit;)   image->pixels=(RunlengthPacket *) NULL;    jpeg_pixels=(JSAMPLE *) NULL;    if (setjmp(error_recovery))      {        /*         JPEG image is corrupt.       */*       if (jpeg_pixels != (JSAMPLE *) NULL)	         { %           free((char *) jpeg_pixels); .           jpeg_destroy_decompress(&jpeg_info);	         }        DestroyImage(image);       return((Image *) NULL);      } %   jpeg_create_decompress(&jpeg_info); @   jpeg_set_marker_processor(&jpeg_info,JPEG_COM,CommentHandler);)   jpeg_stdio_src(&jpeg_info,image->file); +   (void) jpeg_read_header(&jpeg_info,True); (   if (image_info->size != (char *) NULL)     {        unsigned int         height,          width;         unsigned long          scale_factor;          /*.         Let the JPEG library subsample for us.       */.       jpeg_calc_output_dimensions(&jpeg_info);3       image->magick_columns=jpeg_info.output_width; 1       image->magick_rows=jpeg_info.output_height; #       width=jpeg_info.output_width; %       height=jpeg_info.output_height; :       ParseImageGeometry(image_info->size,&width,&height);       if (width == 0)          width=1;9       scale_factor=UpShift(jpeg_info.output_width)/width;        if (height == 0)         height=1; C       if (scale_factor > (UpShift(jpeg_info.output_height)/height)) =         scale_factor=UpShift(jpeg_info.output_height)/height; 4       jpeg_info.scale_denom=DownShift(scale_factor);.       jpeg_calc_output_dimensions(&jpeg_info);     }  #if (JPEG_LIB_VERSION >= 61)"   jpeg_info.dct_method=JDCT_FLOAT;.   image->interlace=jpeg_info.progressive_mode; #endif$   jpeg_start_decompress(&jpeg_info);(   image->columns=jpeg_info.output_width;&   image->rows=jpeg_info.output_height;   image->packets=0; 5   packets=Max((image->columns*image->rows+2) >> 2,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));   jpeg_pixels=(JSAMPLE *) G     malloc(jpeg_info.output_components*image->columns*sizeof(JSAMPLE)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||(       (jpeg_pixels == (JSAMPLE *) NULL))5     PrematureExit("Unable to allocate memory",image); 1   if (jpeg_info.out_color_space == JCS_GRAYSCALE)      {        /*&         Initialize grayscale colormap.       */       image->class=PseudoClass;        image->colors=256;P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)9         PrematureExit("Unable to allocate memory",image); '       for (i=0; i < image->colors; i++)        { *         image->colormap[i].red=UpScale(i);,         image->colormap[i].green=UpScale(i);+         image->colormap[i].blue=UpScale(i);        }      }    /*5     Convert JPEG pixels to runlength-encoded packets.    */   red=0;
   green=0;	   blue=0; 
   index=0;%   scanline[0]=(JSAMPROW) jpeg_pixels;    q=image->pixels;   q->length=MaxRunlength; !   for (y=0; y < image->rows; y++)    { 6     (void) jpeg_read_scanlines(&jpeg_info,scanline,1);     p=jpeg_pixels;&     for (x=0; x < image->columns; x++)     { 2       if (jpeg_info.data_precision > QuantumDepth)	         { 9           if (jpeg_info.out_color_space == JCS_GRAYSCALE) (             index=GETJSAMPLE(*p++) >> 4;           else
             { 4               red=(Quantum) (GETJSAMPLE(*p++) >> 4);6               green=(Quantum) (GETJSAMPLE(*p++) >> 4);5               blue=(Quantum) (GETJSAMPLE(*p++) >> 4); 8               if (jpeg_info.out_color_space == JCS_CMYK)8                 index=(Quantum) (GETJSAMPLE(*p++) >> 4);
             } 
          }        else 8          if (jpeg_info.out_color_space == JCS_GRAYSCALE)"            index=GETJSAMPLE(*p++);
          else             {5              red=(Quantum) UpScale(GETJSAMPLE(*p++)); 7              green=(Quantum) UpScale(GETJSAMPLE(*p++)); 6              blue=(Quantum) UpScale(GETJSAMPLE(*p++));7              if (jpeg_info.out_color_space == JCS_CMYK) 9                index=(Quantum) UpScale(GETJSAMPLE(*p++));             }0       if (jpeg_info.out_color_space == JCS_CMYK)	         { !           index=MAXJSAMPLE-index; $           if ((int) (red-index) < 0)             red=0;           else             red-=index; &           if ((int) (green-index) < 0)             green=0;           else             green-=index; %           if ((int) (blue-index) < 0)              blue=0;            else             blue-=index;           index=0;	         } H       if ((red == q->red) && (green == q->green) && (blue == q->blue) &&B           (index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;/               image->pixels=(RunlengthPacket *) P                 realloc((char *) image->pixels,packets*sizeof(RunlengthPacket));<               if (image->pixels == (RunlengthPacket *) NULL)                 { -                   free((char *) jpeg_pixels); 6                   jpeg_destroy_decompress(&jpeg_info);C                   PrematureExit("Unable to allocate memory",image);                  } /               q=image->pixels+image->packets-1; 
             }            q->red=red;            q->green=green;            q->blue=blue;            q->index=index;            q->length=0;	         }      } 1     ProgressMonitor(LoadImageText,y,image->rows);    } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket)); "   if (image->class == PseudoClass)     {        SyncImage(image);        CompressColormap(image);     }    /*     Free memory.   */   free((char *) jpeg_pixels); ,   (void) jpeg_finish_decompress(&jpeg_info);&   jpeg_destroy_decompress(&jpeg_info);   CloseImage(image);   return(image); }  #else 8 static Image *ReadJPEGImage(const ImageInfo *image_info) { @   Warning("JPEG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d L O G O I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadLOGOImage reads a LOGO image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadLOGOImage routine is: % & %      image=ReadLOGOImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadLOGOImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */2 static Image *ReadLOGOImage(ImageInfo *image_info) {  #include "logo.h"      char     *filename,!     logo_filename[MaxTextLength];      FILE
     *file;     Image      *image;      register int     i;     register unsigned char     *p;      /*     Open temporary output file.    */#   TemporaryFilename(logo_filename);     file=fopen(logo_filename,"w");   if (file == (FILE *) NULL)     { 4       Warning("Unable to write file",logo_filename);&       return(ReadXCImage(image_info));     }    p=LogoImage;%   for (i=0; i < LogoImageLength; i++)    { !     (void) fputc((char) *p,file);      p++;   }    if (ferror(file))      { E       Warning("An error has occurred writing to file",logo_filename);        (void) fclose(file);#       (void) remove(logo_filename); &       return(ReadXCImage(image_info));     }    (void) fclose(file);    filename=image_info->filename;%   image_info->filename=logo_filename; "   image=ReadMIFFImage(image_info);    image_info->filename=filename;   if (image != (Image *) NULL)8     (void) strcpy(image->filename,image_info->filename);   (void) remove(logo_filename);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M A P I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function ReadMAPImage reads an image of raw RGB colormap and colormap indexM %  bytes and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % - %  The format of the ReadMAPImage routine is:  % % %      image=ReadMAPImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadMAPImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadMAPImage(const ImageInfo *image_info)  {    Image      *image;      int      colors;      register int     i;     register unsigned char     *p;      unsigned char      *colormap;     unsigned int     height,      packet_size,     status, 
     width;     unsigned short
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*D     Determine width, height, and number of colors, e.g. 640x512+256.   */   width=512;
   height=512; 
   colors=256; (   if (image_info->size != (char *) NULL)K     (void) XParseGeometry(image_info->size,&colors,&colors,&width,&height);    /*     Initialize image structure.    */   image->class=PseudoClass; #   image->compression=NoCompression;    image->columns=width;    image->rows=height;    image->colors=colors; ,   image->packets=image->columns*image->rows;$   packet_size=3*(image->depth >> 3);   colormap=(unsigned char *)<     malloc(packet_size*image->colors*sizeof(unsigned char));L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));(   image->packed_pixels=(unsigned char *);     malloc(image->packets*packet_size*(image->depth >> 3)); -   if ((colormap == (unsigned char *) NULL) || 0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Read image colormap.   */M   (void) ReadData((char *) colormap,1,image->colors*packet_size,image->file); 
   p=colormap; #   for (i=0; i < image->colors; i++)    { *     ReadQuantum(image->colormap[i].red,p);,     ReadQuantum(image->colormap[i].green,p);+     ReadQuantum(image->colormap[i].blue,p);    }    free((char *) colormap);   /*6     Convert raster image to runlength-encoded packets.   */   packet_size=1;   if (image->colors > 256)     packet_size++;5   if (image->packed_pixels != (unsigned char *) NULL) (     free((char *) image->packed_pixels);(   image->packed_pixels=(unsigned char *)'     malloc(image->packets*packet_size); 5   if (image->packed_pixels == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image); K   (void) ReadData((char *) image->packed_pixels,packet_size,image->packets,      image->file); %   status=RunlengthDecodeImage(image);    if (status == False)     {        DestroyImages(image);        return((Image *) NULL);      }    CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M A T T E I m a g e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ReadMATTEImage reads an image of raw matte bytes and returns it.N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % / %  The format of the ReadMATTEImage routine is:  % ' %      image=ReadMATTEImage(image_info)  % + %  A description of each parameter follows:  % K %    o image:  Function ReadMATTEImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */9 static Image *ReadMATTEImage(const ImageInfo *image_info)  {    Image      *image;      int      x,
     x_offset,      y,
     y_offset;      register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *scanline;     unsigned int     height, 
     width;     unsigned short
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; 
   x_offset=0; 
   y_offset=0; (   if (image_info->size != (char *) NULL)     { 
       x=0;C       (void) XParseGeometry(image_info->size,&x,&y,&width,&height);        for (i=0; i < x; i++) "         (void) fgetc(image->file);     }    /*     Initialize image structure.    */   image->columns=width;    image->rows=height; J   scanline=(unsigned char *) malloc(image->columns*sizeof(unsigned char));(   if (image_info->tile != (char *) NULL)O     (void) XParseGeometry(image_info->tile,&x_offset,&y_offset,&image->columns,        &image->rows);,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); -   if ((scanline == (unsigned char *) NULL) || 2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*6     Convert raster image to runlength-encoded packets.   */   for (y=0; y < y_offset; y++);     (void) ReadData((char *) scanline,1,width,image->file);    q=image->pixels;!   for (y=0; y < image->rows; y++)    { ;     (void) ReadData((char *) scanline,1,width,image->file);      p=scanline+x_offset;&     for (x=0; x < image->columns; x++)     {        q->red=0;        q->green=0;        q->blue=0;       ReadQuantum(q->index,p);       q->length=0;
       q++;     } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    free((char *) scanline);   CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d M I F F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadMIFFImage reads a MIFF image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadMIFFImage routine is: % $ %      image=ReadMIFFImage(filename) % + %  A description of each parameter follows:  % I %    o image: Function ReadMIFFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasPNG  #include "zlib.h"  #endif  8 static Image *ReadMIFFImage(const ImageInfo *image_info) {    char     keyword[MaxTextLength],      value[MaxTextLength];      Image      *image;      register int     c,     i;     register unsigned char     *p;      unsigned int     length,      packet_size,     status;      unsigned long 
     count,     packets;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    image->depth=8;    /*G     Decode image header;  header terminates one character beyond a ':'.    */   c=fgetc(image->file);    if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      }    do   {      /*I       Decode image header;  header terminates one character beyond a ':'.      */%     image->compression=NoCompression; $     while (isgraph(c) && (c != ':'))     {        register char          *p;          if (c == '{') 	         {            /*0             Read comment-- any text between { }.           *//           if (image->comments != (char *) NULL) 
             { -               length=strlen(image->comments); '               p=image->comments+length; 
             }            else
             { #               length=MaxTextLength; C               image->comments=(char *) malloc(length*sizeof(char));                 p=image->comments;
             } 8           for ( ; image->comments != (char *) NULL; p++)           { !             c=fgetc(image->file); )             if ((c == EOF) || (c == '}'))                break;0             if ((p-image->comments+1) >= length)               {                  *p='\0';                 length<<=1; (                 image->comments=(char *)H                   realloc((char *) image->comments,length*sizeof(char));5                 if (image->comments == (char *) NULL)                    break;:                 p=image->comments+strlen(image->comments);               } !             *p=(unsigned char) c;            } /           if (image->comments == (char *) NULL) =             PrematureExit("Unable to allocate memory",image);            *p='\0';           c=fgetc(image->file); 	         } 
       else         if (isalnum(c))            {              /*0               Determine a keyword and its value.             */             p=keyword;             do
             { 2               if ((p-keyword) < (MaxTextLength-1))                 *p++=(char) c;#               c=fgetc(image->file); !             } while (isalnum(c));              *p='\0';,             while (isspace(c) || (c == '='))#               c=fgetc(image->file);              p=value;-             while (!isspace(c) && (c != EOF)) 
             { 0               if ((p-value) < (MaxTextLength-1))                 *p++=(char) c;#               c=fgetc(image->file); 
             }              *p='\0';             /*6               Assign a value to the specified keyword.             */-             if (strcmp(keyword,"class") == 0) 3               if (strcmp(value,"PseudoClass") == 0) )                 image->class=PseudoClass;                else5                 if (strcmp(value,"DirectClass") == 0) +                   image->class=DirectClass;                  else.                   image->class=UndefinedClass;.             if (strcmp(keyword,"colors") == 0)7               image->colors=(unsigned int) atoi(value); 3             if (strcmp(keyword,"compression") == 0) L               if ((strcmp(value,"Zip") == 0) || (strcmp(value,"Zlib") == 0))2                 image->compression=ZipCompression;               else:                 if (strcmp(value,"RunlengthEncoded") == 0)A                   image->compression=RunlengthEncodedCompression;                  else:                   image->compression=UndefinedCompression;/             if (strcmp(keyword,"columns") == 0) 8               image->columns=(unsigned int) atoi(value);-             if (strcmp(keyword,"depth") == 0) 5               image->depth=atoi(value) <= 8 ? 8 : 16; -             if (strcmp(keyword,"gamma") == 0) '               image->gamma=atof(value); *             if (strcmp(keyword,"id") == 0)3               if (strcmp(value,"ImageMagick") == 0) (                 image->id=ImageMagickId;               else&                 image->id=UndefinedId;1             if ((strcmp(keyword,"matte") == 0) || /                 (strcmp(keyword,"alpha") == 0)) M               if ((strcmp(value,"True") == 0) || (strcmp(value,"true") == 0)) "                 image->matte=True;               else#                 image->matte=False; /             if (strcmp(keyword,"montage") == 0)                { M                 image->montage=(char *) malloc(strlen(value)+1*sizeof(char)); 4                 if (image->montage == (char *) NULL)C                   PrematureExit("Unable to allocate memory",image); 4                 (void) strcpy(image->montage,value);               } /             if (strcmp(keyword,"packets") == 0) 8               image->packets=(unsigned int) atoi(value);,             if (strcmp(keyword,"rows") == 0)5               image->rows=(unsigned int) atoi(value); -             if (strcmp(keyword,"scene") == 0) 6               image->scene=(unsigned int) atoi(value);1             if (strcmp(keyword,"signature") == 0)                { )                 image->signature=(char *) 9                   malloc((strlen(value)+1)*sizeof(char)); 6                 if (image->signature == (char *) NULL)C                   PrematureExit("Unable to allocate memory",image); 6                 (void) strcpy(image->signature,value);               }            }          else           c=fgetc(image->file);        while (isspace(c))         c=fgetc(image->file);      }      (void) fgetc(image->file);     /*8       Verify that required image information is defined.     */I     if ((image->id == UndefinedId) || (image->class == UndefinedClass) || P         (image->compression == UndefinedCompression) || (image->columns == 0) ||         (image->rows == 0)) <       PrematureExit("Incorrect image header in file",image);(     if (image->montage != (char *) NULL)       {          register char 
           *p;   
         /*           Image directory.
         */E         image->directory=(char *) malloc(MaxTextLength*sizeof(char)); .         if (image->directory == (char *) NULL);           PrematureExit("Unable to read image data",image);          p=image->directory; 
         do	         {            *p='\0';H           if ((((int) strlen(image->directory)+1) % MaxTextLength) == 0)
             {                /*=                 Allocate more memory for the image directory.                */J               image->directory=(char *) realloc((char *) image->directory,I                 (strlen(image->directory)+MaxTextLength+1)*sizeof(char)); 4               if (image->directory == (char *) NULL)A                 PrematureExit("Unable to read image data",image); :               p=image->directory+strlen(image->directory);
             }            c=fgetc(image->file); !           *p++=(unsigned char) c;          } while (c != '\0');       } $     if (image->class == PseudoClass)       {          unsigned int           colors;            unsigned short           value;  
         /*3           PseudoClass image cannot have matte data. 
         */         if (image->matte) B           PrematureExit("Matte images must be DirectClass",image);
         /*            Create image colormap.
         */         colors=image->colors;          if (colors == 0)           colors=256; K         image->colormap=(ColorPacket *) malloc(colors*sizeof(ColorPacket)); 4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);          if (image->colors == 0) $           for (i=0; i < colors; i++)           { 8             image->colormap[i].red=(Quantum) UpScale(i);:             image->colormap[i].green=(Quantum) UpScale(i);9             image->colormap[i].blue=(Quantum) UpScale(i);              image->colors++;           }          else           {              unsigned char                *colormap;               /*,               Read image colormap from file.             */.             packet_size=3*(image->depth >> 3);&             colormap=(unsigned char *)F               malloc(packet_size*image->colors*sizeof(unsigned char));3             if (colormap == (unsigned char *) NULL) ?               PrematureExit("Unable to allocate memory",image); J             (void) ReadData((char *) colormap,1,packet_size*image->colors,               image->file);              p=colormap; -             for (i=0; i < image->colors; i++) 
             { 4               ReadQuantum(image->colormap[i].red,p);6               ReadQuantum(image->colormap[i].green,p);5               ReadQuantum(image->colormap[i].blue,p); 
             } $             free((char *) colormap);           }        }      /*#       Determine packed packet size.      */$     if (image->class == PseudoClass)       {          image->packet_size=1;           if (image->colors > 256)           image->packet_size++;        }      else       { 1         image->packet_size=3*(image->depth >> 3);          if (image->matte)            image->packet_size++;        } :     if (image->compression == RunlengthEncodedCompression)       image->packet_size++; #     packet_size=image->packet_size; -     if (image->compression == ZipCompression)        packet_size=1;     /*       Allocate image pixels.     */,     if (image->compression == NoCompression)0       image->packets=image->columns*image->rows;     packets=image->packets;      if (image->packets == 0))       packets=image->columns*image->rows; *     image->packed_pixels=(unsigned char *)G       malloc((unsigned int) packets*packet_size*sizeof(unsigned char)); 7     if (image->packed_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      /*"       Read image pixels from file.     */>     if ((image->compression != RunlengthEncodedCompression) ||         (image->packets != 0))D       (void) ReadData((char *) image->packed_pixels,1,(unsigned int))         packets*packet_size,image->file);      else       { 
         /*5           Number of runlength packets is unspecified. 
         */         count=0;         p=image->packed_pixels; 
         do	         { @           (void) ReadData((char *) p,1,packet_size,image->file);           image->packets++;            p+=(packet_size-1);            count+=(*p+1);           p++;	         } 5         while (count < (image->columns*image->rows));        } .     if (image->compression ==  ZipCompression)       {          int            status;            unsigned char            *compressed_pixels;   
         /*4           Uncompress image pixels with Zip encoding.
         *//         compressed_pixels=image->packed_pixels; >         packets=image->columns*image->rows*image->packet_size;.         image->packed_pixels=(unsigned char *)0           malloc(packets*sizeof(unsigned char));;         if (image->packed_pixels == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image);          status=True;
 #ifdef HasPNG J         status=uncompress(image->packed_pixels,&packets,compressed_pixels,           image->packets); #endif2         image->packets=packets/image->packet_size;)         free((char *) compressed_pixels);          if (status) @           PrematureExit("Unable to Zip uncompress image",image);       }      /*J       Unpack the packed image pixels into runlength-encoded pixel packets.     */'     status=RunlengthDecodeImage(image);      if (status == False)       {          DestroyImages(image);          return((Image *) NULL);        }      /*       Proceed to next image.     */     do     {        c=fgetc(image->file); (     } while (!isgraph(c) && (c != EOF));     if (c != EOF)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (c != EOF); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M O N O I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function ReadMONOImage reads an image of raw bites in LSB order and returnsI %  it.  It allocates the memory necessary for the new Image structure and & %  returns a pointer to the new image. % . %  The format of the ReadMONOImage routine is: % & %      image=ReadMONOImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadMONOImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 static Image *ReadMONOImage(const ImageInfo *image_info) {    Image      *image;      int      x,
     x_offset,      y,
     y_offset;      register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      bit,	     byte;      unsigned int     height,      packets,
     width;     unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; 
   x_offset=0; 
   y_offset=0; (   if (image_info->size != (char *) NULL)     { 
       x=0;C       (void) XParseGeometry(image_info->size,&x,&y,&width,&height);        for (i=0; i < x; i++) "         (void) fgetc(image->file);     }    /*     Initialize image structure.    */   image->columns=width;    image->rows=height; (   if (image_info->tile != (char *) NULL)O     (void) XParseGeometry(image_info->tile,&x_offset,&y_offset,&image->columns,        &image->rows);   image->packets=0; 5   packets=Max((image->columns*image->rows+8) >> 4,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));   image->class=PseudoClass;    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image); #   for (i=0; i < image->colors; i++)    { 8     image->colormap[i].red=(MaxRGB*i)/(image->colors-1);:     image->colormap[i].green=(MaxRGB*i)/(image->colors-1);9     image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);    }    /*8     Convert bi-level image to runlength-encoded packets.   */8   for (y=0; y < ((y_offset*image->columns+7) >> 3); y++)     (void) fgetc(image->file);	   byte=0;    q=image->pixels;   q->length=MaxRunlength; !   for (y=0; y < image->rows; y++)    { 
     bit=0;+     for (x=0; y < ((x_offset+7) >> 3); x++)         (void) fgetc(image->file);&     for (x=0; x < image->columns; x++)     {        if (bit == 0)           byte=fgetc(image->file);"       index=(byte & 0x01) ? 0 : 1;B       if ((index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;@               image->pixels=(RunlengthPacket *) realloc((char *)?                 image->pixels,packets*sizeof(RunlengthPacket)); <               if (image->pixels == (RunlengthPacket *) NULL)A                 PrematureExit("Unable to allocate memory",image); /               q=image->pixels+image->packets-1; 
             }            q->index=index;            q->length=0;	         }        bit++;       if (bit == 8)          bit=0;       byte>>=1;      } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    SyncImage(image);    CloseImage(image);   return(image); }  #ifdef HasMPEG #undef BitmapPad #include "mpeg.h"    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M P E G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadMPEGImage reads a MPEG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadMPEGImage routine is: % & %      image=ReadMPEGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadMPEGImage returns a pointer to the image afterN %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 static Image *ReadMPEGImage(const ImageInfo *image_info) {    Image      *image;      ImageDesc      mpeg_info;     int      y;     register int     x;     register unsigned char     *p;      register RunlengthPacket     *q;      unsigned char      *mpeg_pixels;      unsigned int     number_frames,     status;      unsigned long      lsb_first;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate MPEG pixels.    */*   (void) OpenMPEG(image->file,&mpeg_info);C   number_frames=8*image->filesize/mpeg_info.Width/mpeg_info.Height; M   mpeg_pixels=(unsigned char *) malloc(mpeg_info.Size*sizeof(unsigned char));%,   if (mpeg_pixels == (unsigned char *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*     Read MPEG image.   */,   status=GetMPEGFrame((char *) mpeg_pixels);    if (image_info->subimage != 0)/     while (image->scene < image_info->subimage)      {        /*         Skip to next image.        */       image->scene++; 0       status=GetMPEGFrame((char *) mpeg_pixels);       if (status == False)         break;@       ProgressMonitor(LoadImageText,image->scene,number_frames);     }    if (status == False)     { !       free((char *) mpeg_pixels); 0       PrematureExit("Corrupt MPEG image",image);     }    while (status == True)   {      /*!       Initialize image structure.      */#     image->columns=mpeg_info.Width; #     image->rows=mpeg_info.Height-8; .     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)e5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*=       Convert MPEG raster image to runlength-encoded packets.      */     p=mpeg_pixels;     q=image->pixels;     lsb_first=1;     if (*(char *) &lsb_first) %       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         {            q->red=UpScale(*p++); !           q->green=UpScale(*p++);             q->blue=UpScale(*p++);           q->length=0;           p++;           q++;	         }        }p     else%       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         {            p++;            q->blue=UpScale(*p++);!           q->green=UpScale(*p++);u           q->red=UpScale(*p++);            q->length=0;           q++;	         }g       }t     if (image_info->verbose)(       DescribeImage(image,stderr,False);     CompressImage(image); "     if (image_info->subimage != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;.     status=GetMPEGFrame((char *) mpeg_pixels);     if (status == True)        {n
         /*#           Allocate image structure.r
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {d!             DestroyImages(image); #             return((Image *) NULL);f           } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } =     if ((status == False) || (image->scene == number_frames))f#       number_frames=image->scene+1;e>     ProgressMonitor(LoadImageText,image->scene,number_frames);   }    free((char *) mpeg_pixels);b+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }u #elser8 static Image *ReadMPEGImage(const ImageInfo *image_info) {o@   Warning("MPEG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %%O %                                                                             %lO %                                                                             % O %  R e a d M T V I m a g e                                                    %dO %                                                                             %rO %                                                                             %aO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%g %fM %  Function ReadMTVImage reads a MTV image file and returns it.  It allocates%L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % - %  The format of the ReadMTVImage routine is:  % % %      image=ReadMTVImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadMTVImage returns a pointer to the image aftergL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadMTVImage(const ImageInfo *image_info)  {    Image      *image;      int 
     count,     y;  	   Quantum%	     blue,%
     green,     red;     register int     x;     register RunlengthPacket     *q;i     unsigned int     columns,     packets,	     rows;e     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)I/     PrematureExit("Unable to open file",image);    /*     Read MTV image.e   */5   count=fscanf(image->file,"%u %u\n",&columns,&rows);e   if (count == 0) 0     PrematureExit("Not a MTV image file",image);   do   {c     /*!       Initialize image structure.a     */     image->columns=columns;      image->rows=rows;a     image->packets=0; 7     packets=Max((image->columns*image->rows+4) >> 3,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert MTV raster image to runlength-encoded packets.     */     q=image->pixels;     q->length=MaxRunlength;_#     for (y=0; y < image->rows; y++))     {e(       for (x=0; x < image->columns; x++)       { (         red=UpScale(fgetc(image->file));*         green=UpScale(fgetc(image->file));)         blue=UpScale(fgetc(image->file));eJ         if ((red == q->red) && (green == q->green) && (blue == q->blue) &&-             ((int) q->length < MaxRunlength))            q->length++;         else           {t$             if (image->packets != 0)               q++;             image->packets++;u*             if (image->packets == packets)               {h                 packets<<=1;B                 image->pixels=(RunlengthPacket *) realloc((char *)A                   image->pixels,packets*sizeof(RunlengthPacket));t>                 if (image->pixels == (RunlengthPacket *) NULL)C                   PrematureExit("Unable to allocate memory",image);c1                 q=image->pixels+image->packets-1;t               }n             q->red=red;              q->green=green;              q->blue=blue;              q->index=0;w             q->length=0;           }m       }m3       ProgressMonitor(LoadImageText,y,image->rows);>     } %     image->pixels=(RunlengthPacket *);M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));>     /*       Proceed to next image.     */7     count=fscanf(image->file,"%u %u\n",&columns,&rows);x     if (count > 0)       {n
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);k           } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }(   } while (count > 0);+   while (image->previous != (Image *) NULL)+     image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %gO %                                                                             %)O %                                                                             %aO %  R e a d N U L L I m a g e                                                  %fO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m %mE %  Function ReadNULLImage reads a NULL image file and returns it.  ItmK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadNULLImage routine is: %s& %      image=ReadNULLImage(image_info) %i+ %  A description of each parameter follows:  % J %    o image:  Function ReadNULLImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 static Image *ReadNULLImage(const ImageInfo *image_info) {    ImageB     *image;e  :   Warning("Cannot read NULL images",image_info->filename);"   image=ReadMIFFImage(image_info);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %%O %                                                                             %eO %  R e a d P C D I m a g e                                                    %rO %                                                                             %mO %                                                                             %nO %                                                                             %pO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadPCDImage reads a Photo CD image file and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns aaF %  pointer to the new image.  Much of the PCD decoder was derived from. %  the program hpcdtoppm(1) by Hadmut Danisch. %;- %  The format of the ReadPCDImage routine is:  %n% %      image=ReadPCDImage(image_info)  %e+ %  A description of each parameter follows:n %sI %    o image:  Function ReadPCDImage returns a pointer to the image aftersL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.M %aA %    o image_info: Specifies a pointer to an ImageInfo structure.  %e %t */  V static void Upsample(unsigned int width,unsigned int height,unsigned int scaled_width,   unsigned char *pixels) {    register int     x,     y;     register unsigned char     *p,      *q,d     *r;      /*L     Create a new image that is a integral size greater than an existing one.   */   for (y=0; y < height; y++)   {_1     p=pixels+(height-1-y)*scaled_width+(width-1);(?     q=pixels+((height-1-y) << 1)*scaled_width+((width-1) << 1);m     *q=(*p);     *(q+1)=(*(p));     for (x=1; x < width; x++)U     { 
       p--;       q-=2;o       *q=(*p);0       *(q+1)=(((int) *p)+((int) *(p+1))+1) >> 1;     }    }s    for (y=0; y < (height-1); y++)   {l#     p=pixels+(y << 1)*scaled_width;y     q=p+scaled_width;/     r=q+scaled_width;e!     for (x=0; x < (width-1); x++)      {e(       *q=(((int) *p)+((int) *r)+1) >> 1;J       *(q+1)=(((int) *p)+((int) *(p+2))+((int) *r)+((int) *(r+2))+2) >> 2;       q+=2;R       p+=2;-       r+=2;      }d,     *q++=(((int) *p++)+((int) *r++)+1) >> 1;,     *q++=(((int) *p++)+((int) *r++)+1) >> 1;   }e%   p=pixels+(2*height-2)*scaled_width;B%   q=pixels+(2*height-1)*scaled_width;e   for (x=0; x < width; x++)a   {i     *q++=(*p++);     *q++=(*p++);   }  }   E static Image *OverviewImage(const ImageInfo *image_info,Image *image,d   unsigned int number_images)s {a #define ClientName  "montage"m     char     *resource_value;  	   Displayh
     *display;)     Image 
     **images;e     register int     i,     j;     XMontageInfo     montage_info;s     XResourceInfoi     resource_info;  
   XrmDatabases     resource_database;     /*     Allocate images array.   */:   images=(Image **) malloc(number_images*sizeof(Image *));    if (images == (Image **) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);f       return((Image *) NULL);h     }r   /*     Open X server connection._   */7   resource_info.background_color=DefaultTileBackground;d*   resource_info.border_color=BorderColor;;:   resource_info.border_width=atoi(DefaultTileBorderwidth);7   resource_info.foreground_color=DefaultTileForeground;e&   resource_info.gravity=CenterGravity;3   resource_info.image_geometry=DefaultTileGeometry;x-   resource_info.matte_color=DefaultTileMatte;_$   resource_info.title=(char *) NULL;0   display=XOpenDisplay(image_info->server_name);"   if (display != (Display *) NULL)     {o       /*(         Set our forgiving error handler.       */       XSetErrorHandler(XError);        /*3         Get user defaults from X resource database.a       */B       resource_database=XGetResourceDatabase(display,client_name);D       XGetResourceInfo(resource_database,ClientName,&resource_info);L       resource_info.background_color=XGetResourceInstance(resource_database,7         ClientName,"background",DefaultTileBackground);rD       resource_value=XGetResourceClass(resource_database,ClientName,.         "borderWidth",DefaultTileBorderwidth);6       resource_info.border_width=atoi(resource_value);*       resource_info.font=image_info->font;L       resource_info.foreground_color=XGetResourceInstance(resource_database,7         ClientName,"foreground",DefaultTileForeground);tJ       resource_info.image_geometry=XGetResourceInstance(resource_database,8         ClientName,"imageGeometry",DefaultTileGeometry);G       resource_info.matte_color=XGetResourceInstance(resource_database, 2         ClientName,"mattecolor",DefaultTileMatte);       XCloseDisplay(display);r     }    /*/     Read each image and convert them to a tile.(   */   j=0;#   for (i=0; i < number_images; i++)*   {      LabelImage(image,"%f");]F     TransformImage(&image,(char *) NULL,resource_info.image_geometry);     if (image_info->verbose)(       DescribeImage(image,stderr,False);     images[j]=image;     image=image->next;     j++;   }e   /*"     Create the PCD Overview image.   */!   XGetMontageInfo(&montage_info);    montage_info.number_tiles=j;%   if (montage_info.number_tiles != 0) 
     image=N       XMontageImage(images,&resource_info,&montage_info,image_info->filename);   free((char *) images);   if (image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image);    CompressImage(image);a   return(image); }y  7 static Image *ReadPCDImage(const ImageInfo *image_info)e {n   Imagea     *image;e  
   long int     offset;      register int     i;     register RunlengthPacket     *p;      register unsigned char     *c1,     *c2,     *y;      unsigned charr
     *chroma1,c
     *chroma2,e     *header,
     *luma;     unsigned int     height,r     number_images,
     overview,*     rotate,h     status, 
     subimage,r
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);e   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)b/     PrematureExit("Unable to open file",image);o   /*$     Determine if this is a PCD file.   */A   header=(unsigned char *) malloc(3*0x800*sizeof(unsigned char));r'   if (header == (unsigned char *) NULL)u5     PrematureExit("Unable to allocate memory",image); 9   status=ReadData((char *) header,1,3*0x800,image->file);-5   overview=strncmp((char *) header,"PCD_OPA",7) == 0;h   if ((status == False) ||C       ((strncmp((char *) header+0x800,"PCD",3) != 0) && !overview)) 0     PrematureExit("Not a PCD image file",image);   rotate=header[0x0e02] & 0x03;l/   number_images=(header[10] << 8) | header[11];    free((char *) header);
   subimage=3;     if (image_info->subimage != 0)"     subimage=image_info->subimage;(   if (image_info->size != (char *) NULL)     {u	       int4
         x,
         y;         /*.         Determine which image size to extract.       */       width=768;       height=512;hC       (void) XParseGeometry(image_info->size,&x,&y,&width,&height); 1       for (subimage=1; subimage <= 6; subimage++)g       {-.         if ((width <= 192) && (height <= 128))           break;         width>>=1;         height>>=1;-       }      }    if (overview)      subimage=1;    /*     Initialize image structure.    */   width=192;
   height=128;?%   for (i=1; i < Min(subimage,3); i++)=   {      width<<=1;     height<<=1;    }    image->columns=width;    image->rows=height;o   for ( ; i < subimage; i++)   {      image->columns<<=1;i     image->rows<<=1;   }i   /*$     Allocate luma and chroma memory.   */,   image->packets=image->columns*image->rows;M   chroma1=(unsigned char *) malloc((image->packets+1)*sizeof(unsigned char));;M   chroma2=(unsigned char *) malloc((image->packets+1)*sizeof(unsigned char));rJ   luma=(unsigned char *) malloc((image->packets+1)*sizeof(unsigned char));,   if ((chroma1 == (unsigned char *) NULL) ||N       (chroma2 == (unsigned char *) NULL) || (luma == (unsigned char *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Advance to image data.   */   offset=93;   if (overview)g
     offset=2;a   else     if (subimage == 2)       offset=20;     else       if (subimage == 1)         offset=1;p$   for (i=0; i < (offset*0x800); i++)     (void) fgetc(image->file);   if (overview)      {        Imagel         *overview_image;         register int
         j;         /*,         Read thumbnails from overview image.       */(       for (j=1; j <= number_images; j++)       {n8         (void) sprintf(image->filename,"img%04d.pcd",j);         image->scene=j;o         image->columns=width;-         image->rows=height; 2         image->packets=image->columns*image->rows;)         image->pixels=(RunlengthPacket *)a9           malloc(image->packets*sizeof(RunlengthPacket)); 6         if (image->pixels == (RunlengthPacket *) NULL);           PrematureExit("Unable to allocate memory",image);e         y=luma;u         c1=chroma1;i         c2=chroma2; #         for (i=0; i < height; i+=2)e	         {r:           (void) ReadData((char *) y,1,width,image->file);           y+=image->columns;:           (void) ReadData((char *) y,1,width,image->file);           y+=image->columns;@           (void) ReadData((char *) c1,1,width >> 1,image->file);           c1+=image->columns;m@           (void) ReadData((char *) c2,1,width >> 1,image->file);           c2+=image->columns;r	         } N         Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma1);N         Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma2);
         /*6           Transfer luminance and chrominance channels.
         */         p=image->pixels;         y=luma;u         c1=chroma1;          c2=chroma2;m*         for (i=0; i < image->packets; i++)	         {s           p->red=UpScale(*y++);;"           p->green=UpScale(*c1++);!           p->blue=UpScale(*c2++);)           p->index=0;U           p->length=0;           p++;	         } /         TransformRGBImage(image,YCCColorspace);o         CompressImage(image);-          if (image_info->verbose),           DescribeImage(image,stderr,False);         if (j < number_images)           {              /*'               Allocate image structure.              */2             image->next=AllocateImage(image_info);.             if (image->next == (Image *) NULL)               {s%                 DestroyImages(image); '                 return((Image *) NULL);i               } *             image->next->file=image->file;(             image->next->previous=image;             image=image->next;           }e9         ProgressMonitor(LoadImageText,j-1,number_images);        }        free(chroma2);       free(chroma1);       free(luma);e/       while (image->previous != (Image *) NULL)          image=image->previous;       CloseImage(image);C       overview_image=OverviewImage(image_info,image,number_images);        return(overview_image);c     }m   /*     Allocate image pixels.   */#   image->pixels=(RunlengthPacket *)g3     malloc(image->packets*sizeof(RunlengthPacket));a0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*     Read interleaved image.    */	   y=luma; 
   c1=chroma1; 
   c2=chroma2;    for (i=0; i < height; i+=2)    { 4     (void) ReadData((char *) y,1,width,image->file);     y+=image->columns;4     (void) ReadData((char *) y,1,width,image->file);     y+=image->columns;:     (void) ReadData((char *) c1,1,width >> 1,image->file);     c1+=image->columns; :     (void) ReadData((char *) c2,1,width >> 1,image->file);     c2+=image->columns;    }    if (subimage >= 4)     {        /*5         Recover luminance deltas for 1536x1024 image.        */,       Upsample(768,512,image->columns,luma);/       Upsample(384,256,image->columns,chroma1);n/       Upsample(384,256,image->columns,chroma2);a       image->rows=1024;a#       for (i=0; i < (4*0x800); i++)s"         (void) fgetc(image->file);8       status=PCDDecodeImage(image,luma,chroma1,chroma2);$       if ((subimage >= 5) && status)	         {i           /*9             Recover luminance deltas for 3072x2048 image.a           */2           Upsample(1536,1024,image->columns,luma);3           Upsample(768,512,image->columns,chroma1); 3           Upsample(768,512,image->columns,chroma2);t           image->rows=2048;a-           offset=ftell(image->file)/0x800+12;s3           (void) fseek(image->file,offset*0x800,0);t<           status=PCDDecodeImage(image,luma,chroma1,chroma2);(           if ((subimage >= 6) && status)
             {                /*I                 Recover luminance deltas for 6144x4096 image (vaporware).e               */6               Upsample(3072,2048,image->columns,luma);9               Upsample(1536,1024,image->columns,chroma1);t9               Upsample(1536,1024,image->columns,chroma2);d               image->rows=4096;l
             }r	         }      }mH   Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma1);H   Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma2);   /*0     Transfer luminance and chrominance channels.   */   p=image->pixels;	   y=luma;o
   c1=chroma1;g
   c2=chroma2; $   for (i=0; i < image->packets; i++)   {      p->red=UpScale(*y++);t     p->green=UpScale(*c1++);     p->blue=UpScale(*c2++);i     p->index=0;L     p->length=0;     p++;     if (QuantumTick(i,image))n6       ProgressMonitor(LoadImageText,i,image->packets);   }    free(chroma2);   free(chroma1);
   free(luma); )   TransformRGBImage(image,YCCColorspace);m%   if ((rotate == 1) || (rotate == 3))g     {        double         degrees;         Image(         *rotated_image;l         /*         Rotate image.f       */)       degrees=rotate == 1 ? -90.0 : 90.0;)       image->orphan=True;oO       rotated_image=RotateImage(image,degrees,(ColorPacket *) NULL,False,True);;       image->orphan=False;*       if (rotated_image != (Image *) NULL)	         {            DestroyImage(image);           image=rotated_image;	         }(     }d   CompressImage(image);    CloseImage(image);   return(image); })   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             %aO %                                                                             %CO %                                                                             %RO %  R e a d P C L I m a g e                                                    %;O %                                                                             % O %                                                                             %fO %                                                                             %uO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%) % M %  Function ReadPCLImage reads a Page Control Language image file and returns I %  it.  It allocates the memory necessary for the new Image structure and & %  returns a pointer to the new image. % - %  The format of the ReadPCLImage routine is:C %.% %      image=ReadPCLImage(image_info)K % + %  A description of each parameter follows:) % I %    o image:  Function ReadPCLImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadPCLImage(const ImageInfo *image_info)d {n   Imaged     *image;   9   Warning("Cannot read PCL images",image_info->filename);a"   image=ReadMIFFImage(image_info);   return(image); }= n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d P C X I m a g e                                                    % O %                                                                             %-O %                                                                             % O %                                                                             %-O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m %-M %  Function ReadPCXImage reads a ZSoft IBM PC Paintbrush file and returns it. L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %+- %  The format of the ReadPCXImage routine is:, %t% %      image=ReadPCXImage(image_info)m %-+ %  A description of each parameter follows:+ % I %    o image:  Function ReadPCXImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.p % A %    o image_info: Specifies a pointer to an ImageInfo structure.s %i %( */7 static Image *ReadPCXImage(const ImageInfo *image_info)- {x   typedef struct _PCXHeaderi   {m     unsigned char        identifier,t       version,       encoding,-       bits_per_pixel;0  
     short int;       left, 
       top,       right,
       bottom,l       horizontal_resolution,       vertical_resolution;       unsigned char        reserved,+
       planes;   
     short intn       bytes_per_line,        palette_info;        unsigned charo       colormap_signature;r   } PCXHeader;     PCXHeaderm     pcx_header;      Image      *image;m     int)	     bits, 
     count,     id,c	     mask,l     packets,     pcx_packets;  	   Quantum 	     blue,w
     green,     red;     register int     i,     x,     y;     register RunlengthPacket     *q;e     register unsigned char     *p,g     *r;s     unsigned char      packet,d     *pcx_colormap,     *pcx_pixels,     *scanline;     unsigned int     status;x     unsigned long<     *page_table;     unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)x/     PrematureExit("Unable to open file",image);    /*$     Determine if this is a PCX file.   */$   page_table=(unsigned long *) NULL;,   if (strcmp(image_info->magick,"DCX") == 0)     {        unsigned long(         magic;         /*          Read the DCX page table.       */*       magic=LSBFirstReadLong(image->file);       if (magic != 987654321) 4         PrematureExit("Not a DCX image file",image);F       page_table=(unsigned long *) malloc(1024*sizeof(unsigned long));/       if (page_table == (unsigned long *) NULL)d9         PrematureExit("Unable to allocate memory",image); !       for (id=0; id < 1024; id++)        {g5         page_table[id]=LSBFirstReadLong(image->file);b          if (page_table[id] == 0)           break;       };     } +   if (page_table != (unsigned long *) NULL) .     (void) fseek(image->file,page_table[0],0);C   status=ReadData((char *) &pcx_header.identifier,1,1,image->file);e   for (id=1; id < 1024; id++)%   {%     /*       Verify PCX identifier.     */B     (void) ReadData((char *) &pcx_header.version,1,1,image->file);?     if ((status == False) || (pcx_header.identifier != 0x0a) || A         ((pcx_header.version != 2) && (pcx_header.version != 5))) 2       PrematureExit("Not a PCX image file",image);C     (void) ReadData((char *) &pcx_header.encoding,1,1,image->file); I     (void) ReadData((char *) &pcx_header.bits_per_pixel,1,1,image->file); 3     pcx_header.left=LSBFirstReadShort(image->file); 2     pcx_header.top=LSBFirstReadShort(image->file);4     pcx_header.right=LSBFirstReadShort(image->file);5     pcx_header.bottom=LSBFirstReadShort(image->file);%D     pcx_header.horizontal_resolution=LSBFirstReadShort(image->file);B     pcx_header.vertical_resolution=LSBFirstReadShort(image->file);     /*       Read PCX raster colormap.      */8     image->columns=(pcx_header.right-pcx_header.left)+1;5     image->rows=(pcx_header.bottom-pcx_header.top)+1;s.     image->packets=image->columns*image->rows;     image->colors=16; D     image->colormap=(ColorPacket *) malloc(256*sizeof(ColorPacket));G     pcx_colormap=(unsigned char *) malloc(3*256*sizeof(unsigned char));r4     if ((image->colormap == (ColorPacket *) NULL) ||1         (pcx_colormap == (unsigned char *) NULL))i7       PrematureExit("Unable to allocate memory",image);iG     (void) ReadData((char *) pcx_colormap,3,image->colors,image->file);      p=pcx_colormap;l%     for (i=0; i < image->colors; i++)      {p+       image->colormap[i].red=UpScale(*p++);p-       image->colormap[i].green=UpScale(*p++); ,       image->colormap[i].blue=UpScale(*p++);     } C     (void) ReadData((char *) &pcx_header.reserved,1,1,image->file); A     (void) ReadData((char *) &pcx_header.planes,1,1,image->file);sE     if ((pcx_header.bits_per_pixel != 8) || (pcx_header.planes != 3))c       image->class=PseudoClass;i=     pcx_header.bytes_per_line=LSBFirstReadShort(image->file);b;     pcx_header.palette_info=LSBFirstReadShort(image->file);p     for (i=0; i < 58; i++)        (void) fgetc(image->file);     /*       Read image data.     */     image->packets=0;-7     packets=Max((image->columns*image->rows+4) >> 3,1);e'     if (pcx_header.bits_per_pixel == 1) 9       packets=Max((image->columns*image->rows+8) >> 4,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));H     pcx_packets=image->rows*pcx_header.bytes_per_line*pcx_header.planes;K     pcx_pixels=(unsigned char *) malloc(pcx_packets*sizeof(unsigned char));(     scanline=(unsigned char *)E       malloc(image->columns*pcx_header.planes*sizeof(unsigned char));c6     if ((image->pixels == (RunlengthPacket *) NULL) ||1         (pcx_pixels == (unsigned char *) NULL) ||u-         (scanline == (unsigned char *) NULL))*7       PrematureExit("Unable to allocate memory",image);o     /*       Uncompress image data.     */     p=pcx_pixels;L     while (pcx_packets > 0)e     {n        packet=fgetc(image->file);"       if ((packet & 0xc0) != 0xc0)	         {n           *p++=packet;           pcx_packets--;           continue;u	         }        count=packet & 0x3f;9       for (packet=fgetc(image->file); count > 0; count--)p       {p         *p++=packet;         pcx_packets--;         if (pcx_packets == 0)v           break;       }*     })$     if (image->class == DirectClass))       image->matte=pcx_header.planes > 3;p     else"       if (pcx_header.version == 5)	         {&           /*&             Initialize image colormap.           */K           image->colors=1 << (pcx_header.bits_per_pixel*pcx_header.planes);/"           if (image->colors > 256)D             PrematureExit("PCX colormap exceeded 256 colors",image);!           if (image->colors > 16)*
             {                /*M                 256 color images have their color map at the end of the file.                */J               (void) ReadData((char *) &pcx_header.colormap_signature,1,1,                 image->file);nD               (void) ReadData((char *) pcx_colormap,3,image->colors,                 image->file);o               p=pcx_colormap; /               for (i=0; i < image->colors; i++)L               {l5                 image->colormap[i].red=UpScale(*p++);x7                 image->colormap[i].green=UpScale(*p++);l6                 image->colormap[i].blue=UpScale(*p++);               }i
             }F           elseO             if (Intensity(image->colormap[0]) == Intensity(image->colormap[1]))o%               if (image->colors == 2)                  {L                   /*(                     Monochrome colormap.                   */0                   image->colormap[0].red=MaxRGB;2                   image->colormap[0].green=MaxRGB;1                   image->colormap[0].blue=MaxRGB;o+                   image->colormap[1].red=0; -                   image->colormap[1].green=0; ,                   image->colormap[1].blue=0;                 }o&           free((char *) pcx_colormap);	         }t     /*<       Convert PCX raster image to runlength-encoded packets.     */
     red=0;     green=0;     blue=0;a     index=0;     q=image->pixels;     q->length=MaxRunlength;i#     for (y=0; y < image->rows; y++),     {)C       p=pcx_pixels+(y*pcx_header.bytes_per_line*pcx_header.planes);L       r=scanline;e&       if (image->class == DirectClass)3         for (i=0; i < (int) pcx_header.planes; i++) 	         {t           r=scanline+i;i7           for (x=0; x < pcx_header.bytes_per_line; x++)            {*             switch (i)
             {                case 0:c               {o!                 *r=UpScale(*p++);o                 break;               }e               case 1:                {p!                 *r=UpScale(*p++);s                 break;               }N               case 2:u               {r!                 *r=UpScale(*p++);                  break;               }(               case 3:D               default:               { !                 *r=UpScale(*p++);i                 break;               } 
             }i!             r+=pcx_header.planes;            } 	         } 
       else"         if (pcx_header.planes > 1)           {r.             for (x=0; x < image->columns; x++)               *r++=0; 7             for (i=0; i < (int) pcx_header.planes; i++)e
             {e               r=scanline; ;               for (x=0; x < pcx_header.bytes_per_line; x++)                {=                  bits=(*p++);s5                  for (mask=0x80; mask != 0; mask>>=1)>                  {#                    if (bits & mask)0                       *r|=1 << i;                    r++;o                  }                }
             }.           }          else,           switch (pcx_header.bits_per_pixel)           {=             case 1:e
             {                register int                 bit;  5               for (x=0; x < (image->columns-7); x+=8)s               {s,                 for (bit=7; bit >= 0; bit--)<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               }i,               if ((image->columns % 8) != 0)                 {sE                   for (bit=7; bit >= (8-(image->columns % 8)); bit--)l>                     *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                   p++;                 }                break;
             }-             case 2:l
             {k5               for (x=0; x < (image->columns-3); x+=4)t               {-%                 *r++=(*p >> 6) & 0x3; %                 *r++=(*p >> 4) & 0x3; %                 *r++=(*p >> 2) & 0x3;m                  *r++=(*p) & 0x3;                 p++;               }e,               if ((image->columns % 4) != 0)                 {d?                   for (i=3; i >= (4-(image->columns % 4)); i--)g.                     *r++=(*p >> (i*2)) & 0x03;                   p++;                 }u               break;
             }              case 4:n
             { 5               for (x=0; x < (image->columns-1); x+=2)                {h%                 *r++=(*p >> 4) & 0xf;h                  *r++=(*p) & 0xf;                 p++;               }u,               if ((image->columns % 2) != 0)'                 *r++=(*p++ >> 4) & 0xf;(               break;
             }              case 8: 
             {+0               for (x=0; x < image->columns; x++)                 *r++=(*p++);               break;
             })             default:               break;           }+       /*          Transfer image scanline.       */       r=scanline;0(       for (x=0; x < image->columns; x++)       { (         if (image->class == PseudoClass)           index=(*r++);*         else           {o             red=UpScale(*r++);              green=UpScale(*r++);             blue=UpScale(*r++);_             if (image->matte)                index=(*r++);w           } J         if ((red == q->red) && (green == q->green) && (blue == q->blue) &&D             (index == q->index) && ((int) q->length < MaxRunlength))           q->length++;         else           {o$             if (image->packets != 0)               q++;             image->packets++;-*             if (image->packets == packets)               {p                 packets<<=1;B                 image->pixels=(RunlengthPacket *) realloc((char *)A                   image->pixels,packets*sizeof(RunlengthPacket)); >                 if (image->pixels == (RunlengthPacket *) NULL)                   {e,                     free((char *) scanline);E                     PrematureExit("Unable to allocate memory",image);                    }i1                 q=image->pixels+image->packets-1;e               }s             q->red=red;o             q->green=green;s             q->blue=blue;x             q->index=index;s             q->length=0;           }l       })3       ProgressMonitor(LoadImageText,y,image->rows);t     }e$     if (image->class == PseudoClass)       {5         SyncImage(image);           CompressColormap(image);       }      free((char *) scanline);     free((char *) pcx_pixels);E     image->pixels=(RunlengthPacket *) realloc((char *) image->pixels,P.       image->packets*sizeof(RunlengthPacket));     /*       Proceed to next image.     */-     if (page_table == (unsigned long *) NULL)C       break;     if (page_table[id] == 0)       break;/     (void) fseek(image->file,page_table[id],0);)E     status=ReadData((char *) &pcx_header.identifier,1,1,image->file);o<     if ((status == True) && (pcx_header.identifier == 0x0a))       {d
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image);;#             return((Image *) NULL);r           }.B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }r   }m+   if (page_table != (unsigned long *) NULL) %     (void) free((char *) page_table); +   while (image->previous != (Image *) NULL))     image=image->previous;   CloseImage(image);   return(image); },   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             % O %                                                                             %hO %                                                                             % O %  R e a d P D F I m a g e                                                    % O %                                                                             %_O %                                                                             %iO %                                                                             %hO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%T %,H %  Function ReadPDFImage reads a Portable Document Format image file andM %  returns it.  It allocates the memory necessary for the new Image structurea* %  and returns a pointer to the new image. %t- %  The format of the ReadPDFImage routine is:. %t% %      image=ReadPDFImage(image_info)a %,+ %  A description of each parameter follows:m %;I %    o image:  Function ReadPDFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %0A %    o image_info: Specifies a pointer to an ImageInfo structure.m %  %) */7 static Image *ReadPDFImage(const ImageInfo *image_info)  {  #define MediaBox  "/MediaBox ["a     char     command[MaxTextLength],T     *device,     filename[MaxTextLength],     options[MaxTextLength],D'     postscript_filename[MaxTextLength];      FILE
     *file;     floatr     dx_resolution,     dy_resolution,     lower_x,     lower_y,     upper_x,     upper_y,     x_resolution,&     y_resolution;d     ImageU     *image,e     *next_image;     inta
     count,     status;e  
   long int
     filesize;*     register charI     *p;*     register int     c,     i;     unsigned int     height,f
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Open temporary output file.    */)   TemporaryFilename(postscript_filename); &   file=fopen(postscript_filename,"w");   if (file == (FILE *) NULL)0     PrematureExit("Unable to write file",image);   /*     Set the page geometry.   */   *options='\0';(   if (image_info->page != (char *) NULL)     { #       (void) strcat(options," -g"); .       (void) strcat(options,image_info->page);     }%   else     for (p=command; ; )%     {%       c=fgetc(image->file);t       if (c == EOF)s         break;       (void) fputc(c,file); 
       *p++=c;tJ       if ((c != '\n') && (c != '\r') && ((p-command) < (MaxTextLength-1)))         continue;        *p='\0';       p=command;       /*5         Continue unless this is a MediaBox statement.        */:       if (strncmp(MediaBox,command,strlen(MediaBox)) != 0)         continue;rG       count=sscanf(command,"/MediaBox [ %f %f %f %f",&lower_x,&lower_y,e         &upper_x,&upper_y);t       if (count != 4)m         continue; 5       if ((lower_x > upper_x) || (lower_y > upper_y))e         continue;        /*         Determine bounding box.I       */       dx_resolution=72.0;        dy_resolution=72.0;i       x_resolution=72.0;J       count=sscanf(PSDensityGeometry,"%fx%f",&x_resolution,&y_resolution);/       if (image_info->density != (char *) NULL))N         count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);       if (count != 2)-"         y_resolution=x_resolution;,       if (image_info->page != (char *) NULL)         continue;e       /*'         Set Postscript render geometry.        */-       width=(unsigned int) (upper_x-lower_x);e-       if ((float) ((int) upper_x) != upper_x)          width++;.       height=(unsigned int) (upper_y-lower_y);-       if ((float) ((int) upper_y) != upper_y)          height++;l'       (void) sprintf(options,"-g%ux%u",oB         (unsigned int) (((width*x_resolution)/dx_resolution)+0.5),D         (unsigned int) (((height*y_resolution)/dy_resolution)+0.5));       break;     }o
   for ( ; ; )    {      c=fgetc(image->file);/     if (c == EOF)[       break;     (void) fputc(c,file);n   }G   if (ferror(file))[     {=K       Warning("An error has occurred writing to file",postscript_filename);g       (void) fclose(file);       return((Image *) NULL);      }(   (void) fclose(file);   CloseImage(image);   filesize=image->filesize;    DestroyImage(image);   /*2     Determine if the density options is specified.   */   (void) strcat(options," -r");%+   if (image_info->density == (char *) NULL) -     (void) strcat(options,PSDensityGeometry);    else/     (void) strcat(options,image_info->density);     if (image_info->subimage != 0)     { O       (void) sprintf(options,"%s -dFirstPage=%u",options,image_info->subimage); M       (void) sprintf(options,"%s -dLastPage=%u",options,image_info->subimage+           image_info->subrange-1);     }    /*0     Use Ghostscript to convert Postscript image.   */   device=PostscriptColorDevice;    if (image_info->monochrome)       device=PostscriptMonoDevice;/   (void) strcpy(filename,image_info->filename);%   for (i=0; i < 50; i++)   {%     /*$       Ghostscript eats % characters.     */,     TemporaryFilename(image_info->filename);:     if (strchr(image_info->filename,'%') == (char *) NULL)       break;   } O   (void) sprintf(command,PostscriptCommand,device,options,image_info->filename,      postscript_filename);e    status=SystemCommand(command);
   if (status)t     {o       /*7         Pre GS 3.51 does not support the pnmraw device.        */@       (void) sprintf(command,PostscriptCommand,"ppmraw",options,2         image_info->filename,postscript_filename);$       status=SystemCommand(command);     } 
   if (status)      { K       Warning("Portable Document translation failed",image_info->filename);y)       (void) remove(postscript_filename);d       return((Image *) NULL);      } !   image=ReadPNMImage(image_info);t%   (void) remove(postscript_filename);,&   (void) remove(image_info->filename);   if (image == (Image *) NULL)     { K       Warning("Portable Document translation failed",image_info->filename);        return((Image *) NULL);      }[   do   {t,     (void) strcpy(image->filename,filename);     image->filesize=filesize;      next_image=image->next; %     if (next_image != (Image *) NULL)k       image=next_image;g)   } while (next_image != (Image *) NULL);t+   while (image->previous != (Image *) NULL)g     image=image->previous;   return(image); }  p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_O %                                                                             %mO %                                                                             % O %                                                                             %mO %  R e a d P I C T I m a g e                                                  % O %                                                                             %eO %                                                                             %aO %                                                                             %hO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %=L %  Function ReadPICTImage reads an Apple Macintosh QuickDraw/PICT image fileG %  and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. %). %  The format of the ReadPICTImage routine is: % & %      image=ReadPICTImage(image_info) % + %  A description of each parameter follows:t %aJ %    o image:  Function ReadPICTImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %( %c */8 static Image *ReadPICTImage(const ImageInfo *image_info) {d   char     filename[MaxTextLength];     Image)     *image,      *next_image,     *proxy_image;      /*     Allocate image structure.(   */(   proxy_image=AllocateImage(image_info);$   if (proxy_image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   OpenImage(image_info,proxy_image,ReadBinaryType); )   if (proxy_image->file == (FILE *) NULL)h5     PrematureExit("Unable to open file",proxy_image);g   CloseImage(proxy_image);   DestroyImage(proxy_image);   /*2     Use picttoppm to convert Macintosh PICT image.   *//   (void) strcpy(filename,image_info->filename);E<   (void) sprintf(image_info->filename,PICTCommand,filename);!   image=ReadPNMImage(image_info);y   if (image == (Image *) NULL)     {a>       Warning("PICT translation failed",image_info->filename);       return((Image *) NULL);      }i   /*     Assign proper filename.i   */   do   { ,     (void) strcpy(image->filename,filename);     next_image=image->next;u%     if (next_image != (Image *) NULL)(       image=next_image;=)   } while (next_image != (Image *) NULL);i+   while (image->previous != (Image *) NULL)"     image=image->previous;   return(image); }g  
 #ifdef HasPNG) #include "png.h" /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %uO %                                                                             %fO %  R e a d P N G I m a g e                                                    % O %                                                                             % O %                                                                             %uO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %eI %  Function ReadPNGImage reads a Portable Network Graphics image file andpM %  returns it.  It allocates the memory necessary for the new Image structure_* %  and returns a pointer to the new image. %s- %  The format of the ReadPNGImage routine is:r %a% %      image=ReadPNGImage(image_info)t % + %  A description of each parameter follows:  %(I %    o image:  Function ReadPNGImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.m %-A %    o image_info: Specifies a pointer to an ImageInfo structure.u %Q %t */7 static Image *ReadPNGImage(const ImageInfo *image_info)  {    Imageg     *image;a     register int     i,     x,     y;     register unsigned char     *p;e     register RunlengthPacket     *q;   
   png_info     *ping_info;r     png_struct
     *ping;     unsigned chars     *png_pixels,     **scanlines;     unsigned int     bytes_per_line,a     packets;     unsigned short
     index,
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);D#   if (image->file == (FILE *) NULL)t/     PrematureExit("Unable to open file",image);    /*     Allocate the PNG structuress   */1   ping=(png_struct *) malloc(sizeof(png_struct));f2   ping_info=(png_info *) malloc(sizeof(png_info));H   if ((ping == (png_struct *) NULL) || (ping_info == (png_info *) NULL))5     PrematureExit("Unable to allocate memory",image);m)   image->pixels=(RunlengthPacket *) NULL;o$   png_pixels=(unsigned char *) NULL;$   scanlines=(unsigned char **) NULL;   if (setjmp(ping->jmpbuf))<     {(       /*         PNG image is corrupt.a       */9       png_read_destroy(ping,ping_info,(png_info *) NULL);d/       if (scanlines != (unsigned char **) NULL)h!         free((char *) scanlines); /       if (png_pixels != (unsigned char *) NULL) "         free((char *) png_pixels);       free((char *) ping);       free((char *) ping_info);x       CloseImage(image);6       if ((image->columns == 0) || (image->rows == 0))	         {            DestroyImage(image);!           return((Image *) NULL); 	         }p       return(image);     }    /*     Prepare PNG for reading.   */   png_info_init(ping_info);)   png_read_init(ping);    png_init_io(ping,image->file);    png_read_info(ping,ping_info);*   if (ping_info->bit_depth > QuantumDepth)     {        png_set_strip_16(ping);h       ping_info->bit_depth=8;      }     if (ping_info->bit_depth < 16)     image->depth=8;c   /*     Initialize image structure._   */"   image->columns=ping_info->width;    image->rows=ping_info->height;   image->packets=0;a5   packets=Max((image->columns*image->rows+4) >> 3,1);d    if (ping_info->bit_depth == 1)7     packets=Max((image->columns*image->rows+8) >> 4,1);SL   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));   bytes_per_line=aN     Max((int) ping_info->bit_depth >> 3,1)*ping_info->channels*image->columns;   png_pixels=(unsigned char *)7     malloc(bytes_per_line*image->rows*sizeof(Quantum));oK   scanlines=(unsigned char **) malloc(image->rows*sizeof(unsigned char *)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||/       (png_pixels == (unsigned char *) NULL) || -       (scanlines == (unsigned char **) NULL)) 5     PrematureExit("Unable to allocate memory",image);a:   if ((ping_info->color_type == PNG_COLOR_TYPE_PALETTE) ||5       (ping_info->color_type == PNG_COLOR_TYPE_GRAY))=     {        /*"         Initialize image colormap.       */       image->class=PseudoClass; .       image->colors=1 << ping_info->bit_depth;:       if (ping_info->color_type == PNG_COLOR_TYPE_PALETTE)-         image->colors=ping_info->num_palette;iP       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)9         PrematureExit("Unable to allocate memory",image); :       if (ping_info->color_type == PNG_COLOR_TYPE_PALETTE))         for (i=0; i < image->colors; i++)m	         {lD           image->colormap[i].red=UpScale(ping_info->palette[i].red);H           image->colormap[i].green=UpScale(ping_info->palette[i].green);F           image->colormap[i].blue=UpScale(ping_info->palette[i].blue);	         } 
       else)         for (i=0; i < image->colors; i++) 	         { >           image->colormap[i].red=(MaxRGB*i)/(image->colors-1);@           image->colormap[i].green=(MaxRGB*i)/(image->colors-1);?           image->colormap[i].blue=(MaxRGB*i)/(image->colors-1); 	         }      }    /*     Read image scanlines.    */"   if (image->class == DirectClass)!     if (ping_info->bit_depth < 8)        png_set_packing(ping);!   for (i=0; i < image->rows; i++) /     scanlines[i]=png_pixels+(bytes_per_line*i);%!   png_read_image(ping,scanlines);%   png_read_end(ping,ping_info);I   /*4     Convert PNG pixels to runlength-encoded packets.   */   q=image->pixels;   q->length=MaxRunlength;a"   if (image->class == DirectClass)     {h
       Quantum 
         blue,          green,         red;         /*?         Convert image to DirectClass runlength-encoded packets.p       */@       if ((ping_info->color_type == PNG_COLOR_TYPE_RGB_ALPHA) ||?           (ping_info->color_type == PNG_COLOR_TYPE_GRAY_ALPHA))          image->matte=True;%       for (y=0; y < image->rows; y++)        {e         p=scanlines[y];r*         for (x=0; x < image->columns; x++)	         {*           ReadQuantum(red,p);n           green=red;           blue=red;)A           if (ping_info->color_type != PNG_COLOR_TYPE_GRAY_ALPHA))
             { #               ReadQuantum(green,p); "               ReadQuantum(blue,p);
             }t           index=0;           if (image->matte) !             ReadQuantum(index,p); L           if ((red == q->red) && (green == q->green) && (blue == q->blue) &&F               (index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             { &               if (image->packets != 0)                 q++;               image->packets++;l,               if (image->packets == packets)                 {u                   packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket));o@                   if (image->pixels == (RunlengthPacket *) NULL)                     {c0                       free((char *) png_pixels);G                       PrematureExit("Unable to allocate memory",image);(                     }53                   q=image->pixels+image->packets-1;i                 }l               q->red=red;u               q->green=green;=               q->blue=blue;)               q->index=index;i               q->length=0;
             }l	         }e5         ProgressMonitor(LoadImageText,y,image->rows);)       }k     }c   else     {i
       Quantuma         *quantum_scanline;         register Quantum         *r;)         /*?         Convert image to PseudoClass runlength-encoded packets.l       */J       quantum_scanline=(Quantum *) malloc(image->columns*sizeof(Quantum));/       if (quantum_scanline == (Quantum *) NULL)f9         PrematureExit("Unable to allocate memory",image);t%       for (y=0; y < image->rows; y++)f       {e         p=scanlines[y];(         r=quantum_scanline;o%         switch (ping_info->bit_depth)a	         {n           case 1:;           {n             register int               bit;  9             for (x=0; x < ((int) image->columns-7); x+=8) 
             { *               for (bit=7; bit >= 0; bit--):                 *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);               p++;
             } *             if ((image->columns % 8) != 0)               {(C                 for (bit=7; bit >= (8-(image->columns % 8)); bit--)l<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               }              break;           }x           case 2:            { 9             for (x=0; x < ((int) image->columns-3); x+=4) 
             {e#               *r++=(*p >> 6) & 0x3; #               *r++=(*p >> 4) & 0x3;)#               *r++=(*p >> 2) & 0x3;a               *r++=(*p) & 0x3;               p++;
             } *             if ((image->columns % 4) != 0)               { =                 for (i=3; i >= (4-(image->columns % 4)); i--)/,                   *r++=(*p >> (i*2)) & 0x03;                 p++;               }*             break;           }            case 4:)           { 9             for (x=0; x < ((int) image->columns-1); x+=2)U
             { #               *r++=(*p >> 4) & 0xf;c               *r++=(*p) & 0xf;               p++;
             }t*             if ((image->columns % 2) != 0)%               *r++=(*p++ >> 4) & 0xf;              break;           }o           case 8:(           { .             for (x=0; x < image->columns; x++)               *r++=(*p++);             break;           }            case 16:           {c.             for (x=0; x < image->columns; x++)
             {l                ReadQuantum(*r,p);               r++;
             }              break;           }c           default:             break;	         } 
         /*"           Transfer image scanline.
         */         r=quantum_scanline;o*         for (x=0; x < image->columns; x++)	         {a           index=(*r++); F           if ((index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             {r&               if (image->packets != 0)                 q++;               image->packets++;=,               if (image->packets == packets)                 {                    packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket));m@                   if (image->pixels == (RunlengthPacket *) NULL)                     {g6                       free((char *) quantum_scanline);G                       PrematureExit("Unable to allocate memory",image);B                     }i3                   q=image->pixels+image->packets-1;m                 }s               q->index=index;m               q->length=0;
             } 	         }p5         ProgressMonitor(LoadImageText,y,image->rows);e       } &       if (image->class == PseudoClass)         SyncImage(image);a&       free((char *) quantum_scanline);+       if (ping_info->valid & PNG_INFO_tRNS)h	         {-           /*/             Image has a transparent background.c           */#           image->class=DirectClass;(           image->matte=True;           q=image->pixels;,           for (i=0; i < image->packets; i++)           {p             index=q->index;              q->index=Opaque;@             if (ping_info->color_type != PNG_COLOR_TYPE_PALETTE)               { :                 if (index == ping_info->trans_values.gray)'                   q->index=Transparent;%               }i             else/               if (index < ping_info->num_trans) 1                 q->index=ping_info->trans[index];t             q++;           } 	         }d&       if (image->class == PseudoClass)          CompressColormap(image);     })#   image->pixels=(RunlengthPacket *)aK     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));v'   if (ping_info->valid & PNG_INFO_gAMA)i"     image->gamma=ping_info->gamma;   if (ping_info->num_text > 0)     {l       unsigned int         length;g         /*!         Initialize image comment.*       */       length=1;o-       for (i=0; i < ping_info->num_text; i++)oP         length+=strlen(ping_info->text[i].key)+ping_info->text[i].text_length+4;.       image->comments=(char *) malloc(length);+       if (image->comments == (char *) NULL) 9         PrematureExit("Unable to allocate memory",image);r       *image->comments='\0';-       for (i=0; i < ping_info->num_text; i++)        {-D         p=(unsigned char *) image->comments+strlen(image->comments);?         (void) strncat(image->comments,ping_info->text[i].text, *           ping_info->text[i].text_length);*         p+=ping_info->text[i].text_length;(         if (i < (ping_info->num_text-1))           *p++='\n';         *p='\0';       }d     };   /*     Free memory.   */5   png_read_destroy(ping,ping_info,(png_info *) NULL);o   free((char *) png_pixels);   free((char *) ping);   free((char *) ping_info);r   CloseImage(image);   return(image); }  #else 7 static Image *ReadPNGImage(const ImageInfo *image_info)g {c?   Warning("PNG library is not available",image_info->filename);n$   return(ReadMIFFImage(image_info)); }a #endif p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %eO %                                                                             % O %                                                                             %iO %  R e a d P N M I m a g e                                                    %=O %                                                                             %mO %                                                                             %cO %                                                                             %=O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%( %aK %  Function ReadPNMImage reads a Portable Anymap image file and returns it. L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. % - %  The format of the ReadPNMImage routine is:  % % %      image=ReadPNMImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadPNMImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.g % A %    o image_info: Specifies a pointer to an ImageInfo structure.p %a %; */  D static unsigned int PNMInteger(Image *image,const unsigned int base) {  #define MaxRawValue  255     into     c;     unsigned int
     value;     /*      Skip any leading whitespace.   */   do   {e     c=fgetc(image->file);i     if (c == EOF)        return(0);     if (c == '#')a       {          register char 
           *p;p           unsigned int           length;r  
         /*           Read comment. 
         */-         if (image->comments != (char *) NULL)n           {F+             length=strlen(image->comments); %             p=image->comments+length;            }o         else           {(!             length=MaxTextLength;mA             image->comments=(char *) malloc(length*sizeof(char));              p=image->comments;           } 6         for ( ; image->comments != (char *) NULL; p++)	         {L.           if ((p-image->comments+2) >= length)
             {g               *p='\0';               length<<=1;L&               image->comments=(char *)F                 realloc((char *) image->comments,length*sizeof(char));3               if (image->comments == (char *) NULL)                  break;8               p=image->comments+strlen(image->comments);
             }r           c=fgetc(image->file); (           if ((c == EOF) || (c == '\n'))             break;           *p=(unsigned char) c;n	         })-         if (image->comments == (char *) NULL)            {f=             Warning("Memory allocation error",(char *) NULL);              return(0);           }e         *p++='\n';         *p='\0';       }%   } while (!isdigit(c));   if (base == 2)     return(c-'0');   /*     Evaluate number.   */
   value=0;   do   {      value*=10;     value+=c-'0';      c=fgetc(image->file);      if (c == EOF)        return(0);   }    while (isdigit(c));    return(value); }   7 static Image *ReadPNMImage(const ImageInfo *image_info)A {I   char     format;      Image      *image;      int      y;  	   Quantum 	     blue, 
     green,     red,     *scale;      register int     i,     x;     register RunlengthPacket     *q;      unsigned int     max_value,     packets,     status;      unsigned short
     index;     /*     Allocate image structure.%   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);a   /*     Open image file.   */"   OpenImage(image_info,image,"r");#   if (image->file == (FILE *) NULL)t/     PrematureExit("Unable to open file",image);f   /*     Read PNM image.r   */4   status=ReadData((char *) &format,1,1,image->file);   do   {p     /*       Verify PNM identifier.     */-     if ((status == False) || (format != 'P')) 2       PrematureExit("Not a PNM image file",image);     /*!       Initialize image structure.r     */     format=fgetc(image->file);     if (format == '7')"       (void) PNMInteger(image,10);(     image->columns=PNMInteger(image,10);%     image->rows=PNMInteger(image,10); *     if ((image->columns*image->rows) == 0)M       PrematureExit("Unable to read image: image dimensions are zero",image);r     image->packets=0;q7     packets=Max((image->columns*image->rows+4) >> 3,1);a+     if ((format == '1') || (format == '4'))g9       packets=Max((image->columns*image->rows+8) >> 4,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);o+     if ((format == '1') || (format == '4'))=        max_value=1;  /* bitmap */     else%       max_value=PNMInteger(image,10);e     scale=(Quantum *) NULL;m+     if ((format != '3') && (format != '6'))<       {e
         /*           Create colormap.
         */!         image->class=PseudoClass;f.         image->colors=Min(max_value,MaxRGB)+1;'         image->colormap=(ColorPacket *),4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);Q         if (format != '7')+           for (i=0; i < image->colors; i++)            {1@             image->colormap[i].red=(MaxRGB*i)/(image->colors-1);B             image->colormap[i].green=(MaxRGB*i)/(image->colors-1);A             image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);            }          else           {i             /*&               Initialize 332 colormap.             */             i=0;'             for (red=0; red < 8; red++)c/               for (green=0; green < 8; green++)).                 for (blue=0; blue < 4; blue++)                 {eB                   image->colormap[i].red=(Quantum) (red*MaxRGB)/7;F                   image->colormap[i].green=(Quantum) (green*MaxRGB)/7;D                   image->colormap[i].blue=(Quantum) (blue*MaxRGB)/3;                   i++;                 }            }        }a     if (max_value != MaxRGB)       {)
         /*&           Compute pixel scaling table.
         */@         scale=(Quantum *) malloc((max_value+1)*sizeof(Quantum));&         if (scale == (Quantum *) NULL);           PrematureExit("Unable to allocate memory",image);p&         for (i=0; i <= max_value; i++)E           scale[i]=(Quantum) ((i*MaxRGB+(max_value >> 1))/max_value);        }n     /*;       Convert PNM pixels to runlength-encoded MIFF packets.      */     q=image->pixels;     q->length=MaxRunlength;      switch (format)i     {d       case '1':-       { 
         /*9           Convert PBM image to runlength-encoded packets.m
         */'         for (y=0; y < image->rows; y++)a	         {u,           for (x=0; x < image->columns; x++)           {%'             index=!PNMInteger(image,2);%H             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);%5                     q=image->pixels+image->packets-1;a                   }a                 q->index=index;r                 q->length=0;               }o           }g7           ProgressMonitor(LoadImageText,y,image->rows); 	         }f         break;       }        case '2':        {a
         /*9           Convert PGM image to runlength-encoded packets.l
         */'         for (y=0; y < image->rows; y++)r	         {r,           for (x=0; x < image->columns; x++)           {r'             index=PNMInteger(image,10); *             if (scale != (Quantum *) NULL)!               index=scale[index];tH             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {B(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {t                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));nB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image); 5                     q=image->pixels+image->packets-1;i                   }p                 q->index=index;r                 q->length=0;               }            }E7           ProgressMonitor(LoadImageText,y,image->rows); 	         }e         break;       }l       case '3':        {D
         /*9           Convert PNM image to runlength-encoded packets. 
         */'         for (y=0; y < image->rows; y++)D	         {i,           for (x=0; x < image->columns; x++)           {(%             red=PNMInteger(image,10);e'             green=PNMInteger(image,10);,&             blue=PNMInteger(image,10);*             if (scale != (Quantum *) NULL)               {                  red=scale[red];g#                 green=scale[green];i!                 blue=scale[blue];k               }fN             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))e               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++;|.                 if (image->packets == packets)                   {t                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));*B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);;5                     q=image->pixels+image->packets-1;a                   }z                 q->red=red;f                 q->green=green;*                 q->blue=blue;>                 q->index=0;U                 q->length=0;
             }c           }m7           ProgressMonitor(LoadImageText,y,image->rows);i	         }i!         if (IsPseudoClass(image))g>           QuantizeImage(image,MaxRGB+1,8,False,RGBColorspace);         break;       }D       case '4':        {s         unsigned chark           bit,           byte;a           unsigned int           x,           y;  
         /*=           Convert PBM raw image to runlength-encoded packets.+
         */'         for (y=0; y < image->rows; y++)+	         {            bit=0;           byte=0;(,           for (x=0; x < image->columns; x++)           {              if (bit == 0) &               byte=fgetc(image->file);(             index=(byte & 0x80) ? 0 : 1;H             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {*(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {i                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);o5                     q=image->pixels+image->packets-1;m                   })                 q->index=index;                  q->length=0;               }t             bit++;             if (bit == 8)n               bit=0;             byte<<=1;m           }e7           ProgressMonitor(LoadImageText,y,image->rows); 	         }:         break;       }        case '5':        case '7':        {B
         /*=           Convert PGM raw image to runlength-encoded packets. 
         */'         for (y=0; y < image->rows; y++) 	         {x,           for (x=0; x < image->columns; x++)           { )             if (max_value <= MaxRawValue) '               index=fgetc(image->file);              else3               index=LSBFirstReadShort(image->file);-H             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image); 5                     q=image->pixels+image->packets-1;                    }                  q->index=index;                  q->length=0;               })           } 7           ProgressMonitor(LoadImageText,y,image->rows);l	         }c         break;       }o       case '6':-       { 
         /*@           Convert PNM raster image to runlength-encoded packets.
         */'         for (y=0; y < image->rows; y++)o	         {T,           for (x=0; x < image->columns; x++)           { )             if (max_value <= MaxRawValue)                { '                 red=fgetc(image->file);n)                 green=fgetc(image->file); (                 blue=fgetc(image->file);               }              else               { 3                 red=LSBFirstReadShort(image->file); 5                 green=LSBFirstReadShort(image->file); 4                 blue=LSBFirstReadShort(image->file);               } *             if (scale != (Quantum *) NULL)               {                  red=scale[red]; #                 green=scale[green];+!                 blue=scale[blue];-               }+N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))                q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++;m.                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));aB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);i7                       q=image->pixels+image->packets-1;                    }D                 q->red=red;,                 q->green=green;e                 q->blue=blue;*                 q->index=0;m                 q->length=0;               }t           }m7           ProgressMonitor(LoadImageText,y,image->rows); 	         }g!         if (IsPseudoClass(image)) >           QuantizeImage(image,MaxRGB+1,8,False,RGBColorspace);         break;       }h       default:4         PrematureExit("Not a PNM image file",image);     } "     if (scale != (Quantum *) NULL)       free((char *) scale);,$     if (image->class == PseudoClass)       {          SyncImage(image);o          CompressColormap(image);       }i%     image->pixels=(RunlengthPacket *) M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));s     /*       Proceed to next image.     */>     if ((format == '1') || (format == '2') || (format == '3'))       do       { 
         /*           Skip to end of line.
         */1         status=ReadData(&format,1,1,image->file);p         if (status == False)           break;       } while (format != '\n');f6     status=ReadData((char *) &format,1,1,image->file);,     if ((status == True) && (format == 'P'))       {x
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {I!             DestroyImages(image); #             return((Image *) NULL);i           }iB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } 0   } while ((status == True) && (format == 'P'));+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d P S I m a g e                                                      % O %                                                                             %IO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %pO %  Function ReadPSImage reads a Adobe Postscript image file and returns it.  IttK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % , %  The format of the ReadPSImage routine is: %:$ %      image=ReadPSImage(image_info) %c+ %  A description of each parameter follows:A %aH %    o image:  Function ReadPSImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.% %%A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */6 static Image *ReadPSImage(const ImageInfo *image_info) { % #define BoundingBox  "%%BoundingBox:" ) #define DocumentMedia  "%%DocumentMedia:" - #define PageBoundingBox  "%%PageBoundingBox:"a     char     command[MaxTextLength],      *device,     filename[MaxTextLength],     options[MaxTextLength], '     postscript_filename[MaxTextLength], &     translate_geometry[MaxTextLength];     FILE
     *file;     float      dx_resolution,     dy_resolution,     lower_x,     lower_y,     upper_x,     upper_y,     x_resolution,%     y_resolution;%     Image%     *image,%     *next_image;     inte     c,
     count,     status;l  
   long int
     filesize;l     register chare     *p;o     register int     i;     unsigned int     height,h
     width;     /*     Allocate image structure.e   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);s   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);r#   if (image->file == (FILE *) NULL)t/     PrematureExit("Unable to open file",image);i   /*     Open temporary output file.o   */)   TemporaryFilename(postscript_filename);s&   file=fopen(postscript_filename,"w");   if (file == (FILE *) NULL)0     PrematureExit("Unable to write file",image);O   (void) sprintf(translate_geometry,"%f %f translate\n              ",0.0,0.0);n(   (void) fputs(translate_geometry,file);   /*     Set the page geometry.   */   lower_x=0;   lower_y=0;   *options='\0';(   if (image_info->page != (char *) NULL)     { #       (void) strcat(options," -g"); .       (void) strcat(options,image_info->page);     }    else     for (p=command; ; )      {        c=fgetc(image->file);        if (c == EOF)          break;       (void) fputc(c,file);J
       *p++=c;eJ       if ((c != '\n') && (c != '\r') && ((p-command) < (MaxTextLength-1)))         continue;        *p='\0';       p=command;       /*'         Parse a bounding box statement.        */       count=0;@       if (strncmp(BoundingBox,command,strlen(BoundingBox)) == 0)N         count=sscanf(command,"%%%%BoundingBox: %f %f %f %f",&lower_x,&lower_y,           &upper_x,&upper_y); D       if (strncmp(DocumentMedia,command,strlen(DocumentMedia)) == 0)         count=M           sscanf(command,"%%%%DocumentMedia: %*s %f %f",&upper_x,&upper_y)+2;hH       if (strncmp(PageBoundingBox,command,strlen(PageBoundingBox)) == 0)@         count=sscanf(command,"%%%%PageBoundingBox: %f %f %f %f",/           &lower_x,&lower_y,&upper_x,&upper_y);e       if (count != 4)o         continue;a5       if ((lower_x > upper_x) || (lower_y > upper_y))e         continue;t       /*         Determine bounding box.        */       dx_resolution=72.0;p       dy_resolution=72.0;c       x_resolution=72.0;J       count=sscanf(PSDensityGeometry,"%fx%f",&x_resolution,&y_resolution);/       if (image_info->density != (char *) NULL) N         count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);       if (count != 2)h"         y_resolution=x_resolution;       /*'         Set Postscript render geometry.u       */O       (void) sprintf(translate_geometry,"%f %f translate\n",-lower_x,-lower_y); -       width=(unsigned int) (upper_x-lower_x); -       if ((float) ((int) upper_x) != upper_x)e         width++;.       height=(unsigned int) (upper_y-lower_y);-       if ((float) ((int) upper_y) != upper_y))         height++;i'       (void) sprintf(options,"-g%ux%u",iB         (unsigned int) (((width*x_resolution)/dx_resolution)+0.5),D         (unsigned int) (((height*y_resolution)/dy_resolution)+0.5));       break;     }.
   for ( ; ; )    {      c=fgetc(image->file);5     if (c == EOF)n       break;     (void) fputc(c,file);a   }o   if (ferror(file))e     {&K       Warning("An error has occurred writing to file",postscript_filename);)       (void) fclose(file);       return((Image *) NULL);i     }n   (void) fseek(file,0,0);E(   (void) fputs(translate_geometry,file);   (void) fclose(file);   CloseImage(image);   filesize=image->filesize;=   DestroyImage(image);   /*.     Determine if density options is specified.   */   (void) strcat(options," -r");t+   if (image_info->density == (char *) NULL) -     (void) strcat(options,PSDensityGeometry);    else/     (void) strcat(options,image_info->density);;   /*0     Use Ghostscript to convert Postscript image.   */   device=PostscriptColorDevice;    if (image_info->monochrome)(      device=PostscriptMonoDevice;/   (void) strcpy(filename,image_info->filename);    for (i=0; i < 50; i++)   {g     /*$       Ghostscript eats % characters.     */,     TemporaryFilename(image_info->filename);:     if (strchr(image_info->filename,'%') == (char *) NULL)       break;   }lO   (void) sprintf(command,PostscriptCommand,device,options,image_info->filename,=     postscript_filename);e    status=SystemCommand(command);
   if (status)r     {(       /*7         Pre GS 3.51 does not support the pnmraw device.,       */@       (void) sprintf(command,PostscriptCommand,"ppmraw",options,2         image_info->filename,postscript_filename);$       status=SystemCommand(command);     } *   if (!IsAccessible(image_info->filename))     {        /*1         Ghostscript requires a showpage operator.        */*       file=fopen(postscript_filename,"a");        if (file == (FILE *) NULL)4         PrematureExit("Unable to write file",image);&       (void) fputs("showpage\n",file);       (void) fclose(file);$       status=SystemCommand(command);     }x%   (void) remove(postscript_filename);d
   if (status)-     {        /*F         Ghostscript has failed-- try the Display Postscript Extension.       */3       (void) strcpy(image_info->filename,filename); %       image=ReadDPSImage(image_info);t"       if (image != (Image *) NULL)         return(image);D       Warning("Postscript translation failed",image_info->filename);       return((Image *) NULL);R     }h!   image=ReadPNMImage(image_info);-&   (void) remove(image_info->filename);   if (image == (Image *) NULL)     {_D       Warning("Postscript translation failed",image_info->filename);       return((Image *) NULL);      }    do   { ,     (void) strcpy(image->filename,filename);     image->filesize=filesize;i     next_image=image->next;;%     if (next_image != (Image *) NULL)<       image=next_image; )   } while (next_image != (Image *) NULL);o+   while (image->previous != (Image *) NULL)_     image=image->previous;   return(image); }m - /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%fO %                                                                             %IO %                                                                             %nO %                                                                             %eO %  R e a d R A D I A N C E I m a g e                                          %eO %                                                                             %*O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function ReadRADIANCEImage reads a RADIANCE image file and returns it. L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. % 2 %  The format of the ReadRADIANCEImage routine is: % * %      image=ReadRADIANCEImage(image_info) % + %  A description of each parameter follows:  % N %    o image:  Function ReadRADIANCEImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.f % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %g %t */< static Image *ReadRADIANCEImage(const ImageInfo *image_info) {a   char     command[MaxTextLength],      filename[MaxTextLength];     Image      *image,r     *next_image;     intl     status;      /*     Allocate image structure.u   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);t   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);m   CloseImage(image);   /*)     Use ra_ppm to convert RADIANCE image.a   *//   (void) strcpy(filename,image_info->filename); *   TemporaryFilename(image_info->filename);G   (void) sprintf(command,"ra_ppm %s %s",filename,image_info->filename);;    status=SystemCommand(command);
   if (status)r7     PrematureExit("RADIANCE translation failed",image);c   DestroyImage(image);!   image=ReadPNMImage(image_info); &   (void) remove(image_info->filename);   if (image == (Image *) NULL)7     PrematureExit("RADIANCE translation failed",image);U   /*     Assign proper filename.r   */   do   {m,     (void) strcpy(image->filename,filename);     next_image=image->next;e%     if (next_image != (Image *) NULL)-       image=next_image; )   } while (next_image != (Image *) NULL);h+   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }  ( /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cO %                                                                             %=O %                                                                             %hO %                                                                             %(O %  R e a d R G B I m a g e                                                    % O %                                                                             %eO %                                                                             %fO %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadRGBImage reads an image of raw red, green, and blue bytes andeM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. %o- %  The format of the ReadRGBImage routine is:s %m% %      image=ReadRGBImage(image_info); % + %  A description of each parameter follows:  % I %    o image:  Function ReadRGBImage returns a pointer to the image afteriL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.e %sA %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %n */7 static Image *ReadRGBImage(const ImageInfo *image_info)  {    Imagea     *image;c     int      x,
     x_offset,g     y,
     y_offset;m     register int     i;     register RunlengthPacket     *q;p     register unsigned char     *p;g     unsigned charn     *scanline;     unsigned int     height,      packet_size,
     width;     unsigned short
     value;     /*     Allocate image structure.p   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);e   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);J#   if (image->file == (FILE *) NULL)r/     PrematureExit("Unable to open file",image);i   /*-     Determine width and height, e.g. 640x512.L   */   width=512;
   height=512;r
   x_offset=0;g
   y_offset=0; (   if (image_info->size != (char *) NULL)     { 
       x=0;C       (void) XParseGeometry(image_info->size,&x,&y,&width,&height);c       for (i=0; i < x; i++) "         (void) fgetc(image->file);     }E   /*     Initialize image structure.c   */   image->columns=width;v   image->rows=height;j$   packet_size=3*(QuantumDepth >> 3);-   if (strcmp(image_info->magick,"RGBA") == 0)t     {        image->matte=True;(       packet_size=4*(QuantumDepth >> 3);     }    scanline=(unsigned char *)=     malloc(packet_size*image->columns*sizeof(unsigned char));d(   if (image_info->tile != (char *) NULL)O     (void) XParseGeometry(image_info->tile,&x_offset,&y_offset,&image->columns,g       &image->rows);,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)t3     malloc(image->packets*sizeof(RunlengthPacket)); -   if ((scanline == (unsigned char *) NULL) ||S2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);(   /*6     Convert raster image to runlength-encoded packets.   */    switch (image_info->interlace)   {      case NoneInterlace:o     default:     {t       /*.         No interlacing:  RGBRGBRGBRGBRGBRGB...       */"       for (y=0; y < y_offset; y++)I         (void) ReadData((char *) scanline,packet_size,width,image->file);d       q=image->pixels;%       for (y=0; y < image->rows; y++)_       {uI         (void) ReadData((char *) scanline,packet_size,width,image->file);a(         p=scanline+packet_size*x_offset;*         for (x=0; x < image->columns; x++)	         {c            ReadQuantum(q->red,p);"           ReadQuantum(q->green,p);!           ReadQuantum(q->blue,p);>           q->index=0;)           if (image->matte)R             q->index=(*p++);           q->length=0;           q++;	         }r5         ProgressMonitor(LoadImageText,y,image->rows);i       }o       break;     }S     case LineInterlace:      {        /*?         Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...        */"       for (y=0; y < y_offset; y++)I         (void) ReadData((char *) scanline,packet_size,width,image->file);g%       for (y=0; y < image->rows; y++)        {m?         (void) ReadData((char *) scanline,1,width,image->file);          p=scanline+x_offset;)         q=image->pixels+y*image->columns;i*         for (x=0; x < image->columns; x++)	         {             ReadQuantum(q->red,p);           q->index=0;            q->length=0;           q++;	         }p?         (void) ReadData((char *) scanline,1,width,image->file);c         p=scanline+x_offset;)         q=image->pixels+y*image->columns;n*         for (x=0; x < image->columns; x++)	         { "           ReadQuantum(q->green,p);           q++;	         }p?         (void) ReadData((char *) scanline,1,width,image->file);(         p=scanline+x_offset;)         q=image->pixels+y*image->columns;i*         for (x=0; x < image->columns; x++)	         {e!           ReadQuantum(q->blue,p);            q++;	         }          if (image->matte)S           {>C             (void) ReadData((char *) scanline,1,width,image->file);               p=scanline+x_offset;-             q=image->pixels+y*image->columns;o.             for (x=0; x < image->columns; x++)
             {M&               ReadQuantum(q->index,p);               q++;
             }e           }l5         ProgressMonitor(LoadImageText,y,image->rows);(       }        break;     }      case PlaneInterlace:     {U       unsigned int
         span;          /*7         Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...Q       */"       for (y=0; y < y_offset; y++)?         (void) ReadData((char *) scanline,1,width,image->file);d
       i=0;.       span=image->rows*(image->matte ? 4 : 3);       q=image->pixels;%       for (y=0; y < image->rows; y++)        {=?         (void) ReadData((char *) scanline,1,width,image->file);          p=scanline+x_offset;*         for (x=0; x < image->columns; x++)	         {x            ReadQuantum(q->red,p);           q->index=0;            q->length=0;           q++;	         }00         ProgressMonitor(LoadImageText,i++,span);       }=       q=image->pixels;.       for (y=0; y < (height-image->rows); y++)?         (void) ReadData((char *) scanline,1,width,image->file);i%       for (y=0; y < image->rows; y++)h       { ?         (void) ReadData((char *) scanline,1,width,image->file);e         p=scanline+x_offset;*         for (x=0; x < image->columns; x++)	         {s"           ReadQuantum(q->green,p);           q++;	         } 0         ProgressMonitor(LoadImageText,i++,span);       }        q=image->pixels;.       for (y=0; y < (height-image->rows); y++)?         (void) ReadData((char *) scanline,1,width,image->file); %       for (y=0; y < image->rows; y++)*       {x?         (void) ReadData((char *) scanline,1,width,image->file);          p=scanline+x_offset;*         for (x=0; x < image->columns; x++)	         { !           ReadQuantum(q->blue,p);g           q++;	         } 0         ProgressMonitor(LoadImageText,i++,span);       }        if (image->matte) 	         {d           /*             Read matte channel.            */           q=image->pixels;2           for (y=0; y < (height-image->rows); y++)C             (void) ReadData((char *) scanline,1,width,image->file);n)           for (y=0; y < image->rows; y++)u           { C             (void) ReadData((char *) scanline,1,width,image->file);               p=scanline+x_offset;.             for (x=0; x < image->columns; x++)
             {e&               ReadQuantum(q->index,p);               q++;
             }e4             ProgressMonitor(LoadImageText,i++,span);           }f	         }f       break;     }E   }r   free((char *) scanline);   CompressImage(image);n   CloseImage(image);   return(image); }  * /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d R L A I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             %%O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ReadRLAImage reads a run-length encoded Wavefront RLA image fileG %  and returns it.  It allocates the memory necessary for the new Imagep4 %  structure and returns a pointer to the new image. %GO %  Note:  This module was contributed by Lester Vecsey (master@internexus.net).i %o- %  The format of the ReadRLAImage routine is:F %t% %      image=ReadRLAImage(image_info)t %i+ %  A description of each parameter follows:r %rI %    o image:  Function ReadRLAImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.m %IA %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %o */7 static Image *ReadRLAImage(const ImageInfo *image_info)  {    typedef struct _WindowFrame    { 	     shortu       left,        right,
       bottom,m
       top;   } WindowFrame;     typedef struct _RLAHeader)   {      WindowFramei
       window,        active_window;  	     short        frame,       storage_type,"       number_channels,       number_matte_channels,        number_auxillary_channels,       revision;g       char       gamma[16],       red_primary[24],       green_primary[24],       blue_primary[24],        white_point[24];       long       job_number;o       char       name[128],       description[128],r       program[64],       machine[32],       user[32],f       date[20],v       aspect[24],        aspect_ratio[8],       chan[32];_  	     shorte       field;       char       time[12],g       filter[32];n  	     shortf       bits_per_channel,(       matte_type,        matte_bits,-       auxillary_type,i       auxillary_bits;v       char       auxillary[32],       space[36];       long       next;%   } RLAHeader;     Image%     *image;%     int      length,      runlength,     y;     long     *scanlines;      register int     i;     register RunlengthPacket     *q;      RLAHeader      rla_header;      unsigned char 	     byte;      unsigned int     channel;     /*     Allocate image structure.a   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image); 8   rla_header.window.left=MSBFirstReadShort(image->file);9   rla_header.window.right=MSBFirstReadShort(image->file); :   rla_header.window.bottom=MSBFirstReadShort(image->file);7   rla_header.window.top=MSBFirstReadShort(image->file);s?   rla_header.active_window.left=MSBFirstReadShort(image->file);s@   rla_header.active_window.right=MSBFirstReadShort(image->file);A   rla_header.active_window.bottom=MSBFirstReadShort(image->file);A>   rla_header.active_window.top=MSBFirstReadShort(image->file);2   rla_header.frame=MSBFirstReadShort(image->file);9   rla_header.storage_type=MSBFirstReadShort(image->file); <   rla_header.number_channels=MSBFirstReadShort(image->file);&   if (rla_header.number_channels == 0)!     rla_header.number_channels=3; B   rla_header.number_matte_channels=MSBFirstReadShort(image->file);F   rla_header.number_auxillary_channels=MSBFirstReadShort(image->file);5   rla_header.revision=MSBFirstReadShort(image->file);c>   (void) ReadData((char *) rla_header.gamma,16,1,image->file);D   (void) ReadData((char *) rla_header.red_primary,24,1,image->file);F   (void) ReadData((char *) rla_header.green_primary,24,1,image->file);E   (void) ReadData((char *) rla_header.blue_primary,24,1,image->file);*D   (void) ReadData((char *) rla_header.white_point,24,1,image->file);6   rla_header.job_number=MSBFirstReadLong(image->file);>   (void) ReadData((char *) rla_header.name,128,1,image->file);E   (void) ReadData((char *) rla_header.description,128,1,image->file); @   (void) ReadData((char *) rla_header.program,64,1,image->file);@   (void) ReadData((char *) rla_header.machine,32,1,image->file);=   (void) ReadData((char *) rla_header.user,32,1,image->file);/=   (void) ReadData((char *) rla_header.date,20,1,image->file);i?   (void) ReadData((char *) rla_header.aspect,24,1,image->file);cD   (void) ReadData((char *) rla_header.aspect_ratio,8,1,image->file);=   (void) ReadData((char *) rla_header.chan,32,1,image->file); 2   rla_header.field=MSBFirstReadShort(image->file);=   (void) ReadData((char *) rla_header.time,12,1,image->file);z?   (void) ReadData((char *) rla_header.filter,32,1,image->file); =   rla_header.bits_per_channel=MSBFirstReadShort(image->file);(7   rla_header.matte_type=MSBFirstReadShort(image->file);o7   rla_header.matte_bits=MSBFirstReadShort(image->file);l;   rla_header.auxillary_type=MSBFirstReadShort(image->file);.;   rla_header.auxillary_bits=MSBFirstReadShort(image->file);aB   (void) ReadData((char *) rla_header.auxillary,32,1,image->file);>   (void) ReadData((char *) rla_header.space,36,1,image->file);0   rla_header.next=MSBFirstReadLong(image->file);   /*     Initialize image structure.    */N   image->columns=rla_header.active_window.right-rla_header.active_window.left;K   image->rows=rla_header.active_window.top-rla_header.active_window.bottom;+,   image->packets=image->columns*image->rows;   image->depth=QuantumDepth;.   image->matte=rla_header.number_channels > 3;6   scanlines=(long *) malloc(image->rows*sizeof(long));#   image->pixels=(RunlengthPacket *)u3     malloc(image->packets*sizeof(RunlengthPacket));a0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image); &   if (*rla_header.description != '\0')     {(       /*         RLA image comment.       */       image->comments=(char *)@         malloc((strlen(rla_header.description)+1)*sizeof(char));+       if (image->comments == (char *) NULL)%8         PrematureExit("Unable to allocate memory",image)5       strcpy(image->comments,rla_header.description);      }    /*'     Read offsets to each scanline data.    */!   for (i=0; i < image->rows; i++) /     scanlines[i]=MSBFirstReadLong(image->file);    /*     Read image data.   */   q=image->pixels;!   for (y=0; y < image->rows; y++)a   { ;     (void) fseek(image->file,scanlines[image->rows-y-1],0); D     for (channel=0; channel < rla_header.number_channels; channel++)     { ,       length=MSBFirstReadShort(image->file);)       q=image->pixels+(y*image->columns);        while (length > 0)       { 8         (void) ReadData((char *) &byte,1,1,image->file);         runlength=byte;%         if (byte > 127)            runlength=byte-256;e         length--;r         if (length == 0)           break;         if (runlength < 0)           {e!             while (runlength < 0)r
             {g>               (void) ReadData((char *) &byte,1,1,image->file);               length--;(               switch (channel)               {t                 case 0:i                 {d                   q->red=byte;                   q->index=0;g                   q->length=0;                   break;                 }                  case 1:                  {:                    q->green=byte;                   break;                 }d                 case 2:o                 {                    q->blue=byte;                    break;                 }                  case 3:;                 default:                 {                     q->index=byte;                   break;                 }n               }t               q++;               runlength++;
             }o             continue;            }=8         (void) ReadData((char *) &byte,1,1,image->file);         length--;          runlength++;
         do	         {            switch (channel)           {p             case 0:l
             {U               q->red=byte;               q->index=0;                q->length=0;               break;
             }t             case 1: 
             {                q->green=byte;               break;
             }              case 2:i
             {r               q->blue=byte;t               break;
             }i             case 3:f             default:
             {                q->index=byte;               break;
             }g           }t           q++;           runlength--;	         }m         while (runlength > 0);       }n     }e1     ProgressMonitor(LoadImageText,y,image->rows);_   }>   CompressImage(image);&   CloseImage(image);   return(image); }m - /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cO %                                                                             %NO %                                                                             %UO %                                                                             %nO %  R e a d R L E I m a g e                                                    %)O %                                                                             %;O %                                                                             %=O %                                                                             %0O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%- %nG %  Function ReadRLEImage reads a run-length encoded Utah Raster ToolkitwL %  image file and returns it.  It allocates the memory necessary for the new: %  Image structure and returns a pointer to the new image. %%- %  The format of the ReadRLEImage routine is:% %%% %      image=ReadRLEImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadRLEImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadRLEImage(const ImageInfo *image_info)  {  #define SkipLinesOp  0x01  #define SetColorOp  0x02 #define SkipPixelsOp  0x03 #define ByteDataOp  0x05 #define RunDataOp  0x06  #define EOFOp  0x07%     char     magick[12];%     Image%     *image;%     int%     opcode,      operand,     status,e     x,     y;     register int     i,     j;     register RunlengthPacket     *q;      register unsigned char     *p;i     unsigned charg     background_color[256],     *colormap,
     pixel,
     plane,     *rle_pixels;     unsigned int     bits_per_pixel,h
     flags,     map_length,      number_colormaps,M     number_planes;     /*     Allocate image structure.i   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);/#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);I   /*$     Determine if this is a RLE file.   */3   status=ReadData((char *) magick,1,2,image->file); ?   if ((status == False) || (strncmp(magick,"\122\314",2) != 0)) 0     PrematureExit("Not a RLE image file",image);   do   {z     /*       Read image header.     */*     (void) LSBFirstReadShort(image->file);*     (void) LSBFirstReadShort(image->file);2     image->columns=LSBFirstReadShort(image->file);/     image->rows=LSBFirstReadShort(image->file);l.     image->packets=image->columns*image->rows;     flags=fgetc(image->file);(     image->matte=flags & 0x04;%     number_planes=fgetc(image->file);g&     bits_per_pixel=fgetc(image->file);(     number_colormaps=fgetc(image->file);'     map_length=1 << fgetc(image->file); P     if ((number_planes == 0) || (number_planes == 2) || (bits_per_pixel != 8) ||         (image->columns == 0))8       PrematureExit("Unsupported RLE image file",image);     if (flags & 0x02)        {m
         /*4           No background color-- initialize to black.
         */)         for (i=0; i < number_planes; i++) 0           background_color[i]=(unsigned char) 0;"         (void) fgetc(image->file);       }      else       { 
         /*&           Initialize background color.
         */         p=background_color;c)         for (i=0; i < number_planes; i++)+2           *p++=(unsigned char) fgetc(image->file);       } $     if ((number_planes & 0x01) == 0)        (void) fgetc(image->file);$     colormap=(unsigned char *) NULL;     if (number_colormaps != 0)       { 
         /*           Read image colormaps.*
         */"         colormap=(unsigned char *)D           malloc(number_colormaps*map_length*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image);          p=colormap; ,         for (i=0; i < number_colormaps; i++)(           for (j=0; j < map_length; j++)<             *p++=XDownScale(LSBFirstReadShort(image->file));       }h     if (flags & 0x08)        {r         unsigned int           length;t  
         /*           Read image comment. 
         */.         length=LSBFirstReadShort(image->file);=         image->comments=(char *) malloc(length*sizeof(char));U-         if (image->comments == (char *) NULL)p;           PrematureExit("Unable to allocate memory",image);lI         (void) ReadData((char *) image->comments,1,length-1,image->file);e'         image->comments[length-1]='\0'; !         if ((length & 0x01) == 0) $           (void) fgetc(image->file);       }p     /*       Allocate RLE pixels.     */     if (image->matte)        number_planes++;      rle_pixels=(unsigned char *)A       malloc(image->packets*number_planes*sizeof(unsigned char));(-     if (rle_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image); *     if ((flags & 0x01) && !(flags & 0x02))       {l
         /*           Set background color.+
         */         p=rle_pixels;m*         for (i=0; i < image->packets; i++)	         {            if (!image->matte)-             for (j=0; j < number_planes; j++) '               *p++=background_color[j];s           else
             {t3               for (j=0; j < (number_planes-1); j++)g)                 *p++=background_color[j]; 5               *p++=0;  /* initialize matte channel */ 
             } 	         }a       }C     /*#       Read runlength-encoded image.      */     plane=0;     x=0;     y=0;     opcode=fgetc(image->file);     do     {        switch (opcode & 0x3f)       {a         case SkipLinesOp:c	         {"%           operand=fgetc(image->file);(           if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);c           x=0;           y+=operand;            break;	         }t         case SetColorOp:	         { %           operand=fgetc(image->file);n           plane=operand;           if (plane == 255) "             plane=number_planes-1;           x=0;           break;	         }o         case SkipPixelsOp:	         {g%           operand=fgetc(image->file);            if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);u           x+=operand;            break;	         }a         case ByteDataOp:	         {m%           operand=fgetc(image->file);p           if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file); H           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;           operand++;%           for (i=0; i < operand; i++)e           {)%             pixel=fgetc(image->file);u>             if ((y < image->rows) && ((x+i) < image->columns))               *p=pixel;              p+=number_planes;            }F           if (operand & 0x01)k&             (void) fgetc(image->file);           x+=operand;g           break;	         }r         case RunDataOp:)	         { %           operand=fgetc(image->file);N           if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file); #           pixel=fgetc(image->file);v$           (void) fgetc(image->file);           operand++;H           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;%           for (i=0; i < operand; i++)s           {o>             if ((y < image->rows) && ((x+i) < image->columns))               *p=pixel;n             p+=number_planes;            }c           x+=operand;            break;	         }          default:           break;       }         opcode=fgetc(image->file);<     } while (((opcode & 0x3f) != EOFOp) && (opcode != EOF));     if (number_colormaps != 0)       {E         unsigned int           mask;   
         /*1           Apply colormap transformation to image. 
         */         mask=(map_length-1);         p=rle_pixels;l"         if (number_colormaps == 1),           for (i=0; i < image->packets; i++)           {>3             *p=(unsigned char) colormap[*p & mask];r             p++;           }          else>           if ((number_planes >= 3) && (number_colormaps >= 3)).             for (i=0; i < image->packets; i++)/               for (j=0; j < number_planes; j++)=               {mF                 *p=(unsigned char) colormap[j*map_length+(*p & mask)];                 p++;               }        }c     /*!       Initialize image structure.      */%     image->pixels=(RunlengthPacket *)d5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      q=image->pixels;     if (number_planes >= 3)        { 
         /*H           Convert raster image to DirectClass runlength-encoded packets.
         */         p=rle_pixels; '         for (y=0; y < image->rows; y++)e	         {c,           for (x=0; x < image->columns; x++)           {h!             q->red=UpScale(*p++);t#             q->green=UpScale(*p++);d"             q->blue=UpScale(*p++);B             q->index=(unsigned short) (image->matte ? (*p++) : 0);             q->length=0;             q++;           })7           ProgressMonitor(LoadImageText,y,image->rows);o	         }        }      else       {m
         /*           Create colormap.
         */!         image->class=PseudoClass; "         if (number_colormaps == 0)           map_length=256;n!         image->colors=map_length; '         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);          p=colormap; "         if (number_colormaps == 0)+           for (i=0; i < image->colors; i++)o           {              /*               Grayscale.             */@             image->colormap[i].red=(MaxRGB*i)/(image->colors-1);B             image->colormap[i].green=(MaxRGB*i)/(image->colors-1);A             image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);            }          else$           if (number_colormaps == 1)-             for (i=0; i < image->colors; i++)m
             {]               /*                 Pseudocolor.               */:               image->colormap[i].red=(Quantum) UpScale(i);<               image->colormap[i].green=(Quantum) UpScale(i);;               image->colormap[i].blue=(Quantum) UpScale(i);e
             }a           else-             for (i=0; i < image->colors; i++)>
             { 1               image->colormap[i].red=UpScale(*p); @               image->colormap[i].green=UpScale(*(p+map_length));A               image->colormap[i].blue=UpScale(*(p+map_length*2));r               p++;
             }m         p=rle_pixels;i         if (!image->matte)           {z             /*L               Convert raster image to PseudoClass runlength-encoded packets.             */+             for (y=0; y < image->rows; y++)d
             {c0               for (x=0; x < image->columns; x++)               {e1                 q->index=(unsigned short) (*p++);]                 q->length=0;                 q++;               } ;               ProgressMonitor(LoadImageText,y,image->rows);e
             }              SyncImage(image);)           }          else           {              /*A               Image has a matte channel-- promote to DirectClass.              */+             for (y=0; y < image->rows; y++) 
             {f0               for (x=0; x < image->columns; x++)               {f/                 q->red=image->colormap[*p].red;o3                 q->green=image->colormap[*p].green;g3                 q->blue=image->colormap[*p++].blue;m1                 q->index=(unsigned short) (*p++);o                 q->length=0;                 q++;               }o;               ProgressMonitor(LoadImageText,y,image->rows);k
             }e"             free(image->colormap);1             image->colormap=(ColorPacket *) NULL;g%             image->class=DirectClass;              image->colors=0;           }*       }s     if (number_colormaps != 0)       free((char *) colormap);     free((char *) rle_pixels);     CompressImage(image);m     /*       Proceed to next image.     */     (void) fgetc(image->file);5     status=ReadData((char *) magick,1,2,image->file);i@     if ((status == True) && (strncmp(magick,"\122\314",2) == 0))       {,
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {n!             DestroyImages(image);s#             return((Image *) NULL);            }tB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } D   } while ((status == True) && (strncmp(magick,"\122\314",2) == 0));+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }p l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %eO %                                                                             % O %                                                                             %(O %  R e a d S G I I m a g e                                                    % O %                                                                             %mO %                                                                             % O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%c % G %  Function ReadSGIImage reads a SGI RGB image file and returns it.  ItnK %  allocates the memory necessary for the new Image structure and returns ao %  pointer to the new image. %(- %  The format of the ReadSGIImage routine is:e %o% %      image=ReadSGIImage(image_info)  % + %  A description of each parameter follows:( %&I %    o image:  Function ReadSGIImage returns a pointer to the image aftereL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.) %LA %    o image_info: Specifies a pointer to an ImageInfo structure.e %n %m */  C static void SGIDecode(unsigned char *packets,unsigned char *pixels)m {_   unsigned char 
     count,
     pixel;     for ( ; ;)   {      pixel=(*packets++);e     count=pixel & 0x7f;-     if (count == 0);       break;     if (pixel & 0x80) "       for ( ; count != 0; count--)       {v         *pixels=(*packets++);m         pixels+=4;       }I     else       {u         pixel=(*packets++);%$         for ( ; count != 0; count--)	         {%           *pixels=pixel;           pixels+=4;	         }        }    }  }   7 static Image *ReadSGIImage(const ImageInfo *image_info)  {    typedef struct _SGIHeader    {      unsigned short       magic;       unsigned char        storage,       bytes_per_pixel;       unsigned short       dimension,       columns,       rows,        depth;       unsigned long        minimum_value,       maximum_value;       unsigned char        filler[492];   } SGIHeader;     Image      *image;      SGIHeader      iris_header;     register int     i,     x,     y,     z;     register RunlengthPacket     *q;%     register unsigned char     *p;%     unsigned charn     *iris_pixels;      /*     Allocate image structure.r   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);p   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL))/     PrematureExit("Unable to open file",image);    /*     Read SGI raster header.O   */3   iris_header.magic=MSBFirstReadShort(image->file);g   do   {m     /*       Verify SGI identifier.     */$     if (iris_header.magic != 0x01DA)1       PrematureExit("Not a SGI RGB image",image); +     iris_header.storage=fgetc(image->file);I3     iris_header.bytes_per_pixel=fgetc(image->file); )     if (iris_header.bytes_per_pixel != 1) F       PrematureExit("Image must have 1 byte per pixel channel",image);9     iris_header.dimension=MSBFirstReadShort(image->file); 7     iris_header.columns=MSBFirstReadShort(image->file);n4     iris_header.rows=MSBFirstReadShort(image->file);5     iris_header.depth=MSBFirstReadShort(image->file);e<     iris_header.minimum_value=MSBFirstReadLong(image->file);<     iris_header.maximum_value=MSBFirstReadLong(image->file);2     (void) ReadData((char *) iris_header.filler,1,=       (unsigned int) sizeof(iris_header.filler),image->file);      /*       Allocate SGI pixels.     */!     iris_pixels=(unsigned char *)eK       malloc(4*iris_header.columns*iris_header.rows*sizeof(unsigned char));_.     if (iris_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image);g$     if (iris_header.storage != 0x01)       {          unsigned char            *scanline;  
         /*%           Read standard image format.e
         */"         scanline=(unsigned char *)<           malloc(iris_header.columns*sizeof(unsigned char));/         if (scanline == (unsigned char *) NULL)f;           PrematureExit("Unable to allocate memory",image);s3         for (z=0; z < (int) iris_header.depth; z++) 	         {m           p=iris_pixels+z;4           for (y=0; y < (int) iris_header.rows; y++)           {CD             (void) ReadData((char *) scanline,1,iris_header.columns,               image->file);e9             for (x=0; x < (int) iris_header.columns; x++) 
             {o               *p=scanline[x];)               p+=4;U
             }t           }g	         }           free((char *) scanline);       }m     else       {d         unsigned charo           *packets;l           unsigned int           data_order;            unsigned long=           offset,c           *offsets,*           *runlength;i  
         /*.           Read runlength-encoded image format.
         */!         offsets=(unsigned long *))K           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long));h!         packets=(unsigned char *)+H           malloc(((iris_header.columns << 1)+10)*sizeof(unsigned char));#         runlength=(unsigned long *)xK           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long));c2         if ((offsets == (unsigned long *) NULL) ||2             (packets == (unsigned char *) NULL) ||2             (runlength == (unsigned long *) NULL));           PrematureExit("Unable to allocate memory",image);;F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)3           offsets[i]=MSBFirstReadLong(image->file); F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)5           runlength[i]=MSBFirstReadLong(image->file); 
         /*           Check data order.P
         */         offset=0;          data_order=0;oE         for (y=0; ((y < (int) iris_header.rows) && !data_order); y++)sH           for (z=0; ((z < (int) iris_header.depth) && !data_order); z++)           { 7             if (offsets[y+z*iris_header.rows] < offset)y               data_order=1;s1             offset=offsets[y+z*iris_header.rows];c           } A         offset=512+4*((iris_header.rows*iris_header.depth) << 1);f         if (data_order == 1)           {%7             for (z=0; z < (int) iris_header.depth; z++)%
             {%               p=iris_pixels;8               for (y=0; y < (int) iris_header.rows; y++)               { <                 if (offset != offsets[y+z*iris_header.rows])                   { 9                     offset=offsets[y+z*iris_header.rows]; =                     (void) fseek(image->file,(int) offset,0);                    } 3                 (void) ReadData((char *) packets,1, N                   (unsigned int) runlength[y+z*iris_header.rows],image->file);8                 offset+=runlength[y+z*iris_header.rows];'                 SGIDecode(packets,p+z); +                 p+=(iris_header.columns*4);%               }%
             }%           }          else           {e             p=iris_pixels;6             for (y=0; y < (int) iris_header.rows; y++)
             {u9               for (z=0; z < (int) iris_header.depth; z++)T               {R<                 if (offset != offsets[y+z*iris_header.rows])                   {r9                     offset=offsets[y+z*iris_header.rows];t=                     (void) fseek(image->file,(int) offset,0);r                   }i3                 (void) ReadData((char *) packets,1, N                   (unsigned int) runlength[y+z*iris_header.rows],image->file);8                 offset+=runlength[y+z*iris_header.rows];'                 SGIDecode(packets,p+z);m               } )               p+=(iris_header.columns*4); 
             }i           }          free(runlength);         free(packets);         free(offsets);       }      /*!       Initialize image structure.n     */(     image->matte=iris_header.depth == 4;'     image->columns=iris_header.columns; !     image->rows=iris_header.rows; .     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *))5       malloc(image->packets*sizeof(RunlengthPacket));(2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);i     /*<       Convert SGI raster image to runlength-encoded packets.     */     q=image->pixels;     if (iris_header.depth >= 3)p       {i
         /*E           Convert SGI image to DirectClass runlength-encoded packets.f
         */'         for (y=0; y < image->rows; y++)a	         { ?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4); ,           for (x=0; x < image->columns; x++)           {_             q->red=UpScale(*p);a%             q->green=UpScale(*(p+1));g$             q->blue=UpScale(*(p+2));             q->index=(*(p+3));             q->length=0;             p+=4;G             q++;           }s7           ProgressMonitor(LoadImageText,y,image->rows);g	         }(       }T     else       {m         unsigned short           index;  
         /*           Create grayscale map. 
         */!         image->class=PseudoClass;;         image->colors=256;'         image->colormap=(ColorPacket *)a4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);n)         for (i=0; i < image->colors; i++)t	         {n6           image->colormap[i].red=(Quantum) UpScale(i);8           image->colormap[i].green=(Quantum) UpScale(i);7           image->colormap[i].blue=(Quantum) UpScale(i);r	         }c
         /*E           Convert SGI image to PseudoClass runlength-encoded packets. 
         */'         for (y=0; y < image->rows; y++)m	         {y?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4); ,           for (x=0; x < image->columns; x++)           {U(             index=(unsigned short) (*p);             q->index=index;;             q->length=0;             p+=4;              q++;           }y7           ProgressMonitor(LoadImageText,y,image->rows); 	         }l         SyncImage(image);        };     free((char *) iris_pixels);;     CompressImage(image);e     /*       Proceed to next image.     */5     iris_header.magic=MSBFirstReadShort(image->file); $     if (iris_header.magic == 0x01DA)       {e
         /*#           Allocate image structure.g
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image);m#             return((Image *) NULL);t           } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }e(   } while (iris_header.magic == 0x01DA);+   while (image->previous != (Image *) NULL)_     image=image->previous;   CloseImage(image);   return(image); }- x /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             % O %                                                                             %eO %                                                                             %!O %  R e a d S U N I m a g e                                                    %aO %                                                                             % O %                                                                             %IO %                                                                             %%O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadSUNImage reads a SUN image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % - %  The format of the ReadSUNImage routine is:  % % %      image=ReadSUNImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadSUNImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.% %% %% */7 static Image *ReadSUNImage(const ImageInfo *image_info)  {  #define RMT_EQUAL_RGB  1 #define RMT_NONE  0s #define RMT_RAW  2 #define RT_STANDARD  1 #define RT_ENCODED  2w #define RT_FORMAT_RGB  3     typedef struct _SUNHeaders   {      unsigned longM       magic,       width,
       height,o       depth,
       length,        type,e       maptype,       maplength;   } SUNHeader;     Imageg     *image;i     register int     bit,     i,     x,     y;     register RunlengthPacket     *q;t     register unsigned char     *p;e     SUNHeaderr     sun_header;s     unsigned char      *sun_data,     *sun_pixels;     unsigned int     status;      /*     Allocate image structure.o   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);n   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);(   /*     Read SUN raster header.n   */1   sun_header.magic=MSBFirstReadLong(image->file);p   do   {g     /*       Verify SUN identifier.     */'     if (sun_header.magic != 0x59a66a95)(4       PrematureExit("Not a SUN raster image",image);3     sun_header.width=MSBFirstReadLong(image->file);u4     sun_header.height=MSBFirstReadLong(image->file);3     sun_header.depth=MSBFirstReadLong(image->file); 4     sun_header.length=MSBFirstReadLong(image->file);2     sun_header.type=MSBFirstReadLong(image->file);5     sun_header.maptype=MSBFirstReadLong(image->file);+7     sun_header.maplength=MSBFirstReadLong(image->file);c     switch (sun_header.maptype);     {f       case RMT_NONE:       {c"         if (sun_header.depth < 24)           {c             /*'               Create linear color ramp.a             */0             image->colors=1 << sun_header.depth;+             image->colormap=(ColorPacket *) 8               malloc(image->colors*sizeof(ColorPacket));8             if (image->colormap == (ColorPacket *) NULL)?               PrematureExit("Unable to allocate memory",image);S-             for (i=0; i < image->colors; i++) 
             {eB               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1); 
             }s           }          break;       }        case RMT_EQUAL_RGB:        {          unsigned char            *sun_colormap;  
         /*#           Read SUN raster colormap. 
         */-         image->colors=sun_header.maplength/3; '         image->colormap=(ColorPacket *)P4           malloc(image->colors*sizeof(ColorPacket));&         sun_colormap=(unsigned char *)6           malloc(image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||5             (sun_colormap == (unsigned char *) NULL))w;           PrematureExit("Unable to allocate memory",image);gK         (void) ReadData((char *) sun_colormap,1,image->colors,image->file);g)         for (i=0; i < image->colors; i++)>:           image->colormap[i].red=UpScale(sun_colormap[i]);K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file);o)         for (i=0; i < image->colors; i++)n<           image->colormap[i].green=UpScale(sun_colormap[i]);K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file); )         for (i=0; i < image->colors; i++) ;           image->colormap[i].blue=UpScale(sun_colormap[i]);k$         free((char *) sun_colormap);         break;       }g       case RMT_RAW:        {g         unsigned charl           *sun_colormap;  
         /*#           Read SUN raster colormap.=
         */&         sun_colormap=(unsigned char *)=           malloc(sun_header.maplength*sizeof(unsigned char)); 3         if (sun_colormap == (unsigned char *) NULL)e;           PrematureExit("Unable to allocate memory",image);%>         (void) ReadData((char *) sun_colormap,1,(unsigned int),           sun_header.maplength,image->file);$         free((char *) sun_colormap);         break;       }        default:>         PrematureExit("Colormap type is not supported",image);     } O     sun_data=(unsigned char *) malloc(sun_header.length*sizeof(unsigned char)); +     if (sun_data == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image); I     status=ReadData((char *) sun_data,1,(unsigned int) sun_header.length,        image->file); =     if ((status == False) && (sun_header.type != RT_ENCODED)) 7       PrematureExit("Unable to read image data",image);%     sun_pixels=sun_data;&     if (sun_header.type == RT_ENCODED)       {L         unsigned int           width,           height;e  
         /*0           Read run-length encoded raster pixels.
         */?         width=sun_header.width*(((sun_header.depth-1) >> 3)+1); !         height=sun_header.height; P         sun_pixels=(unsigned char *) malloc(width*height*sizeof(unsigned char));1         if (sun_pixels == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image);s@         (void) SUNDecodeImage(sun_data,sun_pixels,width,height);          free((char *) sun_data);       }s     /*!       Initialize image structure.U     */*     image->matte=(sun_header.depth == 32);E     image->class=(sun_header.depth < 24 ? PseudoClass : DirectClass);e$     image->columns=sun_header.width;"     image->rows=sun_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert SUN raster image to runlength-encoded packets.     */     p=sun_pixels;      q=image->pixels;     if (sun_header.depth == 1)%       for (y=0; y < image->rows; y++)        { 
         /*E           Convert bitmap scanline to runlength-encoded color packets. 
         */1         for (x=0; x < (image->columns >> 3); x++) 	         { &           for (bit=7; bit >= 0; bit--)           {%:             q->index=((*p) & (0x01 << bit) ? 0x00 : 0x01);             q->length=0;             q++;           }i           p++;	         }a&         if ((image->columns % 8) != 0)           {t?             for (bit=7; bit >= (8-(image->columns % 8)); bit--) 
             {i<               q->index=((*p) & (0x01 << bit) ? 0x00 : 0x01);               q->length=0;               q++;
             }e             p++;           } I         if ((((image->columns/8)+(image->columns % 8 ? 1 : 0)) % 2) != 0)e           p++;5         ProgressMonitor(LoadImageText,y,image->rows);l       }s     else&       if (image->class == PseudoClass)'         for (y=0; y < image->rows; y++) 	         {f           /*L             Convert PseudoColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {c             q->index=(*p++);             q->length=0;             q++;           } (           if ((image->columns % 2) != 0)             p++;7           ProgressMonitor(LoadImageText,y,image->rows); 	         }e
       else'         for (y=0; y < image->rows; y++)d	         {)           /*L             Convert DirectColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {2B             q->index=(unsigned short) (image->matte ? (*p++) : 0);/             if (sun_header.type == RT_STANDARD)                {s&                 q->blue=UpScale(*p++);'                 q->green=UpScale(*p++); %                 q->red=UpScale(*p++);                }(             else               {(%                 q->red=UpScale(*p++);t'                 q->green=UpScale(*p++);+&                 q->blue=UpScale(*p++);               } #             if (image->colors != 0))               {>3                 q->red=image->colormap[q->red].red; 9                 q->green=image->colormap[q->green].green;;6                 q->blue=image->colormap[q->blue].blue;               }e             q->length=0;             q++;           }dE           if (((image->columns % 2) != 0) && (image->matte == False))              p++;7           ProgressMonitor(LoadImageText,y,image->rows); 	         }      free((char *) sun_pixels);$     if (image->class == PseudoClass)       {s         SyncImage(image);f          CompressColormap(image);       };     CompressImage(image);e     /*       Proceed to next image.     */3     sun_header.magic=MSBFirstReadLong(image->file);*'     if (sun_header.magic == 0x59a66a95)l       {e
         /*#           Allocate image structure.L
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image);l#             return((Image *) NULL);o           }BB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }f+   } while (sun_header.magic == 0x59a66a95);y+   while (image->previous != (Image *) NULL)(     image=image->previous;   CloseImage(image);   return(image); }d . /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             %sO %                                                                             %_O %                                                                             %sO %  R e a d T G A I m a g e                                                    %eO %                                                                             %lO %                                                                             %oO %                                                                             %cO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %tJ %  Function ReadTGAImage reads a Truevision TGA image file and returns it.L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %r- %  The format of the ReadTGAImage routine is:l %,% %      image=ReadTGAImage(image_info)( %p+ %  A description of each parameter follows:  %vI %    o image:  Function ReadTGAImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.m %_A %    o image_info: Specifies a pointer to an ImageInfo structure.s %= %g */7 static Image *ReadTGAImage(const ImageInfo *image_info)t {P #define TGAColormap 1/ #define TGARGB 2 #define TGAMonochrome 3t #define TGARLEColormap  9  #define TGARLERGB  10_ #define TGARLEMonochrome  11     typedef struct _TGAHeadere   {,     unsigned char_       id_length,       colormap_type,       image_type;(       unsigned short       colormap_index,a       colormap_length;       unsigned charg       colormap_size;       unsigned short       x_origin,t       y_origin,_       width,
       height;a       unsigned char        pixel_size,i       attributes;    } TGAHeader;     Image      *image;   	   Quantumg	     blue, 
     green,     red;     register int     i,     x,     y;     register RunlengthPacket     *q;;     TGAHeaderi     tga_header;      unsigned char      j,     k,     runlength;     unsigned int	     base, 	     flag,      offset,o	     real,s	     skip,      status;=     unsigned short
     index;     /*     Allocate image structure.(   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);f   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);o#   if (image->file == (FILE *) NULL)D/     PrematureExit("Unable to open file",image);*   /*      Read TGA header information.   */B   status=ReadData((char *) &tga_header.id_length,1,1,image->file);.   tga_header.colormap_type=fgetc(image->file);+   tga_header.image_type=fgetc(image->file);p   do   {e<     if ((status == False) || (tga_header.image_type == 0) ||%         (tga_header.image_type > 11))!2       PrematureExit("Not a TGA image file",image);=     tga_header.colormap_index=LSBFirstReadShort(image->file);i>     tga_header.colormap_length=LSBFirstReadShort(image->file);0     tga_header.colormap_size=fgetc(image->file);7     tga_header.x_origin=LSBFirstReadShort(image->file);i7     tga_header.y_origin=LSBFirstReadShort(image->file); 4     tga_header.width=LSBFirstReadShort(image->file);5     tga_header.height=LSBFirstReadShort(image->file);5-     tga_header.pixel_size=fgetc(image->file);i-     tga_header.attributes=fgetc(image->file);=     /*!       Initialize image structure.      */-     image->matte=tga_header.pixel_size == 32; $     image->columns=tga_header.width;"     image->rows=tga_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *);5       malloc(image->packets*sizeof(RunlengthPacket));=2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image); "     if (tga_header.id_length != 0)       {1
         /*           TGA image comment.
         */          image->comments=(char *)8           malloc((tga_header.id_length+1)*sizeof(char));-         if (image->comments == (char *) NULL)g;           PrematureExit("Unable to allocate memory",image);eL         (void) ReadData(image->comments,1,tga_header.id_length,image->file);3         image->comments[tga_header.id_length]='\0';g       }*
     red=0;     green=0;     blue=0; &     if (tga_header.colormap_type != 0)       {)
         /*#           Read TGA raster colormap.m
         */8         if ((tga_header.image_type == TGARLEColormap) ||1             (tga_header.image_type == TGARLERGB))=#           image->class=PseudoClass; 1         image->colors=tga_header.colormap_length;0'         image->colormap=(ColorPacket *)e4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);m)         for (i=0; i < image->colors; i++)_	         {)+           switch (tga_header.colormap_size)e           {.             case 8:g             default:
             {w               /*                 Gray scale.m               */.               red=UpScale(fgetc(image->file));               green=red;               blue=red;*               break;
             }f             case 15:             case 16:
             {m               /*2                 5 bits each of red green and blue.               */#               j=fgetc(image->file);0#               k=fgetc(image->file); B               red=(Quantum) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);               green=(Quantum)iP                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);>               blue=(Quantum) ((MaxRGB*((int) (j & 0x1f)))/31);               break;
             }              case 32:             case 24:
             {                /*3                 8 bits each of blue, green and red.                *//               blue=UpScale(fgetc(image->file));a0               green=UpScale(fgetc(image->file));.               red=UpScale(fgetc(image->file));               break;
             }            }=%           image->colormap[i].red=red; )           image->colormap[i].green=green; '           image->colormap[i].blue=blue; 	         }        }r     /*6       Convert TGA pixels to runlength-encoded packets.     */     base=0;+     flag=0;      index=0;     skip=False;n     real=0;      runlength=0;
     offset=0;n     q=image->pixels;&     for (i=0; i < image->packets; i++)     {        q->red=0;_       q->green=0;        q->blue=0;       q->index=0;e       q->length=0;
       q++;     } #     for (y=0; y < image->rows; y++)      {a       real=offset;E       if (((unsigned char) (tga_header.attributes & 0x20) >> 5) == 0)           real=image->rows-real-1;,       q=image->pixels+(real*image->columns);(       for (x=0; x < image->columns; x++)       {g8         if ((tga_header.image_type == TGARLEColormap) ||3             (tga_header.image_type == TGARLERGB) ||m8             (tga_header.image_type == TGARLEMonochrome))           if (runlength != 0),
             {e               runlength--;               skip=flag != 0; 
             })           else
             {sC               status=ReadData((char *) &runlength,1,1,image->file);e"               if (status == False)A                 PrematureExit("Unable to read image data",image);m$               flag=runlength & 0x80;               if (flag != 0)                 runlength-=128;l               skip=False;n
             }a         if (!skip)(           switch (tga_header.pixel_size)           {l             case 8:,             default:
             {i               /*                 Gray scale.c               */'               index=fgetc(image->file);R0               if (tga_header.colormap_type == 0)                 { /                   red=(Quantum) UpScale(index); 1                   green=(Quantum) UpScale(index);)0                   blue=(Quantum) UpScale(index);                 }R               else                 {>1                   red=image->colormap[index].red;a5                   green=image->colormap[index].green;e3                   blue=image->colormap[index].blue;7                 }n               break;
             }e             case 15:             case 16:
             {,               /*2                 5 bits each of red green and blue.               */#               j=fgetc(image->file);P#               k=fgetc(image->file);mB               red=(Quantum) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);               green=(Quantum) P                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);>               blue=(Quantum) ((MaxRGB*((int) (j & 0x1f)))/31);0               index=((unsigned short) k << 8)+j;               break;
             }              case 24:             case 32:
             {v               /*2                 8 bits each of blue green and red.               *//               blue=UpScale(fgetc(image->file));s0               green=UpScale(fgetc(image->file));.               red=UpScale(fgetc(image->file));.               if (tga_header.pixel_size == 32))                 index=fgetc(image->file);;               break;
             }a           }h         if (status == False);           PrematureExit("Unable to read image data",image);r         q->red=red;          q->green=green;          q->blue=blue;n         q->index=index;m         q->length=0;         q++;       }uE       if (((unsigned char) (tga_header.attributes & 0xc0) >> 6) == 4)l         offset+=4;
       elseG         if (((unsigned char) (tga_header.attributes & 0xc0) >> 6) == 2)            offset+=2;         else           offset++;S        if (offset >= image->rows)	         {            base++;c           offset=base;	         }n       if (feof(image->file))         break;3       ProgressMonitor(LoadImageText,y,image->rows);e     }      (void) IsGrayImage(image);$     if (image->class == PseudoClass)       SyncImage(image);)     CompressImage(image);(     /*       Proceed to next image.     */D     status=ReadData((char *) &tga_header.id_length,1,1,image->file);0     tga_header.colormap_type=fgetc(image->file);-     tga_header.image_type=fgetc(image->file);oL     status&=((tga_header.image_type != 0) && (tga_header.image_type <= 11));     if (status == True)=       { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {l!             DestroyImages(image); #             return((Image *) NULL);%           }%B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status == True); +   while (image->previous != (Image *) NULL)L     image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %%O %                                                                             %oO %  R e a d T E X T I m a g e                                                  %aO %                                                                             %tO %                                                                             % O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ReadTEXTImage reads a text file and returns it as an image.  It K %  allocates the memory necessary for the new Image structure and returns ar %  pointer to the new image. % . %  The format of the ReadTEXTImage routine is: %*& %      image=ReadTEXTImage(image_info) % + %  A description of each parameter follows:- %lJ %    o image:  Function ReadTEXTImage returns a pointer to the image afterN %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 static Image *ReadTEXTImage(const ImageInfo *image_info) {    AnnotateInfo     annotate_info;     char     geometry[MaxTextLength],     text[MaxTextLength],     *text_status;   	   Display 
     *display;      Image      *image;      int      offset,      x,     y;     register int     i;     register RunlengthPacket     *p;      RunlengthPacket      background_color;      unsigned int     height, 
     width;     XColor
     color;     XResourceInfo%     resource_info;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */"   OpenImage(image_info,image,"r");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);e   /*     Initialize Image structure.s   */?   (void) XParseGeometry(TextPageGeometry,&x,&y,&width,&height);C(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);y   else     {        floatm         dx_resolution,         dy_resolution,         x_resolution,I         y_resolution;i  	       intt         count;         /*         Determine bounding box.y       */       dx_resolution=72.0;n       dy_resolution=72.0;i       x_resolution=72.0;J       count=sscanf(PSDensityGeometry,"%fx%f",&x_resolution,&y_resolution);/       if (image_info->density != (char *) NULL)tN         count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);       if (count != 2) "         y_resolution=x_resolution;F       width=(unsigned int) (((width*x_resolution)/dx_resolution)+0.5);H       height=(unsigned int) (((height*y_resolution)/dy_resolution)+0.5);     }    image->columns=width;n   image->rows=height;l,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));R0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);d   /*%     Initialize image annotation info.s   */"   GetAnnotateInfo(&annotate_info);4   annotate_info.server_name=image_info->server_name;&   annotate_info.font=image_info->font;   annotate_info.text=text;"   annotate_info.geometry=geometry;$   annotate_info.pen=ForegroundColor;5   (void) XQueryColorDatabase(BackgroundColor,&color);p0   display=XOpenDisplay(image_info->server_name);"   if (display != (Display *) NULL)     {r       XrmDatabasee         resource_database;         /*%         Set background and pen color.e       */       XSetErrorHandler(XError);eB       resource_database=XGetResourceDatabase(display,client_name);D       XGetResourceInfo(resource_database,ClientName,&resource_info);H       (void) XQueryColorDatabase(resource_info.background_color,&color);7       annotate_info.pen=resource_info.foreground_color;e       XCloseDisplay(display);(     }z   /*.     Initialize text image to background color.   */-   background_color.red=XDownScale(color.red);l1   background_color.green=XDownScale(color.green); /   background_color.blue=XDownScale(color.blue);R   background_color.index=0;    p=image->pixels;$   for (i=0; i < image->packets; i++)     *p++=background_color;+   if (image_info->texture != (char *) NULL)e,     TextureImage(image,image_info->texture);   /*     Annotate the text image.   */   offset=0; 
   for ( ; ; )4   {+     /*       Annotate image with text.f     */F     ProgressMonitor(LoadImageText,ftell(image->file),image->filesize);8     text_status=fgets(text,MaxTextLength-1,image->file);%     if (text_status == (char *) NULL)!       break;-     if ((int) strlen(annotate_info.text) > 0)t<       annotate_info.text[strlen(annotate_info.text)-1]='\0';?     (void) sprintf(annotate_info.geometry,"%+d%+d",x,y+offset);&(     AnnotateImage(image,&annotate_info);$     offset+=annotate_info.pointsize;@     if (((y << 1)+offset+annotate_info.pointsize) < image->rows)       continue;d     /*3       Page is full-- allocate next image structure.o     */     CompressImage(image); -     if (image_info->texture == (char *) NULL)a3       QuantizeImage(image,2,8,False,RGBColorspace);i     image->orphan=True;eB     image->next=CopyImage(image,image->columns,image->rows,False);     image->orphan=False;&     if (image->next == (Image *) NULL)       {eF         Warning("Unable to annotate image","Memory allocation error");         break;       }6>     (void) strcpy(image->next->filename,image_info->filename);"     image->next->file=image->file;*     image->next->filesize=image->filesize;&     image->next->scene=image->scene+1;      image->next->previous=image;     image=image->next;     /*0       Initialize text image to background color.     */     p=image->pixels;&     for (i=0; i < image->packets; i++)       *p++=background_color;-     if (image_info->texture != (char *) NULL) .       TextureImage(image,image_info->texture);
     offset=0;g   }l   CompressImage(image);++   if (image_info->texture == (char *) NULL)p1     QuantizeImage(image,2,8,False,RGBColorspace);d+   while (image->previous != (Image *) NULL)a     image=image->previous;   CloseImage(image);   return(image); }e i #ifdef HasTIFF #include "tiffio.h"n ! /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%hO %                                                                             % O %                                                                             %iO %                                                                             %-O %  R e a d T I F F I m a g e                                                  %iO %                                                                             %lO %                                                                             %sO %                                                                             %*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%u %*G %  Function ReadTIFFImage reads a Tagged image file and returns it.  ItnK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %a. %  The format of the ReadTIFFImage routine is: %t& %      image=ReadTIFFImage(image_info) %s+ %  A description of each parameter follows:  %lJ %    o image:  Function ReadTIFFImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.o %  %; */  E static void TIFFWarningMessage(const char *module,const char *format,f   va_list warning) {    char     message[MaxTextLength];      register char      *p;s     p=message;   if (module != (char *) NULL)     {e&       (void) sprintf(p,"%s: ",module);       p+=strlen(message);      }    vsprintf(p,format,warning);    strcat(p,".");!   Warning(message,(char *) NULL);t }e  8 static Image *ReadTIFFImage(const ImageInfo *image_info) {)   char
     *comment;E     Imagel     *image;d     intr
     range;  	   Quantum(	     blue,r
     green,     red;     register int     i,     x,     y;     register RunlengthPacket     *q;e     register unsigned char     *p;      TIFF
     *tiff;     uint16     extra_samples,     *sample_info;,     unsigned charm     *scanline;     unsigned int     height,a     method,r     packets,     status, 
     width;     unsigned short     bits_per_sample,
     index,     interlace,     max_sample_value,L     min_sample_value,      photometric,     samples_per_pixel,
     value;     /*     Allocate image structure.U   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);F   /*     Open image.    */-   OpenImage(image_info,image,ReadBinaryType);i#   if (image->file == (FILE *) NULL)f/     PrematureExit("Unable to open file",image); ,   if ((image->file == stdin) || image->pipe)     {a
       FILE         *file;  	       int 
         c;         /*6         Copy standard input or pipe to temporary file.       */.       TemporaryFilename(image_info->filename);7       file=fopen(image_info->filename,WriteBinaryType);         if (file == (FILE *) NULL)4         PrematureExit("Unable to write file",image);       c=fgetc(image->file);(       while (c != EOF)       {t         (void) putc(c,file);         c=fgetc(image->file);        }        (void) fclose(file);:       (void) strcpy(image->filename,image_info->filename);       image->temporary=True;     }0   CloseImage(image);*   TIFFSetErrorHandler(TIFFWarningMessage);,   TIFFSetWarningHandler(TIFFWarningMessage);0   tiff=TIFFOpen(image->filename,ReadBinaryType);   if (tiff == (TIFF *) NULL)/     PrematureExit("Unable to open file",image);=    if (image_info->subimage != 0)/     while (image->scene < image_info->subimage)*     {        /*         Skip to next image.        */       image->scene++;o%       status=TIFFReadDirectory(tiff);        if (status == False)7         PrematureExit("Unable to read subimage",image);      }    do   {a     if (image_info->verbose),       TIFFPrintDirectory(tiff,stderr,False);1     TIFFGetField(tiff,TIFFTAG_IMAGEWIDTH,&width);)3     TIFFGetField(tiff,TIFFTAG_IMAGELENGTH,&height); @     TIFFGetFieldDefaulted(tiff,TIFFTAG_PLANARCONFIG,&interlace);G     TIFFGetFieldDefaulted(tiff,TIFFTAG_BITSPERSAMPLE,&bits_per_sample); I     TIFFGetFieldDefaulted(tiff,TIFFTAG_MINSAMPLEVALUE,&min_sample_value); I     TIFFGetFieldDefaulted(tiff,TIFFTAG_MAXSAMPLEVALUE,&max_sample_value); A     TIFFGetFieldDefaulted(tiff,TIFFTAG_PHOTOMETRIC,&photometric); K     TIFFGetFieldDefaulted(tiff,TIFFTAG_SAMPLESPERPIXEL,&samples_per_pixel);=E     TIFFGetFieldDefaulted(tiff,TIFFTAG_RESOLUTIONUNIT,&image->units); I     TIFFGetFieldDefaulted(tiff,TIFFTAG_XRESOLUTION,&image->x_resolution);aI     TIFFGetFieldDefaulted(tiff,TIFFTAG_YRESOLUTION,&image->y_resolution);b     /*5       Allocate memory for the image and pixel buffer.      */     image->columns=width;      image->rows=height;.     image->depth=QuantumDepth;     if (bits_per_sample <= 8)_       image->depth=8;=     image->packets=0; 7     packets=Max((image->columns*image->rows+4) >> 3,1);      if (bits_per_sample == 1)09       packets=Max((image->columns*image->rows+8) >> 4,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)       {          TIFFClose(tiff);9         PrematureExit("Unable to allocate memory",image);        }i     comment=(char *) NULL;9     TIFFGetField(tiff,TIFFTAG_IMAGEDESCRIPTION,&comment);?!     if (comment != (char *) NULL)+$       if ((int) strlen(comment) > 4)	         { "           image->comments=(char *)D             malloc((unsigned int) (strlen(comment)+1)*sizeof(char));/           if (image->comments == (char *) NULL)&
             {                TIFFClose(tiff);?               PrematureExit("Unable to allocate memory",image); 
             } 1           (void) strcpy(image->comments,comment);i	         }n,     range=max_sample_value-min_sample_value;     if (range < 0)       range=max_sample_value;g     q=image->pixels;     q->length=MaxRunlength; 
     method=0; 5     if ((samples_per_pixel > 1) || TIFFIsTiled(tiff))        {          method=2; K         if ((samples_per_pixel >= 3) && (photometric == PHOTOMETRIC_RGB) && /             (interlace == PLANARCONFIG_CONTIG))h           method=1;+       }x     switch (method)+     { 
       case 0:        {          Quantumu           *quantum_scanline;           register Quantum
           *r;r  
         /*7           Convert TIFF image to PseudoClass MIFF image. 
         */!         image->class=PseudoClass;          image->colors=range+1;'         image->colormap=(ColorPacket *)a4           malloc(image->colors*sizeof(ColorPacket));C         quantum_scanline=(Quantum *) malloc(width*sizeof(Quantum));oD         scanline=(unsigned char *) malloc(TIFFScanlineSize(tiff)+1);8         if ((image->colormap == (ColorPacket *) NULL) ||5             (quantum_scanline == (Quantum *) NULL) || 1             (scanline == (unsigned char *) NULL)))           {              TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);            }q
         /*           Create colormap.
         */         switch (photometric)	         {n&           case PHOTOMETRIC_MINISBLACK:           { -             for (i=0; i < image->colors; i++) 
             {;6               image->colormap[i].red=(MaxRGB*i)/range;8               image->colormap[i].green=(MaxRGB*i)/range;7               image->colormap[i].blue=(MaxRGB*i)/range;t
             }a             break;           }x&           case PHOTOMETRIC_MINISWHITE:           { -             for (i=0; i < image->colors; i++))
             { >               image->colormap[i].red=((range-i)*MaxRGB)/range;@               image->colormap[i].green=((range-i)*MaxRGB)/range;?               image->colormap[i].blue=((range-i)*MaxRGB)/range;1
             }              break;           } #           case PHOTOMETRIC_PALETTE:            {e             unsigned short               *blue_colormap,                *green_colormap,               *red_colormap;  M             TIFFGetField(tiff,TIFFTAG_COLORMAP,&red_colormap,&green_colormap,y               &blue_colormap);-             for (i=0; i < image->colors; i++) 
             { 3               image->colormap[i].red=(unsigned int)g0                 (red_colormap[i]*MaxRGB)/65535L;5               image->colormap[i].green=(unsigned int) 2                 (green_colormap[i]*MaxRGB)/65535L;4               image->colormap[i].blue=(unsigned int)1                 (blue_colormap[i]*MaxRGB)/65535L;i
             }_             break;           }t           default:             break;	         }o
         /*A           Convert image to PseudoClass runlength-encoded packets. 
         */'         for (y=0; y < image->rows; y++)/	         {m7           TIFFReadScanline(tiff,(char *) scanline,y,0);n           p=scanline;            r=quantum_scanline;o"           switch (bits_per_sample)           {L             case 1: 
             {r               register int                 bit;  2               for (x=0; x < ((int) width-7); x+=8)               {e,                 for (bit=7; bit >= 0; bit--)<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               }i#               if ((width % 8) != 0)l                 {!<                   for (bit=7; bit >= (8-(width % 8)); bit--)>                     *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                   p++;                 }%               break;
             }              case 2: 
             { 2               for (x=0; x < ((int) width-3); x+=4)               { %                 *r++=(*p >> 6) & 0x3; %                 *r++=(*p >> 4) & 0x3; %                 *r++=(*p >> 2) & 0x3;a                  *r++=(*p) & 0x3;                 p++;               } #               if ((width % 4) != 0)                  { 6                   for (i=3; i >= (4-(width % 4)); i--).                     *r++=(*p >> (i*2)) & 0x03;                   p++;                 }                break;
             }h             case 4:%
             {%2               for (x=0; x < ((int) width-1); x+=2)               {I%                 *r++=(*p >> 4) & 0xf;m                  *r++=(*p) & 0xf;                 p++;               }e#               if ((width % 2) != 0)p'                 *r++=(*p++ >> 4) & 0xf;a               break;
             }t             case 8:F
             {o'               for (x=0; x < width; x++)r                 *r++=(*p++);               break;
             }t             case 16:
             {g0               for (x=0; x < image->columns; x++)               { "                 ReadQuantum(*r,p);                 r++;               }r               break;
             }              default:               break;           }o           /*$             Transfer image scanline.           */           r=quantum_scanline; ,           for (x=0; x < image->columns; x++)           {              index=(*r++);xH             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {_(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {I                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));(B                     if (image->pixels == (RunlengthPacket *) NULL)                       {p0                         free((char *) scanline);8                         free((char *) quantum_scanline);(                         TIFFClose(tiff);I                         PrematureExit("Unable to allocate memory",image);i                       }a5                     q=image->pixels+image->packets-1;i                   }l                 q->index=index;e                 q->length=0;               }_           } 7           ProgressMonitor(LoadImageText,y,image->rows);)	         }v          free((char *) scanline);(         free((char *) quantum_scanline);(         if (image->class == PseudoClass)           {              SyncImage(image); $             CompressColormap(image);           }c         break;       }&
       case 1:<       {L
         /*7           Convert TIFF image to DirectClass MIFF image. 
         */K         scanline=(unsigned char *) malloc((TIFFScanlineSize(tiff) << 1)+1);(/         if (scanline == (unsigned char *) NULL)            {              TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);e           } G         TIFFGetFieldDefaulted(tiff,TIFFTAG_EXTRASAMPLES,&extra_samples,o           &sample_info);         image->matte= O           ((extra_samples == 1) && (sample_info[0] == EXTRASAMPLE_ASSOCALPHA));r'         for (y=0; y < image->rows; y++);	         {n7           TIFFReadScanline(tiff,(char *) scanline,y,0);u#           if (bits_per_sample == 4) 
             {L$               register unsigned char                 *r;o  +               width=TIFFScanlineSize(tiff); !               p=scanline+width-1; (               r=scanline+(width << 1)-1;-               for (x=0; x < (int) width; x++)o               {e'                 *r--=((*p) & 0xf) << 4; ,                 *r--=((*p >> 4) & 0xf) << 4;                 p--;               }t
             }g           p=scanline;r,           for (x=0; x < image->columns; x++)           {              ReadQuantum(red,p);)!             ReadQuantum(green,p);               ReadQuantum(blue,p);             index=0;             if (image->matte)(#               ReadQuantum(index,p);.N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&H                 (index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {i(                 if (image->packets != 0)                   q++;!                 image->packets++;(.                 if (image->packets == packets)                   {e                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)                       {e(                         TIFFClose(tiff);0                         free((char *) scanline);I                         PrematureExit("Unable to allocate memory",image);-                       }g5                     q=image->pixels+image->packets-1;                    }h                 q->red=red;p                 q->green=green;p                 q->blue=blue;o                 q->index=index;r                 q->length=0;               }i           })7           ProgressMonitor(LoadImageText,y,image->rows);r	         }c          free((char *) scanline);         break;       }a
       case 2:t       default:       {,         register uint32 
           *p,            *pixels;  
         /*7           Convert TIFF image to DirectClass MIFF image.t
         */G         TIFFGetFieldDefaulted(tiff,TIFFTAG_EXTRASAMPLES,&extra_samples,*           &sample_info);         image->matte= O           ((extra_samples == 1) && (sample_info[0] == EXTRASAMPLE_ASSOCALPHA));n         pixels=(uint32 *)eM           malloc((image->columns*image->rows+image->columns)*sizeof(uint32));(&         if (pixels == (uint32 *) NULL)           {a             TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);e           })K         status=TIFFReadRGBAImage(tiff,image->columns,image->rows,pixels,0);i         if (status == False)           {>"             free((char *) pixels);             TIFFClose(tiff);8             PrematureExit("Unable to read image",image);           }e
         /*A           Convert image to DirectClass runlength-encoded packets.i
         */*         for (y=image->rows-1; y >= 0; y--)	         {t$           p=pixels+y*image->columns;,           for (x=0; x < image->columns; x++)           {m&             red=UpScale(TIFFGetR(*p));(             green=UpScale(TIFFGetG(*p));'             blue=UpScale(TIFFGetB(*p));%E             index=(unsigned short) (image->matte ? TIFFGetA(*p) : 0);%N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&H                 (index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)                       { .                         free((char *) pixels);(                         TIFFClose(tiff);I                         PrematureExit("Unable to allocate memory",image);u                       }t5                     q=image->pixels+image->packets-1;e                   }                  q->red=red;i                 q->green=green;h                 q->blue=blue;o                 q->index=index;e                 q->length=0;               }i             p++;           }fC           ProgressMonitor(LoadImageText,image->rows-y,image->rows); 	         }o         free((char *) pixels);!         if (IsPseudoClass(image))cJ           QuantizeImage(image,(unsigned int) range,8,False,RGBColorspace);         break;       }h     } %     image->pixels=(RunlengthPacket *) M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));=     /*       Proceed to next image.     */"     if (image_info->subimage != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;#     status=TIFFReadDirectory(tiff);=     if (status == True)m       {(
         /*#           Allocate image structure.e
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {)!             DestroyImages(image);m#             return((Image *) NULL);l           }mB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }e   } while (status == True);i   TIFFClose(tiff);   if (image->temporary)t(     (void) remove(image_info->filename);+   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }l #elsee8 static Image *ReadTIFFImage(const ImageInfo *image_info) { @   Warning("TIFF library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }% #endif % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d T I L E I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             %%O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %aH %  Function ReadTILEImage tiles a texture on an image.  It allocates theL %  memory necessary for the new Image structure and returns a pointer to the
 %  new image.P %m. %  The format of the ReadTILEImage routine is: %g& %      image=ReadTILEImage(image_info) %m+ %  A description of each parameter follows:e %NJ %    o image:  Function ReadTILEImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.i %aA %    o image_info: Specifies a pointer to an ImageInfo structure.d %I %e */2 static Image *ReadTILEImage(ImageInfo *image_info) {    Imaget     *image,,     *tiled_image;      intr     x,     y;     unsigned int     height,h
     width;  $   tiled_image=ReadImage(image_info);$   if (tiled_image == (Image *) NULL)     return((Image *) NULL);    /*     Allocate image structure.y   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);r   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;e(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);f   /*     Initialize Image structure.r   */6   (void) strcpy(image->filename,image_info->filename);   image->columns=width;/   image->rows=height; ,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));n0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);t   /*     Tile texture onto image.   */)   ProgressMonitor(LoadImageText,200,400);;2   for (y=0; y < image->rows; y+=tiled_image->rows):     for (x=0; x < image->columns; x+=tiled_image->columns)?       CompositeImage(image,ReplaceCompositeOp,tiled_image,x,y);n)   ProgressMonitor(LoadImageText,400,400);*   return(image); }  ( /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             % O %                                                                             %IO %                                                                             %;O %  R e a d U Y V Y I m a g e                                                  % O %                                                                             %nO %                                                                             %_O %                                                                             %1O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%c %mI %  Function ReadUYVYImage reads an image in the UYVY (16bit/pixel) formataG %  and returns it.  It allocates the memory necessary for the new Image-4 %  structure and returns a pointer to the new image. %r- %  The format of the ReadYUVImage routine is:k %*& %      image=ReadUYVYImage(image_info) % + %  A description of each parameter follows:b %dI %    o image:  Function ReadYUVImage returns a pointer to the image afteraL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.i %fA %    o image_info: Specifies a pointer to an ImageInfo structure.U %  %  */8 static Image *ReadUYVYImage(const ImageInfo *image_info) {s   Imageg     *image;N     int      x,     y;     register int     i;     register RunlengthPacket     *q;e     register unsigned char     *p;      unsigned chary     *uyvy_pixels;E     unsigned int     height, 
     width;     /*     Allocate image structure.g   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */6   (void) strcpy(image->filename,image_info->filename);-   OpenImage(image_info,image,ReadBinaryType);z#   if (image->file == (FILE *) NULL)c.     PrematureExit("Unable to open file",image)   /*-     Determine width and height, e.g. 640x512.f   */   width=512;
   height=512;R   x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);_   for (i=0; i < x; i++)      (void) fgetc(image->file);   /*     Read data.   */   image->columns=width;g   image->rows=height;c,   image->packets=image->columns*image->rows;   uyvy_pixels=(unsigned char *) 3     malloc((2*width*height)*sizeof(unsigned char));l#   image->pixels=(RunlengthPacket *)s3     malloc(image->packets*sizeof(RunlengthPacket));i0   if ((uyvy_pixels == (unsigned char *) NULL) ||2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);cE   (void) ReadData((char *) uyvy_pixels,1,2*width*height,image->file);_   /*1     Accumulate UYVY, then unpack into two pixels.c   */   p=uyvy_pixels;   q=image->pixels;+   for (i=0; i < (image->packets >> 1); i++)d   {p     q->red=UpScale(p[1]);      q->green=UpScale(p[0]);t     q->blue=UpScale(p[2]);     q->index=0;      q->length=0;     q++;     q->red=UpScale(p[3]);t     q->green=UpScale(p[0]);      q->blue=UpScale(p[2]);     q->index=0;;     q->length=0;     q++;	     p+=4;D     if (QuantumTick(i,image))c;       ProgressMonitor(LoadImageText,i,image->packets >> 1);O   }E   free((char *) uyvy_pixels);_+   TransformRGBImage(image,YCbCrColorspace);)   CompressImage(image);T   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cO %                                                                             % O %                                                                             %PO %                                                                             %nO %   R e a d V I C A R I m a g e                                               % O %                                                                             %rO %                                                                             %tO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%c %sG %  Function ReadVICARImage reads a VICAR image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns at %  pointer to the new image. % / %  The format of the ReadVICARImage routine is:k %)' %      image=ReadVICARImage(image_info)= %u+ %  A description of each parameter follows:c % J %    o image: Function ReadVICARImage returns a pointer to the image afterO %      reading.  A null image is returned if there is a a memory shortage or if   %      the image cannot be read. %19 %    o filename: Specifies the name of the image to read.  %  %- */9 static Image *ReadVICARImage(const ImageInfo *image_info)i {x   char     keyword[MaxTextLength],      value[MaxTextLength];      Imageg     *image;o     intx     c,     y;     long
     count;     register int     i,     x;     register RunlengthPacket     *q;t     register unsigned char     *p;      unsigned charg     *vicar_pixels;     unsigned int     header_length,     status,c     value_expected;l     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);)   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)w/     PrematureExit("Unable to open file",image);    /*     Decode image header.   */   c=fgetc(image->file); 
   count=1;   if (c == EOF)0     {(       DestroyImage(image);       return((Image *) NULL);      }b   header_length=0;;   while (isgraph(c) && ((image->columns*image->rows) == 0));   {      if (!isalnum(c))       {          c=fgetc(image->file);          count++;       }(     else       {o         register chara
           *p;)  
         /*,           Determine a keyword and its value.
         */         p=keyword;
         do	         { .           if ((p-keyword) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);u           count++;+         } while (isalnum(c) || (c == '_'));3         *p='\0';         value_expected=False; (         while (isspace(c) || (c == '='))	         {            if (c == '=');              value_expected=True;           c=fgetc(image->file);            count++;	         } $         if (value_expected == False)           continue;          p=value;         while (isalnum(c))	         { ,           if ((p-value) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);(           count++;	         }          *p='\0';
         /*2           Assign a value to the specified keyword.
         */1         if (strcmp(keyword,"LABEL_RECORDS") == 0)>3           header_length=(unsigned int) atoi(value);0+         if (strcmp(keyword,"LBLSIZE") == 0) 3           header_length=(unsigned int) atoi(value); 0         if (strcmp(keyword,"RECORD_BYTES") == 0)4           image->columns=(unsigned int) atoi(value);&         if (strcmp(keyword,"NS") == 0)4           image->columns=(unsigned int) atoi(value);)         if (strcmp(keyword,"LINES") == 0) 1           image->rows=(unsigned int) atoi(value); &         if (strcmp(keyword,"NL") == 0)1           image->rows=(unsigned int) atoi(value);        }/     while (isspace(c))     {        c=fgetc(image->file);c       count++;     }a   }    /*      Read the rest of the header.   */   while (count < header_length)a   {e     c=fgetc(image->file);t     count++;   }e   /*6     Verify that required image information is defined.   */(   if ((image->columns*image->rows) == 0).     PrematureExit("image size is zero",image);   /*     Create linear colormap.    */   image->class=PseudoClass;    image->colors=256;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image); #   for (i=0; i < image->colors; i++)h   { 0     image->colormap[i].red=(Quantum) UpScale(i);2     image->colormap[i].green=(Quantum) UpScale(i);1     image->colormap[i].blue=(Quantum) UpScale(i);m   }p   /*     Initialize image structure.    */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)r3     malloc(image->packets*sizeof(RunlengthPacket)); N   vicar_pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char));4   if ((image->pixels == (RunlengthPacket *) NULL) ||/       (vicar_pixels == (unsigned char *) NULL)) 5     PrematureExit("Unable to read image data",image);    /*6     Convert VICAR pixels to runlength-encoded packets.   */F   status=ReadData((char *) vicar_pixels,1,image->packets,image->file);   if (status == False);     PrematureExit("Insufficient image data in file",image);    /*6     Convert VICAR pixels to runlength-encoded packets.   */   p=vicar_pixels;    q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {i#       q->index=(unsigned short) *p;(       q->length=0;
       p++;
       q++;     }i1     ProgressMonitor(LoadImageText,y,image->rows);    }    free((char *) vicar_pixels);   SyncImage(image);s   CompressColormap(image);   CompressImage(image);-   CloseImage(image);   return(image); }c   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%PO %                                                                             %)O %                                                                             %aO %                                                                             %;O %  R e a d V I D I m a g e                                                    %nO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %iL %  Function ReadVIDImage reads one of more images and creates a Visual ImageG %  Directory file.  It allocates the memory necessary for the new Imagef4 %  structure and returns a pointer to the new image. % - %  The format of the ReadVIDImage routine is:m %r% %      image=ReadVIDImage(image_info)i %,+ %  A description of each parameter follows:e %;I %    o image:  Function ReadVIDImage returns a pointer to the image after;L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.y % A %    o image_info: Specifies a pointer to an ImageInfo structure.e %f %; */7 static Image *ReadVIDImage(const ImageInfo *image_info)% {% #define ClientName  "montage"%     char     **filelist,      **list,      *resource_value;  	   Display 
     *display;      Image      *image, 
     **images;      ImageInfo      local_info;      int      number_files;      register int     i,     j;     XMontageInfo     montage_info;m     XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     /*     Expand the filename.   */(   list=(char **) malloc(sizeof(char *));   if (list == (char **) NULL)      { 7       Warning("Memory allocation error",(char *) NULL);        return((Image *) NULL);      } :   list[0]=(char *) malloc(strlen(image_info->filename)+1);   if (list[0] == (char *) NULL)      {o7       Warning("Memory allocation error",(char *) NULL);u       return((Image *) NULL);e     }c.   (void) strcpy(list[0],image_info->filename);   number_files=1;    filelist=list;+   ExpandFilenames(&number_files,&filelist);    if (number_files == 0)     {g=       Warning("VID translation failed",image_info->filename);        return((Image *) NULL);I     }t   /*     Allocate images array.   */9   images=(Image **) malloc(number_files*sizeof(Image *));y    if (images == (Image **) NULL)     {b7       Warning("Memory allocation error",(char *) NULL);n&       for (i=0; i < number_files; i++)#         free((char *) filelist[i]);m       free((char *) filelist);       return((Image *) NULL);      }    /*     Open X server connection.    */7   resource_info.background_color=DefaultTileBackground;=/   resource_info.border_color=DefaultTileBorder;e:   resource_info.border_width=atoi(DefaultTileBorderwidth);7   resource_info.foreground_color=DefaultTileForeground;g&   resource_info.gravity=CenterGravity;3   resource_info.image_geometry=DefaultTileGeometry;r-   resource_info.matte_color=DefaultTileMatte;r$   resource_info.title=(char *) NULL;0   display=XOpenDisplay(image_info->server_name);"   if (display != (Display *) NULL)     {t       /*(         Set our forgiving error handler.       */       XSetErrorHandler(XError);g       /*3         Get user defaults from X resource database.(       */B       resource_database=XGetResourceDatabase(display,client_name);D       XGetResourceInfo(resource_database,ClientName,&resource_info);L       resource_info.background_color=XGetResourceInstance(resource_database,7         ClientName,"background",DefaultTileBackground);-D       resource_value=XGetResourceClass(resource_database,ClientName,.         "borderWidth",DefaultTileBorderwidth);6       resource_info.border_width=atoi(resource_value);*       resource_info.font=image_info->font;L       resource_info.foreground_color=XGetResourceInstance(resource_database,7         ClientName,"foreground",DefaultTileForeground);MJ       resource_info.image_geometry=XGetResourceInstance(resource_database,8         ClientName,"imageGeometry",DefaultTileGeometry);G       resource_info.matte_color=XGetResourceInstance(resource_database,a2         ClientName,"mattecolor",DefaultTileMatte);       XCloseDisplay(display);=     }m   /*/     Read each image and convert them to a tile.    */   j=0;"   for (i=0; i < number_files; i++)   {c     local_info=(*image_info);e)     if (local_info.size == (char *) NULL) 3       local_info.size=resource_info.image_geometry;n$     local_info.filename=filelist[i];     *local_info.magick='\0';!     image=ReadImage(&local_info);n     free((char *) filelist[i]);n      if (image == (Image *) NULL)       continue;      image->scene=j;      LabelImage(image,"%f");eF     TransformImage(&image,(char *) NULL,resource_info.image_geometry);     if (image_info->verbose)(       DescribeImage(image,stderr,False);     images[j]=image;     j++;2     ProgressMonitor(LoadImageText,i,number_files);   }    free((char *) filelist);   /*&     Create the visual image directory.   */!   XGetMontageInfo(&montage_info);t   montage_info.number_tiles=j;   image=(Image *) NULL;i%   if (montage_info.number_tiles != 0)F
     image=N       XMontageImage(images,&resource_info,&montage_info,image_info->filename);   free((char *) images);   if (image == (Image *) NULL)     {i=       Warning("VID translation failed",image_info->filename);;       return((Image *) NULL);(     }0   free((char *) list[0]);g   free((char *) list);   return(image); }- w /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)O %                                                                             %)O %                                                                             %nO %                                                                             %sO %   R e a d V I F F I m a g e                                                 % O %                                                                             %(O %                                                                             %IO %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %mM %  Function ReadVIFFImage reads a Khoros Visualization image file and returns I %  it.  It allocates the memory necessary for the new Image structure ando& %  returns a pointer to the new image. %=. %  The format of the ReadVIFFImage routine is: %a& %      image=ReadVIFFImage(image_info) %f+ %  A description of each parameter follows:g %cI %    o image: Function ReadVIFFImage returns a pointer to the image afteriO %      reading.  A null image is returned if there is a a memory shortage or if1  %      the image cannot be read. %u9 %    o filename: Specifies the name of the image to read.e %  %  */8 static Image *ReadVIFFImage(const ImageInfo *image_info) {  #define VFF_CM_genericRGB  15  #define VFF_CM_ntscRGB  1  #define VFF_CM_NONE  0 #define VFF_DEP_DECORDER  0x4e #define VFF_DEP_NSORDER  0x8 #define VFF_DES_RAW  0 #define VFF_LOC_IMPLICIT  1  #define VFF_MAPTYP_NONE  0 #define VFF_MAPTYP_1_BYTE  1 #define VFF_MS_NONE  0 #define VFF_MS_ONEPERBAND  1 #define VFF_MS_SHARED  3 #define VFF_TYP_BIT  0 #define VFF_TYP_1_BYTE  1* #define VFF_TYP_2_BYTE  2  #define VFF_TYP_4_BYTE  4      typedef struct _ViffHeader   {a     unsigned char        identifier,        file_type,       release,       version,       machine_dependency,a       reserve[3];s       char       comment[512];l       unsigned long)       rows,r       columns,       subrows;       long       x_offset,        y_offset;l  	     float        x_pixel_size,u       y_pixel_size;l       unsigned long        location_type,       location_dimension,u       number_of_images,e       number_data_bands,       data_storage_type,       data_encode_scheme,o       map_scheme,        map_storage_type,        map_rows,        map_columns,       map_subrows,       map_enable,        maps_per_cycle,        color_space_model;   } ViffHeader;      Image      *image;m     register int     bit,     i,     x,     y;     register Quantum     *p;i     register RunlengthPacket     *q;      unsigned char      buffer[7],     *viff_pixels;      unsigned int     bytes_per_pixel,     status;c     unsigned long      packets;     ViffHeader     viff_header;     /*     Allocate image structure.=   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);R   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);i#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);N   /*"     Read VIFF header (1024 bytes).   */D   status=ReadData((char *) &viff_header.identifier,1,1,image->file);   do   {s     /*       Verify VIFF identifier.      */N     if ((status == False) || ((unsigned char) viff_header.identifier != 0xab))/       PrematureExit("Not a VIFF raster",image);)     /*       Initialize VIFF image.     */5     (void) ReadData((char *) buffer,1,7,image->file);G$     viff_header.file_type=buffer[0];"     viff_header.release=buffer[1];"     viff_header.version=buffer[2];-     viff_header.machine_dependency=buffer[3]; D     (void) ReadData((char *) viff_header.comment,1,512,image->file);"     viff_header.comment[511]='\0';.     if ((int) strlen(viff_header.comment) > 4)       {x          image->comments=(char *)N           malloc((unsigned int) (strlen(viff_header.comment)+1)*sizeof(char));-         if (image->comments == (char *) NULL) ;           PrematureExit("Unable to allocate memory",image);f;         (void) strcpy(image->comments,viff_header.comment);        } ?     if ((viff_header.machine_dependency == VFF_DEP_DECORDER) ||*<         (viff_header.machine_dependency == VFF_DEP_NSORDER))       {R7         viff_header.rows=LSBFirstReadLong(image->file); :         viff_header.columns=LSBFirstReadLong(image->file);:         viff_header.subrows=LSBFirstReadLong(image->file);;         viff_header.x_offset=LSBFirstReadLong(image->file); ;         viff_header.y_offset=LSBFirstReadLong(image->file);;G         viff_header.x_pixel_size=(float) LSBFirstReadLong(image->file);,G         viff_header.y_pixel_size=(float) LSBFirstReadLong(image->file); @         viff_header.location_type=LSBFirstReadLong(image->file);E         viff_header.location_dimension=LSBFirstReadLong(image->file); C         viff_header.number_of_images=LSBFirstReadLong(image->file); D         viff_header.number_data_bands=LSBFirstReadLong(image->file);D         viff_header.data_storage_type=LSBFirstReadLong(image->file);E         viff_header.data_encode_scheme=LSBFirstReadLong(image->file);e=         viff_header.map_scheme=LSBFirstReadLong(image->file);eC         viff_header.map_storage_type=LSBFirstReadLong(image->file);(;         viff_header.map_rows=LSBFirstReadLong(image->file);(>         viff_header.map_columns=LSBFirstReadLong(image->file);>         viff_header.map_subrows=LSBFirstReadLong(image->file);=         viff_header.map_enable=LSBFirstReadLong(image->file);eA         viff_header.maps_per_cycle=LSBFirstReadLong(image->file); D         viff_header.color_space_model=LSBFirstReadLong(image->file);       }R     else       {e7         viff_header.rows=MSBFirstReadLong(image->file);t:         viff_header.columns=MSBFirstReadLong(image->file);:         viff_header.subrows=MSBFirstReadLong(image->file);;         viff_header.x_offset=MSBFirstReadLong(image->file); ;         viff_header.y_offset=MSBFirstReadLong(image->file); G         viff_header.x_pixel_size=(float) MSBFirstReadLong(image->file); G         viff_header.y_pixel_size=(float) MSBFirstReadLong(image->file); @         viff_header.location_type=MSBFirstReadLong(image->file);E         viff_header.location_dimension=MSBFirstReadLong(image->file);sC         viff_header.number_of_images=MSBFirstReadLong(image->file);aD         viff_header.number_data_bands=MSBFirstReadLong(image->file);D         viff_header.data_storage_type=MSBFirstReadLong(image->file);E         viff_header.data_encode_scheme=MSBFirstReadLong(image->file);m=         viff_header.map_scheme=MSBFirstReadLong(image->file);0C         viff_header.map_storage_type=MSBFirstReadLong(image->file);e;         viff_header.map_rows=MSBFirstReadLong(image->file); >         viff_header.map_columns=MSBFirstReadLong(image->file);>         viff_header.map_subrows=MSBFirstReadLong(image->file);=         viff_header.map_enable=MSBFirstReadLong(image->file); A         viff_header.maps_per_cycle=MSBFirstReadLong(image->file); D         viff_header.color_space_model=MSBFirstReadLong(image->file);       }-     for (i=0; i < 420; i++)         (void) fgetc(image->file);     /*.       Verify that we can read this VIFF image.     */4     if ((viff_header.columns*viff_header.rows) == 0)G       PrematureExit("Image column or row size is not supported",image);t9     if ((viff_header.data_storage_type != VFF_TYP_BIT) &&c<         (viff_header.data_storage_type != VFF_TYP_1_BYTE) &&<         (viff_header.data_storage_type != VFF_TYP_2_BYTE) &&:         (viff_header.data_storage_type != VFF_TYP_4_BYTE))@       PrematureExit("Data storage type is not supported",image);6     if (viff_header.data_encode_scheme != VFF_DES_RAW)C       PrematureExit("Data encoding scheme is not supported",image);o<     if ((viff_header.map_storage_type != VFF_MAPTYP_NONE) &&<         (viff_header.map_storage_type != VFF_MAPTYP_1_BYTE))?       PrematureExit("Map storage type is not supported",image);c9     if ((viff_header.color_space_model != VFF_CM_NONE) && <         (viff_header.color_space_model != VFF_CM_ntscRGB) &&=         (viff_header.color_space_model != VFF_CM_genericRGB)) ?       PrematureExit("Colorspace model is not supported",image); 6     if (viff_header.location_type != VFF_LOC_IMPLICIT)       { B         Warning("Location type is not supported",image->filename);         DestroyImages(image);          return((Image *) NULL);m       }e*     if (viff_header.number_of_images != 1)?       PrematureExit("Number of images is not supported",image);a#     switch (viff_header.map_scheme)      {        case VFF_MS_NONE:        { .         if (viff_header.number_data_bands < 3)           {              /*'               Create linear color ramp.t             */=             if (viff_header.data_storage_type == VFF_TYP_BIT)                image->colors=2;             elseN               image->colors=1 << (viff_header.number_data_bands*QuantumDepth);+             image->colormap=(ColorPacket *)x8               malloc(image->colors*sizeof(ColorPacket));8             if (image->colormap == (ColorPacket *) NULL)?               PrematureExit("Unable to allocate memory",image); -             for (i=0; i < image->colors; i++)r
             {nB               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1); 
             }            }m         break;       }        case VFF_MS_ONEPERBAND:        case VFF_MS_SHARED:i       {e         unsigned char            *viff_colormap;   
         /*$           Read VIFF raster colormap.
         */.         image->colors=viff_header.map_columns;'         image->colormap=(ColorPacket *)t4           malloc(image->colors*sizeof(ColorPacket));'         viff_colormap=(unsigned char *) 6           malloc(image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||6             (viff_colormap == (unsigned char *) NULL));           PrematureExit("Unable to allocate memory",image);>L         (void) ReadData((char *) viff_colormap,1,image->colors,image->file);)         for (i=0; i < image->colors; i++)e	         { ;           image->colormap[i].red=UpScale(viff_colormap[i]); =           image->colormap[i].green=UpScale(viff_colormap[i]); <           image->colormap[i].blue=UpScale(viff_colormap[i]);	         }n%         if (viff_header.map_rows > 1)            { P             (void) ReadData((char *) viff_colormap,1,image->colors,image->file);-             for (i=0; i < image->colors; i++) A               image->colormap[i].green=UpScale(viff_colormap[i]);            } %         if (viff_header.map_rows > 2)            { P             (void) ReadData((char *) viff_colormap,1,image->colors,image->file);-             for (i=0; i < image->colors; i++)0@               image->colormap[i].blue=UpScale(viff_colormap[i]);           }g%         free((char *) viff_colormap);)         break;       }f       default:>         PrematureExit("Colormap type is not supported",image);     };     /*       Allocate VIFF pixels.a     */     bytes_per_pixel=1;8     if (viff_header.data_storage_type == VFF_TYP_2_BYTE)       bytes_per_pixel=2;8     if (viff_header.data_storage_type == VFF_TYP_4_BYTE)       bytes_per_pixel=4;5     if (viff_header.data_storage_type == VFF_TYP_BIT) >       packets=((viff_header.columns+7) >> 3)*viff_header.rows;     else       packets=K         viff_header.columns*viff_header.rows*viff_header.number_data_bands; !     viff_pixels=(unsigned char *)26       malloc(bytes_per_pixel*packets*sizeof(Quantum));.     if (viff_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image);fP     (void) ReadData((char *) viff_pixels,bytes_per_pixel,(unsigned int) packets,       image->file);o*     switch (viff_header.data_storage_type)     { 	       int'         max_value,         min_value,         value;         register Quantum         *q;x         unsigned longn         scale_factor;-         case VFF_TYP_1_BYTE:       {          register unsigned char
           *p;            if (QuantumDepth == 8)           break;
         /*.           Scale integer pixels to [0..MaxRGB].
         */         p=viff_pixels;"         q=(Quantum *) viff_pixels;         p+=packets-1;n         q+=packets-1; #         for (i=0; i < packets; i++) 	         {t           value=UpScale(*p);           *q=(Quantum) value;!           p--;           q--;	         }u         break;       }        case VFF_TYP_2_BYTE:       {%         register short int
           *p;%  
         /*F           Ensure the header byte-order is most-significant byte first.
         */C         if ((viff_header.machine_dependency == VFF_DEP_DECORDER) || @             (viff_header.machine_dependency == VFF_DEP_NSORDER))3           MSBFirstOrderShort((char *) &viff_header,P6             (unsigned int) (bytes_per_pixel*packets));
         /*!           Determine scale factor. 
         */$         p=(short int *) viff_pixels;         max_value=(*p);          min_value=(*p); #         for (i=0; i < packets; i++) 	         {            if (*p > max_value)              max_value=(*p);%           else             if (*p < min_value)%               min_value=(*p);p           p++;	         }e1         if ((min_value == 0) && (max_value == 0))I           scale_factor=0;          else%           if (min_value == max_value) 
             {h5               scale_factor=UpShift(MaxRGB)/min_value;i               min_value=0;
             }i           else?             scale_factor=UpShift(MaxRGB)/(max_value-min_value);o
         /*.           Scale integer pixels to [0..MaxRGB].
         */$         p=(short int *) viff_pixels;"         q=(Quantum *) viff_pixels;#         for (i=0; i < packets; i++)e	         {i7           value=DownShift((*p-min_value)*scale_factor);t           if (value > MaxRGB)m             value=MaxRGB;d           else             if (value < 0)               value=0;           *q=(Quantum) value;i           p++;           q++;	         }          break;       }        case VFF_TYP_4_BYTE:       {g         register int
           *p;   
         /*F           Ensure the header byte-order is most-significant byte first.
         */C         if ((viff_header.machine_dependency == VFF_DEP_DECORDER) || @             (viff_header.machine_dependency == VFF_DEP_NSORDER))2           MSBFirstOrderLong((char *) &viff_header,6             (unsigned int) (bytes_per_pixel*packets));
         /*!           Determine scale factor. 
         */         p=(int *) viff_pixels;         max_value=(*p);          min_value=(*p);a#         for (i=0; i < packets; i++)l	         {(           if (*p > max_value)m             max_value=(*p);g           else             if (*p < min_value)                min_value=(*p);B           p++;	         }f1         if ((min_value == 0) && (max_value == 0))o           scale_factor=0;          else%           if (min_value == max_value)l
             {t5               scale_factor=UpShift(MaxRGB)/min_value;                min_value=0;
             }i           else?             scale_factor=UpShift(MaxRGB)/(max_value-min_value);s
         /*.           Scale integer pixels to [0..MaxRGB].
         */         p=(int *) viff_pixels;"         q=(Quantum *) viff_pixels;#         for (i=0; i < packets; i++)o	         {c7           value=DownShift((*p-min_value)*scale_factor);            if (value > MaxRGB)m             value=MaxRGB;            else             if (value < 0)               value=0;#           *q=(unsigned char) value;;           p++;           q++;	         }c         break;       }      }=     /*!       Initialize image structure.)     */6     image->matte=(viff_header.number_data_bands == 4);     image->class=oF       (viff_header.number_data_bands < 3 ? PseudoClass : DirectClass);$     image->columns=viff_header.rows;$     image->rows=viff_header.columns;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)f5       malloc(image->packets*sizeof(RunlengthPacket));=2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);f     /*=       Convert VIFF raster image to runlength-encoded packets.      */     p=(Quantum *) viff_pixels;     q=image->pixels;5     if (viff_header.data_storage_type == VFF_TYP_BIT)f       {=         unsigned int           polarity;x  
         /*E           Convert bitmap scanline to runlength-encoded color packets. 
         */H         polarity=(viff_header.machine_dependency == VFF_DEP_DECORDER) ||>           (viff_header.machine_dependency == VFF_DEP_NSORDER);'         for (y=0; y < image->rows; y++)f	         {o           /*G             Convert bitmap scanline to runlength-encoded color packets.u           */3           for (x=0; x < (image->columns >> 3); x++)x           { '             for (bit=0; bit < 8; bit++)e
             { E               q->index=((*p) & (0x01 << bit) ? polarity : !polarity);x               q->length=0;               q++;
             }              p++;           } (           if ((image->columns % 8) != 0)
             {t<               for (bit=0; bit < (image->columns % 8); bit++)               {eG                 q->index=((*p) & (0x01 << bit) ? polarity : !polarity);)                 q->length=0;                 q++;               }(               p++;
             }n7           ProgressMonitor(LoadImageText,y,image->rows); 	         }g       }5     else&       if (image->class == PseudoClass)'         for (y=0; y < image->rows; y++) 	         {            /*L             Convert PseudoColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {)             q->index=(*p++);             q->length=0;             q++;           }e7           ProgressMonitor(LoadImageText,y,image->rows); 	         }e
       else	         {o           unsigned long              offset;,             /*L             Convert DirectColor scanline to runlength-encoded color packets.           */,           offset=image->columns*image->rows;)           for (y=0; y < image->rows; y++)t           {m.             for (x=0; x < image->columns; x++)
             {>               q->red=(*p);%               q->green=(*(p+offset));e&               q->blue=(*(p+offset*2));%               if (image->colors != 0)s                 {a5                   q->red=image->colormap[q->red].red;a;                   q->green=image->colormap[q->green].green;L8                   q->blue=image->colormap[q->blue].blue;                 }iM               q->index=(unsigned short) (image->matte ? (*(p+offset*3)) : 0);c               q->length=0;               p++;               q++;
             }e9             ProgressMonitor(LoadImageText,y,image->rows);s           }d	         }p     free((char *) viff_pixels);a$     if (image->class == PseudoClass)       {m         SyncImage(image);f          CompressColormap(image);       }      CompressImage(image);s     /*       Proceed to next image.     */F     status=ReadData((char *) &viff_header.identifier,1,1,image->file);=     if ((status == True) && (viff_header.identifier == 0xab))        {)
         /*#           Allocate image structure.i
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image);l#             return((Image *) NULL);s           }/B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } A   } while ((status == True) && (viff_header.identifier == 0xab));f+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }l o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %tO %                                                                             % O %   R e a d X I m a g e                                                       %%O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %d8 %  Procedure ReadXImage reads an image from an X window. % + %  The format of the ReadXImage routine is:  % @ %      image=ReadXImage(image_info,frame,borders,screen,descend) % + %  A description of each parameter follows:  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % L %    o frame: Specifies whether to include the window manager frame with the
 %      image.  % E %    o borders: Specifies whether borders pixels are to be saved with  %      the image.e %hN %    o screen: Specifies whether the GetImage request used to obtain the imageO %      should be done on the root window, rather than directly on the specifieda %      window. %eO %    o descend: If this option is zero, check to see if the WM_COLORMAP_WINDOWS J %      property is set or if XListInstalledColormaps returns more than oneG %      colormap.  If so, the image is obtained by descending the window = %      hierarchy and reading each subwindow and its colormap.s %p %t */A Image *ReadXImage(ImageInfo *image_info,const unsigned int frame,mL   const unsigned int borders,const unsigned int screen,unsigned int descend) {i
   Colormap     *colormaps;m  	   Displaya
     *display;_     Image      *image;t     int      status,a     x;     RectangleInfo      crop_info;     Window     *children,     client,      prior_target,n	     root,N     target;      XTextProperty.     window_name;     /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {i.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));f       return((Image *) NULL);n     }g   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);-   /*     Select target window.a   */   crop_info.x=0;   crop_info.y=0;   crop_info.width=0;   crop_info.height=0; 4   root=XRootWindow(display,XDefaultScreen(display));   target=(Window) NULL;g0   if ((image_info->filename != (char *) NULL) &&&       (*image_info->filename != '\0'))8     if (Latin1Compare(image_info->filename,"root") == 0)       target=root;     else       {-
         /*&           Select window by ID or name.
         */+         if (isdigit(*image_info->filename))iO           target=XWindowByID(display,root,(Window) strtol(image_info->filename,I             (char **) NULL,0));p$         if (target == (Window) NULL)B           target=XWindowByName(display,root,image_info->filename);$         if (target == (Window) NULL)M           Warning("No window with specified id exists",image_info->filename);        }      /*>     If target window is not defined, interactively select one.   */   prior_target=target;   if (target == (Window) NULL)-     target=XSelectWindow(display,&crop_info); !   client=target;   /* obsolete */    if (target != root)      {        unsigned int
         d;  B       status=XGetGeometry(display,target,&root,&x,&x,&d,&d,&d,&d);       if (status != 0)	         {            for ( ; ; )            {              Window               parent;%               /*(               Find window manager frame.             */I             status=XQueryTree(display,target,&root,&parent,&children,&d); 8             if (status && (children != (Window *) NULL))'               XFree((char *) children);sI             if (!status || (parent == (Window) NULL) || (parent == root))                break;             target=parent;           }r           /*             Get client window.           *//           client=XClientWindow(display,target);f           if (!frame)A             target=client;%           if (!frame && prior_target)i              target=prior_target;	         }e     }S
   if (screen)t     {n	       ints
         y;         Window         child;         XWindowAttributesg         window_attributes;         /*1         Obtain window image directly from screen.t       */E       status=XGetWindowAttributes(display,target,&window_attributes);r       if (status == False)	         {cM           Warning("Unable to read X window attributes",image_info->filename);t!           XCloseDisplay(display); !           return((Image *) NULL);e	         } B       XTranslateCoordinates(display,target,root,0,0,&x,&y,&child);       crop_info.x=x;       crop_info.y=y;.       crop_info.width=window_attributes.width;0       crop_info.height=window_attributes.height;       if (borders)	         {            /*$             Include border in image.           */6           crop_info.x-=window_attributes.border_width;6           crop_info.y-=window_attributes.border_width;?           crop_info.width+=window_attributes.border_width << 1;n@           crop_info.height+=window_attributes.border_width << 1;	         })       target=root;     }E   if (descend)     {i	       intu         number_colormaps,s         number_windows;e         /*N         If WM_COLORMAP_WINDOWS property is set or multiple colormaps, descend.       */       descend=False;       number_windows=0;QM       status=XGetWMColormapWindows(display,target,&children,&number_windows);e3       if ((status == True) && (number_windows > 0))_	         {!           descend=True;i$           XFree ((char *) children);	         }fJ       colormaps=XListInstalledColormaps(display,target,&number_colormaps);       if (number_colormaps > 0)R	         {k#           if (number_colormaps > 1)e             descend=True;f$           XFree((char *) colormaps);	         }      }>   /*+     Alert the user not to alter the screen.E   */   XBell(display,0);o   /*     Get image by window id.t   */   XGrabServer(display);a8   image=XGetWindowImage(display,target,borders,descend);   XUngrabServer(display);e   if (image == (Image *) NULL)B     Warning("Unable to read X window image",image_info->filename);   else     {+:       (void) strcpy(image->filename,image_info->filename);<       if ((crop_info.width != 0) && (crop_info.height != 0))	         {w           Imageu             *cropped_image;a             /*<             Crop image as defined by the cropping rectangle.           */4           cropped_image=CropImage(image,&crop_info);.           if (cropped_image != (Image *) NULL)
             {n"               DestroyImage(image);"               image=cropped_image;
             }m	         } 5       status=XGetWMName(display,target,&window_name);        if (status == True) 	         {o8           if ((image_info->filename != (char *) NULL) &&.               (*image_info->filename == '\0'))
             {                /**                 Initialize image filename.               */H               (void) strncpy(image->filename,(char *) window_name.value,*                 (int) window_name.nitems);7               image->filename[window_name.nitems]='\0';c
             },,           XFree((void *) window_name.value);	         }      }m   /*     Alert the user we're done.   */   XBell(display,0);m   XBell(display,0);    CompressImage(image);r   XCloseDisplay(display);0   return(image); }t ; /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-O %                                                                             %nO %                                                                             %-O %                                                                             %,O %  R e a d X B M I m a g e                                                    %mO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o % K %  Function ReadXBMImage reads an X11 bitmap image file and returns it.  IteK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %,- %  The format of the ReadXBMImage routine is:  % % %      image=ReadXBMImage(image_info)n %n+ %  A description of each parameter follows:l % I %    o image:  Function ReadXBMImage returns a pointer to the image after_L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.( %gA %    o image_info: Specifies a pointer to an ImageInfo structure.g %r %; */7 static int XBMInteger(FILE *file,short int *hex_digits), {t   int-     c,	     flag,=
     value;  
   value=0;	   flag=0; 
   for ( ; ; )m   {+     c=getc(file);      if (c == EOF)-       {          value=(-1);          break;       }      c&=0xff;     if (isxdigit(c))       {o)         value=(value << 4)+hex_digits[c];          flag++;l         continue;        }h$     if ((hex_digits[c]) < 0 && flag)       break;   }a   return(value); }f  7 static Image *ReadXBMImage(const ImageInfo *image_info)  {    char     buffer[MaxTextLength],     name[MaxTextLength];     Imagen     *image;;     register int     x,     y;     register RunlengthPacket     *q;u     register unsigned char     *p;      register unsigned shorti
     index;     short int;     hex_digits[256];     unsigned char      bit,
     *data;     unsigned int	     byte,v     bytes_per_line,)     packets,     padding,
     value,     version;     /*     Allocate image structure.v   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)o/     PrematureExit("Unable to open file",image);f   /*     Read X bitmap header.    */D   while (fgets(buffer,MaxTextLength-1,image->file) != (char *) NULL)?     if (sscanf(buffer,"#define %*32s %u",&image->columns) == 1)        break;D   while (fgets(buffer,MaxTextLength-1,image->file) != (char *) NULL)<     if (sscanf(buffer,"#define %*32s %u",&image->rows) == 1)       break;   /*     Scan until hex digits.   */
   version=11;eD   while (fgets(buffer,MaxTextLength-1,image->file) != (char *) NULL)   { 7     if (sscanf(buffer,"static short %s = {",name) == 1);       version=10;      elseA       if (sscanf(buffer,"static unsigned char %s = {",name) == 1)          version=11; 
       else:         if (sscanf(buffer,"static char %s = {",name) == 1)           version=11;e         else           continue;%*     p=(unsigned char *) strrchr(name,'_');$     if (p == (unsigned char *) NULL)       p=(unsigned char *) name;      else
       p++;)     if (strcmp("bits[]",(char *) p) == 0)        break;   } G   if ((image->columns == 0) || (image->rows == 0) || feof(image->file)) A     PrematureExit("XBM file is not in the correct format",image);    /*     Initialize image structure.    */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));    padding=0;O   if ((image->columns % 16) && ((image->columns % 16) < 9)  && (version == 10))      padding=1;.   bytes_per_line=(image->columns+7)/8+padding;%   packets=bytes_per_line*image->rows;nA   data=(unsigned char *) malloc(packets*sizeof(unsigned char *));i4   if ((image->pixels == (RunlengthPacket *) NULL) ||'       (data == (unsigned char *) NULL))r5     PrematureExit("Unable to allocate memory",image);m   /*     Create colormap.   */   image->class=PseudoClass;i   image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);i   image->colormap[0].red=0;    image->colormap[0].green=0;t   image->colormap[0].blue=0;    image->colormap[1].red=MaxRGB;"   image->colormap[1].green=MaxRGB;!   image->colormap[1].blue=MaxRGB;n   /*     Initialize hex values.   */   hex_digits['0']=0;   hex_digits['1']=1;   hex_digits['2']=2;   hex_digits['3']=3;   hex_digits['4']=4;   hex_digits['5']=5;   hex_digits['6']=6;   hex_digits['7']=7;   hex_digits['8']=8;   hex_digits['9']=9;   hex_digits['A']=10;    hex_digits['B']=11;    hex_digits['C']=12;m   hex_digits['D']=13;"   hex_digits['E']=14;,   hex_digits['F']=15;a   hex_digits['a']=10;x   hex_digits['b']=11;    hex_digits['c']=12;    hex_digits['d']=13;    hex_digits['e']=14;    hex_digits['f']=15;    hex_digits['x']=0;   hex_digits[' ']=(-1);    hex_digits[',']=(-1);r   hex_digits['}']=(-1);e   hex_digits['\n']=(-1);   hex_digits['\t']=(-1);   /*     Read hex image data.   */	   p=data;e   if (version == 10)"     for (x=0; x < packets; (x+=2))     {]/       value=XBMInteger(image->file,hex_digits);        *p++=value;i/       if (!padding || ((x+2) % bytes_per_line))(         *p++=value >> 8;     }_   else     for (x=0; x < packets; x++)i     {i/       value=XBMInteger(image->file,hex_digits);c       *p++=value;      }e   /*8     Convert X bitmap image to runlength-encoded packets.   */	   byte=0;n	   p=data;;   q=image->pixels;!   for (y=0; y < image->rows; y++)    {e
     bit=0;&     for (x=0; x < image->columns; x++)     {e       if (bit == 0)c         byte=(*p++);"       index=(byte & 0x01) ? 0 : 1;       q->index=index;c       q->length=0;
       q++;       bit++;       byte>>=1;=       if (bit == 8)          bit=0;     } 1     ProgressMonitor(LoadImageText,y,image->rows);g   }o   SyncImage(image);)   CompressImage(image);(   CloseImage(image);   free((char *) data);   return(image); }  _ /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             %eO %                                                                             %_O %                                                                             %BO %  R e a d X C I m a g e                                                      %(O %                                                                             % O %                                                                             %rO %                                                                             %>O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function ReadXCImage creates a constant image and initializes to theeH %  X server color as specified by the filename.  It allocates the memoryI %  necessary for the new Image structure and returns a pointer to the newa	 %  image.m %6, %  The format of the ReadXCImage routine is: %h$ %      image=ReadXCImage(image_info) %v+ %  A description of each parameter follows:r %4H %    o image:  Function ReadXCImage returns a pointer to the image afterL %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. %dA %    o image_info: Specifies a pointer to an ImageInfo structure.1 %a %> */6 static Image *ReadXCImage(const ImageInfo *image_info) {,   Imagel     *image;)     int(     x,     y;     register int     i;     register RunlengthPacket     *q;a     unsigned int     height, 
     width;     XColor
     color;     /*     Allocate image structure.a   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);m   /*-     Determine width and height, e.g. 640x512.s   */   width=512;
   height=512;i(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Initialize Image structure.i   */6   (void) strcpy(image->filename,image_info->filename);   image->columns=width;    image->rows=height;_E   image->packets=((image->columns*image->rows-1)/(MaxRunlength+1))+1;r#   image->pixels=(RunlengthPacket *)d3     malloc(image->packets*sizeof(RunlengthPacket));_   image->class=PseudoClass;t   image->colors=1;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);a   /*     Initialize colormap.   */:   (void) XQueryColorDatabase(image_info->filename,&color);/   image->colormap[0].red=XDownScale(color.red);r3   image->colormap[0].green=XDownScale(color.green);n1   image->colormap[0].blue=XDownScale(color.blue);-   q=image->pixels;$   for (i=0; i < image->packets; i++)   {.     q->index=0;      q->length=MaxRunlength;o     q++;     if (QuantumTick(i,image))x6       ProgressMonitor(LoadImageText,i,image->packets);   }n   q--;M   q->length=image->columns*image->rows-(MaxRunlength+1)*(image->packets-1)-1;U   SyncImage(image);o   return(image); }r h /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %iO %                                                                             %(O %                                                                             %iO %  R e a d X P M I m a g e                                                    %0O %                                                                             % O %                                                                             %aO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%B %sK %  Function ReadXBMImage reads an X11 pixmap image file and returns it.  IthK %  allocates the memory necessary for the new Image structure and returns a> %  pointer to the new image. % - %  The format of the ReadXPMImage routine is:y %2% %      image=ReadXPMImage(image_info)e %h+ %  A description of each parameter follows:t % I %    o image:  Function ReadXPMImage returns a pointer to the image after L %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasXPM  #include "xpm.h"7 static Image *ReadXPMImage(const ImageInfo *image_info)  {a   char     *xpm_buffer;  	   Display 
     *display;      Image:     *image;      intg     length,      status,      x,     y;     register char      *q;      register int     i;     register RunlengthPacket     *p;      register unsigned long
     pixel;     XColor     *colors;     XImage     *matte_image,      *ximage;     XpmAttributes      xpm_attributes;      XResourceInfo;     resource_info;  
   XrmDatabaset     resource_database;     XStandardColormap;     *map_info;  
   XVisualInfot     *visual_info;=     /*     Allocate image structure.e   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);(   /*     Open image file.   */"   OpenImage(image_info,image,"r");#   if (image->file == (FILE *) NULL)i/     PrematureExit("Unable to open file",image);    /*     Read XPM file.   */   length=MaxTextLength; 2   xpm_buffer=(char *) malloc(length*sizeof(char));"   if (xpm_buffer != (char *) NULL)     {        q=xpm_buffer; C       while (fgets(q,MaxTextLength-1,image->file) != (char *) NULL)        {3         q+=strlen(q);:2         if ((q-xpm_buffer+MaxTextLength) > length)           {a             *q='\0';             length<<=1;;             xpm_buffer=(char *) ?               realloc((char *) xpm_buffer,length*sizeof(char));s,             if (xpm_buffer == (char *) NULL)               break;,             q=xpm_buffer+strlen(xpm_buffer);           }%       }%     }%"   if (xpm_buffer == (char *) NULL)5     PrematureExit("Unable to allocate memory",image);    CloseImage(image);   /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     { .       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name)); 8       PrematureExit("Unable to create XPM image",image);     }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);%   /*     Allocate standard colormap.o   */#   visual_info=(XVisualInfo *) NULL;t$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)fM     Warning("Unable to create standard colormap","Memory allocation failed");T   else     {e       /*         Initialize visual info.e       */C       visual_info=XBestVisualInfo(display,map_info,&resource_info); .       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL;      }h1   if ((map_info == (XStandardColormap *) NULL) ||e,       (visual_info == (XVisualInfo *) NULL))     { F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);8       PrematureExit("Unable to create XPM image",image);     }n   /*     Initialize X colormap.   */-   map_info->colormap=XCreateColormap(display,oA     XRootWindow(display,visual_info->screen),visual_info->visual, >     visual_info->class == DirectColor ? AllocAll : AllocNone);,   if (map_info->colormap == (Colormap) NULL)     { F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);7       PrematureExit("Unable to create colormap",image);      }    /*     Initialize XPM attributes.   */L   xpm_attributes.valuemask=XpmColorKey | XpmColormap | XpmDepth | XpmVisual;,   xpm_attributes.visual=visual_info->visual;-   xpm_attributes.colormap=map_info->colormap; *   xpm_attributes.depth=visual_info->depth;%   xpm_attributes.color_key=XPM_COLOR;)   /*>     Read in a file in the XPM format into a X image structure.   */J   status=XpmCreateImageFromBuffer(display,xpm_buffer,&ximage,&matte_image,     &xpm_attributes);    if (status != XpmSuccess)a     {"F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);8       PrematureExit("Unable to create XPM image",image);     }    free((char *) xpm_buffer);%   XpmFreeAttributes(&xpm_attributes);a   /*     Get the colormap colors.   */F   colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));    if (colors == (XColor *) NULL)     {iF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       XDestroyImage(ximage);7       PrematureExit("Unable to read X colormap",image);E     }s,   if ((visual_info->class != DirectColor) &&(       (visual_info->class != TrueColor))2     for (i=0; i < visual_info->colormap_size; i++)     {        colors[i].pixel=i;       colors[i].pad=0;     }r   else     {u       unsigned long 
         blue,c         blue_bit,          green,         green_bit,         red,         red_bit;         /*(         DirectColor or TrueColor visual.       */       red=0;       green=0;
       blue=0;+C       red_bit=visual_info->red_mask & (~(visual_info->red_mask)+1);sI       green_bit=visual_info->green_mask & (~(visual_info->green_mask)+1);aF       blue_bit=visual_info->blue_mask & (~(visual_info->blue_mask)+1);4       for (i=0; i < visual_info->colormap_size; i++)       {n+         colors[i].pixel=red | green | blue;*         colors[i].pad=0;         red+=red_bit;o(         if (red > visual_info->red_mask)           red=0;         green+=green_bit;,,         if (green > visual_info->green_mask)           green=0;         blue+=blue_bit; *         if (blue > visual_info->blue_mask)           blue=0;t       }(     }fM   XQueryColors(display,map_info->colormap,colors,visual_info->colormap_size);    /*#     Convert X image to MIFF format.i   */O   if ((visual_info->class != TrueColor) && (visual_info->class != DirectColor))g     image->class=PseudoClass;g   image->columns=ximage->width;m   image->rows=ximage->height;p,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)D3     malloc(image->packets*sizeof(RunlengthPacket));e0   if (image->pixels == (RunlengthPacket *) NULL)     {l       free((char *) colors);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       XDestroyImage(ximage);7       PrematureExit("Unable to allocate memory",image);r     }    p=image->pixels;   switch (image->class)    {      case DirectClass:o     {t       register unsigned long         color,         index;         unsigned long          blue_mask,         blue_shift,          green_mask,e         green_shift,         red_mask,s         red_shift;         /*:         Determine shift and mask for red, green, and blue.       */%       red_mask=visual_info->red_mask;        red_shift=0;$       while ((red_mask & 0x01) == 0)       {l         red_mask>>=1;          red_shift++;       }])       green_mask=visual_info->green_mask;t       green_shift=0;&       while ((green_mask & 0x01) == 0)       {d         green_mask>>=1;          green_shift++;       } '       blue_mask=visual_info->blue_mask;        blue_shift=0; %       while ((blue_mask & 0x01) == 0)        {i         blue_mask>>=1;         blue_shift++;(       }l       /*/         Convert X image to DirectClass packets.F       */-       if ((visual_info->colormap_size > 0) &&+.           (visual_info->class == DirectColor))'         for (y=0; y < image->rows; y++) 	         {t,           for (x=0; x < image->columns; x++)           {l(             pixel=XGetPixel(ximage,x,y);2             index=(pixel >> red_shift) & red_mask;1             p->red=XDownScale(colors[index].red); 6             index=(pixel >> green_shift) & green_mask;5             p->green=XDownScale(colors[index].green);u4             index=(pixel >> blue_shift) & blue_mask;3             p->blue=XDownScale(colors[index].blue);r             p->index=0;              p->length=0;             p++;           }t7           ProgressMonitor(LoadImageText,y,image->rows);>	         }m
       else'         for (y=0; y < image->rows; y++)a	         { ,           for (x=0; x < image->columns; x++)           {e(             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;7             p->red=XDownScale((color*65535L)/red_mask); 6             color=(pixel >> green_shift) & green_mask;;             p->green=XDownScale((color*65535L)/green_mask); 4             color=(pixel >> blue_shift) & blue_mask;9             p->blue=XDownScale((color*65535L)/blue_mask);g             p->index=0;(             p->length=0;             p++;           }g7           ProgressMonitor(LoadImageText,y,image->rows); 	         }e       break;     }      case PseudoClass:      {l       /*         Create colormap.       *//       image->colors=visual_info->colormap_size; P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         {             free((char *) colors);J           XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,F             (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);            XDestroyImage(ximage);           DestroyImage(image);!           return((Image *) NULL); 	         }n'       for (i=0; i < image->colors; i++)        {pG         image->colormap[colors[i].pixel].red=XDownScale(colors[i].red);gK         image->colormap[colors[i].pixel].green=XDownScale(colors[i].green); I         image->colormap[colors[i].pixel].blue=XDownScale(colors[i].blue);c       }r       /*/         Convert X image to PseudoClass packets.l       */%       for (y=0; y < image->rows; y++)_       { *         for (x=0; x < image->columns; x++)	         { :           p->index=(unsigned short) XGetPixel(ximage,x,y);           p->length=0;           p++;	         }[5         ProgressMonitor(LoadImageText,y,image->rows);        }        SyncImage(image);        break;     }c   } %   if (matte_image != (XImage *) NULL)a     {d       /*         Initialize image matte.g       */       image->class=DirectClass;l       image->matte=True;       p=image->pixels;%       for (y=0; y < image->rows; y++)g*         for (x=0; x < image->columns; x++)	         {            p->index=Opaque;*           if (!XGetPixel(matte_image,x,y))!             p->index=Transparent;_           p++;	         } !       XDestroyImage(matte_image);      } "   if (image->class == PseudoClass)     CompressColormap(image);   /*     Free resources.    */   free((char *) colors);   XDestroyImage(ximage);B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,>     (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);   CompressImage(image);i   return(image); }m #elsew7 static Image *ReadXPMImage(const ImageInfo *image_info)* { ?   Warning("XPM library is not available",image_info->filename);C$   return(ReadMIFFImage(image_info)); }) #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %-O %                                                                             %eO %                                                                             % O %  R e a d X W D I m a g e                                                    % O %                                                                             %>O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%- %lL %  Function ReadXWDImage reads an X Window System window dump image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. %S- %  The format of the ReadXWDImage routine is:= %a% %      image=ReadXWDImage(image_info)  % + %  A description of each parameter follows:r %iI %    o image:  Function ReadXWDImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.a %eA %    o image_info: Specifies a pointer to an ImageInfo structure.s %  %  */7 static Image *ReadXWDImage(const ImageInfo *image_info)  {    Image      *image;t     intl     status,-     x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned long
     pixel;     unsigned long+     lsb_first;     unsigned int     packets;     unsigned short
     index;     XColor     *colors;     XImage     *ximage;     XWDFileHeader      header;s     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);*   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)r/     PrematureExit("Unable to open file",image);0   /*       Read in header information.   */?   status=ReadData((char *) &header,sz_XWDheader,1,image->file);    if (status == False);     PrematureExit("Unable to read dump file header",image);l   /*@     Ensure the header byte-order is most-significant byte first.   */   lsb_first=1;   if (*(char *) &lsb_first) 5     MSBFirstOrderLong((char *) &header,sz_XWDheader);-   /*:     Check to see if the dump file is in the proper format.   */.   if (header.file_version != XWD_FILE_VERSION)<     PrematureExit("XWD file format version mismatch",image);(   if (header.header_size < sz_XWDheader)8     PrematureExit("XWD header size is too small",image);,   packets=(header.header_size-sz_XWDheader);<   image->comments=(char *) malloc((packets+1)*sizeof(char));'   if (image->comments == (char *) NULL)c5     PrematureExit("Unable to allocate memory",image);uB   status=ReadData((char *) image->comments,1,packets,image->file);    image->comments[packets]='\0';   if (status == False)F     PrematureExit("Unable to  read window name from dump file",image);   /*     Initialize the X image.    */+   ximage=(XImage *) malloc(sizeof(XImage));g    if (ximage == (XImage *) NULL)5     PrematureExit("Unable to allocate memory",image);a$   ximage->depth=header.pixmap_depth;&   ximage->format=header.pixmap_format;!   ximage->xoffset=header.xoffset;e   ximage->data=(char *) NULL;g$   ximage->width=header.pixmap_width;&   ximage->height=header.pixmap_height;'   ximage->bitmap_pad=header.bitmap_pad;I/   ximage->bytes_per_line=header.bytes_per_line;s'   ximage->byte_order=header.byte_order; )   ximage->bitmap_unit=header.bitmap_unit;%3   ximage->bitmap_bit_order=header.bitmap_bit_order; /   ximage->bits_per_pixel=header.bits_per_pixel; #   ximage->red_mask=header.red_mask; '   ximage->green_mask=header.green_mask; %   ximage->blue_mask=header.blue_mask;    status=XInitImage(ximage);   if (status == False).     PrematureExit("Invalid XWD header",image);   /*     Read colormap.   */   colors=(XColor *) NULL;    if (header.ncolors != 0)     {        XWDColor         color;  M       colors=(XColor *) malloc((unsigned int) header.ncolors*sizeof(XColor)); $       if (colors == (XColor *) NULL)9         PrematureExit("Unable to allocate memory",image);%(       for (i=0; i < header.ncolors; i++)       {%C         status=ReadData((char *) &color,sz_XWDColor,1,image->file);n         if (status == False)I           PrematureExit("Unable to read color map from dump file",image);t$         colors[i].pixel=color.pixel;          colors[i].red=color.red;$         colors[i].green=color.green;"         colors[i].blue=color.blue;$         colors[i].flags=color.flags;       }o       /*D         Ensure the header byte-order is most-significant byte first.       */       lsb_first=1;       if (*(char *) &lsb_first)h*         for (i=0; i < header.ncolors; i++)	         {iM           MSBFirstOrderLong((char *) &colors[i].pixel,sizeof(unsigned long));nO           MSBFirstOrderShort((char *) &colors[i].red,3*sizeof(unsigned short)); 	         }      }    /*     Allocate the pixel buffer.   */    if (ximage->format == ZPixmap)2     packets=ximage->bytes_per_line*ximage->height;   else@     packets=ximage->bytes_per_line*ximage->height*ximage->depth;>   ximage->data=(char *) malloc(packets*sizeof(unsigned char));$   if (ximage->data == (char *) NULL)5     PrematureExit("Unable to allocate memory",image); 6   status=ReadData(ximage->data,1,packets,image->file);   if (status == False)6     PrematureExit("Unable to read dump pixmap",image);   /*!     Convert image to MIFF format.a   */   image->columns=ximage->width;g   image->rows=ximage->height; ?   if ((colors == (XColor *) NULL) || (ximage->red_mask != 0) || <       (ximage->green_mask != 0) || (ximage->blue_mask != 0))     image->class=DirectClass;d   else     image->class=PseudoClass;e   image->colors=header.ncolors;    image->packets=0;h5   packets=Max((image->columns*image->rows+4) >> 3,1);;L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);m   q=image->pixels;   q->length=MaxRunlength;)   switch (image->class)L   {      case DirectClass:l     {/       register unsigned long         color;         unsigned int
         blue,L         green,         red;         unsigned long          blue_mask,         blue_shift,          green_mask,S         green_shift,         red_mask,m         red_shift;         /*:         Determine shift and mask for red, green, and blue.       */        red_mask=ximage->red_mask;       red_shift=0;$       while ((red_mask & 0x01) == 0)       {e         red_mask>>=1;-         red_shift++;       }y$       green_mask=ximage->green_mask;       green_shift=0;&       while ((green_mask & 0x01) == 0)       {.         green_mask>>=1;r         green_shift++;       }."       blue_mask=ximage->blue_mask;       blue_shift=0;.%       while ((blue_mask & 0x01) == 0)        {a         blue_mask>>=1;         blue_shift++;        }e       /*/         Convert X image to DirectClass packets.a       */       if (image->colors != 0)>'         for (y=0; y < image->rows; y++)_	         {e,           for (x=0; x < image->columns; x++)           {-(             pixel=XGetPixel(ximage,x,y);E             index=(unsigned short) ((pixel >> red_shift) & red_mask);d.             red=XDownScale(colors[index].red);I             index=(unsigned short) ((pixel >> green_shift) & green_mask);U2             green=XDownScale(colors[index].green);G             index=(unsigned short) ((pixel >> blue_shift) & blue_mask);n0             blue=XDownScale(colors[index].blue);N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))c               q->length++;             else               {a(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {o                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));xB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);c5                     q=image->pixels+image->packets-1;d                   }c                 q->red=red;t                 q->green=green;                  q->blue=blue;s                 q->index=0;                  q->length=0;               }e           }e7           ProgressMonitor(LoadImageText,y,image->rows);e	         } 
       else'         for (y=0; y < image->rows; y++)i	         {e,           for (x=0; x < image->columns; x++)           {a(             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;4             red=XDownScale((color*65535L)/red_mask);6             color=(pixel >> green_shift) & green_mask;8             green=XDownScale((color*65535L)/green_mask);4             color=(pixel >> blue_shift) & blue_mask;6             blue=XDownScale((color*65535L)/blue_mask);N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))n               q->length++;             else               {*(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {d                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image); 5                     q=image->pixels+image->packets-1;e                   }                  q->red=red;                  q->green=green;i                 q->blue=blue;                  q->index=0;=                 q->length=0;               }            }o7           ProgressMonitor(LoadImageText,y,image->rows); 	         }*       break;     }      case PseudoClass:      {        /*/         Convert X image to PseudoClass packets.        */P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)9         PrematureExit("Unable to allocate memory",image);e'       for (i=0; i < image->colors; i++)*       {e9         image->colormap[i].red=XDownScale(colors[i].red); =         image->colormap[i].green=XDownScale(colors[i].green); ;         image->colormap[i].blue=XDownScale(colors[i].blue);        }x%       for (y=0; y < image->rows; y++)r       {.*         for (x=0; x < image->columns; x++)	         { &           pixel=XGetPixel(ximage,x,y);           index=pixel;F           if ((index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             { &               if (image->packets != 0)                 q++;               image->packets++; ,               if (image->packets == packets)                 {s                   packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket)); @                   if (image->pixels == (RunlengthPacket *) NULL)E                     PrematureExit("Unable to allocate memory",image);r3                   q=image->pixels+image->packets-1;e                 }/               q->index=index;d               q->length=0;
             }c	         } 5         ProgressMonitor(LoadImageText,y,image->rows);a       }n       SyncImage(image);-       CompressColormap(image);       break;     }k   }i#   image->pixels=(RunlengthPacket *)gK     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));t   /*     Free image and colormap.   */   if (header.ncolors != 0)     free((char *) colors);   free(ximage->data);    free(ximage);.   CloseImage(image);   return(image); }  o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%yO %                                                                             %yO %                                                                             %_O %                                                                             % O %  R e a d Y U V I m a g e                                                    %nO %                                                                             %iO %                                                                             % O %                                                                             %pO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadYUVImage reads an image with digital YUV (CCIR 601 4:1:1) bytescG %  and returns it.  It allocates the memory necessary for the new Imager4 %  structure and returns a pointer to the new image. % - %  The format of the ReadYUVImage routine is:  % % %      image=ReadYUVImage(image_info)U %a+ %  A description of each parameter follows:u %uI %    o image:  Function ReadYUVImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.o %yA %    o image_info: Specifies a pointer to an ImageInfo structure.m %- %w */7 static Image *ReadYUVImage(const ImageInfo *image_info)c {m   Image      *image,      *zoomed_image;     inth     x,     y;     register int     i;     register RunlengthPacket     *q;+     register unsigned char     *p;      unsigned charo     *yuv_pixels;     unsigned int     height, 
     width;     /*     Allocate image structure.r   */)   zoomed_image=AllocateImage(image_info); %   if (zoomed_image == (Image *) NULL)      return((Image *) NULL);F   /*     Open image file.   */=   (void) strcpy(zoomed_image->filename,image_info->filename); 4   OpenImage(image_info,zoomed_image,ReadBinaryType);*   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image)    /*-     Determine width and height, e.g. 640x512.g   */   width=512;
   height=512;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);x   for (i=0; i < x; i++) %     (void) fgetc(zoomed_image->file);    /*     Read Y channel.    */#   zoomed_image->columns=width >> 1;1!   zoomed_image->rows=height >> 1;IA   zoomed_image->packets=zoomed_image->columns*zoomed_image->rows;    yuv_pixels=(unsigned char *)7     malloc((3*(width*height)/2)*sizeof(unsigned char));%*   zoomed_image->pixels=(RunlengthPacket *):     malloc(zoomed_image->packets*sizeof(RunlengthPacket));/   if ((yuv_pixels == (unsigned char *) NULL) || 9       (zoomed_image->pixels == (RunlengthPacket *) NULL)) <     PrematureExit("Unable to allocate memory",zoomed_image);O   (void) ReadData((char *) yuv_pixels,1,3*(width*height)/2,zoomed_image->file);    /*     Initialize U channel.    */   p=yuv_pixels+(width*height);   q=zoomed_image->pixels; +   for (i=0; i < zoomed_image->packets; i++)    {I     q->green=UpScale(*p);      q->index=0;      q->length=0;     p++;     q++;   }%   /*     Initialize V channel.%   */)   ProgressMonitor(LoadImageText,100,400);F   q=zoomed_image->pixels;a+   for (i=0; i < zoomed_image->packets; i++)    {t     q->blue=UpScale(*p);     p++;     q++;   }    /*     Scale image.   */)   ProgressMonitor(LoadImageText,250,400);N   zoomed_image->orphan=True;#   image=MagnifyImage(zoomed_image);    zoomed_image->orphan=False;t   CloseImage(zoomed_image);e   DestroyImage(zoomed_image);s   if (image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image);    p=yuv_pixels;    q=image->pixels;2   for (i=0; i < (image->columns*image->rows); i++)   {p     q->red=UpScale(*p);r     p++;     q++;   }t   free((char *) yuv_pixels);+   TransformRGBImage(image,YCbCrColorspace);_   CompressImage(image); )   ProgressMonitor(LoadImageText,400,400);    return(image); }D w /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %yO %                                                                             % O %                                                                             % O %  R e a d Y U V 3 I m a g e                                                  % O %                                                                             %sO %                                                                             %oO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %=J %  Function ReadYUV3Image reads an image with digital YUV (CCIR 601 2:1:1)M %  bytes and returns it.  It allocates the memory necessary for the new ImagelK %  structure and returns a pointer to the new image.  This function differseJ %  from ReadYUVImage in that it reads the Y, U, and V planes from separate) %  files (image.Y, image.U, and image.V).( %g. %  The format of the ReadYUV3Image routine is: %i& %      image=ReadYUV3Image(image_info) %R+ %  A description of each parameter follows:= %FJ %    o image:  Function ReadYUV3Image returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.c % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 static Image *ReadYUV3Image(const ImageInfo *image_info) {    char     filename[MaxTextLength];     Image      *image,      *zoomed_image;     inte     x,     y;     register int     i;     register RunlengthPacket     *q;e     register unsigned char     *p;      unsigned charl     *uv_pixels,c     *y_pixels;     unsigned int     height,l
     width;     /*     Allocate image structure.0   */)   zoomed_image=AllocateImage(image_info); %   if (zoomed_image == (Image *) NULL)i     return((Image *) NULL);    /*     Open image file.   *//   (void) strcpy(filename,image_info->filename);c1   (void) strcpy(zoomed_image->filename,filename); .   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".Y"); 4   OpenImage(image_info,zoomed_image,ReadBinaryType);*   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image)    /*-     Determine width and height, e.g. 640x512.a   */   width=512;
   height=512;e   x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);a   for (i=0; i < x; i++)k%     (void) fgetc(zoomed_image->file);a   /*     Read Y channel.)   */#   zoomed_image->columns=width >> 1;c!   zoomed_image->rows=height >> 1;)A   zoomed_image->packets=zoomed_image->columns*zoomed_image->rows;    uv_pixels=(unsigned char *);8     malloc(zoomed_image->packets*sizeof(unsigned char));   y_pixels=(unsigned char *):     malloc(4*zoomed_image->packets*sizeof(unsigned char));*   zoomed_image->pixels=(RunlengthPacket *):     malloc(zoomed_image->packets*sizeof(RunlengthPacket));.   if ((uv_pixels == (unsigned char *) NULL) ||-       (y_pixels == (unsigned char *) NULL) || 9       (zoomed_image->pixels == (RunlengthPacket *) NULL))=<     PrematureExit("Unable to allocate memory",zoomed_image);P   (void) ReadData((char *) y_pixels,4,zoomed_image->packets,zoomed_image->file);   CloseImage(zoomed_image);    /*     Read U channel.d   */)   ProgressMonitor(LoadImageText,100,400);o1   (void) strcpy(zoomed_image->filename,filename);e.   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".U"); 4   OpenImage(image_info,zoomed_image,ReadBinaryType);*   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image)a=   (void) ReadData((char *) uv_pixels,1,zoomed_image->packets,;     zoomed_image->file);   p=uv_pixels;   q=zoomed_image->pixels;o+   for (i=0; i < zoomed_image->packets; i++)n   {d     q->green=UpScale(*p);l     q->index=0;g     q->length=0;     p++;     q++;   }    CloseImage(zoomed_image);r   /*     Read V channel.e   */)   ProgressMonitor(LoadImageText,200,400);d1   (void) strcpy(zoomed_image->filename,filename);g.   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".V");U4   OpenImage(image_info,zoomed_image,ReadBinaryType);*   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image) =   (void) ReadData((char *) uv_pixels,1,zoomed_image->packets,e     zoomed_image->file);   p=uv_pixels;   q=zoomed_image->pixels;e+   for (i=0; i < zoomed_image->packets; i++)h   {.     q->blue=UpScale(*p);     p++;     q++;   }o   CloseImage(zoomed_image);d   free((char *) uv_pixels);e   /*     Scale image.   */)   ProgressMonitor(LoadImageText,300,400);t   zoomed_image->orphan=True;#   image=MagnifyImage(zoomed_image);l   zoomed_image->orphan=False;(   CloseImage(zoomed_image);    DestroyImage(zoomed_image);s   if (image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image);e
   p=y_pixels;    q=image->pixels;2   for (i=0; i < (image->columns*image->rows); i++)   {g     q->red=UpScale(*p);;     p++;     q++;   }e   free((char *) y_pixels);+   TransformRGBImage(image,YCbCrColorspace);l*   (void) strcpy(image->filename,filename);   CompressImage(image);=)   ProgressMonitor(LoadImageText,400,400);E   return(image); }t e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %iO %                                                                             % O %   R e a d I m a g e                                                         %-O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%) %(B %  Function ReadImage reads an image and returns it.  It allocatesL %  the memory necessary for the new Image structure and returns a pointer toJ %  the new image.  By default, the image format is determined by its magicM %  number. To specify a particular image format, precede the filename with anfM %  explicit image format name and a colon (i.e.  ps:image) or as the filename  %  suffix  (i.e. image.ps).  %o* %  The format of the ReadImage routine is: % " %      image=ReadImage(image_info) % + %  A description of each parameter follows:  % E %    o image: Function ReadImage returns a pointer to the image after;L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read., %mA %    o image_info: Specifies a pointer to an ImageInfo structure.r %; %+ */' Image *ReadImage(ImageInfo *image_info)v {    char      magic_number[MaxTextLength];     Imaget     decode_image,      *image;x     ImageInfoc     decode_info;     register char      *p;x     register int     i;     SetImageInfo(image_info);    decode_info=(*image_info);?   decode_image.temporary=strcmp(decode_info.magick,"TMP") == 0;;3   if ((strncmp(decode_info.magick,"FTP",3) == 0) || 4       (strncmp(decode_info.magick,"HTTP",4) == 0) ||4       (strncmp(decode_info.magick,"GOPHER",6) == 0))     {*
       char         command[MaxTextLength],)          filename[MaxTextLength];         /*H         Retrieve image as specified with a WWW uniform resource locator.       */"       decode_image.temporary=True;"       TemporaryFilename(filename);P       (void) sprintf(command,WWWCommand,decode_info.magick,decode_info.filename,         filename);$       (void) SystemCommand(command);!       SetImageInfo(&decode_info);(3       (void) strcpy(decode_info.filename,filename);)     } J   if (!decode_info.assert || (strncmp(decode_info.magick,"SGI",3) == 0) ||1       (strncmp(decode_info.magick,"PCD",3) == 0))g     {s       /*/         Determine type from image magic number.        *//       for (i=0 ; i < sizeof(magic_number); i++)m         magic_number[i]='\0';o@       (void) strcpy(decode_image.filename,decode_info.filename);9       OpenImage(image_info,&decode_image,ReadBinaryType);e-       if (decode_image.file != (FILE *) NULL)e>         if ((decode_image.file == stdin) || decode_image.pipe)           {m             FILE               *file;               intt               c;               /*<               Copy standard input or pipe to temporary file.             */(             decode_image.temporary=True;5             TemporaryFilename(decode_image.filename);e7             decode_info.filename=decode_image.filename; >             file=fopen(decode_image.filename,WriteBinaryType);&             if (file == (FILE *) NULL)               { E                 Warning("Unable to write file",decode_info.filename); '                 return((Image *) NULL);%               }%'             c=fgetc(decode_image.file);              while (c != EOF)
             { "               (void) putc(c,file);)               c=fgetc(decode_image.file); 
             }               (void) fclose(file);&             CloseImage(&decode_image);?             OpenImage(image_info,&decode_image,ReadBinaryType);            } -       if (decode_image.file != (FILE *) NULL) 	         {            /*             Read magic number.           */C           (void) ReadData(magic_number,(unsigned int) sizeof(char), C             (unsigned int) sizeof(magic_number),decode_image.file); :           if (((unsigned char) magic_number[0] == 0xff) &&8               ((unsigned char) magic_number[1] == 0xff))
             {o               register int                 i;                 /*6                 For PCD image type, skip to byte 2048.               */D               for (i=0; i < (int) (0x800-sizeof(magic_number)); i++)0                 (void) fgetc(decode_image.file);G               (void) ReadData(magic_number,(unsigned int) sizeof(char),rG                 (unsigned int) sizeof(magic_number),decode_image.file);e
             } $           CloseImage(&decode_image);	         }b       /*#         Determine the image format.i       */)       magic_number[MaxTextLength-1]='\0';I,       if (strncmp(magic_number,"BM",2) == 0)0         (void) strcpy(decode_info.magick,"BMP");-       if (strncmp(magic_number,"IT0",3) == 0)p1         (void) strcpy(decode_info.magick,"FITS");o9       if (strncmp(magic_number,"\261\150\336\72",4) == 0)c0         (void) strcpy(decode_info.magick,"DCX");0       if (strncmp(magic_number,"SIMPLE",6) == 0)1         (void) strcpy(decode_info.magick,"FITS");c.       if (strncmp(magic_number,"GIF8",4) == 0)0         (void) strcpy(decode_info.magick,"GIF");:       if (strncmp(magic_number,"\016\003\023\001",4) == 0)0         (void) strcpy(decode_info.magick,"HDF");3       if ((strncmp(magic_number,"<HTML",5) == 0) || 1           (strncmp(magic_number,"<html",5) == 0)) 1         (void) strcpy(decode_info.magick,"HTML"); 2       if (strncmp(magic_number,"\001\332",2) == 0)0         (void) strcpy(decode_info.magick,"SGI");6       if (strncmp(magic_number,"\377\330\377",3) == 0)1         (void) strcpy(decode_info.magick,"JPEG");l9       if (strncmp(magic_number,"id=ImageMagick",14) == 0)_1         (void) strcpy(decode_info.magick,"MIFF");(.       if (strncmp(magic_number,"PCD_",4) == 0)0         (void) strcpy(decode_info.magick,"PCD");/       if (strncmp(magic_number,"\12\2",2) == 0)t0         (void) strcpy(decode_info.magick,"PCX");/       if (strncmp(magic_number,"\12\5",2) == 0)D0         (void) strcpy(decode_info.magick,"PCX");/       if (strncmp(magic_number,"%!PDF",5) == 0);0         (void) strcpy(decode_info.magick,"PDF");=       if ((*magic_number == 'P') && isdigit(magic_number[1]))=0         (void) strcpy(decode_info.magick,"PNM");;       if (strncmp(magic_number,"\211PNG\r\n\032\n",8) == 0)d0         (void) strcpy(decode_info.magick,"PNG");,       if (strncmp(magic_number,"%!",2) == 0)/         (void) strcpy(decode_info.magick,"PS");f5       if (strncmp(magic_number,"#?RADIANCE",10) == 0)d0         (void) strcpy(decode_info.magick,"RAD");2       if (strncmp(magic_number,"\122\314",2) == 0)0         (void) strcpy(decode_info.magick,"RLE");:       if (strncmp(magic_number,"\131\246\152\225",4) == 0)0         (void) strcpy(decode_info.magick,"SUN");>       if ((strncmp(magic_number,"\115\115\000\052",4) == 0) ||<           (strncmp(magic_number,"\111\111\052\000",4) == 0))1         (void) strcpy(decode_info.magick,"TIFF");=5       if ((strncmp(magic_number,"LBLSIZE",7) == 0) ||m2           (strncmp(magic_number,"NJPL1I",6) == 0))2         (void) strcpy(decode_info.magick,"VICAR");0       if (strncmp(magic_number,"\253\1",2) == 0)1         (void) strcpy(decode_info.magick,"VIFF");y!       p=strchr(magic_number,'#');e       if (p != (char *) NULL)*(         if (strncmp(p,"#define",7) == 0)2           (void) strcpy(decode_info.magick,"XBM");3       if (strncmp(magic_number,"/* XPM */",9) == 0)(0         (void) strcpy(decode_info.magick,"XPM");A       if ((magic_number[1] == 0x00) && (magic_number[2] == 0x00))DC         if ((magic_number[5] == 0x00) && (magic_number[6] == 0x00))gE           if ((magic_number[4] == 0x07) || (magic_number[7] == 0x07))e4             (void) strcpy(decode_info.magick,"XWD");     }    /*6     Call appropriate image reader based on image type.   */   switch (*decode_info.magick)   {=
     case 'A':p     { 0       if (strcmp(decode_info.magick,"AVS") == 0)	         {m+           image=ReadAVSImage(&decode_info);r           break;	         }0(       image=ReadMIFFImage(&decode_info);       break;     }a
     case 'B':o     {P0       if (strcmp(decode_info.magick,"BIE") == 0)	         {),           image=ReadJBIGImage(&decode_info);           break;	         } 0       if (strcmp(decode_info.magick,"BMP") == 0)	         {(+           image=ReadBMPImage(&decode_info);            break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }y
     case 'C':      { 1       if (strcmp(decode_info.magick,"CMYK") == 0) 	         { ,           image=ReadCMYKImage(&decode_info);           break;	         }f(       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'D':      { 3       if (strncmp(decode_info.magick,"DCX",3) == 0) 	         { +           image=ReadPCXImage(&decode_info);            break;	         } 0       if (strcmp(decode_info.magick,"DIB") == 0)	         {;+           image=ReadBMPImage(&decode_info);            break;	         }3(       image=ReadMIFFImage(&decode_info);       break;     }n
     case 'E':(     { 3       if (strncmp(decode_info.magick,"EPS",3) == 0) 	         { *           image=ReadPSImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'F':l     {a0       if (strcmp(decode_info.magick,"FAX") == 0)	         {m+           image=ReadFAXImage(&decode_info);(           break;	         } 1       if (strcmp(decode_info.magick,"FITS") == 0)g	         {[,           image=ReadFITSImage(&decode_info);           break;	         }c(       image=ReadMIFFImage(&decode_info);       break;     }v
     case 'G':t     {n3       if (strncmp(decode_info.magick,"GIF",3) == 0)0	         {e+           image=ReadGIFImage(&decode_info);l           break;	         } 1       if (strcmp(decode_info.magick,"GRAY") == 0) 	         { ,           image=ReadGRAYImage(&decode_info);           break;	         }e(       image=ReadMIFFImage(&decode_info);       break;     }g
     case 'H':      { 0       if (strcmp(decode_info.magick,"HDF") == 0)	         {t+           image=ReadHDFImage(&decode_info);a           break;	         }g9       if (strncmp(decode_info.magick,"HISTOGRAM",4) == 0)-	         {+1           image=ReadHISTOGRAMImage(&decode_info);            break;	         } 1       if (strcmp(decode_info.magick,"HTML") == 0) 	         {a,           image=ReadHTMLImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }=
     case 'J':      { 1       if (strcmp(decode_info.magick,"JBIG") == 0)R	         {a,           image=ReadJBIGImage(&decode_info);           break;	         } 1       if (strcmp(decode_info.magick,"JPEG") == 0)a	         { ,           image=ReadJPEGImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'L':f     {)1       if (strcmp(decode_info.magick,"LOGO") == 0) 	         { ,           image=ReadLOGOImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }=
     case 'M':l     { 0       if (strcmp(decode_info.magick,"MAP") == 0)	         { +           image=ReadMAPImage(&decode_info);(           break;	         }r2       if (strcmp(decode_info.magick,"MATTE") == 0)	         {)-           image=ReadMATTEImage(&decode_info);            break;	         } 1       if (strcmp(decode_info.magick,"MONO") == 0) 	         { ,           image=ReadMONOImage(&decode_info);           break;	         }o5       if ((strcmp(decode_info.magick,"MPEG") == 0) || 2           (strcmp(decode_info.magick,"MPG") == 0))	         {1,           image=ReadMPEGImage(&decode_info);           break;	         }e0       if (strcmp(decode_info.magick,"MTV") == 0)	         {f+           image=ReadMTVImage(&decode_info);            break;	         }((       image=ReadMIFFImage(&decode_info);       break;     }t
     case 'N':      {(1       if (strcmp(decode_info.magick,"NULL") == 0)>	         { ,           image=ReadNULLImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'P':      { 4       if ((strcmp(decode_info.magick,"PBM") == 0) ||4           (strcmp(decode_info.magick,"PGM") == 0) ||4           (strcmp(decode_info.magick,"PNM") == 0) ||2           (strcmp(decode_info.magick,"PPM") == 0))	         {-+           image=ReadPNMImage(&decode_info);g           break;	         }(0       if (strcmp(decode_info.magick,"PCD") == 0)	         {g+           image=ReadPCDImage(&decode_info);            break;	         }(0       if (strcmp(decode_info.magick,"PCL") == 0)	         {g+           image=ReadPCLImage(&decode_info);            break;	         }-0       if (strcmp(decode_info.magick,"PCX") == 0)	         { +           image=ReadPCXImage(&decode_info);c           break;	         } 0       if (strcmp(decode_info.magick,"PDF") == 0)	         {f+           image=ReadPDFImage(&decode_info);x           break;	         }f1       if (strcmp(decode_info.magick,"PICT") == 0) 	         {>,           image=ReadPICTImage(&decode_info);           break;	         } 0       if (strcmp(decode_info.magick,"PCD") == 0)	         {r+           image=ReadPCDImage(&decode_info);            break;	         }e/       if (strcmp(decode_info.magick,"PM") == 0) 	         {g+           image=ReadXPMImage(&decode_info);*           break;	         }.0       if (strcmp(decode_info.magick,"PNG") == 0)	         {1+           image=ReadPNGImage(&decode_info);e           break;	         }_2       if (strncmp(decode_info.magick,"PS",2) == 0)	         {r*           image=ReadPSImage(&decode_info);           break;	         }r(       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'R':      {m0       if (strcmp(decode_info.magick,"RAD") == 0)	         { 0           image=ReadRADIANCEImage(&decode_info);           break;	         } 0       if (strcmp(decode_info.magick,"RAS") == 0)	         {p+           image=ReadSUNImage(&decode_info);;           break;	         }m3       if (strncmp(decode_info.magick,"RGB",3) == 0);	         {m+           image=ReadRGBImage(&decode_info);g           break;	         } 0       if (strcmp(decode_info.magick,"RLA") == 0)	         {L+           image=ReadRLAImage(&decode_info);i           break;	         } 0       if (strcmp(decode_info.magick,"RLE") == 0)	         {%+           image=ReadRLEImage(&decode_info);            break;	         } (       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'S':      { 0       if (strcmp(decode_info.magick,"SGI") == 0)	         { +           image=ReadSGIImage(&decode_info);o           break;	         }e0       if (strcmp(decode_info.magick,"SUN") == 0)	         { +           image=ReadSUNImage(&decode_info);            break;	         } (       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'T':      { 1       if (strcmp(decode_info.magick,"TEXT") == 0) 	         { ,           image=ReadTEXTImage(&decode_info);           break;	         }%0       if (strcmp(decode_info.magick,"TGA") == 0)	         {l+           image=ReadTGAImage(&decode_info);t           break;	         }h3       if (strncmp(decode_info.magick,"TIF",3) == 0)h	         {.,           image=ReadTIFFImage(&decode_info);           break;	         }T1       if (strcmp(decode_info.magick,"TILE") == 0)p	         {l,           image=ReadTILEImage(&decode_info);           break;	         }i(       image=ReadMIFFImage(&decode_info);       break;     }s
     case 'U':r     { 1       if (strcmp(decode_info.magick,"UYVY") == 0)a	         {e,           image=ReadUYVYImage(&decode_info);           break;	         }d(       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'V':      {r2       if (strcmp(decode_info.magick,"VICAR") == 0)	         {t-           image=ReadVICARImage(&decode_info);            break;	         } 0       if (strcmp(decode_info.magick,"VID") == 0)	         { !           if (decode_info.assert) -             image=ReadVIDImage(&decode_info);            else.             image=ReadMIFFImage(&decode_info);           break;	         }o1       if (strcmp(decode_info.magick,"VIFF") == 0) 	         {g,           image=ReadVIFFImage(&decode_info);           break;	         }m(       image=ReadMIFFImage(&decode_info);       break;     }m
     case 'X':"     { .       if (strcmp(decode_info.magick,"X") == 0)	         {lA           image=ReadXImage(&decode_info,False,False,False,False);            break;	         }e/       if (strcmp(decode_info.magick,"XC") == 0)g	         {e*           image=ReadXCImage(&decode_info);           break;	         }t0       if (strcmp(decode_info.magick,"XBM") == 0)	         {t+           image=ReadXBMImage(&decode_info);u           break;	         }i0       if (strcmp(decode_info.magick,"XPM") == 0)	         { +           image=ReadXPMImage(&decode_info);=           break;	         }2/       if (strcmp(decode_info.magick,"XV") == 0)f	         {e,           image=ReadVIFFImage(&decode_info);           break;	         } 0       if (strcmp(decode_info.magick,"XWD") == 0)	         {"+           image=ReadXWDImage(&decode_info);f           break;	         }o(       image=ReadMIFFImage(&decode_info);       break;     }o
     case 'Y':l     {00       if (strcmp(decode_info.magick,"YUV") == 0)	         {r+           image=ReadYUVImage(&decode_info);d           break;	         } 1       if (strcmp(decode_info.magick,"YUV3") == 0)g	         {R,           image=ReadYUV3Image(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }i     default:     { /       (void) strcpy(decode_info.magick,"MIFF");t(       image=ReadMIFFImage(&decode_info);     }n   }    if (decode_image.temporary)g(     (void) remove(decode_info.filename);   if (image != (Image *) NULL)     {t       if (image->status)K         Warning("An error has occurred reading from file",image->filename);a!       if (decode_image.temporary) <         (void) strcpy(image->filename,image_info->filename);+       if (image->comments == (char *) NULL)s;         CommentImage(image,"  Imported from %m image: %f");rA       (void) strcpy(image->magick_filename,image_info->filename); %       if (image->magick_columns == 0)a-         image->magick_columns=image->columns;o"       if (image->magick_rows == 0)'         image->magick_rows=image->rows;a2       image_info->interlace=decode_info.interlace;     }i   return(image); }.