 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                   EEEEE  N   N   CCCC   OOO   DDDD   EEEEE                  % O %                   E      NN  N  C      O   O  D   D  E                      % O %                   EEE    N N N  C      O   O  D   D  EEE                    % O %                   E      N  NN  C      O   O  D   D  E                      % O %                   EEEEE  N   N   CCCC   OOO   DDDD   EEEEE                  % O %                                                                             % O %                                                                             % O %                    Utility Routines to Write Image Formats                  % O %                                                                             % O %                                                                             % O %                                                                             % O %                             Software Design                                 % O %                               John Cristy                                   % O %                              January 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright 1996 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Functions in this library convert to and from `alien' image formats to the  %  MIFF image format.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "XWDFile.h"   /*   Define declarations. */, #define SaveImageText  "  Saving image...  "& #define PrematureExit(message,image) \ { \ %   Warning(message,image->filename); \    return(False); \ }    /*   Function prototypes. */ static unsigned int ,   WriteMIFFImage(const ImageInfo *,Image *),+   WritePNMImage(const ImageInfo *,Image *), ,   WriteYUV3Image(const ImageInfo *,Image *);   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e A V S I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function WriteAVSImage writes an image to a file in AVS X image format. % . %  The format of the WriteAVSImage routine is: % - %      status=WriteAVSImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteAVSImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteAVSImage(const ImageInfo *image_info,Image *image)  {    typedef struct _AVSHeader    {      int        width,
       height;    } AVSHeader;     AVSHeader      avs_header;      register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*"     Initialize raster file header.   */"   avs_header.width=image->columns;    avs_header.height=image->rows;F   (void) fwrite((char *) &avs_header,sizeof(AVSHeader),1,image->file);   p=image->pixels;$   for (i=0; i < image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)     { A       (void) fputc(image->matte ? p->index : Opaque,image->file); 2       (void) fputc(DownScale(p->red),image->file);4       (void) fputc(DownScale(p->green),image->file);3       (void) fputc(DownScale(p->blue),image->file);      }      p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e B M P I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function WriteBMPImage writes an image in Microsoft Windows bitmap encoded  %  image format. % . %  The format of the WriteBMPImage routine is: % - %      status=WriteBMPImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteBMPImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteBMPImage(const ImageInfo *image_info,Image *image)  {    typedef struct _BMPHeader    {      unsigned long        file_size;       unsigned short       reserved[2];       unsigned long        offset_bits,       size,        width,
       height;        unsigned short
       planes,        bit_count;       unsigned long        compression,       image_size,        x_pixels,        y_pixels,        number_colors,       colors_important;    } BMPHeader;     BMPHeader      bmp_header;      register int     i,     j,     x,     y;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *bmp_data,     *bmp_pixels;     unsigned int     bytes_per_line;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {      /*(       Initialize BMP raster file header.     */     bmp_header.file_size=14+40; !     bmp_header.offset_bits=14+40; 5     if (!IsPseudoClass(image) && !IsGrayImage(image))        { 
         /*            Full color BMP raster.
         */          bmp_header.bit_count=24;#         bmp_header.number_colors=0;        }      else       { 
         /*!           Colormapped BMP raster. 
         */         bmp_header.bit_count=8; 7         if (IsGrayImage(image) && (image->colors == 2)) !           bmp_header.bit_count=1; <         bmp_header.file_size+=4*(1 << bmp_header.bit_count);>         bmp_header.offset_bits+=4*(1 << bmp_header.bit_count);;         bmp_header.number_colors=1 << bmp_header.bit_count;        }      bmp_header.reserved[0]=0;      bmp_header.reserved[1]=0;      bmp_header.size=40; $     bmp_header.width=image->columns;"     bmp_header.height=image->rows;     bmp_header.planes=1;     bmp_header.compression=0; C     bytes_per_line=((image->columns*bmp_header.bit_count+31)/32)*4; 5     bmp_header.image_size=bytes_per_line*image->rows; 0     bmp_header.file_size+=bmp_header.image_size;     bmp_header.x_pixels=75*39;     bmp_header.y_pixels=75*39;9     bmp_header.colors_important=bmp_header.number_colors;      /*(       Convert MIFF to BMP raster pixels.     */      bmp_pixels=(unsigned char *):       malloc(bmp_header.image_size*sizeof(unsigned char));-     if (bmp_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      x=0;     y=image->rows-1;!     switch (bmp_header.bit_count)      { 
       case 1:        {          register unsigned char           bit,           byte,            polarity;   
         /*>           Convert PseudoClass image to a BMP monochrome image.
         */         p=image->pixels;         polarity=0;          if (image->colors == 2)            polarity= J             Intensity(image->colormap[1]) > Intensity(image->colormap[0]);         bit=0;         byte=0; &         q=bmp_pixels+y*bytes_per_line;*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           {              byte<<=1; %             if (p->index == polarity)                byte|=0x01;              bit++;             if (bit == 8)                {                  *q++=byte;                 bit=0;                 byte=0;                }              x++;$             if (x == image->columns)               {                  /*/                   Advance to the next scanline.                  */                 if (bit != 0) '                   *q++=byte << (8-bit);                  bit=0;                 byte=0;                  x=0;                 y--;.                 q=bmp_pixels+y*bytes_per_line;              }           }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }          break;       } 
       case 8:        { 
         /*2           Convert PseudoClass packet to BMP pixel.
         */3         image->compression=image_info->compression;          CompressImage(image); >         if (image->compression == RunlengthEncodedCompression)(           bytes_per_line=image->columns;         p=image->pixels;&         q=bmp_pixels+y*bytes_per_line;*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           {              *q++=p->index;             x++;$             if (x == image->columns)               {                  x=0;                 y--;.                 q=bmp_pixels+y*bytes_per_line;               }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }          break;       }        case 24:       { 
         /*6           Convert DirectClass packet to BMP RGB pixel.
         */         p=image->pixels;&         q=bmp_pixels+y*bytes_per_line;*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           { $             *q++=DownScale(p->blue);%             *q++=DownScale(p->green); #             *q++=DownScale(p->red);              x++;$             if (x == image->columns)               {                  x=0;                 y--;.                 q=bmp_pixels+y*bytes_per_line;               }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }          break;       }      } "     if (bmp_header.bit_count == 8)<       if (image->compression == RunlengthEncodedCompression)	         {            unsigned int             packets;             /*5             Convert run-length encoded raster pixels.            */@           packets=(bytes_per_line*(bmp_header.height+2)+1) << 1;K           bmp_data=(unsigned char *) malloc(packets*sizeof(unsigned char)); 3           if (bmp_pixels == (unsigned char *) NULL) 
             { ?               Warning("Memory allocation error",(char *) NULL); (               free((char *) bmp_pixels);               return(False);
             }             bmp_header.image_size=K             BMPEncodeImage(bmp_pixels,bmp_data,image->columns,image->rows); $           free((char *) bmp_pixels);           bmp_pixels=bmp_data;#           bmp_header.compression=1; 	         }      /*       Write BMP header.      */(     (void) fwrite("BM",1,2,image->file);8     LSBFirstWriteLong(bmp_header.file_size,image->file);;     LSBFirstWriteShort(bmp_header.reserved[0],image->file); ;     LSBFirstWriteShort(bmp_header.reserved[1],image->file); :     LSBFirstWriteLong(bmp_header.offset_bits,image->file);3     LSBFirstWriteLong(bmp_header.size,image->file); 4     LSBFirstWriteLong(bmp_header.width,image->file);5     LSBFirstWriteLong(bmp_header.height,image->file); 6     LSBFirstWriteShort(bmp_header.planes,image->file);9     LSBFirstWriteShort(bmp_header.bit_count,image->file); :     LSBFirstWriteLong(bmp_header.compression,image->file);9     LSBFirstWriteLong(bmp_header.image_size,image->file); 7     LSBFirstWriteLong(bmp_header.x_pixels,image->file); 7     LSBFirstWriteLong(bmp_header.y_pixels,image->file); <     LSBFirstWriteLong(bmp_header.number_colors,image->file);?     LSBFirstWriteLong(bmp_header.colors_important,image->file); $     if (image->class == PseudoClass)       {          unsigned char            *bmp_colormap;  
         /*            Dump colormap to file.
         */&         bmp_colormap=(unsigned char *)F           malloc(4*(1 << bmp_header.bit_count)*sizeof(unsigned char));3         if (bmp_colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image);          q=bmp_colormap; )         for (i=0; i < image->colors; i++) 	         { 2           *q++=DownScale(image->colormap[i].blue);3           *q++=DownScale(image->colormap[i].green); 1           *q++=DownScale(image->colormap[i].red);            q++;	         } ;         for ( ; i < (int) (1 << bmp_header.bit_count); i++) 	         {            *q++=0;            *q++=0;            *q++=0;            q++;	         } H         (void) fwrite((char *) bmp_colormap,4,1 << bmp_header.bit_count,           image->file); $         free((char *) bmp_colormap);       } D     (void) fwrite((char *) bmp_pixels,1,(int) bmp_header.image_size,       image->file);      free((char *) bmp_pixels);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e C M Y K I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function WriteCMYKImage writes an image to a file in cyan, magenta,' %  yellow, and black rasterfile format.  % / %  The format of the WriteCMYKImage routine is:  % . %      status=WriteCMYKImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteCMYKImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteCMYKImage(const ImageInfo *image_info,Image *image) {    float      black_generation,      undercolor;      int 
     black,	     cyan,      magenta,     yellow;      register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*'     Convert MIFF to CMYK raster pixels.    */   undercolor=1.0;    black_generation=1.0; .   if (image_info->undercolor != (char *) NULL)     { ?       (void) sscanf(image_info->undercolor,"%fx%f",&undercolor,          &black_generation); "       if (black_generation == 1.0)$         black_generation=undercolor;     }     switch (image_info->interlace)   {      case NoneInterlace:      default:     {        /*4         No interlacing:  CMYKCMYKCMYKCMYKCMYKCMYK...       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; C           WriteQuantumFile((unsigned int) (cyan-undercolor*black)); F           WriteQuantumFile((unsigned int) (magenta-undercolor*black));E           WriteQuantumFile((unsigned int) (yellow-undercolor*black)); D           WriteQuantumFile((unsigned int) (black_generation*black));	         }          p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       }        break;     }      case LineInterlace:      {        register int
         x,
         y;         /*?         Line interlacing:  CCC...MMM...YYY...CCC...MMM...YYY...        */"       if (!UncompressImage(image))         return(False);%       for (y=0; y < image->rows; y++)        { +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; C           WriteQuantumFile((unsigned int) (cyan-undercolor*black));            p++;	         } +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; F           WriteQuantumFile((unsigned int) (magenta-undercolor*black));           p++;	         } +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; E           WriteQuantumFile((unsigned int) (yellow-undercolor*black));            p++;	         } +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; D           WriteQuantumFile((unsigned int) (black_generation*black));           p++;	         } 5         ProgressMonitor(SaveImageText,y,image->rows);        }        break;     }      case PlaneInterlace:     {        /*@         Plane interlacing:  CCCCCC...MMMMMM...YYYYYY...KKKKKK...       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; C           WriteQuantumFile((unsigned int) (cyan-undercolor*black)); 	         }          p++;       } -       ProgressMonitor(SaveImageText,100,400);        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; F           WriteQuantumFile((unsigned int) (magenta-undercolor*black));	         }          p++;       } -       ProgressMonitor(SaveImageText,200,400);        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {             cyan=MaxRGB-p->red;#            magenta=MaxRGB-p->green; !            yellow=MaxRGB-p->blue;             black=cyan;            if (magenta < black)               black=magenta;             if (yellow < black)              black=yellow;E           WriteQuantumFile((unsigned int) (yellow-undercolor*black)); 	         }          p++;       } -       ProgressMonitor(SaveImageText,300,400);        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; D           WriteQuantumFile((unsigned int) (black_generation*black));	         }          p++;       } -       ProgressMonitor(SaveImageText,400,400);        break;     }    }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e F A X I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Procedure WriteFAXImage writes an image to a file in 1 dimensional Huffman  %  encoded format. % . %  The format of the WriteFAXImage routine is: % - %      status=WriteFAXImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteFAXImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteFAXImage(const ImageInfo *image_info,Image *image)  {    unsigned int     status;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {      /*!       Convert MIFF to monochrome.      */4     if (!IsGrayImage(image) || (image->colors != 2))       { C         QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);          SyncImage(image);        } %     status=HuffmanEncodeImage(image); &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e F I T S I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteFITSImage writes a Flexible Image Transport System image to a+ %  file as gray scale intensities [0..255].  % / %  The format of the WriteFITSImage routine is:  % . %      status=WriteFITSImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteFITSImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteFITSImage(const ImageInfo *image_info,Image *image) {    char     buffer[81],      *fits_header;      register int     i,     j;     register RunlengthPacket     *p;        /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate image header.   */:   fits_header=(char *) malloc(2880*sizeof(unsigned char));#   if (fits_header == (char *) NULL) 5     PrematureExit("Unable to allocate memory",image);    /*     Initialize image header.   */   for (i=0; i < 2880; i++)     fits_header[i]=' '; 9   (void) strcpy(buffer,"SIMPLE  =                    T"); 6   (void) strncpy(fits_header+0,buffer,strlen(buffer));9   (void) strcpy(buffer,"BITPIX  =                    8"); 7   (void) strncpy(fits_header+80,buffer,strlen(buffer)); 9   (void) strcpy(buffer,"NAXIS   =                    2"); 8   (void) strncpy(fits_header+160,buffer,strlen(buffer));C   (void) sprintf(buffer,"NAXIS1  =           %10u",image->columns); 8   (void) strncpy(fits_header+240,buffer,strlen(buffer));@   (void) sprintf(buffer,"NAXIS2  =           %10u",image->rows);8   (void) strncpy(fits_header+320,buffer,strlen(buffer));:   (void) strcpy(buffer,"HISTORY Created by ImageMagick.");8   (void) strncpy(fits_header+400,buffer,strlen(buffer));   (void) strcpy(buffer,"END");8   (void) strncpy(fits_header+480,buffer,strlen(buffer));9   (void) fwrite((char *) fits_header,1,2880,image->file);    free((char *) fits_header);    /*2     Convert image to fits scale PseudoColor class.   */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)9       (void) fputc(DownScale(Intensity(*p)),image->file);      p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e G I F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteGIFImage writes an image to a file in the Compuserve Graphics %  image format. % . %  The format of the WriteGIFImage routine is: % - %      status=WriteGIFImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteGIFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteGIFImage(const ImageInfo *image_info,Image *image)  {    int 	     left,      top;     register int     i,     x;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      bits_per_pixel,      c,     *colormap;     unsigned int     colors,      height,      interlace,
     scene,     status,      transparent,
     width;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate colormap.   */A   colormap=(unsigned char *) malloc(3*256*sizeof(unsigned char)); )   if (colormap == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image);    /*     Write GIF header.    */B   if ((image->comments == (char *) NULL) && !image_info->adjoin &&       !image->matte),     (void) fwrite("GIF87a",1,6,image->file);   else0     if (strcmp(image_info->magick,"GIF87") == 0).       (void) fwrite("GIF87a",1,6,image->file);     else.       (void) fwrite("GIF89a",1,6,image->file);   width=image->columns;    height=image->rows;    if (image_info->adjoin)      {        Image          *q;          /*%         Determine image bounding box.        */9       for (q=image->next; q != (Image *) NULL; q=q->next)        {          if (q->columns > width)            width=q->columns;          if (q->rows > height)            height=q->rows;        }      } 	   left=0;    top=0;(   LSBFirstWriteShort(width,image->file);)   LSBFirstWriteShort(height,image->file); "   interlace=image_info->interlace;<   if (image_info->adjoin && (image->next != (Image *) NULL))     interlace=NoneInterlace;
   scene=0;   do   {      colors=image->colors;      transparent=False;?     if ((image->class == DirectClass) || (image->colors > 256))        {          unsigned char            *matte_image;   +         matte_image=(unsigned char *) NULL;          if (image->matte)            {              /*-               Map all the transparent pixels.              */(             if (!UncompressImage(image))               return(False);)             matte_image=(unsigned char *) ;               malloc(image->packets*sizeof(unsigned char)); 6             if (matte_image == (unsigned char *) NULL)               { C                 Warning("Memory allocation error",image->filename);                  return(False);               }              p=image->pixels;.             for (i=0; i < image->packets; i++)
             { 5               matte_image[i]=p->index == Transparent; !               if (matte_image[i]) !                 transparent=True;                p++;
             }            } '         colors=transparent ? 255 : 256; G         QuantizeImage(image,colors,8,image_info->dither,RGBColorspace);          SyncImage(image);           CompressColormap(image);         colors=image->colors;          if (transparent)           { (             if (!UncompressImage(image))               return(False);             colors++;              p=image->pixels;.             for (i=0; i < image->packets; i++)
             { !               if (matte_image[i]) '                 p->index=image->colors;                p++;
             }            } 2         if (matte_image != (unsigned char *) NULL)%           free((char *) matte_image);        } @     for (bits_per_pixel=1; bits_per_pixel < 8; bits_per_pixel++)*       if ((1 << bits_per_pixel) >= colors)         break;     q=colormap; %     for (i=0; i < image->colors; i++)      { -       *q++=DownScale(image->colormap[i].red); /       *q++=DownScale(image->colormap[i].green); .       *q++=DownScale(image->colormap[i].blue);     } 1     for ( ; i < (int) (1 << bits_per_pixel); i++)      {        *q++=0x0;        *q++=0x0;        *q++=0x0;      }      if (scene == 0)        { 
         /*            Write global colormap.
         */         c=0x80; .         c|=(8-1) << 4;  /* color resolution */>         c|=(bits_per_pixel-1);   /* size of global colormap */+         (void) fputc((char) c,image->file); >         (void) fputc(0x0,image->file);  /* background color */6         (void) fputc(0x0,image->file);  /* reserved */F         (void) fwrite(colormap,1,3*(1 << bits_per_pixel),image->file);       } 0     if (strcmp(image_info->magick,"GIF87") != 0)       { B         if (image_info->adjoin && (image->next != (Image *) NULL));           if ((scene == 0) && (image_info->iterations > 0)) 
             {                /*.                 Write Netscape Loop extension.               */-               (void) fputc(0x21,image->file); -               (void) fputc(0xff,image->file); -               (void) fputc(0x0b,image->file); <               (void) fwrite("NETSCAPE2.0",1,11,image->file);-               (void) fputc(0x03,image->file); -               (void) fputc(0x01,image->file); E               LSBFirstWriteShort(image_info->iterations,image->file); -               (void) fputc(0x00,image->file); 
             } F         if ((image_info->adjoin && (image->next != (Image *) NULL)) ||             transparent)           {              unsigned int               delay;               /*/               Write Graphics Control extension.              */+             (void) fputc(0x21,image->file); +             (void) fputc(0xf9,image->file); +             (void) fputc(0x04,image->file); '             c=image_info->dispose << 2;              if (transparent)               c|=0x01;(             (void) fputc(c,image->file);             delay=0;.             if (image->delay != (char *) NULL)'               delay=atoi(image->delay); 2             LSBFirstWriteShort(delay,image->file);;             (void) fputc((char) image->colors,image->file); +             (void) fputc(0x00,image->file);            } -         if (image->comments != (char *) NULL)            {              register char                *p;   !             register unsigned int                count;               /*&               Write Comment extension.             */+             (void) fputc(0x21,image->file); +             (void) fputc(0xfe,image->file);              p=image->comments;'             while ((int) strlen(p) > 0) 
             { -               count=Min((int) strlen(p),255); .               (void) fputc(count,image->file);'               for (i=0; i < count; i++) /                 (void) fputc(*p++,image->file); 
             } *             (void) fputc(0x0,image->file);           }        } 9     (void) fputc(',',image->file);  /* image separator */      /*       Write the image header.      */%     if (image->page != (char *) NULL) C       (void) XParseGeometry(image->page,&left,&top,&width,&height); )     LSBFirstWriteShort(left,image->file); (     LSBFirstWriteShort(top,image->file);3     LSBFirstWriteShort(image->columns,image->file); 0     LSBFirstWriteShort(image->rows,image->file);     c=0x00; #     if (interlace != NoneInterlace) .       c|=0x40;  /* pixel data is interlaced */     if (!image_info->adjoin))       (void) fputc((char) c,image->file);      else       {          c|=0x80;=         c|=(bits_per_pixel-1);   /* size of local colormap */ +         (void) fputc((char) c,image->file); F         (void) fwrite(colormap,1,3*(1 << bits_per_pixel),image->file);       }      /*       Write the image data.      */     c=Max(bits_per_pixel,2);'     (void) fputc((char) c,image->file); #     if (interlace == NoneInterlace) ;       status=GIFEncodeImage(image,Max(bits_per_pixel,2)+1);      else       { 
         Image            *interlaced_image;           int            pass,            y;            register RunlengthPacket
           *q;            static int-           interlace_rate[4] = { 8, 8, 4, 2 }, .           interlace_start[4] = { 0, 4, 2, 1 };  
         /*           Interlace image.
         */$         if (!UncompressImage(image))           return(False);         image->orphan=True; K         interlaced_image=CopyImage(image,image->columns,image->rows,False);          image->orphan=False;/         if (interlaced_image == (Image *) NULL) ;           PrematureExit("Unable to allocate memory",image);          p=image->pixels;#         q=interlaced_image->pixels; &         for (pass=0; pass < 4; pass++)	         { "           y=interlace_start[pass];!           while (y < image->rows)            { /             p=image->pixels+(y*image->columns); .             for (x=0; x < image->columns; x++)
             {                *q=(*p);               p++;               q++;
             } $             y+=interlace_rate[pass];           } 	         } +         interlaced_image->file=image->file; H         status=GIFEncodeImage(interlaced_image,Max(bits_per_pixel,2)+1);-         interlaced_image->file=(FILE *) NULL; '         DestroyImage(interlaced_image);        }      if (status == False)7       PrematureExit("Unable to allocate memory",image); "     (void) fputc(0x0,image->file);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;     scene++;   } while (image_info->adjoin); 1   (void) fputc(';',image->file); /* terminator */    free((char *) colormap);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e G R A Y I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteGRAYImage writes an image to a file as gray scale intensity
 %  values. % / %  The format of the WriteGRAYImage routine is:  % . %      status=WriteGRAYImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteGRAYImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteGRAYImage(const ImageInfo *image_info,Image *image) {    register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*2     Convert image to gray scale PseudoColor class.   */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)&       WriteQuantumFile(Intensity(*p));     p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e H D F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteHDFImage writes an image in the Hierarchial Data Format image
 %  format. % . %  The format of the WriteHDFImage routine is: % - %      status=WriteHDFImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteHDFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */
 #ifdef HasHDF K static unsigned int WriteHDFImage(const ImageInfo *image_info,Image *image)  {  #include "hdf.h"
 #undef BSD #undef LOCAL     int      status;      register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      uint16     reference;     unsigned char      *hdf_pixels;     unsigned int     compression,     packet_size,
     scene;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    CloseImage(image);
   scene=0;   do   {      /*$       Initialize raster file header.     */     packet_size=1;$     if (image->class == DirectClass)       packet_size=3;      hdf_pixels=(unsigned char *)K       malloc(packet_size*image->columns*image->rows*sizeof(unsigned char)); -     if (hdf_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      p=image->pixels;5     if (!IsPseudoClass(image) && !IsGrayImage(image))        { 
         /*3           Convert DirectClass packet to HDF pixels. 
         */         q=hdf_pixels; &         switch (image_info->interlace)	         {            case NoneInterlace:            default:           {              /*4               No interlacing:  RGBRGBRGBRGBRGBRGB...             */"             DF24setil(DFIL_PIXEL);.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)               { '                 *q++=DownScale(p->red); )                 *q++=DownScale(p->green); (                 *q++=DownScale(p->blue);               }                p++;'               if (QuantumTick(i,image)) @                 ProgressMonitor(SaveImageText,i,image->packets);
             }              break;           }            case LineInterlace:            {              register int               x,               y;               /*E               Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...              */(             if (!UncompressImage(image))               return(False);!             DF24setil(DFIL_LINE); +             for (y=0; y < image->rows; y++) 
             { 1               p=image->pixels+(y*image->columns); 0               for (x=0; x < image->columns; x++)               { '                 *q++=DownScale(p->red);                  p++;               } 1               p=image->pixels+(y*image->columns); 0               for (x=0; x < image->columns; x++)               { )                 *q++=DownScale(p->green);                  p++;               } 1               p=image->pixels+(y*image->columns); 0               for (x=0; x < image->columns; x++)               { (                 *q++=DownScale(p->blue);                 p++;               } ;               ProgressMonitor(SaveImageText,y,image->rows); 
             }              break;           }            case PlaneInterlace:           {              /*=               Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...              */"             DF24setil(DFIL_PLANE);.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)'                 *q++=DownScale(p->red);                p++;
             } 3             ProgressMonitor(SaveImageText,100,400);              p=image->pixels;.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++))                 *q++=DownScale(p->green);                p++;
             } 3             ProgressMonitor(SaveImageText,250,400);              p=image->pixels;.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)(                 *q++=DownScale(p->blue);               p++;
             } 3             ProgressMonitor(SaveImageText,400,400);              break;           } 	         }          if (scene == 0) B           status=DF24putimage(image->filename,(void *) hdf_pixels,(             image->columns,image->rows);         elseB           status=DF24addimage(image->filename,(void *) hdf_pixels,(             image->columns,image->rows);          reference=DF24lastref();       }      else       { 
         /*3           Convert PseudoClass packet to HDF pixels. 
         */         q=hdf_pixels;          if (IsGrayImage(image)) ,           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)%               *q++=DownScale(p->red);              p++;%             if (QuantumTick(i,image)) >               ProgressMonitor(SaveImageText,i,image->packets);           }          else           {              unsigned char                *hdf_palette;   L             hdf_palette=(unsigned char *) malloc(768*sizeof(unsigned char));6             if (hdf_palette == (unsigned char *) NULL)?               PrematureExit("Unable to allocate memory",image);              q=hdf_palette;-             for (i=0; i < image->colors; i++) 
             { 5               *q++=DownScale(image->colormap[i].red); 7               *q++=DownScale(image->colormap[i].green); 6               *q++=DownScale(image->colormap[i].blue);
             } /             (void) DFR8setpalette(hdf_palette);              free(hdf_palette);             q=hdf_pixels; .             for (i=0; i < image->packets; i++)
             { 2               for (j=0; j <= (int) p->length; j++)                 *q++=p->index;               p++;'               if (QuantumTick(i,image)) @                 ProgressMonitor(SaveImageText,i,image->packets);
             }            } M         compression=image_info->compression == NoCompression ? 0 : DFTAG_RLE;          if (scene == 0) B           status=DFR8putimage(image->filename,(void *) hdf_pixels,4             image->columns,image->rows,compression);         elseB           status=DFR8addimage(image->filename,(void *) hdf_pixels,4             image->columns,image->rows,compression);          reference=DFR8lastref();       } &     if (image->label != (char *) NULL)L       (void) DFANputlabel(image->filename,DFTAG_RIG,reference,image->label);)     if (image->comments != (char *) NULL) M       (void) DFANputdesc(image->filename,DFTAG_RIG,reference,image->comments, #         strlen(image->comments)+1);      free(hdf_pixels);      scene++;&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    return(status != -1);  }  #else K static unsigned int WriteHDFImage(const ImageInfo *image_info,Image *image)  {    unsigned int     status;   :   Warning("HDF library is not available",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e H I S T O G R A M I m a g e                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteHISTOGRAMImage writes an image to a file in HISTOGRAM format.O %  The image shows a histogram of the color (or gray) values in the image.  The O %  image consists of three overlaid histograms:  a red one for the red channel, O %  a green one for the green channel, and a blue one for the blue channel.  The O %  image comment contains a list of unique pixel values and the number of times  %  each occurs in the image. % > %  This routine is strongly based on a similiar one written byI %  muquit@warm.semcor.com which in turn is based on ppmhistmap of netpbm.  % 4 %  The format of the WriteHISTOGRAMImage routine is: % 3 %      status=WriteHISTOGRAMImage(image_info,image)  % + %  A description of each parameter follows.  % P %    o status: Function WriteHISTOGRAMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */D static unsigned int WriteHISTOGRAMImage(const ImageInfo *image_info,   Image *image)  { # #define HistogramDensity  "256x200"      char     filename[MaxTextLength];     double
     scale;     FILE
     *file;     Image      *histogram_image;      int 
     *blue,     *green,      maximum,	     *red,      sans_offset;     register RunlengthPacket     *p,      *q;      register int     i,     j;     unsigned int     height,      status, 
     width;     /*     Allocate histogram image.    */C   (void) XParseGeometry(HistogramDensity,&sans_offset,&sans_offset,      &width,&height);+   if (image_info->density != (char *) NULL) H     (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,       &width,&height);   image->orphan=True; 6   histogram_image=CopyImage(image,width,height,False);   image->orphan=False;(   if (histogram_image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image); %   histogram_image->class=DirectClass;    /*$     Allocate histogram count arrays.   */<   red=(int *) malloc (histogram_image->columns*sizeof(int));>   green=(int *) malloc (histogram_image->columns*sizeof(int));=   blue=(int *) malloc (histogram_image->columns*sizeof(int)); 9   if ((red == (int *) NULL) || (green == (int *) NULL) ||        (blue == (int *) NULL))      { $       DestroyImage(histogram_image);7       PrematureExit("Unable to allocate memory",image);      }    /*&     Initialize histogram count arrays.   */.   for (i=0; i < histogram_image->columns; i++)   { 
     red[i]=0;      green[i]=0;      blue[i]=0;   }    p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     red[DownScale(p->red)]+=(p->length+1);.     green[DownScale(p->green)]+=(p->length+1);,     blue[DownScale(p->blue)]+=(p->length+1);     p++;   }    maximum=0;.   for (i=0; i < histogram_image->columns; i++)   {      if (maximum < red[i])        maximum=red[i];      if (maximum < green[i])        maximum=green[i];      if (maximum < blue[i])       maximum=blue[i];   } .   for (i=0; i < histogram_image->columns; i++)   {      if (red[i] > maximum)        red[i]=maximum;      if (green[i] > maximum)        green[i]=maximum;      if (blue[i] > maximum)       blue[i]=maximum;   }    /*     Initialize histogram image.    */   q=histogram_image->pixels;.   for (i=0; i < histogram_image->packets; i++)   { 
     q->red=0;      q->green=0;      q->blue=0;     q->index=0;      q->length=0;     q++;   } /   scale=(double) histogram_image->rows/maximum;    q=histogram_image->pixels;.   for (i=0; i < histogram_image->columns; i++)   { 1     j=histogram_image->rows-(int) (scale*red[i]); %     while (j < histogram_image->rows)      { ?       q=histogram_image->pixels+(j*histogram_image->columns+i);        q->red=MaxRGB;
       j++;     } 3     j=histogram_image->rows-(int) (scale*green[i]); %     while (j < histogram_image->rows)      { ?       q=histogram_image->pixels+(j*histogram_image->columns+i);        q->green=MaxRGB;
       j++;     } 2     j=histogram_image->rows-(int) (scale*blue[i]);%     while (j < histogram_image->rows)      { ?       q=histogram_image->pixels+(j*histogram_image->columns+i);        q->blue=MaxRGB; 
       j++;     } >     ProgressMonitor(SaveImageText,i,histogram_image->columns);   }    free ((char *) blue);    free ((char *) green);   free ((char *) red);   TemporaryFilename(filename);   file=fopen(filename,"w");    if (file != (FILE *) NULL)     { 
       char         command[MaxTextLength];          /*,         Add a histogram as an image comment.       */2       (void) fprintf(file,"%s\n",image->comments);       NumberColors(image,file);        (void) fclose(file);-       (void) sprintf(command,"@%s",filename); ,       CommentImage(histogram_image,command);       (void) remove(filename);     }    /*"     Write HISTOGRAM image as MIFF.   */4   status=WriteMIFFImage(image_info,histogram_image);    DestroyImage(histogram_image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e H T M L I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteHTMLImage writes an image in the HTML encoded image format. % / %  The format of the WriteHTMLImage routine is:  % . %      status=WriteHTMLImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteHTMLImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteHTMLImage(const ImageInfo *image_info,Image *image) {    char     color[MaxTextLength],      filename[MaxTextLength],     mapname[MaxTextLength],      url[MaxTextLength];      int      x,     y;     register char      *p;      unsigned int     height,      status, 
     width;     *url='\0';3   if ((strncmp(image_info->magick,"FTP",3) == 0) || 2       (strncmp(image_info->magick,"HTTP",4) == 0))     {        /*'         Extract URL base from filename.        */%       p=strrchr(image->filename,'/');        if (p)	         {            p++;0           (void) strcpy(url,image_info->magick);!           (void) strcat(url,":"); 2           url[strlen(url)+p-image->filename]='\0';@           (void) strncat(url,image->filename,p-image->filename);$           strcpy(image->filename,p);	         }      }    /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Write the HTML image file.   */&   if (*image->magick_filename != '\0'):     (void) strcpy(image->filename,image->magick_filename);9   (void) fprintf(image->file,"<html version=\"2.0\">\n"); )   (void) fprintf(image->file,"<head>\n"); D   (void) fprintf(image->file,"<title>%s</title>\n",image->filename);*   (void) fprintf(image->file,"</head>\n");)   (void) fprintf(image->file,"<body>\n"); +   (void) fprintf(image->file,"<center>\n"); >   (void) fprintf(image->file,"<h1>%s</h1>\n",image->filename);+   (void) fprintf(image->file,"<br><br>\n"); *   (void) strcpy(filename,image->filename);+   AppendImageFormat("gif",image->filename); &   if (image->montage == (char *) NULL)G     (void) fprintf(image->file,"<img src=\"%s\" border=0>\n",filename);    else     {        /*          Refer to image map file.       */.       (void) strcpy(image->filename,filename);/       AppendImageFormat("map",image->filename); $       p=filename+strlen(filename)-1;>       while ((p > filename) && (*(p-1) != *BasenameSeparator))         p--;       (void) strcpy(mapname,p); 9       for (p=mapname+strlen(mapname)-1; p > mapname; p--)          if (*p == '.')           {              *p='\0';             break;           } (       AppendImageFormat("gif",filename);P       (void) fprintf(image->file,"<img ismap usemap=#%s src=\"%s\" border=0>\n",         mapname,filename);       /*;         Determine the size and location of each image tile.        */
       x=0;
       y=0;       width=image->columns;        height=image->rows; A       (void) XParseGeometry(image->montage,&x,&y,&width,&height);        /*         Write an image map.        */<       (void) fprintf(image->file,"<map name=%s>\n",mapname);<       (void) fprintf(image->file,"  <area href=""%s""",url);/       for (p=image->directory; *p != '\0'; p++)          if (*p != '\n') '           (void) fputc(*p,image->file);          else           { O             (void) fprintf(image->file," shape=rect coords=%d,%d,%d,%d>\n",x,y, 0               x+(int) width-1,y+(int) height-1);             if (*(p+1) != '\0') D               (void) fprintf(image->file,"  <area href=""%s""",url);             x+=width; $             if (x >= image->columns)               {                  x=0;                 y+=height;               }            } -       (void) fprintf(image->file,"</map>\n"); O       (void) sprintf(color,"#%02x%02x%02x",(unsigned int) image->pixels[0].red, <         (unsigned int) image->pixels[0].green,(unsigned int)         image->pixels[0].blue); $       TransparentImage(image,color);.       (void) strcpy(filename,image->filename);/       AppendImageFormat("gif",image->filename);      } ,   (void) fprintf(image->file,"</center>\n");0   (void) fprintf(image->file,"<br><br><pre>\n");(   DescribeImage(image,image->file,True);)   (void) fprintf(image->file,"</pre>\n"); *   (void) fprintf(image->file,"</body>\n");*   status=fprintf(image->file,"</html>\n");   CloseImage(image);,   if (strcmp(image_info->magick,"GIF") != 0)     {        /*+         Write the image as transparent GIF.        */.       (void) strcpy(image->filename,filename);/       AppendImageFormat("gif",image->filename); .       status|=WriteGIFImage(image_info,image);     } &   if (image->montage != (char *) NULL)     {        /*         Open image map.        */.       (void) strcpy(image->filename,filename);<       for (p=filename+strlen(filename)-1; p > filename; p--)         if (*p == '.')           { @             (void) strncpy(image->filename,filename,p-filename);-             image->filename[p-filename]='\0';              break;           } 1       (void) strcat(image->filename,"_map.html"); &       OpenImage(image_info,image,"w");'       if (image->file == (FILE *) NULL) 3         PrematureExit("Unable to open file",image);        /*;         Determine the size and location of each image tile.        */
       x=0;
       y=0;       width=image->columns;        height=image->rows; A       (void) XParseGeometry(image->montage,&x,&y,&width,&height);        /*         Write an image map.        */<       (void) fprintf(image->file,"<map name=%s>\n",mapname);<       (void) fprintf(image->file,"  <area href=""%s""",url);/       for (p=image->directory; *p != '\0'; p++)          if (*p != '\n') '           (void) fputc(*p,image->file);          else           { O             (void) fprintf(image->file," shape=rect coords=%d,%d,%d,%d>\n",x,y, 0               x+(int) width-1,y+(int) height-1);             if (*(p+1) != '\0') D               (void) fprintf(image->file,"  <area href=""%s""",url);             x+=width; $             if (x >= image->columns)               {                  x=0;                 y+=height;               }            } -       (void) fprintf(image->file,"</map>\n");        CloseImage(image);     } *   (void) strcpy(image->filename,filename);   return(status);  }    #ifdef HasJBIG #include "jbig.h"    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e J B I G I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteJBIGImage writes an image in the JBIG encoded image format. % / %  The format of the WriteJBIGImage routine is:  % . %      status=WriteJBIGImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteJBIGImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */  @ void JBIGEncode(unsigned char  *start,size_t length,void  *file) { .   (void) fwrite(start,length,1,(FILE *) file);	   return;  }   L static unsigned int WriteJBIGImage(const ImageInfo *image_info,Image *image) {    int      sans_offset;     register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     bit,     *q;      struct jbg_enc_state     jbig_info;     unsigned char      *pixels,
     polarity;      unsigned int	     byte,      number_packets,      x,     x_resolution,      y_resolution;      /*     Open image file.   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {      /*       Allocate pixel data.     */9     number_packets=((image->columns+7) >> 3)*image->rows; J     pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));)     if (pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      /*3       Convert Runlength encoded pixels to a bitmap.      */4     if (!IsGrayImage(image) || (image->colors != 2))       { C         QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);          SyncImage(image);        }      polarity=0;      if (image->colors == 2) M       polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]); 
     bit=0;     byte=0;      x=0;     p=image->pixels;
     q=pixels; &     for (i=0; i < image->packets; i++)     { *       for (j=0; j <= (int) p->length; j++)       {          byte<<=1; !         if (p->index == polarity)            byte|=0x01;          bit++;         if (bit == 8)            {              *q++=byte;             bit=0;             byte=0;            }          x++;          if (x == image->columns)           {              /*+               Advance to the next scanline.              */             if (bit != 0) #               *q++=byte << (8-bit);              bit=0;             byte=0;              x=0;
          }       } 
       p++;       if (QuantumTick(i,image)) 8         ProgressMonitor(SaveImageText,i,image->packets);     }      /*%       Initialize JBIG info structure.      */A     jbg_enc_init(&jbig_info,image->columns,image->rows,1,&pixels, ;       (void (*)(unsigned char *,size_t,void *)) JBIGEncode,        image->file);      x_resolution=640;      y_resolution=480; H     (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,#       &x_resolution,&y_resolution); "     if (image_info->subimage != 0)6       jbg_enc_layers(&jbig_info,image_info->subimage);     else;       jbg_enc_lrlmax(&jbig_info,x_resolution,y_resolution); %     jbg_enc_lrange(&jbig_info,-1,-1); L     jbg_enc_options(&jbig_info,JBG_ILEAVE | JBG_SMID,JBG_TPDON | JBG_TPBON |       JBG_DPON,-1,-1,-1);      /*       Write JBIG image.      */     jbg_enc_out(&jbig_info);     jbg_enc_free(&jbig_info);      free((char *) pixels);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }  #else L static unsigned int WriteJBIGImage(const ImageInfo *image_info,Image *image) {    unsigned int     status;   ;   Warning("JBIG library is not available",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif   #ifdef HasJPEG #include "jpeglib.h" #include "jerror.h"    static Image	   *image;    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  W r i t e J P E G I m a g e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WriteJPEGImage writes a JPEG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % / %  The format of the WriteJPEGImage routine is:  % . %      status=WriteJPEGImage(image_info,image) % + %  A description of each parameter follows:  % L %    o status:  Function WriteJPEGImage return True if the image is written.I %      False is returned is there is of a memory shortage or if the image ) %      file cannot be opened for writing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % 3 %    o jpeg_image:  A pointer to a Image structure.  %  %  */  9 static void EmitMessage(j_common_ptr jpeg_info,int level)  {    char     message[JMSG_LENGTH_MAX];      struct jpeg_error_mgr      *jpeg_error;     jpeg_error=jpeg_info->err;3   (jpeg_error->format_message) (jpeg_info,message);    if (level < 0)     { H       if (jpeg_error->num_warnings == 0 || jpeg_error->trace_level >= 3)2         Warning((char *) message,image->filename);!       jpeg_error->num_warnings++;      }    else)     if (jpeg_error->trace_level >= level) 0       Warning((char *) message,image->filename); }   L static unsigned int WriteJPEGImage(const ImageInfo *image_info,Image *image) { 	   JSAMPLE      *jpeg_pixels;   
   JSAMPROW     scanline[1];     register int     i,     j,     x;     register JSAMPLE     *q;      register RunlengthPacket     *p;      struct jpeg_compress_struct      jpeg_info;     struct jpeg_error_mgr      jpeg_error;      unsigned int     packets;     /*     Open image file.   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize JPEG parameters.    */,   jpeg_info.err=jpeg_std_error(&jpeg_error);*   jpeg_info.err->emit_message=EmitMessage;#   jpeg_create_compress(&jpeg_info); *   jpeg_stdio_dest(&jpeg_info,image->file);'   jpeg_info.image_width=image->columns; %   jpeg_info.image_height=image->rows;    jpeg_info.input_components=3; #   jpeg_info.in_color_space=JCS_RGB;    if (IsGrayImage(image))      { #       jpeg_info.input_components=1; -       jpeg_info.in_color_space=JCS_GRAYSCALE;      }     jpeg_set_defaults(&jpeg_info);$   for (i=0; i < MAX_COMPONENTS; i++)   { +     jpeg_info.comp_info[i].h_samp_factor=1; +     jpeg_info.comp_info[i].v_samp_factor=1;    } 8   jpeg_set_quality(&jpeg_info,image_info->quality,True);!   jpeg_info.optimize_coding=True;  #if (JPEG_LIB_VERSION >= 61)"   jpeg_info.dct_method=JDCT_FLOAT;-   if (image_info->interlace != NoneInterlace) (     jpeg_simple_progression(&jpeg_info); #endif'   jpeg_start_compress(&jpeg_info,True); '   if (image->comments != (char *) NULL) :     for (i=0; i < (int) strlen(image->comments); i+=65533)P       jpeg_write_marker(&jpeg_info,JPEG_COM,(unsigned char *) image->comments+i,C         (unsigned int) Min((int) strlen(image->comments+i),65533));    /*'     Convert MIFF to JPEG raster pixels.    */4   packets=jpeg_info.input_components*image->columns;:   jpeg_pixels=(JSAMPLE *) malloc(packets*sizeof(JSAMPLE));&   if (jpeg_pixels == (JSAMPLE *) NULL)5     PrematureExit("Unable to allocate memory",image);    p=image->pixels;   q=jpeg_pixels;   x=0;%   scanline[0]=(JSAMPROW) jpeg_pixels; ;   if ((jpeg_info.data_precision > 8) && (QuantumDepth > 8))      { 4       if (jpeg_info.in_color_space == JCS_GRAYSCALE)*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           { 0             *q++=(JSAMPLE) (Intensity(*p) >> 4);             x++;$             if (x == image->columns)               { C                 (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                  q=jpeg_pixels;                 x=0;               }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         } 
       else*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           { )             *q++=(JSAMPLE) (p->red >> 4); +             *q++=(JSAMPLE) (p->green >> 4); *             *q++=(JSAMPLE) (p->blue >> 4);             x++;$             if (x == image->columns)               { C                 (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                  q=jpeg_pixels;                 x=0;               }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }      }    else2     if (jpeg_info.in_color_space == JCS_GRAYSCALE)(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         { 2           *q++=(JSAMPLE) DownScale(Intensity(*p));           x++;"           if (x == image->columns)
             { A               (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                q=jpeg_pixels;               x=0;
             } 	         }          p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       }      else(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         { +           *q++=(JSAMPLE) DownScale(p->red); -           *q++=(JSAMPLE) DownScale(p->green); ,           *q++=(JSAMPLE) DownScale(p->blue);           x++;"           if (x == image->columns)
             { A               (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                q=jpeg_pixels;               x=0;
             } 	         }          p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       } #   jpeg_finish_compress(&jpeg_info);    /*     Free memory.   */$   jpeg_destroy_compress(&jpeg_info);   free((char *) jpeg_pixels);    CloseImage(image);   return(True);  }  #else L static unsigned int WriteJPEGImage(const ImageInfo *image_info,Image *image) {    unsigned int     status;   ;   Warning("JPEG library is not available",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e L O G O I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteLOGOImage writes an image in the LOGO encoded image format. % / %  The format of the WriteLOGOImage routine is:  % . %      status=WriteLOGOImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteLOGOImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteLOGOImage(const ImageInfo *image_info,Image *image) {    unsigned int     status;   6   Warning("Cannot write LOGO images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M A P I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteMAPImage writes an image to a file as red, green, and blue 3 %  colormap bytes followed by the colormap indexes.  % . %  The format of the WriteMAPImage routine is: % - %      status=WriteMAPImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteMAPImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteMAPImage(const ImageInfo *image_info,Image *image)  {    register int     i;     register unsigned char     *q;      unsigned char      *colormap;     unsigned int     packet_size;     unsigned short
     value;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate colormap.   */"   if (image->class == DirectClass)     {        /**         Demote DirectClass to PseudoClass.       */N       QuantizeImage(image,MaxColormapSize,8,image_info->dither,RGBColorspace);       SyncImage(image);      } $   packet_size=3*(image->depth >> 3);   colormap=(unsigned char *)<     malloc(packet_size*image->colors*sizeof(unsigned char));)   if (colormap == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image);    /*     Write colormap to file.    */
   q=colormap; #   for (i=0; i < image->colors; i++)    { +     WriteQuantum(image->colormap[i].red,q); -     WriteQuantum(image->colormap[i].green,q); ,     WriteQuantum(image->colormap[i].blue,q);   } D   (void) fwrite((char *) colormap,1,(int) image->colors*packet_size,     image->file);    free((char *) colormap);   /*     Write image pixels to file.    */#   image->compression=NoCompression; %   (void) RunlengthEncodeImage(image); G   (void) fwrite((char *) image->packed_pixels,(int) image->packet_size, &     (int) image->packets,image->file);&   free((char *) image->packed_pixels);.   image->packed_pixels=(unsigned char *) NULL;   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M A T T E I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function WriteMATTEImage writes an image of matte bytes to a file.  It C %  consists of data from the matte component of the image [0..255].  % 0 %  The format of the WriteMATTEImage routine is: % / %      status=WriteMATTEImage(image_info,image)  % + %  A description of each parameter follows.  % L %    o status: Function WriteMATTEImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */M static unsigned int WriteMATTEImage(const ImageInfo *image_info,Image *image)  {    register int     i,     j;     register RunlengthPacket     *p;      if (!image->matte)?     PrematureExit("Image does not have a matte channel",image);    /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate matte pixels.   */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)4       (void) fputc(DownScale(p->index),image->file);     p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M I F F I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 5 %  Function WriteMIFFImage writes an image to a file.  % / %  The format of the WriteMIFFImage routine is:  % . %      status=WriteMIFFImage(image_info,image) % + %  A description of each parameter follows:  % K %    o status: Function WriteMIFFImage return True if the image is written. K %      False is returned if there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % - %    o image: A pointer to a Image structure.  %  %  */
 #ifdef HasPNG  #include "zlib.h"  #endif  L static unsigned int WriteMIFFImage(const ImageInfo *image_info,Image *image) {    register int     i;     unsigned long      packets;  E   if ((image->class != DirectClass) && (image->class != PseudoClass)) /     PrematureExit("Unknown image class",image);    /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image); 4   (void) strcpy((char *) image_info->magick,"MIFF");   do   {      /*       Pack image pixels.     *//     image->compression=image_info->compression; '     (void) RunlengthEncodeImage(image);      packets=image->packets; 2     if (image_info->compression == ZipCompression)       {          int            status;            unsigned char            *compressed_pixels;   
         /*2           Compress image pixels with Zip encoding.
         */:         packets=((packets*image->packet_size*110)/100)+12;+         compressed_pixels=(unsigned char *) 0           malloc(packets*sizeof(unsigned char));8         if (compressed_pixels == (unsigned char *) NULL);           PrematureExit("Unable to allocate memory",image);          status=True;
 #ifdef HasPNG H         status=compress(compressed_pixels,&packets,image->packed_pixels,-           image->packets*image->packet_size);  #endif         if (!status)           { 0             free((char *) image->packed_pixels);3             image->packed_pixels=compressed_pixels; !             image->packet_size=1;            }          else           { D             Warning("Unable to Zip compress image",image->filename);4             (void) free((char *) compressed_pixels);-             image->compression=NoCompression; #             packets=image->packets;            }        } $     if (image->class == PseudoClass)       SignatureImage(image);     /*       Write header to file.      */3     (void) fprintf(image->file,"id=ImageMagick\n"); $     if (image->class == PseudoClass)P       (void) fprintf(image->file,"class=PseudoClass  colors=%u  signature=%s\n",(         image->colors,image->signature);     else       if (image->matte) F         (void) fprintf(image->file,"class=DirectClass  matte=True\n");
       else:         (void) fprintf(image->file,"class=DirectClass\n");:     if (image->compression == RunlengthEncodedCompression)O       (void) fprintf(image->file,"compression=RunlengthEncoded  packets=%lu\n",          packets);      else/       if (image->compression == ZipCompression) M         (void) fprintf(image->file,"compression=Zip  packets=%lu\n",packets); P     (void) fprintf(image->file,"columns=%u  rows=%u  depth=%u\n",image->columns,        image->rows,image->depth);     if (image->scene != 0)<       (void) fprintf(image->file,"scene=%u\n",image->scene);     if (image->gamma != 0.0)<       (void) fprintf(image->file,"gamma=%f\n",image->gamma);(     if (image->montage != (char *) NULL)@       (void) fprintf(image->file,"montage=%s\n",image->montage);)     if (image->comments != (char *) NULL) ?       (void) fprintf(image->file,"{\n%s\n}\n",image->comments); *     (void) fprintf(image->file,"\f\n:\n");(     if (image->montage != (char *) NULL)       { 
         /*'           Write montage tile directory. 
         */.         if (image->directory != (char *) NULL)<           (void) fprintf(image->file,"%s",image->directory);'         (void) fputc('\0',image->file);        } $     if (image->class == PseudoClass)       {          register unsigned char
           *q;            unsigned char            *colormap;           unsigned int           packet_size;           unsigned short           value;  
         /*           Allocate colormap.
         */*         packet_size=3*(image->depth >> 3);"         colormap=(unsigned char *)B           malloc(packet_size*image->colors*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image);          q=colormap; )         for (i=0; i < image->colors; i++) 	         { 1           WriteQuantum(image->colormap[i].red,q); 3           WriteQuantum(image->colormap[i].green,q); 2           WriteQuantum(image->colormap[i].blue,q);	         } 
         /*!           Write colormap to file. 
         */J         (void) fwrite((char *) colormap,1,(int) image->colors*packet_size,           image->file);           free((char *) colormap);       }      /*!       Write image pixels to file.      */I     (void) fwrite((char *) image->packed_pixels,(int) image->packet_size, !       (int) packets,image->file); &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M O N O I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteMONOImage writes an image of raw bits in LSB order to a file. % / %  The format of the WriteMONOImage routine is:  % . %      status=WriteMONOImage(image_info,image) % + %  A description of each parameter follows.  % L %    o status: Function WriteMATTEImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteMONOImage(const ImageInfo *image_info,Image *image) {    int      x,     y;     register unsigned char     bit,	     byte, 
     polarity;      register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*&     Convert image to a bi-level image.   */2   if (!IsGrayImage(image) || (image->colors != 2))     { A       QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);        SyncImage(image);      } 
   polarity=0;    if (image->colors == 2) K     polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);    bit=0;	   byte=0;    x=0;   p=image->pixels;$   for (i=0; i < image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)     {        byte>>=1;        if (p->index == polarity)          byte|=0x80;        bit++;       if (bit == 8) 	         { )           (void) fputc(byte,image->file);            bit=0;           byte=0; 	         } 
       x++;       if (x == image->columns)	         {            /*)             Advance to the next scanline.            */           if (bit != 0) 6             (void) fputc(byte >> (8-bit),image->file);           bit=0;           byte=0;            x=0;        }     }      p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M P E G I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteMPEGImage writes an image in the MPEG encoded image format. % / %  The format of the WriteMPEGImage routine is:  % . %      status=WriteMPEGImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteMPEGImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteMPEGImage(const ImageInfo *image_info,Image *image) {    char     basename[MaxTextLength],     command[MaxTextLength],      filename[MaxTextLength];     Image      component_image;     MonitorHandler     handler;     register int     i;     unsigned int     number_images,
     scene,     status;   $   if (image->next == (Image *) NULL);     PrematureExit("MPEG requires multi-frame image",image);    /*     Write component images.    */   scene=image->scene; G   for (number_images=0; image->next != (Image *) NULL; number_images++)      image=image->next;   number_images++;+   while (image->previous != (Image *) NULL)      image=image->previous;   TemporaryFilename(basename);#   (void) strcpy(filename,basename);    (void) strcat(filename,"%d"); #   for (i=0; i < number_images; i++)    { 5     handler=SetMonitorHandler((MonitorHandler) NULL);      component_image=(*image); ,     component_image.previous=(Image *) NULL;(     component_image.next=(Image *) NULL;8     (void) sprintf(component_image.filename,filename,i);7     (void) WriteYUV3Image(image_info,&component_image); &     if (image->next != (Image *) NULL)       image=image->next;&     (void) SetMonitorHandler(handler);3     ProgressMonitor(SaveImageText,i,number_images);    }    /*     Write MPEG image.    */K   (void) sprintf(command,"mpeg -a %u -b %u -h %u -v %u -PF %s -s %s",scene, F     image->scene,image->columns,image->rows,basename,image->filename);    status=SystemCommand(command);   /*     Remove component files.    */#   for (i=0; i < number_images; i++)    { 8     (void) sprintf(component_image.filename,filename,i);1     (void) strcat(component_image.filename,".Y"); ,     (void) remove(component_image.filename);8     (void) sprintf(component_image.filename,filename,i);1     (void) strcat(component_image.filename,".U"); ,     (void) remove(component_image.filename);8     (void) sprintf(component_image.filename,filename,i);1     (void) strcat(component_image.filename,".V"); ,     (void) remove(component_image.filename);   }    return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M T V I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteMTVImage writes an image to a file in red, green, and blue  %  MTV rasterfile format.  % . %  The format of the WriteMTVImage routine is: % - %      status=WriteMTVImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteMTVImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteMTVImage(const ImageInfo *image_info,Image *image)  {    register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {      /*(       Convert MIFF to MTV raster pixels.     */E     (void) fprintf(image->file,"%u %u\n",image->columns,image->rows);      p=image->pixels;&     for (i=0; i < image->packets; i++)     { ,       for (j=0; j <= ((int) p->length); j++)       { 4         (void) fputc(DownScale(p->red),image->file);6         (void) fputc(DownScale(p->green),image->file);5         (void) fputc(DownScale(p->blue),image->file);        } 
       p++;       if (QuantumTick(i,image)) 8         ProgressMonitor(SaveImageText,i,image->packets);     } &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P C D I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WritePCDImage writes an image in the Photo CD encoded image 
 %  format. % . %  The format of the WritePCDImage routine is: % - %      status=WritePCDImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePCDImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WritePCDImage(const ImageInfo *image_info,Image *image)  {    unsigned int     status;   5   Warning("Cannot write PCD images",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P C L I m a g e                                                 % O %                                                                             % O %                                                                             %  %                                                                             % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WritePCLImage writes an image in the Page Control Language encoded %  image format. % . %  The format of the WritePCLImage routine is: % - %      status=WritePCLImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePCLImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  %  */K static unsigned int WritePCLImage(const ImageInfo *image_info,Image *image)  {    int      delta_x,     delta_y,
     flags,     sans_offset,     x,     y;     register int     i,     j;     register RunlengthPacket     *p;      unsigned int     density,     height,      page_height,     page_size,     page_width,      text_size,
     width;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize the printer.    */3   (void) fprintf(image->file,"\033E");  /* reset */ E   (void) fprintf(image->file,"\033&l0O");  /* portrait orientation */ =   (void) fprintf(image->file,"\033&l0E");  /* top margin 0 */    /*     Center image on PCL page.    */I   text_size=image->label == (char *) NULL ? 0 : image_info->pointsize+12;    x=0;   y=0;   width=image->columns;    height=image->rows; H   (void) XParseGeometry(PCLPageGeometry,&x,&y,&page_width,&page_height);   flags=NoValue;(   if (image_info->page != (char *) NULL)J     flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);#   if (image->page != (char *) NULL) E     flags=XParseGeometry(image->page,&x,&y,&page_width,&page_height); (   if (((page_width-(x << 1)) < width) ||2       ((page_height-(y << 1)-text_size) < height))     {        unsigned long          scale_factor;          /*)         Scale image relative to PCL page.        */6       scale_factor=UpShift(page_width-(x << 1))/width;J       if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))D         scale_factor=UpShift(page_height-(y << 1)-text_size)/height;*       width=DownShift(width*scale_factor);,       height=DownShift(height*scale_factor);     }    if ((flags & XValue) == 0)     {        /*(         Center image in the X direction.       */*       delta_x=page_width-(width+(x << 1));       if (delta_x >= 0)          x=(delta_x >> 1)+x;      }    if ((flags & YValue) == 0)     {        /*(         Center image in the X direction.       */6       delta_y=page_height-(height+(y << 1))-text_size;       if (delta_y >= 0)          y=(delta_y >> 1)+y;      }    page_size=2;2   if ((page_width == 540) && (page_height == 720))!     page_size=1;  /* executive */ 2   if ((page_width == 612) && (page_height == 792))     page_size=2;  /* letter */3   if ((page_width == 612) && (page_height == 1008))      page_size=3;  /* legal */ 3   if ((page_width == 1224) && (page_height == 792))      page_size=6;  /* ledger */2   if ((page_width == 595) && (page_height == 842))     page_size=26;  /* A4 */ 3   if ((page_width == 842) && (page_height == 1191))      page_size=27;  /* A3 */ 3   if ((page_width == 729) && (page_height == 1032))      page_size=45;  /* B5 */ 2   if ((page_width == 516) && (page_height == 729))     page_size=46;  /* B4 */ E   (void) fprintf(image->file,"\033&l%uA",page_size);  /* papersize */ E   (void) XParseGeometry(PCLDensityGeometry,&sans_offset,&sans_offset,      &density,&density); +   if (image_info->density != (char *) NULL) H     (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,       &density,&density); 1   (void) fprintf(image->file,"\033*p%dx%dY",x,y); $   if (image->label != (char *) NULL)     {        /*         Print label.       */-       (void) fprintf(image->file,"\033&k2G"); J       (void) fprintf(image->file,"\033(s1p%dv5t3b",image_info->pointsize);8       (void) fprintf(image->file,"\n%s\n",image->label);-       (void) fprintf(image->file,"\033(s0B");      } L   (void) fprintf(image->file,"\033*t%uR",density);  /* graphic resolution */   width=(density*width)/75;    height=(density*height)/75;    if (!IsGrayImage(image))     {        /*         Write PCL color image.       */L       (void) fprintf(image->file,"\033*r%us%uT",image->columns,image->rows);>       (void) fprintf(image->file,"\033*t%uh%uV",width,height);-       (void) fprintf(image->file,"\033*v6W"); :       (void) fputc('\000',image->file);  /* color model */D       (void) fputc('\003',image->file);  /* direct pixel encoding */=       (void) fputc('\000',image->file);  /* bits per index */ 6       (void) fputc('\010',image->file);  /* bits red*/8       (void) fputc('\010',image->file);  /* bits green*/8       (void) fputc('\010',image->file);  /* bits blue */C       (void) fprintf(image->file,"\033*r2A");  /* start graphics */ C       (void) fprintf(image->file,"\033*b0M");  /* no compression */ ?       (void) fprintf(image->file,"\033*b%uW",3*image->columns); 
       x=0;       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)@           (void) fprintf(image->file,"%c%c%c",DownScale(p->red),4             DownScale(p->green),DownScale(p->blue));         x++;          if (x == image->columns)           { E             (void) fprintf(image->file,"\033*b%uW",3*image->columns);              x=0;           }          p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       } @       (void) fprintf(image->file,"\033*rC");  /* end graphics */     }    else     { 
       char          geometry[MaxTextLength];         register unsigned char         bit,
         byte,          polarity;          /*#         Write PCL monochrome image.        */?       if ((width != image->columns) || (height != image->rows)) 	         {            FILE             *file;             /*             Scale image.           */           file=image->file; <           image->file=(FILE *) NULL;  /* prevents closing */8           (void) sprintf(geometry,"%ux%u",width,height);8           TransformImage(&image,(char *) NULL,geometry);           image->file=file; 	         }        if (image->colors > 2)	         { E           QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);            SyncImage(image); 	         }        p=image->pixels;       polarity=0;        if (image->colors == 2)          polarity= H           Intensity(image->colormap[0]) > Intensity(image->colormap[1]);       bit=0;
       byte=0; 
       x=0;
       y=0;L       (void) fprintf(image->file,"\033*r%us%uT",image->columns,image->rows);C       (void) fprintf(image->file,"\033*r1A");  /* start graphics */ C       (void) fprintf(image->file,"\033*b0M");  /* no compression */ C       (void) fprintf(image->file,"\033*b%uW",(image->columns+7)/8); (       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            byte<<=1; #           if (p->index == polarity)              byte|=0x01;            bit++;           if (bit == 8) 
             { -               (void) fputc(byte,image->file);                bit=0;               byte=0; 
             }            x++;"           if (x == image->columns)
             {                /*-                 Advance to the next scanline.                */               if (bit != 0) ;                 (void) fputc(byte  << (8-bit),image->file);                bit=0;               byte=0;                x=0;               y++;"               if (y < image->rows)M                 (void) fprintf(image->file,"\033*b%uW",(image->columns+7)/8);             }	         }          p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       } @       (void) fprintf(image->file,"\033*rB");  /* end graphics */     } )   (void) fprintf(image->file,"\033&l0H"); 3   (void) fprintf(image->file,"\033E");  /* reset */    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P C X I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function WritePCXImage writes an image in the ZSoft IBM PC Paintbrush file 
 %  format. % . %  The format of the WritePCXImage routine is: % - %      status=WritePCXImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePCXImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WritePCXImage(const ImageInfo *image_info,Image *image)  {    typedef struct _PCXHeader    {      unsigned char        identifier,        version,       encoding,        bits_per_pixel;   
     short int        left, 
       top,       right,
       bottom,        horizontal_resolution,       vertical_resolution;       unsigned char        reserved, 
       planes;   
     short int        bytes_per_line,        palette_info;        unsigned char        colormap_signature;    } PCXHeader;     int      id;      PCXHeader      pcx_header;      register int     i,     j,     x,     y;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char 
     count,     packet,      *pcx_colormap,     *pcx_pixels,
     previous;      unsigned int     packets;     unsigned long      *page_table;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image); $   page_table=(unsigned long *) NULL;,   if (strcmp(image_info->magick,"DCX") == 0)     {        /*!         Write the DCX page table.        */0       LSBFirstWriteLong(0x3ade68b1,image->file);F       page_table=(unsigned long *) malloc(1024*sizeof(unsigned long));/       if (page_table == (unsigned long *) NULL) 9         PrematureExit("Unable to allocate memory",image); !       for (id=0; id < 1024; id++) +         LSBFirstWriteLong(0x0,image->file);      }    for (id=0; id < 1024; id++)    { -     if (page_table != (unsigned long *) NULL) (       page_table[id]=ftell(image->file);     /*(       Initialize PCX raster file header.     */     pcx_header.identifier=0x0a;      pcx_header.version=5;      pcx_header.encoding=1;      pcx_header.bits_per_pixel=8;3     if (IsGrayImage(image) && (image->colors == 2)) "       pcx_header.bits_per_pixel=1;     pcx_header.left=0;     pcx_header.top=0; &     pcx_header.right=image->columns-1;$     pcx_header.bottom=image->rows-1;4     pcx_header.horizontal_resolution=image->columns;/     pcx_header.vertical_resolution=image->rows;      pcx_header.reserved=0;     pcx_header.planes=1;$     if (image->class == DirectClass)       {          pcx_header.planes=3;         if (image->matte)            pcx_header.planes++;       } M     pcx_header.bytes_per_line=(image->columns*pcx_header.bits_per_pixel+7)/8;      pcx_header.palette_info=1;'     pcx_header.colormap_signature=0x0c;      /*       Write PCX header.      */:     (void) fwrite(&pcx_header.identifier,1,1,image->file);7     (void) fwrite(&pcx_header.version,1,1,image->file); 8     (void) fwrite(&pcx_header.encoding,1,1,image->file);>     (void) fwrite(&pcx_header.bits_per_pixel,1,1,image->file);C     LSBFirstWriteShort((unsigned int) pcx_header.left,image->file); B     LSBFirstWriteShort((unsigned int) pcx_header.top,image->file);D     LSBFirstWriteShort((unsigned int) pcx_header.right,image->file);E     LSBFirstWriteShort((unsigned int) pcx_header.bottom,image->file); G     LSBFirstWriteShort((unsigned int) pcx_header.horizontal_resolution,        image->file); E     LSBFirstWriteShort((unsigned int) pcx_header.vertical_resolution,        image->file);      /*       Dump colormap to file.     */G     pcx_colormap=(unsigned char *) malloc(3*256*sizeof(unsigned char)); /     if (pcx_colormap == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      for (i=0; i < (3*256); i++)        pcx_colormap[i]=0;     q=pcx_colormap; @     if ((image->class == PseudoClass) && (image->colors <= 256))'       for (i=0; i < image->colors; i++)        { /         *q++=DownScale(image->colormap[i].red); 1         *q++=DownScale(image->colormap[i].green); 0         *q++=DownScale(image->colormap[i].blue);       } :     (void) fwrite((char *) pcx_colormap,3,16,image->file);8     (void) fwrite(&pcx_header.reserved,1,1,image->file);6     (void) fwrite(&pcx_header.planes,1,1,image->file);M     LSBFirstWriteShort((unsigned int) pcx_header.bytes_per_line,image->file); K     LSBFirstWriteShort((unsigned int) pcx_header.palette_info,image->file);      for (i=0; i < 58; i++)*       (void) fwrite("\0",1,1,image->file);D     packets=image->rows*pcx_header.bytes_per_line*pcx_header.planes;G     pcx_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char)); -     if (pcx_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      x=0;     y=0;     p=image->pixels;     q=pcx_pixels; ?     if ((image->class == DirectClass) || (image->colors > 256))        { 
         /*9           Convert DirectClass image to PCX raster pixels. 
         */$         if (!UncompressImage(image))           return(False);'         for (y=0; y < image->rows; y++) 	         { G           q=pcx_pixels+(y*pcx_header.bytes_per_line*pcx_header.planes); 5           for (i=0; i < (int) pcx_header.planes; i++)            { -             p=image->pixels+y*image->columns; 9             for (x=0; x < pcx_header.bytes_per_line; x++) 
             {                switch (i)               {                  case 0:                  { )                   *q++=DownScale(p->red);                    break;                 }                  case 1:                  { +                   *q++=DownScale(p->green);                    break;                 }                  case 2:                  { *                   *q++=DownScale(p->blue);                   break;                 }                  case 3:                  default:                 { +                   *q++=DownScale(p->index);                    break;                 }                }                p++;
             }            } 7           ProgressMonitor(SaveImageText,y,image->rows); 	         }        }      else       { 
         /*9           Convert PseudoClass image to PCX raster pixels. 
         */*         if (pcx_header.bits_per_pixel > 1),           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)
             {                *q++=p->index;               x++;&               if (x == image->columns)                 {                    x=0;                   y++;;                   q=pcx_pixels+y*pcx_header.bytes_per_line;                  } 
             }              p++;%             if (QuantumTick(i,image)) >               ProgressMonitor(SaveImageText,i,image->packets);           }          else           { "             register unsigned char               bit,               byte,                polarity;                /*B               Convert PseudoClass image to a PCX monochrome image.             */             polarity=0; #             if (image->colors == 2) 6               polarity=Intensity(image->colormap[0]) <.                 Intensity(image->colormap[1]);             bit=0;             byte=0; .             for (i=0; i < image->packets; i++)
             { 2               for (j=0; j <= (int) p->length; j++)               {                  byte<<=1; )                 if (p->index == polarity)                    byte|=0x01;                  bit++;                 if (bit == 8)                    {                      *q++=byte;                     bit=0;                     byte=0;                    }                  x++;(                 if (x == image->columns)                   {                      /*3                       Advance to the next scanline.                      */!                     if (bit != 0) +                       *q++=byte << (8-bit);                      bit=0;                     byte=0;                      x=0;                     y++;=                     q=pcx_pixels+y*pcx_header.bytes_per_line;                    }                }                p++;'               if (QuantumTick(i,image)) @                 ProgressMonitor(SaveImageText,i,image->packets);
             }            }        }      /*#       Runlength-encoded PCX pixels.      */#     for (y=0; y < image->rows; y++)      { C       q=pcx_pixels+(y*pcx_header.bytes_per_line*pcx_header.planes); 1       for (i=0; i < (int) pcx_header.planes; i++)        {          previous=(*q++);         count=1;9         for (x=0; x < (pcx_header.bytes_per_line-1); x++) 	         {            packet=(*q++);3           if ((packet == previous) && (count < 63)) 
             {                count++;               continue; 
             } 9           if ((count > 1) || ((previous & 0xc0) == 0xc0)) 
             {                count|=0xc0;4               (void) fwrite(&count,1,1,image->file);
             } 3           (void) fwrite(&previous,1,1,image->file);            previous=packet;           count=1;	         } 7         if ((count > 1) || ((previous & 0xc0) == 0xc0))            {              count|=0xc0;2             (void) fwrite(&count,1,1,image->file);           } 1         (void) fwrite(&previous,1,1,image->file); 5         ProgressMonitor(SaveImageText,y,image->rows);        }      }      if (image->colors > 16)        { F         (void) fwrite(&pcx_header.colormap_signature,1,1,image->file);?         (void) fwrite((char *) pcx_colormap,3,256,image->file);        }      free((char *) pcx_pixels);      free((char *) pcx_colormap);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } +   if (page_table != (unsigned long *) NULL)      {        /*!         Write the DCX page table.        */       page_table[id+1]=0; $       (void) fseek(image->file,0,0);0       LSBFirstWriteLong(0x3ade68b1,image->file);       for (i=0; i <= id; i++) 5         LSBFirstWriteLong(page_table[i],image->file); '       (void) free((char *) page_table);      }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P D F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function WritePDFImage writes an image in the Portable Document image
 %  format. % . %  The format of the WritePDFImage routine is: % - %      status=WritePDFImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePDFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WritePDFImage(const ImageInfo *image_info,Image *image)  { + #define DefaultThumbnailGeometry  "106x106"  #define ObjectsPerImage  12      char     date[MaxTextLength];     float      dx_resolution,     dy_resolution,     x_resolution,      y_resolution;      int 
     count,     delta_x,     delta_y,
     flags,     x,     y;     Image      encode_image,      *tile_image;     register RunlengthPacket     *p;      register unsigned char     *q;      register int     i,     j;     time_t
     timer;     unsigned char      *pixels;     unsigned int     height,      length,      info_id,     number_packets,      object, 
     pages_id,      page_height,     page_width,      root_id,     text_size,
     *xref,
     width;     /*     Open output image file.    */"   OpenImage(image_info,image,"w");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image); -   if ((image->file == stdout) || image->pipe)      {        /*8         Write standard output or pipe to temporary file.       */       encode_image=(*image);)       TemporaryFilename(image->filename);        image->temporary=True;&       OpenImage(image_info,image,"w");'       if (image->file == (FILE *) NULL) 3         PrematureExit("Unable to open file",image);      }    /*     Allocate X ref memory.   */:   xref=(unsigned int *) malloc(2048*sizeof(unsigned int));$   if (xref == (unsigned int *) NULL)     { 9       Warning("Memory allocation error",image->filename);        return(False);     }    /*     Write Info object.   */   object=0; -   (void) fprintf(image->file,"%%PDF-1.1 \n"); $   xref[object++]=ftell(image->file);   info_id=object; 2   (void) fprintf(image->file,"%u 0 obj\n",object);%   (void) fprintf(image->file,"<<\n");    timer=time((time_t *) NULL);   (void) localtime(&timer); $   (void) strcpy(date,ctime(&timer));   date[strlen(date)-1]='\0';:   (void) fprintf(image->file,"/CreationDate (%s)\n",date);8   (void) fprintf(image->file,"/Producer ImageMagick\n");%   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");    /*     Write Catalog object.    */$   xref[object++]=ftell(image->file);   root_id=object; 2   (void) fprintf(image->file,"%u 0 obj\n",object);%   (void) fprintf(image->file,"<<\n"); 1   (void) fprintf(image->file,"/Type /Catalog\n"); 9   (void) fprintf(image->file,"/Pages %u 0 R\n",object+1); %   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");    /*     Write Pages object.    */$   xref[object++]=ftell(image->file);   pages_id=object;2   (void) fprintf(image->file,"%u 0 obj\n",object);%   (void) fprintf(image->file,"<<\n"); /   (void) fprintf(image->file,"/Type /Pages\n"); 9   (void) fprintf(image->file,"/Kids [ %u 0 R ",object+1); #   count=pages_id+ObjectsPerImage+1;    if (image_info->adjoin)      {        Image          *kid_image;          /*!         Predict page object id's.        */       kid_image=image;H       for ( ; kid_image->next != (Image *) NULL; count+=ObjectsPerImage)       { 4         (void) fprintf(image->file,"%d 0 R ",count);"         kid_image=kid_image->next;       }        xref=(unsigned int *) A         realloc((char *) xref,(count+2048)*sizeof(unsigned int)); (       if (xref == (unsigned int *) NULL)	         { =           Warning("Memory allocation error",image->filename);            return(False);	         }      } $   (void) fprintf(image->file,"]\n");M   (void) fprintf(image->file,"/Count %u\n",(count-pages_id)/ObjectsPerImage); %   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");    do   {      /*4       Scale image to size of Portable Document page.     */K     text_size=image->label == (char *) NULL ? 0 : image_info->pointsize+12;      x=0;     y=0;     width=image->columns;      height=image->rows;      /*-       Center image on Portable Document page.      */I     (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height);      flags=NoValue;*     if (image_info->page != (char *) NULL)L       flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);%     if (image->page != (char *) NULL) G       flags=XParseGeometry(image->page,&x,&y,&page_width,&page_height); *     if (((page_width-(x << 1)) < width) ||4         ((page_height-(y << 1)-text_size) < height))       {          unsigned long            scale_factor;   
         /*9           Scale image relative to Portable Document page. 
         */8         scale_factor=UpShift(page_width-(x << 1))/width;L         if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))F           scale_factor=UpShift(page_height-(y << 1)-text_size)/height;,         width=DownShift(width*scale_factor);.         height=DownShift(height*scale_factor);       }      if ((flags & XValue) == 0)       { 
         /**           Center image in the X direction.
         */,         delta_x=page_width-(width+(x << 1));         if (delta_x >= 0)            x=(delta_x >> 1)+x;        }      if ((flags & YValue) == 0)       { 
         /**           Center image in the X direction.
         */8         delta_y=page_height-(height+(y << 1))-text_size;         if (delta_y >= 0)            y=(delta_y >> 1)+y;        }      /*&       Scale relative to dots-per-inch.     */     dx_resolution=72.0;      dy_resolution=72.0;      x_resolution=72.0;H     count=sscanf(PSDensityGeometry,"%fx%f",&x_resolution,&y_resolution);-     if (image_info->density != (char *) NULL) L       count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);     if (count != 2)         y_resolution=x_resolution;D     width=(unsigned int) (((width*dx_resolution)/x_resolution)+0.5);F     height=(unsigned int) (((height*dy_resolution)/y_resolution)+0.5);     /*       Write Page object.     */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);'     (void) fprintf(image->file,"<<\n"); 0     (void) fprintf(image->file,"/Type /Page\n");<     (void) fprintf(image->file,"/Parent %u 0 R\n",pages_id);2     (void) fprintf(image->file,"/Resources <<\n");H     (void) fprintf(image->file,"/Font << /F%u %u 0 R >>\n",image->scene,       object+4);L     (void) fprintf(image->file,"/XObject << /Im%u %u 0 R >>\n",image->scene,       object+5);@     (void) fprintf(image->file,"/ProcSet %u 0 R >>\n",object+3);;     (void) fprintf(image->file,"/MediaBox [ 0 0 %u %u ]\n",        page_width,page_height);>     (void) fprintf(image->file,"/Contents %u 0 R\n",object+1);4     if (!IsGrayImage(image) || (image->colors != 2))=       (void) fprintf(image->file,"/Thumb %u 0 R\n",object+8); '     (void) fprintf(image->file,">>\n"); +     (void) fprintf(image->file,"endobj\n");      /*       Write Contents object.     */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);'     (void) fprintf(image->file,"<<\n"); <     (void) fprintf(image->file,"/Length %u 0 R\n",object+1);'     (void) fprintf(image->file,">>\n"); +     (void) fprintf(image->file,"stream\n");      length=ftell(image->file);&     (void) fprintf(image->file,"q\n");'     (void) fprintf(image->file,"BT\n"); ;     (void) fprintf(image->file,"/F%u %d Tf\n",image->scene,        image_info->pointsize); ;     (void) fprintf(image->file,"%d %u Td\n",x,y+height+12); &     if (image->label == (char *) NULL),       (void) fprintf(image->file,"() Tj\n");     else;       (void) fprintf(image->file,"(%s) Tj\n",image->label); '     (void) fprintf(image->file,"ET\n"); H     (void) fprintf(image->file,"%u 0 0 %u %d %d cm\n",width,height,x,y);:     (void) fprintf(image->file,"/Im%u Do\n",image->scene);&     (void) fprintf(image->file,"Q\n");%     length=ftell(image->file)-length; .     (void) fprintf(image->file,"endstream\n");+     (void) fprintf(image->file,"endobj\n");      /*       Write Length object.     */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);.     (void) fprintf(image->file,"%u\n",length);+     (void) fprintf(image->file,"endobj\n");      /*       Write Procset object.      */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);5     if (!IsPseudoClass(image) && !IsGrayImage(image)) 9       (void) fprintf(image->file,"[ /PDF /Text /ImageC");      else5       if (IsGrayImage(image) && (image->colors == 2)) ;         (void) fprintf(image->file,"[ /PDF /Text /ImageB"); 
       else;         (void) fprintf(image->file,"[ /PDF /Text /ImageI"); '     (void) fprintf(image->file," ]\n"); +     (void) fprintf(image->file,"endobj\n");      /*       Write Font object.     */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);'     (void) fprintf(image->file,"<<\n"); 0     (void) fprintf(image->file,"/Type /Font\n");4     (void) fprintf(image->file,"/Subtype /Type1\n");<     (void) fprintf(image->file,"/Name /F%u\n",image->scene);9     (void) fprintf(image->file,"/BaseFont /Helvetica\n"); @     (void) fprintf(image->file,"/Encoding /MacRomanEncoding\n");'     (void) fprintf(image->file,">>\n"); +     (void) fprintf(image->file,"endobj\n");      /*       Write XObject object.      */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);'     (void) fprintf(image->file,"<<\n"); 3     (void) fprintf(image->file,"/Type /XObject\n"); 4     (void) fprintf(image->file,"/Subtype /Image\n");=     (void) fprintf(image->file,"/Name /Im%u\n",image->scene); /     image->compression=image_info->compression; ,     if (image->compression == NoCompression)=       (void) fprintf(image->file,"/Filter /ASCII85Decode\n");      else!       (void) fprintf(image->file, 3         "/Filter [ /ASCII85Decode /LZWDecode ]\n"); =     (void) fprintf(image->file,"/Width %u\n",image->columns); ;     (void) fprintf(image->file,"/Height %u\n",image->rows); @     (void) fprintf(image->file,"/ColorSpace %u 0 R\n",object+2);8     (void) fprintf(image->file,"/BitsPerComponent %d\n",:       IsGrayImage(image) && (image->colors == 2) ? 1 : 8);<     (void) fprintf(image->file,"/Length %u 0 R\n",object+1);'     (void) fprintf(image->file,">>\n"); +     (void) fprintf(image->file,"stream\n");      length=ftell(image->file);     p=image->pixels;5     if (!IsPseudoClass(image) && !IsGrayImage(image)) !       switch (image->compression)        { )         case RunlengthEncodedCompression:          default:	         {            /*!             Allocate pixel array.            */6           number_packets=3*image->columns*image->rows;"           pixels=(unsigned char *)9             malloc(number_packets*sizeof(unsigned char)); /           if (pixels == (unsigned char *) NULL) =             PrematureExit("Unable to allocate memory",image);            /**             Dump runlength encoded pixels.           */           q=pixels; ,           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)
             {%<               if (image->matte && (p->index == Transparent))                 { )                   *q++=DownScale(MaxRGB); )                   *q++=DownScale(MaxRGB); )                   *q++=DownScale(MaxRGB);                  }                else                 {C)                   *q++=DownScale(p->red); +                   *q++=DownScale(p->green); *                   *q++=DownScale(p->blue);                 } 
             }O             p++;%             if (QuantumTick(i,image)) >               ProgressMonitor(SaveImageText,i,image->packets);           } C           (void) LZWEncodeImage(image->file,pixels,number_packets);             free((char *) pixels);           break;	         }          case NoCompression: 	         {            /*2             Dump uncompressed DirectColor packets.           */           Ascii85Initialize();,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             { <               if (image->matte && (p->index == Transparent))                 { ?                   Ascii85Encode(DownScale(MaxRGB),image->file); ?                   Ascii85Encode(DownScale(MaxRGB),image->file); ?                   Ascii85Encode(DownScale(MaxRGB),image->file);                  }                else                 {J?                   Ascii85Encode(DownScale(p->red),image->file); A                   Ascii85Encode(DownScale(p->green),image->file); @                   Ascii85Encode(DownScale(p->blue),image->file);                 }p
             }I             p++;%             if (QuantumTick(i,image)) >               ProgressMonitor(SaveImageText,i,image->packets);           } $           Ascii85Flush(image->file);           break;	         }        }a     else5       if (IsGrayImage(image) && (image->colors == 2))w	         {             register unsigned char             bit,             byte,              polarity;              polarity=nJ             Intensity(image->colormap[0]) < Intensity(image->colormap[1]);           bit=0;           byte=0;            x=0;%           switch (image->compression)            {r-             case RunlengthEncodedCompression:b             default:
             {c               /*%                 Allocate pixel array.u               */C               number_packets=((image->columns+7) >> 3)*image->rows;h&               pixels=(unsigned char *)=                 malloc(number_packets*sizeof(unsigned char)); 3               if (pixels == (unsigned char *) NULL) A                 PrematureExit("Unable to allocate memory",image);d               /*.                 Dump Runlength encoded pixels.               */               q=pixels;p0               for (i=0; i < image->packets; i++)               {v4                 for (j=0; j <= (int) p->length; j++)                 {n                   byte<<=1;u+                   if (p->index == polarity)s                     byte|=0x01;f                   bit++;                   if (bit == 8)n                     {h                        *q++=byte;                       bit=0;                       byte=0;h                     }                    x++;*                   if (x == image->columns)                     {%                       /*5                         Advance to the next scanline.t                       */#                       if (bit != 0)t-                         *q++=byte << (8-bit);                        bit=0;                       byte=0;u                       x=0;                       y++;                    }                 }                  p++;)                 if (QuantumTick(i,image))mB                   ProgressMonitor(SaveImageText,i,image->packets);               }cG               (void) LZWEncodeImage(image->file,pixels,number_packets);m$               free((char *) pixels);               break;
             }*             case NoCompression:%
             {%               /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();0               for (i=0; i < image->packets; i++)               { 4                 for (j=0; j <= (int) p->length; j++)                 {                    byte<<=1; +                   if (p->index == polarity)                      byte|=0x01;                    bit++;                   if (bit == 8)                      { 6                       Ascii85Encode(byte,image->file);                       bit=0;                       byte=0;                      }                    x++;*                   if (x == image->columns)                     {                        /*5                         Advance to the next scanline.                        */#                       if (bit != 0)sC                         Ascii85Encode(byte << (8-bit),image->file);p                       bit=0;                       byte=0;                        x=0;                       y++;                    }                 }f                 p++;)                 if (QuantumTick(i,image))SB                   ProgressMonitor(SaveImageText,i,image->packets);               }g(               Ascii85Flush(image->file);               break;
             }a           } 	         } 
       else	         {H           /*/             Dump number of colors and colormap.a           */%           switch (image->compression)i           { -             case RunlengthEncodedCompression:              default:
             {                /*%                 Allocate pixel array.(               */8               number_packets=image->columns*image->rows;&               pixels=(unsigned char *)=                 malloc(number_packets*sizeof(unsigned char));h3               if (pixels == (unsigned char *) NULL)dA                 PrematureExit("Unable to allocate memory",image);0               /*.                 Dump Runlength encoded pixels.               */               q=pixels;>0               for (i=0; i < image->packets; i++)               {a4                 for (j=0; j <= (int) p->length; j++)0                   *q++=(unsigned char) p->index;                 p++;)                 if (QuantumTick(i,image))cB                   ProgressMonitor(SaveImageText,i,image->packets);               }aG               (void) LZWEncodeImage(image->file,pixels,number_packets);%$               free((char *) pixels);               break;
             }              case NoCompression: 
             {                /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();0               for (i=0; i < image->packets; i++)               { 6                 for (j=0; j <= ((int) p->length); j++)F                   Ascii85Encode((unsigned char) p->index,image->file);                 p++;)                 if (QuantumTick(i,image)) B                   ProgressMonitor(SaveImageText,i,image->packets);               } (               Ascii85Flush(image->file);               break;
             }%           }%	         } %     length=ftell(image->file)-length;m0     (void) fprintf(image->file,"\nendstream\n");+     (void) fprintf(image->file,"endobj\n");a     /*       Write Length object.     */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);.     (void) fprintf(image->file,"%u\n",length);+     (void) fprintf(image->file,"endobj\n");      /*       Write Colorspace object.     */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);5     if (!IsPseudoClass(image) && !IsGrayImage(image)) 1       (void) fprintf(image->file,"/DeviceRGB\n");I     else5       if (IsGrayImage(image) && (image->colors == 2)) 4         (void) fprintf(image->file,"/DeviceGray\n");
       elseI         (void) fprintf(image->file,"[ /Indexed /DeviceRGB %u %u 0 R ]\n", $           image->colors-1,object+3);+     (void) fprintf(image->file,"endobj\n");;3     if (IsGrayImage(image) && (image->colors == 2))g       {          xref[object++]=0;i         xref[object++]=0;,       }o     else       { 
         /*           Write Thumb object.r
         */         image->orphan=True; D         ParseImageGeometry(DefaultThumbnailGeometry,&width,&height);(         if (image->class == PseudoClass)5           tile_image=SampleImage(image,width,height);y         elseB           tile_image=ZoomImage(image,width,height,MitchellFilter);         image->orphan=False;)         if (tile_image == (Image *) NULL)t;           PrematureExit("Unable to allocate memory",image); *         xref[object++]=ftell(image->file);8         (void) fprintf(image->file,"%u 0 obj\n",object);+         (void) fprintf(image->file,"<<\n"); 0         if (image->compression == NoCompression)A           (void) fprintf(image->file,"/Filter /ASCII85Decode\n");c         else%           (void) fprintf(image->file, 7             "/Filter [ /ASCII85Decode /LZWDecode ]\n"); F         (void) fprintf(image->file,"/Width %u\n",tile_image->columns);D         (void) fprintf(image->file,"/Height %u\n",tile_image->rows);D         (void) fprintf(image->file,"/ColorSpace %u 0 R\n",object-1);<         (void) fprintf(image->file,"/BitsPerComponent %d\n",H           IsGrayImage(tile_image) && (tile_image->colors == 2) ? 1 : 8);@         (void) fprintf(image->file,"/Length %u 0 R\n",object+1);+         (void) fprintf(image->file,">>\n");d/         (void) fprintf(image->file,"stream\n");r"         length=ftell(image->file);         p=tile_image->pixels; '         if (!IsPseudoClass(tile_image))r*           switch (tile_image->compression)           {e-             case RunlengthEncodedCompression:=             default:
             {r               /*%                 Allocate pixel array._               */D               number_packets=3*tile_image->columns*tile_image->rows;&               pixels=(unsigned char *)=                 malloc(number_packets*sizeof(unsigned char));n3               if (pixels == (unsigned char *) NULL)U                 {r+                   DestroyImage(tile_image); C                   PrematureExit("Unable to allocate memory",image);                  }                /*.                 Dump runlength encoded pixels.               */               q=pixels;*5               for (i=0; i < tile_image->packets; i++)m               { 4                 for (j=0; j <= (int) p->length; j++)                 {lE                   if (tile_image->matte && (p->index == Transparent))[                     {c-                       *q++=DownScale(MaxRGB); -                       *q++=DownScale(MaxRGB); -                       *q++=DownScale(MaxRGB);                      }=                   else                     { -                       *q++=DownScale(p->red);i/                       *q++=DownScale(p->green);+.                       *q++=DownScale(p->blue);                     }b                 }                  p++;               } G               (void) LZWEncodeImage(image->file,pixels,number_packets); $               free((char *) pixels);               break;
             }n             case NoCompression: 
             {i               /*6                 Dump uncompressed DirectColor packets.               */"               Ascii85Initialize();5               for (i=0; i < tile_image->packets; i++)p               { 6                 for (j=0; j <= ((int) p->length); j++)                 { E                   if (tile_image->matte && (p->index == Transparent))                      { C                       Ascii85Encode(DownScale(MaxRGB),image->file);sC                       Ascii85Encode(DownScale(MaxRGB),image->file);iC                       Ascii85Encode(DownScale(MaxRGB),image->file);-                     }t                   else                     {iC                       Ascii85Encode(DownScale(p->red),image->file);sE                       Ascii85Encode(DownScale(p->green),image->file); D                       Ascii85Encode(DownScale(p->blue),image->file);                     }                  }                  p++;               } (               Ascii85Flush(image->file);               break;
             }y           }n         elseC           if (IsGrayImage(tile_image) && (tile_image->colors == 2))g
             { $               register unsigned char                 bit,                 byte,                  polarity;   ;               polarity=Intensity(tile_image->colormap[0]) < 3                 Intensity(tile_image->colormap[1]);                bit=0;               byte=0;i               x=0;.               switch (tile_image->compression)               {+1                 case RunlengthEncodedCompression:e                 default:                 {                    /*)                     Allocate pixel array.                    */!                   number_packets= D                     ((tile_image->columns+7) >> 3)*tile_image->rows;*                   pixels=(unsigned char *)A                     malloc(number_packets*sizeof(unsigned char));e7                   if (pixels == (unsigned char *) NULL)                      { /                       DestroyImage(tile_image); G                       PrematureExit("Unable to allocate memory",image);                      }                    /*2                     Dump Runlength encoded pixels.                   */                   q=pixels;s9                   for (i=0; i < tile_image->packets; i++)a                   {l8                     for (j=0; j <= (int) p->length; j++)                     {*                       byte<<=1; /                       if (p->index == polarity)N#                         byte|=0x01;m                       bit++;#                       if (bit == 8)                          { $                           *q++=byte;                            bit=0;!                           byte=0;s                         }p                       x++;3                       if (x == tile_image->columns)                          {)                           /*9                             Advance to the next scanline.                            */'                           if (bit != 0)r1                             *q++=byte << (8-bit);                             bit=0;!                           byte=0;r                           x=0;                           y++;                        }                     }t                     p++;                   }FK                   (void) LZWEncodeImage(image->file,pixels,number_packets);a(                   free((char *) pixels);                   break;                 };#                 case NoCompression:a                 {)                   /*:                     Dump uncompressed PseudoColor packets.                   */&                   Ascii85Initialize();9                   for (i=0; i < tile_image->packets; i++)(                   {o8                     for (j=0; j <= (int) p->length; j++)                     {i                       byte<<=1;a/                       if (p->index == polarity).#                         byte|=0x01;n                       bit++;#                       if (bit == 8)o                         { :                           Ascii85Encode(byte,image->file);                            bit=0;!                           byte=0;p                         }m                       x++;3                       if (x == tile_image->columns);                         {i                           /*9                             Advance to the next scanline.                            */'                           if (bit != 0);G                             Ascii85Encode(byte << (8-bit),image->file);+                            bit=0;!                           byte=0;c                           x=0;                           y++;                        }                     }                      p++;                   }_,                   Ascii85Flush(image->file);                   break;                 }x               }L
             };           else
             {f               /*3                 Dump number of colors and colormap.I               */.               switch (tile_image->compression)               {%1                 case RunlengthEncodedCompression:                  default:                 {                    /*)                     Allocate pixel array.                    */F                   number_packets=tile_image->columns*tile_image->rows;*                   pixels=(unsigned char *)A                     malloc(number_packets*sizeof(unsigned char)); 7                   if (pixels == (unsigned char *) NULL)                      { /                       DestroyImage(tile_image); G                       PrematureExit("Unable to allocate memory",image);                      }                    /*2                     Dump Runlength encoded pixels.                   */                   q=pixels;a9                   for (i=0; i < tile_image->packets; i++)a                   {o8                     for (j=0; j <= (int) p->length; j++)4                       *q++=(unsigned char) p->index;                     p++;                   }sK                   (void) LZWEncodeImage(image->file,pixels,number_packets);i(                   free((char *) pixels);                   break;                 } #                 case NoCompression:e                 {p                   /*:                     Dump uncompressed PseudoColor packets.                   */&                   Ascii85Initialize();9                   for (i=0; i < tile_image->packets; i++)e                   {c:                     for (j=0; j <= ((int) p->length); j++)J                       Ascii85Encode((unsigned char) p->index,image->file);                     p++;                   } ,                   Ascii85Flush(image->file);                   break;                 }                }U
             }i!         DestroyImage(tile_image);F)         length=ftell(image->file)-length;r4         (void) fprintf(image->file,"\nendstream\n");/         (void) fprintf(image->file,"endobj\n");s
         /*           Write Length object.
         */*         xref[object++]=ftell(image->file);8         (void) fprintf(image->file,"%u 0 obj\n",object);2         (void) fprintf(image->file,"%u\n",length);/         (void) fprintf(image->file,"endobj\n");*       } (     if ((image->class == DirectClass) ||7         ((IsGrayImage(image) && (image->colors == 2))))        {c         xref[object++]=0;          xref[object++]=0;l       }+     else       { 
         /*            Write Colormap object.
         */*         xref[object++]=ftell(image->file);8         (void) fprintf(image->file,"%u 0 obj\n",object);+         (void) fprintf(image->file,"<<\n");b@         (void) fprintf(image->file,"/Filter /ASCII85Decode \n");@         (void) fprintf(image->file,"/Length %u 0 R\n",object+1);+         (void) fprintf(image->file,">>\n"); /         (void) fprintf(image->file,"stream\n");-"         length=ftell(image->file);         Ascii85Initialize();)         for (i=0; i < image->colors; i++) 	         { G           Ascii85Encode(DownScale(image->colormap[i].red),image->file);,I           Ascii85Encode(DownScale(image->colormap[i].green),image->file); H           Ascii85Encode(DownScale(image->colormap[i].blue),image->file);	         }i"         Ascii85Flush(image->file);)         length=ftell(image->file)-length;e4         (void) fprintf(image->file,"\nendstream\n");/         (void) fprintf(image->file,"endobj\n");x
         /*           Write Length object.
         */*         xref[object++]=ftell(image->file);8         (void) fprintf(image->file,"%u 0 obj\n",object);2         (void) fprintf(image->file,"%u\n",length);/         (void) fprintf(image->file,"endobj\n");a       } &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    /*     Write Xref object.   */'   length=ftell(image->file)-xref[0]+10;m'   (void) fprintf(image->file,"xref\n"); 0   (void) fprintf(image->file,"0 %u\n",object+1);6   (void) fprintf(image->file,"0000000000 65535 f \n");   for (i=0; i < object; i++);     (void) fprintf(image->file,"%010u 00000 n \n",xref[i]);<*   (void) fprintf(image->file,"trailer\n");%   (void) fprintf(image->file,"<<\n");g4   (void) fprintf(image->file,"/Size %u\n",object+1);7   (void) fprintf(image->file,"/Info %u 0 R\n",info_id); 7   (void) fprintf(image->file,"/Root %u 0 R\n",root_id);n%   (void) fprintf(image->file,">>\n");R,   (void) fprintf(image->file,"startxref\n");,   (void) fprintf(image->file,"%u\n",length);*   (void) fprintf(image->file,"%%%%EOF\n");   free((char *) xref);   CloseImage(image);   if (image->temporary)Q     {i
       FILE         *file;  	       intk
         c;         /*7         Copy temporary file to standard output or pipe.        */1       file=fopen(image->filename,ReadBinaryType);         if (file == (FILE *) NULL)3         PrematureExit("Unable to open file",image);b       c=fgetc(file);       while (c != EOF)       {l)         (void) putc(c,encode_image.file);          c=fgetc(file);       }        (void) fclose(file);%       (void) remove(image->filename);n        CloseImage(&encode_image);     }    return(True);e }o o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             %KO %                                                                             %)O %                                                                             % O %   W r i t e P I C T I m a g e                                               %-O %                                                                             %cO %                                                                             % O %                                                                             %+O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l % K %  Function WritePICTImage writes an image to a file in the Apple Macintoshi %  QuickDraw/PICT image format.  % / %  The format of the WritePICTImage routine is:R %p. %      status=WritePICTImage(image_info,image) % + %  A description of each parameter follows.) % K %    o status: Function WritePICTImage return True if the image is written.eK %      False is returned is there is a memory shortage or if the image file; %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.m %-. %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WritePICTImage(const ImageInfo *image_info,Image *image) {R #define MaxCount  128m #define PictCropRegionOp  0x01  #define PictEndOfPictureOp  0xff #define PictHeaderOp  0x0C00 #define PictHeaderSize  512  #define PictPixmapOp  0x9A #define PictPICTOp  0x98 #define PictVersion  0x11;     typedef struct _PICTRectanglen   {t     unsigned short
       top,       left, 
       bottom,        right;   } PICTRectangle;     typedef struct _PICTPixmap   {x     unsigned short       base_address,        row_bytes;       PICTRectangle(
       bounds;)       unsigned short       version,       pack_type;       unsigned longp       pack_size,       horizontal_resolution,       vertical_resolution;       unsigned short       pixel_type,=       pixel_size,        component_count,       component_size;        unsigned short       plane_bytes,       table,       reserved;    } PICTPixmap;      int 
     count;     PICTPixmap     pixmap;,     PICTRectangler     crop_rectangle,      destination_rectangle,     frame_rectangle,     size_rectangle,%     source_rectangle;%     register int     i,     j,     x;     register RunlengthPacket     *p;      unsigned char      *buffer,     *packed_scanline,      *scanline;     unsigned int     bytes_per_line;      unsigned short     transfer_mode;     unsigned long      horizontal_resolution,     vertical_resolution;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate memory.   */    bytes_per_line=image->columns;"   if (image->class == DirectClass)     bytes_per_line*=3;H   buffer=(unsigned char *) malloc(PictHeaderSize*sizeof(unsigned char));#   packed_scanline=(unsigned char *) M     malloc((bytes_per_line+bytes_per_line/MaxCount+1)*sizeof(unsigned char));rJ   scanline=(unsigned char *) malloc(bytes_per_line*sizeof(unsigned char));+   if ((buffer == (unsigned char *) NULL) ||r4       (packed_scanline == (unsigned char *) NULL) ||+       (scanline == (unsigned char *) NULL)) 5     PrematureExit("Unable to allocate memory",image);    /*     Initialize image info.   */   size_rectangle.top=0;:   size_rectangle.left=0;#   size_rectangle.right=image->rows;a'   size_rectangle.bottom=image->columns; !   frame_rectangle=size_rectangle;X    crop_rectangle=size_rectangle;"   source_rectangle=size_rectangle;'   destination_rectangle=size_rectangle;g#   horizontal_resolution=0x00480000;o!   vertical_resolution=0x00480000;g   pixmap.base_address=0xff;    pixmap.row_bytes=lD     ((image->class == DirectClass ? 4 : 1)*image->columns) | 0x8000;   pixmap.version=0;    pixmap.bounds.top=0;   pixmap.bounds.left=0;)"   pixmap.bounds.right=image->rows;&   pixmap.bounds.bottom=image->columns;=   pixmap.pack_type=(image->class == DirectClass ? 0x4 : 0x0);n   pixmap.pack_size=0; 5   pixmap.horizontal_resolution=horizontal_resolution;m1   pixmap.vertical_resolution=vertical_resolution;;;   pixmap.pixel_type=(image->class == DirectClass ? 16 : 0);e;   pixmap.pixel_size=(image->class == DirectClass ? 32 : 8);%?   pixmap.component_count=(image->class == DirectClass ? 3 : 1);    pixmap.component_size=8;   pixmap.plane_bytes=0;    pixmap.table=0;    pixmap.reserved=0;9   transfer_mode=(image->class == DirectClass ? 0x40 : 0);    /*H     Write header, header size, size bounding box, version, and reserved.   */$   for (i=0; i < PictHeaderSize; i++)     buffer[i]=0;>   (void) fwrite((char *) buffer,1,PictHeaderSize,image->file);$   MSBFirstWriteShort(0,image->file);5   MSBFirstWriteShort(size_rectangle.top,image->file); 6   MSBFirstWriteShort(size_rectangle.left,image->file);7   MSBFirstWriteShort(size_rectangle.right,image->file);%8   MSBFirstWriteShort(size_rectangle.bottom,image->file);.   MSBFirstWriteShort(PictVersion,image->file);)   MSBFirstWriteShort(0x02ff,image->file);a/   MSBFirstWriteShort(PictHeaderOp,image->file);    /*N     Write full size of the file, resolution, frame bounding box, and reserved.   */-   MSBFirstWriteLong(0xfffe0000L,image->file);t7   MSBFirstWriteLong(horizontal_resolution,image->file);r5   MSBFirstWriteLong(vertical_resolution,image->file);e6   MSBFirstWriteShort(frame_rectangle.top,image->file);7   MSBFirstWriteShort(frame_rectangle.left,image->file);i8   MSBFirstWriteShort(frame_rectangle.right,image->file);9   MSBFirstWriteShort(frame_rectangle.bottom,image->file);g$   MSBFirstWriteLong(0L,image->file);   /*3     Write crop region opcode and crop bounding box.    */3   MSBFirstWriteShort(PictCropRegionOp,image->file);i&   MSBFirstWriteShort(0xa,image->file);5   MSBFirstWriteShort(crop_rectangle.top,image->file);_6   MSBFirstWriteShort(crop_rectangle.left,image->file);7   MSBFirstWriteShort(crop_rectangle.right,image->file);)8   MSBFirstWriteShort(crop_rectangle.bottom,image->file);   /*K     Write picture opcode, row bytes, and picture bounding box, and version.    */"   if (image->class == PseudoClass)/     MSBFirstWriteShort(PictPICTOp,image->file);    else     {03       MSBFirstWriteShort(PictPixmapOp,image->file);sI       MSBFirstWriteLong((unsigned long) pixmap.base_address,image->file);d     }f<   MSBFirstWriteShort(pixmap.row_bytes | 0x8000,image->file);4   MSBFirstWriteShort(pixmap.bounds.top,image->file);5   MSBFirstWriteShort(pixmap.bounds.left,image->file); 6   MSBFirstWriteShort(pixmap.bounds.right,image->file);7   MSBFirstWriteShort(pixmap.bounds.bottom,image->file);X1   MSBFirstWriteShort(pixmap.version,image->file);s   /*G     Write pack type, pack size, resolution, pixel type, and pixel size.    */3   MSBFirstWriteShort(pixmap.pack_type,image->file);d2   MSBFirstWriteLong(pixmap.pack_size,image->file);>   MSBFirstWriteLong(pixmap.horizontal_resolution,image->file);<   MSBFirstWriteLong(pixmap.vertical_resolution,image->file);4   MSBFirstWriteShort(pixmap.pixel_type,image->file);4   MSBFirstWriteShort(pixmap.pixel_size,image->file);   /*G     Write component count, size, plane bytes, table size, and reserved.c   */9   MSBFirstWriteShort(pixmap.component_count,image->file); 8   MSBFirstWriteShort(pixmap.component_size,image->file);D   MSBFirstWriteLong((unsigned long) pixmap.plane_bytes,image->file);>   MSBFirstWriteLong((unsigned long) pixmap.table,image->file);A   MSBFirstWriteLong((unsigned long) pixmap.reserved,image->file); "   if (image->class == PseudoClass)     {%       unsigned short         red,         green,
         blue;          /*         Write image colormap.        */:       MSBFirstWriteLong(0L,image->file);  /* color seed */<       MSBFirstWriteShort(0L,image->file);  /* color flags */I       MSBFirstWriteShort((unsigned short) (image->colors-1),image->file); '       for (i=0; i < image->colors; i++)        { B         red=(unsigned int) (image->colormap[i].red*65535L)/MaxRGB;F         green=(unsigned int) (image->colormap[i].green*65535L)/MaxRGB;D         blue=(unsigned int) (image->colormap[i].blue*65535L)/MaxRGB;9         MSBFirstWriteShort((unsigned int) i,image->file);%,         MSBFirstWriteShort(red,image->file);.         MSBFirstWriteShort(green,image->file);-         MSBFirstWriteShort(blue,image->file);e       }v     }i   /*+     Write source and destination rectangle.e   */7   MSBFirstWriteShort(source_rectangle.top,image->file);o8   MSBFirstWriteShort(source_rectangle.left,image->file);9   MSBFirstWriteShort(source_rectangle.right,image->file);t:   MSBFirstWriteShort(source_rectangle.bottom,image->file);<   MSBFirstWriteShort(destination_rectangle.top,image->file);=   MSBFirstWriteShort(destination_rectangle.left,image->file);r>   MSBFirstWriteShort(destination_rectangle.right,image->file);?   MSBFirstWriteShort(destination_rectangle.bottom,image->file);e0   MSBFirstWriteShort(transfer_mode,image->file);   /*     Write picture data.    */
   count=0;   x=0;   p=image->pixels;"   if (image->class == PseudoClass)     {        register unsigned char         *index;          index=scanline;d(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         { ,           *index++=(unsigned char) p->index;           x++;"           if (x == image->columns)
             {EE               count+=PICTEncodeImage(image,scanline,packed_scanline);                index=scanline;o               x=0;
             }*	         }g         p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       }      }t   else     {        register unsigned char         *blue,
         *red,-         *green;          red=scanline;i$       green=scanline+image->columns;*       blue=scanline+(image->columns << 1);(       for (i=0; i < image->packets; i++)       {e,         for (j=0; j <= (int) p->length; j++)	         {e#           *red++=DownScale(p->red); '           *green++=DownScale(p->green);d%           *blue++=DownScale(p->blue);q           x++;"           if (x == image->columns)
             {                red=scanline;(,               green=scanline+image->columns;2               blue=scanline+(image->columns << 1);@               count+=PICTEncodeImage(image,red,packed_scanline);               x=0;
             };	         }t         p++;!         if (QuantumTick(i,image))o:           ProgressMonitor(SaveImageText,i,image->packets);       }m     }o   if (count & 0x1)#     (void) fputc('\0',image->file);c5   MSBFirstWriteShort(PictEndOfPictureOp,image->file);a   free((char *) scanline);!   free((char *) packed_scanline);D   free((char *) buffer);   CloseImage(image);   return(True);d }a  
 #ifdef HasPNGe #include "png.h" /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %tO %                                                                             %hO %   W r i t e P N G I m a g e                                                 % O %                                                                             % O %                                                                             %oO %                                                                             %>O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%p %nJ %  Function WritePNGImage writes an image in the Portable Network Graphics %  encoded image format. % . %  The format of the WritePNGImage routine is: %,- %      status=WritePNGImage(image_info,image)  % + %  A description of each parameter follows.a %>J %    o status: Function WritePNGImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %e %o */K static unsigned int WritePNGImage(const ImageInfo *image_info,Image *image)  {(   register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;_  
   png_info     *ping_info;      png_struct
     *ping;     unsigned char      *png_pixels,     **scanlines;     unsigned int     bytes_per_line,      x,     y;     unsigned short
     value;     /*     Open image file.   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate the PNG structures+   */1   ping=(png_struct *) malloc(sizeof(png_struct));*2   ping_info=(png_info *) malloc(sizeof(png_info));H   if ((ping == (png_struct *) NULL) || (ping_info == (png_info *) NULL))5     PrematureExit("Unable to allocate memory",image); "   ping->palette=(png_colorp) NULL;#   ping_info->text=(png_textp) NULL;>$   png_pixels=(unsigned char *) NULL;$   scanlines=(unsigned char **) NULL;   if (setjmp(ping->jmpbuf))r    {       /*         PNG write failed.e       */       png_write_destroy(ping);/       if (scanlines != (unsigned char **) NULL)(!         free((char *) scanlines);!/       if (png_pixels != (unsigned char *) NULL) "         free((char *) png_pixels);-       if (ping->palette != (png_colorp) NULL)r%         free((char *) ping->palette);        free((char *) ping);.       if (ping_info->text != (png_textp) NULL)'         free((char *) ping_info->text);        free((char *) ping_info);        CloseImage(image);       return(False);     }i   /*     Prepare PNG for writing.   */   png_info_init(ping_info);i   png_write_init(ping);)    png_init_io(ping,image->file);"   ping_info->width=image->columns;    ping_info->height=image->rows;   ping_info->bit_depth=8; <   if ((image->class == DirectClass) && (image->depth == 16))     ping_info->bit_depth=16;+   ping_info->color_type=PNG_COLOR_TYPE_RGB;n   if (image->matte) 3     ping_info->color_type=PNG_COLOR_TYPE_RGB_ALPHA;s$   ping_info->bit_depth=image->depth;   ping_info->num_palette=0;,   if (IsGrayImage(image)) .     ping_info->color_type=PNG_COLOR_TYPE_GRAY;   else@     if ((image->class == PseudoClass) && (image->colors <= 256))       { 
         /*           Set image palette.
         */5         ping_info->color_type=PNG_COLOR_TYPE_PALETTE; -         ping_info->num_palette=image->colors; (         ping_info->valid|=PNG_INFO_PLTE;(         ping_info->palette=(png_color *)2           malloc(image->colors*sizeof(png_color));5         if (ping_info->palette == (png_color *) NULL)f;           PrematureExit("Unable to allocate memory",image); )         for (i=0; i < image->colors; i++)c	         { F           ping_info->palette[i].red=DownScale(image->colormap[i].red);J           ping_info->palette[i].green=DownScale(image->colormap[i].green);H           ping_info->palette[i].blue=DownScale(image->colormap[i].blue);	         }l         ping_info->bit_depth=1;t;         while ((1 << ping_info->bit_depth) < image->colors) #           ping_info->bit_depth<<=1;p       }    if (image->gamma != 0.0)     {a       /*         Note image gamma.        */&       ping_info->valid|=PNG_INFO_gAMA;$       ping_info->gamma=image->gamma;     }vC   ping_info->interlace_type=image_info->interlace != NoneInterlace;c!   png_write_info(ping,ping_info);t   png_set_packing(ping);   /*     Allocate memory.   */   bytes_per_line=(P     Max((int) ping_info->bit_depth >> 3,1)*Max(ping->channels,1)*image->columns;   png_pixels=(unsigned char *)=     malloc(bytes_per_line*image->rows*sizeof(unsigned char));SK   scanlines=(unsigned char **) malloc(image->rows*sizeof(unsigned char *));>/   if ((png_pixels == (unsigned char *) NULL) ||c-       (scanlines == (unsigned char **) NULL))d5     PrematureExit("Unable to allocate memory",image);    /*     Initialize image scanlines.    */!   for (i=0; i < image->rows; i++) /     scanlines[i]=png_pixels+(bytes_per_line*i);o   x=0;   y=0;   p=image->pixels;   q=scanlines[y];    if (IsGrayImage(image))m&     for (i=0; i < image->packets; i++)     { ,       for (j=0; j <= ((int) p->length); j++)       { &         WriteQuantum(Intensity(*p),q);         x++;          if (x == image->columns)           {e             x=0;             y++;             q=scanlines[y];            }        } 
       p++;       if (QuantumTick(i,image)) 8         ProgressMonitor(SaveImageText,i,image->packets);     }n   else?     if ((image->class == DirectClass) || (image->colors > 256))a(       for (i=0; i < image->packets; i++)       {[.         for (j=0; j <= ((int) p->length); j++)	         {g!           WriteQuantum(p->red,q);r#           WriteQuantum(p->green,q);l"           WriteQuantum(p->blue,q);           if (image->matte)I%             WriteQuantum(p->index,q);a           x++;"           if (x == image->columns)
             {=               x=0;               y++;               q=scanlines[y];,
             } 	         }p         p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       }_     else(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            *q++=p->index;           x++;"           if (x == image->columns)
             {                x=0;               y++;               q=scanlines[y];[
             } 	         }          p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       })   /*     Write image scanlines.   */"   png_write_image(ping,scanlines);'   if (image->comments != (char *) NULL)t     {a       /*         Write image comment.       */       ping_info->num_text=1;<       ping_info->text=(png_text *) malloc(sizeof(png_text));/       if (ping_info->text == (png_text *) NULL) 9         PrematureExit("Unable to allocate memory",image);a'       ping_info->text[0].key="Comment";;.       ping_info->text[0].text=image->comments;=       ping_info->text[0].text_length=strlen(image->comments);%M       ping_info->text[0].compression=strlen(image->comments) > 1024 ? 0 : -1;      }     png_write_end(ping,ping_info);   /*     Free memory.   */   png_write_destroy(ping);)   if (ping->palette != (png_colorp) NULL) !     free((char *) ping->palette); 
   free(ping); *   if (ping_info->text != (png_textp) NULL)#     free((char *) ping_info->text);    free(ping_info);   CloseImage(image);   return(True);  }  #else K static unsigned int WritePNGImage(const ImageInfo *image_info,Image *image)  {    unsigned int     status;   :   Warning("PNG library is not available",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);% }% #endif % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %RO %                                                                             %AO %                                                                             %aO %   W r i t e P N M I m a g e                                                 %mO %                                                                             %fO %                                                                             %tO %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %gJ %  Procedure WritePNMImage writes an image to a file in the PNM rasterfile
 %  format. %e. %  The format of the WritePNMImage routine is: %U- %      status=WritePNMImage(image_info,image)m %)+ %  A description of each parameter follows.u %oJ %    o status: Function WritePNMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filen %      fails to write. %fA %    o image_info: Specifies a pointer to an ImageInfo structure.g %p. %    o image:  A pointer to a Image structure. %) %  */K static unsigned int WritePNMImage(const ImageInfo *image_info,Image *image)% {% #define MaxRawValue  255     register int     i,     j;     register RunlengthPacket     *p;      unsigned char      format;      unsigned int     x;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {      /*/       Promote/Demote image based on image type.      */.     if (strcmp(image_info->magick,"PPM") == 0)       image->class=DirectClass;      else0       if (strcmp(image_info->magick,"PGM") == 0)0         RGBTransformImage(image,GRAYColorspace);
       else2         if (strcmp(image_info->magick,"PBM") == 0):           if (!IsGrayImage(image) || (image->colors != 2))
             { I               QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);a               SyncImage(image);e
             }s     /*       Write PNM file header.     *//     image->compression=image_info->compression;t5     if (!IsPseudoClass(image) && !IsGrayImage(image))        {r
         /*           Full color PNM image.s
         */         format='6';:L         if ((image->compression == NoCompression) || (MaxRGB > MaxRawValue))           format='3';        }/     else       {t
         /*            Colormapped PNM image.
         */         format='6'; L         if ((image->compression == NoCompression) || (MaxRGB > MaxRawValue))           format='3'; J         if (IsGrayImage(image) && (strcmp(image_info->magick,"PPM") != 0))           {              /*"               Grayscale PNM image.             */             format='5'; P             if ((image->compression == NoCompression) || (MaxRGB > MaxRawValue))               format='2';y6             if (strcmp(image_info->magick,"PGM") != 0)%               if (image->colors == 2)                  {;                   format='4';*:                   if (image->compression == NoCompression)                     format='1';i                 }a           }        }i/     (void) fprintf(image->file,"P%c\n",format);i)     if (image->comments != (char *) NULL)h       {          register chars
           *p;U  
         /*!           Write comments to file.o
         */)         (void) fprintf(image->file,"# ");a0         for (p=image->comments; *p != '\0'; p++)	         { '           (void) fputc(*p,image->file);i           if (*p == '\n') -             (void) fprintf(image->file,"# ");e	         } '         (void) fputc('\n',image->file);        }eE     (void) fprintf(image->file,"%u %u\n",image->columns,image->rows);B     /*5       Convert runlength encoded to PNM raster pixels.P     */     x=0;     p=image->pixels;     switch (format)      {        case '1':o       {          register unsigned char           polarity;   
         /*'           Convert image to a PBM image.D
         */         polarity=0;          if (image->colors == 2)            polarity= J             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           {rC             (void) fprintf(image->file,"%d ",p->index == polarity);              x++;             if (x == 36)               {g1                 (void) fprintf(image->file,"\n");                  x=0;               }i           }            p++;#           if (QuantumTick(i,image))N<             ProgressMonitor(SaveImageText,i,image->packets);	         }          break;       }y       case '2':        { 
         /*'           Convert image to a PGM image. 
         */2         (void) fprintf(image->file,"%d\n",MaxRGB);*         for (i=0; i < image->packets; i++)	         {y0           for (j=0; j <= ((int) p->length); j++)           { 5             (void) fprintf(image->file,"%d ",p->red);p             x++;             if (x == 12)               { 1                 (void) fprintf(image->file,"\n");                  x=0;               }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }x         break;       }        case '3':        {;
         /*'           Convert image to a PNM image. 
         */2         (void) fprintf(image->file,"%d\n",MaxRGB);*         for (i=0; i < image->packets; i++)	         {40           for (j=0; j <= ((int) p->length); j++)           {+L             (void) fprintf(image->file,"%d %d %d ",p->red,p->green,p->blue);             x++;             if (x == 4)                { 1                 (void) fprintf(image->file,"\n");x                 x=0;               }l           }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }+         break;       }        case '4':        {          register unsigned char           bit,           byte,            polarity;;  
         /*'           Convert image to a PBM image. 
         */         polarity=0;          if (image->colors == 2)            polarity=SJ             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);         bit=0;         byte=0;          x=0;*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           {l             byte<<=1;c%             if (p->index == polarity)                byte|=0x01;m             bit++;             if (bit == 8)                {a/                 (void) fputc(byte,image->file);                  bit=0;                 byte=0;o               }              x++;$             if (x == image->columns)               {s                 /*/                   Advance to the next scanline.                  */                 if (bit != 0)h<                   (void) fputc(byte << (8-bit),image->file);                 bit=0;                 byte=0;                  x=0;              }           }e           p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }e         break;       }l       case '5':i       {)
         /*'           Convert image to a PGM image.N
         */=         (void) fprintf(image->file,"%u\n",DownScale(MaxRGB)); *         for (i=0; i < image->packets; i++)	         {-0           for (j=0; j <= ((int) p->length); j++)8             (void) fputc(DownScale(p->red),image->file);           p++;#           if (QuantumTick(i,image))q<             ProgressMonitor(SaveImageText,i,image->packets);	         })         break;       }t       case '6':        {p
         /*'           Convert image to a PNM image. 
         */=         (void) fprintf(image->file,"%u\n",DownScale(MaxRGB));=*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           { 8             (void) fputc(DownScale(p->red),image->file);:             (void) fputc(DownScale(p->green),image->file);9             (void) fputc(DownScale(p->blue),image->file);            }            p++;#           if (QuantumTick(i,image)),<             ProgressMonitor(SaveImageText,i,image->packets);	         };         break;       }      }D&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }  v /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cO %                                                                             %fO %                                                                             %lO %                                                                             %gO %   W r i t e P S I m a g e                                                   %)O %                                                                             % O %                                                                             %nO %                                                                             %_O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%G %  Function WritePSImage translates an image to encapsulated Postscript H %  Level I for printing.  If the supplied geometry is null, the image isJ %  centered on the Postscript page.  Otherwise, the image is positioned as %  specified by the geometry.  % - %  The format of the WritePSImage routine is:  % , %      status=WritePSImage(image_info,image) % + %  A description of each parameter follows:  % I %    o status: Function WritePSImage return True if the image is printed. I %      False is returned if the image file cannot be opened for printing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.% %%F %    o image: The address of a structure of type Image;  returned from %      ReadImage.O %M %g */J static unsigned int WritePSImage(const ImageInfo *image_info,Image *image) { 
   static charr     *Postscript[]=     {h       "%%BeginProlog",
       "%",E       "% Display a color image.  The image is displayed in color on",eG       "% Postscript viewers or printers that support color, otherwise",e(       "% it is displayed as grayscale.",
       "%",       "/buffer 512 string def",h       "/byte 1 string def", #       "/color_packet 3 string def",r       "/pixels 768 string def",o	       "",t       "/DirectClassPacket", 
       "{",       "  %",&       "  % Get a DirectClass packet.",       "  %",       "  % Parameters:",       "  %   red.",        "  %   green.",a       "  %   blue.",K       "  %   length: number of pixels minus one of this color (optional).",        "  %",9       "  currentfile color_packet readhexstring pop pop",e       "  compression 0 gt",        "  {",!       "    /number_pixels 3 def",r       "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", 0       "    /number_pixels exch 1 add 3 mul def",       "  } ifelse",e"       "  0 3 number_pixels 1 sub",       "  {",1       "    pixels exch color_packet putinterval",g       "  } for",-       "  pixels 0 number_pixels getinterval",        "} bind def", 	       "",        "/DirectClassImage",
       "{",       "  %",)       "  % Display a DirectClass image.",        "  %",'       "  systemdict /colorimage known",        "  {",       "    columns rows 8",        "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",5       "    { DirectClassPacket } false 3 colorimage",;       "  }",       "  {",       "    %",=       "    % No colorimage operator;  convert to grayscale.",&       "    %",       "    columns rows 8",-       "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",,       "    { GrayDirectClassPacket } image",       "  } ifelse",a       "} bind def",y	       "",        "/GrayDirectClassPacket",a
       "{",       "  %",=       "  % Get a DirectClass packet;  convert to grayscale.",m       "  %",       "  % Parameters:",       "  %   red",       "  %   green",       "  %   blue", K       "  %   length: number of pixels minus one of this color (optional).",L       "  %",9       "  currentfile color_packet readhexstring pop pop", '       "  color_packet 0 get 0.299 mul", +       "  color_packet 1 get 0.587 mul add",m+       "  color_packet 2 get 0.114 mul add",m       "  cvi",        "  /gray_packet exch def",       "  compression 0 gt",        "  {",!       "    /number_pixels 1 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get",(*       "    /number_pixels exch 1 add def",       "  } ifelse",g"       "  0 1 number_pixels 1 sub",       "  {",(       "    pixels exch gray_packet put",       "  } for",-       "  pixels 0 number_pixels getinterval",e       "} bind def",=	       "",        "/GrayPseudoClassPacket", 
       "{",       "  %",=       "  % Get a PseudoClass packet;  convert to grayscale.",        "  %",       "  % Parameters:",.       "  %   index: index into the colormap.",K       "  %   length: number of pixels minus one of this color (optional).",        "  %",3       "  currentfile byte readhexstring pop 0 get",o!       "  /offset exch 3 mul def",m:       "  /color_packet colormap offset 3 getinterval def",'       "  color_packet 0 get 0.299 mul", +       "  color_packet 1 get 0.587 mul add",t+       "  color_packet 2 get 0.114 mul add",r       "  cvi",        "  /gray_packet exch def",       "  compression 0 gt",a       "  {",!       "    /number_pixels 1 def",g       "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", *       "    /number_pixels exch 1 add def",       "  } ifelse", "       "  0 1 number_pixels 1 sub",       "  {",(       "    pixels exch gray_packet put",       "  } for",-       "  pixels 0 number_pixels getinterval",_       "} bind def",o	       "",>       "/PseudoClassPacket",M
       "{",       "  %",&       "  % Get a PseudoClass packet.",       "  %",       "  % Parameters:",.       "  %   index: index into the colormap.",K       "  %   length: number of pixels minus one of this color (optional).",        "  %",3       "  currentfile byte readhexstring pop 0 get",;!       "  /offset exch 3 mul def", :       "  /color_packet colormap offset 3 getinterval def",       "  compression 0 gt",p       "  {",!       "    /number_pixels 3 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get",t0       "    /number_pixels exch 1 add 3 mul def",       "  } ifelse",i"       "  0 3 number_pixels 1 sub",       "  {",1       "    pixels exch color_packet putinterval",c       "  } for",-       "  pixels 0 number_pixels getinterval",a       "} bind def",m	       "",e       "/PseudoClassImage",
       "{",       "  %",)       "  % Display a PseudoClass image.",s       "  %",       "  % Parameters:",3       "  %   class: 0-PseudoClass or 1-Grayscale.",%       "  %",*       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",       "  class 0 gt",        "  {",,       "    currentfile buffer readline pop",*       "    token pop /depth exch def pop",&       "    /grays columns string def",       "    columns rows depth",        "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",:       "    { currentfile grays readhexstring pop } image",       "  }",       "  {",       "    %",       "    % Parameters:",:       "    %   colors: number of colors in the colormap.",:       "    %   colormap: red, green, blue color packets.",       "    %",,       "    currentfile buffer readline pop",+       "    token pop /colors exch def pop",a%       "    /colors colors 3 mul def",i(       "    /colormap colors string def",7       "    currentfile colormap readhexstring pop pop",e)       "    systemdict /colorimage known",        "    {",       "      columns rows 8",n       "      [",       "        columns 0 0",        "        rows neg 0 rows",       "      ]",7       "      { PseudoClassPacket } false 3 colorimage",t       "    }",       "    {",       "      %",?       "      % No colorimage operator;  convert to grayscale.",        "      %",       "      columns rows 8",H       "      [",       "        columns 0 0",        "        rows neg 0 rows",       "      ]",.       "      { GrayPseudoClassPacket } image",       "    } ifelse",t       "  } ifelse",,       "} bind def",r	       "",        "/DisplayImage",
       "{",       "  %",8       "  % Display a DirectClass or PseudoClass image.",       "  %",       "  % Parameters:",!       "  %   x & y translation.",)       "  %   x & y scale.",x       "  %   label pointsize.",        "  %   image label.",-$       "  %   image columns & rows.",5       "  %   class: 0-DirectClass or 1-PseudoClass.",_M       "  %   compression: 0-RunlengthEncodedCompression or 1-NoCompression.",-!       "  %   hex color packets.",v       "  %",       "  gsave",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",       "  x y translate",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",*       "  currentfile buffer readline pop",(       "  token pop /pointsize exch def",G       "  /NewCenturySchlbk-Roman findfont pointsize scalefont setfont",f*       "  currentfile buffer readline pop",,       "  0 y 12 add moveto buffer show pop",       "  x y scale",*       "  currentfile buffer readline pop",&       "  token pop /columns exch def",'       "  token pop /rows exch def pop",>*       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",*       "  currentfile buffer readline pop",.       "  token pop /compression exch def pop",F       "  class 0 gt { PseudoClassImage } { DirectClassImage } ifelse",       "  grestore",a       (char *) NULL      };     char     date[MaxTextLength],     *label,\     **q;     floate     dx_resolution,     dy_resolution,     x_resolution,      y_resolution;r     int-     length,e     x,     y;     register RunlengthPacket     *p;      register int     i,     j;     time_t
     timer;     unsigned int     bit,	     byte,t
     count,     height, 	     page,p
     polarity,      text_size,
     width;  
   XSegment     bounding_box;      /*     Open output image file.    */"   OpenImage(image_info,image,"w");#   if (image->file == (FILE *) NULL)g/     PrematureExit("Unable to open file",image);"	   page=1;u   do   {r     /*-       Scale image to size of Postscript page.      */K     text_size=image->label == (char *) NULL ? 0 : image_info->pointsize+12;=     x=0;     y=0;     width=image->columns;      height=image->rows; -     if (strcmp(image_info->magick,"PS") == 0)y       {h         int            delta_x,           delta_y,           flags;           unsigned int           page_height,           page_width;i  
         /**           Center image on Postscript page.
         */M         (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height);f         flags=NoValue;.         if (image_info->page != (char *) NULL)P           flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);)         if (image->page != (char *) NULL)'K           flags=XParseGeometry(image->page,&x,&y,&page_width,&page_height); .         if (((page_width-(x << 1)) < width) ||8             ((page_height-(y << 1)-text_size) < height))           {i             unsigned long                scale_factor;f               /*6               Scale image relative to Postscript page.             */<             scale_factor=UpShift(page_width-(x << 1))/width;P             if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))J               scale_factor=UpShift(page_height-(y << 1)-text_size)/height;0             width=DownShift(width*scale_factor);2             height=DownShift(height*scale_factor);           }""         if ((flags & XValue) == 0)           {f             /*.               Center image in the X direction.             */0             delta_x=page_width-(width+(x << 1));             if (delta_x >= 0)e!               x=(delta_x >> 1)+x;,           } "         if ((flags & YValue) == 0)           {s             /*.               Center image in the X direction.             */<             delta_y=page_height-(height+(y << 1))-text_size;             if (delta_y >= 0) !               y=(delta_y >> 1)+y;)           }        }*     /*&       Scale relative to dots-per-inch.     */     dx_resolution=72.0;e     dy_resolution=72.0;+     x_resolution=72.0;H     count=sscanf(PSDensityGeometry,"%fx%f",&x_resolution,&y_resolution);-     if (image_info->density != (char *) NULL) L       count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);     if (count != 2)(        y_resolution=x_resolution;D     width=(unsigned int) (((width*dx_resolution)/x_resolution)+0.5);F     height=(unsigned int) (((height*dy_resolution)/y_resolution)+0.5);     if (page == 1)       {a
         /*#           Output Postscript header. 
         */1         if (strcmp(image_info->magick,"PS") == 0)a:           (void) fprintf(image->file,"%%!PS-Adobe-3.0\n");         elseC           (void) fprintf(image->file,"%%!PS-Adobe-3.0 EPSF-3.0\n");fC         (void) fprintf(image->file,"%%%%Creator: (ImageMagick)\n");iH         (void) fprintf(image->file,"%%%%Title: (%s)\n",image->filename);$         timer=time((time_t *) NULL);!         (void) localtime(&timer);-*         (void) strcpy(date,ctime(&timer));"         date[strlen(date)-1]='\0';D         (void) fprintf(image->file,"%%%%CreationDate: (%s)\n",date);         bounding_box.x1=x;         bounding_box.y1=y;(         bounding_box.x2=x+(int) width-1;5         bounding_box.y2=y+(int) (height+text_size)-1; B         if (image_info->adjoin && (image->next != (Image *) NULL))C           (void) fprintf(image->file,"%%%%BoundingBox: (atend)\n");          elseF           (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",M             bounding_box.x1,bounding_box.y1,bounding_box.x2,bounding_box.y2);i*         if (image->label != (char *) NULL)%           (void) fprintf(image->file,%J             "%%%%DocumentNeededResources: font NewCenturySchlbk-Roman\n");D         (void) fprintf(image->file,"%%%%DocumentData: Clean7Bit\n");=         (void) fprintf(image->file,"%%%%LanguageLevel: 1\n"); 1         if (strcmp(image_info->magick,"PS") != 0) 7           (void) fprintf(image->file,"%%%%Pages: 0\n");          else           {              Image               *next_image;                unsigned int               pages;               /**               Compute the number of pages.             */F             (void) fprintf(image->file,"%%%%Orientation: Portrait\n");B             (void) fprintf(image->file,"%%%%PageOrder: Ascend\n");             pages=1;#             if (image_info->adjoin)eJ               for (next_image=image->next; next_image != (Image *) NULL; )               { ,                 next_image=next_image->next;                 pages++;               }l@             (void) fprintf(image->file,"%%%%Pages: %u\n",pages);           }w8         (void) fprintf(image->file,"%%%%EndComments\n");<         (void) fprintf(image->file,"\n%%%%BeginDefaults\n");F         (void) fprintf(image->file,"%%%%PageOrientation: Portrait\n");:         (void) fprintf(image->file,"%%%%EndDefaults\n\n");3         if (strcmp(image_info->magick,"EPSI") == 0)d           {              Imager               *preview_image;e               /*#               Create preview image.I             */             image->orphan=True; K             preview_image=CopyImage(image,image->columns,image->rows,True);t              image->orphan=False;0             if (preview_image == (Image *) NULL)?               PrematureExit("Unable to allocate memory",image);              /*#               Dump image as bitmap.              */<             if (!IsGrayImage(image) || (image->colors != 2))               {(C                 QuantizeImage(preview_image,2,8,image_info->dither,L"                   GRAYColorspace);)                 SyncImage(preview_image);                }t             polarity=0;c#             if (image->colors == 2)>               polarity=nN                 Intensity(image->colormap[0]) > Intensity(image->colormap[1]);             bit=0;             byte=0;(             count=0;             x=0;$             p=preview_image->pixels;M             (void) fprintf(image->file,"%%%%BeginPreview: %u %u %u %u\n%%  ",2J               preview_image->columns,preview_image->rows,(unsigned int) 1,M               (((preview_image->columns+7) >> 3)*preview_image->rows+35)/36);c6             for (i=0; i < preview_image->packets; i++)
             {i4               for (j=0; j <= ((int) p->length); j++)               {p                 byte<<=1; )                 if (p->index == polarity)                    byte|=0x01;e                 bit++;                 if (bit == 8)-                   { C                     (void) fprintf(image->file,"%02x",byte & 0xff);                      count++;$                     if (count == 36)                       { =                         (void) fprintf(image->file,"\n%%  ");                           count=0;                       };                     bit=0;                     byte=0;b                   }                  x++;0                 if (x == preview_image->columns)                   { !                     if (bit != 0)                        {g'                         byte<<=(8-bit); G                         (void) fprintf(image->file,"%02x",byte & 0xff);f                          count++;(                         if (count == 36)                           { A                             (void) fprintf(image->file,"\n%%  "); $                             count=0;                           };                         bit=0;                         byte=0;u                       };                     x=0;                   }                  }_                 p++;               }t?               (void) fprintf(image->file,"\n%%%%EndPreview\n");n*               DestroyImage(preview_image);
             } 
         /*%           Output Postscript commands.G
         */#         for (q=Postscript; *q; q++) 0           (void) fprintf(image->file,"%s\n",*q);1         if (strcmp(image_info->magick,"PS") == 0) 5           (void) fprintf(image->file,"  showpage\n");=3         (void) fprintf(image->file,"} bind def\n");s6         (void) fprintf(image->file,"%%%%EndProlog\n");       } ;     (void) fprintf(image->file,"%%%%Page:  1 %u\n",page++); H     (void) fprintf(image->file,"%%%%PageBoundingBox: %d %d %d %d\n",x,y,4       x+(int) width-1,y+(int) (height+text_size)-1);     if (x < bounding_box.x1)       bounding_box.x1=x;     if (y < bounding_box.y1)       bounding_box.y1=y;,     if ((x+(int) width-1) > bounding_box.x2)&       bounding_box.x2=x+(int) width-1;9     if ((y+(int) (height+text_size)-1) > bounding_box.y2) 3       bounding_box.y2=y+(int) (height+text_size)-1; &     if (image->label != (char *) NULL)!       (void) fprintf(image->file, <         "%%%%PageResources: font NewCenturySchlbk-Roman\n");-     if (strcmp(image_info->magick,"PS") != 0)e5       (void) fprintf(image->file,"userdict begin\n"); 3     (void) fprintf(image->file,"%%%%BeginData:\n"); 1     (void) fprintf(image->file,"DisplayImage\n");      /*       Output image data.     *//     image->compression=image_info->compression;      CompressImage(image);      label=image->label;%     if (label == (char *) NULL)%       label=" ";     p=image->pixels;     switch (image->class)e     {        case DirectClass:u       {I#         (void) fprintf(image->file, N           "%d %d\n%u %u\n%d\n%s           \n%u %u\n%d\n%d\n",x,y,width,height,A           image_info->pointsize,label,image->columns,image->rows,rK           image->class == PseudoClass,image->compression == NoCompression);s#         switch (image->compression)e	         {e+           case RunlengthEncodedCompression:l           default:           {e             /*9               Dump runlength-encoded DirectColor packets.              */             x=0;.             for (i=0; i < image->packets; i++)
             { >               for (length=p->length; length >= 0; length-=256)               {r>                 if (image->matte && (p->index == Transparent))H                   (void) fprintf(image->file,"ffffff%02x",(unsigned int)&                     Min(length,0xff));                 else@                   (void) fprintf(image->file,"%02x%02x%02x%02x",M                     DownScale(p->red),DownScale(p->green),DownScale(p->blue),a5                     (unsigned int) Min(length,0xff));e                 x++;                 if (x == 9)                    {a                     x=0;5                     (void) fprintf(image->file,"\n");m                   })               }                p++;'               if (QuantumTick(i,image))t@                 ProgressMonitor(SaveImageText,i,image->packets);
             }e             break;           }j           case NoCompression:i           {u             /*4               Dump uncompressed DirectColor packets.             */             x=0;.             for (i=0; i < image->packets; i++)
             {f4               for (j=0; j <= ((int) p->length); j++)               { >                 if (image->matte && (p->index == Transparent))7                   (void) fprintf(image->file,"ffffff");g                 elseN                   (void) fprintf(image->file,"%02x%02x%02x",DownScale(p->red),<                     DownScale(p->green),DownScale(p->blue));                 x++;                 if (x == 12)                   {a                     x=0;5                     (void) fprintf(image->file,"\n");s                   }.               }S               p++;'               if (QuantumTick(i,image)) @                 ProgressMonitor(SaveImageText,i,image->packets);
             }              break;           }m	         }          break;       }y       case PseudoClass:u       {e         unsigned int           grayscale;  #         (void) fprintf(image->file,cN           "%d %d\n%u %u\n%d\n%s           \n%u %u\n%d\n%d\n",x,y,width,height,A           image_info->pointsize,label,image->columns,image->rows,_K           image->class == PseudoClass,image->compression == NoCompression);tN         grayscale=IsGrayImage(image) && (image->compression == NoCompression);5         (void) fprintf(image->file,"%u\n",grayscale);e         if (grayscale)H           (void) fprintf(image->file,"%d\n",image->colors == 2 ? 1 : 8);         else           {f             /*1               Dump number of colors and colormap.c             */=             (void) fprintf(image->file,"%u\n",image->colors);r-             for (i=0; i < image->colors; i++)=:               (void) fprintf(image->file,"%02x%02x%02x\n",2                 DownScale(image->colormap[i].red),4                 DownScale(image->colormap[i].green),4                 DownScale(image->colormap[i].blue));           }-#         switch (image->compression) 	         { +           case RunlengthEncodedCompression:            default:           {p             /*9               Dump runlength-encoded PseudoColor packets.              */             x=0;.             for (i=0; i < image->packets; i++)
             {p>               for (length=p->length; length >= 0; length-=256)               { N                 (void) fprintf(image->file,"%02x%02x",(unsigned int) p->index,3                   (unsigned int) Min(length,0xff));o                 x++;                 if (x == 18)                   {n                     x=0;5                     (void) fprintf(image->file,"\n");                    })               }                p++;'               if (QuantumTick(i,image));@                 ProgressMonitor(SaveImageText,i,image->packets);
             }j             break;           }a           case NoCompression:p           {              /*4               Dump uncompressed PseudoColor packets.             */             x=0;             if (!grayscale)(0               for (i=0; i < image->packets; i++)               {f6                 for (j=0; j <= ((int) p->length); j++)                 {cM                   (void) fprintf(image->file,"%02x",(unsigned int) p->index);                    x++;                   if (x == 36)                     {f                       x=0;7                       (void) fprintf(image->file,"\n");e                     }                  }p                 p++;)                 if (QuantumTick(i,image))+B                   ProgressMonitor(SaveImageText,i,image->packets);               }g             else%               if (image->colors != 2)g2                 for (i=0; i < image->packets; i++)                 {)8                   for (j=0; j <= ((int) p->length); j++)                   {MI                     (void) fprintf(image->file,"%02x",DownScale(p->red));                      x++;                      if (x == 36)                       {)                         x=0;9                         (void) fprintf(image->file,"\n");                        }                    };                   p++;+                   if (QuantumTick(i,image))mD                     ProgressMonitor(SaveImageText,i,image->packets);                 }e               else                 {(                   /*)                     Dump image as bitmap.;                   */:                   polarity=Intensity(image->colormap[1]) >2                     Intensity(image->colormap[0]);                   bit=0;                   byte=0;,                   count=0;                   x=0;"                   p=image->pixels;4                   for (i=0; i < image->packets; i++)                   {%:                     for (j=0; j <= ((int) p->length); j++)                     {                        byte<<=1; /                       if (p->index == polarity) #                         byte|=0x01;                        bit++;#                       if (bit == 8)                          { I                           (void) fprintf(image->file,"%02x",byte & 0xff); "                           count++;*                           if (count == 36)                             { ?                               (void) fprintf(image->file,"\n"); &                               count=0;                             };                            bit=0;!                           byte=0;t                         }i                       x++;.                       if (x == image->columns)                         {u'                           if (bit != 0)                              {r-                               byte<<=(8-bit);GM                               (void) fprintf(image->file,"%02x",byte & 0xff); &                               count++;.                               if (count == 36)!                                 {nC                                   (void) fprintf(image->file,"\n"); *                                   count=0;"                                 };$                               bit=0;%                               byte=0;e                             };                           x=0;                         }                        }%                       p++;/                       if (QuantumTick(i,image)) H                         ProgressMonitor(SaveImageText,i,image->packets);                     }                    }              break;           } 	         }        }      } %     (void) fprintf(image->file,"\n"); 0     (void) fprintf(image->file,"%%%%EndData\n");-     if (strcmp(image_info->magick,"PS") != 0) *       (void) fprintf(image->file,"end\n");4     (void) fprintf(image->file,"%%%%PageTrailer\n");&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);%.   (void) fprintf(image->file,"%%%%Trailer\n");   if (page > 1)%@     (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",G       bounding_box.x1,bounding_box.y1,bounding_box.x2,bounding_box.y2); *   (void) fprintf(image->file,"%%%%EOF\n");   CloseImage(image);   return(True);g }m _ /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %dO %                                                                             % O %                                                                             %aO %   W r i t e P S 2 I m a g e                                                 %gO %                                                                             %iO %                                                                             %tO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%= %IH %  Function WritePS2Image translates an image to encapsulated PostscriptI %  Level II for printing.  If the supplied geometry is null, the image is J %  centered on the Postscript page.  Otherwise, the image is positioned as %  specified by the geometry._ %o. %  The format of the WritePS2Image routine is: % - %      status=WritePS2Image(image_info,image)  %o+ %  A description of each parameter follows:e %aJ %    o status: Function WritePS2Image return True if the image is printed.I %      False is returned if the image file cannot be opened for printing.  %oA %    o image_info: Specifies a pointer to an ImageInfo structure.; %+F %    o image: The address of a structure of type Image;  returned from %      ReadImage.. %e %) */K static unsigned int WritePS2Image(const ImageInfo *image_info,Image *image)c {r
   static charg     *Postscript[]=     {        "%%BeginProlog",
       "%",E       "% Display a color image.  The image is displayed in color on",iG       "% Postscript viewers or printers that support color, otherwise",t(       "% it is displayed as grayscale.",
       "%",       "/buffer 512 string def",a	       "",        "/DirectClassImage",
       "{",       "  %",)       "  % Display a DirectClass image.",a       "  %",#       "  /DeviceRGB setcolorspace",%
       "  <<",%       "    /ImageType 1",%       "    /Interpolate true",       "    /Width columns",        "    /Height rows",         "    /BitsPerComponent 8","       "    /Decode [0 1 0 1 0 1]",7       "    /ImageMatrix [columns 0 0 rows neg 0 rows]",        "    compression 0 gt",        "    {",<       "      /DataSource currentfile /ASCII85Decode filter",       "    }",       "    {",N       "      /DataSource currentfile /ASCII85Decode filter /LZWDecode filter",       "    } ifelse",        "  >> image",        "} bind def", 	       "",        "/PseudoClassImage",
       "{",       "  %",)       "  % Display a PseudoClass image.",%       "  %",       "  % Parameters:",8       "  %   colors: number of colors in the colormap.",       "  %",*       "  currentfile buffer readline pop",)       "  token pop /colors exch def pop",m       "  colors 0 eq",       "  {",       "    %","       "    % Image is grayscale.",       "    %",&       "    /DeviceGray setcolorspace",       "    <<",f       "      /ImageType 1",F        "      /Interpolate true",       "      /Width columns",        "      /Height rows", "       "      /BitsPerComponent 1",       "      /Decode [0 1]",9       "      /ImageMatrix [columns 0 0 rows neg 0 rows]",o       "      compression 0 gt",A       "      {",>       "        /DataSource currentfile /ASCII85Decode filter",       "      }",       "      {",P       "        /DataSource currentfile /ASCII85Decode filter /LZWDecode filter",       "      } ifelse",        "    >> image",d       "  }",       "  {",       "    %",       "    % Parameters:",:       "    %   colormap: red, green, blue color packets.",       "    %",.       "    /colormap colors 3 mul string def",7       "    currentfile colormap readhexstring pop pop", H       "    [ /Indexed /DeviceRGB colors 1 sub colormap ] setcolorspace",       "    <<",t       "      /ImageType 1",i        "      /Interpolate true",       "      /Width columns",n       "      /Height rows",g"       "      /BitsPerComponent 8",       "      /Decode [0 255]",9       "      /ImageMatrix [columns 0 0 rows neg 0 rows]",%       "      compression 0 gt",%       "      {",>       "        /DataSource currentfile /ASCII85Decode filter",       "      }",       "      {",P       "        /DataSource currentfile /ASCII85Decode filter /LZWDecode filter",       "      } ifelse",        "    >> image",        "  } ifelse",        "} bind def", 	       "",        "/DisplayImage",
       "{",       "  %",8       "  % Display a DirectClass or PseudoClass image.",       "  %",       "  % Parameters:",!       "  %   x & y translation.",        "  %   x & y scale.",        "  %   label pointsize.",        "  %   image label.", $       "  %   image columns & rows.",5       "  %   class: 0-DirectClass or 1-PseudoClass.", M       "  %   compression: 0-RunlengthEncodedCompression or 1-NoCompression.", !       "  %   hex color packets.",        "  %",       "  gsave",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",       "  x y translate",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",*       "  currentfile buffer readline pop",(       "  token pop /pointsize exch def",G       "  /NewCenturySchlbk-Roman findfont pointsize scalefont setfont",l*       "  currentfile buffer readline pop",,       "  0 y 12 add moveto buffer show pop",       "  x y scale",*       "  currentfile buffer readline pop",&       "  token pop /columns exch def",'       "  token pop /rows exch def pop",r*       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",*       "  currentfile buffer readline pop",.       "  token pop /compression exch def pop",F       "  class 0 gt { PseudoClassImage } { DirectClassImage } ifelse",       "  grestore","       (char *) NULL*     };     char     date[MaxTextLength],     *label,n     **q;     floati     dx_resolution,     dy_resolution,     x_resolution,=     y_resolution;      intg
     count,     delta_x,     delta_y,
     flags,     x,     y;     register RunlengthPacket     *p;      register int     i,     j;     time_t
     timer;     unsigned charl     *pixels;     unsigned int     height,k     number_packets,p	     page,1     page_height,     page_width,x     text_size,
     width;  
   XSegment     bounding_box;n     /*     Open output image file.x   */"   OpenImage(image_info,image,"w");#   if (image->file == (FILE *) NULL)o/     PrematureExit("Unable to open file",image); 	   page=1;t   do   {s     /*-       Scale image to size of Postscript page.      */K     text_size=image->label == (char *) NULL ? 0 : image_info->pointsize+12;      x=0;     y=0;     width=image->columns;s     height=image->rows;c     /*&       Center image on Postscript page.     */I     (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height);U     flags=NoValue;*     if (image_info->page != (char *) NULL)L       flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);%     if (image->page != (char *) NULL)eG       flags=XParseGeometry(image->page,&x,&y,&page_width,&page_height); *     if (((page_width-(x << 1)) < width) ||4         ((page_height-(y << 1)-text_size) < height))       {a         unsigned long(           scale_factor;s  
         /*2           Scale image relative to Postscript page.
         */8         scale_factor=UpShift(page_width-(x << 1))/width;L         if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))F           scale_factor=UpShift(page_height-(y << 1)-text_size)/height;,         width=DownShift(width*scale_factor);.         height=DownShift(height*scale_factor);       }i     if ((flags & XValue) == 0)       { 
         /**           Center image in the X direction.
         */,         delta_x=page_width-(width+(x << 1));         if (delta_x >= 0)s           x=(delta_x >> 1)+x;)       }v     if ((flags & YValue) == 0)       {s
         /**           Center image in the X direction.
         */8         delta_y=page_height-(height+(y << 1))-text_size;         if (delta_y >= 0)e           y=(delta_y >> 1)+y;)       }v     /*&       Scale relative to dots-per-inch.     */     dx_resolution=72.0;c     dy_resolution=72.0;)     x_resolution=72.0;H     count=sscanf(PSDensityGeometry,"%fx%f",&x_resolution,&y_resolution);-     if (image_info->density != (char *) NULL)mL       count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);     if (count != 2)L        y_resolution=x_resolution;D     width=(unsigned int) (((width*dx_resolution)/x_resolution)+0.5);F     height=(unsigned int) (((height*dy_resolution)/y_resolution)+0.5);     if (page == 1)       {f
         /*#           Output Postscript header.-
         */2         if (strcmp(image_info->magick,"PS2") == 0):           (void) fprintf(image->file,"%%!PS-Adobe-3.0\n");         elseC           (void) fprintf(image->file,"%%!PS-Adobe-3.0 EPSF-3.0\n"); C         (void) fprintf(image->file,"%%%%Creator: (ImageMagick)\n"); H         (void) fprintf(image->file,"%%%%Title: (%s)\n",image->filename);$         timer=time((time_t *) NULL);!         (void) localtime(&timer); *         (void) strcpy(date,ctime(&timer));"         date[strlen(date)-1]='\0';D         (void) fprintf(image->file,"%%%%CreationDate: (%s)\n",date);         bounding_box.x1=x;         bounding_box.y1=y;(         bounding_box.x2=x+(int) width-1;5         bounding_box.y2=y+(int) (height+text_size)-1; B         if (image_info->adjoin && (image->next != (Image *) NULL))C           (void) fprintf(image->file,"%%%%BoundingBox: (atend)\n");(         elseF           (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",M             bounding_box.x1,bounding_box.y1,bounding_box.x2,bounding_box.y2); *         if (image->label != (char *) NULL)%           (void) fprintf(image->file, J             "%%%%DocumentNeededResources: font NewCenturySchlbk-Roman\n");=         (void) fprintf(image->file,"%%%%LanguageLevel: 2\n");m2         if (strcmp(image_info->magick,"PS2") != 0)7           (void) fprintf(image->file,"%%%%Pages: 0\n");%         else           {%             Image%              *next_image;                unsigned int               pages;               /**               Compute the number of pages.             */F             (void) fprintf(image->file,"%%%%Orientation: Portrait\n");B             (void) fprintf(image->file,"%%%%PageOrder: Ascend\n");             pages=1;#             if (image_info->adjoin) J               for (next_image=image->next; next_image != (Image *) NULL; )               { ,                 next_image=next_image->next;                 pages++;               } @             (void) fprintf(image->file,"%%%%Pages: %u\n",pages);           }%8         (void) fprintf(image->file,"%%%%EndComments\n");<         (void) fprintf(image->file,"\n%%%%BeginDefaults\n");F         (void) fprintf(image->file,"%%%%PageOrientation: Portrait\n");:         (void) fprintf(image->file,"%%%%EndDefaults\n\n");
         /*%           Output Postscript commands. 
         */#         for (q=Postscript; *q; q++) 0           (void) fprintf(image->file,"%s\n",*q);2         if (strcmp(image_info->magick,"PS2") == 0)5           (void) fprintf(image->file,"  showpage\n");i3         (void) fprintf(image->file,"} bind def\n");i6         (void) fprintf(image->file,"%%%%EndProlog\n");       }e;     (void) fprintf(image->file,"%%%%Page:  1 %u\n",page++);)H     (void) fprintf(image->file,"%%%%PageBoundingBox: %d %d %d %d\n",x,y,4       x+(int) width-1,y+(int) (height+text_size)-1);     if (x < bounding_box.x1)       bounding_box.x1=x;     if (y < bounding_box.y1)       bounding_box.y1=y;,     if ((x+(int) width-1) > bounding_box.x2)&       bounding_box.x2=x+(int) width-1;9     if ((y+(int) (height+text_size)-1) > bounding_box.y2)e3       bounding_box.y2=y+(int) (height+text_size)-1;c&     if (image->label != (char *) NULL)!       (void) fprintf(image->file,C<         "%%%%PageResources: font NewCenturySchlbk-Roman\n");.     if (strcmp(image_info->magick,"PS2") != 0)5       (void) fprintf(image->file,"userdict begin\n");)3     (void) fprintf(image->file,"%%%%BeginData:\n"); 1     (void) fprintf(image->file,"DisplayImage\n");      /*       Output image data.     *//     image->compression=image_info->compression;      CompressImage(image);      label=image->label;=     if (label == (char *) NULL))       label=" ";     (void) fprintf(image->file, J       "%d %d\n%u %u\n%d\n%s           \n%u %u\n%u\n%d\n",x,y,width,height,=       image_info->pointsize,label,image->columns,image->rows, @       IsPseudoClass(image),image->compression == NoCompression);     p=image->pixels;5     if (!IsPseudoClass(image) && !IsGrayImage(image)) !       switch (image->compression)        {n)         case RunlengthEncodedCompression:a         default:	         {;            register unsigned char             *q;              /*!             Allocate pixel array.%           */6           number_packets=3*image->columns*image->rows;P           pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));/           if (pixels == (unsigned char *) NULL) =             PrematureExit("Unable to allocate memory",image);            /*(             Dump Packbit encoded pixels.           */           q=pixels; ,           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)
             { <               if (image->matte && (p->index == Transparent))                 { )                   *q++=DownScale(MaxRGB); )                   *q++=DownScale(MaxRGB);%)                   *q++=DownScale(MaxRGB);                  }E               else                 {d)                   *q++=DownScale(p->red);W+                   *q++=DownScale(p->green);=*                   *q++=DownScale(p->blue);                 }p
             }s             p++;%             if (QuantumTick(i,image))e>               ProgressMonitor(SaveImageText,i,image->packets);           }rC           (void) LZWEncodeImage(image->file,pixels,number_packets);i            free((char *) pixels);           break;	         }o         case NoCompression: 	         {            /*2             Dump uncompressed DirectColor packets.           */           Ascii85Initialize();,           for (i=0; i < image->packets; i++)           {a2             for (j=0; j <= ((int) p->length); j++)
             {n<               if (image->matte && (p->index == Transparent))                 {,?                   Ascii85Encode(DownScale(MaxRGB),image->file);)?                   Ascii85Encode(DownScale(MaxRGB),image->file); ?                   Ascii85Encode(DownScale(MaxRGB),image->file);                  }0               else                 {_?                   Ascii85Encode(DownScale(p->red),image->file);iA                   Ascii85Encode(DownScale(p->green),image->file);e@                   Ascii85Encode(DownScale(p->blue),image->file);                 }e
             }              p++;%             if (QuantumTick(i,image))M>               ProgressMonitor(SaveImageText,i,image->packets);           }o$           Ascii85Flush(image->file);           break;	         }m       }L     else5       if (IsGrayImage(image) && (image->colors == 2)) 	         {e            register unsigned char             bit,             byte,              polarity;m             polarity=SJ             Intensity(image->colormap[0]) < Intensity(image->colormap[1]);           bit=0;           byte=0;e,           (void) fprintf(image->file,"0\n");%           switch (image->compression)            {s-             case RunlengthEncodedCompression:>             default:
             {m$               register unsigned char                 *q;0                 /*%                 Allocate pixel array.e               */C               number_packets=((image->columns+7) >> 3)*image->rows; &               pixels=(unsigned char *)=                 malloc(number_packets*sizeof(unsigned char)); 3               if (pixels == (unsigned char *) NULL)vA                 PrematureExit("Unable to allocate memory",image);t               /*.                 Dump Runlength encoded pixels.               */               q=pixels;_0               for (i=0; i < image->packets; i++)               {%4                 for (j=0; j <= (int) p->length; j++)                 {                    byte<<=1; +                   if (p->index == polarity)                      byte|=0x01;                    bit++;                   if (bit == 8)                      {                         *q++=byte;                       bit=0;                       byte=0;                      }                    x++;*                   if (x == image->columns)                     {                        /*5                         Advance to the next scanline.                        */#                       if (bit != 0) -                         *q++=byte << (8-bit);%                       bit=0;                       byte=0;n                       x=0;                       y++;                    }                 }                  p++;)                 if (QuantumTick(i,image))sB                   ProgressMonitor(SaveImageText,i,image->packets);               }sG               (void) LZWEncodeImage(image->file,pixels,number_packets); $               free((char *) pixels);               break;
             }i             case NoCompression:.
             {a               /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();0               for (i=0; i < image->packets; i++)               {e4                 for (j=0; j <= (int) p->length; j++)                 {                    byte<<=1; +                   if (p->index == polarity)a                     byte|=0x01;-                   bit++;                   if (bit == 8)                      { 6                       Ascii85Encode(byte,image->file);                       bit=0;                       byte=0;,                     }m                   x++;*                   if (x == image->columns)                     {-                       /*5                         Advance to the next scanline.                        */#                       if (bit != 0)vC                         Ascii85Encode(byte << (8-bit),image->file);                        bit=0;                       byte=0;m                       x=0;                       y++;                    }                 }g                 p++;)                 if (QuantumTick(i,image))aB                   ProgressMonitor(SaveImageText,i,image->packets);               }%(               Ascii85Flush(image->file);               break;
             }            } 	         } 
       else	         {            /*/             Dump number of colors and colormap.            */;           (void) fprintf(image->file,"%u\n",image->colors); +           for (i=0; i < image->colors; i++) 8             (void) fprintf(image->file,"%02x%02x%02x\n",0               DownScale(image->colormap[i].red),2               DownScale(image->colormap[i].green),2               DownScale(image->colormap[i].blue));%           switch (image->compression)            { -             case RunlengthEncodedCompression:              default:
             {%$               register unsigned char                 *q;                  /*%                 Allocate pixel array.n               */8               number_packets=image->columns*image->rows;&               pixels=(unsigned char *)=                 malloc(number_packets*sizeof(unsigned char)); 3               if (pixels == (unsigned char *) NULL) A                 PrematureExit("Unable to allocate memory",image);m               /*.                 Dump Runlength encoded pixels.               */               q=pixels;I0               for (i=0; i < image->packets; i++)               {t4                 for (j=0; j <= (int) p->length; j++)0                   *q++=(unsigned char) p->index;                 p++;)                 if (QuantumTick(i,image))mB                   ProgressMonitor(SaveImageText,i,image->packets);               } G               (void) LZWEncodeImage(image->file,pixels,number_packets);%$               free((char *) pixels);               break;
             }              case NoCompression: 
             {                /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();0               for (i=0; i < image->packets; i++)               { 6                 for (j=0; j <= ((int) p->length); j++)F                   Ascii85Encode((unsigned char) p->index,image->file);                 p++;)                 if (QuantumTick(i,image)) B                   ProgressMonitor(SaveImageText,i,image->packets);               }%(               Ascii85Flush(image->file);               break;
             }t           }m	         }a%     (void) fprintf(image->file,"\n");c0     (void) fprintf(image->file,"%%%%EndData\n");.     if (strcmp(image_info->magick,"PS2") != 0)*       (void) fprintf(image->file,"end\n");4     (void) fprintf(image->file,"%%%%PageTrailer\n");&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);f.   (void) fprintf(image->file,"%%%%Trailer\n");   if (page > 1)I@     (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",G       bounding_box.x1,bounding_box.y1,bounding_box.x2,bounding_box.y2); *   (void) fprintf(image->file,"%%%%EOF\n");   CloseImage(image);   return(True);  }s f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %eO %                                                                             %gO %                                                                             % O %   W r i t e R A D I A N C E I m a g e                                       %nO %                                                                             % O %                                                                             %)O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %zL %  Function WriteRADIANCEImage writes an image in the RADIANCE encoded image
 %  format. %e3 %  The format of the WriteRADIANCEImage routine is:  %l2 %      status=WriteRADIANCEImage(image_info,image) % + %  A description of each parameter follows.& %pO %    o status: Function WriteRADIANCEImage return True if the image is written.eK %      False is returned is there is a memory shortage or if the image file< %      fails to write. %aA %    o image_info: Specifies a pointer to an ImageInfo structure.n % . %    o image:  A pointer to a Image structure. %m %  */C static unsigned int WriteRADIANCEImage(const ImageInfo *image_info,x   Image *image)  {    unsigned int     status;a  :   Warning("Cannot write RADIANCE images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);n }f i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e R G B I m a g e                                                 %hO %                                                                             % O %                                                                             %eO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function WriteRGBImage writes an image to a file in red, green, and %  blue rasterfile format. %*. %  The format of the WriteRGBImage routine is: %h- %      status=WriteRGBImage(image_info,image)( %g+ %  A description of each parameter follows.  %aJ %    o status: Function WriteRGBImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file7 %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.p %i. %    o image:  A pointer to a Image structure. %& %s */K static unsigned int WriteRGBImage(const ImageInfo *image_info,Image *image)h {*   register int     i,     j;     register RunlengthPacket     *p;a     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*&     Convert MIFF to RGB raster pixels.   */,   if (strcmp(image_info->magick,"RGB") == 0)     image->matte=False;     switch (image_info->interlace)   {n     case NoneInterlace:v     default:     {i       /*.         No interlacing:  RGBRGBRGBRGBRGBRGB...       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {(.         for (j=0; j <= ((int) p->length); j++)	         { #           WriteQuantumFile(p->red);.%           WriteQuantumFile(p->green);>$           WriteQuantumFile(p->blue);           if (image->matte)n'             WriteQuantumFile(p->index);t	         }v         p++;!         if (QuantumTick(i,image))i:           ProgressMonitor(SaveImageText,i,image->packets);       }'       break;     }/     case LineInterlace:/     {        register int
         x,
         y;         /*?         Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...v       */"       if (!UncompressImage(image))         return(False);%       for (y=0; y < image->rows; y++)        {)+         p=image->pixels+(y*image->columns);r*         for (x=0; x < image->columns; x++)	         {)#           WriteQuantumFile(p->red);)           p++;	         }b+         p=image->pixels+(y*image->columns);=*         for (x=0; x < image->columns; x++)	         {)%           WriteQuantumFile(p->green);t           p++;	         } +         p=image->pixels+(y*image->columns);l*         for (x=0; x < image->columns; x++)	         {-$           WriteQuantumFile(p->blue);           p++;	         } +         p=image->pixels+(y*image->columns);"         if (image->matte)),           for (x=0; x < image->columns; x++)           {f'             WriteQuantumFile(p->index);e             p++;           }-5         ProgressMonitor(SaveImageText,y,image->rows);"       };       break;     }      case PlaneInterlace:     {r       /*7         Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {h.         for (j=0; j <= ((int) p->length); j++)#           WriteQuantumFile(p->red);)         p++;       } -       ProgressMonitor(SaveImageText,100,400);        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)%           WriteQuantumFile(p->green);%         p++;       } -       ProgressMonitor(SaveImageText,200,400);m       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)$           WriteQuantumFile(p->blue);         p++;       }m-       ProgressMonitor(SaveImageText,300,400);        p=image->pixels;       if (image->matte) *         for (i=0; i < image->packets; i++)	         {]0           for (j=0; j <= ((int) p->length); j++)'             WriteQuantumFile(p->index);            p++;	         }i-       ProgressMonitor(SaveImageText,400,400);        break;     }i   }>   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %sO %                                                                             % O %                                                                             % O %   W r i t e R L A I m a g e                                                 %uO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteRLAImage writes an image in the Alias/Wavefront encoded image
 %  format. % . %  The format of the WriteRLAImage routine is: %n- %      status=WriteRLAImage(image_info,image)) % + %  A description of each parameter follows.  %fJ %    o status: Function WriteRLAImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image fileh %      fails to write. %rA %    o image_info: Specifies a pointer to an ImageInfo structure." % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteRLAImage(const ImageInfo *image_info,Image *image)% {%   unsigned int     status;   5   Warning("Cannot write RLA images",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e R L E I m a g e                                                 % O %                                                                             %%O %                                                                             %hO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %oN %  Function WriteRLEImage writes an image in the Utah Run length encoded image
 %  format. %l. %  The format of the WriteRLEImage routine is: %t- %      status=WriteRLEImage(image_info,image)  %i+ %  A description of each parameter follows.o %rJ %    o status: Function WriteRLEImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. %eA %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteRLEImage(const ImageInfo *image_info,Image *image), {    char     command[MaxTextLength];n     Image      *flipped_image;      ImageInfo 
     rle_info;      unsigned int     packet_size,     status;n     /*     Flip image.m   */   image->orphan=True;;!   flipped_image=FlipImage(image);    image->orphan=False;&   if (flipped_image == (Image *) NULL)0     PrematureExit("Unable to flip image",image);   rle_info=(*image_info); #   rle_info.interlace=NoneInterlace; -   TemporaryFilename(flipped_image->filename);l0   status=WriteRGBImage(&rle_info,flipped_image);
   if (status)l     {        packet_size=3;       if (image->matte)i         packet_size=4;E       (void) sprintf(command,"rawtorle -w %u -h %u -n %u -o %s %s\n", D         image->columns,image->rows,packet_size,image_info->filename,!         flipped_image->filename);a$       status=SystemCommand(command);-       (void) remove(flipped_image->filename); .       if (!IsAccessible(image_info->filename))2         Warning("RLE translation failed",command);     }z   DestroyImage(flipped_image);   return(status);g }  g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%=O %                                                                             % O %                                                                             % O %                                                                             %hO %   W r i t e S G I I m a g e                                                 % O %                                                                             %gO %                                                                             %lO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function WriteSGIImage writes an image in SGI RGB encoded image format. %c. %  The format of the WriteSGIImage routine is: %l- %      status=WriteSGIImage(image_info,image)  % + %  A description of each parameter follows.a %+J %    o status: Function WriteSGIImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filen %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.r %1. %    o image:  A pointer to a Image structure. %o %, */  5 static int SGIEncode(unsigned char *pixels,int count,i   unsigned char *packets)r {(   shorte     runlength;     unsigned char      *limit,r
     *mark,     *p,t     *q;d     p=pixels;f   limit=p+count*4;   q=packets;   while (p < limit)r   {i     mark=p; 	     p+=8;tA     while ((p < limit) && ((*(p-8) != *(p-4)) || (*(p-4) != *p)))r       p+=4;(	     p-=8;t     count=((p-mark) >> 2);     while (count)t     {o*       runlength=count > 126 ? 126 : count;       count-=runlength;l       *q++=0x80 | runlength;)       for ( ; runlength > 0; runlength--)n       {          *q++=(*mark);          mark+=4;       }.     }/     mark=p;o	     p+=4;n(     while ((p < limit) && (*p == *mark))       p+=4;f     count=((p-mark) >> 2);     while (count)      {t*       runlength=count > 126 ? 126 : count;       count-=runlength;6       *q++=runlength;o       *q++=(*mark);_     }p   } 	   *q++=0;e   return(q-packets); }&  K static unsigned int WriteSGIImage(const ImageInfo *image_info,Image *image)  {    typedef struct _SGIHeaderm   {.     unsigned short       magic;       unsigned char)       storage,       bytes_per_pixel;       unsigned short       dimension,       columns,       rows,i       depth;       unsigned longx       minimum_value,       maximum_value;       unsigned char.       filler[492];   } SGIHeader;     SGIHeadern     iris_header;     register int     i,     j,     x,     y,     z;     register RunlengthPacket     *p;,     register unsigned char     *q;      unsigned charf     *iris_pixels,e
     *packets;a     /*     Open output image file.r   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)h/     PrematureExit("Unable to open file",image);U   do   {      /*(       Initialize SGI raster file header.     */     iris_header.magic=0x01DA;l/     image->compression=image_info->compression;D,     if (image->compression == NoCompression)       iris_header.storage=0x00;      else       iris_header.storage=0x01; <     iris_header.bytes_per_pixel=1;  /* one byte per pixel */     iris_header.dimension=3;'     iris_header.columns=image->columns; !     iris_header.rows=image->rows;s+     iris_header.depth=image->matte ? 4 : 3;      if (IsGrayImage(image))a       {           iris_header.dimension=2;         iris_header.depth=1;       }       iris_header.minimum_value=0;%     iris_header.maximum_value=MaxRGB; 2     for (i=0; i < sizeof(iris_header.filler); i++)       iris_header.filler[i]=0;     /*       Write SGI header.>     */6     MSBFirstWriteShort(iris_header.magic,image->file);2     (void) fputc(iris_header.storage,image->file);:     (void) fputc(iris_header.bytes_per_pixel,image->file);:     MSBFirstWriteShort(iris_header.dimension,image->file);8     MSBFirstWriteShort(iris_header.columns,image->file);5     MSBFirstWriteShort(iris_header.rows,image->file);36     MSBFirstWriteShort(iris_header.depth,image->file);=     MSBFirstWriteLong(iris_header.minimum_value,image->file);;=     MSBFirstWriteLong(iris_header.maximum_value,image->file); O     (void) fwrite(iris_header.filler,1,sizeof(iris_header.filler),image->file);      /*       Allocate SGI pixels.     */!     iris_pixels=(unsigned char *)oA       malloc(4*image->columns*image->rows*sizeof(unsigned char));d.     if (iris_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*C       Convert runlength-encoded packets to uncompressed SGI pixels.      */     x=0;     y=0;     p=image->pixels;?     q=iris_pixels+(iris_header.rows-1)*(iris_header.columns*4); &     for (i=0; i < image->packets; i++)     {a,       for (j=0; j <= ((int) p->length); j++)       {          *q++=DownScale(p->red);f!         *q++=DownScale(p->green);           *q++=DownScale(p->blue);&         *q++=(unsigned char) p->index;         x++;          if (x == image->columns)           {              y++;K             q=iris_pixels+((iris_header.rows-1)-y)*(iris_header.columns*4);              x=0;           }P       }r
       p++;     } ,     if (image->compression == NoCompression)       {-         unsigned char            *scanline;  
         /*(           Write uncompressed SGI pixels.
         */"         scanline=(unsigned char *)<           malloc(iris_header.columns*sizeof(unsigned char));/         if (scanline == (unsigned char *) NULL)p;           PrematureExit("Unable to allocate memory",image); 3         for (z=0; z < (int) iris_header.depth; z++) 	         {e           q=iris_pixels+z;4           for (y=0; y < (int) iris_header.rows; y++)           { 9             for (x=0; x < (int) iris_header.columns; x++) 
             {e               scanline[x]=(*q);                q+=4; 
             } M             (void) fwrite(scanline,sizeof(unsigned char),iris_header.columns,                image->file);c           } =           ProgressMonitor(SaveImageText,z,iris_header.depth); 	         }          free(scanline);        }      else       {          unsigned long0           length,            number_packets,            offset,            *offsets,y           *runlength;i  
         /*F           Convert SGI uncompressed pixels to runlength-encoded pixels.
         */!         offsets=(unsigned long *)oK           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long)); K         packets=(unsigned char *) malloc(4*((iris_header.columns << 1)+10)*g-           image->rows*sizeof(unsigned char));c#         runlength=(unsigned long *)aK           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long)); 2         if ((offsets == (unsigned long *) NULL) ||2             (packets == (unsigned char *) NULL) ||2             (runlength == (unsigned long *) NULL));           PrematureExit("Unable to allocate memory",image); A         offset=512+4*((iris_header.rows*iris_header.depth) << 1);c         number_packets=0;x         q=iris_pixels;2         for (y=0; y < (int) iris_header.rows; y++)	         {(5           for (z=0; z < (int) iris_header.depth; z++)i           {e             length=)N               SGIEncode(q+z,(int) iris_header.columns,packets+number_packets);#             number_packets+=length;)1             offsets[y+z*iris_header.rows]=offset; 3             runlength[y+z*iris_header.rows]=length;              offset+=length;e           }g%           q+=(iris_header.columns*4);e<           ProgressMonitor(SaveImageText,y,iris_header.rows);	         } 
         /*N           Write out line start and length tables and runlength-encoded pixels.
         */F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)4           MSBFirstWriteLong(offsets[i],image->file);F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)6           MSBFirstWriteLong(runlength[i],image->file);P         (void) fwrite(packets,sizeof(unsigned char),number_packets,image->file);
         /*           Free memory.
         */         free(runlength);         free(packets);         free(offsets);       }      free(iris_pixels);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);u   CloseImage(image);   return(True);% }% % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e S U N I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             %%O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %aG %  Function WriteSUNImage writes an image in the SUN rasterfile format.t %W. %  The format of the WriteSUNImage routine is: %F- %      status=WriteSUNImage(image_info,image)o %a+ %  A description of each parameter follows.n %oJ %    o status: Function WriteSUNImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file. %      fails to write. %eA %    o image_info: Specifies a pointer to an ImageInfo structure.p %t. %    o image:  A pointer to a Image structure. %e %n */K static unsigned int WriteSUNImage(const ImageInfo *image_info,Image *image)u {a #define RMT_EQUAL_RGB  1 #define RMT_NONE  0  #define RMT_RAW  2 #define RT_STANDARD  1 #define RT_FORMAT_RGB  3     typedef struct _SUNHeadere   {i     unsigned longi       magic,       width,
       height,        depth,
       length,,       type,        maptype,       maplength;   } SUNHeader;     register int     i,     j,     x;     register RunlengthPacket     *p;i     SUNHeader,     sun_header;e     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {d     /*(       Initialize SUN raster file header.     */      sun_header.magic=0x59a66a95;$     sun_header.width=image->columns;"     sun_header.height=image->rows;P     sun_header.type=(image->class == DirectClass ? RT_FORMAT_RGB : RT_STANDARD);      sun_header.maptype=RMT_NONE;     sun_header.maplength=0;n5     if (!IsPseudoClass(image) && !IsGrayImage(image))        {a
         /*            Full color SUN raster.
         */2         sun_header.depth=(image->matte ? 32 : 24);L         sun_header.length=image->columns*image->rows*(image->matte ? 4 : 3);@         sun_header.length+=image->columns % 2 ? image->rows : 0;       }.     else5       if (IsGrayImage(image) && (image->colors == 2));	         {f           /*"             Monochrome SUN raster.           */           sun_header.depth=1; B           sun_header.length=((image->columns+7) >> 3)*image->rows;P           sun_header.length+=((image->columns/8)+(image->columns % 8 ? 1 : 0)) %              2 ? image->rows : 0;	         }f
       else	         {0           /*#             Colormapped SUN raster.n           */           sun_header.depth=8;)7           sun_header.length=image->columns*image->rows;;B           sun_header.length+=image->columns % 2 ? image->rows : 0;+           sun_header.maptype=RMT_EQUAL_RGB;e/           sun_header.maplength=image->colors*3;n	         }i     /*       Write SUN header.a     */4     MSBFirstWriteLong(sun_header.magic,image->file);4     MSBFirstWriteLong(sun_header.width,image->file);5     MSBFirstWriteLong(sun_header.height,image->file);;4     MSBFirstWriteLong(sun_header.depth,image->file);5     MSBFirstWriteLong(sun_header.length,image->file);f3     MSBFirstWriteLong(sun_header.type,image->file);f6     MSBFirstWriteLong(sun_header.maptype,image->file);8     MSBFirstWriteLong(sun_header.maplength,image->file);     /*(       Convert MIFF to SUN raster pixels.     */     p=image->pixels;     x=0;5     if (!IsPseudoClass(image) && !IsGrayImage(image))        {)
         /*6           Convert DirectClass packet to SUN RGB pixel.
         */*         for (i=0; i < image->packets; i++)	         {1.           for (j=0; j <= (int) p->length; j++)           {              if (image->matte) 1               (void) fputc(p->index,image->file);m8             (void) fputc(DownScale(p->red),image->file);:             (void) fputc(DownScale(p->green),image->file);9             (void) fputc(DownScale(p->blue),image->file);-             x++;$             if (x == image->columns)               {x.                 if ((image->columns % 2) != 0)A                   (void) fputc(0,image->file); /* pad scanline */M                 x=0;               })           }            p++;#           if (QuantumTick(i,image))i<             ProgressMonitor(SaveImageText,i,image->packets);	         }e       }e     else5       if (IsGrayImage(image) && (image->colors == 2))f	         {e            register unsigned char             bit,             byte,P             polarity;              /*@             Convert PseudoClass image to a SUN monochrome image.           */           polarity=mJ             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);           bit=0;           byte=0;i,           for (i=0; i < image->packets; i++)           {i0             for (j=0; j <= (int) p->length; j++)
             {N               byte<<=1;e'               if (p->index == polarity),                 byte|=0x01;-               bit++;               if (bit == 8)y                 {&1                   (void) fputc(byte,image->file);                    bit=0;                   byte=0;x                 }                x++;&               if (x == image->columns)                 {                    /*1                     Advance to the next scanline.                    */                   if (bit != 0) >                     (void) fputc(byte << (8-bit),image->file);+                   if ((((image->columns/8)+e>                       (image->columns % 8 ? 1 : 0)) % 2) != 0)D                     (void) fputc(0,image->file);  /* pad scanline */                   bit=0;                   byte=0;                    x=0;                }
             }/             p++;%             if (QuantumTick(i,image))f>               ProgressMonitor(SaveImageText,i,image->packets);           }Y	         })
       else	         {            /*"             Dump colormap to file.           */+           for (i=0; i < image->colors; i++)zH             (void) fputc(DownScale(image->colormap[i].red),image->file);+           for (i=0; i < image->colors; i++).J             (void) fputc(DownScale(image->colormap[i].green),image->file);+           for (i=0; i < image->colors; i++)"I             (void) fputc(DownScale(image->colormap[i].blue),image->file);*           /*@             Convert PseudoClass packet to SUN colormapped pixel.           */,           for (i=0; i < image->packets; i++)           {=0             for (j=0; j <= (int) p->length; j++)
             {e1               (void) fputc(p->index,image->file);l               x++;&               if (x == image->columns)                 {l0                   if ((image->columns % 2) != 0)D                     (void) fputc(0,image->file);  /* pad scanline */                   x=0;                 } 
             }f             p++;%             if (QuantumTick(i,image))r>               ProgressMonitor(SaveImageText,i,image->packets);           }<	         }R&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);f   CloseImage(image);   return(True);n }b t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%pO %                                                                             % O %                                                                             %eO %                                                                             %iO %   W r i t e T A R G A I m a g e                                             %/O %                                                                             %jO %                                                                             %>O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %fM %  Function WriteTARGAImage writes a image in the Truevision Targa rasterfile)
 %  format. %>0 %  The format of the WriteTARGAImage routine is: %>/ %      status=WriteTARGAImage(image_info,image)% %d+ %  A description of each parameter follows.  %aL %    o status: Function WriteTARGAImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file> %      fails to write. %fA %    o image_info: Specifies a pointer to an ImageInfo structure.v %). %    o image:  A pointer to a Image structure. %  %v */M static unsigned int WriteTARGAImage(const ImageInfo *image_info,Image *image)) {r #define TargaColormap 1a #define TargaRGB 2 #define TargaMonochrome 3n #define TargaRLEColormap  9g #define TargaRLERGB  10r #define TargaRLEMonochrome  11     typedef struct _TargaHeader"   {o     unsigned char        id_length,       colormap_type,       image_type;n       unsigned short       colormap_index,r       colormap_length;       unsigned char+       colormap_size;       unsigned short       x_origin,o       y_origin,        width,
       height;&       unsigned char        pixel_size,n       attributes;P   } TargaHeader;     Imagee     *flopped_image;g     int&
     count,     runlength;     register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q,P     *r;/  
   TargaHeaderv     targa_header;>     unsigned char      *targa_pixels;     /*     Open output image file.r   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)>/     PrematureExit("Unable to open file",image);a   do   {<     /*       Flop image.i     */     image->orphan=True; #     flopped_image=FlopImage(image);/     image->orphan=False;(     if (flopped_image == (Image *) NULL)2       PrematureExit("Unable to flop image",image);7     flopped_image->compression=image_info->compression;M!     CompressImage(flopped_image);r     /**       Initialize TARGA raster file header.     */     targa_header.id_length=0;t1     if (flopped_image->comments != (char *) NULL)lL       targa_header.id_length=Min((int) strlen(flopped_image->comments),255);!     targa_header.colormap_type=0; "     targa_header.colormap_index=0;#     targa_header.colormap_length=0;a!     targa_header.colormap_size=0;      targa_header.x_origin=0;     targa_header.y_origin=0;.     targa_header.width=flopped_image->columns;,     targa_header.height=flopped_image->rows;     targa_header.pixel_size=8;     targa_header.attributes=0;&     if (!IsPseudoClass(flopped_image))       { 
         /*"           Full color TARGA raster.
         */)         targa_header.image_type=TargaRGB;>F         if (flopped_image->compression == RunlengthEncodedCompression).           targa_header.image_type=TargaRLERGB;?         targa_header.pixel_size=flopped_image->matte ? 32 : 24;n       },     else       {(
         /*#           Colormapped TARGA raster.i
         */.         targa_header.image_type=TargaColormap;F         if (flopped_image->compression == RunlengthEncodedCompression)3           targa_header.image_type=TargaRLEColormap;-H         if (!IsGrayImage(flopped_image) || (flopped_image->colors != 2))           {c)             targa_header.colormap_type=1;g*             targa_header.colormap_index=0;?             targa_header.colormap_length=flopped_image->colors; *             targa_header.colormap_size=24;           }r         else           {i             /*&               Monochrome TARGA raster.             */4             targa_header.image_type=TargaMonochrome;J             if (flopped_image->compression == RunlengthEncodedCompression)9               targa_header.image_type=TargaRLEMonochrome;            }e       }      /*       Write TARGA header.      */<     (void) fputc((char) targa_header.id_length,image->file);@     (void) fputc((char) targa_header.colormap_type,image->file);=     (void) fputc((char) targa_header.image_type,image->file);e@     LSBFirstWriteShort(targa_header.colormap_index,image->file);A     LSBFirstWriteShort(targa_header.colormap_length,image->file); @     (void) fputc((char) targa_header.colormap_size,image->file);:     LSBFirstWriteShort(targa_header.x_origin,image->file);:     LSBFirstWriteShort(targa_header.y_origin,image->file);7     LSBFirstWriteShort(targa_header.width,image->file);,8     LSBFirstWriteShort(targa_header.height,image->file);=     (void) fputc((char) targa_header.pixel_size,image->file);m=     (void) fputc((char) targa_header.attributes,image->file);e$     if (targa_header.id_length != 0)N       (void) fwrite((char *) flopped_image->comments,1,targa_header.id_length,         image->file);.     /**       Convert MIFF to TARGA raster pixels.     */     count=(unsigned int)L       (targa_header.pixel_size*targa_header.width*targa_header.height) >> 3;B     if (flopped_image->compression == RunlengthEncodedCompression)       count+=(count/128)+1; G     targa_pixels=(unsigned char *) malloc(count*sizeof(unsigned char)); /     if (targa_pixels == (unsigned char *) NULL))?       PrematureExit("Unable to allocate memory",flopped_image);)7     p=flopped_image->pixels+(flopped_image->packets-1);      q=targa_pixels; &     if (!IsPseudoClass(flopped_image))       { 
         /*8           Convert DirectClass packet to TARGA RGB pixel.
         */F         if (flopped_image->compression != RunlengthEncodedCompression)4           for (i=0; i < flopped_image->packets; i++)           {g0             for (j=0; j <= (int) p->length; j++)
             {s&               *q++=DownScale(p->blue);'               *q++=DownScale(p->green); %               *q++=DownScale(p->red);y'               if (flopped_image->matte)                  *q++=p->index;
             }              p--;-             if (QuantumTick(i,flopped_image)) F               ProgressMonitor(SaveImageText,i,flopped_image->packets);           }[         else4           for (i=0; i < flopped_image->packets; i++)           {gH             for (runlength=p->length+1; runlength > 128; runlength-=128)
             {                *q++=0xff;&               *q++=DownScale(p->blue);'               *q++=DownScale(p->green); %               *q++=DownScale(p->red);n'               if (flopped_image->matte)i                 *q++=p->index;
             }n             r=q;$             *q++=0x80+(runlength-1);$             *q++=DownScale(p->blue);%             *q++=DownScale(p->green);o#             *q++=DownScale(p->red); %             if (flopped_image->matte)e               *q++=p->index;             if (runlength != 1)                p--;             else               { 8                 for ( ; i < flopped_image->packets; i++)                 {                    p--;=                   if ((p->length != 0) || (runlength == 128))                      break;*                   *q++=DownScale(p->blue);+                   *q++=DownScale(p->green); )                   *q++=DownScale(p->red); +                   if (flopped_image->matte) "                     *q++=p->index;                   runlength++;                 })                 *r=runlength-1;                } -             if (QuantumTick(i,flopped_image))nF               ProgressMonitor(SaveImageText,i,flopped_image->packets);           }        }      elseF       if (!IsGrayImage(flopped_image) || (flopped_image->colors != 2))	         {            unsigned char              *targa_colormap;             /*@             Dump colormap to file (blue, green, red byte order).           */*           if (flopped_image->colors > 256)P             QuantizeImage(flopped_image,256,8,image_info->dither,RGBColorspace);*           targa_colormap=(unsigned char *)I             malloc(3*targa_header.colormap_length*sizeof(unsigned char)); 7           if (targa_colormap == (unsigned char *) NULL) E             PrematureExit("Unable to allocate memory",flopped_image);            q=targa_colormap;i3           for (i=0; i < flopped_image->colors; i++)s           { <             *q++=DownScale(flopped_image->colormap[i].blue);=             *q++=DownScale(flopped_image->colormap[i].green); ;             *q++=DownScale(flopped_image->colormap[i].red);=           } 2           (void) fwrite((char *) targa_colormap,1,>             (int) 3*targa_header.colormap_length,image->file);(           free((char *) targa_colormap);           /*B             Convert PseudoClass packet to TARGA colormapped pixel.           */           q=targa_pixels;uH           if (flopped_image->compression != RunlengthEncodedCompression)6             for (i=0; i < flopped_image->packets; i++)
             { 2               for (j=0; j <= (int) p->length; j++)                 *q++=p->index;               p--;/               if (QuantumTick(i,flopped_image))yH                 ProgressMonitor(SaveImageText,i,flopped_image->packets);
             }            else6             for (i=0; i < flopped_image->packets; i++)
             { J               for (runlength=p->length+1; runlength > 128; runlength-=128)               {                  *q++=0xff;                 *q++=p->index;               }                r=q;&               *q++=0x80+(runlength-1);               *q++=p->index;!               if (runlength != 1)                  p--;               else                 {R:                   for ( ; i < flopped_image->packets; i++)                   {                      p--;?                     if ((p->length != 0) || (runlength == 128))i                       break;"                     *q++=p->index;                      runlength++;                   } !                   *r=runlength-1;=                 } /               if (QuantumTick(i,flopped_image))aH                 ProgressMonitor(SaveImageText,i,flopped_image->packets);
             }.	         } 
       else	         {=           unsigned int             polarity;c             /*B             Convert PseudoClass image to a TARGA monochrome image.           */           polarity=0;))           if (flopped_image->colors == 2) <             polarity=Intensity(flopped_image->colormap[0]) >4               Intensity(flopped_image->colormap[1]);H           if (flopped_image->compression != RunlengthEncodedCompression)6             for (i=0; i < flopped_image->packets; i++)
             { 2               for (j=0; j <= (int) p->length; j++)B                 *q++=p->index == polarity ? 0 : DownScale(MaxRGB);               p--;/               if (QuantumTick(i,flopped_image)) H                 ProgressMonitor(SaveImageText,i,flopped_image->packets);
             }            else6             for (i=0; i < flopped_image->packets; i++)
             {iJ               for (runlength=p->length+1; runlength > 128; runlength-=128)               {                  *q++=0xff;B                 *q++=p->index == polarity ? 0 : DownScale(MaxRGB);               }                r=q;&               *q++=0x80+(runlength-1);@               *q++=p->index == polarity ? 0 : DownScale(MaxRGB);!               if (runlength != 1)i                 p--;               else                 {g:                   for ( ; i < flopped_image->packets; i++)                   {a                     p--;?                     if ((p->length != 0) || (runlength == 128))f                       break;F                     *q++=p->index == polarity ? 0 : DownScale(MaxRGB);                      runlength++;                   }0!                   *r=runlength-1;C                 }r/               if (QuantumTick(i,flopped_image))eH                 ProgressMonitor(SaveImageText,i,flopped_image->packets);
             } 	         }fN     (void) fwrite((char *) targa_pixels,1,(int) (q-targa_pixels),image->file);      DestroyImage(flopped_image);      free((char *) targa_pixels);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);]   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-O %                                                                             %tO %                                                                             %aO %                                                                             %hO %   W r i t e T E X T I m a g e                                               %eO %                                                                             % O %                                                                             %nO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %eC %  Function WriteTEXTImage writes an image in the TEXT image forma.  % / %  The format of the WriteTEXTImage routine is:  % . %      status=WriteTEXTImage(image_info,image) %-+ %  A description of each parameter follows.e %HK %    o status: Function WriteTEXTImage return True if the image is written.cK %      False is returned is there is a memory shortage or if the image file  %      fails to write. %gA %    o image_info: Specifies a pointer to an ImageInfo structure.) %r. %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteTEXTImage(const ImageInfo *image_info,Image *image) {r   unsigned int     status;>  6   Warning("Cannot write TEXT images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);o }    #ifdef HasTIFF #include "tiffio.h"n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %lO %                                                                             % O %                                                                             %sO %   W r i t e T I F F I m a g e                                               %tO %                                                                             % O %                                                                             %xO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%> %gK %  Function WriteTIFFImage writes an image in the Tagged image file format.i %x/ %  The format of the WriteTIFFImage routine is:  % . %      status=WriteTIFFImage(image_info,image) % + %  A description of each parameter follows:  % L %    o status:  Function WriteTIFFImage return True if the image is written.I %      False is returned is there is of a memory shortage or if the image ) %      file cannot be opened for writing.) % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteTIFFImage(const ImageInfo *image_info,Image *image) {  #ifndef TIFFDefaultStripSizeM #define TIFFDefaultStripSize(tiff,request)  ((8*1024)/TIFFScanlineSize(tiff))  #endif     Image      encode_image;      intc
     flags,     sans_offset;     register RunlengthPacket     *p;8     register int     i,     j,     x,     y;     register unsigned char     *q;      TIFF
     *tiff;     uint16     compression,     photometric;     unsigned char      *scanline;     unsigned int     x_resolution,n     y_resolution;      unsigned short
     value;     /*     Open TIFF file.B   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);,.   if ((image->file != stdout) && !image->pipe)#     (void) remove(image->filename);i   else     {        /*8         Write standard output or pipe to temporary file.       */       encode_image=(*image);)       TemporaryFilename(image->filename);s       image->temporary=True;     }>   CloseImage(image);1   tiff=TIFFOpen(image->filename,WriteBinaryType);    if (tiff == (TIFF *) NULL)     return(False);   do   {      /*       Initialize TIFF fields.      */@     TIFFSetField(tiff,TIFFTAG_IMAGELENGTH,(uint32) image->rows);B     TIFFSetField(tiff,TIFFTAG_IMAGEWIDTH,(uint32) image->columns);/     TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,8);      if (image->depth == 16) 2       TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,16);      compression=COMPRESSION_LZW;     if (!image->matte)5       if (IsGrayImage(image) && (image->colors == 2)) *         compression=COMPRESSION_CCITTFAX4;/     image->compression=image_info->compression; ,     if (image->compression == NoCompression)#       compression=COMPRESSION_NONE; 7     TIFFSetField(tiff,TIFFTAG_COMPRESSION,compression);x5     if (!IsPseudoClass(image) && !IsGrayImage(image))b       {s
         /*!           Full color TIFF raster.)
         */$         photometric=PHOTOMETRIC_RGB;J         TIFFSetField(tiff,TIFFTAG_SAMPLESPERPIXEL,(image->matte ? 4 : 3));         if (image->matte)            {=             uint16               extra_samples,               sample_info[1];I               /*'               TIFF has a matte channel.a             */             extra_samples=1;2             sample_info[0]=EXTRASAMPLE_ASSOCALPHA;O             TIFFSetField(tiff,TIFFTAG_EXTRASAMPLES,extra_samples,&sample_info);s           }        }o     else       {a
         /*"           Colormapped TIFF raster.
         */(         photometric=PHOTOMETRIC_PALETTE;5         TIFFSetField(tiff,TIFFTAG_SAMPLESPERPIXEL,1);          if (IsGrayImage(image))x           {N             /*$               Grayscale TIFF raster.             *//             photometric=PHOTOMETRIC_MINISBLACK; #             if (image->colors == 2) 9               TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,1);            }        }s7     TIFFSetField(tiff,TIFFTAG_PHOTOMETRIC,photometric); ;     TIFFSetField(tiff,TIFFTAG_FILLORDER,FILLORDER_MSB2LSB); ?     TIFFSetField(tiff,TIFFTAG_ORIENTATION,ORIENTATION_TOPLEFT); @     TIFFSetField(tiff,TIFFTAG_PLANARCONFIG,PLANARCONFIG_CONTIG);+     TIFFSetField(tiff,TIFFTAG_ROWSPERSTRIP,00       TIFFDefaultStripSize(tiff,(uint32) (-1)));0     if (image_info->interlace == PlaneInterlace)       { F         TIFFSetField(tiff,TIFFTAG_PLANARCONFIG,PLANARCONFIG_SEPARATE);2         TIFFSetField(tiff,TIFFTAG_ROWSPERSTRIP,1);       } D     TIFFSetField(tiff,TIFFTAG_RESOLUTIONUNIT,(uint16) image->units);     flags=NoValue;-     if (image_info->density != (char *) NULL) I       flags=XParseGeometry(image_info->density,&sans_offset,&sans_offset, %         &x_resolution,&y_resolution);      if (flags & WidthValue) '       image->x_resolution=x_resolution;e     if (flags & HeightValue)'       image->y_resolution=y_resolution;I?     TIFFSetField(tiff,TIFFTAG_XRESOLUTION,image->x_resolution);;?     TIFFSetField(tiff,TIFFTAG_YRESOLUTION,image->y_resolution);(<     TIFFSetField(tiff,TIFFTAG_DOCUMENTNAME,image->filename);6     TIFFSetField(tiff,TIFFTAG_SOFTWARE,"ImageMagick");)     if (image->comments != (char *) NULL)xB       TIFFSetField(tiff,TIFFTAG_IMAGEDESCRIPTION,image->comments);     /*       Write image scanlines.     */>     scanline=(unsigned char *) malloc(TIFFScanlineSize(tiff));+     if (scanline == (unsigned char *) NULL)y7       PrematureExit("Unable to allocate memory",image);      p=image->pixels;     q=scanline;l     x=0;     y=0;'     if (photometric == PHOTOMETRIC_RGB) $       switch (image_info->interlace)       {a         case NoneInterlace:          default:	         { ,           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)
             {                /*H                 Convert DirectClass packets to contiguous RGB scanlines.               */%               WriteQuantum(p->red,q); '               WriteQuantum(p->green,q); &               WriteQuantum(p->blue,q);               if (image->matte) )                 WriteQuantum(p->index,q);x               x++;&               if (x == image->columns)                 { H                   if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                     break;                   q=scanline;                    x=0;                   y++;                 } 
             }l             p++;%             if (QuantumTick(i,image)) >               ProgressMonitor(SaveImageText,i,image->packets);           }r           break;	         }t         case PlaneInterlace:	         {s           /*;             Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...e           */           p=image->pixels;,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             {m%               WriteQuantum(p->red,q);m               x++;&               if (x == image->columns)                 {RH                   if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                     break;                   q=scanline;+                   x=0;                   y++;                 }p
             }              p++;           }i1           ProgressMonitor(SaveImageText,100,400);            p=image->pixels;           y=0;,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             { '               WriteQuantum(p->green,q);s               x++;&               if (x == image->columns)                 {mH                   if (TIFFWriteScanline(tiff,(char *) scanline,y,1) < 0)                     break;                   q=scanline;e                   x=0;                   y++;                 }0
             }-             p++;           } 1           ProgressMonitor(SaveImageText,200,400);>           p=image->pixels;           y=0;,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             { &               WriteQuantum(p->blue,q);               x++;&               if (x == image->columns)                 {>H                   if (TIFFWriteScanline(tiff,(char *) scanline,y,2) < 0)                     break;                   q=scanline;                    x=0;                   y++;                 }e
             }j             p++;           }r1           ProgressMonitor(SaveImageText,300,400);r           p=image->pixels;           y=0;           if (image->matte)C.             for (i=0; i < image->packets; i++)
             {)4               for (j=0; j <= ((int) p->length); j++)               { )                 WriteQuantum(p->index,q);                  x++;(                 if (x == image->columns)                   { J                     if (TIFFWriteScanline(tiff,(char *) scanline,y,3) < 0)                       break;                     q=scanline;"                     x=0;                     y++;                   }                }1               p++;
             }i1           ProgressMonitor(SaveImageText,400,400);t           break;	         }e       }>     else-       if (photometric == PHOTOMETRIC_PALETTE) 	         {l           unsigned short             *blue,             *green,l             *red;-             /*#             Allocate TIFF colormap.l           */O           blue=(unsigned short *) malloc(image->colors*sizeof(unsigned short));eP           green=(unsigned short *) malloc(image->colors*sizeof(unsigned short));N           red=(unsigned short *) malloc(image->colors*sizeof(unsigned short));2           if ((blue == (unsigned short *) NULL) ||3               (green == (unsigned short *) NULL) || /               (red == (unsigned short *) NULL))i=             PrematureExit("Unable to allocate memory",image);r           /*%             Initialize TIFF colormap.n           */+           for (i=0; i < image->colors; i++)            {NI             red[i]=(unsigned int) (image->colormap[i].red*65535L)/MaxRGB;xM             green[i]=(unsigned int) (image->colormap[i].green*65535L)/MaxRGB;gK             blue[i]=(unsigned int) (image->colormap[i].blue*65535L)/MaxRGB;            }n=           TIFFSetField(tiff,TIFFTAG_COLORMAP,red,green,blue);e           /*H             Convert PseudoClass packets to contiguous indexed scanlines.           */,           for (i=0; i < image->packets; i++)           {;0             for (j=0; j <= (int) p->length; j++)
             {>'               WriteQuantum(p->index,q);r               x++;&               if (x == image->columns)                 {oH                   if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                     break;                   q=scanline;>                   x=0;                   y++;                 } 
             }r             p++;%             if (QuantumTick(i,image)) >               ProgressMonitor(SaveImageText,i,image->packets);           }            free((char *) red);            free((char *) green);            free((char *) blue);	         } 
       else         if (image->colors > 2),           for (i=0; i < image->packets; i++)           {(0             for (j=0; j <= (int) p->length; j++)
             {n               /*N                 Convert PseudoClass packets to contiguous grayscale scanlines.               */,               WriteQuantum(Intensity(*p),q);               x++;&               if (x == image->columns)                 {%H                   if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                     break;                   q=scanline;                    x=0;                   y++;                 } 
             }              p++;%             if (QuantumTick(i,image)) >               ProgressMonitor(SaveImageText,i,image->packets);           }          else           { "             register unsigned char               bit,               byte,                polarity;                /*M               Convert PseudoClass packets to contiguous monochrome scanlines.              */             polarity=0;%#             if (image->colors == 2)%               polarity= N                 Intensity(image->colormap[0]) < Intensity(image->colormap[1]);             bit=0;             byte=0;              x=0;.             for (i=0; i < image->packets; i++)
             {i2               for (j=0; j <= (int) p->length; j++)               {                  byte<<=1;r)                 if (p->index == polarity)i                   byte|=0x01;d                 bit++;                 if (bit == 8)                    {                      *q++=byte;                     bit=0;                     byte=0;                    }                  x++;(                 if (x == image->columns)                   {o                     /*3                       Advance to the next scanline.d                     */!                     if (bit != 0)0+                       *q++=byte << (8-bit);iJ                     if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                       break;                     q=scanline;,                     bit=0;                     byte=0;t                     x=0;                     y++;                  }               }                p++;'               if (QuantumTick(i,image))n@                 ProgressMonitor(SaveImageText,i,image->packets);
             }s           }o     free((char *) scanline);$     if (image_info->verbose == True),       TIFFPrintDirectory(tiff,stderr,False);     TIFFWriteDirectory(tiff);p&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    (void) TIFFClose(tiff);r   if (image->temporary)      {n
       FILE         *file;  	       int 
         c;         /*7         Copy temporary file to standard output or pipe.        */1       file=fopen(image->filename,ReadBinaryType);         if (file == (FILE *) NULL)3         PrematureExit("Unable to open file",image);_       c=fgetc(file);       while (c != EOF)       {i)         (void) putc(c,encode_image.file);          c=fgetc(file);       }        (void) fclose(file);%       (void) remove(image->filename);i        CloseImage(&encode_image);     }    return(True);t }E #elseaL static unsigned int WriteTIFFImage(const ImageInfo *image_info,Image *image) {a   unsigned int     status;a  ;   Warning("TIFF library is not available",image->filename);c*   status=WriteMIFFImage(image_info,image);   return(status);s }l #endif e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             % O %                                                                             % O %                                                                             %(O %   W r i t e T I L E I m a g e                                               %iO %                                                                             %sO %                                                                             % O %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %tL %  Function WriteTILEImage writes an image in the TILE encoded image format. %-/ %  The format of the WriteTILEImage routine is:0 %0. %      status=WriteTILEImage(image_info,image) % + %  A description of each parameter follows.= %gK %    o status: Function WriteTILEImage return True if the image is written.cK %      False is returned is there is a memory shortage or if the image filea %      fails to write. %oA %    o image_info: Specifies a pointer to an ImageInfo structure.m %p. %    o image:  A pointer to a Image structure. %  %i */L static unsigned int WriteTILEImage(const ImageInfo *image_info,Image *image) {m   unsigned int     status;   6   Warning("Cannot write TILE images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);i }e l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%bO %                                                                             %rO %                                                                             %tO %                                                                             % O %   W r i t e U Y V Y I m a g e                                               %zO %                                                                             %eO %                                                                             %0O %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %FH %  Function WriteUYVYImage writes an image to a file in the digital UYVYL %  (16bit/pixel) format.  This format, used by AccomWSD, is not dramaticallyK %  higher quality than the 12bit/pixel YUV format, but has better locality.o %f/ %  The format of the WriteUYVYImage routine is:t %o. %      status=WriteUYVYImage(image_info,image) %r+ %  A description of each parameter follows.g % K %    o status: Function WriteUYVYImage return True if the image is written.oK %      False is returned is there is a memory shortage or if the image file  %      fails to write. %aA %    o image_info: Specifies a pointer to an ImageInfo structure.  %S. %    o image:  A pointer to a Image structure.6 %      Implicit assumption: number of columns is even. %) */L static unsigned int WriteUYVYImage(const ImageInfo *image_info,Image *image) {p   register int     i,     j;     register RunlengthPacket     *p;m     unsigned int	     full,      y,     u,     v;     /*     Open output image file.0   */   if (!UncompressImage(image))     return(False);.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)S/     PrematureExit("Unable to open file",image);>   /*'     Convert to YUV, at full resolution.i   */+   RGBTransformImage(image,YCbCrColorspace);f   /*'     Accumulate two pixels, then output.o   */
   full=False;e   u=0;   v=0;   y=0;
   full=False;b
   full=False;l   p=image->pixels;$   for (i=0; i < image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)     {        if (full)i	         { A           (void) fputc(DownScale((u+p->green) >> 1),image->file);t1           (void) fputc(DownScale(y),image->file);t@           (void) fputc(DownScale((v+p->blue) >> 1),image->file);6           (void) fputc(DownScale(p->red),image->file);           full=False;_	         }>
       else	         {S           y=p->red;e           u=p->green;            v=p->blue;           full=True;	         }      }e     p++;     if (QuantumTick(i,image)).6       ProgressMonitor(SaveImageText,i,image->packets);   }o+   TransformRGBImage(image,YCbCrColorspace);n   return(True);  }m p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %gO %                                                                             %eO %                                                                             %SO %   W r i t e V I C A R I m a g e                                             %mO %                                                                             %>O %                                                                             % O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %aK %  Function WriteVICARImage writes an image in the VICAR rasterfile format.tN %  Vicar files contain a text header, followed by one or more planes of binaryM %  grayscale image data.  Vicar files are designed to allow many planes to beeK %  stacked together to form image cubes.  This routine only writes a single  %  grayscale plane.s %c6 %  Function WriteVICARImage was written contributed by %  gorelick@esther.la.asu.edu. % 0 %  The format of the WriteVICARImage routine is: %)/ %      status=WriteVICARImage(image_info,image)i %e+ %  A description of each parameter follows.c %gL %    o status: Function WriteVICARImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image fileF %      fails to write. %rA %    o image_info: Specifies a pointer to an ImageInfo structure.i %e. %    o image:  A pointer to a Image structure. %o %= */M static unsigned int WriteVICARImage(const ImageInfo *image_info,Image *image)e {t   char     header[MaxTextLength],     label[16];     int      label_size;      register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.(   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)E/     PrematureExit("Unable to open file",image);l   /*     Make a header.   */K   (void) sprintf(header,"LBLSIZE=            FORMAT='BYTE'  TYPE='IMAGE'"); H   (void) sprintf(header+strlen(header),"  BUFSIZE=20000  DIM=2  EOL=0");'   (void) sprintf(header+strlen(header), M     "  RECSIZE=%u  ORG='BSQ'  NL=%u  NS=%u  NB=1",image->columns,image->rows,d     image->columns);'   (void) sprintf(header+strlen(header),i.     "  N1=0  N2=0  N3=0  N4=0  NBB=0  NLB=0");?   (void) sprintf(header+strlen(header),"  TASK='ImageMagick'");e   /*"     Compute the size of the label.   */M   label_size=(strlen(header)+image->columns-1)/image->columns*image->columns;p(   (void) sprintf(label,"%d",label_size);*   for (i=0 ; i < (int) strlen(label); i++)     header[i+8]=label[i];    /*<     Print the header and enough spaces to pad to label size.   */8   (void) fprintf(image->file, "%-*s",label_size,header);   /*(     Convert MIFF to VICAR raster pixels.   */*   RGBTransformImage(image,GRAYColorspace);   p=image->pixels;$   for (i=0; i < image->packets; i++)   {)*     for (j=0; j <= ((int) p->length); j++)'       (void) fputc(p->red,image->file);f     p++;     if (QuantumTick(i,image))g6       ProgressMonitor(SaveImageText,i,image->packets);   }l   CloseImage(image);   return(True);e }h * /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%dO %                                                                             %%O %                                                                             % O %                                                                             % O %   W r i t e V I F F I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteVIFFImage writes an image to a file in the VIFF image format. %%/ %  The format of the WriteVIFFImage routine is:F %t. %      status=WriteVIFFImage(image_info,image) %e+ %  A description of each parameter follows.  %TK %    o status: Function WriteVIFFImage return True if the image is written.mK %      False is returned is there is a memory shortage or if the image fileo %      fails to write. %mA %    o image_info: Specifies a pointer to an ImageInfo structure.i %h. %    o image:  A pointer to a Image structure. %  %f */L static unsigned int WriteVIFFImage(const ImageInfo *image_info,Image *image) {  #define VFF_CM_genericRGB  15t #define VFF_CM_NONE  0 #define VFF_DEP_IEEEORDER  0x2 #define VFF_DES_RAW  0 #define VFF_LOC_IMPLICIT  1  #define VFF_MAPTYP_NONE  0 #define VFF_MAPTYP_1_BYTE  1 #define VFF_MS_NONE  0 #define VFF_MS_ONEPERBAND  1 #define VFF_TYP_BIT  0 #define VFF_TYP_1_BYTE  1      typedef struct _ViffHeader   {p     char       identifier,        file_type,       release,       version,       machine_dependency,        reserve[3],        comment[512];        unsigned long_       rows,i       columns,       subrows;       long       x_offset,m       y_offset;        unsigned int       x_pixel_size,e       y_pixel_size;        unsigned longu       location_type,       location_dimension,p       number_of_images,p       number_data_bands,       data_storage_type,       data_encode_scheme,U       map_scheme,E       map_storage_type,e       map_rows,        map_columns,       map_subrows,       map_enable,x       maps_per_cycle,s       color_space_model;   } ViffHeader;g     register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;n     unsigned charg     buffer[8],     *viff_pixels;d     unsigned long      packets;     ViffHeader     viff_header;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)r/     PrematureExit("Unable to open file",image);    do   {      /*&       Initialize VIFF image structure.     */'     viff_header.identifier=(char) 0xab;(     viff_header.file_type=1;     viff_header.release=1;     viff_header.version=3;O     viff_header.machine_dependency=VFF_DEP_IEEEORDER;  /* IEEE byte ordering */p     *viff_header.comment='\0';)     if (image->comments != (char *) NULL);       {i;         (void) strncpy(viff_header.comment,image->comments,i2           Min((int) strlen(image->comments),511));I         viff_header.comment[Min((int) strlen(image->comments),511)]='\0';n       }m$     viff_header.rows=image->columns;$     viff_header.columns=image->rows;     viff_header.subrows=0;     viff_header.x_offset=(~0);     viff_header.y_offset=(~0);     viff_header.x_pixel_size=0;Y     viff_header.y_pixel_size=0;>/     viff_header.location_type=VFF_LOC_IMPLICIT; %     viff_header.location_dimension=0;g#     viff_header.number_of_images=1;i/     viff_header.data_encode_scheme=VFF_DES_RAW; '     viff_header.map_scheme=VFF_MS_NONE; 1     viff_header.map_storage_type=VFF_MAPTYP_NONE;g     viff_header.map_rows=0;      viff_header.map_columns=0;     viff_header.map_subrows=0;0     viff_header.map_enable=1;  /* no colormap */!     viff_header.maps_per_cycle=0;t5     if (!IsPseudoClass(image) && !IsGrayImage(image));       { 
         /*!           Full color VIFF raster.o
         */;         viff_header.number_data_bands=image->matte ? 4 : 3;o8         viff_header.color_space_model=VFF_CM_genericRGB;5         viff_header.data_storage_type=VFF_TYP_1_BYTE; I         packets=image->columns*image->rows*viff_header.number_data_bands;i       }<     else       { (         viff_header.number_data_bands=1;2         viff_header.color_space_model=VFF_CM_NONE;5         viff_header.data_storage_type=VFF_TYP_1_BYTE;l+         packets=image->columns*image->rows;a          if (!IsGrayImage(image))           {=             /*&               Colormapped VIFF raster.             */5             viff_header.map_scheme=VFF_MS_ONEPERBAND;r;             viff_header.map_storage_type=VFF_MAPTYP_1_BYTE;p#             viff_header.map_rows=3;e2             viff_header.map_columns=image->colors;           }l         else!           if (image->colors == 2)i
             {h               /*'                 Monochrome VIFF raster.(               */8               viff_header.data_storage_type=VFF_TYP_BIT;<               packets=((image->columns+7) >> 3)*image->rows;
             }        }a     /*2       Write VIFF image header (pad to 1024 bytes).     */%     buffer[0]=viff_header.identifier;n$     buffer[1]=viff_header.file_type;"     buffer[2]=viff_header.release;"     buffer[3]=viff_header.version;-     buffer[4]=viff_header.machine_dependency; %     buffer[5]=viff_header.reserve[0]; %     buffer[6]=viff_header.reserve[1]; %     buffer[7]=viff_header.reserve[2];u3     (void) fwrite((char *) buffer,1,8,image->file);;B     (void) fwrite((char *) viff_header.comment,1,512,image->file);4     MSBFirstWriteLong(viff_header.rows,image->file);7     MSBFirstWriteLong(viff_header.columns,image->file); 7     MSBFirstWriteLong(viff_header.subrows,image->file);)H     MSBFirstWriteLong((unsigned long) viff_header.x_offset,image->file);H     MSBFirstWriteLong((unsigned long) viff_header.y_offset,image->file);L     MSBFirstWriteLong((unsigned long) viff_header.x_pixel_size,image->file);L     MSBFirstWriteLong((unsigned long) viff_header.y_pixel_size,image->file);=     MSBFirstWriteLong(viff_header.location_type,image->file); B     MSBFirstWriteLong(viff_header.location_dimension,image->file);@     MSBFirstWriteLong(viff_header.number_of_images,image->file);A     MSBFirstWriteLong(viff_header.number_data_bands,image->file);sA     MSBFirstWriteLong(viff_header.data_storage_type,image->file); B     MSBFirstWriteLong(viff_header.data_encode_scheme,image->file);:     MSBFirstWriteLong(viff_header.map_scheme,image->file);@     MSBFirstWriteLong(viff_header.map_storage_type,image->file);8     MSBFirstWriteLong(viff_header.map_rows,image->file);;     MSBFirstWriteLong(viff_header.map_columns,image->file); ;     MSBFirstWriteLong(viff_header.map_subrows,image->file); :     MSBFirstWriteLong(viff_header.map_enable,image->file);>     MSBFirstWriteLong(viff_header.maps_per_cycle,image->file);A     MSBFirstWriteLong(viff_header.color_space_model,image->file);g     for (i=0; i < 420; i++)g%       (void) fputc('\0',image->file);p     /*)       Convert MIFF to VIFF raster pixels.*     */H     viff_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char));.     if (viff_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image);x     p=image->pixels;     q=viff_pixels;5     if (!IsPseudoClass(image) && !IsGrayImage(image))>       {          unsigned longr           offset;n  
         /*7           Convert DirectClass packet to VIFF RGB pixel.i
         */*         offset=image->columns*image->rows;*         for (i=0; i < image->packets; i++)	         {=.           for (j=0; j <= (int) p->length; j++)           {r!             *q=DownScale(p->red);;,             *(q+offset)=DownScale(p->green);-             *(q+offset*2)=DownScale(p->blue);,             if (image->matte)i5               *(q+offset*3)=(unsigned char) p->index;a             q++;           }s           p++;#           if (QuantumTick(i,image))%<             ProgressMonitor(SaveImageText,i,image->packets);	         }%       }%     else       if (!IsGrayImage(image))	         {            unsigned char              *viff_colormap;              /*"             Dump colormap to file.           */)           viff_colormap=(unsigned char *) :             malloc(image->colors*3*sizeof(unsigned char));6           if (viff_colormap == (unsigned char *) NULL)=             PrematureExit("Unable to allocate memory",image);            q=viff_colormap;+           for (i=0; i < image->colors; i++) 3             *q++=DownScale(image->colormap[i].red); +           for (i=0; i < image->colors; i++) 5             *q++=DownScale(image->colormap[i].green);%+           for (i=0; i < image->colors; i++) 4             *q++=DownScale(image->colormap[i].blue);G           (void) fwrite((char *) viff_colormap,1,(int) image->colors*3,a             image->file);s'           free((char *) viff_colormap);)           /*B             Convert PseudoClass packet to VIFF colormapped pixels.           */           q=viff_pixels;,           for (i=0; i < image->packets; i++)           {e0             for (j=0; j <= (int) p->length; j++)               *q++=p->index;             p++;%             if (QuantumTick(i,image)) >               ProgressMonitor(SaveImageText,i,image->packets);           }g	         }g
       else         if (image->colors == 2)            {2"             register unsigned char               bit,               byte,                polarity;o               register int               x;               /*C               Convert PseudoClass image to a VIFF monochrome image.m             */             polarity=tL               Intensity(image->colormap[0]) > Intensity(image->colormap[1]);             x=0;             bit=0;             byte=0;e.             for (i=0; i < image->packets; i++)
             { 2               for (j=0; j <= (int) p->length; j++)               {T                 byte>>=1;o)                 if (p->index == polarity)a                   byte|=0x80;                  bit++;                 if (bit == 8))                   {                      *q++=byte;                     bit=0;                     byte=0;c                   }                  x++;(                 if (x == image->columns)                   {i                     /*3                       Advance to the next scanline.                      */!                     if (bit != 0) +                       *q++=byte >> (8-bit);e                     bit=0;                     byte=0;)                     x=0;                  }               }                p++;'               if (QuantumTick(i,image))m@                 ProgressMonitor(SaveImageText,i,image->packets);
             }l           }          else           {(             /*A               Convert PseudoClass packet to VIFF grayscale pixel.              */.             for (i=0; i < image->packets; i++)
             {t2               for (j=0; j <= (int) p->length; j++)                 *q++=p->red;               p++;'               if (QuantumTick(i,image))a@                 ProgressMonitor(SaveImageText,i,image->packets);
             }            } D     (void) fwrite((char *) viff_pixels,1,(int) packets,image->file);     free((char *) viff_pixels); &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);U   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%fO %                                                                             % O %                                                                             % O %                                                                             %,O %   W r i t e X I m a g e                                                     %,O %                                                                             % O %                                                                             %'O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %f7 %  Function WriteXImage writes an image to an X server.  %e, %  The format of the WriteXImage routine is: %r+ %      status=WriteXImage(image_info,image)s %++ %  A description of each parameter follows.) %>L %    o status: Function WriteXImage return True if the image is displayed onK %      the X server.  False is returned is there is a memory shortage or if % %      the image file fails to write.e %iA %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */I static unsigned int WriteXImage(const ImageInfo *image_info,Image *image); {    Atom     wm_delete_window,      wm_protocols;      char     name[MaxTextLength];  	   Display 
     *display;f     register char"     *p;R     unsigned int     status;g     XGCValues)     context_values;      XResourceInfoi     resource_info;  
   XrmDatabase      resource_database;     XEvent
     event;     XPixelInfo     pixel_info;      XStandardColormap      *map_info;  
   XVisualInfof     *visual_info;"  
   XWindowInfo      window_info;     /*     Open X server connection.;   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {;.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));        return(False);     }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);    /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) M     Warning("Unable to create standard colormap","Memory allocation failed");    /*     Initialize visual info.,   */?   visual_info=XBestVisualInfo(display,map_info,&resource_info); *   if (visual_info == (XVisualInfo *) NULL)>     Warning("Unable to get visual",resource_info.visual_type);%   map_info->colormap=(Colormap) NULL;i+   pixel_info.pixels=(unsigned long *) NULL; '   pixel_info.gamma_map=(XColor *) NULL;o1   if ((map_info == (XStandardColormap *) NULL) || ,       (visual_info == (XVisualInfo *) NULL))     { >       XFreeResources(display,visual_info,map_info,&pixel_info,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return(False);     }i   /*!     Initialize Standard Colormap.x   */)   ProgressMonitor(SaveImageText,100,400);8J   XMakeStandardColormap(display,visual_info,&resource_info,image,map_info,     &pixel_info);    /*%     Initialize window info structure.    */   window_info.id=(Window) NULL;aO   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,t!     &resource_info,&window_info);    window_info.name=name;.   p=image->filename+strlen(image->filename)-1;A   while ((p > image->filename) && (*(p-1) != *BasenameSeparator))e     p--;H   (void) sprintf(window_info.name,"ImageMagick: %s[%u]",p,image->scene);   if (image->scene == 0)9     (void) sprintf(window_info.name,"ImageMagick: %s",p);s#   window_info.width=image->columns; !   window_info.height=image->rows; C   window_info.attributes.event_mask=ButtonPressMask | ExposureMask; P   XMakeWindow(display,XRootWindow(display,visual_info->screen),(char **) NULL,0,8     (XClassHint *) NULL,(XWMHints *) NULL,&window_info);   window_info.x=0;   window_info.y=0;"   window_info.shared_memory=False;   /*     Graphic context.   */>   context_values.background=pixel_info.background_color.pixel;>   context_values.foreground=pixel_info.foreground_color.pixel;M   pixel_info.annotate_context=XCreateGC(display,window_info.id,GCBackground | "     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);;   window_info.annotate_context=pixel_info.annotate_context;i>   context_values.background=pixel_info.foreground_color.pixel;>   context_values.foreground=pixel_info.background_color.pixel;N   pixel_info.highlight_context=XCreateGC(display,window_info.id,GCBackground |"     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);=   window_info.highlight_context=pixel_info.highlight_context;-&   pixel_info.widget_context=(GC) NULL;'   window_info.widget_context=(GC) NULL;a   /*     Initialize X image.    */)   ProgressMonitor(SaveImageText,250,400);%M   status=XMakeImage(display,&resource_info,&window_info,image,image->columns,      image->rows);    if (status == False)     { >       XFreeResources(display,visual_info,map_info,&pixel_info,:         (XFontStruct *) NULL,&resource_info,&window_info);4       PrematureExit("Unable to make X image",image);     }    free((char *) image->pixels); )   image->pixels=(RunlengthPacket *) NULL; :   (void) XMakePixmap(display,&resource_info,&window_info);!   free(window_info.ximage->data); )   window_info.ximage->data=(char *) NULL;    /*4     Display image and wait for button press to exit.   */)   ProgressMonitor(SaveImageText,400,400);%9   wm_protocols=XInternAtom(display,"WM_PROTOCOLS",False);oA   wm_delete_window=XInternAtom(display,"WM_DELETE_WINDOW",False);L%   XMapWindow(display,window_info.id);e
   for ( ; ; )    {m     XNextEvent(display,&event);r"     if (event.type == ButtonPress)       break;$     if (event.type == ClientMessage)5       if (event.xclient.message_type == wm_protocols) 6         if (*event.xclient.data.l == wm_delete_window)5           if (event.xclient.window == window_info.id)n             break;     if (event.type == Expose)t2       XRefreshWindow(display,&window_info,&event);   }e=   XWithdrawWindow(display,window_info.id,window_info.screen);t   /*     Free X resources.%   */O   XFreeResources(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,a!     &resource_info,&window_info);e   return(True);e }n I /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %iO %                                                                             %rO %                                                                             %fO %   W r i t e X B M I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             %%O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %"L %  Procedure WriteXBMImage writes an image to a file in the X bitmap format. % . %  The format of the WriteXBMImage routine is: %/- %      status=WriteXBMImage(image_info,image){ % + %  A description of each parameter follows.  %eJ %    o status: Function WriteXBMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filel %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %}. %    o image:  A pointer to a Image structure. %, %  */K static unsigned int WriteXBMImage(const ImageInfo *image_info,Image *image)  {    char     name[MaxTextLength];     register int     i,     j,     x;     register char,     *q;      register RunlengthPacket     *p;e     register unsigned char     bit,	     byte,a
     polarity;e     unsigned int
     count;     /*     Open output image file.    */"   OpenImage(image_info,image,"w");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Write X bitmap header.   */&   (void) strcpy(name,image->filename);	   q=name;a%   while ((*q != '.') && (*q != '\0'))a     q++;   if (*q == '.')     *q='\0';J   (void) fprintf(image->file,"#define %s_width %u\n",name,image->columns);H   (void) fprintf(image->file,"#define %s_height %u\n",name,image->rows);A   (void) fprintf(image->file,"static char %s_bits[] = {\n",name);""   (void) fprintf(image->file," ");   /*$     Convert MIFF to X bitmap pixels.   */2   if (!IsGrayImage(image) || (image->colors != 2))     {oA       QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);p       SyncImage(image);"     } 
   polarity=0;e   if (image->colors == 2) K     polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);    bit=0;	   byte=0; 
   count=0;   x=0;   p=image->pixels;"   (void) fprintf(image->file," ");$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     {s       byte>>=1;1       if (p->index == polarity){         byte|=0x80;        bit++;       if (bit == 8)f	         {            /*2             Write a bitmap byte to the image file.           */N           (void) fprintf(image->file,"0x%02x, ",(unsigned int) (byte & 0xff));           count++;           if (count == 12)
             {%1               (void) fprintf(image->file,"\n  ");c               count=0;             };           bit=0;           byte=0;t	         } 
       x++;       if (x == image->columns)	         {o           if (bit != 0)s
             {e               /*6                 Write a bitmap byte to the image file.               */               byte>>=(8-bit);pB               (void) fprintf(image->file,"0x%02x, ",(unsigned int)                 (byte & 0xff));/               count++;               if (count == 12)                 { 5                   (void) fprintf(image->file,"\n  ");                    count=0;                 };               bit=0;               byte=0;d             };           x=0;	         }m     }e     p++;     if (QuantumTick(i,image))l6       ProgressMonitor(SaveImageText,i,image->packets);   } %   (void) fprintf(image->file,"};\n");b   CloseImage(image);   return(True);l }P e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %,O %                                                                             %uO %   W r i t e X C I m a g e                                                   %mO %                                                                             % O %                                                                             %/O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function WriteXCImage writes an image in the X constant image format. %"- %  The format of the WriteXCImage routine is:  %{, %      status=WriteXCImage(image_info,image) %s+ %  A description of each parameter follows.r %,I %    o status: Function WriteXCImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file, %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %k. %    o image:  A pointer to a Image structure. %u %  */J static unsigned int WriteXCImage(const ImageInfo *image_info,Image *image) {s   unsigned int     status;   4   Warning("Cannot write XC images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }  , /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%.O %                                                                             % O %                                                                             % O %                                                                             %gO %   W r i t e X P M I m a g e                                                 %eO %                                                                             % O %                                                                             % O %                                                                             %}O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%v % L %  Procedure WriteXPMImage writes an image to a file in the X pixmap format. %[. %  The format of the WriteXPMImage routine is: %w- %      status=WriteXPMImage(image_info,image){ %a+ %  A description of each parameter follows.e %"J %    o status: Function WriteXPMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filel %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %%. %    o image:  A pointer to a Image structure. %  %  */
 #ifdef HasXPMb #include "xpm.h"K static unsigned int WriteXPMImage(const ImageInfo *image_info,Image *image)s {_   char     *xpm_buffer;  	   DisplayE
     *display;o     intC     status;-     register charc     *p;e     XResourceInfo,     resource_info;  
   XrmDatabasei     resource_database;     XImage     *matte_image;f     XPixelInfo     pixel_info;f     XpmAttributesy     xpm_attributes;      XStandardColormapd     *map_info;  
   XVisualInfo      *visual_info;   
   XWindowInfoh     window_info;     /*     Open output image file.    */"   OpenImage(image_info,image,"w");#   if (image->file == (FILE *) NULL)f/     PrematureExit("Unable to open file",image);e   /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {p.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));r       return(False);     },   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);e   /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info); )   resource_info.colormap=PrivateColormap;;   /*     Allocate standard colormap.y   */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL);M     Warning("Unable to create standard colormap","Memory allocation failed");    /*     Initialize visual info.t   */?   visual_info=XBestVisualInfo(display,map_info,&resource_info);i*   if (visual_info == (XVisualInfo *) NULL)>     Warning("Unable to get visual",resource_info.visual_type);%   map_info->colormap=(Colormap) NULL; +   pixel_info.pixels=(unsigned long *) NULL;m'   pixel_info.gamma_map=(XColor *) NULL; 1   if ((map_info == (XStandardColormap *) NULL) ||o,       (visual_info == (XVisualInfo *) NULL))     {g>       XFreeResources(display,visual_info,map_info,&pixel_info,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return(False);     }h   matte_image=(XImage *) NULL;   if (image->matte),     {        /*         Create X shape image.        */H       matte_image=XCreateImage(display,visual_info->visual,1,XYBitmap,0,H         (char *) NULL,image->columns,image->rows,XBitmapPad(display),0);)       if (matte_image == (XImage *) NULL)l>         Warning("Unable to create matte image",(char *) NULL);
       else	         {m           /*(             Allocate X shape image data.           */$           matte_image->data=(char *)D             malloc(matte_image->bytes_per_line*matte_image->height);1           if (matte_image->data == (char *) NULL) O             Warning("Unable to create matte image","Memory allocation failed");n           else
             {l               int                  x,                 y;                 register int                 i,                 j;  &               register RunlengthPacket                 *p;>                 /*)                 Initialize X shape image.                */               x=0;               y=0;               p=image->pixels;0               for (i=0; i < image->packets; i++)               {a4                 for (j=0; j <= (int) p->length; j++)                 { M                   XPutPixel(matte_image,x,y,p->index == Transparent ? 0 : 1);                    x++;*                   if (x == image->columns)                     {                        x=0;                       y++;                     }                  }                  p++;               } 
             } 	         }      }    /*!     Initialize Standard Colormap.-   */)   ProgressMonitor(SaveImageText,100,400); =   if ((image->class == DirectClass) || (image->colors > 256))      {l       /**         Demote DirectClass to PseudoClass.       */B       QuantizeImage(image,256,8,image_info->dither,RGBColorspace);       SyncImage(image);&     }uJ   XMakeStandardColormap(display,visual_info,&resource_info,image,map_info,     &pixel_info);i(   pixel_info.annotate_context=(GC) NULL;)   pixel_info.highlight_context=(GC) NULL;o&   pixel_info.widget_context=(GC) NULL;   /*%     Initialize window info structure.0   */   window_info.id=(Window) NULL;hO   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL, !     &resource_info,&window_info); .   p=image->filename+strlen(image->filename)-1;2   while ((p > image->filename) && (*(p-1) != '/'))     p--;   window_info.name=p;l#   window_info.width=image->columns;i!   window_info.height=image->rows; P   XMakeWindow(display,XRootWindow(display,visual_info->screen),(char **) NULL,0,8     (XClassHint *) NULL,(XWMHints *) NULL,&window_info);"   window_info.shared_memory=False;   /*     Initialize X image.&   */)   ProgressMonitor(SaveImageText,250,400);)1   if (IsGrayImage(image) && (image->colors == 2))i     image->class=DirectClass;aM   status=XMakeImage(display,&resource_info,&window_info,image,image->columns,;     image->rows);b   if (status == False)     { >       XFreeResources(display,visual_info,map_info,&pixel_info,:         (XFontStruct *) NULL,&resource_info,&window_info);4       PrematureExit("Unable to make X image",image);     }    /*     Intialize XPM attributes.f   */H   xpm_attributes.valuemask=XpmColormap | XpmDepth | XpmSize | XpmVisual;,   xpm_attributes.visual=visual_info->visual;*   xpm_attributes.depth=visual_info->depth;-   xpm_attributes.colormap=map_info->colormap; &   xpm_attributes.width=image->columns;$   xpm_attributes.height=image->rows;I   status=XpmCreateBufferFromImage(display,&xpm_buffer,window_info.ximage,)!     matte_image,&xpm_attributes);e   /*     Free X resources.c   */%   if (matte_image != (XImage *) NULL)      XDestroyImage(matte_image);a%   XpmFreeAttributes(&xpm_attributes); O   XFreeResources(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL, !     &resource_info,&window_info);    if (status != XpmSuccess)b1     PrematureExit("Unable to write image",image);r   /*     Write XPM image.   */F   (void) fwrite((char *) xpm_buffer,1,strlen(xpm_buffer),image->file);   free((char *) xpm_buffer);   CloseImage(image);)   ProgressMonitor(SaveImageText,400,400);_   return(True);; }x #else K static unsigned int WriteXPMImage(const ImageInfo *image_info,Image *image)- {x   unsigned int     status;   :   Warning("XPM library is not available",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);e }i #endif C /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%vO %                                                                             %nO %                                                                             %SO %                                                                             % O %   W r i t e Y U V I m a g e                                                 %mO %                                                                             %eO %                                                                             %=O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %fF %  Function WriteYUVImage writes an image to a file in the digital YUV %  (CCIR 601 4:1:1) format.e %m. %  The format of the WriteYUVImage routine is: %Y- %      status=WriteYUVImage(image_info,image)_ %g+ %  A description of each parameter follows.0 % J %    o status: Function WriteYUVImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. %0A %    o image_info: Specifies a pointer to an ImageInfo structure.m %-. %    o image:  A pointer to a Image structure. %% %e */K static unsigned int WriteYUVImage(const ImageInfo *image_info,Image *image)a {>   Imagei     *reduced_image;      register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.-   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize Y channel.    */+   RGBTransformImage(image,YCbCrColorspace);+   p=image->pixels;$   for (i=0; i < image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)2       (void) fputc(DownScale(p->red),image->file);     p++;   }    /*     Scale image.   */)   ProgressMonitor(SaveImageText,100,400);v   image->orphan=True;e#   reduced_image=MinifyImage(image);    image->orphan=False;&   if (reduced_image == (Image *) NULL)1     PrematureExit("Unable to scale image",image);    /*     Initialize U channel.    */)   ProgressMonitor(SaveImageText,200,400);    p=reduced_image->pixels;,   for (i=0; i < reduced_image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)4       (void) fputc(DownScale(p->green),image->file);     p++;   }    /*     Initialize V channel.    */)   ProgressMonitor(SaveImageText,400,400);    p=reduced_image->pixels;,   for (i=0; i < reduced_image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)3       (void) fputc(DownScale(p->blue),image->file);      p++;   }    DestroyImage(reduced_image);+   TransformRGBImage(image,YCbCrColorspace);;)   ProgressMonitor(SaveImageText,400,400);    return(True);+ }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %tO %                                                                             % O %                                                                             %PO %   W r i t e Y U V 3 I m a g e                                               %)O %                                                                             %nO %                                                                             %)O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WriteYUV3Image writes an image to a file in the digital YUV;M %  (CCIR 601 4:1:1) format.  This function differs from WriteYUVImage in thatiK %  it write the Y, U, and V planes to separate files (image.Y, image.U, andn %  image.V). %t/ %  The format of the WriteYUV3Image routine is:  %a. %      status=WriteYUV3Image(image_info,image) % + %  A description of each parameter follows.- %aK %    o status: Function WriteYUV3Image return True if the image is written.iK %      False is returned is there is a memory shortage or if the image filet %      fails to write. %fA %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteYUV3Image(const ImageInfo *image_info,Image *image) {    char     filename[MaxTextLength];     Imageh     *reduced_image;      register int     i,     j;     register RunlengthPacket     *p;e     /*     Open output image file.    */*   (void) strcpy(filename,image->filename);'   if (strcmp(image->filename,"-") != 0)c(     (void) strcat(image->filename,".Y");.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)r/     PrematureExit("Unable to open file",image);o   /*     Write Y channel.   */+   RGBTransformImage(image,YCbCrColorspace);    p=image->pixels;$   for (i=0; i < image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)2       (void) fputc(DownScale(p->red),image->file);     p++;   }-   CloseImage(image);   /*     Scale image.   */)   ProgressMonitor(SaveImageText,100,400);n   image->orphan=True; #   reduced_image=MinifyImage(image);>   image->orphan=False;&   if (reduced_image == (Image *) NULL)2     PrematureExit("Unable to reduce image",image);   /*     Write U channel.   */)   ProgressMonitor(SaveImageText,200,400);-2   (void) strcpy(reduced_image->filename,filename);/   if (strcmp(reduced_image->filename,"-") != 0)e0     (void) strcat(reduced_image->filename,".U");6   OpenImage(image_info,reduced_image,WriteBinaryType);+   if (reduced_image->file == (FILE *) NULL)n     { "       DestroyImage(reduced_image);9       PrematureExit("Unable to open file",reduced_image);)     }    p=reduced_image->pixels;,   for (i=0; i < reduced_image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)<       (void) fputc(DownScale(p->green),reduced_image->file);     p++;   }r   CloseImage(reduced_image);   /*     Write V channel.   */)   ProgressMonitor(SaveImageText,300,400);)2   (void) strcpy(reduced_image->filename,filename);/   if (strcmp(reduced_image->filename,"-") != 0) 0     (void) strcat(reduced_image->filename,".V");6   OpenImage(image_info,reduced_image,WriteBinaryType);+   if (reduced_image->file == (FILE *) NULL)v     {r"       DestroyImage(reduced_image);9       PrematureExit("Unable to open file",reduced_image);n     }-   p=reduced_image->pixels;,   for (i=0; i < reduced_image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++);       (void) fputc(DownScale(p->blue),reduced_image->file);      p++;   }    CloseImage(reduced_image);   DestroyImage(reduced_image);+   TransformRGBImage(image,YCbCrColorspace);g+   (void) sprintf(image->filename,filename); )   ProgressMonitor(SaveImageText,400,400);    return(True);  }y   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %\O %                                                                             %sO %                                                                             %pO %   W r i t e X W D I m a g e                                                 %rO %                                                                             %yO %                                                                             % O %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%- %lD %  Function WriteXWDImage writes an image to a file in X window dump %  rasterfile format.i %". %  The format of the WriteXWDImage routine is: %c- %      status=WriteXWDImage(image_info,image)g %c+ %  A description of each parameter follows.( %gJ %    o status: Function WriteXWDImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. %*A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %m %- */K static unsigned int WriteXWDImage(const ImageInfo *image_info,Image *image)  {g   int)     x;     register int     i,     j,     k;     register RunlengthPacket     *p;p     unsigned int     bits_per_pixel,n     bytes_per_line,o     scanline_pad;+     unsigned long      lsb_first;     XWDFileHeader      xwd_header;      /*     Open output image file.r   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize XWD file header.-   */@   xwd_header.header_size=sz_XWDheader+strlen(image->filename)+1;;   xwd_header.file_version=(unsigned long) XWD_FILE_VERSION; 3   xwd_header.pixmap_format=(unsigned long) ZPixmap; )   xwd_header.pixmap_depth=(unsigned long)a+     (image->class == DirectClass ? 24 : 8);p9   xwd_header.pixmap_width=(unsigned long) image->columns; 7   xwd_header.pixmap_height=(unsigned long) image->rows; '   xwd_header.xoffset=(unsigned long) 0;,1   xwd_header.byte_order=(unsigned long) MSBFirst; P   xwd_header.bitmap_unit=(unsigned long) (image->class == DirectClass ? 32 : 8);7   xwd_header.bitmap_bit_order=(unsigned long) MSBFirst;eO   xwd_header.bitmap_pad=(unsigned long) (image->class == DirectClass ? 32 : 8); 8   bits_per_pixel=(image->class == DirectClass ? 24 : 8);;   xwd_header.bits_per_pixel=(unsigned long) bits_per_pixel; ?   bytes_per_line=(unsigned long) ((((xwd_header.bits_per_pixel* :     xwd_header.pixmap_width)+((xwd_header.bitmap_pad)-1))/=     (xwd_header.bitmap_pad))*((xwd_header.bitmap_pad) >> 3)); ;   xwd_header.bytes_per_line=(unsigned long) bytes_per_line;e)   xwd_header.visual_class=(unsigned long) >     (image->class == DirectClass ? DirectColor : PseudoColor);%   xwd_header.red_mask=(unsigned long) 1     (image->class == DirectClass ? 0xff0000 : 0);n'   xwd_header.green_mask=(unsigned long) /     (image->class == DirectClass ? 0xff00 : 0); P   xwd_header.blue_mask=(unsigned long) (image->class == DirectClass ? 0xff : 0);)   xwd_header.bits_per_rgb=(unsigned long) +     (image->class == DirectClass ? 24 : 8); -   xwd_header.colormap_entries=(unsigned long)i8     (image->class == DirectClass ? 256 : image->colors);G   xwd_header.ncolors=(image->class == DirectClass ? 0 : image->colors);r9   xwd_header.window_width=(unsigned long) image->columns;07   xwd_header.window_height=(unsigned long) image->rows;    xwd_header.window_x=0;   xwd_header.window_y=0;/   xwd_header.window_bdrwidth=(unsigned long) 0;    /*     Write XWD header.o   */   lsb_first=1;   if (*(char *) &lsb_first) ?     MSBFirstOrderLong((char *) &xwd_header,sizeof(xwd_header)); A   (void) fwrite((char *) &xwd_header,sz_XWDheader,1,image->file); E   (void) fwrite((char *) image->filename,1,strlen(image->filename)+1,      image->file); "   if (image->class == PseudoClass)     {i       XColor         *colors;         XWDColor         color;         /*         Dump colormap to file.       */=       colors=(XColor *) malloc(image->colors*sizeof(XColor));f$       if (colors == (XColor *) NULL)9         PrematureExit("Unable to allocate memory",image);;'       for (i=0; i < image->colors; i++)        {          colors[i].pixel=i;7         colors[i].red=XUpScale(image->colormap[i].red); ;         colors[i].green=XUpScale(image->colormap[i].green); 9         colors[i].blue=XUpScale(image->colormap[i].blue); 1         colors[i].flags=DoRed | DoGreen | DoBlue;e         colors[i].pad=0;!         if (*(char *) &lsb_first)a           {xF             MSBFirstOrderLong((char *) &colors[i].pixel,sizeof(long));H             MSBFirstOrderShort((char *) &colors[i].red,3*sizeof(short));           }        } '       for (i=0; i < image->colors; i++)        { $         color.pixel=colors[i].pixel;          color.red=colors[i].red;$         color.green=colors[i].green;"         color.blue=colors[i].blue;$         color.flags=colors[i].flags;A         (void) fwrite((char *) &color,sz_XWDColor,1,image->file);        }        free((char *) colors);     }    /*&     Convert MIFF to XWD raster pixels.   */   scanline_pad=(unsigned int)(<     (bytes_per_line-((image->columns*bits_per_pixel) >> 3));   x=0;   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     { &       if (image->class == PseudoClass)+         (void) fputc(p->index,image->file);"
       else	         {f6           (void) fputc(DownScale(p->red),image->file);8           (void) fputc(DownScale(p->green),image->file);7           (void) fputc(DownScale(p->blue),image->file);;	         }=
       x++;       if (x == image->columns)	         {)*           for (k=0; k < scanline_pad; k++)(             (void) fputc(0,image->file);           x=0;	         }%     },     p++;     if (QuantumTick(i,image))o6       ProgressMonitor(SaveImageText,i,image->packets);   }e   CloseImage(image);   return(True);  }u T /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%D %  Function WriteImage writes an image to a file.  You can specify aJ %  particular image format by prefixing the file with the image type and aI %  colon (i.e. ps:image) or specify the image type as the filename suffixg %  (i.e. image.ps).  %e+ %  The format of the WriteImage routine is:f %e* %      status=WriteImage(image_info,image) %r+ %  A description of each parameter follows:r %iG %    o status: Function WriteImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image filei %      fails to write. %nA %    o image_info: Specifies a pointer to an ImageInfo structure.s %c- %    o image: A pointer to a Image structure.c %e %  */; unsigned int WriteImage(ImageInfo *image_info,Image *image)c {s   register int     i;     unsigned int     status;g     /*6     Call appropriate image writer based on image type.   */   status=False; 6   (void) strcpy(image_info->filename,image->filename);2   (void) strcpy(image_info->magick,image->magick);   SetImageInfo(image_info);r6   (void) strcpy(image->filename,image_info->filename);   /*3     Determine if format supports multi-image files.    */5   for (i=0; ImageFormats[i][0] != (char *) NULL; i++) ;     if (strcmp(image_info->magick,ImageFormats[i][0]) == 0)e5       image_info->adjoin&=IsTrue(ImageFormats[i][1]);m   switch (*image_info->magick)   { 
     case 'A':      {t-       status=WriteAVSImage(image_info,image);        break;     }t
     case 'B':      {e0       if (strcmp(image_info->magick,"BIE") == 0)0         status=WriteJBIGImage(image_info,image);
       else/         status=WriteBMPImage(image_info,image);/       break;     },
     case 'C':,     { .       status=WriteCMYKImage(image_info,image);       break;     }/
     case 'D':r     { 0       if (strcmp(image_info->magick,"DCX") == 0)/         status=WritePCXImage(image_info,image);e
       else/         status=WriteBMPImage(image_info,image);s       break;     }%
     case 'E':P     {r1       if (strcmp(image_info->magick,"EPS2") == 0)c/         status=WritePS2Image(image_info,image);f
       else.         status=WritePSImage(image_info,image);       break;     } 
     case 'F':{     { 0       if (strcmp(image_info->magick,"FAX") == 0)/         status=WriteFAXImage(image_info,image);e
       else3         if (strcmp(image_info->magick,"FITS") == 0)/2           status=WriteFITSImage(image_info,image);         else2           status=WriteHTMLImage(image_info,image);       break;     }[
     case 'G':      {m3       if (strncmp(image_info->magick,"GIF",3) == 0) /         status=WriteGIFImage(image_info,image); 
       else3         if (strcmp(image_info->magick,"GRAY") == 0) 2           status=WriteGRAYImage(image_info,image);         else1           status=WriteFAXImage(image_info,image);        break;     } 
     case 'H':d     { 0       if (strcmp(image_info->magick,"HDF") == 0)/         status=WriteHDFImage(image_info,image);e
       else8         if (strcmp(image_info->magick,"HISTOGRAM") == 0)7           status=WriteHISTOGRAMImage(image_info,image);e         else2           status=WriteHTMLImage(image_info,image);       break;     }a
     case 'J':      { 1       if (strcmp(image_info->magick,"JBIG") == 0)l0         status=WriteJBIGImage(image_info,image);
       else0         status=WriteJPEGImage(image_info,image);       break;     } 
     case 'L':      {m.       status=WriteLOGOImage(image_info,image);       break;     }0
     case 'M':      {,0       if (strcmp(image_info->magick,"MAP") == 0)/         status=WriteMAPImage(image_info,image);,
       else4         if (strcmp(image_info->magick,"MATTE") == 0)3           status=WriteMATTEImage(image_info,image);          else5           if (strcmp(image_info->magick,"MIFF") == 0) 4             status=WriteMIFFImage(image_info,image);           else7             if (strcmp(image_info->magick,"MONO") == 0) 6               status=WriteMONOImage(image_info,image);             else=               if ((strcmp(image_info->magick,"MPEG") == 0) ||e:                   (strcmp(image_info->magick,"MPG") == 0))8                 status=WriteMPEGImage(image_info,image);               else7                 status=WriteMTVImage(image_info,image);%       break;     }"
     case 'N':,       break;
     case 'P':c     {i0       if (strcmp(image_info->magick,"PCD") == 0)/         status=WritePCDImage(image_info,image); 
       else2         if (strcmp(image_info->magick,"PCL") == 0)1           status=WritePCLImage(image_info,image);n         else4           if (strcmp(image_info->magick,"PCX") == 0)3             status=WritePCXImage(image_info,image);e           else6             if (strcmp(image_info->magick,"PDF") == 0)5               status=WritePDFImage(image_info,image);o             else9               if (strcmp(image_info->magick,"PICT") == 0)d8                 status=WritePICTImage(image_info,image);               else9                 if (strcmp(image_info->magick,"PM") == 0) 9                   status=WriteXPMImage(image_info,image);i                 else<                   if (strcmp(image_info->magick,"PNG") == 0);                     status=WritePNGImage(image_info,image);                    else=                     if (strcmp(image_info->magick,"PS") == 0) <                       status=WritePSImage(image_info,image);                     else@                       if (strcmp(image_info->magick,"PS2") == 0)?                         status=WritePS2Image(image_info,image);k                       else?                         status=WritePNMImage(image_info,image);        break;     }n
     case 'R':g     { 0       if (strcmp(image_info->magick,"RAD") == 0)4         status=WriteRADIANCEImage(image_info,image);
       else2         if (strcmp(image_info->magick,"RAS") == 0)1           status=WriteSUNImage(image_info,image);g         else7           if (strncmp(image_info->magick,"RGB",3) == 0)g3             status=WriteRGBImage(image_info,image);g           else9             if (strncmp(image_info->magick,"RLA",3) == 0) 5               status=WriteRLAImage(image_info,image);              else5               status=WriteRLEImage(image_info,image);        break;     }c
     case 'S':      { 0       if (strcmp(image_info->magick,"SGI") == 0)/         status=WriteSGIImage(image_info,image);(
       else/         status=WriteSUNImage(image_info,image);y       break;     }&
     case 'T':p     {g1       if (strcmp(image_info->magick,"TEXT") == 0) 0         status=WriteTEXTImage(image_info,image);
       else2         if (strcmp(image_info->magick,"TGA") == 0)3           status=WriteTARGAImage(image_info,image);          else7           if (strncmp(image_info->magick,"TIF",3) == 0) 4             status=WriteTIFFImage(image_info,image);           else4             status=WriteTILEImage(image_info,image);       break;     }r
     case 'U':e     {-1       if (strcmp(image_info->magick,"UYVY") == 0)r0         status=WriteUYVYImage(image_info,image);       break;     }f
     case 'V':a     { 2       if (strcmp(image_info->magick,"VICAR") == 0)1         status=WriteVICARImage(image_info,image); 
       else2         if (strcmp(image_info->magick,"VID") == 0)2           status=WriteMIFFImage(image_info,image);         else2           status=WriteVIFFImage(image_info,image);       break;     })
     case 'X':s     { .       if (strcmp(image_info->magick,"X") == 0)-         status=WriteXImage(image_info,image);h
       else2         if (strcmp(image_info->magick,"XBM") == 0)1           status=WriteXBMImage(image_info,image);e         else3           if (strcmp(image_info->magick,"XC") == 0)r2             status=WriteXCImage(image_info,image);           else6             if (strcmp(image_info->magick,"XPM") == 0)5               status=WriteXPMImage(image_info,image);a             else7               if (strcmp(image_info->magick,"XV") == 0) 8                 status=WriteVIFFImage(image_info,image);               else7                 status=WriteXWDImage(image_info,image);t       break;     }t
     case 'Y':o     {;0       if (strcmp(image_info->magick,"YUV") == 0)/         status=WriteYUVImage(image_info,image); 
       else0         status=WriteYUV3Image(image_info,image);       break;     }"     default:.       status=WriteMIFFImage(image_info,image);   }>   if (image->status)     {0G       Warning("An error has occurred writing to file",image->filename);)       return(False);     }a2   (void) strcpy(image->magick,image_info->magick);   return(status);e }*