 /*  *
  *  Title:	  *	Backup   *  *  Decription: "  *	Program to read VMS backup tape  *  *  Author:   *	John Douglas CAREY.%  *	Sven-Ove Westberg    (version 3.0)   *  *  Net-addess:   *	john%monu1.oz@seismo.ARPA  *	luthcad!sow@enea.UUCP  *  *  History:  *	Version 1.0 - September 1984 )  *		Can only read variable length records   *	Version 1.11  *		Cleaned up the program from the original hack   *		Can now read stream files   *	Version 1.2)  *		Now convert filename from VMS to UNIX    *			and creates sub-directories  *	Version 1.3+  *		Works on the Pyramid if SWAP is defined   *	Version 1.4-  *		Reads files spanning multiple tape blocks   *	Version 1.5(  *		Always reset reclen = 0 on file open#  *		Now output fixed length records   *  *      Version 2.0 - July 1985 '  *		VMS Version 4.0 causes a rethink !! ?  *		Now use mtio operations instead of opening and closing file '  *		Blocksize now grabed from the label   *  *	Version 2.1 - September 1985 2  *		Handle variable length records of zero length.  *  *	Version 2.2 - July 1986*  *		Handle FORTRAN records of zero length.'  *		Inserted exit(0) at end of program. &  *		Distributed program in aus.sources  *  *	Version 2.3 - August 19864  *		Handle FORTRAN records with record length fields  *		at the end of a block   *		Put debug output to a file. &  *		Distributed program in net.sources  *  *	Version 3.0 - December 1986  *		Handle multiple saveset   *		Remote tape   *		Interactive mode,  *		File name selection with meta-characters#  *		Convert ; to : in VMS filenames -  *		Flag for usage of VMS directory structure '  *		Flag for "useless" files  eg. *.exe *  *		Flag for use VMS version in file names  *		Flag for verbose mode )  *		Flag to list the contents of the tape   *		Distributed to mod.sources  *1  *	Version 3.1 - January 1988 By Barry A. Suskind .  *		+ Handle those machines that swab bytes on5  *		  the tapedrive. See the SWAB define in this and    *		  other files.5  *		+ Added check for XOR blocks so they get trashed.   *  *  *  Installation:   *  *	Computer Centre  *	Monash University  *	Wellington Road
  *	Clayton  *	Victoria	3168  *	AUSTRALIA  *  */  #include	<stdio.h> #include	<ctype.h>   #include	<sys/ioctl.h> #include	<sys/types.h>
 #ifdef REMOTE  #include	<local/rmt.h> #include	<sys/stat.h>  #endif #include	<sys/mtio.h>  #include	<sys/file.h>   
 #ifdef pyr #define SWAP
 #endif pyr  
 #ifdef sun #define SWAP #endif   struct bbh { 	short	bbh_dol_w_size; 	short	bbh_dol_w_opsys;  	short	bbh_dol_w_subsys; 	short	bbh_dol_w_applic; 	long	bbh_dol_l_number;  	char	bbh_dol_t_spare_1[20]; 	short	bbh_dol_w_struclev; 	short	bbh_dol_w_volnum; 	long	bbh_dol_l_crc; 	long	bbh_dol_l_blocksize; 	long	bbh_dol_l_flags; 	char	bbh_dol_t_ssname[32];  	short	bbh_dol_w_fid[3]; 	short	bbh_dol_w_did[3]; 	char	bbh_dol_t_filename[128]; 	char	bbh_dol_b_rtype; 	char	bbh_dol_b_rattrib; 	short	bbh_dol_w_rsize;  	char	bbh_dol_b_bktsize; 	char	bbh_dol_b_vfcsize; 	short	bbh_dol_w_maxrec; 	long	bbh_dol_l_filesize;  	char	bbh_dol_t_spare_2[22]; 	short	bbh_dol_w_checksum; } *block_header;   #define bbh_dol_k_normal 1 #define bbh_dol_k_XOR 2    struct brh { 	short	brh_dol_w_rsize;  	short	brh_dol_w_rtype;  	long	brh_dol_l_flags; 	long	brh_dol_l_address; 	long	brh_dol_l_spare; } *record_header;    /* define record types */    #define	brh_dol_k_null	0 #define	brh_dol_k_summary	1  #define	brh_dol_k_volume	2 #define	brh_dol_k_file	3 #define	brh_dol_k_vbn	4  #define brh_dol_k_physvol	5  #define brh_dol_k_lbn	6  #define	brh_dol_k_fid	7    struct bsa { 	short	bsa_dol_w_size; 	short	bsa_dol_w_type; 	char	bsa_dol_t_text[1];
 } *data_item;    #define bsa_dol_k_ssname	1 #define bsa_dol_k_command	2  #define bsa_dol_k_comment	3  #define bsa_dol_k_username	4 #define bsa_dol_k_useruic	5  #define bsa_dol_k_date		6  #define bsa_dol_k_opsys		7 #define bsa_dol_k_sysver	8 #define bsa_dol_k_nodename	9 #define bsa_dol_k_sir		10  #define bsa_dol_k_driveid	11 #define bsa_dol_k_backver	12 #define bsa_dol_k_blocksize	13 #define bsa_dol_k_xorsize	14 #define bsa_dol_k_buffers	15   #define bsa_dol_k_filename 	42 #define bsa_dol_k_structlev	43 #define bsa_dol_k_fid		44  #define bsa_dol_k_backlink	45  #define bsa_dol_k_filesize	46  #define bsa_dol_k_uic		47  #define bsa_dol_k_fpro		48 #define bsa_dol_k_rpro		49 #define bsa_dol_k_aclevel	50 #define bsa_dol_k_uchar		51  #define bsa_dol_k_recattr	52 #define bsa_dol_k_revision	53  #define bsa_dol_k_credate	54 #define bsa_dol_k_revdate	55 #define bsa_dol_k_expdate	56 #define bsa_dol_k_bakdate	57 #define bsa_dol_k_bootvbn	58 #define bsa_dol_k_placement	59 #define bsa_dol_k_dir_uic	71 #define bsa_dol_k_dir_fpro	72  #define bsa_dol_k_dir_status	73  #define bsa_dol_k_dir_verlim	74  #define bsa_dol_k_verlimit	75   
 #ifdef	STREAM ! char	*def_tapefile = "/dev/rts8";  #else ! char	*def_tapefile = "/dev/rmt1";  #endif char	*tapefile;    char	filename[128]; 
 int	filesize;   ! char	recfmt;		/* record format */   ) #define			FAB_dol_C_UDF	0	/* undefined */ 3 #define			FAB_dol_C_FIX	1	/* fixed-length record */ 6 #define			FAB_dol_C_VAR	2	/* variable-length record */P #define			FAB_dol_C_VFC	3	/* variable-length with fixed-length control record */T #define 		FAB_dol_C_STM	4	/* RMS-11 stream record (valid only for sequential org) */U #define			FAB_dol_C_STMLF	5	/* stream record delimited by LF (sequential org only) */ U #define 		FAB_dol_C_STMCR	6	/* stream record delimited by CR (sequential org only) */ 8 #define			FAB_dol_C_MAXRFM	6	/* maximum rfm supported */  % char	recatt;		/* record attributes */   B #define			FAB_dol_V_FTN	0	/* FORTRAN carriage control character */B #define			FAB_dol_V_CR	1	/* line feed - record -carriage return */; #define			FAB_dol_V_PRN	2	/* print-file carriage control */ D #define			FAB_dol_V_BLK	3	/* records don't cross block boundaries */     FILE	*f	= NULL;  int	file_count; 
 short	reclen;  short	fixx;  short	recsize; int	vfcsize;   #ifdef	NEWD 	 FILE	*lf;  #endif	NEWD   # int	fd;		/* tape file descriptor */ < int 	cflag, dflag, eflag, sflag, tflag, vflag, wflag, xflag;
 int	setnr;
 char	**gargv;  int 	goptind, gargc;   #define	LABEL_SIZE	80  char	label[LABEL_SIZE];    char	*block; int	blocksize;   struct	mtop	op;    FILE * openfile(fn)	 char	*fn;  {  	char	ufn[256];  	char	ans[80]; 	char	*p, *q, s, *ext; 	int	procf;    	procf = 1; / 	/* copy fn to ufn and convert to lower case */  	p = fn;	 	q = ufn; 
 	while (*p) {  		if (isupper(*p)) 			*q = *p - 'A' + 'a';  		else 			*q = *p;  		p++; 		q++; 	} 	*q = '\0';   : 	/* convert the VMS to UNIX and make the directory path */	 	p = ufn; 	 	q = ++p; 
 	while (*q) {  		if (*q == '.' || *q == ']') { 
 			s = *q;
 			*q = '\0'; % 			if(procf && dflag) mkdir(p, 0777);  			*q = '/'; 			if (s == ']')
 				break; 		}  		*q++;  	} 	*q++; 	if(!dflag) p=q;# 	/* strip off the version number */  	while (*q && *q != ';') { 		if( *q == '.') ext = q;  		q++; 	}
 	if (cflag) {  		*q = ':';  	} 	else {  		*q = '\0'; 	}, 	if(!eflag && procf) procf = typecmp(++ext); 	if(procf && wflag) { % 		printf("extract %s [ny]",filename);  		fflush(stdout);  		gets(ans); 		if(*ans != 'y') procf = NULL;  	}
 	if(procf)! 		/* open the file for writing */  		return(fopen(p, "w")); 	else  		return(NULL);  }   A typecmp(str)    /* Compare the filename type in str with our list ?                    of file type to be ignored.  Return 0 if the 9                    file is to be ignored, return 1 if the H                    file is not in our list and should not be ignored. */ register char   *str;  {          static char *type[] = { :                 "exe",          /* vms executable image */8                 "lib",          /* vms object library */5                 "obj",          /* rsx object file */ B                 "odl",          /* rsx overlay description file */8                 "olb",          /* rsx object library */:                 "pmd",          /* rsx post mortem dump */6                 "stb",          /* rsx symbol table */?                 "sys",          /* rsx bootable system image */e:                 "tsk",          /* rsx executable image */ 		"dir", 		"upd", 		"tlo", 		"tlb",A                 ""              /* null string terminates list */z
         };         register int    i;           i = -1;*         while (*type[++i])1                 if (strncmp(str, type[i],3) == 0)VO                         return(0);      /* found a match, file to be ignored */s<         return(1);                      /* no match found */ }o process_file(buffer,rsize) char		*buffer; unsigned short	rsize;  {t
 	int	i, n;
 	char	*p, *q;e) 	unsigned	short	dsize, dtype, nblk, lnch;g 	unsigned	short	c;
 	short	*s;   	int 	procf;   	s = (short *) buffer;   	/* check the header word */ 	if (*s != 257) {*) 		printf("Snark: invalid data header\n");s
 		exit(1); 	}   	c = 2;  	while ( c < rsize ) {* 	   data_item = (struct bsa *) &buffer[c]; #ifndef	SWAP& 	   dsize = data_item->bsa_dol_w_size;& 	   dtype = data_item->bsa_dol_w_type; #elseeA 	   Swap_This(&data_item->bsa_dol_w_size, &dsize, sizeof(short));aA 	   Swap_This(&data_item->bsa_dol_w_type, &dtype, sizeof(short));f #endif 	   switch ( dtype ) {6 	   	case bsa_dol_k_filename : /* extract file name */# 		   p = data_item->bsa_dol_t_text;l 		   q = filename;- 		   for (i = 0; i < dsize; i++) *q++ = *p++;  		   *q = '\0';i 		   break; ? 		case bsa_dol_k_recattr : /* extract file record attributes */l# 		   p = data_item->bsa_dol_t_text;	 		   recfmt = p[0];	 		   recatt = p[1];i #ifndef	SWAP+ 		   bcopy(&p[2], &recsize, sizeof(short));* #elsef/ 		   Swap_This(&p[2], &recsize, sizeof(short));r #endif 		   vfcsize = p[15];*# 		   if (vfcsize == 0) vfcsize = 2;m #ifdef	DEBUG% 		   printf("recfmt = %d\n", recfmt);c% 		   printf("recatt = %d\n", recatt);o& 		   printf("reclen = %d\n", recsize);' 		   printf("vfcsize = %d\n", vfcsize);e #endif #ifndef	SWAP) 		   bcopy(&p[10], &nblk, sizeof(short));S) 		   bcopy(&p[12], &lnch, sizeof(short));. #else - 		   Swap_This(&p[10], &nblk, sizeof(short)); - 		   Swap_This(&p[12], &lnch, sizeof(short));e #endif$ 		   filesize = (nblk-1)*512 + lnch; #ifdef DEBUG1 		   printf("nbk = %d, lnch = %d\n", nblk, lnch);<+ 		   printf("filesize = 0x%x\n", filesize);/ #endif 		   break;y 		}e 		c = c + dsize + 4; 	} 	/* open the file */ 	if (f != NULL) {  		fclose(f); 		file_count = 0; 
 		reclen = 0;i 	} 	procf = 0;p 	if (goptind < gargc) " 		for(i=goptind; i < gargc; i++) {% 			procf |= match(filename,gargv[i]);s 		}  	elseb 		procf = 1; 	if (tflag && procf) b- 		printf( " %-35s %8d \n",filename,filesize);_ 	if (xflag && procf) { 		/* open file */o 		f = openfile(filename);o= 		if(f != NULL && vflag) printf("extracting %s\n", filename);c 	} }  /*  *0  *  process a virtual block record (file record)  *  */l process_vbn(buffer, rsize) char		*buffer; unsigned short	rsize;; {c
 	int	c, i;   	if (f == NULL) {o	 		return;; 	} 	i = 0;d/ 	while (file_count+i < filesize && i < rsize) {_ 		switch (recfmt) {t 		case FAB_dol_C_FIX:n 			if (reclen == 0) {  				reclen = recsize;[ 			} 			fputc(buffer[i], f);; 			i++;k 			reclen--;	 			break;o   		case FAB_dol_C_VAR:_ 		case FAB_dol_C_VFC:b 			if (reclen == 0) {r% 				reclen = *((short *) &buffer[i]);	 #ifdef	SWAPg/ 				Swap_This(&reclen, &reclen, sizeof(short));r #endif #ifdef	NEWD  				fprintf(lf, "---\n");*) 				fprintf(lf, "reclen = %d\n", reclen);_ 				fprintf(lf, "i = %d\n", i);_' 				fprintf(lf, "rsize = %d\n", rsize);f #endif	NEWD_ 				fixx = reclen; 				i += 2;	" 				if (recfmt == FAB_dol_C_VFC) { 					i += vfcsize; 					reclen -= vfcsize;a 				}s 			} else if (reclen == fixx) 					&& recatt == (1 << FAB_dol_V_FTN)) { 
 					/**** 					if (buffer[i] == '0') 						fputc('\n', f);n 					else if (buffer[i] == '1')s 						fputc('\f', f);f 					*** sow ***/i$ 					fputc(buffer[i],f); /** sow **/	 					i++;_ 					reclen--; 			} else {_ 				fputc(buffer[i], f); 				i++;
 				reclen--;_ 			} 			if (reclen == 0) {o 				fputc('\n', f);n 				if (i & 1)	 					i++;f 			}	 			break;c   		case FAB_dol_C_STM:_ 		case FAB_dol_C_STMLF:_ 			if (reclen < 0) { 				printf("SCREAM\n");	 			} 			if (reclen == 0) {e 				reclen = 512;o 			} 			c = buffer[i++];o 			reclen--; 			if (c == '\n') {_ 				reclen = 0;f 			} 			fputc(c, f); 	 			break;_   		case FAB_dol_C_STMCR:_ 			c = buffer[i++];n 			if (c == '\r')	 				fputc('\n', f);_ 			else  				fputc(c, f);	 			break;2  
 		default:
 			fclose(f);5 			unlink(filename);; 			fprintf(stderr, "Invalid record format = %d\n", recfmt);x
 			return; 		}  	} 	file_count += i;d }n process_summary(buffer,rsize)  char		*buffer; unsigned short	rsize;_ {i 			int	i, n; 			char	sbuf[512]; 			char	*p, *q;s$ 	unsigned	short	dsize, dtype, ssxor; 	unsigned	short	c; 	unsigned	long	ssbsize;t 			short	*s; 			int 	procf;   	s = (short *) buffer;   	/* check the header word */ 	if (*s != 257) {d) 		printf("Snark: invalid data header\n"); 
 		exit(1); 	}   	c = 2;c 	while ( c < rsize ) {* 	   data_item = (struct bsa *) &buffer[c]; #ifndef	SWAP& 	   dsize = data_item->bsa_dol_w_size;& 	   dtype = data_item->bsa_dol_w_type; #elsegA 	   Swap_This(&data_item->bsa_dol_w_size, &dsize, sizeof(short));eA 	   Swap_This(&data_item->bsa_dol_w_type, &dtype, sizeof(short));e #endif 	   switch ( dtype ) {7 	   	case bsa_dol_k_ssname : /* extract saveset name */d# 		   p = data_item->bsa_dol_t_text;) 		   q = sbuf;- 		   for (i = 0; i < dsize; i++) *q++ = *p++;  		   *q = '\0';g# 		   printf("Save set: %s\n",sbuf);M 		   break; 9 		case bsa_dol_k_command : /* Extract original command */ # 		   p = data_item->bsa_dol_t_text;N 		   q = sbuf;- 		   for (i = 0; i < dsize; i++) *q++ = *p++;e 		   *q = '\0';a* 		   printf("Backup Command:\n%s\n",sbuf); 		   break; 9 		case bsa_dol_k_comment : /* extract any user comment */d# 		   p = data_item->bsa_dol_t_text;I 		   q = sbuf;- 		   for (i = 0; i < dsize; i++) *q++ = *p++;  		   *q = '\0';n# 		   printf("Comment:\n%s\n",sbuf);  		   break; 2 		case bsa_dol_k_username : /* extract username */# 		   p = data_item->bsa_dol_t_text;w 		   q = sbuf;- 		   for (i = 0; i < dsize; i++) *q++ = *p++;  		   *q = '\0';I# 		   printf("Username: %s\n",sbuf);h 		   break;n8 		case bsa_dol_k_nodename : /* extract node of backup */# 		   p = data_item->bsa_dol_t_text;a 		   q = sbuf;- 		   for (i = 0; i < dsize; i++) *q++ = *p++;  		   *q = '\0';u 		   printf("Node: %s\n",sbuf);  		   break;=6 		case bsa_dol_k_sysver : /* extract system version */# 		   p = data_item->bsa_dol_t_text;	 		   q = sbuf;- 		   for (i = 0; i < dsize; i++) *q++ = *p++;n 		   *q = '\0';o) 		   printf("VAX/VMS Version %s\n",sbuf);( 		   break;(3 		case bsa_dol_k_driveid : /* extract tape drive */ # 		   p = data_item->bsa_dol_t_text;) 		   q = sbuf;- 		   for (i = 0; i < dsize; i++) *q++ = *p++;  		   *q = '\0';d$ 		   printf("Tapedrive: %s\n",sbuf); 		   break;w5 		case bsa_dol_k_blocksize : /* extract block size */	 #ifndef SWAP) 		   ssbsize = data_item->bsa_dol_t_text;q #else;@ 		   Swap_This(data_item->bsa_dol_t_text,&ssbsize,sizeof(long)); #endif' 		   printf("Blocksize: %d\n",ssbsize);  		   break;u1 		case bsa_dol_k_xorsize : /* extract xor size */  #ifndef SWAP' 		   ssxor = data_item->bsa_dol_t_text;	 #elsef? 		   Swap_This(data_item->bsa_dol_t_text,&ssxor,sizeof(short));* #endif& 		   printf("Groupsize: %d\n", ssxor); 		   break;  		}  		c = c + dsize + 4; 	} }    #ifdef	SWAP  /*  */  *  do swapping for Motorola type architecturesh  *  */  Swap_This(from, to, nbytes)u char	*from, *to; int	nbytes;d {/
 	int	i, j; 	char	temp[100];   	for (i = 0; i < nbytes; i++)  		temp[i] = from[i];0 	for (i = 0, j = nbytes-1; i < nbytes; i++, j--) 		to[i] = temp[j]; }v #endif /*  *  *  process a backup block  *  */  process_block(block, blocksize)  char	*block; int	blocksize; {l  . 	unsigned short	bhsize, bapplic, rsize, rtype; 	unsigned long	bsize, i;   	i = 0;   # 	/* read the backup block header */o) 	block_header = (struct bbh *) &block[i];  	i += sizeof(struct bbh); I /*BAS need to add the XOR killer here,,, also add show stuff for DEBUG */ ' 	bhsize = block_header->bbh_dol_w_size;g+ 	bsize = block_header->bbh_dol_l_blocksize; * 	bapplic = block_header->bbh_dol_w_applic; #ifdef	SWAP , 	Swap_This(&bhsize, &bhsize, sizeof(short));) 	Swap_This(&bsize, &bsize, sizeof(long));e. 	Swap_This(&bapplic, &bapplic, sizeof(short)); #endif  - 	/* check the validity of the header block */u$ 	if (bhsize != sizeof(struct bbh)) {8 		fprintf(stderr, "Snark: Invalid header block size\n");
 		exit(1); 	}( 	if (bsize != 0 && bsize != blocksize) {1 		fprintf(stderr, "Snark: Invalid block size\n");s
 		exit(1); 	} #ifdef	DEBUG5 	printf("new block: i = %d, bsize = %d\n", i, bsize);; #endif! 	if( bapplic == bbh_dol_k_XOR ) {  #ifdef	DEBUG 		printf("XOR Block\n"); #endif	 		return;d 		}  	/* read the records */  	while (i < bsize) {% 		/* read the backup record header */c+ 		record_header = (struct brh *) &block[i];  		i += sizeof(struct brh);  ) 		rtype = record_header->brh_dol_w_rtype;s) 		rsize = record_header->brh_dol_w_rsize;e #ifdef	SWAPe+ 		Swap_This(&rtype, &rtype, sizeof(short));o+ 		Swap_This(&rsize, &rsize, sizeof(short));  #endif #ifdef	DEBUG  		printf("rtype = %d\n", rtype);  		printf("rsize = %d\n", rsize);; 		printf("flags = 0x%x\n", record_header->brh_dol_l_flags);;< 		printf("addr = 0x%x\n", record_header->brh_dol_l_address); 		printf("i = %d\n", i); #endif   		switch (rtype) {   		case brh_dol_k_null: #ifdef	DEBUG 			printf("rtype = null\n"); #endif	 			break;]   		case brh_dol_k_summary:& #ifdef	DEBUG 			printf("rtype = summary\n");S #endif0 			if( tflag ) process_summary(&block[i],rsize);	 			break;1   		case brh_dol_k_file: #ifdef	DEBUG 			printf("rtype = file\n"); #endif! 			process_file(&block[i],rsize);c	 			break;,   		case brh_dol_k_vbn:r #ifdef	DEBUG 			printf("rtype = vbn\n");i #endif! 			process_vbn(&block[i], rsize);P	 			break;y   		case brh_dol_k_physvol:) #ifdef	DEBUG 			printf("rtype = physvol\n");  #endif	 			break;h   		case brh_dol_k_lbn:s #ifdef	DEBUG 			printf("rtype = lbn\n");e #endif	 			break;f   		case brh_dol_k_fid:) #ifdef	DEBUG 			printf("rtype = fid\n");k #endif	 			break;,  
 		default:4 			fprintf(stderr, " Snark: invalid record type\n");1 			fprintf(stderr, " record type = %d\n", rtype); ( 			fprintf(stderr, " Continue (y/n)? ");" 			if( getchar() == 'n' ) exit(1); 		}0
 #ifdef pyr 		i = i + rsize; #elseg
 		i += rsize;= #endif 	} }r   rdhead() {p 	int i, nfound;e 	char name[80];  	nfound = 1;2 	/* read the tape label - 4 records of 80 bytes */1 	while ((i = read(fd, label, LABEL_SIZE)) != 0) {c 		if (i != LABEL_SIZE) {0 			fprintf(stderr, "Snark: bad label record\n"); 			exit(1);t 		}n #ifdef SWABn# 		swab( label, label, LABEL_SIZE );  #endif& 		if (strncmp(label, "VOL1",4) == 0) {! 			sscanf(label+4, "%14s", name);f2 			if(vflag || tflag) printf("Volume: %s\n",name); 		} & 		if (strncmp(label, "HDR1",4) == 0) {! 			sscanf(label+4, "%14s", name);r# 			sscanf(label+31, "%4d", &setnr);e 		}d 		/* get the block size */' 		if (strncmp(label, "HDR2", 4) == 0) {f 			nfound = 0;& 			sscanf(label+5, "%5d", &blocksize); #ifdef	DEBUG) 			printf("blocksize = %d\n", blocksize);  #endif 		}  	}! 	if((vflag || tflag) && !nfound) )7 		printf("Saveset name: %s   number: %d\n",name,setnr);s 	/* get the block buffer */ $ 	block = (char *) malloc(blocksize); 	if (block == (char *) 0) {e: 		fprintf(stderr, "memory allocation for block failed\n");
 		exit(1); 	} 	return(nfound); }	   rdtail() {; 	int i;= 	char name[80];f2 	/* read the tape label - 4 records of 80 bytes */1 	while ((i = read(fd, label, LABEL_SIZE)) != 0) {i 		if (i != LABEL_SIZE) {0 			fprintf(stderr, "Snark: bad label record\n"); 			exit(1);	 		}p #ifdef SWABn# 		swab( label, label, LABEL_SIZE );	 		strcpy(label,name);	 #endif& 		if (strncmp(label, "EOF1",4) == 0) {! 			sscanf(label+4, "%14s", name);  			if(vflag || tflag)(, 				printf("End of saveset: %s\n\n\n",name); 		}i 	} }e   usage(progname)t char	*progname;	 {( 	fprintf(stderr,D 	  "Usage:  %s -{tx}[cdevw][-s setnumber][-f tapefile]\n",progname); }	 main(argc, argv)	 int	argc;f
 char	*argv[];  {} 		 	char *progname; 	int	c, i, eoffl;2 	int	selset; 	extern int optind;r 	extern char *optarg;\   	progname = argv[0]; 	if(argc < 2){ 		usage(progname);
 		exit(1); 	} 	gargv = argv; 	gargc = argc; 	tapefile = def_tapefile;	3 	cflag=dflag=eflag=sflag=tflag=vflag=wflag=xflag=0;k2 	while((c=getopt(argc,argv,"cdef:s:tvwx")) != EOF) 		switch(c){ 		case 'c':a 			cflag++;r	 			break;, 		case 'd':	 			dflag++; 	 			break;_ 		case 'e':  			eflag++;u	 			break;r 		case 'f':r 			tapefile = optarg;o	 			break;  		case 's':  			sflag++;b 			sscanf(optarg,"%d",&selset);g	 			break;s 		case 't':s 			tflag++;e	 			break;  		case 'v':g 			vflag++;		 			break;  		case 'w':; 			wflag++;r	 			break;; 		case 'x':  			xflag++;r	 			break;* 		case '?':  			usage(progname);l 			exit(1);r	 			break;x 		}; 	if(!tflag && !xflag) {( 		usage(progname);
 		exit(1); 	} 	goptind = optind;   #ifdef	NEWDP 	/* open debug file */ 	lf = fopen("log", "w"); 	if (lf == NULL) { 		perror("log");
 		exit(1); 	} #endif   	/* open the tape file */i 	fd = open(tapefile, O_RDONLY);t 	if (fd < 0) { 		perror(tapefile);f
 		exit(1); 	}   	/* rewind the tape */ 	op.mt_op = MTREW; 	op.mt_count = 1;c 	i = ioctl(fd, MTIOCTOP, &op);
 	if (i < 0) {_ 		perror(tapefile);u
 		exit(1); 	}   	eoffl = rdhead();5 	/* read the backup tape blocks until end of tape */ % 	while (!eoffl) {b  		if(sflag && setnr != selset) { 			op.mt_op = MTFSF; 			op.mt_count = 1;d  			i = ioctl(fd, MTIOCTOP, &op); 			if (i < 0) {r 				perror(tapefile);) 				exit(1); 			}	 			i = 0;a 		}  		else	{ 			strncpy(block,"",blocksize); " 			i = read(fd, block, blocksize); #ifdef SWABn# 			swab( block, block, blocksize );m #endif 			} 		if(i == 0) { 			rdtail(); 			eoffl=rdhead(); 		}* 		else if (i != blocksize) {1 			fprintf(stderr, "bad block read i = %d\n", i);  			exit(1);d 		}u 		else{ 
 			eoffl = 0;n# 			process_block(block, blocksize);_ 		}w 	}, 	if(vflag || tflag) printf("End of tape\n");   	/* close the tape */  	close(fd);p   #ifdef	NEWD: 	/* close debug file */k 	fclose(lf); #endif	NEWDm   	/* exit cleanly */b	 	exit(0);	 }p