
/* Rosegarden Top Box, widget creation stuff */

#include "General.h"
#include "Widgets.h"
#include "ILTypes.h"
#include "ILServer.h"
#include "ILClient.h"
#include "Yawn.h"
#include "YHelp.h"
#include "Visuals.h"

#include <Version.h>

#ifndef VMS
#include <sys/types.h>
#include <sys/stat.h>
#else
#include <types.h>
#include <stat.h>
#endif

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>

#ifndef VMS
Widget aboutButton;
#else
Widget My_aboutButton;
#include <lib$routines>
#define NOWAIT   1
int flags = 1;
int status;
int child_count;
int pid;
#include <descrip.h>
#define $NEW_DESCRIPTOR(name) \
        struct dsc$descriptor_s name = { \
            0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0}
        $NEW_DESCRIPTOR (edit_cmd);
        $NEW_DESCRIPTOR (seq_cmd);
void EditFinished();
void SequFinished();
#endif
static Widget editButton;
static Widget midiButton;
static Widget helpButton;

Boolean serverStarted = False;

YMessageString aboutText[] = {
  { "Rosegarden",                    YMessageBold,       },
  { " ",                             YMessageNormal,     },
  { "Music Editing and Sequencing",  YMessageNormal,     },
  { ROSEGARDEN_VERSION,              YMessageNormal,     },
  { "C Cannam, A J Green, R W Bown", YMessageBold,       },
  { " ",                             YMessageNormal,     },
  { "contact:",                      YMessageItalic,     },
  { "cannam@netcomuk.co.uk",         YMessageBoldItalic, },
};


void ActivateILClient(String tag)
{
  Begin("ActivateILClient");

#ifndef VMS
  if (!strncmp(tag, ILS_SEQUENCE_SERVICE, 4) ||
      !strncmp(tag, ILS_PLAY_SERVICE, 4) ||
      !strncmp(tag, ILS_FOLLOWREADY_SERVICE, 4)) {

    SetSigHupForClient();
    XtSetSensitive(midiButton, False);

  } else if (!strncmp(tag, ILS_EDIT_SERVICE, 4) ||
	     !strncmp(tag, ILS_FOLLOW_SERVICE, 4)) {

    SetSigHupForClient();
    XtSetSensitive(editButton, False);

  }  else if (!strncmp(tag, ILS_HELP_SERVICE, 4)) {

    XtSetSensitive(helpButton, False);
  }       
#else
   if (!strncmp(tag, ILS_HELP_SERVICE, 4)) {
    XtSetSensitive(helpButton, False);
  }       
#endif

  End;
}


void InitialiseILServer(void)
{
  struct stat buf;

  Begin("InitialiseILServer");

#ifndef VMS
  IL_ServerInit(topLevel, ProgramName, ClientFinished, ActivateILClient, NULL);
#endif

  serverStarted = True;
  
#ifndef VMS
  if (stat(appData.editorName, &buf)) {
    fprintf(stderr,"%s: Cannot open editor service\n", ProgramName);
    appData.editorName = NULL;
  }

  if (stat(appData.sequencerName, &buf)) {
    fprintf(stderr,"%s: Cannot open sequencer service\n", ProgramName);
    appData.sequencerName = NULL;
  }
#endif

  if (appData.editorName) {
#ifndef VMS
    IL_AddService(ILS_EDIT_SERVICE, appData.editorName);
    IL_AddService(ILS_FOLLOW_SERVICE, appData.editorName);
#endif
  } else XtSetSensitive(editButton, False);

  if (appData.sequencerName) {
#ifndef VMS
    IL_AddService(ILS_PLAY_SERVICE, appData.sequencerName);
    IL_AddService(ILS_SEQUENCE_SERVICE, appData.sequencerName);
    IL_AddService(ILS_FOLLOWREADY_SERVICE, appData.sequencerName);
#endif
  } else XtSetSensitive(midiButton, False);

printf("Editor    name: %s\n",appData.editorName);
printf("Sequencer name: %s\n",appData.sequencerName);
  End;
}


void HelpILCallback(char *chunk)
{
  Begin("HelpILCallback");
  if (strcmp(chunk, "Nothing")) YHelpSetTopic(chunk);
  YHelpInstallHelp();
#ifndef VMS
  IL_AcknowledgeRequest(ILS_HELP_SERVICE, IL_SERVICE_OK);
#endif
  XtSetSensitive(helpButton, False);
  End;
}


void ILQuit(Boolean confirm)
{
  Begin("ILQuit");
#ifndef VMS
  if (confirm) IL_DeRegisterWithServer("Help");
#endif
  YHelpClose();
  End;
}


/* This application is both server and client.  Interlock can't handle */
/* the case where the server window is the same as one of the clients  */
/* (it has multiple-messaging problems, things get sent to both client */
/* and server), so we have to use a different window for the client id */

void InitialiseILClient(void)
{
  Begin("InitialiseILClient");

#ifndef VMS
  IL_ClientInit(XtWindow(topLevel), helpButton, ILQuit);
  IL_RegisterWithServer(ILS_HELP_SERVICE, HelpILCallback);
#endif

  End;
}


void EditButton(Widget w, XtPointer a, XtPointer b)
{
  Begin("EditButton");
#ifndef VMS
  IL_StartTask(ILS_EDIT_SERVICE);
#else
  edit_cmd.dsc$w_length = strlen (appData.editorName);
  edit_cmd.dsc$a_pointer = appData.editorName;
  status = lib$spawn (&edit_cmd, 0, 0, &flags, 0, &pid, 0, 0,
                      EditFinished, child_count);
  if (status != 1) {
     printf("Unable to Execute Rosegarden Editor\n");
    } else {
    printf("Rosegarden Editor activated\n");
    }
#endif
  YDarkenWidget(w);
  XtSetSensitive(w, False);
  SetSigHupForClient();
  End;
}


void MidiButton(Widget w, XtPointer a, XtPointer b)
{
  Begin("MidiButton");
#ifndef VMS
  IL_StartTask(ILS_SEQUENCE_SERVICE);
#else
  seq_cmd.dsc$w_length = strlen (appData.sequencerName);
  seq_cmd.dsc$a_pointer = appData.sequencerName;
  status = lib$spawn (&seq_cmd, 0, 0, &flags, 0, &pid, 0, 0,
                      SequFinished, child_count);
  if (status != 1) {
     printf("Unable to Execute Rosegarden Sequencer\n");
    } else {
    printf("Rosegarden Sequencer activated\n");
    }
#endif
  YDarkenWidget(w);
  XtSetSensitive(w, False);
  SetSigHupForClient();
  End;
}


void AboutButton(Widget w, XtPointer a, XtPointer b)
{
  Begin("AboutButton");
  YMessage(XtParent(w), "About Rosegarden",
	   "Enough!", aboutText, XtNumber(aboutText));
  End;
}


void ClientFinished(char *name)
{
  Begin("ClientFinished");
  if (strncmp(name, ILS_EDIT_SERVICE, 4) == 0 ||
      strncmp(name, ILS_FOLLOW_SERVICE, 4) == 0)
    XtSetSensitive(editButton, True);
  else if (strncmp(name, ILS_SEQUENCE_SERVICE, 4) == 0 ||
	   strncmp(name, ILS_FOLLOWREADY_SERVICE, 4) == 0 ||
	   strncmp(name, ILS_PLAY_SERVICE, 4) == 0)
    XtSetSensitive(midiButton, True);
  else if (strncmp(name, ILS_HELP_SERVICE, 4) == 0)
    XtSetSensitive(helpButton, True);
  End;
}


void HelpFinished()
{
  XtSetSensitive(helpButton, True);
}

#ifdef VMS
void EditFinished()
{
    XtSetSensitive(editButton, True);
}
void SequFinished()
{
    XtSetSensitive(midiButton, True);
}
#endif

void HelpButton(Widget w, XtPointer a, XtPointer b)
{
  YHelpSetTopic("The Rosegarden Top Box");
  YHelpInstallHelp();
#ifndef VMS
  IL_AcknowledgeRequest(ILS_HELP_SERVICE, IL_SERVICE_OK);
#endif
  YDarkenWidget(w);
  XtSetSensitive(helpButton, False);
}


void CreateApplicationWidgets(void)
{
  Widget outerForm;
  Widget quitButton;
  Window w;

  Begin("CreateApplicationWidgets");

  w = RootWindowOfScreen(XtScreen(topLevel));

  YInitialise(topLevel, NULL);
  YHelpInitialise(topLevel, "Rosegarden Help", NULL, HelpFinished,
		  "The Rosegarden Help System");
  YHelpSetHelpFile(appData.helpFile);

  YShouldWarpPointer(appData.shouldWarpPointer);

  InitialiseVisuals();

  YMessageInitialise(roseMap, appData.aboutTextFont);

  outerForm   = YCreateShadedWidget
    ("Top Box", formWidgetClass, topLevel, MediumShade);
#ifndef VMS
  aboutButton = YCreateSurroundedWidget
    ("About", commandWidgetClass, outerForm, SurroundShade, NoShade);
  YSetValue(aboutButton, "shadowWidth", 0); /* in case we're 3d */

  YSetValue( aboutButton, XtNbitmap,        roseMap );
  YSetValue(    topLevel, XtNiconPixmap,    roseMap );
  YSetValue(    topLevel, XtNiconMask,  roseMaskMap );
#else
  My_aboutButton = YCreateSurroundedWidget
    ("About", commandWidgetClass, outerForm, SurroundShade, NoShade);
  YSetValue(My_aboutButton, "shadowWidth", 0); /* in case we're 3d */

  YSetValue( My_aboutButton, XtNbitmap,        roseMap );
  YSetValue(    topLevel, XtNiconPixmap,    roseMap );
  YSetValue(    topLevel, XtNiconMask,  roseMaskMap );
#endif


  editButton = YCreateCommand("Editor",    outerForm);
  midiButton = YCreateCommand("Sequencer", outerForm);
  quitButton = YCreateCommand("Quit",      outerForm);
  helpButton = YCreateCommand("Help",      outerForm);


#ifndef VMS
  YSetValue(XtParent(editButton), XtNfromHoriz, XtParent(aboutButton));
#else
  YSetValue(XtParent(editButton), XtNfromHoriz, XtParent(My_aboutButton));
#endif
  YSetValue(XtParent(midiButton), XtNfromHoriz, XtParent(editButton));
  YSetValue(XtParent(quitButton), XtNfromHoriz, XtParent(midiButton));
  YSetValue(XtParent(helpButton), XtNfromHoriz, XtParent(quitButton));

  XtAddCallback(quitButton,  XtNcallback, QuitNicelyCallback, NULL);
  XtAddCallback(editButton,  XtNcallback,         EditButton, NULL);
  XtAddCallback(midiButton,  XtNcallback,         MidiButton, NULL);
  XtAddCallback(helpButton,  XtNcallback,         HelpButton, NULL);
#ifndef VMS
  XtAddCallback(aboutButton, XtNcallback,        AboutButton, NULL);
#else
  XtAddCallback(My_aboutButton, XtNcallback,        AboutButton, NULL);
#endif

  XtRealizeWidget(topLevel);

  YHelpSetIdentifyingBitmap(roseMap);
  YHelpSetXrefFont(appData.helpXrefFont);
  YHelpSetTitleFont(appData.helpTitleFont);
  YHelpSetTextFont(appData.helpTextFont);
  YHelpSetVerbatimFont(appData.helpVerbatimFont);

  InitialiseILServer();
  InitialiseILClient();
  End;

}
