#
# Makefile for the WX RS6k AIX3 shared libraries
#

ifeq ($(SH_OBJDIR), )
SH_OBJDIR=shared
endif
ifeq ($(SH_OBJS), )
SH_OBJS= $(wildcard $(SH_OBJDIR)/*.o)
endif
ifeq ($(SHARED_DIR), )
SHARED_DIR=${top_srcdir}/lib
endif
SHARED_LIB=${SHARED_DIR}/lib${lib_name}.sa

all:: lib

.PHONY: lib
lib:: shared ${SHARED_LIB}

.PHONY: shared
shared::
	@if [ ! -d $(SH_OBJDIR) ]; then\
		mkdir -p $(SH_OBJDIR);\
	fi;

${SHARED_LIB}: $(SH_OBJS)
	${AR} cr ${SHARED_LIB}~ ${SH_OBJS}
	${NM} ${SH_OBJS} | awk '/ [BD] /{print $$3}' | sort | uniq > ${SHARED_LIB}.syms
	ld -o shr.o ${SHARED_LIB}~ -lX11 -lXt -lc -lm -H512 -T512 -bE:${SHARED_LIB}.syms -bM:SRE
	rm -f ${SHARED_LIB}~
	${AR} ruv ${SHARED_LIB}~ shr.o
	rm -f ${SHARED_LIB}.syms ${SHARED_LIB} shr.o;
	mv ${SHARED_LIB}~ ${SHARED_LIB}
	chmod a+x ${SHARED_LIB}

install:: ${SHARED_LIB}
	${INSTALL_DATA} ${SHARED_LIB} ${lib_dir}

clean::
	rm -f ${SHARED_LIB} ${SH_OBJS}
