#
# Makefile for the WX HPUX cc-based shared libraries
#

ifeq ($(SH_OBJDIR), )
SH_OBJDIR=shared
endif
ifeq ($(CC), gcc)
SH_LINK=-shared
else
#SH_LINK=-b -n
SH_LINK=-Wl,+s
endif
ifeq ($(SH_OBJS), )
SH_OBJS= $(wildcard $(SH_OBJDIR)/*.o)
endif
ifeq ($(SHARED_DIR), )
SHARED_DIR=${top_srcdir}/lib
endif
SHARED_LIB=${SHARED_DIR}/lib${lib_name}.sl

all:: lib

.PHONY: lib
lib:: shared ${SHARED_LIB}

.PHONY: shared
shared::
	@if [ ! -d $(SH_OBJDIR) ]; then\
		mkdir -p $(SH_OBJDIR);\
	fi;

${SHARED_LIB}: $(SH_OBJS)
	$(CXX) $(SH_LINK) -o ${SHARED_LIB} ${SH_OBJS}
	chmod a+x ${SHARED_LIB}

install:: ${SHARED_LIB}
	${INSTALL} ${SHARED_LIB} ${lib_dir}

clean::
	rm -f ${SHARED_LIB} ${SH_OBJS}
