#
# Makefile for the WX SunOS4 shared libraries
#

ifeq ($(SH_OBJDIR), )
SH_OBJDIR=shared
endif
ifeq ($(CC), gcc)
SH_LINK=-shared 
LINK_CMD=gcc
else
SH_LINK=-assert pure-text
LINK_CMD=CC
endif
ifeq ($(SH_OBJS), )
SH_OBJS= $(wildcard $(SH_OBJDIR)/*.o)
endif
ifeq ($(SHARED_DIR), )
SHARED_DIR=${top_srcdir}/lib
endif
SHARED_LIB=${SHARED_DIR}/lib${lib_name}.so.${major_shared}.${minor_shared}

all:: lib

.PHONY: lib
lib:: shared ${SHARED_LIB}

.PHONY: shared
shared::
	@if [ ! -d $(SH_OBJDIR) ]; then\
		mkdir -p $(SH_OBJDIR);\
	fi;

${SHARED_LIB}: $(SH_OBJS)
	$(LINK_CMD) $(SH_LINK) -o ${SHARED_LIB} ${SH_OBJS}
	chmod a+x ${SHARED_LIB}
	rm -f ${SHARED_DIR}/lib${lib_name}.so
	(cd ${SHARED_DIR}; ln -s lib${lib_name}.so.${major_shared}.${minor_shared} lib${lib_name}.so)

install:: ${SHARED_LIB}
	${INSTALL} ${SHARED_LIB} ${lib_dir}
	rm -f ${lib_dir}/lib${lib_name}.so
	ln -s ${lib_dir}/lib${lib_name}.so.${major_shared}.${minor_shared} ${lib_dir}/lib${lib_name}.so

clean::
	rm -f ${SHARED_LIB} ${SHARED_DIR}/lib${lib_name}.so ${SH_OBJS}
