
/* XTHING -- a visualization tool for 2Dimensional
 * representations of 3Dimensional data.
 *
 * Copyright 1991 John L. Cwikla
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of John L. Cwikla or
 * University of Illinois not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  John L. Cwikla and University of Illinois make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * John L. Cwikla and University of Illinois disclaim all warranties with
 * regard to this software, including all implied warranties of
 * merchantability and fitness, in no event shall John L. Cwikla or
 * University of Illinois be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * Author:
 * 	John L. Cwikla
 * 	Materials Research Laboratory Center for Computation
 * 	University Of Illinois at Urbana-Champaign
 *	104 S. Goodwin
 * 	Urbana, IL 61801
 * 
 * 	cwikla@uimrl7.mrl.uiuc.edu
*/
 
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/DrawingA.h>

#include "local.h"
#include "extern.h"

extern Pixmap ThePixmap;
Widget PeriodDA;
int PeriodExists = FALSE;
static Widget PeriodShell;
static GC TheGC;

void PeriodClose()
{
  if (PeriodExists)
  {
    XFreeGC(TheDisplay, TheGC); 
    XtDestroyWidget(PeriodShell);
    PeriodExists = FALSE;
  }
}

void Period()
{
  Widget bb;
  int i, j, n;
  Arg warg[5];
  XRectangle *rects, *rectPtr;
  int count;
  int periodX, periodY;
  char periodString[50];

  periodX = GetXPeriod();
  periodY = GetYPeriod();
  
  PeriodClose();

  sprintf(periodString,"Period -- %d X %d", periodX, periodY);
  UpdateStatus("Period by %d x %d.", periodX, periodY);
  n = 0;
  XtSetArg(warg[n], XmNx, 10); n++;
  XtSetArg(warg[n], XmNy, 10); n++;
  PeriodShell = XtCreatePopupShell(periodString, transientShellWidgetClass, TopLevel, 
	warg, n);

  n = 0;
  XtSetArg(warg[n], XmNwidth, periodX*Xdimension+20); n++;
  XtSetArg(warg[n], XmNheight, periodY*Ydimension+20); n++;
  XtSetArg(warg[n], XmNforeground, NumColors); n++;
  XtSetArg(warg[n], XmNbackground, NumColors); n++;
  bb = XtCreateManagedWidget("bb", xmBulletinBoardWidgetClass, PeriodShell,
	warg, n); 

  n = 0;
  XtSetArg(warg[n], XmNx, 10); n++;
  XtSetArg(warg[n], XmNy, 10); n++;
  XtSetArg(warg[n], XmNwidth, periodX*Xdimension); n++;
  XtSetArg(warg[n], XmNheight, periodY*Ydimension); n++;
  PeriodDA = XtCreateManagedWidget("PeriodImage", xmDrawingAreaWidgetClass, bb, warg, n);

  XtPopup(PeriodShell, XtGrabNone);

  TheGC = XCreateGC(TheDisplay, XtWindow(PeriodDA), NULL, 0);
  XtAddEventHandler(PeriodDA, ButtonPressMask, FALSE, PeriodClose, NULL);

  XSetWindowColormap(TheDisplay, XtWindow(PeriodShell), TheColormap);

  XSetWindowBackgroundPixmap(TheDisplay, XtWindow(PeriodDA), ThePixmap); 
  XClearWindow(TheDisplay, XtWindow(PeriodDA));
  PeriodExists = TRUE;
}
  
