
/* XTHING -- a visualization tool for 2Dimensional
 * representations of 3Dimensional data.
 *
 * Copyright 1991 John L. Cwikla
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of John L. Cwikla or
 * University of Illinois not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  John L. Cwikla and University of Illinois make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * John L. Cwikla and University of Illinois disclaim all warranties with
 * regard to this software, including all implied warranties of
 * merchantability and fitness, in no event shall John L. Cwikla or
 * University of Illinois be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * Author:
 * 	John L. Cwikla
 * 	Materials Research Laboratory Center for Computation
 * 	University Of Illinois at Urbana-Champaign
 *	104 S. Goodwin
 * 	Urbana, IL 61801
 * 
 * 	cwikla@uimrl7.mrl.uiuc.edu
*/
 
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/DrawingA.h>
#include <string.h>

#include "local.h"
#include "extern.h"


static Widget PicShell, TheDA;
Pixmap ThePixmap;
static GC TheGC;
static short PicOpen = FALSE;

void PicClose()
{
  if (PicOpen)
  {
    XFreePixmap(TheDisplay, ThePixmap);
    XFreeGC(TheDisplay, TheGC);
    XtDestroyWidget(PicShell);
    PicOpen = FALSE;
  }
}

void DrawPoints(XPoint *points, int length)
{
        if (length <= MaxRequests)
        {
          XDrawPoints(TheDisplay, ThePixmap, TheGC, points, length,
                CoordModeOrigin);
          XDrawPoints(TheDisplay, XtWindow(TheDA), TheGC, points, length,
                CoordModeOrigin);
        }
        else
        {
          XDrawPoints(TheDisplay, ThePixmap, TheGC, points, MaxRequests,
                CoordModeOrigin);
          XDrawPoints(TheDisplay, XtWindow(TheDA), TheGC, points, MaxRequests,
                CoordModeOrigin);
          DrawPoints(points+MaxRequests, length-MaxRequests);
        }
	XFlush(TheDisplay);
}

void DrawIt(int width, int height)
{
    int i;
    XColor *color;
    color = XtNew(XColor);

    ThePixmap = XCreatePixmap(TheDisplay, XtWindow(XThing),
                width, height, DefaultDepth(TheDisplay,
                        DefaultScreen(TheDisplay)));

    for(i=0;i<NumColors;i++)
    {
      if (PS[i].length != 0)
      {
        color->pixel = i;
        XSetForeground(TheDisplay, TheGC, i);
        DrawPoints(PS[i].points, PS[i].length);
      }
     }
     XtFree(color);
     XFlush(TheDisplay);
     XSetWindowBackgroundPixmap(TheDisplay, XtWindow(TheDA),
	ThePixmap);
}

void CreatePicShell(Widget parent, int width, int height)
{
  Widget bb, da;
  Arg warg[5];
  int n;
  char shellName[255];
  char *filename;
  char *subFilename;

  filename = GetInputFileName();

/* This is unix file specific */
  subFilename = strrchr(filename, '/');
  if (subFilename != NULL)
    sprintf(shellName, "%s - %d x %d", ++subFilename, width, height);
  else
    sprintf(shellName, "%s - %d x %d", filename, width, height);

  if (filename)
    XtFree(filename);

  PicShell = XtCreatePopupShell(shellName, transientShellWidgetClass, parent, NULL, 0);

  n = 0;
  XtSetArg(warg[n], XmNwidth, width+BORDER); n++;
  XtSetArg(warg[n], XmNheight, height+BORDER); n++;
  XtSetArg(warg[n], XmNbackground, NumColors); n++;
  XtSetArg(warg[n], XmNforeground, NumColors); n++;
  bb = XtCreateManagedWidget("bb", xmBulletinBoardWidgetClass, PicShell, warg, n);

  n = 0;
  XtSetArg(warg[n], XmNx, BORDER/2); n++;
  XtSetArg(warg[n], XmNy, BORDER/2); n++;
  XtSetArg(warg[n], XmNwidth, width); n++;
  XtSetArg(warg[n], XmNheight, height); n++;
  TheDA = XtCreateManagedWidget("XThingDA", xmDrawingAreaWidgetClass, bb, warg, n);
  XtPopup(PicShell, XtGrabNone);
  TheGC = XCreateGC(TheDisplay, XtWindow(TheDA), NULL, 0);
  XSetWindowColormap(TheDisplay, XtWindow(PicShell), TheColormap); 
  XClearWindow(TheDisplay, XtWindow(PicShell));
  PicOpen = TRUE;
}
