
/* XTHING -- a visualization tool for 2Dimensional
 * representations of 3Dimensional data.
 *
 * Copyright 1991 John L. Cwikla
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of John L. Cwikla or
 * University of Illinois not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  John L. Cwikla and University of Illinois make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * John L. Cwikla and University of Illinois disclaim all warranties with
 * regard to this software, including all implied warranties of
 * merchantability and fitness, in no event shall John L. Cwikla or
 * University of Illinois be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * Author:
 * 	John L. Cwikla
 * 	Materials Research Laboratory Center for Computation
 * 	University Of Illinois at Urbana-Champaign
 *	104 S. Goodwin
 * 	Urbana, IL 61801
 * 
 * 	cwikla@uimrl7.mrl.uiuc.edu
*/
 
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>

extern Display *TheDisplay;

#define xthing_width 50
#define xthing_height 50
static char xthing_bits[] = {
   0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0x55, 0x55, 0x55, 0x55, 0x55,
   0x55, 0x01, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0x05, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x80, 0x02, 0x05,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xb2, 0xfd, 0x66, 0xbf, 0xb1, 0xbf,
   0x02, 0xb5, 0x31, 0x66, 0x8c, 0xb3, 0x31, 0x01, 0xb2, 0x31, 0x66, 0x8c,
   0xb7, 0x81, 0x02, 0xf5, 0x31, 0x66, 0x8c, 0xbf, 0x01, 0x01, 0xe2, 0x30,
   0x7e, 0x8c, 0xbd, 0xb9, 0x02, 0xe5, 0x30, 0x66, 0x8c, 0xb9, 0x31, 0x01,
   0xf2, 0x31, 0x66, 0x8c, 0xb1, 0xb1, 0x02, 0xb5, 0x31, 0x66, 0x8c, 0xb1,
   0x31, 0x01, 0xb2, 0x31, 0x66, 0x8c, 0xb1, 0xb1, 0x02, 0xb5, 0x31, 0x66,
   0xbf, 0xb1, 0x3f, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x80, 0x02, 0x05,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x68, 0x0b, 0x00, 0x80,
   0x02, 0x05, 0x00, 0x68, 0x0b, 0x00, 0x00, 0x01, 0x02, 0x00, 0x48, 0x0a,
   0x00, 0x80, 0x02, 0x05, 0x00, 0x48, 0x0a, 0x00, 0x00, 0x01, 0x02, 0x00,
   0x00, 0x00, 0x00, 0x80, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x82, 0x4f, 0x20, 0x0e, 0x8a, 0x80, 0x02, 0x05, 0x42, 0x20, 0x02, 0xa8,
   0x0e, 0x01, 0x02, 0x42, 0x20, 0xa2, 0x9a, 0x8c, 0x02, 0x85, 0xda, 0x26,
   0xe2, 0x9a, 0x0a, 0x01, 0x82, 0xdb, 0x66, 0xee, 0xaa, 0x8e, 0x02, 0x05,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x80,
   0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00,
   0x00, 0x00, 0x00, 0x80, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x02, 0x00, 0x00, 0x00, 0x00, 0x80, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x01, 0x02, 0x7c, 0x2f, 0xbc, 0xf7, 0x80, 0x02, 0x05, 0x54, 0x29,
   0x84, 0x10, 0x00, 0x01, 0x02, 0x44, 0x2f, 0x84, 0x11, 0x80, 0x02, 0x05,
   0x44, 0x25, 0x84, 0x10, 0x00, 0x01, 0x02, 0x44, 0x29, 0x84, 0x10, 0x80,
   0x02, 0x05, 0x44, 0xe9, 0xbd, 0xf0, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00,
   0x00, 0x00, 0x00, 0x80, 0x02, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x01,
   0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0x55, 0x55, 0x55, 0x55, 0x55,
   0x55, 0x01};

void SetIcon(Widget _w)
{
  Pixmap iconPixmap;
  Arg warg[3];
  int n = 0;
  iconPixmap = XCreateBitmapFromData(TheDisplay, XtWindow(_w),
	xthing_bits, xthing_width, xthing_height);
  XtSetArg(warg[n], XmNiconPixmap, iconPixmap); n++;
  XtSetValues(_w, warg, n);
}

