/* yacc -d user.y */
#line 1 "user.y"

/*
 *	user interface
 */
# include	"min_reversi.h"
# include	<stdio.h>
# include	<signal.h>

extern boardT	board, saveBoard;
extern int	saved;
extern int	savePlayer;
extern int	atend;
extern int	atbegin;
extern int	level;
extern int	player;
extern int	maxlev, movex, movey;
extern int	x, y;
extern int	com;
extern int	gotsignal;
extern char	sbuf[80];
extern char	ebuf[80];
extern int	sdebug, mdebug;
extern FILE	*rfile;
extern int	first;
extern int	defcom;
extern int	showScore;

extern struct move	saveGame[64];
extern struct move	*saveP;

#define MOVE	257
#define LEVEL	258
#define COMPUTER	259
#define UNDO	260
#define HINT	261
#define PLAY	262
#define RECORD	263
#define REPLAY	264
#define SAVE	265
#define RESTART	266
#define NEW	267
#define GAME	268
#define QUIT	269
#define GRID	270
#define NOGRID	271
#define HELP	272
#define NOHELP	273
#define SCORE	274
#define NOSCORE	275
#define DEBUG	276
#define EVAL	277
#define FROM	278
#define INTO	279
#define TO	280
#define FILEe	281
#define NO	282
#define NUMBER	283
#define LETTER	284
#define COMMA	285
#define NL	286
#define STRING	287
#define SEMI	288
#define EOG	289
#define ERR	290
#define WH	291
#define BL	292
#define HUMAN	293
#define BOTH	294
#define NEITHER	295
#define NONE	296
#define FIRST	297
#define SECOND	298
extern int yychar, yyerrflag;
#ifndef YYSTYPE
#define YYSTYPE int
#endif
extern YYSTYPE yyval;
extern YYSTYPE yylval;
#line 253 "user.y"
yyerror (s)
char	*s;
{
	dispError (s);
}

yywrap ()
{
	return 1;
}

playGameCurses ()
{
    return yyparse ();
}
static short yydef[] = {
	  -1,  -13,  -23,  -33,   52,   52,   52,   52,  -39,  -45, 
	 -49,  -55,  -59,  -65,  -71,  -77,  -83,  -87,  -91,  -97,   41
};
static short yyex[] = {
	   0,    0,  283,   64,  284,   64,  286,   65,  288,   65, 
	  -1,    1,  256,   52,  286,   52,  288,   52,  290,   52, 
	  -1,   61,  256,   52,  286,   52,  288,   52,  290,   52, 
	  -1,   60,  286,   63,  288,   63,   -1,    1,  286,    9, 
	 288,    9,   -1,    1,  287,   59,   -1,    1,  286,    8, 
	 288,    8,   -1,    1,  287,   59,   -1,    1,  286,    7, 
	 288,    7,   -1,    1,  286,    6,  288,    6,   -1,    1, 
	 286,    5,  288,    5,   -1,    1,  286,    4,  288,    4, 
	  -1,    1,  284,   62,   -1,    1,  283,   62,   -1,    1, 
	 286,    3,  288,    3,   -1,    1,  283,   64,  284,   64, 
	 286,   65,  288,   65,   -1,    1
};
static short yyact[] = {
	  -8,  -71,   -7,  -36,  -45,  -40,   -6,   -3,   -2,  -32, 
	  -4,  -46,  -59,  -57,  -49,  -48,  -56,  -55,  -29,  -30, 
	 -63,  -38,  -37,  -35,  -34,  -81,  -80,   -5,  -75,  298, 
	 297,  296,  295,  294,  293,  292,  291,  289,  282,  276, 
	 275,  274,  273,  272,  271,  270,  269,  267,  266,  265, 
	 264,  262,  261,  260,  259,  258,  257,  256,  -77,  -76, 
	 280,  279,  -78,  278,  -70,  -69,  288,  286,  -72,  268, 
	 -51,  -50,  298,  297,  -36,  -38,  -37,  -35,  -34,  -81, 
	 -80,  296,  295,  294,  293,  292,  291,  259,  -53,  283, 
	 -58,  -47,  -54,  274,  272,  270,  -60,  287,  -17,  -18, 
	 284,  283,  -21,  -20,  288,  286,  -39,  -74,  290,  256, 
	 -79,  281,  -73,  285,  -71,   -7,  -36,  -45,  -40,   -6, 
	  -3,   -2,  -32,   -4,  -46,  -59,  -57,  -49,  -48,  -56, 
	 -55,  -29,  -30,  -63,  -38,  -37,  -35,  -34,  -81,  -80, 
	  -5,  -75,  298,  297,  296,  295,  294,  293,  292,  291, 
	 289,  282,  276,  275,  274,  273,  272,  271,  270,  269, 
	 267,  266,  265,  264,  262,  261,  260,  259,  258,  257, 
	 -41,  287,  -42,  287,  -61,  284,  -62,  283,   -1
};
static short yypact[] = {
	  29,   60,   63,   69,   70,   81,   89,  102,  108,  111, 
	 108,  111,  108,  108,  108,  108,  113,  113,  108,  142, 
	 170,  177,  175,  173,  171,   66,  104,  100,   97,   93, 
	  72,   66
};
static short yygo[] = {
	  -1,  -27,  -65,  -66,   20,  -67,  -68,   19,  -11,  -14, 
	 -15,  -16,  -19,  -13,   -9,   74,    7,    6,    5,    4, 
	   2,  -28,  -22,  -23,   17,  -52,  -31,    5,  -26,  -44, 
	 -43,   25,  -12,  -24,  -25,   11,  -10,  -33,   -1
};
static short yypgo[] = {
	   0,    0,    0,    1,    6,    6,    6,    6,    6,    6, 
	  26,   26,   26,   26,   26,   26,   14,    6,    6,    6, 
	   6,    6,    6,    6,    6,    6,    6,    6,    6,    6, 
	   6,    6,    6,    6,    6,    6,    6,    6,    6,    6, 
	   6,    3,    0,    0,    1,    1,   30,   30,   21,   28, 
	  23,   14,   14,   36,   36,   32,   34,   37,   37,   34, 
	  32,   36,   23,   28,   21,    6,    0
};
static short yyrlen[] = {
	   0,    0,    0,    2,    2,    2,    2,    2,    2,    2, 
	   1,    1,    1,    1,    1,    1,    2,    1,    4,    4, 
	   2,    3,    1,    1,    2,    1,    1,    2,    2,    2, 
	   2,    2,    1,    1,    1,    2,    1,    2,    4,    4, 
	   1,    0,    4,    1,    3,    1,    1,    1,    1,    1, 
	   1,    2,    0,    1,    1,    1,    1,    1,    1,    0, 
	   0,    0,    0,    0,    0,    0,    2
};
#define YYS0	63
#define YYDELTA	22
#define YYNPACT	32
#define YYNDEF	21

#define YYr64	0
#define YYr65	1
#define YYr66	2
#define YYr6	3
#define YYr19	4
#define YYr21	5
#define YYr23	6
#define YYr25	7
#define YYr34	8
#define YYr36	9
#define YYr61	10
#define YYr60	11
#define YYr59	12
#define YYr58	13
#define YYr57	14
#define YYr56	15
#define YYr46	16
#define YYr37	17
#define YYr35	18
#define YYr33	19
#define YYr32	20
#define YYr31	21
#define YYr30	22
#define YYr29	23
#define YYr28	24
#define YYr27	25
#define YYr26	26
#define YYr24	27
#define YYr22	28
#define YYr20	29
#define YYr18	30
#define YYr17	31
#define YYr16	32
#define YYr15	33
#define YYr14	34
#define YYr13	35
#define YYr12	36
#define YYr11	37
#define YYr10	38
#define YYr9	39
#define YYr8	40
#define YYr3	41
#define YYrACCEPT	YYr64
#define YYrERROR	YYr65
#define YYrLR2	YYr66
#line 2 "/etc/yyparse.c"

/*
*****************************************************************************
**									    *
**  Copyright  Digital Equipment Corporation, 1990, 1991, 1992, 1993	    *
**  All Rights Reserved.  Unpublished rights reserved under  the  copyright *
**  laws of the United States.						    *
**									    *
**  The software contained on this media is proprietary to and embodies the *
**  confidential  technology of Digital Equipment Corporation.  Possession, *
**  use,  duplication  or  dissemination  of  the  software  and  media  is *
**  authorized  only  pursuant  to  a  valid  written  license from Digital *
**  Equipment Corporation.						    *
**									    *
**  RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure by the  U.S. *
**  Government  is  subject  to  restrictions  as set forth in Subparagraph *
**  (c)(1)(ii) of DFARS 252.227-7013, or in FAR 52.227-19, as applicable.   *
**									    *
*****************************************************************************
*/

/*
 * Copyright 1985, 1990 by Mortice Kern Systems Inc.  All rights reserved.
 *
 * This Software is unpublished, valuable, confidential property of
 * Mortice Kern Systems Inc.  Use is authorized only in accordance
 * with the terms and conditions of the source licence agreement
 * protecting this Software.  Any unauthorized use or disclosure of
 * this Software is strictly prohibited and will result in the
 * termination of the licence agreement.
 *
 * If you have any questions, please consult your supervisor.
 * 
 * Automaton to interpret LALR(1) tables.
 *
 *	Macros:
 *		yyclearin - clear the lookahead token.
 *		yyerrok - forgive a pending error
 *		YYERROR - simulate an error
 *		YYACCEPT - halt and return 0
 *		YYABORT - halt and return 1
 *		YYRETURN(value) - halt and return value.  You should use this
 *			instead of return(value).
 *		YYREAD - ensure yychar contains a lookahead token by reading
 *			one if it does not.  See also YYSYNC.
 *		YYRECOVERING - 1 if syntax error detected and not recovered
 *			yet; otherwise, 0.
 *
 *	Preprocessor flags:
 *		YYDEBUG - includes debug code.  The parser will print
 *			 a travelogue of the parse if this is defined
 *			 and yydebug is non-zero.
 *		YYSSIZE - size of state and value stacks (default 150).
 *		YYSTATIC - By default, the state stack is an automatic array.
 *			If this is defined, the stack will be static.
 *			In either case, the value stack is static.
 *		YYALLOC - Dynamically allocate both the state and value stacks
 *			by calling malloc() and free().
 *		YYLR2 - defined if lookahead is needed to resolve R/R or S/R conflicts
 *		YYSYNC - if defined, yacc guarantees to fetch a lookahead token
 *			before any action, even if it doesnt need it for a decision.
 *			If YYSYNC is defined, YYREAD will never be necessary unless
 *			the user explicitly sets yychar = -1
 *
 *	Copyright (c) 1983, by the University of Waterloo
 */

/* GENTEXT: yyerror */
#ifndef I18N
#define	gettext(x)	x 
#else
#define	gettext(x)	x             /* <<< modified! */
#endif

#ifndef YYSSIZE
# define YYSSIZE	150
#endif
#ifndef	YYDEBUG
#define	YYDEBUG	0
#endif
#define YYERROR		goto yyerrlabel
#define yyerrok		yyerrflag = 0
#define yyclearin	yychar = -1
#define YYACCEPT	YYRETURN(0)
#define YYABORT		YYRETURN(1)
#define YYRECOVERING()	(yyerrflag != 0)
#ifdef YYALLOC
# define YYRETURN(val)	{ retval = (val); goto yyReturn; }
#else
# define YYRETURN(val)	return(val)
#endif
#if YYDEBUG
/* The if..else makes this macro behave exactly like a statement */
# define YYREAD	if (yychar < 0) {					\
			if ((yychar = yylex()) < 0)			\
				yychar = 0;				\
			if (yydebug)					\
				printf(gettext("read %s (%d)\n"), 	\
				yyptok(yychar),				\
				yychar);				\
		} else
#else
# define YYREAD	if (yychar < 0) {					\
			if ((yychar = yylex()) < 0)			\
				yychar = 0;				\
		} else
#endif
#define YYERRCODE	256		/* value of `error' */
#if 0 && defined(__TURBOC__) && __SMALL__
	/* THIS ONLY WORKS ON TURBO C 1.5 !!! */
#define	YYQYYP	*(int *)((int)yyq + ((int)yyq-(int)yyp))
#else
#define	YYQYYP	yyq[yyq-yyp]
#endif

YYSTYPE	yyval;				/* $$ */
YYSTYPE	*yypvt;				/* $n */
YYSTYPE	yylval;				/* yylex() sets this */

int	yychar,				/* current token */
	yyerrflag,			/* error flag */
	yynerrs;			/* error count */

#if YYDEBUG
int yydebug = 0;		/* debug flag & tables */
extern char	*yysvar[], *yystoken[], *yyptok();
extern short	yyrmap[], yysmap[];
extern int	yynstate, yynvar, yyntoken, yynrule;
# define yyassert(condition, msg, arg) \
	if (!(condition)) { printf(gettext("\nyacc bug: ")); printf(msg, arg); YYABORT; }
#else /* !YYDEBUG */
# define yyassert(condition, msg, arg)
#endif

yyparse()
{

	register short		yyi, *yyp;	/* for table lookup */
	register short		*yyps;		/* top of state stack */
	register short		yystate;	/* current state */
	register YYSTYPE	*yypv;		/* top of value stack */
	register short		*yyq;
	register int		yyj;

#ifdef YYSTATIC
	static short	yys[YYSSIZE + 1];
	static YYSTYPE	yyv[YYSSIZE + 1];
#else
#ifdef YYALLOC
	YYSTYPE *yyv;
	short	*yys;
	YYSTYPE save_yylval;
	YYSTYPE save_yyval;
	YYSTYPE *save_yypvt;
	int save_yychar, save_yyerrflag, save_yynerrs;
	int retval;
#if 0	/* defined in <stdlib.h>*/
	extern char	*malloc();
#endif
#else
	short		yys[YYSSIZE + 1];
	static YYSTYPE	yyv[YYSSIZE + 1];	/* historically static */
#endif
#endif

#ifdef YYALLOC
	yys = (short *) malloc((YYSSIZE + 1) * sizeof(short));
	yyv = (YYSTYPE *) malloc((YYSSIZE + 1) * sizeof(YYSTYPE));
	if (yys == (short *)0 || yyv == (YYSTYPE *)0) {
		yyerror("Not enough space for parser stacks");
		return 1;
	}
	save_yylval = yylval;
	save_yyval = yyval;
	save_yypvt = yypvt;
	save_yychar = yychar;
	save_yyerrflag = yyerrflag;
	save_yynerrs = yynerrs;
#endif

	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;
	yyps = yys;
	yypv = yyv;
	yystate = YYS0;		/* start state */

yyStack:
	yyassert((unsigned)yystate < yynstate, gettext("state %d\n"), yystate);
	if (++yyps > &yys[YYSSIZE]) {
		yyerror("Parser stack overflow");
		YYABORT;
	}
	*yyps = yystate;	/* stack current state */
	*++yypv = yyval;	/* ... and value */

#if YYDEBUG
	if (yydebug)
		printf(gettext("state %d (%d), char %s (%d)\n"),yysmap[yystate],
			yystate, yyptok(yychar), yychar);
#endif

	/*
	 *	Look up next action in action table.
	 */
yyEncore:
#ifdef YYSYNC
	YYREAD;
#endif
	if (yystate >= sizeof yypact/sizeof yypact[0]) 	/* simple state */
		yyi = yystate - YYDELTA;	/* reduce in any case */
	else {
		if(*(yyp = &yyact[yypact[yystate]]) >= 0) {
			/* Look for a shift on yychar */
#ifndef YYSYNC
			YYREAD;
#endif
			yyq = yyp;
			yyi = yychar;
#if 0 && defined(__TURBOC__) && __SMALL__
	/* THIS ONLY WORKS ON TURBO C 1.5 !!! */
			/* yyi is in di, yyp is in si */
		L01:
			asm lodsw	/* ax = *yyp++; */
			asm cmp yyi, ax
			asm jl L01
#else
			while (yyi < *yyp++)
				;
#endif
			if (yyi == yyp[-1]) {
				yystate = ~YYQYYP;
#if YYDEBUG
				if (yydebug)
					printf(gettext("shift %d (%d)\n"),
						yysmap[yystate], yystate);
#endif
				yyval = yylval;		/* stack what yylex() set */
				yychar = -1;		/* clear token */
				if (yyerrflag)
					yyerrflag--;	/* successful shift */
				goto yyStack;
			}
		}

		/*
	 	 *	Fell through - take default action
	 	 */

		if (yystate >= sizeof yydef /sizeof yydef[0])
			goto yyError;
		if ((yyi = yydef[yystate]) < 0)	 { /* default == reduce? */
											/* Search exception table */
			yyassert((unsigned)~yyi < sizeof yyex/sizeof yyex[0],
				gettext("exception %d\n"), yystate);
			yyp = &yyex[~yyi];
#ifndef YYSYNC
			YYREAD;
#endif
			while((yyi = *yyp) >= 0 && yyi != yychar)
				yyp += 2;
			yyi = yyp[1];
			yyassert(yyi >= 0,
				 gettext("Ex table not reduce %d\n"), yyi);
		}
	}

#ifdef YYLR2
yyReduce:	/* reduce yyi */
#endif
	yyassert((unsigned)yyi < yynrule, gettext("reduce %d\n"), yyi);
	yyj = yyrlen[yyi];
#if YYDEBUG
	if (yydebug) printf(gettext("reduce %d (%d), pops %d (%d)\n"), 
		yyrmap[yyi], yyi, yysmap[yyps[-yyj]], yyps[-yyj]);
#endif
	yyps -= yyj;		/* pop stacks */
	yypvt = yypv;		/* save top */
	yypv -= yyj;
	yyval = yypv[1];	/* default action $$ = $1 */
	switch (yyi) {		/* perform semantic action */
		
case YYr3: {	/* prompt :  */
#line 46 "user.y"

		    checkInput ();
		    readLine ();
		
} break;

case YYr6: {	/* commands :  error oerror */
#line 54 "user.y"

			dispHelp ();
		
} break;

case YYr8: {	/* command :  EOG */
#line 60 "user.y"

			YYACCEPT;
		
} break;

case YYr9: {	/* command :  omove LETTER ocomma NUMBER */
#line 64 "user.y"

			domove (yypvt[0], yypvt[-2] - 'a' + 1);
		
} break;

case YYr10: {	/* command :  omove NUMBER ocomma LETTER */
#line 68 "user.y"

			domove (yypvt[-2], yypvt[0] - 'a' + 1);
		
} break;

case YYr11: {	/* command :  DEBUG STRING */
#line 72 "user.y"

			register char	*s;
			register int	v;

			v = 1;
			for (s = sbuf; *s; ++s)
				switch (*s) {
				case 'm':
					mdebug = v;
					break;
				case 's':
					sdebug = v;
					break;
				case '!':
					v = !v;
					break;
				}
		
} break;

case YYr12: {	/* command :  GRID */
#line 91 "user.y"

			dispGrid ();
		
} break;

case YYr13: {	/* command :  NO GRID */
#line 95 "user.y"

			dispNoGrid ();
		
} break;

case YYr14: {	/* command :  NOGRID */
#line 99 "user.y"

			dispNoGrid ();
		
} break;

case YYr15: {	/* command :  SCORE */
#line 103 "user.y"

			showScore = 1;
			dispScore (board);
		
} break;

case YYr16: {	/* command :  NOSCORE */
#line 108 "user.y"

			showScore = 0;
			dispNoScore ();
		
} break;

case YYr17: {	/* command :  NO SCORE */
#line 113 "user.y"

			showScore = 0;
			dispNoScore ();
		
} break;

case YYr18: {	/* command :  LEVEL NUMBER */
#line 118 "user.y"

			level = yypvt[0];
		
} break;

case YYr19: {	/* command :  LEVEL oerror */
#line 122 "user.y"

			sprintf (ebuf, "current level is %d", level);
			dispError (ebuf);
		
} break;

case YYr20: {	/* command :  PLAY whichp */
#line 127 "user.y"

			if (yypvt[0] == WHITE || yypvt[0] == BLACK) 
				defcom = yypvt[0];
			com = yypvt[0];
		
} break;

case YYr21: {	/* command :  PLAY oerror */
#line 133 "user.y"

			dispError ("play (white black both none)");
		
} break;

case YYr22: {	/* command :  whichp FIRST */
#line 137 "user.y"

			if (yypvt[-1] == WHITE || yypvt[-1] == BLACK)
				first = yypvt[-1];
			if (atbegin)
				player = first;
		
} break;

case YYr23: {	/* command :  FIRST oerror */
#line 144 "user.y"

			dispError ("(white black you me) first");
		
} break;

case YYr24: {	/* command :  whichp SECOND */
#line 148 "user.y"

			if (yypvt[-1] == WHITE || yypvt[-1] == BLACK)
				first = - yypvt[-1];
			if (atbegin)
				player = first;
		
} break;

case YYr25: {	/* command :  SECOND oerror */
#line 155 "user.y"

			dispError ("(white black you me) second");
		
} break;

case YYr26: {	/* command :  HELP */
#line 159 "user.y"

			dispHelp ();
		
} break;

case YYr27: {	/* command :  NOHELP */
#line 163 "user.y"

			dispNoHelp ();
		
} break;

case YYr28: {	/* command :  NO HELP */
#line 167 "user.y"

			dispNoHelp ();
		
} break;

case YYr29: {	/* command :  QUIT */
#line 171 "user.y"

			YYACCEPT;
		
} break;

case YYr30: {	/* command :  UNDO */
#line 175 "user.y"

		    undo ();
		
} break;

case YYr31: {	/* command :  NEW ogame eoc */
#line 179 "user.y"

			YYABORT;
		
} break;

case YYr32: {	/* command :  RESTART eoc */
#line 183 "user.y"

			YYABORT;
		
} break;

case YYr33: {	/* command :  REPLAY ofrom ofile STRING */
#line 187 "user.y"

			replay (sbuf);
		
} break;

case YYr34: {	/* command :  REPLAY oerror */
#line 191 "user.y"

			dispError ("replay \"file\"");
		
} break;

case YYr35: {	/* command :  SAVE ointo ofile STRING */
#line 195 "user.y"

		    save (sbuf);
		
} break;

case YYr36: {	/* command :  SAVE oerror */
#line 199 "user.y"

			dispError ("save \"file\"");
		
} break;

case YYr37: {	/* command :  HINT */
#line 203 "user.y"

		    doHint ();
		
} break;

case YYr46: {	/* oerror :  oerror error */
#line 220 "user.y"

			yyerrok;
		
} break;

case YYr56: {	/* whichp :  WH */
#line 237 "user.y"
 yyval = WHITE; 
} break;

case YYr57: {	/* whichp :  BL */
#line 239 "user.y"
 yyval = BLACK; 
} break;

case YYr58: {	/* whichp :  COMPUTER */
#line 241 "user.y"
 yyval = com==WHITE?WHITE:BLACK; 
} break;

case YYr59: {	/* whichp :  HUMAN */
#line 243 "user.y"
 yyval = com==WHITE?BLACK:WHITE; 
} break;

case YYr60: {	/* whichp :  BOTH */
#line 245 "user.y"
 yyval = 0; 
} break;

case YYr61: {	/* whichp :  none */
#line 247 "user.y"
 yyval = 2; 
} break;
#line 237 "/etc/yyparse.c"
	case YYrACCEPT:
		YYACCEPT;
	case YYrERROR:
		goto yyError;
#ifdef YYLR2
	case YYrLR2:
#ifndef YYSYNC
		YYREAD;
#endif
		yyj = 0;
		while(yylr2[yyj] >= 0) {
			if(yylr2[yyj] == yystate && yylr2[yyj+1] == yychar
			&& yylook(yys+1,yyps,yystate,yychar,yy2lex(),yylr2[yyj+2]))
					break;
			yyj += 3;
		}
		if(yylr2[yyj] < 0)
			goto yyError;
		if(yylr2[yyj+2] < 0) {
			yystate = ~ yylr2[yyj+2];
			goto yyStack;
		}
		yyi = yylr2[yyj+2];
		goto yyReduce;
#endif
	}

	/*
	 *	Look up next state in goto table.
	 */

	yyp = &yygo[yypgo[yyi]];
	yyq = yyp++;
	yyi = *yyps;
#if	0 && defined(__TURBOC__) && __SMALL__
	/* THIS ONLY WORKS ON TURBO C 1.5 !!! */
	/* yyi is in di, yyp is in si */
L02:
	asm lodsw		/* ax = *yyp++; */
	asm cmp yyi, ax
	asm jl L02
#else
	while (yyi < *yyp++)
		;
#endif
	yystate = ~(yyi == *--yyp? YYQYYP: *yyq);
	goto yyStack;

yyerrlabel:	;		/* come here from YYERROR	*/
/*
#pragma used yyerrlabel
 */
	yyerrflag = 1;
	if (yyi == YYrERROR)
		yyps--, yypv--;
	
yyError:
	switch (yyerrflag) {

	case 0:		/* new error */
		yynerrs++;
		yyi = yychar;
		yyerror("Syntax error");
		if (yyi != yychar) {
			/* user has changed the current token */
			/* try again */
			yyerrflag++;	/* avoid loops */
			goto yyEncore;
		}

	case 1:		/* partially recovered */
	case 2:
		yyerrflag = 3;	/* need 3 valid shifts to recover */
			
		/*
		 *	Pop states, looking for a
		 *	shift on `error'.
		 */

		for ( ; yyps > yys; yyps--, yypv--) {
			if (*yyps >= sizeof yypact/sizeof yypact[0])
				continue;
			yyp = &yyact[yypact[*yyps]];
			yyq = yyp;
			do
				;
			while (YYERRCODE < *yyp++);
			if (YYERRCODE == yyp[-1]) {
				yystate = ~YYQYYP;
				goto yyStack;
			}
				
			/* no shift in this state */
#if YYDEBUG
			if (yydebug && yyps > yys+1)
				printf(
	gettext("Error recovery pops state %d (%d), uncovers %d (%d)\n"),
					yysmap[yyps[0]], yyps[0],
					yysmap[yyps[-1]], yyps[-1]);
#endif
			/* pop stacks; try again */
		}
		/* no shift on error - abort */
		break;

	case 3:
		/*
		 *	Erroneous token after
		 *	an error - discard it.
		 */

		if (yychar == 0)  /* but not EOF */
			break;
#if YYDEBUG
		if (yydebug)
			printf(gettext("Error recovery discards %s (%d), "),
				yyptok(yychar), yychar);
#endif
		yyclearin;
		goto yyEncore;	/* try again in same state */
	}
	YYABORT;

#ifdef YYALLOC
yyReturn:
	yylval = save_yylval;
	yyval = save_yyval;
	yypvt = save_yypvt;
	yychar = save_yychar;
	yyerrflag = save_yyerrflag;
	yynerrs = save_yynerrs;
	free((char *)yys);
	free((char *)yyv);
	return(retval);
#endif
}

#ifdef YYLR2
yylook(s,rsp,state,c1,c2,i)
short *s;		/* stack		*/
short *rsp;		/* real top of stack	*/
int state;		/* current state	*/
int c1;			/* current char		*/
int c2;			/* next char		*/
int i;			/* action S < 0, R >= 0	*/
{
	int j;
	short *p,*q;
	short *sb,*st;
#if YYDEBUG
	if(yydebug) {
	printf(gettext("LR2 state %d (%d) char %s (%d) lookahead %s (%d)"),
			yysmap[state],state,yyptok(c1),c1,yyptok(c2),c2);
		if(i > 0)
			printf(gettext("reduce %d (%d)\n"), yyrmap[i], i);
		else
			printf(gettext("shift %d (%d)\n"), yysmap[i], i);
	}
#endif
	st = sb = rsp+1;
	if(i >= 0)
		goto reduce;
  shift:
	state = ~i;
	c1 = c2;
	if(c1 < 0)
		return 1;
	c2 = -1;

  stack:
  	if(++st >= &s[YYSSIZE]) {
		yyerror("Parser Stack Overflow");
		return 0;
	}
	*st = state;
	if(state >= sizeof yypact/sizeof yypact[0])
		i = state- YYDELTA;
	else {
		p = &yyact[yypact[state]];
		q = p;
		i = c1;
		while(i < *p++)
			;
		if(i == p[-1]) {
			state = ~q[q-p];
			c1 = c2;
			if(c1 < 0)
				return 1;
			c2 = -1;
			goto stack;
		}
		if(state >= sizeof yydef/sizeof yydef[0])
			return 0;
		if((i = yydef[state]) < 0) {
			p = &yyex[~i];
			while((i = *p) >= 0 && i != c1)
				p += 2;
			i = p[1];
		}
	}
  reduce:
  	j = yyrlen[i];
	if(st-sb >= j)
		st -= j;
	else {
		rsp -= j+st-sb;
		st = sb;
	}
	switch(i) {
	case YYrERROR:
		return 0;
	case YYrACCEPT:
		return 1;
	case YYrLR2:
		j = 0;
		while(yylr2[j] >= 0) {
			if(yylr2[j] == state && yylr2[j+1] == c1)
				if((i = yylr2[j+2]) < 0)
					goto shift;
				else
					goto reduce;
		}
		return 0;
	}
	p = &yygo[yypgo[i]];
	q = p++;
	i = st==sb ? *rsp : *st;
	while(i < *p++);
	state = ~(i == *--p? q[q-p]: *q);
	goto stack;
}
#endif
		
#if YYDEBUG
	
/*
 *	Print a token legibly.
 *	This won't work if you roll your own token numbers,
 *	but I've found it useful.
 */
char *
yyptok(i)
{
	static char	buf[10];

	if (i >= YYERRCODE)
		return yystoken[i-YYERRCODE];
	if (i < 0)
		return "";
	if (i == 0)
		return "$end";
	if (i < ' ')
		sprintf(buf, "'^%c'", i+'@');
	else
		sprintf(buf, "'%c'", i);
	return buf;
}
#endif
#if YYDEBUG
char * yystoken[] = {
	"error",
	"MOVE",
	"LEVEL",
	"COMPUTER",
	"UNDO",
	"HINT",
	"PLAY",
	"RECORD",
	"REPLAY",
	"SAVE",
	"RESTART",
	"NEW",
	"GAME",
	"QUIT",
	"GRID",
	"NOGRID",
	"HELP",
	"NOHELP",
	"SCORE",
	"NOSCORE",
	"DEBUG",
	"EVAL",
	"FROM",
	"INTO",
	"TO",
	"FILEe",
	"NO",
	"NUMBER",
	"LETTER",
	"COMMA",
	"NL",
	"STRING",
	"SEMI",
	"EOG",
	"ERR",
	"WH",
	"BL",
	"HUMAN",
	"BOTH",
	"NEITHER",
	"NONE",
	"FIRST",
	"SECOND",
	0
};
char * yysvar[] = {	"$accept",
	"game",
	"commands",
	"prompt",
	"command",
	"oerror",
	"omove",
	"ocomma",
	"whichp",
	"ogame",
	"eoc",
	"ofrom",
	"ofile",
	"ointo",
	"none",
	0
};
short yyrmap[] = {
	  64,   65,   66,    6,   19,   21,   23,   25,   34,   36, 
	  61,   60,   59,   58,   57,   56,   46,   37,   35,   33, 
	  32,   31,   30,   29,   28,   27,   26,   24,   22,   20, 
	  18,   17,   16,   15,   14,   13,   12,   11,   10,    9, 
	   8,    3,    1,    2,    4,    5,   38,   39,   40,   42, 
	  44,   47,   48,   49,   50,   52,   54,   62,   63,   55, 
	  53,   51,   45,   43,   41,    7,    0
};
short yysmap[] = {
	   2,   13,   14,   16,   22,   24,   25,   34,   39,   40, 
	  42,   43,   49,   50,   53,   55,   61,   62,   63,   64, 
	  65,   74,   73,   70,   69,   48,   36,   32,   31,   29, 
	  23,   15,    5,    6,    7,    8,    9,   10,   67,   12, 
	  77,   78,   46,   71,   17,   18,   57,   19,   20,   51, 
	  52,   54,   56,   58,   26,   27,   28,   59,   30,   60, 
	  79,   80,   33,    0,   76,    1,   75,   35,   45,   44, 
	  11,   47,   72,   66,   21,   38,   37,   41,   68,    4,    3
};
int yyntoken = 44;
int yynvar = 15;
int yynstate = 81;
int yynrule = 67;
#endif
