C AUTH.FOR

        Logical Function Do_Auth ()

        Include 'News.Def'

C External routines

        Integer		Auth_Cmd	! Send a command to the server.

C Local variables

        Character *255	Buf		! Buffer for stuff from server.
        Integer		Lg		! Length of the response.

c+
c       Send an AUTHINFO command to the server.  We then get back
c       whether we're authorized to use this server or not.
C
c	Dialog should look like this:
c	authinfo user username
c	381 send the rest
c	authinfo pass password
c	281 ok, you're authorized.
c	
c	Other error codes related to authorization include:
c	 281 ok_auth authorization is ok
c	 381 need_authdata send password
c	 480 err_noauth need to authorize for this command
c	 482 err_authrej already done, or order is wrong
c	 502 err_access authorization rejected; wrong password
c-

c+++
C Assume that we are going to fail.
c---
	Do_Auth = .FALSE.

C+++
C send the username, and check to make sure we got NEED_AUTHDATA
C---
	If (.not. Auth_Cmd
	1	('authinfo user ' // Authinfo_User,Buf,Lg)) Then
	    Return			! server failure
	EndIf

	If (Buf(1:3) .eq. '482') Then
	    Call SMG_All_Print
	1 ('Confused. Server wants authorization, but then doesn''t.')
	    Do_Auth = .TRUE.
	    Return
	EndIf

	If (Buf(1:3) .ne. '381') Then
	    Call SMG_All_Print
	1 ('Unexpected response from server. Moving boldly forward.')
	    Call SMG_All_Print(Buf(:Lg))
	EndIf

C+++
C now, send the password.
C---
	If (.not. Auth_Cmd
	1	('authinfo pass ' // Authinfo_Pass,Buf,Lg)) Then
	    Return 			! server failure
	EndIf

	If (Buf(1:3) .eq. '502') Then
	    Call SMG_All_Print
	1 ('Server indicates that your password is invalid.')
	    Return
	Endif

	If (Buf(1:3) .ne. '281') Then
	    Call SMG_All_Print
	1 ('Server has returned an unexpected response. Going on.')
	    Call SMG_All_Print(Buf(:Lg))
	Endif

	Do_Auth = .TRUE.		! authorized OK!
	Return

	End

	Integer Function Auth_Cmd (Cmd, Rsp, Lg)

C a srv_cmd to be used by auth

	Implicit None

c	Include 'Network.Def'

	Character *(*)		Cmd
	Character *(*)		Rsp
	Integer	  *4		Lg

	Integer			Srv_Send
	Integer			Srv_Recv

	Auth_Cmd = Srv_Send (Cmd)
	If (.not. Auth_Cmd) Then
	  Return
	EndIf

	Auth_Cmd = Srv_Recv (Rsp, Lg)

	Return

	End ! of Auth_Cmd

C
C The following is NNTP.H from NNTP.1.5.10
C
c/*
c * Response codes for NNTP server
c *
c * @(#)$Header: nntp.h,v 1.8 90/07/05 02:08:31 sob Exp $
c *
c * First digit:
c *
c *	1xx	Informative message
c *	2xx	Command ok
c *	3xx	Command ok so far, continue
c *	4xx	Command was correct, but couldn't be performed
c *		for some specified reason.
c *	5xx	Command unimplemented, incorrect, or a
c *		program error has occured.
c *
c * Second digit:
c *
c *	x0x	Connection, setup, miscellaneous
c *	x1x	Newsgroup selection
c *	x2x	Article selection
c *	x3x	Distribution
c *	x4x	Posting
c */
c
c#define	CHAR_INF	'1'
c#define	CHAR_OK		'2'
c#define	CHAR_CONT	'3'
c#define	CHAR_ERR	'4'
c#define	CHAR_FATAL	'5'
c
c#define	INF_HELP	100	/* Help text on way */
c#define	INF_AUTH	180	/* Authorization capabilities */
c#define	INF_DEBUG	199	/* Debug output */
c
c#define	OK_CANPOST	200	/* Hello; you can post */
c#define	OK_NOPOST	201	/* Hello; you can't post */
c#define	OK_SLAVE	202	/* Slave status noted */
c#define	OK_GOODBYE	205	/* Closing connection */
c#define	OK_GROUP	211	/* Group selected */
c#define	OK_GROUPS	215	/* Newsgroups follow */
c#define	OK_ARTICLE	220	/* Article (head & body) follows */
c#define	OK_HEAD		221	/* Head follows */
c#define	OK_BODY		222	/* Body follows */
c#define	OK_NOTEXT	223	/* No text sent -- stat, next, last */
c#define	OK_NEWNEWS	230	/* New articles by message-id follow */
c#define	OK_NEWGROUPS	231	/* New newsgroups follow */
c#define	OK_XFERED	235	/* Article transferred successfully */
c#define	OK_POSTED	240	/* Article posted successfully */
c#define	OK_AUTHSYS	280	/* Authorization system ok */
c#define	OK_AUTH		281	/* Authorization (user/pass) ok */
c
c#define	CONT_XFER	335	/* Continue to send article */
c#define	CONT_POST	340	/* Continue to post article */
c#define	NEED_AUTHINFO	380	/* authorization is required */
c#define	NEED_AUTHDATA	381	/* <type> authorization data required */
c
c#define	ERR_GOODBYE	400	/* Have to hang up for some reason */
c#define	ERR_NOGROUP	411	/* No such newsgroup */
c#define	ERR_NCING	412	/* Not currently in newsgroup */
c#define	ERR_NOCRNT	420	/* No current article selected */
c#define	ERR_NONEXT	421	/* No next article in this group */
c#define	ERR_NOPREV	422	/* No previous article in this group */
c#define	ERR_NOARTIG	423	/* No such article in this group */
c#define	ERR_NOART	430	/* No such article at all */
c#define	ERR_GOTIT	435	/* Already got that article, don't send */
c#define	ERR_XFERFAIL	436	/* Transfer failed */
c#define	ERR_XFERRJCT	437	/* Article rejected, don't resend */
c#define	ERR_NOPOST	440	/* Posting not allowed */
c#define	ERR_POSTFAIL	441	/* Posting failed */
c#define	ERR_NOAUTH	480	/* authorization required for command */
c#define	ERR_AUTHSYS	481	/* Authorization system invalid */
c#define	ERR_AUTHREJ	482	/* Authorization data rejected */
c
c#define	ERR_COMMAND	500	/* Command not recognized */
c#define	ERR_CMDSYN	501	/* Command syntax error */
c#define	ERR_ACCESS	502	/* Access to server denied */
c#define	ERR_FAULT	503	/* Program fault, command not performed */
c#define	ERR_AUTHBAD	580	/* Authorization Failed */
c
c/* RFC 977 defines this; don't change it. */
c
c#define	NNTP_STRLEN	512
