C CLI.FOR - - command line interface routines           Pat Rankin, May'88
C                                             (adapted for VNews, Apr'90)
C					      (jms installed vnews 1.4, 3/91)
*  i*4  Cli_Present ( label )
*  i*4  Cli_Get_Value ( label, result, reslen )
*  i*4  Cli_Parse_Command ( tables, verb, prompt )
*  i*4  Get_Cli_Number ( key, result )          ![not used]
*  sub  VNews_Cli_Init ( )
*


	INTEGER *4 FUNCTION  Cli_Present ( label )
C
C Call CLI$PRESENT with signalling disabled.
C

	implicit none

C	input:

	CHARACTER *(*)  label

C     functions:

	INTEGER *4      CLI$PRESENT
	EXTERNAL        LIB$SIG_TO_RET

	CALL LIB$ESTABLISH( LIB$SIG_TO_RET)
	Cli_Present = CLI$PRESENT( label)
	RETURN

	END !of Cli_Present


	INTEGER *4 FUNCTION  Cli_Get_Value ( label, result, reslen )
C
C   Call CLI$GET_VALUE with signalling disabled.
C

	implicit none

C     input:

	CHARACTER *(*)  label

C     output:

	CHARACTER *(*)  result
	INTEGER *2      reslen

C     functions:

	INTEGER *4      CLI$GET_VALUE
	EXTERNAL        LIB$SIG_TO_RET

	CALL LIB$ESTABLISH( LIB$SIG_TO_RET)
	reslen = 0
	Cli_Get_Value = CLI$GET_VALUE( label, result, reslen)
	RETURN

	END !of Cli_Get_Value


	INTEGER *4 FUNCTION  Cli_Parse_Command ( tables, verb, prompt )

C 
C Fetch user's command line and parse it.  If he used "RUN,"
C there was no chance to supply one, so prompt for it now.
C


	implicit none
C     constant:

	INCLUDE '($FSCNdef)/nolist'             !filescan defs
	INCLUDE '($CliVERBdef)/nolist'          !cli verb defs
*-      INCLUDE '($CliSERVdef)/nolist'          !cli service defs
	PARAMETER       CLI$K_GETCMD = '00000001'x  !get command line

	INCLUDE '($DSCdef)/nolist'              !descriptor defs

	STRUCTURE /dsc_d/               !dynamic string descriptor
	    INTEGER *2  d_len  /0/
	    BYTE        d_typ  /DSC$K_DTYPE_T/      !ascii text
	    BYTE        d_cls  /DSC$K_CLASS_D/      !dynamic
	    INTEGER *4  d_adr  /0/
	END STRUCTURE !dsc_d

	STRUCTURE /dsc_z/               !unspecified string descriptor
	    INTEGER *2  d_len  /0/
	    BYTE        d_typ  /0/,  d_cls  /0/     !type & class unspecified
	    INTEGER *4  d_adr  /0/
	END STRUCTURE !dsc_d

	STRUCTURE /clirq/               !cli request block
	    BYTE            rqtype/0/, rqindx/0/, rqflags/0/, rqstat /0/
	    INTEGER *4     %FILL(1) 
	    RECORD /dsc_z/  rdesc               !descriptor initialized to 0's
	    INTEGER *4     %FILL(3) 
	END STRUCTURE !clirq

	STRUCTURE /fscn/                !short itemlist for $filescan
	    INTEGER *2      len /0/,  code /0/
	    INTEGER *4      adr /0/,  end_of_list /0/
	END STRUCTURE !fscn

C     input:

	EXTERNAL        tables          !command tables [set command/obj]
	CHARACTER *(*)  verb,  prompt   !command verb and prompt strings

C     local:

	RECORD /dsc_d/  parse           !descriptor for dynamic string
	RECORD /clirq/  cmd             !command interface request block
	RECORD /fscn/   fscn            !item list for $filescan
	INTEGER *4      sts             !return status value

C     functions:

	INTEGER *4      SYS$CLI,  CLI$DCL_PARSE
	EXTERNAL        LIB$SIG_TO_RET,  LIB$GET_INPUT

	CALL LIB$ESTABLISH( LIB$SIG_TO_RET)     !suppress error signals

C     get command line

	cmd.rqtype = CLI$K_GETCMD       !request is 'get command line'
	sts = SYS$CLI( cmd,,)

	IF ( sts ) THEN         !ok => cli available & verb wasn't "RUN"

C invoked via symbol => have command line (which might be empty)
C [might also be invoked via mcr or dcl; that's ok]

	    IF ( cmd.rqstat .EQ. CLI$K_VERB_MCR ) THEN  !strip image name -
		fscn.code = FSCN$_FILESPEC              !+ from MCR invocation
		CALL SYS$FILESCAN( cmd.rdesc, fscn,)
		cmd.rdesc.d_len = cmd.rdesc.d_len - fscn.len  !shrink size
		cmd.rdesc.d_adr = cmd.rdesc.d_adr + fscn.len  !advance ptr
	    END IF 

C prepend verb and parse the command line

	    CALL STR$CONCAT( parse, verb, ' ', cmd.rdesc)
	    sts = CLI$DCL_PARSE( parse, tables)

	ELSE        ! RUN (might be "no cli present" [CLI$_INVREQTYP])

C invoked via run => get a substitute command line from the user
	    sts = CLI$DCL_PARSE(, tables, LIB$GET_INPUT,
     &                          LIB$GET_INPUT, prompt)
	END IF ! (sts)

	Cli_Parse_Command = sts
	RETURN

	END !of Cli_Parse_Command

	INTEGER *4 FUNCTION  Get_Cli_Number ( key, result )
C
C Use CLI routine to obtain a parameter or qualifier value
C and convert the resulting string into a binary integer.
C

	implicit none

C     input:

	CHARACTER *(*)  key

C     output:

	INTEGER *4      result

C     local:

	CHARACTER *32   value
	INTEGER *2      ln
	INTEGER *4      sts

C     functions:

	INTEGER *4      Cli_Get_Value,  OTS$CVT_TI_L

	result = 0
	sts = Cli_Get_Value( key, value, ln)
	IF ( sts )  sts = OTS$CVT_TI_L( value(:ln), result)

	Get_Cli_Number = sts
	RETURN

	END !of Get_Cli_Number


	subroutine  VNews_Cli_Init ( )

C 
C Make sure that DCL has parsed our command line.
C [Patched together from some similar routines; signal code moved in-line.]
C

	implicit none

c     constant:
	include '($SHRdef)/nolist'              !shared message status codes
	parameter       CLI$_SYNTAX = '000310FC'x       !cli-f-syntax
	character *(*)  fACILITY_NAME,  fACILITY_PROMPT
	parameter     ( fACILITY_NAME = 'VNEWS' )
	parameter     ( fACILITY_PROMPT = fACILITY_NAME // ' args> ' )
	external        VNews_Cmd               !from SET COMMAND/OBJECT

c     local:

	integer *4      msgvec(0:7)     !message vector
	integer *4      arg_dsc(2)      !simplified string descriptor
	integer *4      sts

C     functions:

	integer *4      Cli_Present,  Cli_Parse_Command
	integer         LIB$MATCH_COND

C     check for a parameter or qualifier that isn't part of the RUN verb.

	sts = Cli_Present( 'HEADER')

C     did we get a syntax error?

	if ( LIB$MATCH_COND( sts, CLI$_SYNTAX) .gt. 0 ) then

C         syntax error indicates we weren't invoked as a native dcl command,
C             so we now want to generate a command and parse it
	    sts = Cli_Parse_Command( VNews_Cmd,      !command table
     &                              fACILITY_NAME, fACILITY_PROMPT)

	    if ( .not. sts ) then
C             if there's a problem, give up with error message
C                 "%VNEWS-F-PARSEFAIL, error parsing VNEWS command"
C                 "-CLI-W-IVfoo, unrecognized foo - check documentation"
		arg_dsc(1) =  LEN( fACILITY_NAME // ' command' )
		arg_dsc(2) = %LOC( fACILITY_NAME // ' command' )

		msgvec(0) = 4           !vector contains 4 longwords
C                 set primary condition:  severity=fatal, facility=non-system
		msgvec(1) = SHR$_PARSEFAIL .or. '08000004'x
		msgvec(2) = 1           !1 fao arg follows
		msgvec(3) = %LOC(arg_dsc)   !(pointer to "VNEWS command")
		msgvec(4) = sts         !secondary condition (CLI error)
		msgvec(5) = 0           !dummy entries (just in case)
		msgvec(6) = 0
		msgvec(7) = 0

		call SYS$PUTMSG( msgvec,, fACILITY_NAME,)
		sts = msgvec(1) .or. '10000000'x    !set message inhibit bit
		call SYS$EXIT(%VAL(sts))
	    end if
	end if

	return
	end !of VNews_Cli_Init
