C CLOSE_NEWSRC.FOR

	Integer Function Close_Newsrc ()

	Include 'News.Def'

C External definitions

	Integer			TrimLg

C Local Definitions

	Logical			First
	Integer    *4		G
	Character  *(MAX_NEWSRC_LINE)	Image
	Integer	   *4		R
	Integer    *4		Status
	Integer    *4		X

	Integer    *4           S,    E
	Character  *8		S_C,  E_C
	Integer    *4		S_Lg, E_Lg, N_LG ! VNEWS 1.3-4

C Begin Close_Newsrc

	If (Newsrc_Is_Open) Then
	    Close (LU_Newsrc)
	EndIf

	Open
	1 (
	2 Unit		= LU_Newsrc,
	3 File		= NewsRC_Loc(:TrimLG(NewsRC_Loc))//'XX.Newsrc',
	4 Status	= 'New',
	5 Form		= 'Formatted',
	6 CarriageControl = 'List',
	7 Recl		= MAX_NEWSRC_LINE,
	8 IOStat	= Status
	9 )

	G = 1

	If (Status .ne. 0) Then
	  Close_Newsrc = 0
	  Return
	EndIf

C Wander through all groups

	Do While (G .le. Group_Count)
c
c	VNEWS 1.3-4	Kevin Oberman
c	modified to write only active entries out to the XX.NEWSRC file
c	non-active entries branch to the else statement where the user is
c	notified they are being removed.
c

	  If (Group(G).Active_File) Then

C Start image with group name.

	    X = TrimLg (Group(G).Name)
	    If (X .GT. MAX_NEWSRC_LINE) Then
	      Call SMG_All_Print
	1 ('The range for your group is too complex. Skipping '//
	2 Group(G).Name(1:TrimLg(Group(G).NAME)) )
	      Call SMG_All_Print
	1 ('You must manually re-subscribe to this group.')
	      Goto 117
	    EndIf
	    Image(1:X) = Group(G).Name(1:X)

C Now add subscribed flag

	    X = X + 1
	    If (Group(G).Subscribed) Then
	      Image(X:X) = ':'
	    Else
	      Image(X:X) = '!'
	    EndIf

C Wander through all ranges for this group
c
c    VNEWS 1.3-4	John McMahon
c    Do not write ranges out for groups that you aren't subscribed to
c    (if then labeled 123)
c    Do not write ranges out for groups that start ABOVE the current
c    Active End Point.  (if then labeled 234)
c    (e.g. If active end is 502, do not write a range that starts with 1128).
c    Skip ranges which end BELOW the current Active Starting Point
c    (vnews 1.4   Pat Rankin 910325)
c
123	    If (Group(G).Subscribed) Then

	      R = Group(G).Range_First
	      First = .true.

	      Do While (R .ne. 0)

		S = Range(R).Start
		E = Range(R).End

234		If (S .Le. Group(G).Active_End .and.
	1	    E .Ge. Group(G).Active_Start) Then

		   If (.not. First) Then
		     X = X + 1
		     Image(X:X) = ','
		   Else
		     First = .false.
		   EndIf

		   Call ItoS (S, S_C, S_Lg)
		   Image(X+1:X+S_Lg) = S_C(1:S_Lg)
		   X = X + S_Lg
		   If (Range(R).End .ne. Range(R).Start) Then
		      X = X + 1
		      Image(X:X) = '-'
		      Call ItoS (E, E_C, E_Lg)
		      Image(X+1:X+E_Lg) = E_C(1:E_Lg)
		      X = X + E_Lg
		   EndIf ! If Range(R)

		End If ! (S .le. )

		R = Range(R).Next

	      End Do ! (R .ne. 0)

	    Endif ! (if subscribed)
c
c	Error branch inserted by John McMahon - 14-MAR-1990
c	a user could end up with a blank XX.NEWSRC if they had enough
c	quota to open a file, but not complete writing to it.
c

	    Write (LU_Newsrc, '(A)',ERR=88 ) Image(1:X)

	  Else

		N_Lg = TrimLg (Group(G).Name)
		Call SMG_All_Print
	1	  ('Group '// Group(G).Name(1:N_Lg)
	2	  // ' has been deleted from the news server.')

	  EndIf ! If Group(G).Active_File

117	  G = G + 1
	End Do ! (G .le. Group_Count)

C Return success
C VNEWS 1.4/jms/910327.  Close the file early and often.

	Close (LU_Newsrc)
	Close_Newsrc = 1

	Return

c
c	Error during Write routine - John McMahon  15-MAR-1990 (VNEWS 1.3-3)
c
c	Issue an error message warning the user.  Return a bad status.
c	Delete the junk file...
c

88		Call SMG_All_Print
	1 ('WARNING: Error during write of new XX.NEWSRC file.')
	        Call SMG_All_Print('All changes have been lost.')

		Close (LU_Newsrc,DISP='DELETE')

		Close_Newsrc = 0

	END ! of Close_NewsRC
