C CMD.FOR - VNEWS Command handling

	Subroutine Cmd_AddKillfile (G, S, U, Buf)
C
C Open an existing KILL file (or create a new one if the old one does
C not exist) and add subjects to the file. Also, delete the current
C subject as well.
C JMH - 5/12/89
C
C Vnews 1.4/jms/910327 - make 72 column safe
C
	Include 'News.Def'

C Parameter definitions

	Integer   *4    G
	Integer   *4    S
	Integer   *4    U
	Character *(*)  Buf

C External routines

	Integer         TrimLg
	Integer		UnRead

C Local Definitions

	Character *64   FileName
	Character *80   Image
	Integer   *4    Status
	Integer   *4    Lg
	Integer   *4    X
	Integer         ImageLg
	Character *128	Subject
	Integer	  *4	Subject_Lg

C Create the filename from group name

	FileName = Group(G).Name
	X = 1
	Lg = TrimLg (FileName)
	Do While (X .le. Lg)
	  If (FileName(X:X) .eq. '.') FileName(X:X) = '_'
	  X = X + 1
	EndDo

	FileName = FileName(1:TrimLg(FileName))//'.KILL'

C Open the Kill file

	Open
	1	(
	1	Unit 	   = LU_KillFile,
	1	File		   = FileName,
	1	DefaultFile     = UserDirectory,
	1	Status	   = 'Old',
	1	Form		   = 'Formatted',
	1	CarriageControl = 'List',
	1	Access	   = 'Append',
	1	IOStat	   = Status
	1	)

	If (Status .ne. 0) Then         ! no kill file, make new one
	  Open
	1	(
	1	Unit            = LU_KillFile,
	1	File            = FileName,
	1	DefaultFile     = UserDirectory,
	1	Status          = 'New',
	1	Form            = 'Formatted',
	1	CarriageControl = 'List',
	1	IOStat          = Status
	1	)
	End If
C
C Put the info in the file
C
	If (Index (Buf, '/') .eq. 0) Then
C
C Send XHdg Subject command to retrieve subject line for article
C
	  Call CacheHdr (S, Subject, Subject_Lg)

C Remove article number from front of subject line

	  Call ItoS (S, Image, ImageLg)

	  Subject = Subject(2+ImageLg:)
	  Subject_Lg = Subject_Lg - ImageLg
	  Call STR_Strip_Re (Subject, Subject_Lg)
	Else
C
C The user specified it on the command line
C
	  Subject = Buf(Index (Buf, '/')+1:)
	  If (Index (Subject, '/') .NE. 0) Then
	    Subject = Subject (:Index (Subject, '/') - 1)
	  End If
	  Subject_Lg = TrimLg(Subject)
	End If

	Write (LU_KillFile, '(A)') '/'//Subject(1:Subject_Lg)

	Call SMG_All_Print 
	1	(
	1	'Subject "'//Subject(1:Subject_Lg)//
	1	'" has been added to the killfile'
	1	)
	Close (LU_KillFile)

C Now kill all articles with the subject in the header

	Call Cmd_ArticleKill (G, S, U, '/'//Subject)

C Finally, update unread count

	U = UnRead (G)			! Update unread article count
	Call Lib$Wait(3.0)		! VNEWS 1.3-4 Kevin Oberman
					! Let the user read the messages b4
					! continuing.

	Return

	End ! of Cmd_AddKillfile

	Logical Function Cmd_ArticleCatchUp (G, A, Cmd, U)

	Include 'News.Def'

C Description
C
C   Handles the catchup command...
C
C     Catchup [article]
C
C   Marks all articles through and including article as read.
C   Default article is last article in the group.
C
C   Returns:
C
C     .true.  all articles read
C     .false. some articles remain

C Parameter definitions

	Integer   *4	G		! Group number
	Integer   *4	A		! Article
	Character *(*)	Cmd		! Catchup command string
	Integer   *4	U		! Unread article count, updated

C External routines

	Integer		Range_Allocate
	Integer		UnRead
	Integer		SMG_Prompt
	Logical		Get_Integer

C Local definitions

	Integer   *4    Status
	Integer   *4	L, R, X
	Integer   *4    Lg
	Character *4    Confirm

C Begin Cmd_ArticleCatchUp

C Make sure that the user knows what will happen and give a chance
C to abort

C Added "NoAsk" option. Vnews 1.4/paf/910327

	Cmd_ArticleCatchUp = .FALSE.		! alpha/jms/921026

	If (.not. NoAsk) Then

	  Status = SMG_Prompt
	1	(
	1	Confirm,
	1	'Do you really want to mark everything as read? [yn] ',
	1	Lg
	1	)
	  Call STR$Upcase (Confirm,Confirm)
	  If (Confirm(1:1) .ne. 'Y') Return

	EndIf

C Get the last article to be caught up from the command
C+++
C Vnews 1.4/Alain Cedelle/910416. Updated to use new Get_Integer 
C---
	X = Index (Cmd, ' ')
	L = 0
	Lg = Len(Cmd)
	If ( X .ne. 0 ) Then
	    If ( .not. Get_Integer(Cmd(X:Lg),X,L) ) Then
		L = Group(G).Active_End
	    EndIf
	EndIf

C If no last article, use entire group active file range

	If (L .eq. 0) Then
	  L = Group(G).Active_End
	EndIf

C Calulate return value


	If (L .ge. Group(G).Active_End) Then
	  Cmd_ArticleCatchUp = .true.
	Else
	  Cmd_ArticleCatchUp = .false.
	EndIf

C Find the first range beyond L

	R = Group(G).Range_First
	X = 0

	Do While ((R .ne. 0) .and. (L .ge. Range(R).End))
	  X = R
	  R = Range(R).Next	
	EndDo

C R is the Range following L or zero, X is the Range in front of
C L or zero.

C Release all ranges from Group(G).Range_First - X.  These ranges
C contain articles less than L.

	If (X .ne. 0) Then
	  Range(X).Next = 0
	  X = Group(G).Range_First
	  Call Range_Deallocate (X)
	  Group(G).Range_First = R
	EndIf

C Several cases can arise.
C
C   R = 0			All ranges have been released, get
C				a new one and set it to 1-L
C
C   L < R.Start			Add a new range to the
C				Group from 1-L
C
C   R.Start <= L < R.End        Set R.Start = 1
C
C   L >= R.End			Impossible

	If (R .eq. 0) Then
	  R = Range_Allocate ()
	  Range(R).Start = 1
	  Range(R).End   = L
	  Range(R).Next  = 0
	  Group(G).Range_First = R
	  Group(G).Range_Last = R
	Else If (L .lt. Range(R).Start) Then
	  X = Range_Allocate ()
	  Group(G).Range_First = X
	  Range(X).Start = 1
	  Range(X).End = L
	  Range(X).Next = R
	  Call Range_Combine (X, R)
	Else If
	1 ((L .ge. Range(R).Start) .and. (L .lt. Range(R).End)) Then
	  Range(R).Start = 1
	Else
	  Call SMG_All_Print ('Catchup error. Submit an SPR.')
	  Stop
	EndIf

	A = L

	U = UnRead (G)			! Update unread mail count

	Return

	End ! of Cmd_ArticleCatchUp

	Subroutine Cmd_ArticleDisplay ( A, Rotate_Flag)

	Include 'News.Def'

C Parameter definitions

	Integer   *4	A	! Article number
	Logical		Rotate_Flag

C External routines

	Integer		Srv_Cmd

C Local definitions

	Character *128	Cmd
	Integer   *4	Lg
	Integer   *4	Status

C Begin Cmd_ArticleDisplay

	Call More_Heading

	Messages_Read = Messages_Read + 1

	Write (Cmd, '(A, I6)') 'head ', A
	Status = Srv_Cmd (Cmd(1:11), Cmd, Lg)
	If (.not. Status) Then
	  Call SMG_All_Print ('Server failed')
	  Stop
	EndIf
	If (Cmd(1:3) .eq. '221') Then
	  Call Srv_RdTxt (.true., .false., srv_rdtxt_check)
	Else
	  Call SMG_All_Print ('Unexpected server response')
	  Call SMG_All_Print (Cmd(1:Lg))
	  Return
	EndIf

	Call SMG_All_Print (' ')

	Write (Cmd, '(A, I6)') 'body ', A
	Status = Srv_Cmd (Cmd(1:11), Cmd, Lg)
	If (.not. Status) Then
	  Call SMG_All_Print ('Server failed')
	  Stop
	EndIf
	If (Cmd(1:3) .eq. '222') Then
	  Call Srv_RdTxt (.true., Rotate_Flag, srv_rdtxt_dont)
	Else
	  Call SMG_All_Print ('Unexpected server response')
	  Call SMG_All_Print (Cmd(1:Lg))
	  Return
	EndIf

	End ! of Cmd_ArticleDisplay

	Integer Function Cmd_ArticleFindSubj (Buf, G, A, Pattern)

C************************************************************************
C John Howells  8/12/88
C
C this routine added to locate a subject with the '/pattern' command
C
C************************************************************************

	Include 'News.Def'

C Parameter definition

	Integer   *4		G	! Group number
	Integer   *4		A	! Article number

C External routines

	Integer			Range_Find

C Local definitions

	Integer   *4		I
	Integer   *4		I_Lg
	Character *8		I_C
	Integer	  *4		Subject_Lg
	Integer   *4		Status
	Integer   *4		STR$Upcase
	Character *512		Buf
	Character *128		Subject
	Integer   *4		XSubject_Lg
	Character *128		XSubject
	Character *(*)		Pattern

C Begin Cmd_ArticleFindSubj

	Cmd_ArticleFindSubj = .FALSE.		! alpha/jms/921026

	If (Buf(2:2) .eq. ' ') Then
	   If (Pattern .eq. ' ') Then
	      Call SMG_All_Print ('No pattern specified')
	      Return
	   Else
	      Subject = Pattern
	      Subject_Lg = Index(Subject,'  ')-1
	      Pattern = Subject
	   End If
	Else
	   Subject = Buf(2:128)
	   Subject_Lg = index(Subject,'  ')-1
	   Pattern = Subject
	End If

C Display subject being looked for

	Call SMG_All_Print
	1	('Searching for: ' // Subject(1:Subject_Lg))

C Convert Subject to uppercase

	Call STR$Upcase (Subject,Subject)

C Page through articles looking for this subject

	Do I = Group(G).Active_Start, Group(G).Active_End

	    If (Range_Find(G, I, .false.) .eq. 0) Then

	      Call CacheHdr (I, XSubject, XSubject_Lg)

C Remove article number from front of subject line

	      Call ItoS (I, I_C, I_Lg)

	      If (XSubject_Lg .gt. I_Lg) Then

	        XSubject(1:XSubject_Lg-I_Lg) =
	1		XSubject(1+I_Lg:XSubject_Lg)
	        XSubject_Lg = XSubject_Lg - I_Lg
		Call STR$Upcase (XSubject,XSubject)
	        Status = Index(XSubject(1:XSubject_Lg),
	1			Subject(1:Subject_Lg))
	        If (Status .gt. 0) Then
		  Cmd_ArticleFindSubj = .true.
		  A = I
		  Return
	        EndIf

	      EndIf ! (XSubject_Lg .gt. I_Lg)

	    EndIf ! (Range_Find(G, I, .false.) .eq. 0)

	End Do

	Call SMG_All_Print ('No articles found')
	Cmd_ArticleFindSubj = .false.
	Return

	End ! of Cmd_ArticleFindSubj

	Integer Function Cmd_ArticleFirst (G, A)

	Include 'News.Def'

C Parameter definition

	Integer   *4		G	! Group number
	Integer   *4		A	! Article number

C Entry point definitions

	Integer			Cmd_ArticleLast

C External routines

	Integer			Range_Find

C Local definitions

	Integer   *4		E, D, I, S

C Begin Cmd_ArticleFirst

	S = Group(G).Active_Start
	E = Group(G).Active_End
	D = +1
	Goto 1

C Begin Cmd_ArticleLast

	Entry Cmd_ArticleLast (G, A)

	S = Group(G).Active_End
	E = Group(G).Active_Start
	D = -1
	Goto 1

C Page through articles looking for first unread

1	Do I = S, E, D

	  If (Range_Find(G, I, .false.) .eq. 0) Then

	    A = I
	    Cmd_ArticleFirst = .true.
	    Return

	  EndIf

	End Do

C No unread articles found

	Call SMG_All_Print ('No unread articles found')
	Cmd_ArticleFirst = .false.
	Return

	End ! of Cmd_ArticleFirst

	Subroutine Cmd_ArticleKill (G, A, U, Buf)
        
	Include 'News.Def'
        
C       Parameter definition
        
	Integer   *4		G	! Group number
	Integer   *4		A	! Article number
	Integer   *4            U	! Unread article count, updated
	Character *(*)		Buf	! Buffer the user typed in.

C Constants

	Parameter MAX_Subject_Length = 25	! Where we truncate at.

C External routines

	Integer			Range_Find
	Integer			TrimLg

C Local definitions

	Integer   *4		Buff_Lg
	Character *80		Buff
	Integer   *4		I
	Logical			Kill_Article
	Integer			Killed
	Logical			Partial_Flag
	Character *128		Subject
	Integer	  *4		Subject_Lg
	Integer   *4		Status
	Character *128		UpSubject
	Integer	  *4		UpSubject_Lg
	Character *128		XSubject
	Integer   *4		XSubject_Lg

C Begin Cmd_ArticleKill

	Killed = 0

	If (Index (Buf, '/') .EQ. 0) Then
C+
C	  Send XHdg Subject command to retrieve subject line for article
C-
	  Call CacheHdr (A, Subject, Subject_Lg)
C+
C Remove article number from front of subject line
C-
	  Call ItoS (A, Buff, Buff_Lg)

	  If (Buff_Lg .lt. Subject_Lg) Then

	    Subject = Subject(2+Buff_Lg:)
	    Subject_Lg = Subject_Lg - Buff_Lg
	    UpSubject_Lg = Subject_Lg
	    CALL STR$UPCASE (UpSubject, Subject)
	    CALL STR_Strip_Re (UpSubject, UpSubject_Lg)
	  Else
	    Go to 1
	  End If
	  Partial_Flag = .FALSE.
	Else
C+
C	  The user specified it on the command line
C-
	  Subject = Buf(Index (Buf, '/')+1:)
	  If (Index (Subject, '/') .NE. 0) Then
	    Subject = Subject (:Index (Subject, '/') - 1)
	  End If
	  CALL STR$UPCASE (UpSubject, Subject)
	  UpSubject_Lg = TrimLg (UpSubject)
	  Subject_Lg = TrimLg (Subject)
	  Partial_Flag = .TRUE.
	End If
	UpSubject_Lg = MIN (UpSubject_Lg, MAX_SUBJECT_LENGTH)

C Display subject being killed

	Call SMG_All_Print
	1	('Searching for: ' // Subject(1:Subject_Lg))

C Page through articles looking for this subject

	Do I = Group(G).Active_Start, Group(G).Active_End

	  If (Range_Find(G, I, .false.) .eq. 0) Then

	    Call CacheHdr (I, XSubject, XSubject_Lg)

C Remove article number from front of subject line

	    Call ItoS (I, Buff, Buff_Lg)

	    If (XSubject_Lg .gt. Buff_Lg) Then

	      XSubject = XSubject(2+Buff_Lg:)
	      XSubject_Lg = XSubject_Lg - Buff_Lg
	      CALL STR$UPCASE (XSubject (1:XSubject_Lg), XSubject)
	      CALL Str_Strip_Re (XSubject, XSubject_Lg)
	      IF (.NOT. Partial_Flag) THEN
	        XSubject_Lg = MIN (XSubject_Lg, MAX_SUBJECT_LENGTH)
	      End If

	      If (Partial_Flag) THEN
	        Kill_Article = Index (XSubject,
	1		UpSubject(:UpSubject_Lg)) .NE. 0
	      Else
	        Kill_Article = UpSubject(1:UpSubject_Lg) .eq.
	1		XSubject(1:XSubject_Lg)
	      End If

	      If (Kill_Article) THEN
	        Status = Range_Find (G, I, .true., U)
	        CALL SYS$FAO ('Killed: !UL', Buff_Lg, Buff, %val(I))
	        Call SMG_All_Print (Buff(1:Buff_Lg))
	        Killed = Killed + 1
	      End If

	    EndIf
	  EndIf                 ! (Range_Find(G, I, .false.) .eq. 0)
	End Do


1	If (Killed .EQ. 0) Then
	  Call SMG_All_Print ('No articles killed')
	Else
	  CALL SYS$FAO ('Killed !UL message!%S',Buff_Lg, Buff, 
	1		%Val(Killed))
	  Call SMG_All_Print (Buff(1:Buff_Lg))
	End If

	End ! of Cmd_ArticleKill

	Subroutine Cmd_ArticleList (G, CatchUp_Cmd)

	Include 'News.Def'
	Include 'SMG.Def'

C Description
C
C   Handles the....
C
C     Dir [article]
C
C   command.  Produces a short list of the subject lines
C   of un read articles in the group starting with article.
C   Default article is first available from the active file.

C Parameter definitions

	Integer   *4	G
	Character *(*)	CatchUp_Cmd

C External Routines

	Integer   	Range_Find
	Logical		Get_Integer

C Local definitions

	Integer   *4	A
	Integer   *4	X
	Integer   *4	Lg
	Integer   *4	Subject_Lg
	Character *128  Subject
	
C Begin Cmd_ArticleList

	Call More_Heading
	More_Input = ' '

C Get the article number

	X = Index (CatchUp_Cmd, ' ')
	A = 0
	Lg = Len(CatchUp_Cmd)
	If ( X .ne. 0) Then
	    If ( .not. Get_Integer(CatchUp_Cmd(X:Lg),X,A) ) Then
		A = Group(G).Active_Start
	    EndIf
	EndIf

	If (A .eq. 0) Then
	  A = Group(G).Active_Start
	EndIf

C Get all the subject lines

C+++
C OK, here's the problem.  If there is a 500-level error message,
C then we can't tell the difference between that and a message
C with a number of 500 and a valid subject.  So, we make
C two bold assumptions:
C	No message in a group will have a number of 500 and a
C		subject line beginning with "command"
C AND
C	All servers begin the error after "500" with "command."
C
C May the gods of computer programming forgive me for this sin.
C jms/910416/vnews 1.4
C---

	Do While
	1	(
	1	(A .le. Group(G).Active_End)
	1	.and.
	1	(More_Input .eq. ' ')
	1	)

	  If (Range_Find (G, A, .false.) .eq. 0) Then

	    Call CacheHdr (A, Subject, Subject_Lg)
	    If (Subject(1:4) .eq. '500 ') Then
		If (Subject(1:11) .eq. '500 Command' .or.
	1	    Subject(1:11) .eq. '500 COMMAND' .or.
	2	    Subject(1:11) .eq. '500 command') Then
		    Call SMG_All_Print
	1		('XHDR command failure. Directory abort!')
		    Return
		Endif
	    EndIf
	    Call SMG_More_Print (Subject(1:Subject_Lg))

	  EndIf

	  A = A + 1

	End Do

	Return

	End ! of Cmd_ArticleList

	Subroutine Cmd_ArticleMark (G, A, U)

	Include 'News.Def'

C Parameter definition

	Integer   *4	G		! Group number
	Integer   *4 	A		! Article number
	Integer   *4	U		! Unread article count, updated

C External routines

	Integer		Range_Allocate

C Local definitions

	Logical		Found
	Integer   *4	P, Q, R

C Begin Cmd_ArticleMark

C Find range containing this article

	Found = .false.
	P = 0
	R = Group(G).Range_First
	Do While ((.not. Found) .and. (R .ne. 0))
	  If ((A .ge. Range(R).Start) .and. (A .le. Range(R).End)) Then
	    Found = .true.
	  Else
	    P = R
	    R = Range(R).Next
	  EndIf
	EndDo

C If no range found for this article, then we are done since its already
C marked as unread.

	If (.not. Found) Then
	  Return
	EndIf

C Range found, three cases can arise

	If (A . eq. Range(R).Start) Then

C Article is first in range

	  Range(R).Start = Range(R).Start + 1

	ElseIf (A .eq. Range(R).End) Then

C Article is last in range

	  Range(R).End = Range(R).End - 1

	Else

C Article is within the range but not at either end point

C Get a new range and set it up from the old start through A - 1

	  Q = Range_Allocate ()
	  Range(Q).Start = Range(R).Start
	  Range(Q).End = A - 1

C The old range becomes the end of the range from A+1 through the old end

	  Range(R).Start = A + 1

C Chain P -> Q -> R

	  Range(Q).Next = R
	  If (P .ne. 0) Then
	    Range(P).Next = Q
	  Else
	    Group(G).Range_First = Q
	  EndIf

	  P = Q	

	EndIf

C Now, we may have left a nonsense group at R

	If (Range(R).Start .gt. Range(R).End) Then
	  If (P .ne. 0) Then
	    Range(P).Next = Range(R).Next
	    If (Group(G).Range_Last .eq. R) Then
	      Group(G).Range_Last = P
	    EndIf
	  Else
	    Group(G).Range_First = Range(R).Next
	    If (Group(G).Range_Last .eq. R) Then
	      Group(G).Range_Last = Group(G).Range_First
	    EndIf
	  EndIf

	  Range(R).Next = 0
	  Call Range_Deallocate (R)

	EndIf

C Finally, update unread count

	U = U + 1

C That's all folks

	Return

	End ! of Cmd_ArticleMark

	Subroutine Cmd_ArticleNone

	Call SMG_All_Print ('No article selected')

	End ! of Cmd_ArticleNone

	Subroutine Cmd_NoAsk(Argument)
C+++
C Added NoAsk concept, and integrated into VNEWS. jms/910327 (based
C on ideas by paf.  Vnews 1.4
C---

	Include 'News.DEF/NOLIST'

	Logical	Argument
	NoAsk = Argument

	If (NoAsk) Then
	    Call SMG_All_Print ('Catchups will not be confirmed.')
	Else
	    Call SMG_All_Print ('You will have to confirm catchups.')
	Endif
	
	End ! of Cmd_NoAsk

	Subroutine Cmd_NoPosting

C
C Print out a message that posting is not allowed to this server.
C 900622/jms.  Vnews 1.4
C

	Call SMG_All_Print ('Posting is not allowed to this server')

	End ! of Cmd_NoPosting

	Integer Function Cmd_ArticleNumber (G, Text, S)

	Include 'News.Def'

C Parameter definition

	Integer   *4	G
	Character *(*)	Text
	Integer   *4	S

C External Functions
	
	Logical		Get_Integer

C Local definitions

	Integer   *4	Lg
	Integer   *4	N
	Integer   *4	X
	Character *8    Num

C Begin Cmd_ArticleNUmber

	Lg = Len(Text)
	X = 1
	N = 0
	Cmd_ArticleNumber = Get_Integer (Text(1:Lg), X, N)

	If (Cmd_ArticleNumber) Then
	  If
	1	(
	1	(N .ge. Group(G).Active_Start)
	1	.and.
	1	(N .le. Group(G).Active_End)
	1	)
	1	Then
	    S = N
	  Else
	    Call ItoS (N, Num, Lg)
	    Print '(A)', '  Article ' // Num(1:Lg) // ' not available'
	    Cmd_ArticleNumber = .false.
	  EndIf
	EndIf

	Return

	End ! of Cmd_ArticleNumber

C************************************************************************
C John Howells 8/2/88
C
C This subroutine was added in order to mark an entire newsgroup as
C unread.
C 
C updated 910619/pr, multiple bug fixes. 
C
C************************************************************************

	Subroutine Cmd_ArticleRestore (G,U)

	Include 'News.Def'

C Parameter definition

	Integer   *4	G		! Group number
	Integer   *4	U		! Unread article count, updated

C Local definitions

	Integer   *4	R

C Release existing range(s), if any

	R = Group(G).Range_First
	Call Range_Deallocate(R)

C Make this group have no range(s) of read articles

	Group(G).Range_First = 0
	Group(G).Range_Last = 0

C Finally, update unread count and return

	U = Group(G).Active_End - Group(G).Active_Start + 1

	Return

	End ! of Cmd_ArticleRestore


	Integer Function Cmd_ArticleSameSubj (G, A)

	Include 'News.Def'

C Parameter definition

	Integer   *4		G	! Group number
	Integer   *4		A	! Article number

C External routines

	Integer			Range_Find

C Local definitions

	Integer   *4		I
	Integer   *4		I_Lg
	Character *8		I_C
	Integer	  *4		Subject_Lg
	Integer   *4		Status
	Character *128		Subject
	Integer   *4		XSubject_Lg
	Character *128		XSubject

C Begin Cmd_ArticleSameSubj

C Send XHdg Subject command to retrieve subject line for article

C Check for "command unrecognized" reply. vnews 1.4/910416/jms

	Cmd_ArticleSameSubj = .FALSE. 		! alpha/jms/921026

	Call CacheHdr (A, Subject, Subject_Lg)

	If (Subject(1:4) .eq. '500 ') Then
	    If (Subject(1:11) .eq. '500 Command' .or.
	1	Subject(1:11) .eq. '500 COMMAND' .or.
	2	Subject(1:11) .eq. '500 command') Then
		Call SMG_All_Print
	1	    ('XHDR command failure. Directory abort!')
		Return
	    Endif
	EndIf

C Remove article number from front of subject line

	Call ItoS (A, I_C, I_Lg)

	If (I_Lg .lt. Subject_Lg) Then
	
	  Subject(1:Subject_Lg-I_Lg) = Subject(1+I_Lg:Subject_Lg)
	  Subject_Lg = Subject_Lg - I_Lg

C Display subject being looked for

	  Call SMG_All_Print
	1	('Searching for: ' // Subject(1:Subject_Lg))

C Page through articles looking for this subject

	  Do I = Group(G).Active_Start, Group(G).Active_End

	    If (Range_Find(G, I, .false.) .eq. 0) Then

	      Call CacheHdr (I, XSubject, XSubject_Lg)

C Remove article number from front of subject line

	      Call ItoS (I, I_C, I_Lg)

	      If (XSubject_Lg .gt. I_Lg) Then

	        XSubject(1:XSubject_Lg-I_Lg) =
	1	     XSubject(1+I_Lg:XSubject_Lg)
	        XSubject_Lg = XSubject_Lg - I_Lg
	        Status = Index(XSubject(1:XSubject_Lg), 	! JMH
	1			Subject(1:Subject_Lg))          !   8/2/88
		If (Status .gt. 0) Then
		  Cmd_ArticleSameSubj = .true.
		  A = I
		  Return
		EndIf

	      EndIf ! (XSubject_Lg .gt. I_Lg)

	    EndIf ! (Range_Find(G, I, .false.) .eq. 0)

	  End Do

	EndIf ! (I_Lg .lt. Subject_Lg)

	Call SMG_All_Print ('No other articles found')
	Cmd_ArticleSameSubj = .false.
	Return

	End ! of Cmd_ArticleSameSubj

	Subroutine Cmd_ArticleSave (G, A, Cmd)

	Include 'News.Def'

C Description
C
C   Handles the S filename command.
C

C Parameter definitions

	Integer   *4	G		! Group number
	Integer   *4	A		! Article number
	Character *(*)	Cmd		! Save command line

C External routines

	Integer		Srv_Cmd
	Integer		TrimLg
	Integer		User_Open
	External	User_Open
	Integer		User_Open_Get_What_Happened

C Local definitions

	Character *64	FileName
	Character *128  Buf
	Logical		FirstDot
	Integer   *4	Lg
	Integer   *4	Status
	Integer	  *4	X
	Character *128  Msg
	Logical 	FileOpen
	Character*66	FChars

c
c	VNEWS 1.3-4	Kevin Oberman
c
c	FChars contains the list of valid characters in a file name.
c

	Data FChars /'ABCDEFGHIJKLMNOPQRSTUVWXYZ
     $abcdefghijklmnopqrstuvwxyz1234567890-_.$'/

C Begin Cmd_ArticleSave

C Get the file name from the command line

	X = 1
	Lg = Len(Cmd)
	Call GetField (FileName, Cmd, X, Lg)
	Call GetField (FileName, Cmd, X, Lg)

C If user specified no file name, build default from group name

	If (FileName .eq. ' ') Then
	  FileName = Group(G).Name
	  FirstDot = .true.
	  X = 1
	  Lg = TrimLg (FileName)
          Do While (X .le. Lg)
c
c	VNEWS 1.3-4	Kevin Oberman
c
c	Check all filenames for valid characters for VMS.  
c	e.g. C++ becomes C__
c
            If (Index(Fchars,Filename(X:X)) .eq. 0) Filename(X:X) = '_'
	    If (FileName(X:X) .eq. '.') Then
	      If (FirstDot) Then
		FirstDot = .false.
	      Else
		FileName(X:X) = '_'
	      EndIf
	    EndIf
	    X = X + 1
	  EndDo
	EndIf

C Open the file

	FileOpen = .false.

	Do While (.not. FileOpen)
	Call User_Open_Init ('STATUS_UNKNOWN')
	Open
	1	(
	1	Unit		   = LU_Save,
	1	File	 	   = FileName,
	1	DefaultFile     = UserDirectory,
	1	Status	   = 'Unknown',
	1	Form		   = 'Formatted',
	1	CarriageControl = 'List',
	1	Recl		   = 1024,
	1	Access	   = 'Append',
	1	UserOpen	   = User_Open,
	1	IOStat	   = Status
	1	)

	If (Status .ne. 0) Then
	    Call SMG_All_Print
	1	('Error opening file ' // FileName(1:TrimLg(FileName)) )
	    Return
	Else
	    FileOpen = .true.
	EndIf

	End Do

	If (.not. Srv_Cmd('head',Buf,Lg)) Then
	  Call SMG_All_Print ('Server failed')
	  Stop
	EndIf

	If (Buf(1:3) .ne. '221') Then
	  If (Buf(1:1) .eq. '4') Then
	    Call SMG_All_Print ('Server doesn''t like that article.')
	    Call SMG_All_Print ('It seems to have just disappeared.')
	  Else
	    Call SMG_All_Print ('Unexpected server reply. Better quit.')
	  Endif
	  Call Smg_All_Print (Buf(1:Lg))
	  Close (LU_Save)
	  Return
	EndIf

C+
C	Well now, I like to have some space between articles.  Form Feed
C	is good.
C-
	If (User_Open_Get_What_Happened() .EQ. 1) Then
	  WRITE (LU_Save, '(A)') Char (12)
	End If

	Call Srv_CopyTxt (LU_Save, ' ', .false.)

	If (.not. Srv_Cmd('body',Buf,Lg)) Then
	  Call SMG_All_Print ('Server failed')
	  Stop
	EndIf

	Write (LU_Save, '(A)') ' '

	If (Buf(1:3) .ne. '222') Then
	  If (Buf(1:1) .eq. '4') Then
	    Call SMG_All_Print ('Server doesn''t like that article now.')
	    Call SMG_All_Print ('It seems to have just disappeared.')
	  Else
	    Call SMG_All_Print ('Unexpected server reply. Better quit.')
	  Endif
	  Call Smg_All_Print (Buf(1:Lg))
	  Close (LU_Save)
	  Return
	EndIf

	Call Srv_CopyTxt (LU_Save, ' ', Rotated)

	Msg = 'Article '
	Call ItoS (A, Msg(9:Len(Msg)), Lg)
	Lg = 8 + Lg
	If (User_Open_Get_What_Happened() .eq. 1) Then
	  Msg (Lg+1:Len(Msg)) = ' appended'
	  Lg = Lg + 9
	Else
	  Msg (Lg+1:Len(Msg)) = ' saved'
	  Lg = Lg + 6
	EndIf
	Msg (Lg+1:Len(Msg)) = ' to file ' // FileName
	Lg = TrimLg(Msg)

	Call SMG_All_Print (Msg(1:Lg))

	Close (LU_Save)
	Return

	End ! of Cmd_ArticleSave


	Subroutine Cmd_GroupList (Cmd)

	Include 'News.Def'

C Parameter definition

	Character *(*)		Cmd

C External routines

	Logical			SMG_More_Print
	Integer			Str$Match_Wild
	Integer			TrimLg
	Integer			SYS$FAO
	
C Local definitions

	Character *1		Active, Subscribed, Post
	Logical			Any, Ok, Try_Wild
	Integer   *4		G, X, R
	Integer   *4		Lg, Trimmed_Length
	Character *80		Text
	Character *(NwsGrpSz+2) Pattern

C Begin Cmd_GroupList

	Pattern = ' '
	X = Index (Cmd,' ')
	If (X .ne. 0) Then
	  Do While ((X .lt. Len(Cmd)) .and. (Cmd(X:X) .eq. ' '))
	    X = X + 1
	  EndDo
	  Pattern = Cmd(X:Len(Cmd))
	  Call Down_Case (Pattern)
	EndIf

C+++
C Figure out whether pattern has wildcards in it. 
C vnews 1.4/pr/910416
C---
	Trimmed_Length = TrimLg(Pattern)
	Try_Wild = (   INDEX(Pattern(1:Trimmed_Length),'*')
	1	  .ne. INDEX(Pattern(1:Trimmed_Length),'%') )

	Ok = .true.
	G = 0
	Any = .false.
	Do While (Ok .and. (G .lt. Group_Count))

	  G = G + 1

	  If (
	1	(Pattern .eq. ' ')
	1    .or.
	1       ( Try_Wild .and. Str$Match_Wild(
	1		 		Group(G).Name(1:TrimLg(Group(G).Name)),
	1				Pattern(1:Trimmed_Length) )
	1	)
	1    .or.
	1	( .not. Try_Wild .and. 
	1	        (Group(G).Name(1:TrimLg(Group(G).Name)) .eq.
	1		Pattern(1:Trimmed_Length))
	1	)
	1    ) Then
	    Any =.true.

C
C	VNEWS 1.3-4	Kevin Oberman
C	Change the output letters for the d/g command so it makes more
C	sense to a novice user (or any user for that matter)
C

	    If (Group(G).Subscribed) Then
	      Subscribed = 'S'	
	    Else
	      Subscribed = '-'
	    EndIf

	    If (Group(G).Active_File) Then
	      Active = 'A'
	    Else
	      Active = '-'
	    EndIf

	    If (Group(G).Active_Post) Then
	      Post = 'P'
	    Else
	      Post = 'M'
	    EndIf

C
C	VNEWS 1.3-4 Kevin Oberman
C	Added group number to d/g command.
C	VNEWS 1.4 Jim Gerland put in TrimLg of Group(G).Name
C	VNEWS 1.4 pr/910416. One more fix.
C
C	Format group name to 32 columns, unless it's even wider
C
	Lg = MAX( TrimLg(Group(G).Name), 32)	![NwsGrpSz-'n']

	Call SYS$FAO('!6SL !AS!_!1AS !1AS !1AS !7SL!7SL', Lg, Text,
	1	      %VAL(G),
	1		   Group(G).Name(1:Lg),
	1			 Active,
	1			     Subscribed,
	1				  Post,
	1				       %VAL(Group(G).Active_Start),
	1					  %VAL(Group(G).Active_End) )
	    Ok = SMG_More_Print (Text(1:Lg))

	    R = Group(G).Range_First
	    Do While (Ok .and. (R .ne. 0))
	      Write (Text, '(x,I,A,I)')
	1			Range(R).Start, ':', Range(R).End
	      Ok = SMG_More_Print (Text)
	      R = Range(R).Next
	    End Do

	  EndIf

	EndDo

	If (.not. Any) Then
	  Call SMG_All_Print
	1	(
	1	'No groups matching ' // Pattern(1:TrimLg(Pattern)) //
	1	' found.'
	1	)
	EndIf

	Return

	End ! of Cmd_GroupList


	Subroutine Cmd_GroupNone

	Implicit None

	Call SMG_All_Print ('No group selected.')

	End ! of Cmd_GroupNone


	Subroutine Cmd_ReadKillfile (G, S, U)
C
C Open a KILL file (if one exists for this group) and delete any articles
C according to subject found in the file.
C
C JMH - 5/11/89
C
	Include 'News.Def'

C Parameter definitions

	Integer   *4    G
	Integer   *4    S
	Integer   *4    U

C External routines

	Integer         TrimLg
	Integer		UnRead

C Local Definitions

	Character *64   FileName
	Character *80   Image
	Integer   *4    Status
	Integer   *4    Lg
	Integer   *4    X
	Integer         ImageLg

C Create the filename from group name

	FileName = Group(G).Name
	X = 1
	Lg = TrimLg (FileName)
	Do While (X .le. Lg)
	  If (FileName(X:X) .eq. '.') FileName(X:X) = '_'
	  X = X + 1
	EndDo

	FileName = FileName(1:TrimLg(FileName))//'.KILL'

C Open the Kill file

	Open
	1	(
	1	Unit 	   = LU_KillFile,
	1	File		   = FileName,
	1	DefaultFile     = UserDirectory,
	1	Status	   = 'Old',
	1	Form		   = 'Formatted',
	1	CarriageControl = 'List',
	1	IOStat	   = Status
	1	)

	If (Status .ne. 0) Return       ! no kill file

	Kill_Done = .true.

	Call SMG_All_Print ('Searching for articles to kill...')

C Read through the Kill file and remove articles

	Status = 1
	Do While (Status)
	  Read
	1	(
	1	Unit	 = LU_KillFile,
	1	Fmt	 = '(Q,A)',
	1	IOStat	 = Status
	1	)
	1		ImageLg, Image
	  If (Status .ne. 0) Then
	    Close (LU_KillFile)
	    Status = 0
	  Else
	    Status = 1
	    Call STR_Strip_Re (Image, ImageLg)
	    Call Cmd_ArticleKill (G, S, U, Image)
	  EndIf
	End Do

	Close (LU_KillFile)

C Finally, update unread count

	U = UnRead (G)			! Update unread article count
	Call Lib$Wait(3.0)		! VNEWS 1.3-4

	Return

	End  ! of Cmd_ReadKillFile

	Integer Function Cmd_Spawn (Command)
C************************************************************************
C Cmd_Spawn - Spawn a subprocess for a single command or, if no command
C given, an interactive subprocess.
C
C JMH - 8/17/88
C complete rewrite - Vnews 1.4. pr/910325, pr/910619 (try to reuse)
C************************************************************************
  
	Include 'News.Def/NOLIST'

	Character *(*)          Command
	Integer                 Command_Lg
	Integer			Status
	Integer	   		LIB$Spawn,LIB$Attach
	Integer                 TrimLg
  
C Disable broadcast trapping so that we can spawn the subprocess
  
	Call SMG_Handle_Broadcasts( .False.)
  
C Check for existence of a command after the '!'
C Attempt to re-attach to a previous subprocess, if possible.  If not,
C then spawn a new one.
  
	If (Command(2:) .eq. '  ') Then		! no command found
	    Status = 0
	    If (SubProc_PID .NE. 0) Status = LIB$ATTACH(SubProc_PID)
	    If (.NOT. Status) Status = LIB$Spawn(,,,,,SubProc_PID)
	Else					! command is found	
	  Command_Lg = TrimLG(Command)		! find end of string
	  Status = LIB$Spawn(Command(2:Command_Lg))	! spawn single command
	End If
  
C Enable broadcast trapping again
  
	Call SMG_Handle_Broadcasts( .True.)
	
	Cmd_Spawn = Status			! get status info
                
	Return
	End  ! of Cmd_Spawn


	Subroutine Cmd_ArticlePrint (A)

	Include 'News.Def'

C Description
C
C   Handles the print filename command.
C

C Parameter definitions

	Integer   *4	A		! Article number

C External routines

	Integer		Srv_Cmd
	Integer		TrimLg
	Integer		User_Open
	External	User_Open
	Integer		User_Open_Get_What_Happened

C Local definitions

	Character *64	FileName
	Character *128  Buf
	Integer   *4	Lg
	Integer   *4	Status
	Character *128  Msg

C Begin Cmd_ArticlePrint

	FileName = 'SYS$SCRATCH:NEWS_PRINT.TXT'
	Lg = TrimLg(FileName)

C Open the file

	Call User_Open_Init ('STATUS_UNKNOWN')
	Open
	1	(
	1	Unit		= LU_Save,
	1	File	 	= FileName(1:Lg),
	1	Status	   	= 'Unknown',
	1	Form		= 'Formatted',
	1	CarriageControl = 'List',
	1	Recl		= 1024,
	1	Access	   	= 'Append',
	1	UserOpen	= User_Open,
	1	IOStat	   	= Status
	1	)

	If (Status .ne. 0) Then
	    Call SMG_All_Print
	1	('Error opening file ' // FileName(1:Lg))
	    Return
	EndIf

	If (.not. Srv_Cmd('head',Buf,Lg)) Then
	  Call SMG_All_Print ('Server failed')
	  Stop
	EndIf

	If (Buf(1:3) .ne. '221') Then
	  If (Buf(1:1) .eq. '4') Then
	    Call SMG_All_Print ('Server doesn''t like that article now.')
	    Call SMG_All_Print ('It seems to have suddenly disappeared.')
	  Else
	    Call SMG_All_Print ('Unexpected server reply. Better quit.')
	  Endif
	  Call Smg_All_Print (Buf(1:Lg))
	  Close (LU_Save)
	  Return
	EndIf

C+
C	Well now, I like to have some space between articles.  Form Feed
C	is good.
C-
	If (User_Open_Get_What_Happened() .EQ. 1) Then
	  WRITE (LU_Save, '(A)') Char (12)
	End If

	Call Srv_CopyTxt (LU_Save, ' ', .false.)

	If (.not. Srv_Cmd('body',Buf,Lg)) Then
	  Call SMG_All_Print ('Server failed')
	  Stop
	EndIf

	Write (LU_Save, '(A)') ' '

	If (Buf(1:3) .ne. '222') Then
	  If (Buf(1:1) .eq. '4') Then
	    Call SMG_All_Print ('Server doesn''t have that article body.')
	    Call SMG_All_Print ('It seems to have only the header.')
	  Else
	    Call SMG_All_Print ('Unexpected server reply. Better quit.')
	  Endif
	  Call Smg_All_Print (Buf(1:Lg))
	  Close (LU_Save)
	  Return
	EndIf

	Call Srv_CopyTxt (LU_Save, ' ', Rotated)

	Msg = 'Article '
	Call ItoS (A, Msg(9:Len(Msg)), Lg)
	Lg = 8 + Lg
	If (User_Open_Get_What_Happened() .eq. 1) Then
	  Msg (Lg+1:Len(Msg)) = ' appended'
	  Lg = Lg + 9
	Else
	  Msg (Lg+1:Len(Msg)) = ' saved'
	  Lg = Lg + 6
	EndIf
	Msg (Lg+1:Len(Msg)) = ' to file ' // FileName
	Lg = TrimLg(Msg)

	Call SMG_All_Print (Msg(1:Lg))

	Close (LU_Save)
	Return

	End ! of Cmd_ArticlePrint


	Subroutine Cmd_Attach (Process_Name)
C
C Subroutine to attach to another process.
C
C Written by:
C		John Howells, Sterling Software, 29-JAN-1990
C Updated:
C		Vnews 1.4.  pr/910325.  Use new Broadcast Trapping routines.

	Implicit None
	Include '($JPIdef)'

	Integer*4 		Pid, Owner_Pid
	Integer*4 		Lib$Getjpi, Lib$Attach
	Character*(*) 		Process_Name

	External		SMG_Broadcast_AST
C
C Disable broadcast trapping so that we can spawn the subprocess
C
	Call SMG_Handle_Broadcasts (.False.)
C
C if no parameter is passed to this subroutine, the parent process
C is assumed.
C
	If (Process_Name .eq. ' ') Then
	   Call Lib$Getjpi ( JPI$_Owner ,,, Owner_Pid )
	   Call Lib$Attach ( Owner_Pid )
	Else
C
C Otherwise a parameter has been passed and a particular process is to
C be attached to.
C
	   Call Str$Upcase ( Process_Name, Process_Name )
	   Call Lib$Getjpi ( JPI$_Pid ,, Process_Name, Pid )
	   Call Lib$Attach ( Pid )
	End If
C
C Enable broadcast trapping again
C
	Call SMG_Handle_Broadcasts (.True.)

	Return

	End 	! of Cmd_Attach

	Subroutine Cmd_MoveGroup (Current_G)
C **********************************************************************
C Subroutime to move a group to a new location in the list.
C R. Kevin Oberman 3/12/90
C VNEWS 1.3-4
C **********************************************************************

	Include 'News.Def'
	Include 'SMG.Def'
	External SMG$_EOF, RMS$_EOF

C External routines

	Integer		SMG_Prompt	! Prompt for input.
	Integer		STR$Find_First_Not_In_Set
	Integer		Group_Find
	Integer		TrimLG

C Local variables

	Integer		G		! Current location of the group
	Integer		Current_G
	Integer		Destination_G
	Integer		Lg
	Integer		I

	Character *80	Answer		! 
	Character *10	Numbers/'0123456789'/

	Record	/GroupDef/	Temp_Group

C Place Group

	More_Input = ' '		! Clear out the more buffer
100	If (More_Input .ne. ' ') Then	! Check for input from more
	  Answer = More_Input
	  Lg = TrimLg (More_Input)
	  More_Input = ' '
	Else
C Prompt for input
	  I = SMG_Prompt (Answer, 'Insert where? [^$+-#DH] ', Lg)
	  If (I .EQ. %LOC(SMG$_EOF) .or. I .EQ. %LOC(RMS$_EOF)) Return
	End If
C Process the command
	Call STR$UPCASE(Answer(1:1), Answer(1:1))	! Keep it simple
	If (Answer(1:1) .EQ. ' ') Then
	  GoTo 100
	Else If (Answer(1:1) .EQ. '^') Then		! Make it the top group
	  Destination_G = 1
	Else If (Answer(1:1) .EQ. '$') Then	! Make it the last group
	  Destination_G = Group_Count
	Else If (Answer(1:1) .EQ. 'D') Then	! List the groups
	  Call CMD_GroupList (Answer)
	  GoTo 100
	Else If (Answer(1:1) .EQ. '-' .OR. Answer(1:1) .EQ. '+') Then
	  I = Group_Find (Answer(3:))
	  If (I .eq. 0) Then
	    Call SMG_All_Print
	1	(
	1	' No such group as "' //
	1	Answer (3:2+TrimLg(Answer(3:))) // '"'
	1	)
	    GoTo 100
	  Else
c
c	VNEWS 1.3-4	John McMahon
c
c	Changed '-' to '+' to get M command to obey the help file.
c
	    If (Answer(1:1) .EQ. '+') Then
	      Destination_G = I
	    Else
	      Destination_G = I + 1
	    End If
	  End If
	Else If (Answer(1:1) .EQ. '.' .OR. Answer(1:1) .EQ.CHAR(26) ) Then
	  Destination_G = Current_G	! no change
	Else If (Answer(1:1) .EQ. 'H' .OR. Answer(1:1) .EQ. '?') Then
	  Call SMG_Erase
	  Call SMG_All_Print ('^         Place at top of the list')
	  Call SMG_All_Print ('$         Place at the end of the list')
	  Call SMG_All_Print ('- group   Place after "group"')
	  Call SMG_All_Print ('+ group   Place before "group"')
	  Call SMG_All_Print ('The new number for this group.')
	  Call SMG_All_Print ('D [group] List groups')
	  Call SMG_All_Print ('H or ?    This help list')
	  Call SMG_All_Print ('. or ^z   Don''t move after all')
	  GoTo 100
	Else If (STR$Find_First_Not_In_Set(Answer, Numbers) .EQ. 0) Then
	  Call SMG_All_Print ('Huh?')
	  GoTo 100
	Else
	  If (Lg .GT. 4) Then
	    Call SMG_All_Print ('Huh?')
	    GoTo 100
	  End If
	  Read (Answer, '(I<Lg>)') Destination_G
	End If
       
C Move the group to its new location

	If (Destination_G .GT. Group_Count) Destination_G = Group_Count ! Max
	If (Destination_G .LT. 1) Destination_G = 1	! Min
	If (Destination_G .EQ. Current_G) Return	! Already there. Null
	Temp_Group = Group(Current_G)		! Save the group
	G = Current_G				! Start at the current group
	Do While (G .LT. Destination_G)
	    Group(G) = Group(G+1)
	    G = G + 1
	End Do
	Do While (G .GT. Destination_G)
	    Group(G) = Group(G-1)
	    G = G - 1
	End Do
	Group(Destination_G) = Temp_Group
	Current_G = Destination_G
	Return
	End ! of Cmd_MoveGroup

	Subroutine Cmd_ArticleSend ( A, Cmd, CopySelf)

c added to vnews 1.4/jms/910705

	Include 'News.Def'
	Include 'Smg.Def'

C Parameter definitions

	Integer         A	! Article number
        Character       *(*)Cmd ! Command text
	Logical		CopySelf! True if we get a copy of it ourselves

C External routines

	Integer		Delete_File	
	Integer		SMG_Prompt
	Integer		Srv_Cmd
	Integer		TrimLg
	Integer		Send_Mail
	
C Local definitions

	Character *(File_Name_Size)	File_Out
	Integer				OutLg
	Character *128			To
	Integer   *4			ToLg
	Integer   *4			I
	Character *1024			Img
	Integer	  *4			Img_Lg
	Character *128			TmpTo
	Logical   *4			Rotx
	Integer   *4			Status
	Character *128			Subject
	Integer   *4			Subject_Lg
	
	To = ' '
	TmpTo = ' '

C Accept an argument after the command which is a new address
C to replace the one we plan on sending to.
C vnews 1.4/jms/910705.  If there is no argument on the command
C line, then prompt for a "To" from the user.
C vnews 1.51/jms/940105  If they hit "return" on the To line,
C then consider that an abort.

	I = Index(Cmd,' ')
	If (I .gt. 1) Then
	    TmpTo = Cmd(I+1:TrimLg(Cmd))
	Else
	    Status = SMG_Prompt (TmpTo, 'To: ', ToLg)
	    If (.not. Status .or. ToLg .le. 1) Then
		Call SMG_All_Print ('Send aborted.')
		Return
	    EndIf
	EndIf

C Translate this "To:" into a real email address.  There are
C three possibilities:
C	- if the user has put a mailer (i.e., smtp%") in front,
C	    then just pass it on.
C	- if the user has NO mailer and an @ sign, then stick
C	    a mailer in front.
C	- if there is no mailer and no @ sign, then don't put a
C	    mailer in front (i.e., probably local or decnet)
C

	If (Index(TmpTo,'%"') .gt. 0) Then 	! if mailer specified
	    ToLg = TrimLg(TmpTo)
	    To(:ToLg) = TmpTo(:ToLg)
	Else 					! else, mailer not specified
	    If (Index(TmpTo,'@') .gt. 0) Then	!  if we need a mailer
		ToLg = Index(TmpTo,'(')-2
		If (ToLg .le. 0) Then
		    ToLg = TrimLg (TmpTo)
		EndIf
		To = Mailer(1:TrimLg(Mailer)) //
	1			'"'// TmpTo(1:ToLg) // '"'
		ToLg = TrimLg(To)
	    Else				!  else, we don't need a 
		ToLg = TrimLg(TmpTo)		!        mailer
		To = TmpTo(:ToLg)
	    EndIf ! we need/don't need a mailer
	EndIf ! a mailer was specified


C open the output file

	File_Out = 'Sys$Scratch:News$Out.News'
	OutLg = TrimLg(File_Out)

	Open
	1	(
	1	Unit		= LU_EditIn,
	1	File		= File_Out(:OutLg),
	1	Status		= 'New',
	1	Form		= 'Formatted',
	1	CarriageControl	= 'List',
	1	Recl 		= 1024,
	1	IOStat		= Status
	1	)

	If (Status .ne. 0) Then
	    Call SMG_All_Print
	1	(
	1	'Error opening temporary file ' // File_Out(1:OutLg) //
	1	'.  Send aborted.'
	1	)
	    Return
	EndIf

C Was original text rotated?  If so, we'll need to un-rot it when
C sending it along.


	If ((Len(Cmd) .lt. 3) .or. (Cmd(2:3) .ne. '/x')) Then
	    Rotx = .false.
	Else
	    Rotx = .true.
	EndIf

C Copy the header and text to the file.

	Write (Img, '(A,I8)') 'head ', A	! get the header
	
	Status = Srv_Cmd (Img(1:13), Img, Img_Lg)
	If (.not. Status) Then
	    Call SMG_All_Print ('Server failed')
	    Stop
	EndIf
	If (Img(1:3) .ne. '221') Then
	  If (Img(1:1) .eq. '4') Then
	    Call SMG_All_Print ('Server doesn''t have that article header.')
	  Else
	    Call SMG_All_Print ('Unexpected server reply. Better quit.')
	  Endif
	  Call Smg_All_Print (Img(1:Img_Lg))
	  Close (LU_EditIn)
	  Return
	EndIf

	Call Srv_CopyTxt (LU_EditIn, ' ', .FALSE.)

	Write (LU_EditIn, '(A)') ' '		! blank line

	Write (Img, '(A,I8)') 'body ', A	! get the body
	Status = Srv_Cmd (Img(1:13), Img, Img_Lg)
	If (.not. Status) Then
	    Call SMG_All_Print ('Server failed')
	    Stop
	EndIf
	If (Img(1:3) .ne. '222') Then
	  If (Img(1:1) .eq. '4') Then
	    Call SMG_All_Print ('Server doesn''t have the article text.')
	  Else
	    Call SMG_All_Print ('Unexpected server reply. Better quit.')
	  Endif
	  Call Smg_All_Print (Img(1:Img_Lg))
	  Close (LU_EditIn)
	  Return
	EndIf

	Call Srv_CopyTxt (LU_EditIn, ' ', Rotx)

C Copy Signature file if any

	Open
	1	(
	1	Unit		= LU_Signature,
	1	File         	= '.SIGNATURE',
	1	DefaultFile	= 'SYS$LOGIN:',
	1	Form		= 'Formatted',
	1	CarriageControl	= 'None',
	1	Status		= 'Old',
	1	ReadOnly,
	1	IOStat		= Status
	1	)

	If (Status .eq. 0) Then

	    Write (LU_EditIn, '(A)') ' '	! blank line

	    Do While (Status .eq. 0)
		Read
	1	(
	1	Unit 		= LU_Signature,
	1	Fmt		= '(Q,A)',
	1	IOStat		= Status
	1	)				 Img_Lg, Img
		If (Status .eq. 0) Then
		    If (Img_Lg .Ge. 1) Then
			Write (LU_EditIn, '(A)') Img(1:Img_Lg)
		    Else
			Write (LU_EditIn, '(A)') ' '
		    Endif ! Img_Lg .eq. 0
		EndIf ! Status .eq. 0
	    EndDo ! While Status
	    Close (LU_Signature)
	EndIf

	If (Yow_Signature) Call Yow(LU_EditIn)

	Close (LU_EditIn)

C
C give the user the opportunity to create a subject line.
C

	Status = SMG_Prompt   (Subject, 'Subject :', Subject_Lg  )
	If (.not. Status) Then
	    Call SMG_All_Print ('Post aborted.')
	    Return
	EndIf

C 
C send the file as email
C

	Status = Send_Mail (	To(:ToLg), 
	1			File_Out(1:OutLg), 
	2			Subject(1:Subject_Lg),
	3			CopySelf )

	Call SMG_ALL_PRINT(' ')		! Doesn't erase log msg from ST%

	If (Status) Then 
	    Call SMG_All_Print('A copy of the message was sent to '//
	1			To(:ToLg)//'.')
	Else
	    Call Lib$Signal (%Val(Status))
	Endif

	Call Delete_File (File_Out(:OutLg))

	Return

	End ! of Cmd_ArticleSend
