	Subroutine Cmd_ArticlePost (G, Cmd)

	Include 'News.Def'
	Include 'Smg.Def'
	Include '($CliDef)'

C Parameter definitions

	Integer   	G	! Group number
	Integer         A	! Article number
        Character       *(*)Cmd ! Command text

C External routines

	Integer		Edit_File
	Integer		LIB$Rename_File     
	Integer		Delete_File	! vnews 1.4/jms/910325
	Integer		Group_Find
	Integer		SMG_Prompt
	Integer		Srv_Cmd
	Integer		Srv_Recv
	Integer		Srv_Send
	Integer		TrimLg
	Integer		STR$CASE_BLIND_COMPARE
	Integer		Send_Mail
	Logical		Validate_Headers	! vnews 1.4/jms/910704
	Logical		SMG_More_Print
	
C Local definitions

	Logical				CopySelf
	Logical				CopySelfArg
	Character *27			Date_Time
	Character *128			Distribution_Fld
	Logical				Eof
	Character *(File_Name_Size)	File_In
	Character *(File_Name_Size)	File_Out
	Logical				File_Out_Exists	!Vnews 1.4
	Character *(NwsGrpSz) 		Fld
	Integer				InLg, OutLg
	Character *128			Lunar_Date
	Logical				FollowUp
	Logical				MailReply
	Logical				MailCopyToSender
	Character *128			From
	Integer   *4			FromLg
	Character *128			To
	Integer   *4			ToLg
	Character *256			Group_Name
	Integer   *4			Group_Name_Lg
	Integer   *4			I
	Character *1024			Img
	Integer	  *4			Img_Lg
	Logical   *4			InHeader
	Character *128			MessageID
	Character *128			TmpTo
	Logical				ReAddress
	Logical				Posted_Ok
	Logical   *4			Rotx
	Logical				ReplyToSeen
	Integer   *4			Status
	Character *128			Subject
	Integer   *4			Subject_Lg
	Character *128			NewSubject
	Integer   *4			NewSubject_Lg
	Integer   *4			X
	Integer   *4			Lg
	Character *128			Summary
	Character *128			Keywords
	Character *128			References
	Character *128			Followup_line
	Character*24			WhatAreWeDoing ! VNEWS 1.4 jjm
	Character *4			WhatNow
	Character*5			Choice
C Cancel definitions (vnews 1.4/LHWong,jms/910331)
	Logical				CancelArticle
	Logical				CancelFail
	Character *128			OldFrom
	
C Begin Cmd_ArticlePost

	WhatAreWeDoing = 'Post Article'		! vnews 1.4/jfem/910430
	FollowUp = .false.
	MailReply = .false.
	CancelArticle = .false.
	CancelFail = .false.
	MailCopyToSender = .false.
	CopySelf = .false.

	Group_Name = ' '
	Group_Name_Lg = 0
	Subject = ' '
	Distribution_Fld = ' '
	Keywords = ' '
	References = ' '
	Followup_line = ' '

	Goto 1

C Begin Cmd_ArticleCancel
	
	Entry Cmd_ArticleCancel (G, A, Cmd)

	WhatAreWeDoing = 'Cancel'		! vnews 1.4/jfem/910430
	Followup = .false.
	MailReply = .false.
	CancelArticle = .true.
	CancelFail = .false.
	MailCopyToSender = .false.
	CopySelf = .false.

	Goto 88

C Begin Cmd_ArticleMail

	Entry Cmd_ArticleMail (G, A, Cmd, CopySelfArg)

c
c	Modified by John McMahon so that MailReply and Followup are 
c	initialized with each call.  The variables are init'd and control
c       jumps directly to the common part of CMD_ARTICLEFOLLOWUP
c	(Label 88)
c	28-FEB-1990 23:27:55.67 
c

	WhatAreWeDoing = 'E-mail'		! vnews 1.4/jfem/910430
	MailReply = .true.
	Followup = .true.
	CancelArticle = .false.
	MailCopyToSender = .false.
	CopySelf = CopySelfArg

	Goto 88

C Begin Cmd_ArticleFollowUp

	Entry Cmd_ArticleFollowUp (G, A, Cmd)

	WhatAreWeDoing = 'Followup Article'		! vnews 1.4/jfem/910430
	Mailreply = .false.	! JJM - See comments for CMD_ARTICLEMAIL
	FollowUp = .true.
	CancelArticle = .false.
	CopySelf = .false.
	MailCopyToSender = .false.

	Goto 88

C this is just like followups, but a copy gets sent to the sender
C of the original message

C Begin Cmd_ArticleFollowMail

	Entry Cmd_ArticleFollowMail (G, A, Cmd, CopySelfArg)

	WhatAreWeDoing = 'Followup Article'		! vnews 1.4/jms/910705
	Mailreply = .false.	! See comments for CMD_ARTICLEMAIL
	FollowUp = .true.
	CancelArticle = .false.
	MailCopyToSender = .true.
	CopySelf = CopySelfArg

	Goto 88

88	Write (Img, '(A,I8)') 'head ', A ! JJM - See comments CMD_ARTICLEMAIL
	Status = Srv_Cmd (Img(1:13), Img, Img_Lg)
	If (.not. Status) Then
	  Call SMG_All_Print ('Server failed')
	  Stop
	EndIf
	If (Img(1:3) .ne. '221') Then
	  If (Img(1:1) .eq. '4') Then
	    Call SMG_All_Print ('Server doesn''t like that article number')
	    Call SMG_All_Print ('Are you sure that it exists?')
	  Else
	    Call SMG_All_Print ('Unexpected server reply. Better quit.')
	  Endif
	  Call Smg_All_Print (Img(1:Img_Lg))
	  Return
	EndIf

	From = ' '
	OldFrom = ' '
	Group_Name = ' '
	Group_Name_Lg = 0
	MessageID = ' '
	Subject = ' '
	Distribution_Fld = ' '
	Summary = ' '
	Keywords = ' '
	References = ' '
	Followup_line = ' '
	To = ' '
	TmpTo = ' '

	ReplyToSeen = .FALSE.

	Do While (Img(1:Img_Lg) .ne. '.')
	  Status = Srv_Recv (Img, Img_Lg)
	  If (.not. Status) Then
	    Call SMG_All_Print ('Server failed')
	    Stop
	  EndIf
	  If (Img(1:13) .eq. 'Distribution:') Then
	    If (Img_Lg .ge. 15) Then
	      Distribution_Fld = Img(15:Img_Lg)
	    EndIf
	  Else If (Img(1:8) .eq. 'Subject:') Then
            If (Img_Lg .ge. 10) Then
	      Subject = Img(10:Img_Lg)
	      If (    STR$CASE_BLIND_COMPARE( Subject(:3), 'Re:') .ne. 0
	1	.and. STR$CASE_BLIND_COMPARE( Subject(:3), 'Re^') .ne. 0
	2	) Then
	        Subject = 'Re: ' // Subject
	      EndIf
	      Subject_Lg = TrimLg(Subject)
	    EndIf
	  ElseIf (Img(1:11) .eq. 'Newsgroups:') Then
	    If (Img_Lg .ge. 13) Then
	      Group_Name = Img(13:Img_Lg)
	      Group_Name_Lg = Img_Lg - 12
	    EndIf
	  ElseIf (Img(1:5) .eq. 'Path:') Then
	  ElseIf (Img(1:5) .eq. 'From:' .AND. .NOT. ReplyToSeen) Then
	    If (Img_Lg .ge. 7) Then
	      OldFrom = Img(7:Img_Lg)			! vnews 1.4. cancel.
	      From = Img(7:Img_Lg)
	      To = Img(7:Img_Lg)
	    EndIf
	  ElseIf (Img(1:9) .eq. 'Reply-To:') Then
	    If (Img_Lg .ge. 11) Then
	      If (.not. CancelArticle) OldFrom = Img(11:Img_Lg)
	      From = Img(11:Img_Lg)
	      To = Img(11:Img_Lg)
	      ReplyToSeen = .TRUE.
	    EndIf
	  ElseIf (Img(1:11) .eq. 'Message-ID:') Then
	    If (Img_Lg .ge. 13) Then
	      MessageID = Img(13:Img_Lg)
	    EndIf
	  ElseIf (Img(1:8) .eq. 'Summary:') Then
	    If (Img_Lg .ge. 10) Then
	      Summary = Img(10:Img_Lg)
	    EndIf
	  ElseIf (Img(1:11) .eq. 'References:') Then
	    If (Img_Lg .ge. 13) Then
	      References = Img(13:Img_Lg)
	    EndIf
	  ElseIf (Img(1:9) .eq. 'Keywords:') Then
	    If (Img_Lg .ge. 11) Then
	      Keywords = Img(11:Img_lg)
	    EndIf
	  ElseIf (Img(1:12) .eq. 'Followup-To:') Then
	    If (Img_Lg .ge. 14) Then
	      Group_Name = Img(14:Img_Lg)
	      Group_Name_Lg = Img_Lg - 13
	      Followup_line = Img(14:Img_Lg)
	    EndIf
	  EndIf
	EndDo

C Accept an argument after a R or F command which is a new address
C to replace the one we plan on sending to.
C vnews 1.4/jms/910705

	ReAddress = .FALSE.
	I = Index(Cmd,' ')
	If ((MailReply .or. MailCopyToSender) .AND. I .gt. 1) Then
	  ReAddress = .TRUE.
	  TmpTo = Cmd(I+1:TrimLg(Cmd))
	Else
	  TmpTo = From(:TrimLg(From))
	EndIf

	If (Index(TmpTo,'%"') .gt. 0) Then 	! if mailer specified
	    ToLg = TrimLg(TmpTo)
	    To(:ToLg) = TmpTo(:ToLg)
	Else 					! else, mailer not specified
	  If (Index(TmpTo,'@') .gt. 0) Then	!  if we need a mailer
	    ToLg = Index(TmpTo,'(')-2
	    If (ToLg .le. 0) Then
	      ToLg = TrimLg (TmpTo)
	    EndIf
	    To = Mailer(1:TrimLg(Mailer)) //'"'// TmpTo(1:ToLg) // '"'
	    ToLg = TrimLg(To)
	  Else					!  else, we don't need a 
	    ToLg = TrimLg(TmpTo)		!        mailer
	    To = TmpTo(:ToLg)
	  EndIf ! we need/don't need a mailer
	EndIf ! a mailer was specified

	Goto 1

C Begin common Cmd_ArticlePost - Cmd_ArticleFollowUp - Cmd_ArticleMail
C              Cmd_ArticleCancel

1	If ((Len(Cmd) .lt. 3) .or. (Cmd(2:3) .ne. '/x')) Then
	  Rotx = .false.
	Else
	  Rotx = .true.
	EndIf

	Answers_Written = Answers_Written + 1

C If we are cancelling an article, then simply name the file as if it
C had already been edited. vnews 1.4/jms/910331

	If (.NOT. CancelArticle) Then
	  File_In = 'Sys$Scratch:News$In.News'
	  InLg = TrimLg(File_In)
	Else
	  File_In = 'Sys$Scratch:News$Out.News'
	  InLg = TrimLg(File_In)
	Endif

	File_Out = 'Sys$Scratch:News$Out.News'
	OutLg = TrimLg(File_Out)
	Call Smg_Erase

C If the followup-To: line is "poster," then we change a followup
C to a reply.

	If ((.NOT. MailReply) .AND. Followup .AND.
	1	Followup_Line(1:6) .eq. 'poster') Then
	    Call SMG_All_Print (
	1	'Followups have been redirected to the poster.')
	    WhatAreWeDoing = 'E-mail'		
	    MailReply = .true.
	    Followup = .true.
	EndIf ! reset followups

C Get group to post to

	If (Group_Name_Lg .eq. 0) Then

	I = 0
	Do While (I .eq. 0)

	  Status = SMG_Prompt
     	1	(
	1	Group_Name,
	1	'Group (' // Group(G).Name(1:TrimLg(Group(G).Name))
	1	// ') ',
	1	Group_Name_Lg
	1	)
	  If (.not. Status) Then
	    Call SMG_All_Print ('Post aborted.')
	    Return
	  EndIf

C Make sure group is legal

	  If (Group_Name(1:Group_Name_Lg) .eq. ' ') Then
	    Group_Name = Group(G).Name
	    Group_Name_Lg = TrimLg(Group(G).Name)
	    I = G
	  Else
	    I = Group_Find (Group_Name(1:Group_Name_Lg))
	    If (I .eq. 0) Then
	      Call SMG_All_Print
	1	('No such group as ' // Group_Name(1:Group_Name_Lg))
	    EndIf
	  EndIf

	EndDo

	EndIf

C Get subject

	If (Subject .eq. ' ' .AND. (.NOT. CancelArticle)) Then
	  Status = SMG_Prompt (Subject, 'Subject: ', Subject_Lg)
	  If (.not. Status) Then
	    Call SMG_All_Print ('Post aborted.')
	    Return
	  EndIf
	EndIf

C Get distribution.  If there is none, and we are cancelling, then
C  send the cancel message as far and wide as we can.
C  Other changes to make distribution simpler. jms/910331. VNEWS 1.4

	If ( (CancelArticle) .AND. (Distribution_Fld .eq. ' ') ) Then
	    Distribution_Fld = 'world'
	Endif

	If (    (Distribution_Fld .eq. ' ') .AND. 
	1	(.NOT. MailReply) .AND.
	2	(.NOT. CancelArticle) ) Then
118	  Distribution_Fld = ' '
          Status = SMG_Prompt (Img, 'Distribution (' // 
	1   DefaultDistribution(:TrimLg(DefaultDistribution)) //
	2   '): ', Img_Lg)
	  If ((Img_Lg .LE. 1) .AND. (Img(1:1) .EQ. ' ')) Then
	      Img = DefaultDistribution
	      Img_Lg = TrimLG(DefaultDistribution)
	  EndIf
	  X = 1
	  Do While (X .le. Img_Lg)
	    Call Field (Img(1:Img_Lg), X, Fld)
	    If (Fld .ne. ' ') Then
	      I = 1
	      Do While
	1	(
	1	(I .le. Distribution_Count)
	1	.and.
	1	(Distribution(I) .ne. Fld)
	1	)
	        I = I + 1
	      EndDo
	      If (I .le. Distribution_Count) Then
	        If (Distribution_Fld .ne. ' ') Then
	          Distribution_Fld =
	1	  Distribution_Fld(1:TrimLg(Distribution_Fld)) 
	2			// ', '
		EndIf

		If (Distribution_Fld .eq. ' ') Then
		    Distribution_Fld = Fld
		Else
		    Distribution_Fld =
	1	        Distribution_Fld(1:TrimLg(Distribution_Fld)) 
	2		 // Fld
		EndIf
	      Else
		Call SMG_All_Print
	1	('Illegal Distribution field ' // Fld(1:TrimLg(Fld)))
		Call SMG_All_Print ('Valid fields are: ' )
		Call SMG_All_Print ( ' ' )
		Do I = 1, Distribution_Count
		   Call SMG_All_Print (Distribution(I))
		End Do
		Goto 118	! vnews 1.4
	      EndIf
	    EndIf
	  EndDo

	EndIf


C Open the edit input file

	Open
	1	(
	1	Unit			= LU_EditIn,
	1	File			= File_In(:InLg),
	1	Status		= 'New',
	1	Form			= 'Formatted',
	1	CarriageControl	= 'List',
	1	Recl 		= 1024,
	1	IOStat		= Status
	1	)

	If (Status .ne. 0) Then
	  Call SMG_All_Print
	1	(
	1	'Error opening file ' // File_In(1:InLg) //
	1	'.  Post aborted.'
	1	)
	  Return
	EndIf

C Write the article header

	If (.NOT. MailReply) Then

c
c	RFC1036 is a bit fuzzy on whether or not followups should contain the
c	original path.  Since the server will calculate the path, I chose to
c	remove the path line from followups.
c
c	John McMahon   2-MAR-1990
c
c	After discussions with various folks, it appears the proper Path:
c	is nodename!username for posting and followups.  VNEWS 1.3-3
c	all this was moved to validate_headers. jms/910705/vnews 1.4
c

C add Cancel code. vnews 1.4/LHWong@csa2.lbl.gov

	  If (CancelArticle) Then
	    Write (LU_EditIn, '(A)') 'Control: cancel ' //
	1		MessageId(1:TrimLg(MessageID))
	  EndIf

C Vnews 1.41/jms/910828
C Only check the username + siteid (i.e., ignore personal name)

	  If (CancelArticle) Then
	    From = UserName(1:TrimLg(Username)) // SiteId(1:TrimLg(SiteId))
	    FromLg = TrimLg(Username) + TrimLg(SiteId)
	    If (Str$Case_Blind_Compare( OldFrom(1:FromLg), 
	1				From(1:FromLg)) .ne. 0) Then
		Call SMG_ALL_Print(
	1 'This is not your article. You are only allowed to')
		Call SMG_ALL_Print('cancel articles which you submitted.')
		Call Lib$Wait(3.0)
		CancelFail = .true.
	    Endif
	  Endif

	  If (UserPersonalName .ne. ' ') Then
	    From = 
	2	UserName(1:TrimLg(UserName)) //
	3	SiteId(1:TrimLg(SiteId)) //
	4	' (' //
	5	UserPersonalName(1:TrimLg(UserPersonalName)) //
	6	')'
	  Else
	    From = 
	2       UserName(1:TrimLg(UserName)) //
	3	SiteId(1:TrimLg(SiteId))
	  EndIf
	  Write (LU_EditIn, '(A)') 'From: ' // From(:TrimLg(From))

	  Write (LU_EditIn, '(A)') 'Newsgroups: ' //
	1			Group_Name(1:Group_Name_Lg)

	  If (.Not. CancelArticle) Then
	    Write (LU_EditIn, '(A)') 'Subject: ' // 
	1			Subject(1:Subject_Lg)
	  Else
	    Write (LU_EditIn, '(A)') 'Subject: cmsg cancel ' //
	1			MessageID(1:TrimLg(MessageID))
	  Endif

	  If (Followup) Write (LU_EditIn, '(A)') 'Summary: ' //
	1			Summary(1:TrimLg(Summary))

	  Call RFC_Date(Date_Time,Timezone)
	  Write (LU_EditIn, '(A)') 'Date: ' // Date_Time

	  If ( Obscure_Gratuitous_Lunar_Date ) Then
	    Call Phoon(Lunar_Date)
	    Write (LU_EditIn, '(A)') 'X-Lunar-Date: ' //
	1       Lunar_Date(1:TrimLg(Lunar_Date))
	  EndIf
c jms/921026/rao's phoon + alpha

c	Took out "Expires:" per instructions in RFC1036.
C	jms/910705
C	  Write (LU_EditIn, '(A)') 'Expires: '

c	Only put in sender if they fool with From:
c	  Write (LU_EditIn, '(A)') 'Sender: '

	  If (ReplyTo(1:1) .NE. ' ') Then
	    Write (LU_EditIn, '(A)') 'Reply-To: ' //
	1	ReplyTo(1:TrimLg(ReplyTo))
	  EndIf 

	  If (Followup_line(1:1) .ne. ' ') Then
	    Write (LU_EditIn, '(A)') 'Followup-To: ' //
	1	Followup_line(1:TrimLg(Followup_line))
	  EndIf

	  If (Distribution_Fld(1:1) .ne. ' ') Then
	    Write (LU_EditIn, '(A)') 'Distribution: ' //
	1	Distribution_Fld(1:TrimLg(Distribution_Fld))
	  EndIf

	  Write (LU_EditIn, '(A)') 'Keywords: ' // 
	1	Keywords(1:TrimLg(Keywords))

	  Write (LU_EditIn, '(A)') ' '

c	  Write (LU_EditIn, '(A)') '-Message-Text-Follows-'
	End If ! .not. mailreply

C Create the introduction line.

	If ((FollowUp .And. .Not. MailReply) .OR. ReAddress) Then
	  Write (LU_EditIn, '(A)')
	1	'In article ' // MessageID(1:TrimLg(MessageID)) // ', ' //
	1	OldFrom(1:TrimLg(OldFrom)) // ' writes...'
	Else If (MailReply) Then
	  Write (LU_EditIn, '(A)')
	1	'In article ' // MessageID(1:TrimLg(MessageID)) // ', ' //
	1	'you write...'
	EndIf

C If followup or mailreply, copy the article to the file

	If (Followup .or. MailReply) Then

	  Write (Img, '(A,I8)') 'body ', A
	  Status = Srv_Cmd (Img(1:13), Img, Img_Lg)
	  If (.not. Status) Then
	    Call SMG_All_Print ('Server failed')
	    Stop
	  EndIf
	  If (Img(1:3) .ne. '222') Then
	    If (Img(1:1) .eq. '4') Then
		Call SMG_All_Print ('Server doesn''t like that article.')
		Call SMG_All_Print ('It seems to have just disappeared.')
	    Else
		Call SMG_All_Print ('Unexpected server reply. Better quit.')
	    Endif
	    Call Smg_All_Print (Img(1:Img_Lg))
	    Close (LU_EditIn)
	    Return
	  EndIf

	  Call Srv_CopyTxt (LU_EditIn, Mark_Character, Rotated)

	EndIf

C Copy Signature file if any

	Open
	1	(
	1	Unit		= LU_Signature,
	1	File         	= '.SIGNATURE',
	1	DefaultFile	= 'SYS$LOGIN:',
	1	Form		= 'Formatted',
	1	CarriageControl	= 'None',
	1	Status		= 'Old',
	1	ReadOnly,
	1	IOStat		= Status
	1	)

	If (Status .eq. 0) Then
	  Do While (Status .eq. 0)
	    Read
	1	(
	1	Unit 		= LU_Signature,
	1	Fmt		= '(Q,A)',
	1	IOStat		= Status
	1	) Img_Lg, Img
	    If (Status .eq. 0) Then
C
C	VNEWS 1.3-3 McMahon 16-APR-1990 19:45
C
C	A null line in a .SIGNATURE file would cause the Img(1:x) to bomb
C	with an out of bounds error.
C
             If (Img_Lg .Ge. 1) Then
	      Write (LU_EditIn, '(A)') Img(1:Img_Lg)
             Else
              Write (LU_EditIn, '(A)') ' '
             Endif ! Img_Lg .eq. 0
	    EndIf ! Status .eq. 0
	  EndDo ! While Status
	  Close (LU_Signature)
	EndIf

	If (Yow_Signature) Call Yow(LU_EditIn)

C Done building edit input file

	Close (LU_EditIn)

C If this is a mail reply, give them the opportunity to change
C the subject line.  If they hit "return," then don't change it.
C vnews 1.4/jms/910705

	If (MailReply) Then
	  Status = SMG_Prompt
	1	(
	1	NewSubject, 
     	1	'Subject (' // Subject(:Subject_Lg) // ') :',
	1	NewSubject_Lg
	1	)
	  If (.not. Status) Then
	    Call SMG_All_Print ('Post aborted.')
	    Return
	  EndIf

	  If (NewSubject(1:NewSubject_Lg) .ne. ' ') Then
	    Subject = NewSubject(:NewSubject_Lg)
	    Subject_Lg = NewSubject_Lg
	  EndIf

	EndIf

C Edit the file
c	VNEWS 1.4 : change to a call to EDIT_FILE.
C	VNEWS 1.4 : add cancel article code. jms/910331
C+++
C Vnews 1.4/910326. Change to check to see if files exist before
C deleting them.  Jim Rapp, ICC User Services, jrapp@ucsd.edu
C Also: add label 105 which is used if the user wants to edit again.
C---

	If (CancelArticle) GOTO 117		! skip all this stuff.

105	Status = Edit_File( File_In(:InLg), File_Out(:OutLg))

	Call SMG_Erase
	If (.not. Status) Then
	    Call Smg_All_Print('Error editing file, post aborted.')
	    Call Delete_File (File_In(:InLg))
	    Call Delete_File (File_Out(:OutLg))
	    Return
	EndIf

C+++
C Find out what the user wants to do now
C  Change to use paging code. pr/910416/vnews 1.4
C  Change to use whatarewedoing. jfem/910430/vnews 1.4
C---
	If (MailReply) Then
	    Call SMG_All_Print('E-mail addressed to '//To( 1:ToLg ))
	EndIf

	Inquire (File=File_Out(:OutLg),Exist=File_Out_Exists)
	If (.NOT. File_Out_Exists) Then
	    Call SMG_All_Print('No output file was created.')
	    Choice = 'Abort'
	Else
	    Choice = 'Send '
	EndIf

100	Status = SMG_Prompt
	1	(
	1	WhatNow,
	1	WhatAreWeDoing(1:Trimlg(WhatAreWeDoing)) // 
	1	' Send, Abort, List, Edit? [ '//Choice//']: ',
	1	Lg
	1	)
	
	Call STR$Upcase (WhatNow, WhatNow)
	If (WhatNow(1:1) .eq. ' ' .and. File_Out_Exists) Then
	ElseIf (WhatNow(1:1) .eq. 'S') Then
	ElseIf (WhatNow(1:1) .eq. 'A' .or. Choice(1:1) .eq. 'A') Then
	   Call Delete_File (File_In(:InLg))
	   Call Delete_File (File_Out(:OutLg))
	   Return
	ElseIf (WhatNow(1:1) .eq. 'L' .and. File_Out_Exists) Then
	   Open
	1	(
	1	Unit			= LU_EditIn,
	1	File			= File_Out(:OutLg),
	1	Status			= 'Old',
	1	Form			= 'Formatted',
	1	CarriageControl		= 'List',
	1	Recl 			= 1024,
	1	IOStat			= Status
	1	)

	   Do While (Status .eq. 0)
	     Read
	1	(
	1	Unit	 	= LU_EditIn,
	1	Fmt	 	= '(Q,A)',
	1	IOStat	 	= Status
	1	)
	1		Img_Lg, Img
	     If (Status .eq. 0) Then
	       If (Img_Lg .eq. 0 ) Then
		 Img_Lg = 1
		 Img(1:1) = ' '
	       EndIf
	       If (.not. SMG_More_Print (Img(1:Img_Lg))) Status = -1
	     EndIf
	   End Do
	   Close (LU_EditIn)
	   More_Input = ' '
	   Go To 100
	ElseIf (WhatNow(1:1) .eq. 'L') Then
	   Call SMG_All_Print('Look, I said NO OUTPUT FILE CREATED.')
	   Call SMG_All_Print('There isn''t anything to list.')
	   Call SMG_All_Print('Get off my back.')
	   Goto 100
	ElseIf (WhatNow(1:1) .eq. 'E') Then
	   If (File_Out_Exists) Then
		Call LIB$Rename_File (File_Out(:OutLg),File_In(:InLg))
	   EndIf
	   Go to 105			! call to Edit_File
	Else
	   Go To 100
	EndIf

C Open the output file
C Label 117: added for VNEWS 1.4.  This is a "come-from" which skips
C all of the editing and checking code above for CancelArticle
C only. jms/910331
        
117	If (CancelFail) Then
	  Return
	Endif

	If (.not. MailReply) Then
C
C This is the place to validate headers
C
	  If (.NOT. Validate_Headers (File_Out(:OutLg), 
	1				From,
	2				Followup,
	3				References,
	4				MessageID) ) Then
	    Call SMG_All_Print ('Posting aborted.')
	    Call SMG_All_Print ('Your message is saved in '//
	1			File_Out(:OutLg) // '.' )
	    Call Delete_File (File_In(:InLg))
C	    Call Delete_File (File_Out(:OutLg))
	  EndIf ! unable to validate headers
		
	  Open
	1	(
	2	Unit		= LU_EditOut,
	3	File		= File_Out(:OutLg),
	4	Status		= 'Old',
	5	IOStat		= Status
	6	)
          
	  If (Status .ne. 0) Then
	    Call SMG_All_Print
	1	(
	2	'Error opening file ' // File_Out(1:OutLg) //
	3	'.  Post aborted.'
	4	)
	    Call Delete_File (File_In(:InLg))
	    Return
	  EndIf
	EndIf

C If mailreply, mail the file. Note: V5.0 has callable mail interface.
C We will use that.

	If (MailReply) Then

	  Status = Send_Mail (	To(:ToLg), 
	1			File_Out(1:OutLg), 
	2			Subject(1:Subject_Lg),
	3			CopySelf )

	  Call SMG_ALL_PRINT(' ')	! VNEWS 1.3-5/jfem/910430
					! Doesn't erase log msg from ST%
	  If (Status) Then 
	    Call SMG_All_Print ('Reply was successfully sent.')
	  Else
	    Call Lib$Signal (%Val(Status))
	  Endif

	  MailReply = .false.

	  Call Delete_File (File_In(:InLg))
	  Call Delete_File (File_Out(:OutLg))

	  Return

	End If
	   
C Start a post command on the server

	Status = Srv_Cmd ('post', Img, Img_Lg)
	If (.not. Status) Then
	  Call SMG_All_Print ('Server failed')
	  Stop
	EndIf

C 
C Added status code 345, because there's a buggy server out there
C who responds to POST with the IHAVE code.  Tsk, tsk, tsk. RFC977
C is clear on this subject.  jms/910327 Vnews 1.4
C
	If (Img(1:3) .eq. '340' .or. Img(1:3) .eq. '345' ) Then

C Copy the file to the server postnews process

	  If (CancelArticle) Then
	    Call SMG_All_Print('Sending cancel command to server')
	  Else
	    Call SMG_All_Print ('Sending article to server')
	  Endif
	  Call SMG_All_Print (Img(1:Img_Lg))

	  InHeader = .true.
	  Eof = .false.
	  Do While (.not. Eof)

	    Read
	1	(
	2	Unit	= LU_EditOut,
	3	Fmt	= '(Q,A)',
	4	IOStat	= Status
	5	) Img_Lg, Img

	    If ((Img_Lg .eq. 0) .or. (Img(1:Img_Lg) .eq. ' ')) Then
	      InHeader = .false.
	    EndIf

	    If ((.not. InHeader) .and. RotX) Then
	      Call Rotate (Img(1:Img_Lg))
	    EndIf

            If (Status .eq. 0) Then
C
C	VNEWS 1.3-3 McMahon 16-APR-1990
C	A null line in the NEWS$OUT file would cause the Img(1:x) to bomb
C	with an out of bounds error.
C
	      If (Img_lg .eq. 0) Then
		Img = ' '
		Img_Lg = 1
	      Endif
	      If (Img(1:Img_Lg) .eq. '.') Then
		Img = '..'
		Img_Lg = 2
	      EndIf
	      Status = Srv_Send (Img(1:Img_Lg))
	      If (.not. Status) Then
		Call SMG_All_Print ('Server failed.')
		Stop
	      EndIf
	    Else
	      Eof = .true.
	    EndIf
	  EndDo

C Mark end of input with a .

	  Status = Srv_Send ('.')
	  If (.not. Status) Then
	    Call SMG_All_Print ('Server failed.')
	    Stop
	  EndIf

C Retrieve final status
C Vnews 1.4. Added code for Cancel.

	  Status = Srv_Recv (Img, Img_Lg)
	  If (.not. Status) Then
	    Call SMG_All_Print ('Server failed')
	    Stop
	  EndIf

	  If (.Not. CancelArticle) Then
		Call SMG_All_Print (Img(1:Img_Lg))
	  Else
		Call SMG_All_Print ('Article cancelled successfully.')
		Call Lib$Wait(2.0)
	  EndIf

	  Posted_Ok = .TRUE.

C Server not accepting postings

	Else

	  Call SMG_All_Print ('Server refusing posting requests.')
	  Call SMG_All_Print (Img(1:Img_Lg))

	  Posted_Ok = .False.

	EndIf

C Close the edit output file

	Close (LU_EditOut)

C Send a copy of the reply to the original poster, if requested.
C Note that we blasted "from" earlier in order to create a new
C From: line for the message, so we have to use OldFrom.

	If (MailCopyToSender) Then

	  Status = Send_Mail (	To(:ToLg), 
	1			File_Out(1:OutLg), 
	2			Subject(1:Subject_Lg),
	3			CopySelf )

	  Call SMG_All_Print(' ')	
	  If (Status) Then 
	    Call SMG_All_Print('A copy of your reply was sent to '//
	1			To(:ToLg)//'.')
	  Else
	    Call Lib$Signal (%Val(Status))
	  Endif
	EndIf


C Delete the input file

	IF (Posted_Ok) THEN
	  Call Delete_File (File_In(:InLg))
	  Call Delete_File (File_Out(:OutLg))
	End If

C Return

	Return

	End ! of Cmd_ArticlePost
