C
C  Subroutine library to interface UW TNEWS program to CMU TCP/IP.  This
C  library contains functions that take the WIN/TCP calls and makes
C  calls to the CMU TCP/IP driver instead.
C
C    Mike Iglesias
C    University of California, Irvine

	integer function socket(a, b, c)
	integer*4 a, b, c
	integer*4 status, sys$assign, chan
	include '($ssdef)'

C  Socket doesn't need any of the arguments, so we just do a SYS$ASSIGN
C  and return the channel number to the caller

	status=sys$assign('IP:', chan,,)
	if (status .ne. ss$_normal) chan = -1
	socket=chan
	return
	end

	integer function connect(chan, tcpsocket, socklen)
	include 'cmulib.def'
	integer*4 chan, socklen
	record /Socket_IN_Def/ tcpsocket

	structure /hostdef/
	  integer*4 len
	  character*128 text
	end structure
	record /hostdef/ hostname
	integer*4 status, sys$qiow
	record /cmuiosb/ iosb
	include '($ssdef)'

C  Connect does the hard work of connecting to the nntp server.

C  First, convert the IP address to a host name for the TCP$OPEN call

	status=sys$qiow(,%val(channel),%val(gthst),iosb,,,
     *                  %ref(hostname),%val(132),%val(2),
     *                  %val(tcpsocket.sin_address),,)
	if (status .ne. ss$_normal) then
	  print *,'error status from GTHST: ',status,iosb.errcode
	  connect=-1
	  return
	endif

	hostname.text(hostname.len+1:)=char(0)   !make it asciz

C  Now connect to the nntp server

	status=sys$qiow(,%val(channel),%val(tcp$open),iosb,,,
     *                  %ref(hostname.text),%val(119),,%val(1),
     *                  %val(0),%val(60))

	if (status .ne. ss$_normal) then
	  print *,'error status from TCP$OPEN: ', status,iosb.errcode
	  connect=-1
	  return
	else
	  connect=0
	endif

	return
	end

	Integer Function shutdown(chan)
C
C for compatibility with Multinet.
C
	Implicit None
	Integer*4 chan
	Integer*4 netclose

	shutdown = netclose(chan)

	Return
	End

	integer function netclose(chan)
	include 'cmulib.def'
	integer*4 chan
	integer*4 status, sys$qiow
	include '($ssdef)'

C  Close the connection

	status=sys$qiow(,%val(channel),%val(tcp$close),,,,	
     *                  %val(2),,,,,)

	if (status .ne. ss$_normal) then
	  print *,'Close error: ',status
	  netclose=-1
	else
	  netclose=0
	endif

	return
	end


	integer function recv(chan, bufadr, buflen, flags)
	integer*4 chan, bufadr, buflen, flags
	integer*4 status, sys$qiow
	include 'cmulib.def'
	record /cmuiosb/ iosb
	include '($ssdef)'

C Read from the net connection

	status=sys$qiow(,%val(channel),%val(tcp$receive),iosb,,,
     *                  %ref(bufadr),%ref(buflen),,,,)
	if (status .ne. ss$_normal) then
	  print *,'Error during receive: ',status,iosb.errcode
	  recv=-1
	endif

	recv=iosb.bytcnt
	return
	end

	integer function send(chan,bufadr,buflen,flags)
	integer*4 chan, bufadr, buflen, flags
	integer*4 status, sys$qiow
	include 'cmulib.def'
	record /cmuiosb/ iosb
	include '($ssdef)'

c  Send a message to the nntp server

	status=sys$qiow(,%val(channel),%val(tcp$send),iosb,,,
     *                  %ref(bufadr),%ref(buflen),,,,)
	if (status .ne. ss$_normal) then
	  print *,' Error during send: ',status,iosb.errcode
	  send=-1
	endif

	send=0
	return
	end

	Integer Function Inet_Addr( IP_Number )
C+++
C Simulate inet_addr() subroutine for CMULIB.  
C jms/910330 (Joel M Snyder, jms@arizona.edu)
C---
	Implicit 	None

	Character *(*)  IP_Number

	Integer   *4    X, I
        Integer   *4    IP
        Byte            IP_Byte
        Equivalence     (IP,IP_Byte)

	Inet_Addr = 0
        IP = 0
        I = 1
        Do X = 1,15
           If (IP_Number(X:X) .eq. '.') Then
	      Inet_Addr = Inet_Addr + (IP * 2**(8*(I-1)))
              IP = 0
              I = I + 1
           Else If (IP_Number(X:X) .eq. ' ') Then
           Else If ( (IP_Number(X:X) .ge. '0') .and.
     $          (IP_Number(X:X) .le. '9') ) Then
              IP = 10 * IP + IChar(IP_Number(X:X)) - IChar('0')
           EndIF
        EndDo
	Inet_Addr = Inet_Addr + (IP * 2**(8*(I-1)))

        Return

        End

c	subroutine gethostbyname()
c
c	print *, ' Look, I''m sorry, but gethostbyname() is not in this'
c	print *, ' version of VNEWS for CMU.  What you are going to'
c	print *, ' have to do is (1) change your NNTP_SERVER logical'
c	print *, ' name or compiled in constant (site_specific.def)'
c	print *, ' to have the real IP address of the host you want to'
c	print *, ' talk to, and (2) write the gethostbyname() emulation'
c	print *, ' software for VNEWS so that this can go away.'
c	print *, '  '
c	print *, ' I wish I could help, but I don''t have access to CMU'
c	print *, ' source code.'
c	print *, '  '
c	print *, ' Good luck.  jms/910331'
c	print *, '  '
c	stop ' %Need to fix NNTP_SERVER.'
c
c	End
