C
C  Subroutine library to interface UW TNEWS program to DECNET.  This
C  library contains functions that take the srv_ calls and makes
C  calls using DECNET task to task communication instead.
C  (PAF) preliminary version 7/12/90
C  several bugfixes. jms/910501/vnews 1.4
C
	integer function socket(a, b, c)

	Implicit	None

	Include		'Network.DEF/nolist'

C Function Arguments

	integer*4	a, b, c

C Function Variables

	integer*4	status, sys$assign, chan
c	integer*4	Translog
	integer*4	l_msg, sys$getmsg
	Integer*2	Len_DECNET, Len_TASK

	Character*255	msg
	Character*255	Temp

	Include '($ssdef)'
C
C  Set up default Server node and task string
C
	Socket = -1
C
C  Allow logical names to override the default values.
C  DECNET_Number is equivalenced to the common variable
C  Server_IP_Number, which has the ASCII DECnet node name in
C  it, terminated by a space.
C
	Len_DECNET = index(DECNET_Number,' ')-1
	Len_TASK = index(DECNET_TASK,' ')-1
C
C  Socket doesn't need any of the arguments, so we just do a SYS$ASSIGN
C  and return the channel number to the caller
C
	status=sys$assign(DECNET_Number(1:Len_DECNET)//'""::"'
	1                    //DECNET_Task(1:Len_TASK)//'"', 
	1                    %ref(chan),,)
C
C       check the status (note not ss$_normal!!!) (PAF)
C
	if (status .ne. ss$_remote) then 
	    status=sys$getmsg(%val(status),l_msg,msg,,) 
	    Call SMG_All_Print ('Error during connect: '//msg(:l_msg))
	    chan = -1
	end if
C
	socket=chan
	return
	end

	Integer Function Connect(chan, tcpsocket, socklen)

	Implicit None

c	include 'network.def/nolist'
c	include '($IODEF)'
c	include '($ssdef)'

	integer*4 chan, socklen
	integer*4 tcpsocket

c	integer*4 status, sys$qiow
c	record /deciosb/ iosb

	connect=0

	return
	end

	Integer Function shutdown(VMS_Channel, How)

	Implicit None

	include 'NETWORK.DEF'
	include '($IODEF)'
	include '($ssdef)'

	Integer*2 VMS_Channel
	Integer*4 How

	Integer*2 My_Channel
	integer*4 l_msg
	Integer*4 sys$getmsg,sys$cancel,sys$qiow,sys$dassgn
	character*255 msg
	integer*4 status

C 	Assume all will go well

	Shutdown = 0				! normal return
	My_Channel = %LOC(VMS_Channel)

C  	Close the connection

	status = sys$cancel(%VAL(My_Channel))
	If (Status .ne. SS$_NORMAL) Then
	    status = SYS$GETMSG(%val(status),l_msg,msg,,) 
	    Call SMG_All_Print ('Close (cancel) error: '//msg(:l_msg))
	    Shutdown = -1
	EndIf
		
	status = sys$dassgn(%VAL(My_Channel))
	If (Status .ne. SS$_NORMAL) Then
	    Status = sys$getmsg(%val(status),l_msg,msg,,) 
	    Call SMG_All_Print ('Close (DASSGN) error: '//msg(:l_msg))
	    Shutdown = -1
	EndIf
C
	Return

	End

	integer function recv(chan, bufadr, buflen, flags)
	
	Implicit None

	include 'NETWORK.DEF'
	include '($IODEF)'
	include '($ssdef)'

	integer*4 chan, bufadr, buflen, flags
	integer*4 status, sys$qiow
	integer*4 l_msg,sys$getmsg
	character*255 msg
	record /deciosb/ iosb

C Read from the net connection

	if( channel .eq. -1 ) then 
	    Call SMG_All_Print ('Error channel not open ')
	    recv=-1
	    return
	end if

	status = sys$qiow(,%val(channel),%val(IO$_READVBLK),
     &                    iosb,,,%ref(bufadr),%ref(buflen),,,,)
	if (status .ne. ss$_normal) then
	    status=sys$getmsg(%val(status),l_msg,msg,,) 
	    Call SMG_All_Print ('Error during receive: '//msg(:l_msg))
	    recv=-1
	endif

	recv=iosb.bytcnt
	return
	end

	integer function send(chan,bufadr,buflen,flags)

	Implicit None

	include 'NETWORK.DEF/nolist'
	include '($iodef)'
	include '($ssdef)'

	integer*4 chan, bufadr, buflen, flags
	integer*4 status, sys$qiow
	integer*4 l_msg,sys$getmsg
	character*255 msg
	record /deciosb/ iosb

	if( channel .eq. -1 ) then 
	    Call SMG_All_Print ('Error channel not open.')
	    send=-1
	    return
	end if ! (channel .eq. -1)

c  Send a message to the nntp server

	status=sys$qiow( , 			! efn
	1		%val(channel),		! chan
	2		%val(IO$_WRITEVBLK),	! func
	3		iosb,			! iosb
	4		,			! astadr
	5		,			! astprm
	6		%ref(bufadr),		! p1
	7		%ref(buflen),		! p2
	8		,,,)			! p3, p4, p5, p6
	if (status .ne. ss$_normal) then
	    status=sys$getmsg(%val(status),l_msg,msg,,) 
	    Call SMG_All_Print ('Error during send: '//msg(:l_msg))
	    send=-1
	endif ! (status .ne. ss$_normal)

	send=0
	return
	end ! of send

	Integer Function gethostbyname()
	GetHostByName=0
	return
	end

	subroutine inet_addr()
	return
	end

	subroutine bcopy()
	return
	end
