*   Edit.For - editor support for VNews         Pat Rankin, Apr'90
*						Installed into 1.4, jms/910325
*
*  i*4  Edit_File ( file_in, file_out )
*  i*4  Really_Edit_File ( file_in, file_out, callable, editor )
*  i*4  Invoke_Routine ( routine, arg1, arg2 )
*

	integer *4 function  Edit_File ( file_in, file_out )
	!
	!   Invoke an editor prior to posting or mailing.
	!   [Old code removed from CMD.FOR and fixed/enhanced.]
	!
	Include 'NEWS.DEF'

C     constant:
	include '($SHRdef)/nolist'
	parameter       ABORT = SHR$_ABEND .or. '08000000'x     !noname-w-abort
C     input:
	character *(*)  file_in,  file_out
C     local:
	integer *4      Status
C     functions:
	integer *4      Really_Edit_File

C     turn off broadcast catching so that we can spawn (either directly
C         or from within the called editor)
	call SMG_Handle_Broadcasts( .False. )    !disable broadcast trapping
C
C     do the real work
C
	Status = Really_Edit_File( file_in, 
	1			file_out,
	2			IsEditorCallable,
	3			VisualEditor(:VisualEditorLen) )

C     wrap up
	call SMG_Handle_Broadcasts( .True.)     !re-enable broadcast trapping

	if ( .not. Status ) then
	    call LIB$SIGNAL( %VAL(ABORT),
     &                       %VAL(1), 'VNews Edit',
     &                       %VAL(Status) )
C         since our caller is about to erase the screen, pause a bit
	    call LIB$WAIT( 2.0)
	end if

	Edit_File = Status
	return
	end !of Edit_File

	Integer *4 function  Really_Edit_File ( file_in, file_out,
	1                                        callable, editor )
	!
	!   Perform editing with signal trapping enabled.
	!
	implicit none
C     constant:
C         flag bits for callable EDT:
	parameter       EDT$M_RECOVER   =  1,   EDT$M_COMMAND  =  2,
     &                  EDT$M_NOJOURNAL =  4,   EDT$M_NOOUTPUT =  8,
     &                  EDT$M_NOCOMMAND = 16,   EDT$M_NOCREATE = 32
C     input:
	character *(*)  file_in,  file_out
	logical         callable
	character *(*)  editor
C     local:
	character *512  command
	integer *4      extern_routine,  Status
	    data    extern_routine /0/
	    save    extern_routine
C     functions:
	integer         TrimLg
	integer *4      Invoke_Routine
	integer *4      EDT$EDIT,  TPU$EDIT
	integer *4      LIB$SPAWN,  LIB$FIND_IMAGE_SYMBOL
	external        LIB$SIG_TO_RET

	call LIB$ESTABLISH( LIB$SIG_TO_RET)
C
C     Edit the file using callable interface or by spawning a subprocess.
C
C+++
C If the editor is not a callable one, then spawn the command
C---
	If ( .NOT. Callable) Then
	    Command = Editor // ' ' // File_In // ' ' // File_Out
	    Status  = LIB$SPAWN ( Command(:TrimLg(Command)) )
	Else	! Callable = .TRUE.
C+++
C We fall through to here because the editor IS callable
C---
	    If ( editor .eq. 'TPU' ) then
		Status = TPU$EDIT( file_in, file_out)
	    Else If ( editor .eq. 'EDT' ) then
		Status = EDT$EDIT( file_in, file_out,,, 
	1				EDT$M_NOJOURNAL,,,)
	    Else
C             invoke arbitrary callable editor (simplest interface only)
C                       [not tested]
		if ( extern_routine .eq. 0 ) then
C                 look for 'xxx_EDIT' in sharable image 'xxxSHR'
C                     [should also try for 'xxx$EDIT', perhaps even first]
		  Status = LIB$FIND_IMAGE_SYMBOL( editor // 'SHR',
     &                                           editor // '_EDIT',
     &                                           extern_routine)
		end if
		Status = Invoke_Routine ( extern_routine,
	1				  file_in,
	2				  file_out)
	    end if !TPU vs EDT vs other
C
	EndIf ! .NOT. Callable

	Really_Edit_File = Status

	Return

	end !of Really_Edit_File

	Integer Function Invoke_Routine (Routine, Arg1, Arg2)
C+++
C Call a routine that takes two string arguments.
C---
	Implicit None

C Input Arguments
	Integer *4	Routine
	External	Routine
	Character *(*)	Arg1, Arg2
	
	Invoke_Routine = Routine ( Arg1, Arg2 )

	Return

	End ! of Invoke_Routine
