C EXPAND_TABS.FOR

	Subroutine Expand_Tabs (In, Out)

	Implicit None

C Parameter Definitions

	Character *(*) In, Out

C Local Definitions

	Integer X_In, L_In, T_In, X_Out, L_Out, E_Out, L, T
	Integer HT
	Parameter (HT=9)

C Begin Expand_Tabs

	X_In = 1
	L_In = Len(In)

	X_Out = 1
	L_Out = Len(Out)

	Do While (X_In .le. L_In)

C Find the next tab

	  T_In = Index (In(X_In:L_In), Char(HT))

	  If (T_In .ne. 0) Then

	    T_In = T_In + X_In - 1

C Tab, found move text before tab (if any) to output

	    L = T_In - X_In
	    If (L .gt. 0) Then
	      If (X_Out .le. L_Out) Then
	        E_Out = X_Out + L - 1
	        If (E_Out .gt. L_Out) Then
	          E_Out = L_Out
	        End If
	        Out(X_Out:E_Out) = In(X_In:X_In+L-1)
	        X_Out = X_Out + L
	      End If
	    End If

C Now advance to the next tab stop if not already there

	    T = 8 * ((X_Out-1)/8 + 1) + 1
	    L = T - X_Out
	    If (L .gt. 0) Then
	      If (X_Out .le. L_Out) Then
	        E_Out = X_Out + L - 1
	        If (E_Out .gt. L_Out) Then
	          E_Out = L_Out
	        End If
	        Out(X_Out:E_Out) = ' '
	        X_Out = X_Out + L
	      End If
	    End If

	    X_In = T_In + 1

	  Else

C No tab found, copy remaider of text to output

	    L = L_In - X_In + 1
	    If (L .gt. 0) Then
	      If (X_Out .le. L_Out) Then
	        E_Out = X_Out + L - 1
	        If (E_Out .gt. L_Out) Then
	          E_Out = L_Out
	        End If
	        Out(X_Out:E_Out) = In(X_In:L_In)
	        X_In = X_In + L
	        X_Out = X_Out + L
	      End If
	    End If

	  End If
	End Do

C Blank fill rest of output

	If (X_Out .le. L_Out) Then
	  Out(X_Out:L_Out) = ' '
	End If

	Return

	End
