C GET_INIT.FOR

	Subroutine Get_Init(Server_Name)

	Include 'News.Def'
	Include 'Network.Def'

C Parameter Definition

	Character *(*)	Server_Name

C Local definitions

	Character*256   Dst_Fld
	Integer   *4    Status
	Integer   *4    I
	Integer   *4    Img_Lg
	Character *64   Img_Field
	Integer   *4    IP
	Byte            IP_Byte
	Equivalence     (IP,IP_Byte)
	Character *63   NNTP_Server		! for gethostbyname()
	Character *255  Temp
	Integer   *4    X
	Integer	  *4	hostp			! for gethostbyname()
	Logical		Is_Alpha		! for gethostbyname()
	Logical		Was_MAIL$EDIT		! for VisualEditor

	Integer		TransLog, TrimLg
	Integer	  *4	STR$CASE_BLIND_COMPARE	! RTL	
	External	STR$CASE_BLIND_COMPARE
	Integer   *4	decc$gethostbyname, decc$inet_addr
	External	decc$gethostbyname, decc$inet_addr, bcopy


	Character *(*)  CallablePrefix
	Parameter     ( CallablePrefix = 'CALLABLE_' )
	Parameter       CallablePrefixLen = 9         !LEN(CallablePrefix)

C Site Specific Definitions

	Include 'Site_Specific.DEF'

C Begin Get_Init

C
C Get the distribution field
C       
	X = 1
	Distribution_Count = 0
	Call Str$Trim ( Dst_Fld, Dst_Fld, Img_Lg )
	Do While (X .lt. Img_Lg)
	   Call Field (Dst_Fld(1:Img_Lg), X, Img_Field)
	   If (Img_Field .ne. ' ') Then
	      Distribution_Count = Distribution_Count + 1
	      Distribution(Distribution_Count) = Img_Field
	   EndIf
	EndDo

C NOTE: All Vnews logical name translations simplified for V1.4
C	to use process/job/group/system tables, at all access
C	modes. jms/910325
C
C Get the Site ID. Logical name ARPANET_HOST_NAME must already be 
C defined.  If you're running CMU, you have INTERNET_HOST_NAME, which
C should be OK.
C
C Use NNTP_HOST_NAME if present, to allow a cluster alias to override
C its individual node names. pr/910816
C
	Status = TransLog ('NNTP_HOST_NAME', Temp, 0)
	If (.NOT.Status)
	1    Status = TransLog ('ARPANET_HOST_NAME', Temp, 0)
	If (.NOT.Status)
	1    Status = Translog ('INTERNET_HOST_NAME', Temp, 0)
	If (.NOT.Status)
	1    Status = Translog ('UCX$INET_HOST', Temp, 0)
	If (Status) Then
	   Call Down_Case (Temp)
	   SiteId = '@'//Temp(1:index(Temp,' ')-1)
	Else
	   Call SMG_All_Print ('NNTP_HOST_NAME must be defined for')
	   Call SMG_All_Print ('VNEWS to run.  Read the documentation.')
	   Stop 
	EndIf
C
C Get the organization field. If the logical name NNTP_ORGANIZATION is not
C defined the string will be taken from the default definition. Process
C logical name will be checked first.
C
	Status = TransLog ('NNTP_ORGANIZATION',Temp, 0)
	If (Status) Then
	   Organization = Temp(1:index(Temp,'  ')-1)
	EndIf


C 
C Get the Reply_To: field.  If the logical name NNTP_REPLY is defined,
C it will be created.  If not, we'll stick to the poster's address.
C
	ReplyTo = ' '
	Status = TransLog ('NNTP_REPLY', Temp, 0)
	If (Status) Then
	    ReplyTo = Temp(1:index(Temp,' ')-1)
	EndIf

C 
C Get the Lunar Date field.  If the logical NNTP_LUNAR is defined, then
C postings will have a lunar date appended.
C
	Status = Translog ('NNTP_LUNAR', Temp, 0)
	If (Status) Then
	    Obscure_Gratuitous_Lunar_Date = .TRUE.
	Else
	    Obscure_Gratuitous_Lunar_Date = .FALSE.
	EndIf
	

C
C Get the NNTP_NewsRC_Location.  If the logical name NNTP_NewsRC_Location
C is defined, use that instead.  If the location doesn't end with a
C right bracket or a colon (i.e., node::, disk:, [directory]), then we
C assume that it should have a colon on the end, and stick it there.
C
	Status = TransLog ('NNTP_NEWSRC_LOCATION',Temp, 0)
	If (Status) Then
	    NewsRC_Loc = Temp(1:index(Temp,' ')-1)
	EndIf
	X = TrimLg(NewsRC_Loc)
	If (NewsRC_Loc(X:X) .NE. ':' .AND.
	1   NewsRC_Loc(X:X) .ne. ']') Then
	    NewsRC_Loc(X+1:X+1) = ':'
	EndIf
	
C 
C Get the timezone field.  If the logical NNTP_TIMEZONE is not defined,
C the string will be taken from the default definition.  Other popular
C timezones will also be checked.
C If anyone wants to write the code to translate LISP$TIME_ZONE 
C (which is a simple integer) or GMT_DSP into a +/-hhmm format,
C please contribute!
C
	Status = TransLog ('NNTP_TIMEZONE', Temp, 0)
	If (.NOT.Status)
	1    Status = Translog ('PMDF_TIMEZONE', Temp, 0)
	If (.NOT.Status) 
	1    Status = Translog ('MULTINET_TIMEZONE', Temp, 0)
	If (.NOT.Status)
	1    Status = Translog ('JAN_TIME_ZONE', Temp, 0)
	If (Status) Then
	    Timezone = Temp(1:Index(Temp,' ')-1)
	EndIf

C
C Get the Mailer name. The logical name NNTP_MAILPOSTER will be checked
C to see if the user has overridden the definition given above.
C
	Status = TransLog ('NNTP_MAILPOSTER', Temp, 0)
	If ( Status ) Then
	   Mailer = Temp(1:Index(Temp,'  ')-1)
	EndIf
	    
C
C Get the print command. The logical name NNTP_NEWS_PRINT will be
C checked to see if the user has overriden the print command definition.
C
        Status = TransLog ('NNTP_NEWS_PRINT', Temp, 0)
        If (Status) Then
           Call STR$Trim (Temp, Temp, I)
           PrintCommand = Temp(1:I) //
     $          '/NOTIFY/DELETE SYS$SCRATCH:NEWS_PRINT.TXT'
        EndIf

C
C Get the Visual Editor preferences.  If the logical name NNTP_VISUAL
C (or NNTP_EDITOR  or MAIL$EDIT) is defined, use that.  Else, use
C the local definition.
C
	Was_MAIL$EDIT = .false.
	IsEditorCallable = .false.

	Status = Translog ('NNTP_VISUAL', Temp, 0)
	If (.NOT. Status) 
	1	Status = Translog ('NNTP_EDITOR', Temp, 0)
	If (.NOT. Status) Then
	    Status = Translog ('MAIL$EDIT', Temp, 0)
	    If (Status) Was_MAIL$EDIT = .true.
	EndIf

C
C  Parse editor; default is given by DefaultEditor
C
	If ( Temp .NE. ' ') Then
	    VisualEditor = Temp(1:index(Temp,' ')-1)
	EndIf

	VisualEditorLen = TrimLg(VisualEditor)

	If ( (VisualEditorLen .GT. CallablePrefixLen) .AND.
	1    (STR$CASE_BLIND_COMPARE( CallablePrefix,
	2		VisualEditor(:CallablePrefixLen))   
	3		.EQ. 0) 
	4  ) IsEditorCallable = .TRUE.

	If (IsEditorCallable) Then
	    Call STR$UPCASE( VisualEditor,
	1	     VisualEditor(CallablePrefixLen+1:VisualEditorLen))
	    VisualEditorLen = VisualEditorLen - CallablePrefixLen
	Else 
	1 If ( (Was_MAIL$EDIT) .AND.
	2      (VisualEditor(1:1) .NE. '@') ) Then
	    VisualEditor = '@' // VisualEditor(:VisualEditorLen)
	    VisualEditorLen = VisualEditorLen + 1
	Endif

C
C Get the DECnet Task string. If the logical name NNTP_TASK is
C not defined, the task name will be taken from the default definition.
C
C
        Status = TransLog ('NNTP_TASK',Temp, 0)
        If (Status) Then
	    DECNET_Task = Temp(1:index(Temp,' ')-1)
	EndIf

C Figure out what the transport is.
	NNTP_Transport = UNKNOWN_TRANSPORT
C
C Get the IP number. If the logical name NNTP_SERVER is not defined
C the number will be taken from the default definition. Process logical
C name will be checked first.
C
C New server id code -- use tcp/ip routines instead of manual parse [pr]
C Installed into vnews 1.4 910325.
C
	status = Translog('NNTP_SERVER', Temp, 0)
	If (Status)  nntp_server = Temp
  
C
C Check to see if there is a colon in nntp_server.  If so, then
C this must be DECnet, and we don't have to any of this nonsense.
C On the other hand, if there's a colon, and we're not linked for
C DECnet, the whole thing will blow up---but that's not a real big
C problem, is it, since we're broke anyway?
C Vnews 1.4/jms/910328
C
	X = index(nntp_server,':')  ! if there is a colon in NNTP_SERVER,
	If (X .gt. 1) Then
	    Do I=1,x-1
		Server_IP_Number(i) = ICHAR(nntp_server(i:i))
	    EndDo
	    Server_IP_Number(X) = ICHAR(' ')
	    Server_Name = NNTP_Server
	    NNTP_Transport = DECNET_TRANSPORT
	    Return
	EndIf
	   	
	X = index(nntp_server,' ')  !use trailing space to determine length
	nntp_server(X:X) = CHAR(0)  !convert to NUL-terminated (ASCIZ) string

	is_alpha = .false.
	do while ( X .gt. 1 )       !figure whether it's numeric or alphabetic
	   X = X - 1
	   if ( ( nntp_server(X:X).LT.'0' .OR. nntp_server(X:X).GT.'9')
	1	.AND. nntp_server(X:X) .NE. '.' ) then
	      is_alpha = .true.
	      X = 0     !break loop
	   endif
	end do
 
C+++
C If the host name is alphabetic, then call gethostbyname and copy
C the IP number into Server_IP_Number.  If not, then simply do
C the copy.
C Before we do anything, copy the name so that the user can see it later.
C---
	Server_Name = NNTP_Server
	NNTP_Transport = TCPIP_TRANSPORT

	If (is_alpha) then
	   hostp = decc$gethostbyname(%REF(nntp_server))
	   If (hostp .eq. 0) Then
		Call SMG_All_Print ('gethostbyname failed to find your')
		Call SMG_All_Print ('NNTP_SERVER. Is it a valid DNS name?')
		STOP 
	   EndIf
c         get pointer to address list
	   call bcopy( %VAL(hostp + hostent__H_ADDR), X, %VAL(4))
c         get pointer to [first] address
	   call bcopy( %VAL(X), X, %VAL(4))
c         copy value of address
	   call bcopy( %VAL(X), Server_IP_Number, %VAL(4))
	else
	   IP = decc$inet_addr(%REF(nntp_server))
	   If (IP .eq. -1) Then
		Call SMG_All_Print ('inet_addr failed to convert NNTP_SERVER')
		STOP
	   EndIf
	   call bcopy( IP, Server_IP_Number, %VAL(4))
	endif

	Return

	End ! of Get_Init
