/*
 * CMULIB.C - emulates gethostbyname() 
 *
 * Bruce Miller/bm17+@anywhere/910531
 *
 */

#include descrip
#include stsdef
#include iodef

/*
 * Standard gethostbyname() hostentry
 */

typedef struct  {
	char    *h_name;        /* official name */
	char    **h_aliases;    /* alias list */
	int     h_addrtype;     /* host address type */
	int     h_length;       /* length of address */
	char    **h_addr_list;  /* list of addresses */
#define h_addr  h_addr_list[0]  /* address, for compat */
	char    *h_cputype;     /* cpu type */
	char    *h_opsys;       /* operating system */
	char    **h_protos;     /* protocols */
	struct  sockaddr *h_addresses; /* sockaddr form */
	} hostent;

typedef struct {
	short cond_value;
	short count;
	int info;
	} io_statblk;

/*
 * Constants and structures from CMU/TEK TCP-IP
 */

#define U$GH_NAMADR 1

#define MAX_HADDRS 20
#define MAX_HNAME 128

typedef struct {
	unsigned long GHA$NL_ADRCNT;		/* Count of addresses */
	unsigned long GHA$NL_ADRLST[MAX_HADDRS];/* Address list */
	unsigned long GHA$NL_NAMLEN;		/* Official name length */
	char  GHA$NL_NAMSTR[MAX_HNAME];		/* Official name string */
	} GTHST_NMLOOK_BLOCK;

static GTHST_NMLOOK_BLOCK buffer;
static hostent uglyness;
static char* hostaddr;

hostent *
gethostbyname(name)
char *name;
/*
 * Returns a pointer to a hostent, or null in case of error.
 */
{
    io_statblk IOSB;
    unsigned long RC;
    $DESCRIPTOR(IPDevice,"INET$DEVICE");
    unsigned short chan;

    RC = SYS$ASSIGN(&IPDevice,&chan,0,0);
    if (!(RC & STS$M_SUCCESS)) return 0;

    RC = SYS$QIOW(0,chan,IO$_SKIPFILE,&IOSB,0,0, 
		  &buffer,sizeof(buffer),U$GH_NAMADR,name,0,0);
    if (!(RC & STS$M_SUCCESS)) return 0;
    if (!(IOSB.cond_value & STS$M_SUCCESS)) return 0;

    hostaddr = &buffer.GHA$NL_ADRLST[0];
    uglyness.h_addr_list = &hostaddr;

    RC = SYS$DASSGN(chan);
    if (!(RC & STS$M_SUCCESS)) return 0;

    return &uglyness;
}
