C GETINTEGER.FOR

C**************************************************************************
C
C This routine evaluates the integer value of the beginning of the 
C string-buffer Text.
C						Alain Cedelle Apr 8,1991
C						cedelle@yin.irisa.fr
C**************************************************************************
C bugfix to call ots$ func instead of fortran RTL to handle some
C bad data input cases. pr/910620.

	Logical Function Get_Integer (Text, X, N)

	Implicit None

C Parameter definition

	Character *(*)	Text
	Integer   *4	N		! returned value
	Integer   *4	X		! index in Text buffer (updated)

C Local definitions

	Character *1	tab
	Parameter	( tab = CHAR(9) )
	Integer   *4	Lg
	Integer   *4	FirstX
	Logical		Is_Integer
  
	Integer   *4	OTS$CVT_TI_L	! number conversion routine

C Begin Get_Integer

	Lg = Len(Text)
	N = 0
	Is_Integer = .true.		! assume is an integer

C Skip leading blanks

	Do While ((X .le. Lg) .and. 
	1	( text(X:X) .eq. ' ' .or. text(X:X) .eq. tab) )
	    X = X + 1
	EndDo

	FirstX = X			! save starting position

C Ignore the sign, if any

	If ( X .le. Lg .and. text(X:X) .eq. '-' ) X = X + 1

C Get the digits
  
	Do While ( (X .le. Lg) .and. Is_Integer )
	    If ((Text(X:X) .ge. '0').and.(Text(X:X) .le. '9')) Then
		X = X + 1
	    Else
		Is_Integer = .FALSE.
	    End If
	End Do

	If (X .gt. FirstX) Then
	    If (.NOT. OTS$CVT_TI_L( text(FirstX:X-1), N)) ! decode value
	1	Is_Integer = .FALSE. 		! error (value too large?) 
	Else
	    Is_Integer = .FALSE. 		! no digits found
	End If

	Get_Integer = Is_Integer

	Return

	End ! of Get_Integer
