C GETPERSONALNAME.FOR - get a personal name for the user

	Integer Function GetPersonalName (Name)

C+++
C	This subroutine will attempt to create a personal name for
C	the user.  It looks in three places:
C		NNTP_NAME logical name
C		MAILUAF database (Personal Name field)
C		SYSUAF database (Owner field)
C---

	Implicit 	NONE

C	output
	Character*(*)	Name

	Integer*4 	Context
	Volatile	Context

	Integer*4	Status

	Character*12	Username
	Character*32	Owner
	Character*128	Temp
	Integer*4	Length

	Integer  TransLog, TrimLG

	External  MAIL$USER_BEGIN, MAIL$USER_GET_INFO, MAIL$USER_END
	Integer*4 MAIL$USER_BEGIN, MAIL$USER_GET_INFO, MAIL$USER_END
	External  SYS$GETUAI, SYS$GETJPI
	Integer*4 SYS$GETUAI, SYS$GETJPI
	INCLUDE '($MAILdef)/nolist'             !callable mail definitions
	INCLUDE '($SSdef)/nolist'		!status return def'ns
	INCLUDE '($UAIdef)/nolist'		!$GETUAI definitions
	INCLUDE '($JPIdef)/nolist'		!$GETJPI definitions

	INCLUDE 'Itemlist.DEF'			!Itemlist structure def'n

	RECORD /itmlst/ item_list(2)

C+++
C	Assume this will come out OK.
C---
	GetPersonalName = .TRUE.
	Temp = ' '

C+++
C 	NNTP_NAME logical name
C	first, check to see if they have defined a logical name for
C	their personal name.  If this fails, drop through to the
C	MAILUAF solution.
C---
        Status = TransLog ('NNTP_NAME', Temp, 0)
	If (Status) Then
	   Name = Temp
	   Return
	EndIf

C+++
C 	MAILUAF
C	Now, try reading from the Mail User database.
C	If anything at all fails, drop through (line 300) to
C	the SYSUAF solution.  Also, if the personal name has a
C	length of zero, drop through. 
C---
	Status = MAIL$USER_BEGIN( %REF(Context) , 0 , 0 )	
	If (Status .NE. SS$_NORMAL) GOTO 300

C Build an item list to get the user information
	item_list(1).buflen = 128	! maximum length of username,NEWS.DEF
	item_list(1).code = MAIL$_USER_PERSONAL_NAME
	item_list(1).bufaddr = %LOC(temp)
	item_list(1).retlenadr = %LOC(length)
	
	item_list(2).end_list = 0

	Status = MAIL$USER_GET_INFO(
	1	%REF(Context),
	2	0 ,
	3	%REF(Item_List))
	If (Status .NE. SS$_NORMAL .or. length .le. 0) GOTO 300

	Status = MAIL$USER_END( %REF(Context) , 0 , 0 )

	Name = Temp

	Return

C+++
C 	SYSUAF
C	Finally, try reading from the SYSUAF the personal name.
C	Use $GETJPI to get the username, and if there is no 
C	"Owner" field, then use the username.  We hope against hope
C	that a $GETJPI on JPI$_USERNAME will not fail, as this will
C	cause VNEWS to exit.
C---
300	CONTINUE

	item_list(1).buflen = 12
	item_list(1).code = JPI$_USERNAME
	item_list(1).bufaddr = %LOC(username)
	item_list(1).retlenadr = %LOC(length)
	
	item_list(2).end_list = 0

	Status = SYS$GETJPI (  , , , %REF(Item_List), , , )
	If (Status .NE. SS$_NORMAL) Then
	    GetPersonalName = .FALSE.
	    Return
	EndIf

	item_list(1).buflen = 32
	item_list(1).code = UAI$_OWNER
	item_list(1).bufaddr = %LOC(owner)
	item_list(1).retlenadr = %LOC(length)

	item_list(2).end_list = 0	

	Status = SYS$GETUAI (, , username , %REF(Item_List), , , )

C+++
C Owner has to be at least one character (remember the length byte
C in front) or we just use the VMS username.
C---
	Name = Username		! just in case.
	If (Status .EQ. SS$_NORMAL) Then
	    Length = TrimLG(Owner)
	    If (Length .GT. 1) Name = Owner(2:)
	Endif

	Return

	END ! of GetPersonalName
