C GETUSERDIRECTORY.FOR 

C Enhanced (?) 930105/jms to create the .NEWS directory if it
C does not exist.  This would be the place to change this via
C a logical name, if you insisted.

        Integer Function GetUserDirectory (Dir)

        Include 'News.Def'

C Parameter definitions

        Character *(*) Dir

C External definitions

        Integer  Sys$GetUAI
	Integer  LIB$CREATE_DIR
	Integer  TrimLg

C Local Definitions

        Include '($UAIDEF)'

        Character       *32             Device		! Vnews 1.4/jg/910326
        Integer         *4              DeviceLg	! per $GETUAI SYS-317
	Character	*32		Owner
        Integer         *4              OwnerLg
        Character       *64             Directory
        Integer         *4              DirectoryLg
	Character	*64		SysLogin	! vnews 1.51/jms
	Logical         		Directory_Exists ! 930105

C Begin GetUserDirectory

	Include 'Itemlist.DEF'
        Record /Itmlst/ Itmlist(5) ! Changed by McMahon (VNEWS 1.3-3)
                                ! was originally defined to 4 and blew
                                ! up when it was finally recompiled.

        Itmlist(1).Buflen = 64
        Itmlist(1).Code = UAI$_DefDir
        Itmlist(1).BufAddr = %loc(Directory)
        Itmlist(1).RetlenAdr = %loc(DirectoryLg)

        Itmlist(2).Buflen = 32
        Itmlist(2).Code = UAI$_DefDev
        Itmlist(2).BufAddr = %loc(Device)
        Itmlist(2).RetlenAdr = %loc(DeviceLg)

        Itmlist(3).Buflen = 32
        Itmlist(3).Code = UAI$_Owner
        Itmlist(3).BufAddr = %loc(Owner)
        Itmlist(3).RetlenAdr = %loc(OwnerLg)

        Itmlist(4).End_List = 0

        GetUserDirectory = Sys$GetUAI (,,UserName,Itmlist,,,)
        If (GetUserDirectory) Then
        Else
         Return
        EndIf

        DeviceLg = IChar(Device(1:1))
        DirectoryLg = IChar(Directory(1:1))
        OwnerLg = IChar(Owner(1:1))

        Dir = Device(2:DeviceLg+1) // 
	1	Directory(2:DirectoryLg) //
	2	'.NEWS]'

	SysLogin = Device(2:DeviceLg+1) //
	1	Directory(2:DirectoryLg+1) //
	2	'NEWS.DIR'

C Check to see if the UserDirectory has been created.  If it hasn't,
C create it and tell the user.

	Inquire (File=SysLogin, Exist=Directory_Exists)
	If (.not. Directory_Exists) Then
	    GetUserDirectory = Lib$Create_Dir
	1	(
	1	Dir(1:TrimLg(Dir)),		! Name
	1	,				! Owner
	1	'FF00'X,			! Prot enable
	1	'FF00'X,			! Prot mask
	1	,				! Max versions
	1					! Rvn
	1	)
	    If (GetUserDirectory) Then
	      Call SMG_All_Print
	1	('Created your NEWS storage directory.')
	    Else
	      Call SMG_All_Print
	1	('Unable to create your NEWS storage directory.')
	    EndIf
	EndIf

        Return

        END ! of GetUserDirectory
