C GROUP_FIND.FOR

	Integer Function Group_Find (Name)

	Include 'News.Def'

C Parameter definition

	Character *(*)	Name

C Local definitions

	Integer   *4	I
	Integer		Str$Match_Wild
	Integer		Trimmed_Length, Trimlg
	Logical		Try_Wild

C Begin Group_Find

	Group_Find = 0

c
c	VNEWS 1.3-4	John McMahon
c	Modified GROUP_FIND to accept wildcard patterns, primarily
c	for the GO command which calls this routine.  Exact matching
c	still works.
c
C	Efficiency optimize: move call to TrimLg out of loop. pr/910325
C	Also: Don't try wildcard matching unless the target contains
C	explicit wildcard character(s). pr/910327. VNEWS 1.4

	Trimmed_Length = Trimlg(Name)

C The only way the position of '*' can equal the position of '%' is if
C they're both 0 (i.e., neither is present).  In that case, the user is not
C trying to use wildcards.  Try_Wild is TRUE if wildcards should be tried.

	Try_Wild = (   INDEX(name(1:trimmed_length),'*')
	1	  .ne. INDEX(name(1:trimmed_length),'%') )

	I = 1

	Do While ((I .le. Group_Count) .and. (Group_Find .eq. 0))

	    If (     (Name .eq. Group(I).Name) .OR.
	1	     (Try_Wild .AND.
	1		Str$Match_Wild (
	1		  group(I).name(1:trimlg(group(I).name)) , 
	1		  name(1:Trimmed_Length) ) ) )
	1 Then
		Group_Find = I
	    Else
		I = I + 1
	    EndIf
	EndDo

	Return

	END ! of Group_Find
