C MARK_XREF_AS_READ.FOR 

        Subroutine Mark_Xref_As_Read (Art, G)

        Include 'News.Def'
C+
C       Formal paramters.
C-
        Integer Art			! Article in current group.
        Integer G			! Group number.
C+
C       External routines.
C-
        Integer TrimLg			! Trims the length of a srting.
        Integer ValI4			! Gets the Value of a string.
C+
C       Local variables
C updated for VNEWS 1.4 to include NwsGrpSz. jg/910326
C bugfix pr/910414
C-
	Character *512 Buf		! Buffer for XHDR.
	Integer Buf_Lg			! Length of Buf
	Integer Space_Index		! Where the space is in the string.
	Integer Colon_Index		! Where the colon is in a string.
	Integer Art_Number		! Article number cross referenced.
	Character *(NwsGrpSz) Group_Name! Group name cros referenced.
	Character *(NwsGrpSz) This_Group! Current group.
	Character *(NwsGrpSz+12) Cross_Post	! Group & Article number xrefed.

C+
C       M a i n    C o d e
C-

	Buf = ' '

	This_Group = Group(G).Name

	Call XHdr (Art, 'XRef', Buf, Buf_Lg)

C
C	Added to correct a problem with calling XREF when the Article Header
C	and Body was missing.  Instead of getting a (NONE), a "." was returned.
C	This combined with the garbage left in Buf from the call caused a
C	numeric conversion error.
C
C	John McMahon - 26-FEB-1990 18:43:53.21 
C

	If (Buf(1:Buf_Lg) .eq. '.') Return

	Buf = Buf (Index (Buf, ' ') + 1:Buf_Lg)
	Buf_Lg = TrimLg (Buf)

	IF (Buf(:Buf_Lg) .NE. '(none)') THEN
	  Buf = Buf (Index (Buf, ' ') + 1:)
	  Do While (Buf .Ne. ' ')
	    Space_Index = Index (Buf, ' ')
	    Cross_Post = Buf (:Space_Index - 1)
	    Buf = Buf (Space_Index + 1:)
	    Colon_Index = Index (Cross_Post, ':')
	    Group_Name = Cross_Post (:Colon_Index - 1)
	    IF (This_Group .NE. Group_Name) THEN
	      Art_Number = ValI4 (Cross_Post (Colon_Index + 1:
	1          TrimLg (Cross_Post)))
	      Call Mark_As_Read (Group_Name, Art_Number)
	    End If
	  END Do
	End IF

	Return

	End
