C       NNTP NEWS Reader
C
C************************************************************************
C
C    Portions of this software are 
C    Copyright (C) 1988, University of Wisconsin Board of Regents,
C    all rights reserved.
C
C    Anyone may reproduce this work, in whole or in part, provided
C    that: (1) any copy of the entire work must show University of
C    Wisconsin as the source, and must include this notice; and (2)
C    any other use of this work must acknowledge the fact that the
C    material is coprighted by the University of Wisconsin Board of
C    Regents and is used by permission.
C
C    Copyright (C) 1991, University of Arizona Board of Regents,
C    all rights reserved.
C
C    Anyone may reproduce this work, in whole or in part, provided
C    that: (1) any copy of the entire work must show University of 
C    Arizona as the source, and must include this notice; and (2)
C    any other use of this work must acknowledge the fact that the
C    material is coprighted by the University of Arizona Board of
C    Regents and is used by permission.
C************************************************************************
C
C Changes: moved to NEWS.CHANGES.
C

	PROGRAM NEWS

	Include 'News.Def/list'
	Include 'SMG.Def/list'
	Include 'Debug.Def/list'
	Include 'Handler.Def/list'

C External Routines

	Integer			CLI_Get_Value
	Integer			CLI_Present
	Integer			GetUserName
	Integer			GetUserDirectory
	Integer			GetPersonalName
	Integer			Open_Newsrc
	Integer			Srv_Connect
	Integer			Srv_Recv
	Integer			TrimLg
	Real     *4		Secnds

C Local Definitions and Constants

	Character *512		Buf
	Character *64		Server_Name	! returned name of server
	Integer   *4		Lg
	Integer			Status		! Status of various commands.

	Parameter	CLI$_PRESENT = '0003FD19'x  ! cli value is present
	Parameter	CLI$_NEGATED = '000381F8'x  ! cli value is negated

C Security precaution -- should do this with LIB$INITIALIZE
C pr/910325.  Vnews 1.4

	call Disable_Installed_Privs()

C Begin News

	Range_Free_List = 0             ! Initialize Range item free list
	Group_Count = 0                 ! Initialize next group
	Range_Count = 0                 ! Initialize next range
	Header_Count = 0                ! Number of /Header fields
	NoAsk = .FALSE.			! Ask on Catchup (jms/910327/V1.4)
	SubProc_PID = 0			! no held subprocesses (jms/910619)
	Yow_Signature = .FALSE.		! No Yow in signature

C
C     Parse command before doing anything else [pr] 
C	Added to VNEWS 1.4 910325
C
	call VNews_Cli_Init()
	Lg = 0

C Get /Header qualifier telling us what header lines to print

	Header_Present = Cli_Present('HEADER')
	If (Header_Present) Then
	  Status = 1
	  Do While (Status)
	    Header_Count = Header_Count + 1
	    Status = Cli_Get_Value('HEADER', Header(Header_Count), Lg)
	  EndDo
	  Header_Count = Header_Count - 1
	EndIf

C Get followup command mark character

	Status = Cli_Get_Value('MARK', Mark_Character, Lg)
	If (.not. Status) Then
	  Mark_Character = '>'
	EndIf

C Get /AutoCatchup qualifier

	Status = Cli_Present('AUTOCATCHUP')
	If (Status .EQ. CLI$_PRESENT) Then
	  NoAsk = .TRUE.
	Else If (Status .EQ. CLI$_NEGATED) Then
	  NoAsk = .FALSE.
	EndIf

C Get /Debug qualifier

	Status = Cli_Present('DEBUG')
	If (Status .EQ. CLI$_PRESENT) Then
	  Debug = .TRUE.
	Else If (Status .EQ. CLI$_NEGATED) Then
	  Debug = .FALSE.
	EndIf

C Get /Yow qualifier

	Status = Cli_Present('YOW')
	If (Status .EQ. CLI$_PRESENT) Then
	  Yow_Signature = .TRUE.
	Else If (Status .EQ. CLI$_NEGATED) Then
	  Yow_Signature = .FALSE.
	EndIf

C Get qualifier for newsgroup to be read

	GroupSelect = Cli_Present('GROUP')
	If (GroupSelect) Then
	  Status = Cli_Get_Value('GROUP', NewsGroup, Lg)
	  If (Status) Then
	    Call Down_Case (NewsGroup)
	  Endif
	EndIf
C
C     -- end of DCL command parsing --
C	end of VNEWS 1.4 addition 910325
C

        Call SMG_Initialize             ! Initialize screen routines

C Added a ^Y handler to jump to quit_news() once newsrc has been read in.
C paf,jms/910327. vnews 1.4
C NOTE: This must be AFTER the call to SMG_INITIALIZE

	call Declare_Handler		! ^Y handler for VNEWS

C Get our user name

	Status = GetUserName (UserName)
	If (.not. Status) Then
	  Call SMG_All_Print ('Error obtaining your username')
	  Stop
	EndIf

C Get our .news directory and personal name

	Status = GetUserDirectory (UserDirectory) 
	If (.not. Status) Then
	  Call SMG_All_Print('Error obtaining your login directory')
	  Stop
	EndIf
	Status = GetPersonalName ( UserPersonalName )
	If (.not. Status) Then
	  Call SMG_All_Print('Error obtaining your personal name')
	  Stop
	EndIf

C Set up for some basic statistics

	Time_In = SECNDS(0.0)
	Messages_Read = 0
	Answers_Written = 0
	Groups_Read = 0

	Call Ctrl_C                     ! Initialize control C handler

	Call Version                    ! Print out the version

	Call Get_Init(Server_Name)      ! Get configuration values

C Read users XX.NEWSRC file

	Call SMG_All_Print ('Reading your XX.Newsrc file from ' //
	1	NewsRC_Loc(:TrimLG(NewsRC_Loc))//' ...')
	Status = Open_Newsrc()
	Call SMG_All_Print (' ')

C Connect to server

	Call SMG_All_Print
	1 ('Connecting to remote news server ' //
	2   Server_Name(:TrimLG(Server_Name)) // ' ...')
	Status = Srv_Connect()
	If (.not. Status) Then
	  Call SMG_All_Print('Can not connect to remote news server!')
	  Stop
	EndIf

C Get initial signon line
C Fix bug in call to sys$fao. 910320/jms

	Status = Srv_Recv (Buf, Lg)
	If (.not. Status) Then
	  CALL SYS$FAO (
	1	'Error receiving data from news server, status = !UL',,
	1	Buf,
	1	%VAL (Status))
	  Call SMG_All_Print (Buf(1:TrimLg(Buf)))
	  Stop
	EndIf

	If (Lg .gt. 0) Then
	  Call SMG_All_Print (Buf (1:Lg))
	EndIf

C Determine if posting is allowed. Set the Posting_Allowed global,
C or die if neither 200 or 201 appear (RFC977 pg 8) 900622/jms

	If (Buf(1:3) .eq. '200') Then
	   Posting_Allowed = .TRUE.
	Else If (Buf(1:3) .eq. '201') Then
	   Call SMG_All_Print('You cannot post to this news server.')
	   Posting_Allowed = .FALSE.
	Else
	   Call SMG_All_Print ('NNTP server has refused connection.')
	   Stop
	End If

	Call SMG_All_Print (' ')

C Tell Exit Handler that we have connected and are continuing

	EXH_Connected = .TRUE.

C Get the active file from the remote host.

	Call SMG_All_Print 
	1	('Retrieving status of all groups from server...')
	Call NNTP_Get_Active_File ()
	Call SMG_All_Print (' ')

C Now get list of groups created since XX.NEWSRC created

	If (Newsrc_Is_Open) Then
	  Call SMG_All_Print
	1	('Last News execution at ' // Newsrc_CDT_VMS // '.')
	  Call SMG_All_Print (' ')
	  Call SMG_All_Print ('Retrieving any new groups from server...')
	  Call NNTP_Get_New_Groups ()
	End If

C prompt about subscribing for each new group (in NNTP.FOR)

	Call Query_New_Groups()

C Tell Exit Handler that we have read the NEWSRC file and it is OK.

	EXH_NewsrcRead = .TRUE.

C Go and read all the news that we have.

	Call Read_News ()

C Clean up and Exit

	Call Quit_News (.TRUE.)			! save NewsRc YES

	End

	SUBROUTINE Quit_News(Save_NewsRc)
C+++
C All done. Close out and finish off.
C---

	Include 'News.Def/list'
	Include 'SMG.Def/list'
	Include 'Handler.Def'

C Arguments
	Logical			Save_NewsRc

C External Routines

	Integer                 Delete_File     
	Integer                 LIB$Rename_File     
	Integer                 Close_Newsrc
	Integer                 Srv_Cmd
	Integer			SYS$Fao
	Integer  *4		SYS$DELPRC
	Integer			TrimLg
	Real     *4		Secnds

C Local Definitions

	Character *512          Buf
	Integer   *4            Lg
	Integer                 Status          ! Status of various commands.
	Logical                 File_Exists     ! For NEWS_PRINT
	Real      *4		Delta		! for computing
	Character *10		Total_Seconds	! length of session
	Character *512		Out_Msg		! done message

C Kill spawned subprocesses, if any

	If (SubProc_PID .NE. 0) Then
	    Call SYS$DELPRC(SubProc_PID,)
	    SubProc_PID = 0
	EndIf 

C Disconnect from server

	If (EXH_Connected) Then

	  Status = Srv_Cmd ('quit', Buf, Lg)
	  If (.not. Status) Then
	    Call SMG_All_Print 
	1	('Server failed, still trying to clean up...')
	  EndIf

	  Call SMG_All_Print (' ')
	  Call SMG_All_Print('Closing News server connection...')
C	  Call SMG_All_Print (Buf(1:Lg))	! ignore. Couldn't be that
						! interesting. vnews 1.4
	  EXH_Connected = .FALSE.		! in case we get called again

	EndIf ! EXH_Connected

	If (EXH_NewsrcRead .AND. Save_NewsRc) Then

C Update xx.newsrc

	  Call SMG_All_Print (' ')
	  Call SMG_All_Print ('Updating XX.Newsrc in '//
	1	NewsRC_Loc(:TrimLg(NewsRC_Loc))//' ...')
	  Status = Close_Newsrc ()
	  If (.not. Status) Then
	    Print '(A)', ' Error closing XX.NEWSRC'
	    Stop
	  End If

C
C Purge the XX.NEWSRC file so that we only have the current version
C JMH 8/12/88
c Rename the old XX.NEWSRC file to XX.OLDNEWSRC as safety factor.
C VNEWS 1.3-4	John McMahon
C

	  Lg = TrimLg(NewsRC_Loc)
	  Call SMG_All_Print
	1    ('Purging old XX.NEWSRC files out of '//
	2	NewsRC_Loc(:Lg)//' ...')

c do the current version first (the one we just wrote)
c and then the older copy

	  Status = LIB$Rename_File (
	1	NewsRC_Loc(:Lg)//'XX.NEWSRC',
	2	NewsRC_Loc(:Lg)//'OLD.NEWSRC')
	  Status = LIB$Rename_File (
	1	NewsRC_Loc(:Lg)//'XX.NEWSRC',
	2	NewsRC_Loc(:Lg)//'OLD.OLDNEWSRC')

c now do a purge of the rest of the files...
C vnews 1.4/jms/910326 Use new Delete_File subroutine.

	  Call Delete_File (NewsRC_Loc(:Lg)//'XX.NEWSRC')
	  Call Delete_File (NewsRC_Loc(:Lg)//'XX.OLDNEWSRC')

C Rename the current OLD.NEWSRC to XX.NEWSRC version one. JMH 8/12/88

	  Status = LIB$Rename_File (
	1	NewsRC_Loc(:Lg)//'OLD.NEWSRC',
	2	NewsRC_Loc(:Lg)//'XX.NEWSRC;1')
	  Status = LIB$Rename_File (
	1	NewsRC_Loc(:Lg)//'OLD.OLDNEWSRC',
	2	NewsRC_Loc(:Lg)//'XX.OLDNEWSRC;1')

	  EXH_NewsrcRead = .FALSE.		! in case we get called again

	EndIf ! EXH_NewsrcRead

C vnews 1.4/jms/910325. Move logical name translations to get_init.
C vnews 1.4/paf/910326. Call SMG_Final to clean up SMG stuff.
C vnews 1.4/paf/910326. Call Cancel_Handler to cancel exit handler.
C vnews 1.4/jms/910429. Remove call to SMG_Final (per SMG$ manual)
C vnews 1.4/jms/910430. Add statistics.
C
	Delta = SECNDS(Time_In)
	Write (Total_Seconds,'(F5.0)') Delta/60
	Call SMG_All_Print (' ')
	Call SMG_All_Print ('VNEWS done after ' //
	1	Total_Seconds(:TrimLg(Total_Seconds)-1)//' minutes.')
	Call SYS$FAO (
	1 'You read !UL message!%S (!UL group!%S) and composed !UL answer!%S.'
	2  , Lg, Out_Msg, 
	3  %val(Messages_Read), %val(Groups_Read), %val(Answers_Written) )
	Call SMG_All_Print (Out_Msg(:Lg))

	Call SMG_Handle_Broadcasts (.false.)

	Call Cancel_Handler

C
C Print the current SYS$SCRATCH:NEWS_PRINT.TXT file (if it exists).
C
	File_Exists = .FALSE.
	Inquire 
	1	(
	2	File = 'SYS$SCRATCH:NEWS_PRINT.TXT',
	3	Exist = File_Exists,
	4	IoStat = Status
	5	)

C
C PrintCommand is defined in SITE_SPECIFIC.DEF and GET_INIT.FOR
C
	If (File_Exists) Then
	    Lg = TrimLg (PrintCommand)
	    Call LIB$Do_Command (PrintCommand(1:Lg))
	Endif

	Call Exit

	Write (6,*) 'Something is very, very wrong.' 
	Write (6,*) 'You have just entered the Twilight Zone.'

	Return

	END
