C NNTP.FOR

	Subroutine NNTP_Get_Active_File ()

	Include 'News.Def'

C External routines

	Logical		Get_Integer	! Gets a number from a string.
	Integer		Srv_Cmd		! Send a command to the server.
	Integer		Srv_Recv	! Get me a line from server.

C Local variables


	Character *255	Buf		! Buffer for stuff from server.
	Character *10	C		! Smaller buffer.
	Integer		I		! Generic loop variable.
	Integer		Lg		! Length of the responce.
	Integer		Status		! Status of an the reads.
	Integer		X		! Walker for an array.
	Integer		Prev_X,Start_X	! Rankin optimizations
	Record /groupdef/ Gtemp		! for swapping
	Logical		Newusers_Found
	Integer		Server_Groups	! count of groups on server

C NNTP_Get_Active_File

	Buf = ' '			! Clear out the buffer.
	Server_Groups = 0		! start with no groups on server
	Newusers_Found = NewsRC_Is_Open	! not found if no newsrc file.

C+
C       Send a LIST command to the server.  We then get back a list
C       of currently active news groups.
C-
	If (.not. Srv_Cmd('list',Buf,Lg)) Then
	    Call SMG_All_Print('Your NNTP server has gone away.')
	    Stop
	EndIf

C+
C	Did we succeed in getting the list started???
C-
	If (Buf(1:3) .ne. '215') Then
	  Call SMG_All_Print (
	1	'Unexpected LIST command result, ' // Buf(1:Lg))
	  Stop
	EndIf

C+
C       Retrieve list output and update group
C	See notes at bottom! pr/910815
C-
	prev_x = 0
	Status = Srv_Recv (Buf, Lg)
	Do While (Status .and. (Buf(1:Lg) .ne. '.'))
	  I = Index (Buf(1:Lg), ' ')
	  If (I .eq. 0) Then
	    Call SMG_All_Print('In a LIST command, got a bad response.')
	    Stop
	  EndIf

	  If (I .gt. NwsGrpSz-1) Then
	    Call SMG_All_Print('Newsgroup name too long! Tell your')
	    Call SMG_All_Print('system manager to make NwsGrpSz bigger.')
	    Call SMG_All_Print('Truncating '//Buf(1:I))
	    I = NwsGrpSz-1
	    Buf(NwsGrpSz:NwsGrpSz) = ' '
	  EndIf

	  X = prev_x + 1                !check next group
	  If ( X .le. Group_Count .AND.
	1      Group(X).Name(:I) .eq. Buf(:I) )  GOTO 75
	  start_x = MAX(prev_x - 7, 0)  !check from a few before til end
	  X = start_x
	  Do While (X .lt. Group_Count)
	    X = X + 1
	    If (Group(X).Name(:I) .eq. Buf(:I))  GOTO 75
	  EndDo
	  X = 0                         !check from beginning til prior
	  Do While (X .lt. start_x)
	    X = X + 1
	    If (Group(X).Name(:I) .eq. Buf(:I))  GOTO 75
	  EndDo
	  X = Group_Count + 1           !wasn't found
75	  Continue
	  prev_x = X

	  If (X .gt. Group_Count) Then
	    If (X .gt. Mx_Group) Then
		X = X - 1
		Call SMG_All_Print('Too many newsgroups!  Dropping '
	1	// Group(X).Name)
	    EndIf
	    Group_Count = X

	    Group(X).Name = Buf(1:I)
	    Group(X).Subscribed = .true.
	    Group(X).Newsrc_File = .false. ! not found in xx.newsrc,hence new
	    Group(X).Range_First = 0
	    Group(X).Range_Last = 0
	    If (.not. newusers_found) Then
C	     if there's no newsrc, put group "news.announce.newuser" first
	      newusers_found = ( Buf(1:I) .eq. 'news.announce.newuser' )
	      If (newusers_found .and. X .gt. 1) Then
		Gtemp    = Group(1)
		Group(1) = Group(X)
		Group(X) = Gtemp
	      End If !news.announce.newuser
	    End If !no newsrc
	  End If ! If X

c
c	VNEWS 1.3-4 Kevin Oberman
c	Set the active_file flag for any entry read in from the server.
c
	  Group(X).Active_File = .true.
	  Server_Groups = Server_Groups + 1

C+++
C Now get last first and p flags
C    Changed to use new Get_Integer in VNEWS 1.4/910416/Alain Cedelle
C---
	  Status = Get_Integer (Buf, I, Group(X).Active_End)
	  Status = Get_Integer (Buf, I, Group(X).Active_Start)

	  Call GetField (C, Buf, I, Lg)
c
c	Some code was deleted from the IF-THEN.  It seemed to have little
c	correct function since .ACTIVE_FILE and .ACTIVE_POST are not mutually
c	exclusive (or triggered on the post flag)
c	VNEWS 1.3-4	Kevin Oberman
c	optimized VNEWS 1.4/pr/910325
c
	  Group(X).Active_Post = ((C .eq. 'y') .or. (C .eq. 'Y'))

	  Status = Srv_Recv (Buf, Lg)
	End Do

	Buf = ' '
	Call SYS$FAO (
	1	'Your news server currently has !UL news groups available.',
	2	Lg, Buf,
	3	%VAL(Server_Groups) )
	Call SMG_All_Print(Buf(:Lg))

	Return

	End ! of NNTP_Get_Active_File


	Subroutine NNTP_Get_New_Groups ()

	Include 'News.Def'

C External routines

	Integer		Srv_Cmd		! Send a command to the server.
	Integer		Srv_Recv	! Get me a line from server.

C Local variables

	Character *255	Buf		! Buffer for stuff from server.
	Integer		Count		! Number of groups found 
	Integer		Lg		! Length of the responce.
	Integer		Status		! Status of an the reads.

C NNTP_Get_New_Groups

	Buf = 'newgroups ' // Newsrc_CDT_News(1:13)
	If (.not. Srv_Cmd(Buf(1:23),Buf,Lg)) Then
	    Call SMG_All_Print('Server failed in NNTP_Get_New_Groups')
	    Return
	EndIf

	If (Buf(1:3) .ne. '231') Then
	  If (Buf(1:3) .eq. '503') Then
	    Call SMG_All_Print
	1	(
	1	'Note: Your NNTP server does not support the ' //
	1	'NEWGROUPS command. '
	1	)
	  Else
	    Call SMG_All_Print
	1	(
	1	' Unexpected NEWGROUPS command result, ' // Buf(1:Lg)
	1	)
	  Endif ! (If 503 error...)
	  Call Lib$Wait(3.0)
	  Return
	EndIf
          
C	Retrieve newgroups output and update group
          
	Count = 0

	Status = Srv_Recv (Buf, Lg)

	Do While (Status .and. (Buf(1:Lg) .ne. '.'))

	    If (Count .eq. 0) Then
		Call SMG_All_Print (' ')
		Call SMG_All_Print('New groups since you last ran VNEWS:')
	    EndIf

	    If (Buf(1:Lg) .ne. '.' .and. Count .LT. 10) Then
		Call SMG_All_Print (' ... ' // Buf(1:Lg))
	    EndIf

	    Status = Srv_Recv (Buf, Lg)
	    Count = Count + 1

	EndDo
          
	If (Count .eq. 0) Return		! no groups, who cares

C	If lots of groups found, tell the user

	If (Count .GT. 10) Then
	    Count = Count - 10
	    Buf = ' '
	    Call SYS$FAO (' ... and !UL others.',,Buf, %VAL(Count))
	    Call SMG_All_Print(Buf)
	EndIf

C       give user a chance to see them, and format prettily.
          
	Call SMG_All_Print (' ')
	Call SMG_Prompt (Buf, 'Type <return> to continue',Lg)
	Call SMG_All_Print (' ')

	Return

	End ! of NNTP_Get_New_Groups


	subroutine  Query_New_Groups ( )
C
C               02-NOV-1990     Pat Rankin, rankin@eql.caltech.edu
C	Code extracted from NNTP_Get_Active_File, so that the
C	subscribe query will occur *after* the list of known new
C	groups instead of before.
C
C	Installed into VNEWS 1.4/jms/910325
C
	Include 'News.Def'
	Integer         TrimLg

	Character *80   Spare_Buf       ! Buffer for keyboard input
	Integer         Spare_Lg        ! Length of keyboard responce.
	Integer         X,  Lg,  skip, i
	logical         stop_query           ! JJM - flag to stop query
	logical         stop_query_subscribe ! JJM - flag to sub/unsub

	character*72	verbosity(19) /
	1  ' Since I could not find your XX.NEWSRC file, I am assuming',
	2  ' that this is your first time running news.  Most news',
	3  ' servers have over a thousand groups, so you may not want',
	4  ' to individually subscribe to all of them.  If you want to',
	5  ' look at them all, just type y or n to each group name as',
	6  ' it gets shown.  If you want to have them all, just',
	7  ' type q/s. If you want to have none of them, type q/u.',
	8  ' I recommend that you type q/s, and then edit your',
	9  ' XX.NEWSRC file, and change the colon (:) after each name',
	1  ' (which indicates that you want to read that group) to an',
	2  ' exclamation point (!, which indicates that you do NOT',
	3  ' want to read that group, on any group which you are not',
	4  ' interested in reading.',
	5  ' Or, you could do it the other way: type q/u, and then',
	6  ' change !s to :s for the groups you do want to read.',
	7  ' Warning!  When you type q/u or q/s, you will get a',
	8  ' very long list of groups.  Nothing wrong here, just',
	9  ' the normal business of the day.',  ' OK! Here we go...' /


	skip = 0
C If user had no XX.Newsrc file, assume he is subscribed to all groups;
C   don't want to prompt him 1000 times, and he won't know about q/s, q/u.
c	stop_query = .not. Newsrc_Is_Open
c	stop_query_subscribe = .not. Newsrc_Is_Open

	stop_query = .false.
	stop_query_subscribe = .false.
	If (.not. Newsrc_Is_Open) Then
	  Do i = 1, 19
	    Lg = TrimLg(verbosity(i))
	    Call SMG_All_Print( verbosity(i)(:Lg))
	  End Do
	  Call SMG_All_Print(' ')
	EndIf

!
! Experimental notification for new groups...          JJM 10-FEB-1990
!
	do X = 1, Group_Count
	   Lg = TrimLg(Group(X).Name)
	   If (Group(X).Newsrc_File) Then
C            don't do anything
	   Else If (Stop_Query) Then
	     Group(X).Subscribed = stop_query_subscribe
	   Else
	     Spare_buf = '.' ! Space is used in the do statement below.
	     Do While ( Spare_buf(1:1) .Eq. '.' )

	      Call SMG_Prompt(
	1	Spare_buf,'New group ' // Group(X).Name(:Lg) //
	1	' subscribe [ynh?q] ',Spare_Lg)
	      If (Spare_Lg .gt. 0) 
	1		call Down_Case(Spare_buf(1:Spare_Lg))

	      if (spare_buf(1:1) .eq. 'y') then
		 Group(X).Subscribed = .true.
	      else if (spare_buf(1:1) .eq. ' '
	1	  .or. spare_buf(1:1) .eq. 'n') then
		 Group(X).Subscribed = .false.
	      else if (spare_buf(1:1) .eq. '?'
	1	  .or. spare_buf(1:1) .eq. 'h') Then
		 Call Query_New_Groups_Help
	      else if (spare_buf(1:1) .eq. 'q') then
		 if (spare_buf(2:3) .eq. '/s') then 
		    Group(X).Subscribed = .true.
		    stop_query = .true.
		    stop_query_subscribe = .true.
		 else if (spare_buf(2:3) .eq. '/u') then
		    Group(X).Subscribed = .false.
		    stop_query = .true.
		    stop_query_subscribe = .false.
		 else
c
c	A user complained that a 'q' command with no switch did not
c	function properly.  I added the following warning for users
c	who choose to type 'q' with no switch.
c	John McMahon - 14-MAR-1990 17:52:56.14 VNEWS Version 1.3-3
c
		    Call SMG_All_Print
	1	('Command unrecognized. Use q/s or q/u.')
		    Call Query_New_Groups_Help
		    Spare_buf = '.'     !repeat prompt
		 endif ! if spare_buf .eq. q
	      else !wasn't 'y','n','?',or 'q'
		 Call SMG_All_Print('Subscribe? ''y'' or ''n''.')
		 Spare_buf = '.'        !repeat prompt
	      endif !recognized command?

	     EndDO ! Input query test
	   EndIF ! Stop_Query

	   If (Group(X).Newsrc_File) Then
	     skip = skip + 1
	   Else If (Group(X).Subscribed) Then
	     Call Smg_All_Print(Group(X).Name(:Lg)//' subscribed.')
	   Else
	     Call Smg_All_Print(Group(X).Name(:Lg)//' not subscribed.')
	   EndIF
	End Do !Group loop

	if ( skip .lt. Group_Count ) then
	     Call Smg_All_Print(' ')
	     Call LIB$WAIT( 3.0 )        !pause
	end if

	return

	end !of Query_New_Groups

	subroutine query_new_groups_help
	
	Implicit None

	Integer Lg, I, TrimLg

	Character*72	help_text(6) /
	1 ' y         - subscribe to this group',
	2 ' n or <cr> - do not subscribe to this group',
	3 ' h or ?    - this help',
	4 ' q/s       - stop query, and subscribe to remaining groups ',
	5 ' q/u       - stop query, and do not subscribe to ',
	6 '             remaining groups ' /

	Do I = 1, 6
	    Lg = TrimLg(help_text(i))
	    Call SMG_All_Print( help_text(i)(:Lg))
	End Do
	Call SMG_All_Print(' ')

	Return
	End

C an amusing note for those of you attempting to optimize VNEWS.
c I took a DO WHILE loop with the internal increment and changed it
c to a DO I= loop.  Indeed, the number of instructions required to
c manage the loop dropped from 3 to 1.  However, it turns out that
c the timing on the DO I= instruction is the same as the three short
c instructions which it replaced.  In any case, the salient time
c was the character comparison, which was 14 times longer than the
c loop management code...  
c So, be warned. jms/910722

C another note:  the multiple loops and goto 75's are optimizations
c to the original brute force search method.  pr/810815
