C OPEN_NEWSRC.FOR

	Integer Function Open_Newsrc ()

	Include 'News.Def'

C External routines

	Integer		Range_Allocate
	Integer		TrimLg
	Integer 	User_Open
	External	User_Open

C Local Definitions

	Character  *1		C
	Integer    *4		Status
	Integer			ImageLg
	Character  *(MAX_NEWSRC_LINE) Image
	Integer    *4		R
	Integer    *4		S, L, N, E, X
	Integer    *4		Subscribed

C Begin Open_Newsrc

	Call User_Open_Init ('STATUS_OLD')

	Open
	1 (
	2 Unit		= LU_Newsrc,
	3 File		= NewsRC_Loc(:TrimLg(NewsRC_Loc))//'XX.Newsrc',
	4 Status	= 'Old',
	5 Form		= 'Formatted',
	6 UserOpen 	= User_Open,
	7 Recl		= MAX_NEWSRC_LINE,
	8 IOStat	= Status
	9 )

	Subscribed = 0
	Group_Count = 0

	If (Status .ne. 0) Then
	  Newsrc_Is_Open = .false.
	  Open_Newsrc = 0
	  Return
	EndIf

	Newsrc_Is_Open = .true.

C Get date of creation of XX.Newsrc

	Call User_Open_Get_CDT (LU_Newsrc, Newsrc_CDT_VMS)
	Newsrc_CDT_News(1:2) = Newsrc_CDT_VMS(10:11)	! Year
	X = Index
	1    (
	2     'JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC',
	3     Newsrc_CDT_VMS(4:6)
	4    )
	Write (Newsrc_CDT_News(3:4), '(I2.2)') X/3 + 1	! Month
	Newsrc_CDT_News( 5: 6) = Newsrc_CDT_VMS(1:2)	! Day
	If (Newsrc_CDT_News(5:5) .eq. ' ') Then
	  Newsrc_CDT_News(5:5) = '0'
	EndIf
	Newsrc_CDT_News( 7: 7) = ' '
	Newsrc_CDT_News( 8: 9) = Newsrc_CDT_VMS(13:14)	! Hour
	If (Newsrc_CDT_News(8:8) .eq. ' ') Then
	  Newsrc_CDT_News(8:8) = '0'
	EndIf
	Newsrc_CDT_News(10:11) = Newsrc_CDT_VMS(16:17)	! Minute
	If (Newsrc_CDT_News(10:10) .eq. ' ') Then
	  Newsrc_CDT_News(10:10) = '0'
	EndIf
	Newsrc_CDT_News(12:13) = Newsrc_CDT_VMS(19:20)	! Second
	If (Newsrc_CDT_News(12:12) .eq. ' ') Then
	  Newsrc_CDT_News(12:12) = '0'
	EndIf

C Now read users XX.Newsrc

	Status = 1
	Do While (Status)
	  Read
	1	(
	2	Unit	= LU_Newsrc,
	3	Fmt	= '(Q,A)',
	4	IOStat	= Status
	5	)
	6	ImageLg, Image
	  If (Status .lt. 0) Then
	    Open_Newsrc = 1
	    Status = 0
	  Else If (Status .ne. 0) Then
	    Close (LU_Newsrc)
	    Open_Newsrc = 0
	    Status = 0
	  Else
	    Status = 1
	    X = Index (Image, ':')		! subscribed
	    If (X .eq. 0) Then
	      X = Index (Image, '!')		! not subscribed
	    EndIf
	    If (X .ne. 0) Then

C We have a new group
C Check to make sure that we aren't blowing up the common block
C by comparing X and Group_Count against applicable maximums.
C mcmahon,jms/910430/vnews 1.4

	      If (Group_Count .GT. Mx_Group) Then
		Call SMG_All_Print (
	1	'Too many groups in your .newsrc file.  Tell your')
		Call SMG_All_Print (
	1	'system manager to make MX_GROUP bigger.')
		Call SMG_All_Print ('VNEWS overwhelmed.')
		Stop 
	      EndIf ! (Group_Count .GT. MX_GROUP)
	      If (X .GE. NwsGrpSz) Then
		Call SMG_All_Print (
	1	'Group name '//image(1:x-1)//' is too long for VNEWS.')
		Call SMG_All_Print (
	1	'Ask your system manager to make NwsGrpSz larger.')
		Call SMG_All_Print (
	1	'VNEWS suffers from static allocation again.')
		Stop 
	      EndIf ! (X GE. NwsGrpSz)
	      Group_Count = Group_Count + 1
	      Group(Group_Count).Range_First = 0
	      Group(Group_Count).Range_Last  = 0
	      Group(Group_Count).Newsrc_File = .true.

C Record group's name

	      Group(Group_Count).Name = Image (1:X-1)

C Get subscribed information

	      If (Image(X:X) .eq. ':') Then
		Subscribed = Subscribed + 1
		Group(Group_Count).Subscribed = .true.
	      Else
		Group(Group_Count).Subscribed = .false.
	      EndIf

C Clear moderated and activefile flags, they will get set properly
C when we page through the news groups later.

	      Group(Group_Count).Active_Post = .false.
	      Group(Group_Count).Active_File = .false.
	
C Get article ranges

	      S = 0
	      N = 0
	      E = 0
	      L = 0

C change from ImageLg+1 to ImageLg (vnews 1.4, pr/910325)

	      Do While (X .le. ImageLg)

		X = X + 1

C check for blanks and ignore. jms/910620

		If (X .lt. ImageLg .AND. 
	1	    Image(X:X) .eq. ' ') X = X + 1


		If (X .eq. ImageLg+1) Then
		  C = ','
		Else
		  C = Image (X:X)
		EndIf

		If ((C .ge. '0') .and. (C .le. '9')) Then
		  N = 10 * N + IChar(C) - IChar('0')
		Else If (C .eq. '-') Then
		  S = N
		  N = 0
		Else If (C .eq. ',') Then
		  E = N
		  If (S .eq. 0) Then
		    S = E
		  EndIf

C Now add a new range entry to this group's control structure

		  If (S .ne. 0) Then
		    If ((S .le. L) .or. (S .gt. E)) Then
			Call SMG_All_Print
	1		(
	2		'Error in XX.Newsrc entry for group ' //
	3		Group(Group_Count).Name
	4		(1:TrimLg(Group(Group_Count).Name))
	5		)
			S = 0
			E = 0
			N = 0
			GoTo 500
		    Else
		      R = Range_Allocate ()
		      Range(R).Next  = 0
		      Range(R).Start = S
		      Range(R).End   = E

		      If (Group(Group_Count).Range_First .eq. 0) Then
			Group(Group_Count).Range_First = R
		      Else
			Range(Group(Group_Count).Range_Last).Next=R
		      EndIf
		      Group(Group_Count).Range_Last = R
		      L = E
		    EndIf
		  EndIf

C Get ready for next range

		  S = 0
		  E = 0
		  N = 0

		Else
		  Call SMG_All_Print
	1		(
	2		'Error in XX.Newsrc entry for group ' //
	3		Group(Group_Count).Name
	4		(1:TrimLg(Group(Group_Count).Name))
	5		)
		  S = 0
		  E = 0
		  N = 0

		EndIf
500		Continue
	      EndDo
	    EndIf
	  EndIf
	End Do

	Call SYS$FAO (
	1	'You are subscribed to !UL news groups.',,
	2	Image,
	3	%VAL(Subscribed) )
	Call SMG_All_Print(Image(1:TrimLg(Image)))


	END ! of open_newsrc.for
