c/*$The phase of the moon, for your safety and convenience.
c**
c**  Stolen from ArchMach & converted from PL/I by Brian Hess.
c**  Extensively cleaned up by Rich $alz.
c**
c**  If you can figure out how this program works, then YOU deserve
c**  to be working on it, sucker!  Here's a hint:  The epoch is 13:23,
c**  10/1/78.
c*/
c
c vnews 1.4/jms/910805

c  Rao Akella <rao@moose.cccs.umn.edu>/920322:
c    Threw the old Calculate() function code away and replaced it with an
c    astronomer-strength algorithm that is very accurate (calculates the
c    phase of the moon to within a few minutes).
c    Added (badly-needed) comments to document what's going on.
c    Included explanation of the old algorithm (the one which I threw away) and
c    what was wrong with it.
c  This file includes the following 4 (four) routines used for
c  moon phase calculations from MOON.FOR (original name).
c      NextQuarter
c      Phase
c      Mod2Pi
c      WRAP
c  These functions were taken from "moon -- another phase-of-the-moon program"
c  which was posted on the comp.sources.misc archive (particulars follow):
c      Date: 20 Aug 89 00:53:40 GMT
c      Posting-number: Volume 8, Issue 11 (v08i011)
c      Submitted-by: ajs@hpfcajs.hp.com (Alan Silverstein)
c      Archive-name: moon
c  If you're interested in obtaining the original moon archive, you may find
c  it on the anonymous ftp archive site wuarchive.wustl.edu [128.252.135.4]
c  in the usenet/comp.sources.misc/volume08 subdirectory (the file to get is
c  moon.Z).
c  
c  Translated from C to FORTRAN for use in VAX/VMS VNEWS by:
c      Rao Akella <rao@moose.cccs.umn.edu> on 22-MAR-1992.
c  

c	I have taken Rao's work and combined it into a single source
c	file, for ease of maintenance.  If all you want is the phase
c	of the moon stuff (and not the VNEWS part), then you should 
c	go to routine "NextQuarter" and take everything below that as
c	the original "moon" code.  You can also go into PHOON.DEF and
c	see where I have concatenated the original PHOON.DEF and Rao's
c	MOON.DEF.
c	jms/921026


	Subroutine Phoon(Phrase)

	Implicit None

	Include 'Phoon.Def'

	Character Blank		! Useful for blanking out character strings
	Parameter (Blank = ' ')

	Integer MoonPhase, Calculate, SYS$FAO, TrimLg
	Character*(*) Phrase

c  Determine the next quarter as an integer in the range 1 (=New Moon) to
c  4 (=Last Quarter).
	MoonPhase = Calculate()

c  Day, Hour and Minute are computed by Calculate() as the time UNTIL the NEXT
c  quarter of the moon.  The previous algorithm used to return the time SINCE
c  the PREVIOUS quarter, but because this new algorithm only looks forward,
c  the first part of the following IF...THEN block is never going to be
c  executed any more.
c  And oh, By The Way, Calculate() does NOT take timezones into consideration.
c  It assumes the current time is Universal Time (U.T.), which is what
c  astronomers keep time in.  U.T. is basically the time for the meridian of
c  Greenwich, with 0h occurring at midnight (the name "Greenwich Mean Time,"
c  GMT, is no longer commonly used, since it is ambiguous whether it began at
c  noon or midnight.)
c  Besides, I tried looking at converting U.T. to the local time, and found
c  that this loose string has an elephant attached to the other end. :-(
c  Since VAX/VMS has no concept of GMT, and, by convention, the hardware clock
c  is usually set to the local time, there's no sure-fire 100% accurate
c  method which is guarateed to determine the offset from GMT all the time
c  (even if you knew the name of the local timezone).
c  To get a flavor of the complexities involved, try ruminating on this:
c  Canada has the same timezone names as the US (with the same offsets too),
c  but its Daylight Savings Time rules are different.  To top it off, Australia
c  _also_ has the same timezone names, which have different offsets from GMT as
c  well.  Aaaaaarrrrrrgggggghhhhhh!  Besides, you'll never be able to document
c  every single timezone in the world, so why even bother?  Sniff!

	Phrase = Blank		! else tail of string may contain garbage.

	If (Day .eq. 0 .AND. Hour .eq. 0 .AND. Minute .eq. 0) Then
	    Phrase = 'Exactly the ' //
	1     Moon(MoonPhase)(:TrimLg(Moon(MoonPhase))) // ' (U.T.)'
	Else
	    Call SYS$FAO(
	1     '!UL day!%S, !UL hr!%S, !UL min!%S until the !AS (U.T.)',,
	2     Phrase,
	3     %VAL(Day), %VAL(Hour), %VAL(Minute),
	4     Moon(MoonPhase)(:TrimLg(Moon(MoonPhase))) )

	EndIf

	Return

	End


	Integer Function Calculate()

c  This function determines:
c    (a) What the current time is,
c    (b) What the current phase is, and
c    (c) What, When and How far way the next quarter is.

c  Credits:
c    The heart of this routine is the functions Phase() and NextQuarter(),
c    which were taken from the Unix program:
c        "moon -- another phase-of-the-moon program"
c    originally written by Alan Silverstein <ajs@hpfcajs.hp.com>
c
c    These routines are astronomer-strength functions for computing the phase
c    of the moon, and they're VERY accurate (to within a few minutes).  Over
c    the last week, I've had occasion to check out half a dozen different
c    algorithms to calculate the times of various quarters of the moon, and
c    most of them are usually off by a few days, or, at best, a few hours. 
c    This is the most accurate one I've found to date (it uses the same basic
c    function Phase() used by a lot of other programs as well, but it achieves
c    its accuracy by a simple process of iteration).
c    If you can find an even better algorithm (one is sure to come along before
c    long), you're welcome to beef up this program (if you have the patience!)
c
c    Look in the file MOON.FOR for further details of attribution.

c  Some Background Theory:
c  ~~~~~~~~~~~~~~~~~~~~~~
c    From "Stars and Planets" by Donald H. Menzel and Jay M. Pasachoff
c        (Peterson Field Guides), Chapter 8, "The Moon":
c
c    "The moon orbits the earth every 27-1/3 days with respect to the stars.
c    But during that time, the earth and the moon have moved as a system about
c    1/12 of the way in their yearly orbit around the sun.  So if the moon at
c    a certain point in its orbit is directly between the earth and the sun,
c    27-1/3 days later it has not quite returned to that point directly between
c    the earth and the sun.  The moon must orbit the earth a bit further to get
c    back to the same place with respect to the line between the earth and the
c    sun.  The moon reaches this point in a couple of days, making the
c    SYNODIC PERIOD of the moon equal to 29-1/2 days.  (The synodic period is
c    the interval between two successive conjunctions -- coming to the same
c    celestial longitude -- of two celestial bodies, in this case conjunctions
c    of the moon and the sun as observed from the earth.)  It is the synodic
c    months that are taken into account in lunar calendars.
c
c    The phases of the moon repeat with this 29-1/2 day period, since the
c    phases simply depend on the angle between the earth, sun, and moon. 
c    One-half of the moon is always illuminated by the sun.  To us on earth,
c    the moon appears to go through phases because in the course of the month
c    we see different fractions of its lighted half.  When the sun and moon are
c    on opposite sides of the earth, the moon is FULL.  Everyone on earth who
c    can see the moon above the horizon sees the same phase of the moon at the
c    same time.
c
c    When the sun and moon are on the same side of the earth, we are looking
c    past the moon at the sun.  The far side of the moon is illuminated by the
c    sun, but the side that faces us receives no sunlight.  We say the moon is
c    NEW.
c
c    Since the angle between the earth, the moon, and the sun determines which
c    phase will appear, the moon rises at a specific time of night, depending
c    on the phase it is in.  By its nature, a full moon must rise when the sun
c    sets.  A new moon must rise when the sun rises and must set when the sun
c    sets."
c
c  The Old Algorithm (And How It Worked):
c  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
c    The old algorithm was quite simplistic and crude, besides being fairly
c    inaccurate.  It simply took a known epoch date (in this case 13:23 10/1/78)
c    and computed the time elapsed (in minutes) since that date.  It then
c    chopped up this time period into synodic months, and the modulus remainder
c    was the time (in minutes) since the last new moon.  It then assumed that
c    each quarter is exactly one-fourth of the synodic month, and used this
c    assumption to figure out the last quarter of the moon, and the number of
c    Days, Hours and Minutes elapsed since then.
c    Basically, this procedure is sound, if not very accurate (it's guaranteed
c    to be off by a few hours, sometimes by as much as half a day, or -- horror
c    of horrors -- even a full day).
c
c  What Was Wrong With The Old Code:
c    (a) It assumed the epoch time (13:23 10/1/78) to be the local time,
c        whereas it was probably GMT.  The times computed, therefore, did not
c        account for local timezone offsets.
c    (b) It didn't calculate the number of days elapsed since 10/1/78 properly.
c        It assumed that each and every year had exactly 365 days, thereby
c        ignoring the effect of leap years completely (shudder! :-)
c    (c) The algorithm was coded incorrectly.
c    (d) It assumed every quarter is exactly one-fourth of a synodic month,
c        which is definitely not true.

	Implicit None

	Include 'Phoon.Def'

c Variables

	integer currtime, attime, Delta, Delta2
	real*8  phasep, wantphase

c The following two variables would be needed to convert the system time (in
c seconds) into years/months/days/hours/minutes/seconds.
c See PHOON.DEF for an explanation of what fields are included
c in the tm structure, and what values you may expect to find in them.
c****	integer status
c****	record /tm_struct/ tm

c Functions

	integer NextQuarter     ! computes the time at which a specified
	                        ! phase/quarter of the moon will occur.

	real*8  Phase           ! computes the phase of the moon at a given
	                        ! system time.

	external c$time
	integer c$time

c  Determine the current time as the number of seconds elapsed since 00:00:00,
c  January 1, 1970.  In this respect, the c$time() function works exactly like
c  the C function time().
	currtime  = c$time(%VAL(0))

c  There's no need in this function to convert the time returned above into
c  the current Year, Month, Day, Hour, Minute and Second.  But if you did need
c  to do so, the following two lines (which have been commented out) will do
c  what you want.  See PHOON.DEF for an explanation of what fields are included
c  in the tm structure, and what values you may expect to find in them.
c  In this respect, the localtim() and bcopy() functions work exactly as they
c  do in C.
c****	status = localtime(currtime)
c****	call bcopy( %VAL(status), tm, %VAL(36))

	attime    = currtime

c  Calculate the current phase of the moon as a fraction 0.0 <= phasep < 1.0,
c  where 0.0 is the New Moon, 0.25 is the First Quarter, 0.5 is the Full Moon
c  and 0.75 is the last quarter.  The function Phase() does not change attime.
	phasep    = Phase (attime)

c  Initialize Fraction anyway, because it's present in the "PHOON" COMMON block,
c  but I don't know why because it's not used ANYWHERE.
	Fraction  = phasep

c  Set wantphase to a magic number P_NEXT (which is defined in MOON.DEF to be
c  3.0), which signals the NextQuarter() function that we desire the time of
c  the next quarter.
	wantphase = P_NEXT

c  The NextQuarter() function takes the current time (attime), the current moon
c  phase (phasep) and the desired quarter (wantphase), and finds and returns
c  the time of the next specified quarter to the nearest second.  It also
c  changes the current phase (phasep) to match the phase of that event, and
c  sets "wantphase" to the quarter returned, in the form of a fraction:
c      0.0 <= wantphase < 1.0
	attime    = NextQuarter (attime, phasep, wantphase)

c  The rest of the function is pretty simple.  We have the current time in
c  currtime, and the time of the next quarter in attime (both in seconds).
c  All we have to do is break this difference down into Days, Hours and Minutes.
	Delta     = attime - currtime               ! /* difference, in seconds */
	Delta2    = Delta  + (SECperMIN / 2)        ! /* round up */
	Day       = Delta2 / SECperDAY              ! /* truncates */
	Delta2    = Delta2 - Day * SECperDAY
	Hour      = Delta2 / SECperHOUR             ! /* truncates */
	Delta2    = Delta2 - Hour * SECperHOUR
	Minute    = Delta2 / SECperMIN              ! /* truncates */

c  Return the phase of the moon at the time "attime" as an integer in the range
c  1 (= New Moon) to 4 (= Last Quarter).
	Calculate = Int (wantphase * 100) / 25 + 1
	Return
	End

c /************************************************************************
c  * N E X T   Q U A R T E R
c  *
c  * Given a system clock time in seconds, a pointer to the moon phase at that
c  * time (P_NEW..P_NEXTNEW), and a pointer to the wanted phase value (quarter
c  * moon, which can be a special value P_NONE, P_NEXT, or P_ANY to mean any
c  * quarter is acceptable), find and return the time of the next specified
c  * quarter to the nearest second, and change the current phase to match the
c  * phase of that event.  If *wantphasep is P_NEXT, set it to the next specific
c  * value.
c  *
c  * Note:  If *wantphasep is not a special value, it can actually be any legal
c  * value, not just quarter values.
c  *
c  * For lack of better understanding of the math involved in determining when
c  * the quarter occurs, call Phase() repeatedly to approximation search to the
c  * time which is closest to the event.  Always return the first time after the
c  * initial time whose phase value is at or after the desired phase value.
c  * Assume successive times produce monotonically increasing Phase() values
c  * (except for rolling past P_NEXTNEW back to P_NEW).
c  *
c  * The approximation method is similar but not identical to Newtonian.  It does
c  * not know or use the actual slope at each point in the time-phase curve, but
c  * revises the slope based on each approximation.  This doesn't make a huge
c  * difference, since the moon's orbit isn't very eccentric, but tests show it
c  * saves about two calls to Phase() each time.
c  */

      Integer Function NextQuarter (orig_attime, phasep, wantphasep)

      Implicit None

      integer orig_attime
      real*8  phasep
      real*8  wantphasep

      Include 'Phoon.Def'

      integer attime

      real*8  prevphase       ! /* previous approximation	*/
      real*8  wantphase
      real*8  wrapphase       ! /* "wrapped" value, see below	*/
      integer deltatime       ! /* between two approximations	*/
      real*8  invslope        ! /* inverse of slope of curve	*/

      real*8  Phase, WRAP     ! functions

      attime      = orig_attime
      wantphase   = wantphasep

c /*
c  * IF ANY QUARTER IS ACCEPTABLE, SET NEXT PHASE TO FIND:
c  */

      if (  (wantphase .eq. P_NONE)
     & .or. (wantphase .eq. P_NEXT)
     & .or. (wantphase .eq. P_ANY )) then
          if (phasep .lt. P_FIRST) then
              wantphase = P_FIRST
          else if (phasep .lt. P_FULL) then
              wantphase = P_FULL
          else if (phasep .lt. P_LAST) then
              wantphase = P_LAST
          else
              wantphase = P_NEW   ! /* wrap around */
          end if

          if (wantphasep .eq. P_NEXT) wantphasep = wantphase  ! /* change caller's value */
      end if

c /*
c  * COMPUTE FIRST APPROXIMATE TIME OF WANTED PHASE:
c  *
c  * The initial approximate time may be as much as one cycle ahead, in the case
c  * where wantphase == phasep now.
c  *
c  * Take care to "wrap" phase values around P_NEW.  If a phase value is late in
c  * the cycle and the goal is P_NEW, use a value less than P_NEW.
c  */

      if (wantphase .le. phasep) then
          attime = attime + SECperMON * (wantphase - phasep + P_MONTH)
      else
          attime = attime + SECperMON * (wantphase - phasep)
      end if

      phasep      = Phase (attime)
      wrapphase   = WRAP (phasep, wantphase)
      invslope    = SECperMON / P_MONTH   ! /* initially over a whole month */

c /*
c  * SEARCH FOR TIME OF NEXT EVENT:
c  */

      Do While (.TRUE.)           ! /* until break */
          deltatime = invslope * (wantphase - wrapphase)  ! /* truncates */

c #ifdef DEBUG
c         print*, 'wantphase: ', wantphase
c         print*, 'attime:    ', attime
c         print*, 'wrapphase: ', wrapphase
c         print*, 'deltatime: ', deltatime
c         print*, 'invslope:  ', invslope
c #endif
          if (deltatime .eq. 0) go to 100 ! /* as close as we can get */

          prevphase = wrapphase
          attime    = attime + deltatime  ! /* positive or negative */
          phasep    = Phase (attime)
          wrapphase = WRAP (phasep, wantphase)
          invslope  = deltatime / (wrapphase - prevphase)
      End Do

100   Continue

c /*
c  * DECREMENT/INCREMENT TO EXACT TIME:
c  *
c  * For repeatability, find the first time on which phasep >= wantphase.  The
c  * following code is overkill in all but the rarest cases.  Usually the attime
c  * already found is exactly right or just one second too low.
c  */

      Do While (wrapphase .gt. wantphase)
          attime = attime - 1
          phasep    = Phase (attime)
          wrapphase = WRAP (phasep, wantphase)
c #ifdef DEBUG
c         print*, '(down)'
c         print*, 'wantphase: ', wantphase
c         print*, 'attime:    ', attime
c         print*, 'wrapphase: ', wrapphase
c #endif
      End Do

      Do While (wrapphase .lt. wantphase)
          attime = attime + 1
          phasep    = Phase (attime)
          wrapphase = WRAP (phasep, wantphase)
c #ifdef DEBUG
c         print*, '(up)'
c         print*, 'wantphase: ', wantphase
c         print*, 'attime:    ', attime
c         print*, 'wrapphase: ', wrapphase
c #endif
      End Do

c /*
c  * RETURN:
c  */

      NextQuarter = attime

      End ! /* NextQuarter */



c /************************************************************************
c  * P H A S E
c  *
c  * Given a system clock time in seconds, compute and return the phase of the
c  * moon at that time, P_NEW (inclusive) .. P_FULL .. P_NEXTNEW (exclusive).
c  *
c  * Section numbers in comments refer to "Practical Astronomy with Your
c  * Calculator".  Unfortunately, an earlier version of this program provided no
c  * explanation of the calculations or variable names.  The descriptions of
c  * variable names are guesses.
c  *
c  * It appears this code figures the geocentric longitudes of the sun and moon
c  * at the given time, using their actual geocentric orbits (ellipses).  Simple
c  * geometry shows that the difference in their longitudes is also the portion
c  * of the moon which is lit as seen from earth, assuming the sun's rays are
c  * parallel at both earth and moon, which is very nearly true since the moon's
c  * orbital radius is only about 0.2% of the earth's.
c  *
c  * This code seems to assume the orbits are coplanar, which might introduce
c  * some small error since they're not.  (The difference is about 18 degrees.)
c  *
c  * Some numbers expressed as manifest constants should be parameterized, but
c  * I'm not sure what they mean.  Some of their accuracy is overstated.  They
c  * used to be in degrees, to only 2-4 digits, but I converted them to radians
c  * without rounding.
c  */

      Real*8 Function Phase (attime)

      Implicit None

      integer attime

      Include 'Phoon.Def'

      real*8 Mod2Pi

      integer EPOCH
      parameter (EPOCH = 473299200)   ! /* 19841231.0 GMT in UNIX system time */

c /* All the longitudes are values in radians at EPOCH: */

      real*8 EPSILONg, RHOg, e, lzero, Pzero, Nzero, lPerDay
      parameter (EPSILONg = 4.88013905)   ! /* solar ecliptic longitude */
      parameter (RHOg     = 4.9337037632) ! /* solar ecliptic longitude of perigee */
      parameter (e        = 0.01671542)   ! /* solar orbit eccentricity */
      parameter (lzero    = 0.3185558719) ! /* lunar mean longitude */
      parameter (Pzero    = 3.3670470432) ! /* lunar mean longitude of perigee */
      parameter (Nzero    = 0.963504179)  ! /* lunar mean longitude of node */
      parameter (lPerDay  = 0.2299715042) ! /* lunar longitude change per day */

      real*8 days         ! /* since EPOCH */
      real*8 N            ! /* radians of Earth orbit since EPOCH	*/
      real*8 Msol         ! /* sun position in orbit versus perigee */
      real*8 sinMsol      ! /* sin (Msol) */
      real*8 Ec           ! /* eccentricity correction */
      real*8 LambdaSol    ! /* ecliptic longitude of sun */
      real*8 l            ! /* lunar mean longitude */
      real*8 Mm           ! /* moon position in orbit vs. perigee	*/
c     real*8 Nm           ! /* (not used)				*/
      real*8 Ev           ! /* based on angle between sun and moon? */
      real*8 Ac           ! /* correction factor? */
      real*8 A3           ! /* correction factor? */
      real*8 Mmprime      ! /* corrected Mm */
      real*8 A4           ! /* correction factor? */
      real*8 lprime       ! /* corrected lunar longitude */
      real*8 V            ! /* correction factor? */
      real*8 ldprime      ! /* recorrected lunar longitude */
      real*8 D            ! /* sun - moon - Earth angle */

c /*
c  * CALCULATE SOLAR LONGITUDE:
c  */

	days        = Dble (attime - EPOCH) / SECperDAY

      N           = TWOPI * days / DAYSperYEAR                    ! /* sec 42 #3  */
      Msol        = EPSILONg - RHOg + N                           ! /* sec 42 #4  */
      sinMsol	    = sin (Msol)
      Ec          = 2 * e * sinMsol                               ! /* sec 42 #5  */
      LambdaSol   = Mod2Pi (EPSILONg + N + Ec)                    ! /* sec 42 #6  */

c /*
c  * CALCULATE LUNAR LONGITUDE:
c  */

      l           = Mod2Pi (lzero + (lPerDay * days))             ! /* sec 61 #4  */
      Mm          = Mod2Pi (l - Pzero - (0.0019443683 * days))    ! /* sec 61 #5  */
c     Nm          = Mod2Pi (Nzero - (0.0009242199 * days))        ! /* sec 61 #6  */

      Ev          = 0.0222337493 * sin (2 * (l - LambdaSol) - Mm) ! /* sec 61 #7  */
      Ac          = 0.0032428218 * sinMsol                        ! /* sec 61 #8  */
      A3          = 0.0064577182 * sinMsol
      Mmprime     = Mm + Ev - Ac - A3                             ! /* sec 61 #9  */

      Ec          = 0.1097567753 * sin (Mmprime)                  ! /* sec 61 #10 */
      A4          = 0.0037350046 * sin (2 * Mmprime)              ! /* sec 61 #11 */
      lprime      = l + Ev + Ec - Ac + A4                         ! /* sec 61 #12 */
      V           = 0.0114895025 * sin (2 * (lprime - LambdaSol)) ! /* sec 61 #13 */

      ldprime     = lprime + V                                    ! /* sec 61 #14 */

c /*
c  * CALCULATE AND RETURN PHASE:
c  *
c  * The difference angle is lunar - solar longitude because longitudes increase
c  * counter clockwise.  (I wish I could include a simple drawing.)
c  */

      D           = ldprime - LambdaSol                           ! /* sec 63 #2 */

      Phase       = Mod2Pi (D) / TWOPI

      End ! /* Phase */



c /************************************************************************
c  * M O D   2   P I
c  *
c  * Given an angle, adjust it to be in the range 0 <= angle < TWOPI.
c  */

      Real*8 Function Mod2Pi (orig_angle)

      Implicit None

      real*8 orig_angle

      Include 'Phoon.Def'

      real*8 angle

      angle = orig_angle

      if ((angle .lt. 0.0) .or. (angle .ge. TWOPI)) then
          angle = Mod (angle, TWOPI)
          if (angle .lt. 0) angle = angle + TWOPI
      end if

      Mod2Pi = angle

      End ! /* Mod2Pi */



c /************************************************************************
c  * W R A P
c  *
c  * This function is called by function NextQuarter.
c  *
c  * It was originally implemented as a macro in C, but since FORTRAN has
c  * no equivalent, it had to be converted to a function.
c  */

      Real*8 Function WRAP(phasep, wantphase)

      Implicit None

      real*8 phasep, wantphase

      Include 'Phoon.Def'

      if ((wantphase .eq. P_NEW) .and. (phasep .gt. P_LAST)) then
          WRAP = phasep - P_MONTH
      else
          WRAP = phasep
      end if

      End ! /* WRAP */
