	Integer Function Range_Allocate

	Include 'News.Def'

C Begin Range_Allocate

	If (Range_Free_List .ne. 0) Then
	  Range_Allocate = Range_Free_List
	  Range_Free_List = Range(Range_Free_List).Next
	Else
	  If (Range_Count .lt. Mx_Range) Then
	    Range_Count = Range_Count + 1
	    Range_Allocate = Range_Count
	  Else
	    Call SMG_All_Print ('Range array exceeded')
	    Stop
	  EndIf
	EndIf

	Range(Range_Allocate).Next  = 0
	Range(Range_Allocate).Start = 0
	Range(Range_Allocate).End   = 0

	Return

	End ! of Range_Allocate

	Subroutine Range_Combine (P, R)

	Include 'News.Def'

C Parameter definitions

	Integer   *4		P
	Integer   *4		R

C Begin Range_Combine

	If ((P .ne. 0) .and. (R .ne. 0)) Then

C Are range entries ajacent?

	  If ((Range(P).End + 1) .eq. Range(R).Start) Then

C Mark entry P with entire range

	    Range(P).End  = Range(R).End

C Remove entry R from the chain

	    Range(P).Next = Range(R).Next

C Release entry R

	    Range(R).Next = 0
	    Call Range_Deallocate (R)

	  EndIf
	EndIf

	End ! of Range_Combine


	Subroutine Range_Deallocate (R)

	Include 'News.Def'

C Parameter definitions

	Integer   *4	R	! Range index

C Local definitions

	Integer   *4 	N, X

C Begin Range_Deallocate

	X = R
	Do While (X .ne. 0)
	  N = Range(X).Next
	  Range(X).Next = Range_Free_List
	  Range_Free_List = X
	  X = N
	End Do

	End ! of Range_Deallocate


	Integer Function Range_Find (G, A, Create, U)

	Include 'News.Def'

C Description
C
C   Locates the Range entry for article number A in group G.
C   If a range entry does not exist for A and Create is true,
C   one is created.
C
C   Returns the Range entry index or zero if none.
C

C Parameter definitions

	Integer   *4		G	! Group number
	Integer	  *4		A	! Article number
	Logical			Create  ! .true. if create on no find
	Integer   *4		U	! Unread article count, updated

C External routines

	Integer			Range_Allocate

C Local definitions

	Integer   *4		P
	Integer   *4		R, RR
	Logical			Found

C Begin Range_Find

	P = 0
	R = Group(G).Range_First
	Found = .false.
	Range_Find = 0

	Do While ((R .ne. 0) .and. (.not. Found))	
	  If ((A .ge. Range(R).Start) .and. (A .le. Range(R).End)) Then
	    Found = .true.
	    Range_Find = R
	  Else If (A .lt. Range(R).Start) Then
	    Found = .true.
	  Else
	    P = R
	    R = Range(R).Next
	  End If
	End Do

	If ((Range_Find .eq. 0) .and. Create) Then
	  If
	1	(
	1	(P .ne. 0)
	1	.and.
	1	((Range(P).End+1) .eq. A)
	1	) Then
	    Range(P).End = Range(P).End + 1
	    Range_Find = P
	    Call Range_Combine (P, R)
	  Else If
	1	(
	2	(R .ne. 0)
	3	.and.
	4	((Range(R).Start-1) .eq. A)
	5	) Then
	    Range(R).Start = Range(R).Start - 1
	    Range_Find = R
	    Call Range_Combine (P, R)
	  Else
	    RR = Range_Allocate ()
	    Range_Find = RR
	    Range(RR).Start = A
	    Range(RR).End   = A
	    Range(RR).Next  = R
	    If (P .eq. 0) Then
	      Group(G).Range_First = Range_Find
	      Group(G).Range_Last  = Range_Find
	    Else
	      Range(P).Next = Range_Find
	    EndIf
	  EndIf

	  U = U - 1
	  If (U .lt. 0) Then
	    U = 0
	  EndIf

	EndIf

	End ! of Range_Find
