C READ_NEWS.FOR

	Subroutine Read_News ()

	Include 'News.Def'
	Include 'SMG.Def'
	Include 'Debug.Def'

	Logical		Cmd_ArticleCatchUp
	Integer		Cmd_ArticleFindSubj
	Logical		Cmd_ArticleFirst
	Logical		Cmd_ArticleLast
	Integer		Cmd_ArticleNumber
	Integer		Cmd_ArticleRestore
	Integer		Cmd_ArticleSameSubj
	Integer		Group_Find
	Integer		Range_Find
	Integer		SMG_Prompt
	Integer		Srv_Cmd
	Integer		TrimLg
	Integer		UnRead

	Logical		Action
	Logical		A_Continue
	Character*512	Buf		! Buffer.
	Character*512	Trash_Buf	! Spare Buf for 'hit return prompts'
	Logical		ByReadChk
	Logical 	BySubscribedChk	! ???
	Logical		Done		! Done with reading ?
	Integer		E
	Integer 	G		! Current group number.
	Logical		G_Continue	! True to continue to scan groups.
	Integer		I
	Integer		Lg
	Integer		Trash_Lg	! Spare Lg for 'hit return'
	Integer		Next_G
	Character *8	Num
	Character *128	Pattern
	Integer		R
	Logical		RefreshArticle
	Logical		RefreshGroup
	Integer		S
	Integer		Status
	Integer		Trash_Status	! Spare status for 'hit return'
	Integer		U
	Integer		Unavail_Start
	Integer		Unavail_End

C Scan through groups displaying new messages

	Pattern = ' '			! JMH 8/16/88

	G = 1
	G_Continue = .true.
	BySubscribedChk = .false.
	More_Input = ' '
	Done = .false.

1	Do While (G_Continue .and. (G .le. Group_Count))

	  Next_G = G + 1

	  Kill_Done = .false.

	  If (BySubscribedChk .or. (Group(G).Subscribed)) Then

C	    Call CacheHdr_Init (G)		! Initialize header cache
	    Call CacheHdr_Init ()		! Initialize header cache
						! 940105/jms

	    S = Group(G).Active_Start		! Starting article
	    E = Group(G).Active_End		! Ending article
	    R = Group(G).Range_First

	    If (S .eq. 0) Then
	      S = 1
	    End If

C Adjust S depending on articles we have read to avoid some overhead

	    Do While (R .ne. 0)

C Trim range S:E if S is in this range

	      If
	1	(
	2	(S .ge. Range(R).Start)
	3	.and.
	4	(S .le. Range(R).End)
	5	) 				Then
		S = Range(R).End + 1
	      EndIf

C Do next range

	      R = Range(R).Next

	    End Do

	    U = UnRead (G)

C If there is something to read, open the group

	    If (BySubscribedChk .or. (S .le. E)) Then

	      BySubscribedChk = .false.

C Attempt to select group

	      If (GroupSelect) Then
		If (Group(G).Name .ne. NewsGroup) Then
		  A_Continue = .false.
		  G = Next_G
		  Goto 1
		EndIf
	      EndIf

	      If (.not. Srv_Cmd ('group ' // Group(G).Name, Buf, Lg)) Then
		Call SMG_All_Print ('NNTP server went away on GROUP command')
		Stop 
	      End If

	      If (Buf(1:3) .eq. '211') Then

C Good status indicates group selected.  Count it.

		Groups_Read = Groups_Read + 1
	        A_Continue = .true.

C Find out what user wants with this group

		ByReadChk = .false.
		Action = .false.
		RefreshGroup = .true.

		Do While (.not. Action)

		  If (RefreshGroup) Then
		    RefreshGroup = .false.
		    Call Group_Header (G, U, -1) ! setup Mode_Hdg_{One,Two}
		    Call More_Heading
		  EndIf

		  If (More_Input .ne. ' ') Then
		    Buf = More_Input
		    Lg = TrimLg(More_Input)
		    More_Input = ' '
		  Else
		    Call SMG_All_Print (' ')
	            Status = SMG_Prompt
	1		(
	2		Buf,
	3		'GROUP ' //
	4		Group(G).Name(1:TrimLg(Group(G).Name)) //
	5		' action: ',
	6		Lg
	7		)
		  EndIf

		  Action = .true.

C+++
C There are three massive case statements in this subroutine.  The
C first is here, and is the action at the "GROUP" line.
C The second and third, later in the file, are actions at the
C "current article" and "no more articles" lines.
C---

		  If (Buf(1:1) .eq. ' ') Then  ! Process group

c
c	VNEWS 1.3-4, Kevin Oberman, Add the Move group command for reordering 
c		of news groups
c	VNEWS 1.4 paf/910327 Add the N and Y commands
c	VNEWS 1.41  jms/910829 Add Q! commands.
c	VNEWS 1.3-4	Kevin Oberman prevent the user from backing up to a 
c		nonexistant (g=0) group
c	VNEWS 1.3-4	Kevin Oberman, Standardize the print command to be 'P'
c	check to see if posting is allowed, and don't allow
c	people to post if it isn't.  900622/jms (1.4)
c	VNEWS 1.3-4	Kevin Oberman
c	Add the Move group command for reordering of news groups
C	VNEWS 1.4.  Added Z command.
C	VNEWS 1.41. Fix typo bug making $ command not work. jms/910828
c	Toggle state of Manual/Automatic question/answer flag.
c	(vnews 1.4/jms,paf/910327)
c
		  Else If (Buf(1:1) .eq. 'a') Then  ! attach to another proc
		    If (Lg .lt. 3) Then
		      Call Cmd_Attach (' ')
		    Else
		      Call Cmd_Attach (Buf(3:Lg))     
		    End If
		  Action = .false.                
		  Else If (Buf(1:1) .eq. 'b') Then  ! Backup
			If (g .gt. 1) Then
			  Next_G = G - 1
			  BySubscribedChk = .true.
			  A_Continue = .false.
			Else
			  call smg_all_print('No previous group')
			EndIf ! g > 1
		  Else If (Buf(1:1) .eq. 'c') Then  ! Catchup
		    Action = Cmd_ArticleCatchUp (G, S, Buf(1:Lg), U)
		    RefreshGroup = .true.	! Need new heading
		    Next_G = G + 1
		  Else If (Buf(1:1) .eq. 'C') Then  ! Cancel
		    Call Cmd_ArticleNone ! vnews 1.4/jms
		    Action = .false.
		  Else If (Buf(1:3) .eq. 'd/g') Then ! Dir/Group
		    Call Cmd_GroupList (Buf(1:Lg))
		    Action = .false.
		  Else If (Buf(1:1) .eq. 'd') Then  ! Dir
		    If (.not. Kill_Done) Then
		    Call Cmd_ReadKillfile (G, S, U)
		    End If
		    Call Cmd_ArticleList (G, Buf(1:Lg))
		    Action = .false.
		  Else If (Buf(1:1) .eq. 'f') Then  ! Followup
		    Action = .false.
		    If (Posting_Allowed) Then
		      Call Cmd_ArticleNone
		    Else
		      Call Cmd_NoPosting
		    Endif

		  Else If (Buf(1:1) .eq. 'F') Then  ! Followup/Mail
		    Action = .false.
		    If (Posting_Allowed) Then
		      Call Cmd_ArticleNone
		    Else
		      Call Cmd_NoPosting
		    Endif

		  Else If (Buf(1:1) .eq. 'g') Then  ! Group g
		    I = Group_Find (Buf(3:))
		    If (I .eq. 0) Then
		      Action = .false.
		      Call SMG_All_Print
	1	    (' No such group as "' //Buf (3:2+TrimLg(Buf(3:))) // '"')
		    Else
		      BySubscribedChk = .true.
		      Next_G = I
		      A_Continue = .false.
c
c	Notification that the user is being subscribed by the 'g' command.
c	John McMahon  2-MAR-1990 23:17:41.02 
c
c	References to (G).Subscribed were changed to (Next_G).  This
c	changes the 'g' command from 'subscribe to the current group
c	before going to the next' to 'subscribe to the next group'.
c	I think this was a typo, since it made for confusion on how to
c	subscribe.
c
		      If (Group(Next_G).Subscribed .eq. .false.) Then
				Trash_Status = SMG_Prompt
	1			(
	2			Trash_Buf,
	3			' Subscribed to group "' //
	4		Group(Next_G).Name(1:TrimLg(Group(Next_G).Name))  //
	5			'," hit <return> to continue. ',
	6			Trash_Lg
	7			)
		      EndIF
		      Group(Next_G).Subscribed = .true.
		    End If
		  Else If (Buf(1:1) .eq. 'h' .or. Buf(1:1) .eq. '?') Then  ! Help
		    Call Cmd_Help
		    Action = .false.
		  Else If (Buf(1:3) .eq. 'key') Then ! Keypad help
		    Call Keypad_Help
		    Action = .false.
		  Else If (Buf(1:2) .eq. 'k/' .or. Buf(1:3) .eq. 'k /') Then  ! Kill
		    Call Cmd_ArticleKill (G, S, U, Buf)
		    Call Lib$Wait(3.0)	! VNEWS 1.3-4 Oberman
		    RefreshArticle = .true.
		    Action = .false.
		  Else If (Buf(1:1) .eq. 'k') Then  ! Kill
		    Call Cmd_ArticleNone
		    Call Lib$Wait(3.0)	! VNEWS 1.3-4 Oberman
		    Action = .false.
		  Else If (Buf(1:1) .eq. 'K') Then  ! add to KILL file
		    If (Index(Buf,'/') .eq. 0) Then
		      Call Cmd_ArticleNone
		    Else
		      Call Cmd_AddKillfile (G, S, U, Buf)
		      RefreshArticle = .true.
		    EndIf
		    Action = .false.
		  Else If (Buf(1:3) .eq. 'm/g') Then  ! Mark unread
		    Call Cmd_ArticleRestore(G,U)      ! Restore articles
		    RefreshGroup = .true.	      ! Need new heading
		    Action = .false.		      ! (JMH 8/2/88)
		  Else If (Buf(1:1) .eq. 'm') Then
		     Call Cmd_ArticleNone
		     Action = .false.
		  Else If (Buf(1:1) .eq. 'M') Then
		     Call Cmd_Movegroup(G)
		     Action = .false.
		  Else If (Buf(1:1) .eq. 'n') Then  ! Next group
		    A_Continue = .false.
		  Else If (Buf(1:1) .eq. 'N') Then  ! Manual question answer
		    Call Cmd_NoAsk ( .false. )
		    Action = .false.
		  Else If (Buf(1:1) .eq. 'p') Then  ! Post
		    Action = .false.
		    If (Posting_Allowed) Then
		      Call Cmd_ArticlePost (G, Buf(1:Lg))
		    Else
		      Call Cmd_NoPosting
		    Endif
		  Else If (Buf(1:1) .eq. 'P') Then ! Print it!
		    Call Cmd_ArticleNone
		    Action = .false.
		  Else If (Buf(1:1) .eq. 'q') Then  ! Quit
		    G_Continue = .false.
		    A_Continue = .false.
		  Else If (Buf(1:2) .eq. 'Q!') Then ! Quit, no save
		    G_Continue = .false.
		    A_Continue = .false.
		    Call Quit_News(.FALSE.)
		  Else If (Buf(1:1) .eq. 'r') Then  ! Refresh
		    Call Cmd_ArticleNone
		    Action = .false.
		  Else If (Buf(1:1) .eq. 'R') Then  ! Reply by Mail
		    Call Cmd_ArticleNone
		    Action = .false.
		  Else If (Buf(1:1) .eq. 's') Then  ! Save
		    Call Cmd_ArticleNone
		    Action = .false.
		  Else If (Buf(1:1) .eq. 'S') Then  ! Send
		    Call Cmd_ArticleNone
		    Action = .false.
		  Else If (Buf(1:1) .eq. 'u') Then  ! Unsubscribe
		    Group(G).Subscribed = .false.
		    A_Continue = .false.
		  Else If (Buf(1:1) .eq. 'x') Then  ! Refresh rot mode
		    Call Cmd_ArticleNone
		    Action = .false.
		  Else If (Buf(1:1) .eq. 'Y') Then  ! Auto question answer
		    Call Cmd_NoAsk( .true. )
		    Action = .false.
		  Else If (Buf(1:1) .eq. 'z') Then  ! Next article
		    Call Cmd_ArticleNone	    !  same subject
		    Action = .false.
		  Else If (Buf(1:1) .eq. '^') Then  ! First unread article
		    Action = Cmd_ArticleFirst (G,S)
		  Else If (Buf(1:1) .eq. '$') Then  ! Last unread article
		    Action = Cmd_ArticleLast (G,S)
		  Else If (Buf(1:1) .eq. '/') Then  ! Search for pattern
		    Action = Cmd_ArticleFindSubj (Buf,G,S,Pattern) 
		  Else If (Buf(1:1) .eq. '!') Then  ! Spawn subprocess 
		    Call Cmd_Spawn (Buf)
		    Action = .false.
		  Else If
	1		(
	2		(Buf(1:1) .ge. '0')
	3		.and.
	4		(Buf(1:1) .le. '9')
	5		)		            Then
		    If (Cmd_ArticleNumber (G, Buf(1:Lg), S)) Then
		      ByReadChk = .true.
		    Else
		      Action = .false.
		    EndIf
		  Else If (Buf(1:1) .eq. 'j') Then
		    Action = .false.
		    Debug = .not. Debug
		    If (Debug) Then
		      Call SMG_All_Print ('Debug is on')
		    Else
		      Call SMG_All_Print ('Debug is off')
		    EndIf
		  Else
		    Call SMG_All_Print ('Huh?')
		    Action = .false.
		  End If

C Read the KILL file and delete articles

                  If ((Buf(1:1) .eq. ' ') .and. (.not. Kill_Done)) Then
		     Call Cmd_ReadKillfile (G, S, U)
		  End If
		End Do

C Now page through the articles in range S - E

		Unavail_Start = 0		! No unavailable articles
		Unavail_End = 0			!  so far

		Do While ((E .gt. 0 ) .and. (S .le. E) .and. A_Continue)

		  If
	1		(
	2		ByReadChk
	3		.or.
	4		(Range_Find(G, S, .false.) .eq. 0)
	5		)					Then

		    ByReadChk = .false.
	            Write (Buf, '(A, I7)') 'stat ', S

		    If (.not. Srv_Cmd (Buf(1:15), Buf, Lg)) Then
			Call SMG_All_Print (
	1		'NNTP server went away on STAT command.')
		      Stop
		    End If

		    If (Buf(1:3) .ne. '223') Then
		      If (Unavail_Start .eq. 0) Then
		        Unavail_Start = S
	              End If
		      Unavail_End = S
		      Status = Range_Find (G, S, .true., U)
		    EndIf

		    If
	1		(
	2		((Unavail_Start .ne. 0) .and. (S .eq. E))
	3		.or.
	4		(Buf(1:3) .eq. '223')
	5		)			Then

		      More_Input = ' '

		      If (Unavail_Start .ne. 0) Then
		        S = Unavail_End
		        Call Unavail_Print (Unavail_Start, Unavail_End)
		      Else
		        Status = Range_Find (G, S, .true., U)
			call Group_Header(G, U, S) ! setup more_hdg_{1|2}
			Rotated = .false.
			Call Cmd_ArticleDisplay ( S, Rotated)
                        Call Mark_Xref_As_Read (S, G)
		      EndIf

C What does user want to do with this article?
	
		      Action = .false.
		      RefreshArticle = .false.

		      Do While (.not. Action)
			Call Group_Header (G, U, S) ! setup more_hdg_{1|2}

		        If (RefreshArticle) Then
			  RefreshArticle = .false.
			  Call More_Heading
		        EndIf


			If (More_Input .ne. ' ') Then

			  Buf = More_Input
			  Lg = TrimLg (More_Input)
			  More_Input = ' '

			Else

			  Call SMG_All_Print (' ')
			  Call ItoS (S, Num, Trash_Lg)	! 1.51/jms/940106
	        	  Status = SMG_Prompt
	1			(
	2			Buf,
	3			'End article ' // Num(1:Trash_Lg) //
	4			' action: ',
	5			Lg
	6			)

			EndIf
C+++
C Here is the SECOND major case statement, output after the "End article"
C command.
C---

			Action = .true.
			If      (Buf(1:1) .eq. ' ') Then  ! Next article
			  S = S + 1
		        Else If (Buf(1:1) .eq. 'a') Then  ! attach to another proc
	                  If (Lg .lt. 3) Then
		            Call Cmd_Attach (' ')
		          Else
		            Call Cmd_Attach (Buf(3:Lg))     
		          End If
			  Action = .false.                
			Else If (Buf(1:1) .eq. 'b') Then  ! Backup
			  S = S - 1
			  ByReadChk = .true.
			Else If (Buf(1:1) .eq. 'c') Then  ! Catchup
			  Action = Cmd_ArticleCatchUp(G, S, Buf(1:Lg),U)
			  RefreshArticle = .true.
			Else If (Buf(1:1) .eq. 'C') Then  ! Cancel
			  Call Cmd_ArticleCancel(G, S, Buf(1:Lg))
			  RefreshArticle = .true.
			  Action = .false.
			Else If (Buf(1:3) .eq. 'd/g') Then ! Dir/Group
			  Call Cmd_GroupList (Buf(1:Lg))
			  Action = .false.
			Else If (Buf(1:1) .eq. 'd') Then  ! Dir
                          If (.not. Kill_Done) Then
                             Call Cmd_ReadKillfile (G, S, U)
			  End If
			  Call Cmd_ArticleList (G, Buf(1:Lg))
			  Action = .false.
			Else If (Buf(1:1) .eq. 'f') Then  ! Followup
			  Action = .false.
			  If (Posting_Allowed) Then
			    Call Cmd_ArticleFollowUp (G, S, Buf(1:Lg))
			  Else
			    Call Cmd_NoPosting
			  Endif

			Else If (Buf(1:1) .eq. 'F') Then  ! Followup
			  Action = .false.
			  If (Posting_Allowed) Then
			    If (Buf(2:3) .eq. '/c' .or.
	1			Buf(2:3) .eq. '/C'     ) Then
			      Call Cmd_ArticleFollowMail 
	1			(G, S, Buf(1:Lg), .TRUE.)
			    Else
			      Call Cmd_ArticleFollowMail
	1			(G, S, Buf(1:Lg), .FALSE.)
			    EndIf
			  Else
			    Call Cmd_NoPosting
			  Endif

			Else If (Buf(1:1) .eq. 'g') Then  ! Group g
			  I = Group_Find (Buf(3:))
			  If (I .eq. 0) Then
			    Action = .false.
			    Call SMG_All_Print
	1	      ('No such group as "' //Buf(2:2+TrimLg(Buf(3:))) // '"')
			  Else
			    BySubscribedChk = .true.
			    Next_G = I
			    A_Continue = .false.

		      If (Group(Next_G).Subscribed .eq. .false.) Then
				Trash_Status = SMG_Prompt
	1			(
	2			Trash_Buf,
	3			' Subscribed to group ' //
	4		Group(Next_G).Name(1:TrimLg(Group(Next_G).Name))  //
	5			', hit <return> to continue. ',
	6			Trash_Lg
	7			)
		      EndIF
		      Group(Next_G).Subscribed = .true.
			  End If
			Else If (Buf(1:1) .eq. 'h' .or.
     	1			 Buf(1:1) .eq. '?') Then  ! Help
			  Call Cmd_Help
			  Action = .false.
			Else If (Buf(1:3) .eq. 'key') Then ! Keypad help
			  Call Keypad_Help
			  Action = .false.
			Else If (Buf(1:1) .eq. 'k') Then  ! Kill
			  Call Cmd_ArticleKill (G, S, U, Buf)
			  RefreshArticle = .true.
			  Action = .false.
			Else If (Buf(1:1) .eq. 'K') Then  ! add to KILL file
			  Call Cmd_AddKillfile (G, S, U, Buf)
			  RefreshArticle = .true.
			  Action = .false.
			Else If (Buf(1:3) .eq. 'm/g') Then ! Mark group unread
			  Call Cmd_ArticleRestore(G,U)     ! Restore articles
			  Call Group_Header (G, U, -1)     ! setup Mode_Hdg_{One,Two}
			  RefreshArticle = .true.	   ! Need new heading
			  Action = .false.		   ! JMH 8/2/88
			Else If (Buf(1:1) .eq. 'm') Then  ! Mark unread
			  Call Cmd_ArticleMark (G, S, U)
			  RefreshArticle = .true.
			  Action = .false.
			Else If (Buf(1:1) .eq. 'M') Then
			  Call Cmd_Movegroup(G)
			  Action = .false.
			Else If (Buf(1:1) .eq. 'n') Then  ! Next article
			  S = S + 1
			Else If (Buf(1:1) .eq. 'N') Then  ! Manual question answer
			  Call Cmd_NoAsk(.false.)
			  Action = .false.
			Else If (Buf(1:1) .eq. 'P') Then ! Print it.
			  Call Cmd_ArticlePrint (S)
			  Action = .false.
			Else If (Buf(1:1) .eq. 'p') Then  ! Post
			  Action = .false.
			  If (Posting_Allowed) Then
			    Call Cmd_ArticlePost (G, Buf(1:Lg))
			  Else
			    Call Cmd_NoPosting
			  Endif
			Else If (Buf(1:1) .eq. 'q') Then  ! Quit
			  A_Continue = .false.
			Else If (Buf(1:2) .eq. 'Q!') Then ! Quit, no save
			  A_Continue = .false.
			  Call Quit_News(.FALSE.)
			Else If (Buf(1:1) .eq. 'r') Then  ! Refresh
			  ByReadChk = .true.
c
c	if R/c or R/C, then send cc of reply to self.
c
			Else If (Buf(1:1) .eq. 'R') Then  ! Mail
			  If (Buf(2:3) .eq. '/c' .or.
	1		      Buf(2:3) .eq. '/C'     ) Then
			    Call Cmd_ArticleMail (G, S, Buf(1:Lg),.TRUE.)
			  Else
			    Call Cmd_ArticleMail (G, S, Buf(1:Lg),.FALSE.)
			  EndIf
			  Action = .false.
			Else If (Buf(1:1) .eq. 's') Then  ! Save
			  Call Cmd_ArticleSave (G,S,Buf)
			  Action = .false.
			Else If (Buf(1:1) .eq. 'S') Then  ! Send
			  If (Buf(2:3) .eq. '/c' .or.
	1		      Buf(2:3) .eq. '/C'     ) Then
			    Call Cmd_ArticleSend (S, Buf(1:Lg),.TRUE.)
			  Else
			    Call Cmd_ArticleSend (S, Buf(1:Lg),.FALSE.)
			  EndIf
			  Action = .false.
			Else If (Buf(1:1) .eq. 'u') Then  ! Unsubscribe
			  Group(G).Subscribed = .false.
			  A_Continue = .false.
			Else If (Buf(1:1) .eq. 'x') Then  ! Refresh rot mode
			  Rotated = .true.
			  Call Cmd_ArticleDisplay ( S, Rotated)
			  Action = .false.
			Else If (Buf(1:1) .eq. 'Y') Then  ! Auto question answer
			  Call Cmd_NoAsk ( .true. )
			  Action = .false.
			Else If (Buf(1:1) .eq. 'z') Then  ! Next article
							  !  same subject
			  Action = Cmd_ArticleSameSubj (G, S)
			Else If (Buf(1:1) .eq. 'Z') Then  ! 'Z' or '^'
			  Action = Cmd_ArticleSameSubj(G, S)
			  if (.not. Action) then
			    call LIB$WAIT(1.5)
			    Action = Cmd_ArticleFirst(G, S)
			  end if
			Else If (Buf(1:1) .eq. '^') Then  ! First unread article
			  Action = Cmd_ArticleFirst (G, S)
			Else If (Buf(1:1) .eq. '$') Then  ! Last unread article
			  Action = Cmd_ArticleLast (G,S)
			Else If (Buf(1:1) .eq. '/') Then  ! Search for pattern
			  Action = Cmd_ArticleFindSubj (Buf,G,S,Pattern) ! JMH 8/12/88
			Else If (Buf(1:1) .eq. '!') Then  ! Spawn subprocess (JMH 8/17/88)
			  Call Cmd_Spawn (Buf)
			  Action = .false.
			Else If 			  ! Article number
	1			(
	2			(Buf(1:1) .ge. '0')
	3			.and.
	4			(Buf(1:1) .le. '9')
	5			)			Then
			  If (Cmd_ArticleNumber (G, Buf(1:Lg), S)) Then
			    ByReadChk = .true.
			  Else
			    Action = .false.
			  EndIf
			Else If (Buf(1:1) .eq. 'j') Then
			  Action = .false.
			  Debug = .not. Debug
			  If (Debug) Then
			    Call SMG_All_Print ('Debug is on')
			  Else
			    Call SMG_All_Print ('Debug is off')
			  EndIf
			Else
			  Call SMG_All_Print ('Huh?')
			  Action = .false.
			End If

		      End Do ! (.not. Action)

		    Else

		      S = S + 1

		    End If

		  Else

		    S = S + 1

		  End If

		End Do ! (S .le. E)

		If (Unavail_Start .ne. 0) Then
		  Call Unavail_Print (Unavail_Start, Unavail_End)
		EndIf

	      Else If (Buf(1:3) .eq. '411') Then
		Call SMG_All_Print
	1	('No such group as "' // Group(G).Name // '"')
		Call SMG_All_Print (Buf(1:Lg))
	      Else
		Call SMG_All_Print (Buf(1:Lg))
		Call SMG_All_Print ('Unexpected GROUP command response.')
		Stop 
	      End If
	    End If
	  End If

	  G = Next_G

	End Do ! (G_Continue .and. (G .le. Group_Count))

C Done with news groups, find out what user want's to do now

	More_Input = ' '
	Action = .false.
	Kill_Done = .false.

	Do While (.not. Action)

	  If (More_Input .ne. ' ') Then
	    Buf = More_Input
	    Lg = TrimLg (More_Input)
	    More_Input = ' '
	  Else
	    Call SMG_All_Print (' ')
	    Status = SMG_Prompt
	1	(
	2	Buf,
	3	'DONE, action: ',
	4	Lg
	5	)
	  EndIf
C+++
C And this is the final, THIRD, major case statement, at the
C "DONE, action:" prompt.
C---

	  Action = .true.
	  If      (Buf(1:1) .eq. ' ') Then  ! Process group
	    Done = .true.
	  Else If (Buf(1:1) .eq. 'a') Then  ! attach to another proc
	    If (Lg .lt. 3) Then
	      Call Cmd_Attach (' ')
	    Else
	      Call Cmd_Attach (Buf(3:Lg))     
	    End If
	    Action = .false.                
	  Else If (Buf(1:1) .eq. 'b') Then  ! Backup
	    G = G - 1
	  Else If (Buf(1:1) .eq. 'c') Then  ! Catchup
	    Call Cmd_GroupNone
	    Action = .false.
	  Else If (Buf(1:1) .eq. 'C') Then  ! Cancel
	    Call Cmd_ArticleNone
	    Action = .false.
	  Else If (Buf(1:3) .eq. 'd/g') Then ! Dir/Group
	    Call Cmd_GroupList (Buf(1:Lg))
	    Action = .false.
	  Else If (Buf(1:1) .eq. 'd') Then  ! Dir
	    Call Cmd_GroupNone
	    Action = .false.
	  Else If (Buf(1:1) .eq. 'f') Then  ! Followup
	    Action = .false.
	    If (Posting_Allowed) Then
	      Call Cmd_ArticleNone
	    Else
	      Call Cmd_NoPosting
	    Endif

	  Else If (Buf(1:1) .eq. 'F') Then  ! Followup/Mail
	    Action = .false.
	    If (Posting_Allowed) Then
	      Call Cmd_ArticleNone
	    Else
	      Call Cmd_NoPosting
	    Endif

	  Else If (Buf(1:1) .eq. 'g') Then  ! Group g
	    I = Group_Find (Buf(3:))
	    If (I .eq. 0) Then
	      Action = .false.
	      Call SMG_All_Print
	1	('No such group as "' // Buf (3:2+TrimLg(Buf(3:))) // '"')
	    Else
	      BySubscribedChk = .true.
	      G = I
	      A_Continue = .false.
c
c	Notification that the user is being subscribed by the 'g' command.
c	John McMahon  2-MAR-1990 23:17:41.02 
c
		      If (Group(G).Subscribed .eq. .false.) Then
				Trash_Status = SMG_Prompt
	1			(
	2			Trash_Buf,
	3			' Subscribed to group ' //
	4			Group(G).Name(1:TrimLg(Group(G).Name))  //
	5			', hit <return> to continue. ',
	6			Trash_Lg
	7			)
		      EndIF
		      Group(G).Subscribed = .true.
	    End If
	  Else If (Buf(1:1) .eq. 'h' .or. Buf(1:1) .eq. '?') Then  ! Help
	    Call Cmd_Help
	    Action = .false.
	  Else If (Buf(1:3) .eq. 'key') Then ! Keypad help
	    Call Keypad_Help
	    Action = .false.
	  Else If (Buf(1:1) .eq. 'k') Then  ! Kill
	    Call Cmd_ArticleNone
	    Action = .false.
	  Else If (Buf(1:1) .eq. 'K') Then  ! add to KILL file
	    Call Cmd_ArticleNone
	    Action = .false.
	  Else If (Buf(1:3) .eq. 'm/g') Then ! Mark newsgroup unread (JMH)
	    Call Cmd_GroupNone
	    Action = .false.
	  Else If (Buf(1:1) .eq. 'm') Then  ! Mark unread
	    Call Cmd_ArticleNone
	    Action = .false.
	  Else If (Buf(1:1) .eq. 'N') Then  ! Manual question answer
	    Call Cmd_NoAsk ( .false. )
	    Action = .false.
	  Else If (Buf(1:1) .eq. 'n') Then  ! Next group
	    Done = .true.
	  Else If (Buf(1:1) .eq. 'p') Then  ! Post
	    Action = .false.
	    If (Posting_Allowed) Then
	      Call Cmd_ArticlePost (G, Buf(1:Lg))
	    Else
	      Call Cmd_NoPosting
	    Endif
	  Else If (Buf(1:1) .eq. 'q') Then  ! Quit
	    Done = .true.
	  Else If (Buf(1:2) .eq. 'Q!') Then ! Quit, no save
	    Done = .true.
	    Call Quit_News(.FALSE.)
	  Else If (Buf(1:1) .eq. 'r') Then  ! Refresh
	    Call Cmd_ArticleNone
	    Action = .false.
	  Else If (Buf(1:1) .eq. 'R') Then  ! Mail
	    Call Cmd_ArticleNone
	    Action = .false.
	  Else If (Buf(1:1) .eq. 's') Then  ! Save
	    Call Cmd_ArticleNone
	    Action = .false.
	  Else If (Buf(1:1) .eq. 'S') Then  ! Send
	    Call Cmd_ArticleNone
	    Action = .false.
	  Else If (Buf(1:1) .eq. 'u') Then  ! Unsubscribe
	    Call Cmd_GroupNone
	    Action = .false.
	  Else If (Buf(1:1) .eq. 'x') Then  ! Refresh rot mode
	    Call Cmd_ArticleNone
	    Action = .false.
	  Else If (Buf(1:1) .eq. 'Y') Then  ! Auto question answer
	    Call Cmd_NoAsk ( .true. )
	    Action = .false.
	  Else If (Buf(1:1) .eq. 'z') Then  ! Next article
	    Call Cmd_ArticleNone	    !  same subject
	    Action = .false.
	  Else If (Buf(1:1) .eq. '^') Then  ! First unread article
	    Call Cmd_ArticleNone	    !  same subject
	    Action = .false.
	  Else If (Buf(1:1) .eq. '$') Then  ! Last unread article
	    Call Cmd_ArticleNone	    !  same subject
	    Action = .false.
	  Else If (Buf(1:1) .eq. '/') Then  ! Search for pattern
	    Action = Cmd_ArticleFindSubj (Buf,G,S,Pattern) ! JMH 8/12/88
	  Else If (Buf(1:1) .eq. '!') Then  ! Spawn subprocess (JMH 8/17/88)
	    Call Cmd_Spawn (Buf)
	    Action = .false.
	  Else If
	1	(
	2	(Buf(1:1) .ge. '0')
	3	.and.
	4	(Buf(1:1) .le. '9')
	5	) 			Then
	    Call Cmd_ArticleNone
	    Action = .false.
	  Else
	    Call SMG_All_Print ('Huh?')
	    Action = .false.
	  End If
	End Do

	If (.not. Done) Then
	  G_Continue = .true.
	  GroupSelect = .false.
	  Goto 1
	EndIf

	Return
	End ! of Read_News

	subroutine  Group_Header ( Grp, Unrd, Art )
c
c	Format the two header lines of a newsgroup, optionally
c	filling in an article number on the second line.
c
c	installed into vnews 1.4.  pr/910325.
c	change time to date in $fao later on. mcmahon/910430
c
	include 'News.Def/nolist'
	include 'SMG.Def/nolist'

	Integer		TrimLg
	Intrinsic	MAX

	Integer		Grp,  Unrd,  Art
	Integer		Lg

	More_Hdg_One = ' '
	More_Hdg_Two = ' '

c     format group name in 32 columns, unless it's even wider
	Lg = MAX( TrimLg(Group(Grp).Name), 32)	![NwsGrpSz-'n']

	CALL SYS$FAO(
	1	'Group !AS available: !UL - !UL unread: !UL',,
	2	More_Hdg_One, Group(Grp).Name(:Lg),
	3	%VAL(Group(Grp).Active_Start),
	4	%VAL(Group(Grp).Active_End),
	5	%VAL(Unrd))

	if ( Art .ge. 0 ) then
	    CALL SYS$FAO ('article !UL!10* !%D',,
	1	More_Hdg_Two, %VAL(Art), %VAL (0))
	else
	    More_Hdg_Two = '@'
	endif

	return

	end !of Group_Header
